package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTaskConfig invokes the cms.QueryTaskConfig API synchronously
// api document: https://help.aliyun.com/api/cms/querytaskconfig.html
func (client *Client) QueryTaskConfig(request *QueryTaskConfigRequest) (response *QueryTaskConfigResponse, err error) {
	response = CreateQueryTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskConfigWithChan invokes the cms.QueryTaskConfig API asynchronously
// api document: https://help.aliyun.com/api/cms/querytaskconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskConfigWithChan(request *QueryTaskConfigRequest) (<-chan *QueryTaskConfigResponse, <-chan error) {
	responseChan := make(chan *QueryTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskConfigWithCallback invokes the cms.QueryTaskConfig API asynchronously
// api document: https://help.aliyun.com/api/cms/querytaskconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskConfigWithCallback(request *QueryTaskConfigRequest, callback func(response *QueryTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskConfigRequest is the request struct for api QueryTaskConfig
type QueryTaskConfigRequest struct {
	*requests.RpcRequest
}

// QueryTaskConfigResponse is the response struct for api QueryTaskConfig
type QueryTaskConfigResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateQueryTaskConfigRequest creates a request to invoke QueryTaskConfig API
func CreateQueryTaskConfigRequest() (request *QueryTaskConfigRequest) {
	request = &QueryTaskConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryTaskConfig", "cms", "openAPI")
	return
}

// CreateQueryTaskConfigResponse creates a response to parse from QueryTaskConfig response
func CreateQueryTaskConfigResponse() (response *QueryTaskConfigResponse) {
	response = &QueryTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
