package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryErrorDistribution invokes the cms.QueryErrorDistribution API synchronously
// api document: https://help.aliyun.com/api/cms/queryerrordistribution.html
func (client *Client) QueryErrorDistribution(request *QueryErrorDistributionRequest) (response *QueryErrorDistributionResponse, err error) {
	response = CreateQueryErrorDistributionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryErrorDistributionWithChan invokes the cms.QueryErrorDistribution API asynchronously
// api document: https://help.aliyun.com/api/cms/queryerrordistribution.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryErrorDistributionWithChan(request *QueryErrorDistributionRequest) (<-chan *QueryErrorDistributionResponse, <-chan error) {
	responseChan := make(chan *QueryErrorDistributionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryErrorDistribution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryErrorDistributionWithCallback invokes the cms.QueryErrorDistribution API asynchronously
// api document: https://help.aliyun.com/api/cms/queryerrordistribution.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryErrorDistributionWithCallback(request *QueryErrorDistributionRequest, callback func(response *QueryErrorDistributionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryErrorDistributionResponse
		var err error
		defer close(result)
		response, err = client.QueryErrorDistribution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryErrorDistributionRequest is the request struct for api QueryErrorDistribution
type QueryErrorDistributionRequest struct {
	*requests.RpcRequest
	TimeRange string `position:"Query" name:"TimeRange"`
	TaskId    string `position:"Query" name:"TaskId"`
}

// QueryErrorDistributionResponse is the response struct for api QueryErrorDistribution
type QueryErrorDistributionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateQueryErrorDistributionRequest creates a request to invoke QueryErrorDistribution API
func CreateQueryErrorDistributionRequest() (request *QueryErrorDistributionRequest) {
	request = &QueryErrorDistributionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryErrorDistribution", "cms", "openAPI")
	return
}

// CreateQueryErrorDistributionResponse creates a response to parse from QueryErrorDistribution response
func CreateQueryErrorDistributionResponse() (response *QueryErrorDistributionResponse) {
	response = &QueryErrorDistributionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
