package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DelSubAccountPermission invokes the cloudwf.DelSubAccountPermission API synchronously
// api document: https://help.aliyun.com/api/cloudwf/delsubaccountpermission.html
func (client *Client) DelSubAccountPermission(request *DelSubAccountPermissionRequest) (response *DelSubAccountPermissionResponse, err error) {
	response = CreateDelSubAccountPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// DelSubAccountPermissionWithChan invokes the cloudwf.DelSubAccountPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/delsubaccountpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DelSubAccountPermissionWithChan(request *DelSubAccountPermissionRequest) (<-chan *DelSubAccountPermissionResponse, <-chan error) {
	responseChan := make(chan *DelSubAccountPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DelSubAccountPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DelSubAccountPermissionWithCallback invokes the cloudwf.DelSubAccountPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/delsubaccountpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DelSubAccountPermissionWithCallback(request *DelSubAccountPermissionRequest, callback func(response *DelSubAccountPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DelSubAccountPermissionResponse
		var err error
		defer close(result)
		response, err = client.DelSubAccountPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DelSubAccountPermissionRequest is the request struct for api DelSubAccountPermission
type DelSubAccountPermissionRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// DelSubAccountPermissionResponse is the response struct for api DelSubAccountPermission
type DelSubAccountPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDelSubAccountPermissionRequest creates a request to invoke DelSubAccountPermission API
func CreateDelSubAccountPermissionRequest() (request *DelSubAccountPermissionRequest) {
	request = &DelSubAccountPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DelSubAccountPermission", "cloudwf", "openAPI")
	return
}

// CreateDelSubAccountPermissionResponse creates a response to parse from DelSubAccountPermission response
func CreateDelSubAccountPermissionResponse() (response *DelSubAccountPermissionResponse) {
	response = &DelSubAccountPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
