package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeConsumeAmount invokes the bssopenapi.ChangeConsumeAmount API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/changeconsumeamount.html
func (client *Client) ChangeConsumeAmount(request *ChangeConsumeAmountRequest) (response *ChangeConsumeAmountResponse, err error) {
	response = CreateChangeConsumeAmountResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeConsumeAmountWithChan invokes the bssopenapi.ChangeConsumeAmount API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/changeconsumeamount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeConsumeAmountWithChan(request *ChangeConsumeAmountRequest) (<-chan *ChangeConsumeAmountResponse, <-chan error) {
	responseChan := make(chan *ChangeConsumeAmountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeConsumeAmount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeConsumeAmountWithCallback invokes the bssopenapi.ChangeConsumeAmount API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/changeconsumeamount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeConsumeAmountWithCallback(request *ChangeConsumeAmountRequest, callback func(response *ChangeConsumeAmountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeConsumeAmountResponse
		var err error
		defer close(result)
		response, err = client.ChangeConsumeAmount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeConsumeAmountRequest is the request struct for api ChangeConsumeAmount
type ChangeConsumeAmountRequest struct {
	*requests.RpcRequest
	Uid          requests.Integer `position:"Query" name:"Uid"`
	AdjustType   string           `position:"Query" name:"AdjustType"`
	Amount       string           `position:"Query" name:"Amount"`
	OutBizId     string           `position:"Query" name:"OutBizId"`
	ExtendMap    string           `position:"Query" name:"ExtendMap"`
	Currency     string           `position:"Query" name:"Currency"`
	Source       string           `position:"Query" name:"Source"`
	Bid          string           `position:"Query" name:"Bid"`
	BusinessType string           `position:"Query" name:"BusinessType"`
}

// ChangeConsumeAmountResponse is the response struct for api ChangeConsumeAmount
type ChangeConsumeAmountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateChangeConsumeAmountRequest creates a request to invoke ChangeConsumeAmount API
func CreateChangeConsumeAmountRequest() (request *ChangeConsumeAmountRequest) {
	request = &ChangeConsumeAmountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "ChangeConsumeAmount", "", "")
	return
}

// CreateChangeConsumeAmountResponse creates a response to parse from ChangeConsumeAmount response
func CreateChangeConsumeAmountResponse() (response *ChangeConsumeAmountResponse) {
	response = &ChangeConsumeAmountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
