package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstallChaincode invokes the baas.InstallChaincode API synchronously
// api document: https://help.aliyun.com/api/baas/installchaincode.html
func (client *Client) InstallChaincode(request *InstallChaincodeRequest) (response *InstallChaincodeResponse, err error) {
	response = CreateInstallChaincodeResponse()
	err = client.DoAction(request, response)
	return
}

// InstallChaincodeWithChan invokes the baas.InstallChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/installchaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InstallChaincodeWithChan(request *InstallChaincodeRequest) (<-chan *InstallChaincodeResponse, <-chan error) {
	responseChan := make(chan *InstallChaincodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstallChaincode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstallChaincodeWithCallback invokes the baas.InstallChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/installchaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InstallChaincodeWithCallback(request *InstallChaincodeRequest, callback func(response *InstallChaincodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstallChaincodeResponse
		var err error
		defer close(result)
		response, err = client.InstallChaincode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstallChaincodeRequest is the request struct for api InstallChaincode
type InstallChaincodeRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
	ChaincodeId    string `position:"Body" name:"ChaincodeId"`
	Location       string `position:"Body" name:"Location"`
}

// InstallChaincodeResponse is the response struct for api InstallChaincode
type InstallChaincodeResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorCode int                      `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInInstallChaincode `json:"Result" xml:"Result"`
}

// CreateInstallChaincodeRequest creates a request to invoke InstallChaincode API
func CreateInstallChaincodeRequest() (request *InstallChaincodeRequest) {
	request = &InstallChaincodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "InstallChaincode", "", "")
	return
}

// CreateInstallChaincodeResponse creates a response to parse from InstallChaincode response
func CreateInstallChaincodeResponse() (response *InstallChaincodeResponse) {
	response = &InstallChaincodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
