package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumSpecs invokes the baas.DescribeConsortiumSpecs API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumspecs.html
func (client *Client) DescribeConsortiumSpecs(request *DescribeConsortiumSpecsRequest) (response *DescribeConsortiumSpecsResponse, err error) {
	response = CreateDescribeConsortiumSpecsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumSpecsWithChan invokes the baas.DescribeConsortiumSpecs API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumspecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumSpecsWithChan(request *DescribeConsortiumSpecsRequest) (<-chan *DescribeConsortiumSpecsResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumSpecsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumSpecs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumSpecsWithCallback invokes the baas.DescribeConsortiumSpecs API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumspecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumSpecsWithCallback(request *DescribeConsortiumSpecsRequest, callback func(response *DescribeConsortiumSpecsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumSpecsResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumSpecs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumSpecsRequest is the request struct for api DescribeConsortiumSpecs
type DescribeConsortiumSpecsRequest struct {
	*requests.RpcRequest
}

// DescribeConsortiumSpecsResponse is the response struct for api DescribeConsortiumSpecs
type DescribeConsortiumSpecsResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Success   bool          `json:"Success" xml:"Success"`
	ErrorCode int           `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ClusterSpec `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumSpecsRequest creates a request to invoke DescribeConsortiumSpecs API
func CreateDescribeConsortiumSpecsRequest() (request *DescribeConsortiumSpecsRequest) {
	request = &DescribeConsortiumSpecsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumSpecs", "", "")
	return
}

// CreateDescribeConsortiumSpecsResponse creates a response to parse from DescribeConsortiumSpecs response
func CreateDescribeConsortiumSpecsResponse() (response *DescribeConsortiumSpecsResponse) {
	response = &DescribeConsortiumSpecsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
