package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumChannels invokes the baas.DescribeConsortiumChannels API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumchannels.html
func (client *Client) DescribeConsortiumChannels(request *DescribeConsortiumChannelsRequest) (response *DescribeConsortiumChannelsResponse, err error) {
	response = CreateDescribeConsortiumChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumChannelsWithChan invokes the baas.DescribeConsortiumChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumChannelsWithChan(request *DescribeConsortiumChannelsRequest) (<-chan *DescribeConsortiumChannelsResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumChannelsWithCallback invokes the baas.DescribeConsortiumChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumChannelsWithCallback(request *DescribeConsortiumChannelsRequest, callback func(response *DescribeConsortiumChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumChannelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumChannelsRequest is the request struct for api DescribeConsortiumChannels
type DescribeConsortiumChannelsRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeConsortiumChannelsResponse is the response struct for api DescribeConsortiumChannels
type DescribeConsortiumChannelsResponse struct {
	*responses.BaseResponse
	RequestId string                                   `json:"RequestId" xml:"RequestId"`
	Success   bool                                     `json:"Success" xml:"Success"`
	ErrorCode int                                      `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItemInDescribeConsortiumChannels `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumChannelsRequest creates a request to invoke DescribeConsortiumChannels API
func CreateDescribeConsortiumChannelsRequest() (request *DescribeConsortiumChannelsRequest) {
	request = &DescribeConsortiumChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumChannels", "", "")
	return
}

// CreateDescribeConsortiumChannelsResponse creates a response to parse from DescribeConsortiumChannels response
func CreateDescribeConsortiumChannelsResponse() (response *DescribeConsortiumChannelsResponse) {
	response = &DescribeConsortiumChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
