package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSchema invokes the airec.DescribeSchema API synchronously
// api document: https://help.aliyun.com/api/airec/describeschema.html
func (client *Client) DescribeSchema(request *DescribeSchemaRequest) (response *DescribeSchemaResponse, err error) {
	response = CreateDescribeSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSchemaWithChan invokes the airec.DescribeSchema API asynchronously
// api document: https://help.aliyun.com/api/airec/describeschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSchemaWithChan(request *DescribeSchemaRequest) (<-chan *DescribeSchemaResponse, <-chan error) {
	responseChan := make(chan *DescribeSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSchemaWithCallback invokes the airec.DescribeSchema API asynchronously
// api document: https://help.aliyun.com/api/airec/describeschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSchemaWithCallback(request *DescribeSchemaRequest, callback func(response *DescribeSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSchemaResponse
		var err error
		defer close(result)
		response, err = client.DescribeSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSchemaRequest is the request struct for api DescribeSchema
type DescribeSchemaRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeSchemaResponse is the response struct for api DescribeSchema
type DescribeSchemaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeSchemaRequest creates a request to invoke DescribeSchema API
func CreateDescribeSchemaRequest() (request *DescribeSchemaRequest) {
	request = &DescribeSchemaRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DescribeSchema", "/openapi/instances/[InstanceId]/schema", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeSchemaResponse creates a response to parse from DescribeSchema response
func CreateDescribeSchemaResponse() (response *DescribeSchemaResponse) {
	response = &DescribeSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
