package ubsms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBusinessStatus invokes the ubsms.DescribeBusinessStatus API synchronously
// api document: https://help.aliyun.com/api/ubsms/describebusinessstatus.html
func (client *Client) DescribeBusinessStatus(request *DescribeBusinessStatusRequest) (response *DescribeBusinessStatusResponse, err error) {
	response = CreateDescribeBusinessStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBusinessStatusWithChan invokes the ubsms.DescribeBusinessStatus API asynchronously
// api document: https://help.aliyun.com/api/ubsms/describebusinessstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBusinessStatusWithChan(request *DescribeBusinessStatusRequest) (<-chan *DescribeBusinessStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeBusinessStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBusinessStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBusinessStatusWithCallback invokes the ubsms.DescribeBusinessStatus API asynchronously
// api document: https://help.aliyun.com/api/ubsms/describebusinessstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBusinessStatusWithCallback(request *DescribeBusinessStatusRequest, callback func(response *DescribeBusinessStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBusinessStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeBusinessStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBusinessStatusRequest is the request struct for api DescribeBusinessStatus
type DescribeBusinessStatusRequest struct {
	*requests.RpcRequest
	Password  string `position:"Query" name:"Password"`
	CallerBid string `position:"Query" name:"callerBid"`
}

// DescribeBusinessStatusResponse is the response struct for api DescribeBusinessStatus
type DescribeBusinessStatusResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	Success                bool                   `json:"Success" xml:"Success"`
	UserBusinessStatusList UserBusinessStatusList `json:"UserBusinessStatusList" xml:"UserBusinessStatusList"`
}

// CreateDescribeBusinessStatusRequest creates a request to invoke DescribeBusinessStatus API
func CreateDescribeBusinessStatusRequest() (request *DescribeBusinessStatusRequest) {
	request = &DescribeBusinessStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ubsms", "2015-06-23", "DescribeBusinessStatus", "ubsms", "openAPI")
	return
}

// CreateDescribeBusinessStatusResponse creates a response to parse from DescribeBusinessStatus response
func CreateDescribeBusinessStatusResponse() (response *DescribeBusinessStatusResponse) {
	response = &DescribeBusinessStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
