package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMasterSlaveVServerGroup invokes the slb.CreateMasterSlaveVServerGroup API synchronously
// api document: https://help.aliyun.com/api/slb/createmasterslavevservergroup.html
func (client *Client) CreateMasterSlaveVServerGroup(request *CreateMasterSlaveVServerGroupRequest) (response *CreateMasterSlaveVServerGroupResponse, err error) {
	response = CreateCreateMasterSlaveVServerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMasterSlaveVServerGroupWithChan invokes the slb.CreateMasterSlaveVServerGroup API asynchronously
// api document: https://help.aliyun.com/api/slb/createmasterslavevservergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMasterSlaveVServerGroupWithChan(request *CreateMasterSlaveVServerGroupRequest) (<-chan *CreateMasterSlaveVServerGroupResponse, <-chan error) {
	responseChan := make(chan *CreateMasterSlaveVServerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMasterSlaveVServerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMasterSlaveVServerGroupWithCallback invokes the slb.CreateMasterSlaveVServerGroup API asynchronously
// api document: https://help.aliyun.com/api/slb/createmasterslavevservergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMasterSlaveVServerGroupWithCallback(request *CreateMasterSlaveVServerGroupRequest, callback func(response *CreateMasterSlaveVServerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMasterSlaveVServerGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateMasterSlaveVServerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMasterSlaveVServerGroupRequest is the request struct for api CreateMasterSlaveVServerGroup
type CreateMasterSlaveVServerGroupRequest struct {
	*requests.RpcRequest
	AccessKeyId                 string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId             requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MasterSlaveBackendServers   string           `position:"Query" name:"MasterSlaveBackendServers"`
	LoadBalancerId              string           `position:"Query" name:"LoadBalancerId"`
	ResourceOwnerAccount        string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                string           `position:"Query" name:"OwnerAccount"`
	MasterSlaveVServerGroupName string           `position:"Query" name:"MasterSlaveVServerGroupName"`
	OwnerId                     requests.Integer `position:"Query" name:"OwnerId"`
	Tags                        string           `position:"Query" name:"Tags"`
}

// CreateMasterSlaveVServerGroupResponse is the response struct for api CreateMasterSlaveVServerGroup
type CreateMasterSlaveVServerGroupResponse struct {
	*responses.BaseResponse
	RequestId                 string                                                   `json:"RequestId" xml:"RequestId"`
	MasterSlaveVServerGroupId string                                                   `json:"MasterSlaveVServerGroupId" xml:"MasterSlaveVServerGroupId"`
	MasterSlaveBackendServers MasterSlaveBackendServersInCreateMasterSlaveVServerGroup `json:"MasterSlaveBackendServers" xml:"MasterSlaveBackendServers"`
}

// CreateCreateMasterSlaveVServerGroupRequest creates a request to invoke CreateMasterSlaveVServerGroup API
func CreateCreateMasterSlaveVServerGroupRequest() (request *CreateMasterSlaveVServerGroupRequest) {
	request = &CreateMasterSlaveVServerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "CreateMasterSlaveVServerGroup", "slb", "openAPI")
	return
}

// CreateCreateMasterSlaveVServerGroupResponse creates a response to parse from CreateMasterSlaveVServerGroup response
func CreateCreateMasterSlaveVServerGroupResponse() (response *CreateMasterSlaveVServerGroupResponse) {
	response = &CreateMasterSlaveVServerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
