package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainDetail invokes the scdn.DescribeScdnDomainDetail API synchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomaindetail.html
func (client *Client) DescribeScdnDomainDetail(request *DescribeScdnDomainDetailRequest) (response *DescribeScdnDomainDetailResponse, err error) {
	response = CreateDescribeScdnDomainDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainDetailWithChan invokes the scdn.DescribeScdnDomainDetail API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomaindetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainDetailWithChan(request *DescribeScdnDomainDetailRequest) (<-chan *DescribeScdnDomainDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainDetailWithCallback invokes the scdn.DescribeScdnDomainDetail API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomaindetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainDetailWithCallback(request *DescribeScdnDomainDetailRequest, callback func(response *DescribeScdnDomainDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainDetailRequest is the request struct for api DescribeScdnDomainDetail
type DescribeScdnDomainDetailRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnDomainDetailResponse is the response struct for api DescribeScdnDomainDetail
type DescribeScdnDomainDetailResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DomainDetail DomainDetail `json:"DomainDetail" xml:"DomainDetail"`
}

// CreateDescribeScdnDomainDetailRequest creates a request to invoke DescribeScdnDomainDetail API
func CreateDescribeScdnDomainDetailRequest() (request *DescribeScdnDomainDetailRequest) {
	request = &DescribeScdnDomainDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainDetail", "scdn", "openAPI")
	return
}

// CreateDescribeScdnDomainDetailResponse creates a response to parse from DescribeScdnDomainDetail response
func CreateDescribeScdnDomainDetailResponse() (response *DescribeScdnDomainDetailResponse) {
	response = &DescribeScdnDomainDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
