package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReceiveNotify invokes the rtc.ReceiveNotify API synchronously
// api document: https://help.aliyun.com/api/rtc/receivenotify.html
func (client *Client) ReceiveNotify(request *ReceiveNotifyRequest) (response *ReceiveNotifyResponse, err error) {
	response = CreateReceiveNotifyResponse()
	err = client.DoAction(request, response)
	return
}

// ReceiveNotifyWithChan invokes the rtc.ReceiveNotify API asynchronously
// api document: https://help.aliyun.com/api/rtc/receivenotify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReceiveNotifyWithChan(request *ReceiveNotifyRequest) (<-chan *ReceiveNotifyResponse, <-chan error) {
	responseChan := make(chan *ReceiveNotifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReceiveNotify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReceiveNotifyWithCallback invokes the rtc.ReceiveNotify API asynchronously
// api document: https://help.aliyun.com/api/rtc/receivenotify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReceiveNotifyWithCallback(request *ReceiveNotifyRequest, callback func(response *ReceiveNotifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReceiveNotifyResponse
		var err error
		defer close(result)
		response, err = client.ReceiveNotify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReceiveNotifyRequest is the request struct for api ReceiveNotify
type ReceiveNotifyRequest struct {
	*requests.RpcRequest
	TraceId     string           `position:"Query" name:"TraceId"`
	Content     string           `position:"Query" name:"Content"`
	Event       string           `position:"Query" name:"Event"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	ContentType string           `position:"Query" name:"ContentType"`
	BizId       string           `position:"Query" name:"BizId"`
}

// ReceiveNotifyResponse is the response struct for api ReceiveNotify
type ReceiveNotifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
}

// CreateReceiveNotifyRequest creates a request to invoke ReceiveNotify API
func CreateReceiveNotifyRequest() (request *ReceiveNotifyRequest) {
	request = &ReceiveNotifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "ReceiveNotify", "rtc", "openAPI")
	return
}

// CreateReceiveNotifyResponse creates a response to parse from ReceiveNotify response
func CreateReceiveNotifyResponse() (response *ReceiveNotifyResponse) {
	response = &ReceiveNotifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
