package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEntitiesForPolicy invokes the ram.ListEntitiesForPolicy API synchronously
// api document: https://help.aliyun.com/api/ram/listentitiesforpolicy.html
func (client *Client) ListEntitiesForPolicy(request *ListEntitiesForPolicyRequest) (response *ListEntitiesForPolicyResponse, err error) {
	response = CreateListEntitiesForPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListEntitiesForPolicyWithChan invokes the ram.ListEntitiesForPolicy API asynchronously
// api document: https://help.aliyun.com/api/ram/listentitiesforpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEntitiesForPolicyWithChan(request *ListEntitiesForPolicyRequest) (<-chan *ListEntitiesForPolicyResponse, <-chan error) {
	responseChan := make(chan *ListEntitiesForPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEntitiesForPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEntitiesForPolicyWithCallback invokes the ram.ListEntitiesForPolicy API asynchronously
// api document: https://help.aliyun.com/api/ram/listentitiesforpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEntitiesForPolicyWithCallback(request *ListEntitiesForPolicyRequest, callback func(response *ListEntitiesForPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEntitiesForPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListEntitiesForPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEntitiesForPolicyRequest is the request struct for api ListEntitiesForPolicy
type ListEntitiesForPolicyRequest struct {
	*requests.RpcRequest
	PolicyType string `position:"Query" name:"PolicyType"`
	PolicyName string `position:"Query" name:"PolicyName"`
}

// ListEntitiesForPolicyResponse is the response struct for api ListEntitiesForPolicy
type ListEntitiesForPolicyResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Groups    GroupsInListEntitiesForPolicy `json:"Groups" xml:"Groups"`
	Users     UsersInListEntitiesForPolicy  `json:"Users" xml:"Users"`
	Roles     RolesInListEntitiesForPolicy  `json:"Roles" xml:"Roles"`
}

// CreateListEntitiesForPolicyRequest creates a request to invoke ListEntitiesForPolicy API
func CreateListEntitiesForPolicyRequest() (request *ListEntitiesForPolicyRequest) {
	request = &ListEntitiesForPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "ListEntitiesForPolicy", "ram", "openAPI")
	return
}

// CreateListEntitiesForPolicyResponse creates a response to parse from ListEntitiesForPolicy response
func CreateListEntitiesForPolicyResponse() (response *ListEntitiesForPolicyResponse) {
	response = &ListEntitiesForPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
