//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTieringPolicies invokes the nas.DescribeTieringPolicies API synchronously
// api document: https://help.aliyun.com/api/nas/describetieringpolicies.html
func (client *Client) DescribeTieringPolicies(request *DescribeTieringPoliciesRequest) (response *DescribeTieringPoliciesResponse, err error) {
	response = CreateDescribeTieringPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTieringPoliciesWithChan invokes the nas.DescribeTieringPolicies API asynchronously
// api document: https://help.aliyun.com/api/nas/describetieringpolicies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTieringPoliciesWithChan(request *DescribeTieringPoliciesRequest) (<-chan *DescribeTieringPoliciesResponse, <-chan error) {
	responseChan := make(chan *DescribeTieringPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTieringPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTieringPoliciesWithCallback invokes the nas.DescribeTieringPolicies API asynchronously
// api document: https://help.aliyun.com/api/nas/describetieringpolicies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTieringPoliciesWithCallback(request *DescribeTieringPoliciesRequest, callback func(response *DescribeTieringPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTieringPoliciesResponse
		var err error
		defer close(result)
		response, err = client.DescribeTieringPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTieringPoliciesRequest is the request struct for api DescribeTieringPolicies
type DescribeTieringPoliciesRequest struct {
	*requests.RpcRequest
}

// DescribeTieringPoliciesResponse is the response struct for api DescribeTieringPolicies
type DescribeTieringPoliciesResponse struct {
	*responses.BaseResponse
	RequestId       string                                  `json:"RequestId" xml:"RequestId"`
	TotalCount      int                                     `json:"TotalCount" xml:"TotalCount"`
	PageSize        int                                     `json:"PageSize" xml:"PageSize"`
	PageNumber      int                                     `json:"PageNumber" xml:"PageNumber"`
	TieringPolicies DescribeTieringPoliciesTieringPolicies0 `json:"TieringPolicies" xml:"TieringPolicies"`
}

type DescribeTieringPoliciesTieringPolicies0 struct {
	TieringPolicy []DescribeTieringPoliciesTieringPolicy1 `json:"TieringPolicy" xml:"TieringPolicy"`
}

type DescribeTieringPoliciesTieringPolicy1 struct {
	Name        string `json:"Name" xml:"Name"`
	Description string `json:"Description" xml:"Description"`
	RefCount    int    `json:"RefCount" xml:"RefCount"`
	Mtime       int64  `json:"Mtime" xml:"Mtime"`
	Atime       int64  `json:"Atime" xml:"Atime"`
	Ctime       int64  `json:"Ctime" xml:"Ctime"`
	Size        int64  `json:"Size" xml:"Size"`
	FileName    string `json:"FileName" xml:"FileName"`
	RecallTime  int64  `json:"RecallTime" xml:"RecallTime"`
}

// CreateDescribeTieringPoliciesRequest creates a request to invoke DescribeTieringPolicies API
func CreateDescribeTieringPoliciesRequest() (request *DescribeTieringPoliciesRequest) {
	request = &DescribeTieringPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeTieringPolicies", "nas", "openAPI")
	return
}

// CreateDescribeTieringPoliciesResponse creates a response to parse from DescribeTieringPolicies response
func CreateDescribeTieringPoliciesResponse() (response *DescribeTieringPoliciesResponse) {
	response = &DescribeTieringPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
