//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTieringJob invokes the nas.DeleteTieringJob API synchronously
// api document: https://help.aliyun.com/api/nas/deletetieringjob.html
func (client *Client) DeleteTieringJob(request *DeleteTieringJobRequest) (response *DeleteTieringJobResponse, err error) {
	response = CreateDeleteTieringJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTieringJobWithChan invokes the nas.DeleteTieringJob API asynchronously
// api document: https://help.aliyun.com/api/nas/deletetieringjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTieringJobWithChan(request *DeleteTieringJobRequest) (<-chan *DeleteTieringJobResponse, <-chan error) {
	responseChan := make(chan *DeleteTieringJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTieringJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTieringJobWithCallback invokes the nas.DeleteTieringJob API asynchronously
// api document: https://help.aliyun.com/api/nas/deletetieringjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTieringJobWithCallback(request *DeleteTieringJobRequest, callback func(response *DeleteTieringJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTieringJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteTieringJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTieringJobRequest is the request struct for api DeleteTieringJob
type DeleteTieringJobRequest struct {
	*requests.RpcRequest
	Volume string `position:"Query" name:"Volume"`
	Name   string `position:"Query" name:"Name"`
}

// DeleteTieringJobResponse is the response struct for api DeleteTieringJob
type DeleteTieringJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteTieringJobRequest creates a request to invoke DeleteTieringJob API
func CreateDeleteTieringJobRequest() (request *DeleteTieringJobRequest) {
	request = &DeleteTieringJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteTieringJob", "nas", "openAPI")
	return
}

// CreateDeleteTieringJobResponse creates a response to parse from DeleteTieringJob response
func CreateDeleteTieringJobResponse() (response *DeleteTieringJobResponse) {
	response = &DeleteTieringJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
