package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCategoryName invokes the mts.UpdateCategoryName API synchronously
// api document: https://help.aliyun.com/api/mts/updatecategoryname.html
func (client *Client) UpdateCategoryName(request *UpdateCategoryNameRequest) (response *UpdateCategoryNameResponse, err error) {
	response = CreateUpdateCategoryNameResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCategoryNameWithChan invokes the mts.UpdateCategoryName API asynchronously
// api document: https://help.aliyun.com/api/mts/updatecategoryname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateCategoryNameWithChan(request *UpdateCategoryNameRequest) (<-chan *UpdateCategoryNameResponse, <-chan error) {
	responseChan := make(chan *UpdateCategoryNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCategoryName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCategoryNameWithCallback invokes the mts.UpdateCategoryName API asynchronously
// api document: https://help.aliyun.com/api/mts/updatecategoryname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateCategoryNameWithCallback(request *UpdateCategoryNameRequest, callback func(response *UpdateCategoryNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCategoryNameResponse
		var err error
		defer close(result)
		response, err = client.UpdateCategoryName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCategoryNameRequest is the request struct for api UpdateCategoryName
type UpdateCategoryNameRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CateId               string           `position:"Query" name:"CateId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CateName             string           `position:"Query" name:"CateName"`
}

// UpdateCategoryNameResponse is the response struct for api UpdateCategoryName
type UpdateCategoryNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCategoryNameRequest creates a request to invoke UpdateCategoryName API
func CreateUpdateCategoryNameRequest() (request *UpdateCategoryNameRequest) {
	request = &UpdateCategoryNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "UpdateCategoryName", "mts", "openAPI")
	return
}

// CreateUpdateCategoryNameResponse creates a response to parse from UpdateCategoryName response
func CreateUpdateCategoryNameResponse() (response *UpdateCategoryNameResponse) {
	response = &UpdateCategoryNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
