package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMCTemplate invokes the mts.DeleteMCTemplate API synchronously
// api document: https://help.aliyun.com/api/mts/deletemctemplate.html
func (client *Client) DeleteMCTemplate(request *DeleteMCTemplateRequest) (response *DeleteMCTemplateResponse, err error) {
	response = CreateDeleteMCTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMCTemplateWithChan invokes the mts.DeleteMCTemplate API asynchronously
// api document: https://help.aliyun.com/api/mts/deletemctemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMCTemplateWithChan(request *DeleteMCTemplateRequest) (<-chan *DeleteMCTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteMCTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMCTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMCTemplateWithCallback invokes the mts.DeleteMCTemplate API asynchronously
// api document: https://help.aliyun.com/api/mts/deletemctemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMCTemplateWithCallback(request *DeleteMCTemplateRequest, callback func(response *DeleteMCTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMCTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteMCTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMCTemplateRequest is the request struct for api DeleteMCTemplate
type DeleteMCTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId           string           `position:"Query" name:"TemplateId"`
}

// DeleteMCTemplateResponse is the response struct for api DeleteMCTemplate
type DeleteMCTemplateResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateDeleteMCTemplateRequest creates a request to invoke DeleteMCTemplate API
func CreateDeleteMCTemplateRequest() (request *DeleteMCTemplateRequest) {
	request = &DeleteMCTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "DeleteMCTemplate", "mts", "openAPI")
	return
}

// CreateDeleteMCTemplateResponse creates a response to parse from DeleteMCTemplate response
func CreateDeleteMCTemplateResponse() (response *DeleteMCTemplateResponse) {
	response = &DeleteMCTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
