package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCasterLayout invokes the live.ModifyCasterLayout API synchronously
// api document: https://help.aliyun.com/api/live/modifycasterlayout.html
func (client *Client) ModifyCasterLayout(request *ModifyCasterLayoutRequest) (response *ModifyCasterLayoutResponse, err error) {
	response = CreateModifyCasterLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCasterLayoutWithChan invokes the live.ModifyCasterLayout API asynchronously
// api document: https://help.aliyun.com/api/live/modifycasterlayout.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCasterLayoutWithChan(request *ModifyCasterLayoutRequest) (<-chan *ModifyCasterLayoutResponse, <-chan error) {
	responseChan := make(chan *ModifyCasterLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCasterLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCasterLayoutWithCallback invokes the live.ModifyCasterLayout API asynchronously
// api document: https://help.aliyun.com/api/live/modifycasterlayout.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCasterLayoutWithCallback(request *ModifyCasterLayoutRequest, callback func(response *ModifyCasterLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCasterLayoutResponse
		var err error
		defer close(result)
		response, err = client.ModifyCasterLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCasterLayoutRequest is the request struct for api ModifyCasterLayout
type ModifyCasterLayoutRequest struct {
	*requests.RpcRequest
	BlendList  *[]string                       `position:"Query" name:"BlendList"  type:"Repeated"`
	AudioLayer *[]ModifyCasterLayoutAudioLayer `position:"Query" name:"AudioLayer"  type:"Repeated"`
	VideoLayer *[]ModifyCasterLayoutVideoLayer `position:"Query" name:"VideoLayer"  type:"Repeated"`
	CasterId   string                          `position:"Query" name:"CasterId"`
	MixList    *[]string                       `position:"Query" name:"MixList"  type:"Repeated"`
	OwnerId    requests.Integer                `position:"Query" name:"OwnerId"`
	LayoutId   string                          `position:"Query" name:"LayoutId"`
}

// ModifyCasterLayoutAudioLayer is a repeated param struct in ModifyCasterLayoutRequest
type ModifyCasterLayoutAudioLayer struct {
	FixedDelayDuration string `name:"FixedDelayDuration"`
	VolumeRate         string `name:"VolumeRate"`
	ValidChannel       string `name:"ValidChannel"`
}

// ModifyCasterLayoutVideoLayer is a repeated param struct in ModifyCasterLayoutRequest
type ModifyCasterLayoutVideoLayer struct {
	FillMode           string            `name:"FillMode"`
	WidthNormalized    string            `name:"WidthNormalized"`
	FixedDelayDuration string            `name:"FixedDelayDuration"`
	PositionRefer      string            `name:"PositionRefer"`
	PositionNormalized *[]requests.Float `name:"PositionNormalized" type:"Repeated"`
	HeightNormalized   string            `name:"HeightNormalized"`
}

// ModifyCasterLayoutResponse is the response struct for api ModifyCasterLayout
type ModifyCasterLayoutResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	LayoutId  string `json:"LayoutId" xml:"LayoutId"`
}

// CreateModifyCasterLayoutRequest creates a request to invoke ModifyCasterLayout API
func CreateModifyCasterLayoutRequest() (request *ModifyCasterLayoutRequest) {
	request = &ModifyCasterLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ModifyCasterLayout", "live", "openAPI")
	return
}

// CreateModifyCasterLayoutResponse creates a response to parse from ModifyCasterLayout response
func CreateModifyCasterLayoutResponse() (response *ModifyCasterLayoutResponse) {
	response = &ModifyCasterLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
