package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTagJob invokes the imm.DeleteTagJob API synchronously
// api document: https://help.aliyun.com/api/imm/deletetagjob.html
func (client *Client) DeleteTagJob(request *DeleteTagJobRequest) (response *DeleteTagJobResponse, err error) {
	response = CreateDeleteTagJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagJobWithChan invokes the imm.DeleteTagJob API asynchronously
// api document: https://help.aliyun.com/api/imm/deletetagjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTagJobWithChan(request *DeleteTagJobRequest) (<-chan *DeleteTagJobResponse, <-chan error) {
	responseChan := make(chan *DeleteTagJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTagJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagJobWithCallback invokes the imm.DeleteTagJob API asynchronously
// api document: https://help.aliyun.com/api/imm/deletetagjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTagJobWithCallback(request *DeleteTagJobRequest, callback func(response *DeleteTagJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteTagJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagJobRequest is the request struct for api DeleteTagJob
type DeleteTagJobRequest struct {
	*requests.RpcRequest
	JobId          string `position:"Query" name:"JobId"`
	Project        string `position:"Query" name:"Project"`
	ClearIndexData string `position:"Query" name:"ClearIndexData"`
}

// DeleteTagJobResponse is the response struct for api DeleteTagJob
type DeleteTagJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagJobRequest creates a request to invoke DeleteTagJob API
func CreateDeleteTagJobRequest() (request *DeleteTagJobRequest) {
	request = &DeleteTagJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeleteTagJob", "imm", "openAPI")
	return
}

// CreateDeleteTagJobResponse creates a response to parse from DeleteTagJob response
func CreateDeleteTagJobResponse() (response *DeleteTagJobResponse) {
	response = &DeleteTagJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
