package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTagByName invokes the imm.DeleteTagByName API synchronously
// api document: https://help.aliyun.com/api/imm/deletetagbyname.html
func (client *Client) DeleteTagByName(request *DeleteTagByNameRequest) (response *DeleteTagByNameResponse, err error) {
	response = CreateDeleteTagByNameResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagByNameWithChan invokes the imm.DeleteTagByName API asynchronously
// api document: https://help.aliyun.com/api/imm/deletetagbyname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTagByNameWithChan(request *DeleteTagByNameRequest) (<-chan *DeleteTagByNameResponse, <-chan error) {
	responseChan := make(chan *DeleteTagByNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTagByName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagByNameWithCallback invokes the imm.DeleteTagByName API asynchronously
// api document: https://help.aliyun.com/api/imm/deletetagbyname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTagByNameWithCallback(request *DeleteTagByNameRequest, callback func(response *DeleteTagByNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagByNameResponse
		var err error
		defer close(result)
		response, err = client.DeleteTagByName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagByNameRequest is the request struct for api DeleteTagByName
type DeleteTagByNameRequest struct {
	*requests.RpcRequest
	TagName string `position:"Query" name:"TagName"`
	Project string `position:"Query" name:"Project"`
	SetId   string `position:"Query" name:"SetId"`
	SrcUri  string `position:"Query" name:"SrcUri"`
}

// DeleteTagByNameResponse is the response struct for api DeleteTagByName
type DeleteTagByNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagByNameRequest creates a request to invoke DeleteTagByName API
func CreateDeleteTagByNameRequest() (request *DeleteTagByNameRequest) {
	request = &DeleteTagByNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeleteTagByName", "imm", "openAPI")
	return
}

// CreateDeleteTagByNameResponse creates a response to parse from DeleteTagByName response
func CreateDeleteTagByNameResponse() (response *DeleteTagByNameResponse) {
	response = &DeleteTagByNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
