package imagesearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchItem invokes the imagesearch.SearchItem API synchronously
// api document: https://help.aliyun.com/api/imagesearch/searchitem.html
func (client *Client) SearchItem(request *SearchItemRequest) (response *SearchItemResponse, err error) {
	response = CreateSearchItemResponse()
	err = client.DoAction(request, response)
	return
}

// SearchItemWithChan invokes the imagesearch.SearchItem API asynchronously
// api document: https://help.aliyun.com/api/imagesearch/searchitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchItemWithChan(request *SearchItemRequest) (<-chan *SearchItemResponse, <-chan error) {
	responseChan := make(chan *SearchItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchItemWithCallback invokes the imagesearch.SearchItem API asynchronously
// api document: https://help.aliyun.com/api/imagesearch/searchitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchItemWithCallback(request *SearchItemRequest, callback func(response *SearchItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchItemResponse
		var err error
		defer close(result)
		response, err = client.SearchItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchItemRequest is the request struct for api SearchItem
type SearchItemRequest struct {
	*requests.RoaRequest
	InstanceName string `position:"Query" name:"instanceName"`
}

// SearchItemResponse is the response struct for api SearchItem
type SearchItemResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Message   string   `json:"Message" xml:"Message"`
	Code      int      `json:"Code" xml:"Code"`
	Head      Head     `json:"Head" xml:"Head"`
	PicInfo   PicInfo  `json:"PicInfo" xml:"PicInfo"`
	Auctions  Auctions `json:"Auctions" xml:"Auctions"`
}

// CreateSearchItemRequest creates a request to invoke SearchItem API
func CreateSearchItemRequest() (request *SearchItemRequest) {
	request = &SearchItemRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ImageSearch", "2018-01-20", "SearchItem", "/item/search", "imagesearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchItemResponse creates a response to parse from SearchItem response
func CreateSearchItemResponse() (response *SearchItemResponse) {
	response = &SearchItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
