package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCreditWithdrawRecord invokes the finmall.GetCreditWithdrawRecord API synchronously
// api document: https://help.aliyun.com/api/finmall/getcreditwithdrawrecord.html
func (client *Client) GetCreditWithdrawRecord(request *GetCreditWithdrawRecordRequest) (response *GetCreditWithdrawRecordResponse, err error) {
	response = CreateGetCreditWithdrawRecordResponse()
	err = client.DoAction(request, response)
	return
}

// GetCreditWithdrawRecordWithChan invokes the finmall.GetCreditWithdrawRecord API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditwithdrawrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditWithdrawRecordWithChan(request *GetCreditWithdrawRecordRequest) (<-chan *GetCreditWithdrawRecordResponse, <-chan error) {
	responseChan := make(chan *GetCreditWithdrawRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCreditWithdrawRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCreditWithdrawRecordWithCallback invokes the finmall.GetCreditWithdrawRecord API asynchronously
// api document: https://help.aliyun.com/api/finmall/getcreditwithdrawrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCreditWithdrawRecordWithCallback(request *GetCreditWithdrawRecordRequest, callback func(response *GetCreditWithdrawRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCreditWithdrawRecordResponse
		var err error
		defer close(result)
		response, err = client.GetCreditWithdrawRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCreditWithdrawRecordRequest is the request struct for api GetCreditWithdrawRecord
type GetCreditWithdrawRecordRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	UserId   string `position:"Query" name:"UserId"`
}

// GetCreditWithdrawRecordResponse is the response struct for api GetCreditWithdrawRecord
type GetCreditWithdrawRecordResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetCreditWithdrawRecordRequest creates a request to invoke GetCreditWithdrawRecord API
func CreateGetCreditWithdrawRecordRequest() (request *GetCreditWithdrawRecordRequest) {
	request = &GetCreditWithdrawRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetCreditWithdrawRecord", "finmall", "openAPI")
	return
}

// CreateGetCreditWithdrawRecordResponse creates a response to parse from GetCreditWithdrawRecord response
func CreateGetCreditWithdrawRecordResponse() (response *GetCreditWithdrawRecordResponse) {
	response = &GetCreditWithdrawRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
