package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowClusterAllHosts invokes the emr.ListFlowClusterAllHosts API synchronously
// api document: https://help.aliyun.com/api/emr/listflowclusterallhosts.html
func (client *Client) ListFlowClusterAllHosts(request *ListFlowClusterAllHostsRequest) (response *ListFlowClusterAllHostsResponse, err error) {
	response = CreateListFlowClusterAllHostsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowClusterAllHostsWithChan invokes the emr.ListFlowClusterAllHosts API asynchronously
// api document: https://help.aliyun.com/api/emr/listflowclusterallhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowClusterAllHostsWithChan(request *ListFlowClusterAllHostsRequest) (<-chan *ListFlowClusterAllHostsResponse, <-chan error) {
	responseChan := make(chan *ListFlowClusterAllHostsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowClusterAllHosts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowClusterAllHostsWithCallback invokes the emr.ListFlowClusterAllHosts API asynchronously
// api document: https://help.aliyun.com/api/emr/listflowclusterallhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFlowClusterAllHostsWithCallback(request *ListFlowClusterAllHostsRequest, callback func(response *ListFlowClusterAllHostsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowClusterAllHostsResponse
		var err error
		defer close(result)
		response, err = client.ListFlowClusterAllHosts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowClusterAllHostsRequest is the request struct for api ListFlowClusterAllHosts
type ListFlowClusterAllHostsRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// ListFlowClusterAllHostsResponse is the response struct for api ListFlowClusterAllHosts
type ListFlowClusterAllHostsResponse struct {
	*responses.BaseResponse
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	HostList  HostListInListFlowClusterAllHosts `json:"HostList" xml:"HostList"`
}

// CreateListFlowClusterAllHostsRequest creates a request to invoke ListFlowClusterAllHosts API
func CreateListFlowClusterAllHostsRequest() (request *ListFlowClusterAllHostsRequest) {
	request = &ListFlowClusterAllHostsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlowClusterAllHosts", "emr", "openAPI")
	return
}

// CreateListFlowClusterAllHostsResponse creates a response to parse from ListFlowClusterAllHosts response
func CreateListFlowClusterAllHostsResponse() (response *ListFlowClusterAllHostsResponse) {
	response = &ListFlowClusterAllHostsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
