package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserStatistics invokes the emr.CreateUserStatistics API synchronously
// api document: https://help.aliyun.com/api/emr/createuserstatistics.html
func (client *Client) CreateUserStatistics(request *CreateUserStatisticsRequest) (response *CreateUserStatisticsResponse, err error) {
	response = CreateCreateUserStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserStatisticsWithChan invokes the emr.CreateUserStatistics API asynchronously
// api document: https://help.aliyun.com/api/emr/createuserstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserStatisticsWithChan(request *CreateUserStatisticsRequest) (<-chan *CreateUserStatisticsResponse, <-chan error) {
	responseChan := make(chan *CreateUserStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserStatisticsWithCallback invokes the emr.CreateUserStatistics API asynchronously
// api document: https://help.aliyun.com/api/emr/createuserstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserStatisticsWithCallback(request *CreateUserStatisticsRequest, callback func(response *CreateUserStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserStatisticsResponse
		var err error
		defer close(result)
		response, err = client.CreateUserStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserStatisticsRequest is the request struct for api CreateUserStatistics
type CreateUserStatisticsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// CreateUserStatisticsResponse is the response struct for api CreateUserStatistics
type CreateUserStatisticsResponse struct {
	*responses.BaseResponse
}

// CreateCreateUserStatisticsRequest creates a request to invoke CreateUserStatistics API
func CreateCreateUserStatisticsRequest() (request *CreateUserStatisticsRequest) {
	request = &CreateUserStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateUserStatistics", "emr", "openAPI")
	return
}

// CreateCreateUserStatisticsResponse creates a response to parse from CreateUserStatistics response
func CreateCreateUserStatisticsResponse() (response *CreateUserStatisticsResponse) {
	response = &CreateUserStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
