package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserSourceRepoRefList invokes the cr.GetUserSourceRepoRefList API synchronously
// api document: https://help.aliyun.com/api/cr/getusersourcereporeflist.html
func (client *Client) GetUserSourceRepoRefList(request *GetUserSourceRepoRefListRequest) (response *GetUserSourceRepoRefListResponse, err error) {
	response = CreateGetUserSourceRepoRefListResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserSourceRepoRefListWithChan invokes the cr.GetUserSourceRepoRefList API asynchronously
// api document: https://help.aliyun.com/api/cr/getusersourcereporeflist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserSourceRepoRefListWithChan(request *GetUserSourceRepoRefListRequest) (<-chan *GetUserSourceRepoRefListResponse, <-chan error) {
	responseChan := make(chan *GetUserSourceRepoRefListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserSourceRepoRefList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserSourceRepoRefListWithCallback invokes the cr.GetUserSourceRepoRefList API asynchronously
// api document: https://help.aliyun.com/api/cr/getusersourcereporeflist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserSourceRepoRefListWithCallback(request *GetUserSourceRepoRefListRequest, callback func(response *GetUserSourceRepoRefListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserSourceRepoRefListResponse
		var err error
		defer close(result)
		response, err = client.GetUserSourceRepoRefList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserSourceRepoRefListRequest is the request struct for api GetUserSourceRepoRefList
type GetUserSourceRepoRefListRequest struct {
	*requests.RoaRequest
	SourceAccountId     requests.Integer `position:"Path" name:"SourceAccountId"`
	SourceRepoName      string           `position:"Path" name:"SourceRepoName"`
	SourceRepoNamespace string           `position:"Path" name:"SourceRepoNamespace"`
}

// GetUserSourceRepoRefListResponse is the response struct for api GetUserSourceRepoRefList
type GetUserSourceRepoRefListResponse struct {
	*responses.BaseResponse
}

// CreateGetUserSourceRepoRefListRequest creates a request to invoke GetUserSourceRepoRefList API
func CreateGetUserSourceRepoRefListRequest() (request *GetUserSourceRepoRefListRequest) {
	request = &GetUserSourceRepoRefListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetUserSourceRepoRefList", "/users/sourceAccount/[SourceAccountId]/repos/[SourceRepoNamespace]/[SourceRepoName]/refs", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetUserSourceRepoRefListResponse creates a response to parse from GetUserSourceRepoRefList response
func CreateGetUserSourceRepoRefListResponse() (response *GetUserSourceRepoRefListResponse) {
	response = &GetUserSourceRepoRefListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
