package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMyGroupMembers invokes the cms.UpdateMyGroupMembers API synchronously
// api document: https://help.aliyun.com/api/cms/updatemygroupmembers.html
func (client *Client) UpdateMyGroupMembers(request *UpdateMyGroupMembersRequest) (response *UpdateMyGroupMembersResponse, err error) {
	response = CreateUpdateMyGroupMembersResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMyGroupMembersWithChan invokes the cms.UpdateMyGroupMembers API asynchronously
// api document: https://help.aliyun.com/api/cms/updatemygroupmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateMyGroupMembersWithChan(request *UpdateMyGroupMembersRequest) (<-chan *UpdateMyGroupMembersResponse, <-chan error) {
	responseChan := make(chan *UpdateMyGroupMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMyGroupMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMyGroupMembersWithCallback invokes the cms.UpdateMyGroupMembers API asynchronously
// api document: https://help.aliyun.com/api/cms/updatemygroupmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateMyGroupMembersWithCallback(request *UpdateMyGroupMembersRequest, callback func(response *UpdateMyGroupMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMyGroupMembersResponse
		var err error
		defer close(result)
		response, err = client.UpdateMyGroupMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMyGroupMembersRequest is the request struct for api UpdateMyGroupMembers
type UpdateMyGroupMembersRequest struct {
	*requests.RpcRequest
	Readers string           `position:"Query" name:"Readers"`
	GroupId requests.Integer `position:"Query" name:"GroupId"`
	Masters string           `position:"Query" name:"Masters"`
}

// UpdateMyGroupMembersResponse is the response struct for api UpdateMyGroupMembers
type UpdateMyGroupMembersResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateMyGroupMembersRequest creates a request to invoke UpdateMyGroupMembers API
func CreateUpdateMyGroupMembersRequest() (request *UpdateMyGroupMembersRequest) {
	request = &UpdateMyGroupMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "UpdateMyGroupMembers", "cms", "openAPI")
	return
}

// CreateUpdateMyGroupMembersResponse creates a response to parse from UpdateMyGroupMembers response
func CreateUpdateMyGroupMembersResponse() (response *UpdateMyGroupMembersResponse) {
	response = &UpdateMyGroupMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
