package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMonitoringTemplate invokes the cms.GetMonitoringTemplate API synchronously
// api document: https://help.aliyun.com/api/cms/getmonitoringtemplate.html
func (client *Client) GetMonitoringTemplate(request *GetMonitoringTemplateRequest) (response *GetMonitoringTemplateResponse, err error) {
	response = CreateGetMonitoringTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetMonitoringTemplateWithChan invokes the cms.GetMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/getmonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMonitoringTemplateWithChan(request *GetMonitoringTemplateRequest) (<-chan *GetMonitoringTemplateResponse, <-chan error) {
	responseChan := make(chan *GetMonitoringTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMonitoringTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMonitoringTemplateWithCallback invokes the cms.GetMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/getmonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMonitoringTemplateWithCallback(request *GetMonitoringTemplateRequest, callback func(response *GetMonitoringTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMonitoringTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetMonitoringTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMonitoringTemplateRequest is the request struct for api GetMonitoringTemplate
type GetMonitoringTemplateRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
	Id   string `position:"Query" name:"Id"`
}

// GetMonitoringTemplateResponse is the response struct for api GetMonitoringTemplate
type GetMonitoringTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string                          `json:"RequestId" xml:"RequestId"`
	Success      bool                            `json:"Success" xml:"Success"`
	ErrorCode    int                             `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                          `json:"ErrorMessage" xml:"ErrorMessage"`
	Resource     ResourceInGetMonitoringTemplate `json:"Resource" xml:"Resource"`
}

// CreateGetMonitoringTemplateRequest creates a request to invoke GetMonitoringTemplate API
func CreateGetMonitoringTemplateRequest() (request *GetMonitoringTemplateRequest) {
	request = &GetMonitoringTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "GetMonitoringTemplate", "cms", "openAPI")
	return
}

// CreateGetMonitoringTemplateResponse creates a response to parse from GetMonitoringTemplate response
func CreateGetMonitoringTemplateResponse() (response *GetMonitoringTemplateResponse) {
	response = &GetMonitoringTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
