package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeISPAreaCity invokes the cms.DescribeISPAreaCity API synchronously
// api document: https://help.aliyun.com/api/cms/describeispareacity.html
func (client *Client) DescribeISPAreaCity(request *DescribeISPAreaCityRequest) (response *DescribeISPAreaCityResponse, err error) {
	response = CreateDescribeISPAreaCityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeISPAreaCityWithChan invokes the cms.DescribeISPAreaCity API asynchronously
// api document: https://help.aliyun.com/api/cms/describeispareacity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeISPAreaCityWithChan(request *DescribeISPAreaCityRequest) (<-chan *DescribeISPAreaCityResponse, <-chan error) {
	responseChan := make(chan *DescribeISPAreaCityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeISPAreaCity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeISPAreaCityWithCallback invokes the cms.DescribeISPAreaCity API asynchronously
// api document: https://help.aliyun.com/api/cms/describeispareacity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeISPAreaCityWithCallback(request *DescribeISPAreaCityRequest, callback func(response *DescribeISPAreaCityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeISPAreaCityResponse
		var err error
		defer close(result)
		response, err = client.DescribeISPAreaCity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeISPAreaCityRequest is the request struct for api DescribeISPAreaCity
type DescribeISPAreaCityRequest struct {
	*requests.RpcRequest
	City string `position:"Query" name:"City"`
	Isp  string `position:"Query" name:"Isp"`
}

// DescribeISPAreaCityResponse is the response struct for api DescribeISPAreaCity
type DescribeISPAreaCityResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDescribeISPAreaCityRequest creates a request to invoke DescribeISPAreaCity API
func CreateDescribeISPAreaCityRequest() (request *DescribeISPAreaCityRequest) {
	request = &DescribeISPAreaCityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DescribeISPAreaCity", "cms", "openAPI")
	return
}

// CreateDescribeISPAreaCityResponse creates a response to parse from DescribeISPAreaCity response
func CreateDescribeISPAreaCityResponse() (response *DescribeISPAreaCityResponse) {
	response = &DescribeISPAreaCityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
