package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlarmsForResources invokes the cms.DescribeAlarmsForResources API synchronously
// api document: https://help.aliyun.com/api/cms/describealarmsforresources.html
func (client *Client) DescribeAlarmsForResources(request *DescribeAlarmsForResourcesRequest) (response *DescribeAlarmsForResourcesResponse, err error) {
	response = CreateDescribeAlarmsForResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlarmsForResourcesWithChan invokes the cms.DescribeAlarmsForResources API asynchronously
// api document: https://help.aliyun.com/api/cms/describealarmsforresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAlarmsForResourcesWithChan(request *DescribeAlarmsForResourcesRequest) (<-chan *DescribeAlarmsForResourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeAlarmsForResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlarmsForResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlarmsForResourcesWithCallback invokes the cms.DescribeAlarmsForResources API asynchronously
// api document: https://help.aliyun.com/api/cms/describealarmsforresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAlarmsForResourcesWithCallback(request *DescribeAlarmsForResourcesRequest, callback func(response *DescribeAlarmsForResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlarmsForResourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlarmsForResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlarmsForResourcesRequest is the request struct for api DescribeAlarmsForResources
type DescribeAlarmsForResourcesRequest struct {
	*requests.RpcRequest
	EnableState requests.Boolean `position:"Query" name:"EnableState"`
	GroupId     string           `position:"Query" name:"GroupId"`
	Namespace   string           `position:"Query" name:"Namespace"`
	PageSize    string           `position:"Query" name:"PageSize"`
	AlertState  string           `position:"Query" name:"AlertState"`
	Page        string           `position:"Query" name:"Page"`
	MetricName  string           `position:"Query" name:"MetricName"`
	Dimensions  string           `position:"Query" name:"Dimensions"`
}

// DescribeAlarmsForResourcesResponse is the response struct for api DescribeAlarmsForResources
type DescribeAlarmsForResourcesResponse struct {
	*responses.BaseResponse
	RequestId  string                                 `json:"RequestId" xml:"RequestId"`
	TraceId    string                                 `json:"TraceId" xml:"TraceId"`
	Success    bool                                   `json:"Success" xml:"Success"`
	Code       int                                    `json:"Code" xml:"Code"`
	Message    string                                 `json:"Message" xml:"Message"`
	Total      string                                 `json:"Total" xml:"Total"`
	Dimensions string                                 `json:"Dimensions" xml:"Dimensions"`
	Datapoints DatapointsInDescribeAlarmsForResources `json:"Datapoints" xml:"Datapoints"`
}

// CreateDescribeAlarmsForResourcesRequest creates a request to invoke DescribeAlarmsForResources API
func CreateDescribeAlarmsForResourcesRequest() (request *DescribeAlarmsForResourcesRequest) {
	request = &DescribeAlarmsForResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DescribeAlarmsForResources", "cms", "openAPI")
	return
}

// CreateDescribeAlarmsForResourcesResponse creates a response to parse from DescribeAlarmsForResources response
func CreateDescribeAlarmsForResourcesResponse() (response *DescribeAlarmsForResourcesResponse) {
	response = &DescribeAlarmsForResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
