package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeviceUpdate invokes the cloudwf.DeviceUpdate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/deviceupdate.html
func (client *Client) DeviceUpdate(request *DeviceUpdateRequest) (response *DeviceUpdateResponse, err error) {
	response = CreateDeviceUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// DeviceUpdateWithChan invokes the cloudwf.DeviceUpdate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deviceupdate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceUpdateWithChan(request *DeviceUpdateRequest) (<-chan *DeviceUpdateResponse, <-chan error) {
	responseChan := make(chan *DeviceUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeviceUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeviceUpdateWithCallback invokes the cloudwf.DeviceUpdate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deviceupdate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceUpdateWithCallback(request *DeviceUpdateRequest, callback func(response *DeviceUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeviceUpdateResponse
		var err error
		defer close(result)
		response, err = client.DeviceUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeviceUpdateRequest is the request struct for api DeviceUpdate
type DeviceUpdateRequest struct {
	*requests.RpcRequest
	DevicePosition string           `position:"Query" name:"DevicePosition"`
	DeviceName     string           `position:"Query" name:"DeviceName"`
	Did            requests.Integer `position:"Query" name:"Did"`
}

// DeviceUpdateResponse is the response struct for api DeviceUpdate
type DeviceUpdateResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeviceUpdateRequest creates a request to invoke DeviceUpdate API
func CreateDeviceUpdateRequest() (request *DeviceUpdateRequest) {
	request = &DeviceUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeviceUpdate", "cloudwf", "openAPI")
	return
}

// CreateDeviceUpdateResponse creates a response to parse from DeviceUpdate response
func CreateDeviceUpdateResponse() (response *DeviceUpdateResponse) {
	response = &DeviceUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
