package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrganizationPeers invokes the baas.DescribeOrganizationPeers API synchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationpeers.html
func (client *Client) DescribeOrganizationPeers(request *DescribeOrganizationPeersRequest) (response *DescribeOrganizationPeersResponse, err error) {
	response = CreateDescribeOrganizationPeersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrganizationPeersWithChan invokes the baas.DescribeOrganizationPeers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationpeers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationPeersWithChan(request *DescribeOrganizationPeersRequest) (<-chan *DescribeOrganizationPeersResponse, <-chan error) {
	responseChan := make(chan *DescribeOrganizationPeersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrganizationPeers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrganizationPeersWithCallback invokes the baas.DescribeOrganizationPeers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationpeers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationPeersWithCallback(request *DescribeOrganizationPeersRequest, callback func(response *DescribeOrganizationPeersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrganizationPeersResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrganizationPeers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrganizationPeersRequest is the request struct for api DescribeOrganizationPeers
type DescribeOrganizationPeersRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeOrganizationPeersResponse is the response struct for api DescribeOrganizationPeers
type DescribeOrganizationPeersResponse struct {
	*responses.BaseResponse
	RequestId string                                  `json:"RequestId" xml:"RequestId"`
	Success   bool                                    `json:"Success" xml:"Success"`
	ErrorCode int                                     `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItemInDescribeOrganizationPeers `json:"Result" xml:"Result"`
}

// CreateDescribeOrganizationPeersRequest creates a request to invoke DescribeOrganizationPeers API
func CreateDescribeOrganizationPeersRequest() (request *DescribeOrganizationPeersRequest) {
	request = &DescribeOrganizationPeersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOrganizationPeers", "", "")
	return
}

// CreateDescribeOrganizationPeersResponse creates a response to parse from DescribeOrganizationPeers response
func CreateDescribeOrganizationPeersResponse() (response *DescribeOrganizationPeersResponse) {
	response = &DescribeOrganizationPeersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
