package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMySuccessApplies invokes the baas.DescribeMySuccessApplies API synchronously
// api document: https://help.aliyun.com/api/baas/describemysuccessapplies.html
func (client *Client) DescribeMySuccessApplies(request *DescribeMySuccessAppliesRequest) (response *DescribeMySuccessAppliesResponse, err error) {
	response = CreateDescribeMySuccessAppliesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMySuccessAppliesWithChan invokes the baas.DescribeMySuccessApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/describemysuccessapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMySuccessAppliesWithChan(request *DescribeMySuccessAppliesRequest) (<-chan *DescribeMySuccessAppliesResponse, <-chan error) {
	responseChan := make(chan *DescribeMySuccessAppliesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMySuccessApplies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMySuccessAppliesWithCallback invokes the baas.DescribeMySuccessApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/describemysuccessapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMySuccessAppliesWithCallback(request *DescribeMySuccessAppliesRequest, callback func(response *DescribeMySuccessAppliesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMySuccessAppliesResponse
		var err error
		defer close(result)
		response, err = client.DescribeMySuccessApplies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMySuccessAppliesRequest is the request struct for api DescribeMySuccessApplies
type DescribeMySuccessAppliesRequest struct {
	*requests.RpcRequest
}

// DescribeMySuccessAppliesResponse is the response struct for api DescribeMySuccessApplies
type DescribeMySuccessAppliesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeMySuccessAppliesRequest creates a request to invoke DescribeMySuccessApplies API
func CreateDescribeMySuccessAppliesRequest() (request *DescribeMySuccessAppliesRequest) {
	request = &DescribeMySuccessAppliesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeMySuccessApplies", "", "")
	return
}

// CreateDescribeMySuccessAppliesResponse creates a response to parse from DescribeMySuccessApplies response
func CreateDescribeMySuccessAppliesResponse() (response *DescribeMySuccessAppliesResponse) {
	response = &DescribeMySuccessAppliesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
