package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMix invokes the airec.DeleteMix API synchronously
// api document: https://help.aliyun.com/api/airec/deletemix.html
func (client *Client) DeleteMix(request *DeleteMixRequest) (response *DeleteMixResponse, err error) {
	response = CreateDeleteMixResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMixWithChan invokes the airec.DeleteMix API asynchronously
// api document: https://help.aliyun.com/api/airec/deletemix.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMixWithChan(request *DeleteMixRequest) (<-chan *DeleteMixResponse, <-chan error) {
	responseChan := make(chan *DeleteMixResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMix(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMixWithCallback invokes the airec.DeleteMix API asynchronously
// api document: https://help.aliyun.com/api/airec/deletemix.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMixWithCallback(request *DeleteMixRequest, callback func(response *DeleteMixResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMixResponse
		var err error
		defer close(result)
		response, err = client.DeleteMix(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMixRequest is the request struct for api DeleteMix
type DeleteMixRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"Name"`
}

// DeleteMixResponse is the response struct for api DeleteMix
type DeleteMixResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeleteMixRequest creates a request to invoke DeleteMix API
func CreateDeleteMixRequest() (request *DeleteMixRequest) {
	request = &DeleteMixRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DeleteMix", "/openapi/instances/[InstanceId]/mixes/[Name]", "airec", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteMixResponse creates a response to parse from DeleteMix response
func CreateDeleteMixResponse() (response *DeleteMixResponse) {
	response = &DeleteMixResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
