package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserSetting invokes the aegis.CreateUserSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/createusersetting.html
func (client *Client) CreateUserSetting(request *CreateUserSettingRequest) (response *CreateUserSettingResponse, err error) {
	response = CreateCreateUserSettingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserSettingWithChan invokes the aegis.CreateUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/createusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserSettingWithChan(request *CreateUserSettingRequest) (<-chan *CreateUserSettingResponse, <-chan error) {
	responseChan := make(chan *CreateUserSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserSettingWithCallback invokes the aegis.CreateUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/createusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserSettingWithCallback(request *CreateUserSettingRequest, callback func(response *CreateUserSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserSettingResponse
		var err error
		defer close(result)
		response, err = client.CreateUserSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserSettingRequest is the request struct for api CreateUserSetting
type CreateUserSettingRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FrequencyByDays requests.Integer `position:"Query" name:"FrequencyByDays"`
}

// CreateUserSettingResponse is the response struct for api CreateUserSetting
type CreateUserSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateUserSettingRequest creates a request to invoke CreateUserSetting API
func CreateCreateUserSettingRequest() (request *CreateUserSettingRequest) {
	request = &CreateUserSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CreateUserSetting", "vipaegis", "openAPI")
	return
}

// CreateCreateUserSettingResponse creates a response to parse from CreateUserSetting response
func CreateCreateUserSettingResponse() (response *CreateUserSettingResponse) {
	response = &CreateUserSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
