// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/analytics/admin/v1alpha/analytics_admin.proto

package adminpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request for a Data Access Record Report.
type RunAccessReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Data Access Report supports requesting at the property level or account
	// level. If requested at the account level, Data Access Reports include all
	// access for all properties under that account.
	//
	// To request at the property level, entity should be for example
	// 'properties/123' if "123" is your GA4 property ID. To request at the
	// account level, entity should be for example 'accounts/1234' if "1234" is
	// your GA4 Account ID.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The dimensions requested and displayed in the response. Requests are
	// allowed up to 9 dimensions.
	Dimensions []*AccessDimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested and displayed in the response. Requests are allowed
	// up to 10 metrics.
	Metrics []*AccessMetric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Date ranges of access records to read. If multiple date ranges are
	// requested, each response row will contain a zero based date range index. If
	// two date ranges overlap, the access records for the overlapping days is
	// included in the response rows for both date ranges. Requests are allowed up
	// to 2 date ranges.
	DateRanges []*AccessDateRange `protobuf:"bytes,4,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// Dimension filters let you restrict report response to specific
	// dimension values which match the filter. For example, filtering on access
	// records of a single user. To learn more, see [Fundamentals of Dimension
	// Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
	// for examples. Metrics cannot be used in this filter.
	DimensionFilter *AccessFilterExpression `protobuf:"bytes,5,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// Metric filters allow you to restrict report response to specific metric
	// values which match the filter. Metric filters are applied after aggregating
	// the report's rows, similar to SQL having-clause. Dimensions cannot be used
	// in this filter.
	MetricFilter *AccessFilterExpression `protobuf:"bytes,6,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// The row count of the start row. The first row is counted as row 0. If
	// offset is unspecified, it is treated as 0. If offset is zero, then this
	// method will return the first page of results with `limit` entries.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Offset int64 `protobuf:"varint,7,opt,name=offset,proto3" json:"offset,omitempty"`
	// The number of rows to return. If unspecified, 10,000 rows are returned. The
	// API returns a maximum of 100,000 rows per request, no matter how many you
	// ask for. `limit` must be positive.
	//
	// The API may return fewer rows than the requested `limit`, if there aren't
	// as many remaining rows as the `limit`. For instance, there are fewer than
	// 300 possible values for the dimension `country`, so when reporting on only
	// `country`, you can't get more than 300 rows, even if you set `limit` to a
	// higher value.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Limit int64 `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
	// This request's time zone if specified. If unspecified, the property's time
	// zone is used. The request's time zone is used to interpret the start & end
	// dates of the report.
	//
	// Formatted as strings from the IANA Time Zone database
	// (https://www.iana.org/time-zones); for example "America/New_York" or
	// "Asia/Tokyo".
	TimeZone string `protobuf:"bytes,9,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Specifies how rows are ordered in the response.
	OrderBys []*AccessOrderBy `protobuf:"bytes,10,rep,name=order_bys,json=orderBys,proto3" json:"order_bys,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [AccessQuota](#AccessQuota). For account-level
	// requests, this field must be false.
	ReturnEntityQuota bool `protobuf:"varint,11,opt,name=return_entity_quota,json=returnEntityQuota,proto3" json:"return_entity_quota,omitempty"`
	// Optional. Determines whether to include users who have never made an API
	// call in the response. If true, all users with access to the specified
	// property or account are included in the response, regardless of whether
	// they have made an API call or not. If false, only the users who have made
	// an API call will be included.
	IncludeAllUsers bool `protobuf:"varint,12,opt,name=include_all_users,json=includeAllUsers,proto3" json:"include_all_users,omitempty"`
	// Optional. Decides whether to return the users within user groups. This
	// field works only when include_all_users is set to true. If true, it will
	// return all users with access to the specified property or account.
	// If false, only the users with direct access will be returned.
	ExpandGroups bool `protobuf:"varint,13,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
}

func (x *RunAccessReportRequest) Reset() {
	*x = RunAccessReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunAccessReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunAccessReportRequest) ProtoMessage() {}

func (x *RunAccessReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunAccessReportRequest.ProtoReflect.Descriptor instead.
func (*RunAccessReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{0}
}

func (x *RunAccessReportRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *RunAccessReportRequest) GetDimensions() []*AccessDimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunAccessReportRequest) GetMetrics() []*AccessMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunAccessReportRequest) GetDateRanges() []*AccessDateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunAccessReportRequest) GetDimensionFilter() *AccessFilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunAccessReportRequest) GetMetricFilter() *AccessFilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunAccessReportRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *RunAccessReportRequest) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *RunAccessReportRequest) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *RunAccessReportRequest) GetOrderBys() []*AccessOrderBy {
	if x != nil {
		return x.OrderBys
	}
	return nil
}

func (x *RunAccessReportRequest) GetReturnEntityQuota() bool {
	if x != nil {
		return x.ReturnEntityQuota
	}
	return false
}

func (x *RunAccessReportRequest) GetIncludeAllUsers() bool {
	if x != nil {
		return x.IncludeAllUsers
	}
	return false
}

func (x *RunAccessReportRequest) GetExpandGroups() bool {
	if x != nil {
		return x.ExpandGroups
	}
	return false
}

// The customized Data Access Record Report response.
type RunAccessReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header for a column in the report that corresponds to a specific
	// dimension. The number of DimensionHeaders and ordering of DimensionHeaders
	// matches the dimensions present in rows.
	DimensionHeaders []*AccessDimensionHeader `protobuf:"bytes,1,rep,name=dimension_headers,json=dimensionHeaders,proto3" json:"dimension_headers,omitempty"`
	// The header for a column in the report that corresponds to a specific
	// metric. The number of MetricHeaders and ordering of MetricHeaders matches
	// the metrics present in rows.
	MetricHeaders []*AccessMetricHeader `protobuf:"bytes,2,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*AccessRow `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
	// The total number of rows in the query result. `rowCount` is independent of
	// the number of rows returned in the response, the `limit` request
	// parameter, and the `offset` request parameter. For example if a query
	// returns 175 rows and includes `limit` of 50 in the API request, the
	// response will contain `rowCount` of 175 but only 50 rows.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	RowCount int32 `protobuf:"varint,4,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// The quota state for this Analytics property including this request. This
	// field doesn't work with account-level requests.
	Quota *AccessQuota `protobuf:"bytes,5,opt,name=quota,proto3" json:"quota,omitempty"`
}

func (x *RunAccessReportResponse) Reset() {
	*x = RunAccessReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunAccessReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunAccessReportResponse) ProtoMessage() {}

func (x *RunAccessReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunAccessReportResponse.ProtoReflect.Descriptor instead.
func (*RunAccessReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{1}
}

func (x *RunAccessReportResponse) GetDimensionHeaders() []*AccessDimensionHeader {
	if x != nil {
		return x.DimensionHeaders
	}
	return nil
}

func (x *RunAccessReportResponse) GetMetricHeaders() []*AccessMetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunAccessReportResponse) GetRows() []*AccessRow {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunAccessReportResponse) GetRowCount() int32 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *RunAccessReportResponse) GetQuota() *AccessQuota {
	if x != nil {
		return x.Quota
	}
	return nil
}

// Request message for GetAccount RPC.
type GetAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the account to lookup.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccountRequest) Reset() {
	*x = GetAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountRequest) ProtoMessage() {}

func (x *GetAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountRequest.ProtoReflect.Descriptor instead.
func (*GetAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{2}
}

func (x *GetAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccounts RPC.
type ListAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccounts` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccounts` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Accounts in the
	// results. Accounts can be inspected to determine whether they are deleted or
	// not.
	ShowDeleted bool `protobuf:"varint,3,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListAccountsRequest) Reset() {
	*x = ListAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsRequest) ProtoMessage() {}

func (x *ListAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{3}
}

func (x *ListAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAccountsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Request message for ListAccounts RPC.
type ListAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountsResponse) Reset() {
	*x = ListAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsResponse) ProtoMessage() {}

func (x *ListAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{4}
}

func (x *ListAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteAccount RPC.
type DeleteAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Account to soft-delete.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccountRequest) Reset() {
	*x = DeleteAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccountRequest) ProtoMessage() {}

func (x *DeleteAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccountRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAccount RPC.
type UpdateAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to update.
	// The account's `name` field is used to identify the account.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (for example, "field_to_update"). Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccountRequest) Reset() {
	*x = UpdateAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountRequest) ProtoMessage() {}

func (x *UpdateAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateAccountRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *UpdateAccountRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account to create.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Redirect URI where the user will be sent after accepting Terms of Service.
	// Must be configured in Cloud Console as a Redirect URI.
	RedirectUri string `protobuf:"bytes,2,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *ProvisionAccountTicketRequest) Reset() {
	*x = ProvisionAccountTicketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketRequest) ProtoMessage() {}

func (x *ProvisionAccountTicketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketRequest.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{7}
}

func (x *ProvisionAccountTicketRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *ProvisionAccountTicketRequest) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Response message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The param to be passed in the ToS link.
	AccountTicketId string `protobuf:"bytes,1,opt,name=account_ticket_id,json=accountTicketId,proto3" json:"account_ticket_id,omitempty"`
}

func (x *ProvisionAccountTicketResponse) Reset() {
	*x = ProvisionAccountTicketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketResponse) ProtoMessage() {}

func (x *ProvisionAccountTicketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketResponse.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{8}
}

func (x *ProvisionAccountTicketResponse) GetAccountTicketId() string {
	if x != nil {
		return x.AccountTicketId
	}
	return ""
}

// Request message for GetProperty RPC.
type GetPropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the property to lookup.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPropertyRequest) Reset() {
	*x = GetPropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPropertyRequest) ProtoMessage() {}

func (x *GetPropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPropertyRequest.ProtoReflect.Descriptor instead.
func (*GetPropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{9}
}

func (x *GetPropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListProperties RPC.
type ListPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An expression for filtering the results of the request.
	// Fields eligible for filtering are:
	// `parent:`(The resource name of the parent account/property) or
	// `ancestor:`(The resource name of the parent account) or
	// `firebase_project:`(The id or number of the linked firebase project).
	// Some examples of filters:
	//
	// ```
	// | Filter                      | Description                               |
	// |-----------------------------|-------------------------------------------|
	// | parent:accounts/123         | The account with account id: 123.       |
	// | parent:properties/123       | The property with property id: 123.       |
	// | ancestor:accounts/123       | The account with account id: 123.         |
	// | firebase_project:project-id | The firebase project with id: project-id. |
	// | firebase_project:123        | The firebase project with number: 123.    |
	// ```
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListProperties` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Properties in the
	// results. Properties can be inspected to determine whether they are deleted
	// or not.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListPropertiesRequest) Reset() {
	*x = ListPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesRequest) ProtoMessage() {}

func (x *ListPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesRequest.ProtoReflect.Descriptor instead.
func (*ListPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{10}
}

func (x *ListPropertiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPropertiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPropertiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPropertiesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListProperties RPC.
type ListPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPropertiesResponse) Reset() {
	*x = ListPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesResponse) ProtoMessage() {}

func (x *ListPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesResponse.ProtoReflect.Descriptor instead.
func (*ListPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{11}
}

func (x *ListPropertiesResponse) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ListPropertiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateProperty RPC.
type UpdatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to update.
	// The property's `name` field is used to identify the property to be
	// updated.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePropertyRequest) Reset() {
	*x = UpdatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePropertyRequest) ProtoMessage() {}

func (x *UpdatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePropertyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{12}
}

func (x *UpdatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *UpdatePropertyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateProperty RPC.
type CreatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to create.
	// Note: the supplied property must specify its parent.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *CreatePropertyRequest) Reset() {
	*x = CreatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePropertyRequest) ProtoMessage() {}

func (x *CreatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePropertyRequest.ProtoReflect.Descriptor instead.
func (*CreatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{13}
}

func (x *CreatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

// Request message for DeleteProperty RPC.
type DeletePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Property to soft-delete.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePropertyRequest) Reset() {
	*x = DeletePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePropertyRequest) ProtoMessage() {}

func (x *DeletePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePropertyRequest.ProtoReflect.Descriptor instead.
func (*DeletePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{14}
}

func (x *DeletePropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateFirebaseLink RPC
type CreateFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Firebase link to create.
	FirebaseLink *FirebaseLink `protobuf:"bytes,2,opt,name=firebase_link,json=firebaseLink,proto3" json:"firebase_link,omitempty"`
}

func (x *CreateFirebaseLinkRequest) Reset() {
	*x = CreateFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFirebaseLinkRequest) ProtoMessage() {}

func (x *CreateFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{15}
}

func (x *CreateFirebaseLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFirebaseLinkRequest) GetFirebaseLink() *FirebaseLink {
	if x != nil {
		return x.FirebaseLink
	}
	return nil
}

// Request message for DeleteFirebaseLink RPC
type DeleteFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
	// Example: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFirebaseLinkRequest) Reset() {
	*x = DeleteFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFirebaseLinkRequest) ProtoMessage() {}

func (x *DeleteFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteFirebaseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListFirebaseLinks RPC
type ListFirebaseLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListFirebaseLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListFirebaseLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFirebaseLinksRequest) Reset() {
	*x = ListFirebaseLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksRequest) ProtoMessage() {}

func (x *ListFirebaseLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksRequest.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{17}
}

func (x *ListFirebaseLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFirebaseLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFirebaseLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListFirebaseLinks RPC
type ListFirebaseLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of FirebaseLinks. This will have at most one value.
	FirebaseLinks []*FirebaseLink `protobuf:"bytes,1,rep,name=firebase_links,json=firebaseLinks,proto3" json:"firebase_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	// Currently, Google Analytics supports only one FirebaseLink per property,
	// so this will never be populated.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFirebaseLinksResponse) Reset() {
	*x = ListFirebaseLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksResponse) ProtoMessage() {}

func (x *ListFirebaseLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksResponse.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{18}
}

func (x *ListFirebaseLinksResponse) GetFirebaseLinks() []*FirebaseLink {
	if x != nil {
		return x.FirebaseLinks
	}
	return nil
}

func (x *ListFirebaseLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetGlobalSiteTag RPC.
type GetGlobalSiteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the site tag to lookup.
	// Note that site tags are singletons and do not have unique IDs.
	// Format: properties/{property_id}/dataStreams/{stream_id}/globalSiteTag
	// Example: "properties/123/dataStreams/456/globalSiteTag"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGlobalSiteTagRequest) Reset() {
	*x = GetGlobalSiteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGlobalSiteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGlobalSiteTagRequest) ProtoMessage() {}

func (x *GetGlobalSiteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGlobalSiteTagRequest.ProtoReflect.Descriptor instead.
func (*GetGlobalSiteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{19}
}

func (x *GetGlobalSiteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateGoogleAdsLink RPC
type CreateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The GoogleAdsLink to create.
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,2,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
}

func (x *CreateGoogleAdsLinkRequest) Reset() {
	*x = CreateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *CreateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{20}
}

func (x *CreateGoogleAdsLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

// Request message for UpdateGoogleAdsLink RPC
type UpdateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GoogleAdsLink to update
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,1,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleAdsLinkRequest) Reset() {
	*x = UpdateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *UpdateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

func (x *UpdateGoogleAdsLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteGoogleAdsLink RPC.
type DeleteGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/googleAdsLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGoogleAdsLinkRequest) Reset() {
	*x = DeleteGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGoogleAdsLinkRequest) ProtoMessage() {}

func (x *DeleteGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{22}
}

func (x *DeleteGoogleAdsLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListGoogleAdsLinks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGoogleAdsLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGoogleAdsLinksRequest) Reset() {
	*x = ListGoogleAdsLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksRequest) ProtoMessage() {}

func (x *ListGoogleAdsLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksRequest.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{23}
}

func (x *ListGoogleAdsLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGoogleAdsLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGoogleAdsLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAdsLink `protobuf:"bytes,1,rep,name=google_ads_links,json=googleAdsLinks,proto3" json:"google_ads_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGoogleAdsLinksResponse) Reset() {
	*x = ListGoogleAdsLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksResponse) ProtoMessage() {}

func (x *ListGoogleAdsLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksResponse.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{24}
}

func (x *ListGoogleAdsLinksResponse) GetGoogleAdsLinks() []*GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLinks
	}
	return nil
}

func (x *ListGoogleAdsLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataSharingSettings RPC.
type GetDataSharingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format: accounts/{account}/dataSharingSettings
	// Example: "accounts/1000/dataSharingSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSharingSettingsRequest) Reset() {
	*x = GetDataSharingSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataSharingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSharingSettingsRequest) ProtoMessage() {}

func (x *GetDataSharingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSharingSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataSharingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{25}
}

func (x *GetDataSharingSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccountSummaries RPC.
type ListAccountSummariesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of AccountSummary resources to return. The service may
	// return fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccountSummaries` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccountSummaries`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccountSummariesRequest) Reset() {
	*x = ListAccountSummariesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesRequest) ProtoMessage() {}

func (x *ListAccountSummariesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesRequest.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{26}
}

func (x *ListAccountSummariesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountSummariesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAccountSummaries RPC.
type ListAccountSummariesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Account summaries of all accounts the caller has access to.
	AccountSummaries []*AccountSummary `protobuf:"bytes,1,rep,name=account_summaries,json=accountSummaries,proto3" json:"account_summaries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountSummariesResponse) Reset() {
	*x = ListAccountSummariesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesResponse) ProtoMessage() {}

func (x *ListAccountSummariesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesResponse.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{27}
}

func (x *ListAccountSummariesResponse) GetAccountSummaries() []*AccountSummary {
	if x != nil {
		return x.AccountSummaries
	}
	return nil
}

func (x *ListAccountSummariesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AcknowledgeUserDataCollection RPC.
type AcknowledgeUserDataCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property for which to acknowledge user data collection.
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. An acknowledgement that the caller of this method understands the
	// terms of user data collection.
	//
	// This field must contain the exact value:
	// "I acknowledge that I have the necessary privacy disclosures and rights
	// from my end users for the collection and processing of their data,
	// including the association of such data with the visitation information
	// Google Analytics collects from my site and/or app property."
	Acknowledgement string `protobuf:"bytes,2,opt,name=acknowledgement,proto3" json:"acknowledgement,omitempty"`
}

func (x *AcknowledgeUserDataCollectionRequest) Reset() {
	*x = AcknowledgeUserDataCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcknowledgeUserDataCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeUserDataCollectionRequest) ProtoMessage() {}

func (x *AcknowledgeUserDataCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeUserDataCollectionRequest.ProtoReflect.Descriptor instead.
func (*AcknowledgeUserDataCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{28}
}

func (x *AcknowledgeUserDataCollectionRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *AcknowledgeUserDataCollectionRequest) GetAcknowledgement() string {
	if x != nil {
		return x.Acknowledgement
	}
	return ""
}

// Response message for AcknowledgeUserDataCollection RPC.
type AcknowledgeUserDataCollectionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AcknowledgeUserDataCollectionResponse) Reset() {
	*x = AcknowledgeUserDataCollectionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcknowledgeUserDataCollectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeUserDataCollectionResponse) ProtoMessage() {}

func (x *AcknowledgeUserDataCollectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeUserDataCollectionResponse.ProtoReflect.Descriptor instead.
func (*AcknowledgeUserDataCollectionResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{29}
}

// Request message for SearchChangeHistoryEvents RPC.
type SearchChangeHistoryEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account resource for which to return change history
	// resources. Format: accounts/{account} Example: "accounts/100"
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Resource name for a child property. If set, only return changes
	// made to this property or its child resources.
	// Format: properties/{propertyId}
	// Example: "properties/100"
	Property string `protobuf:"bytes,2,opt,name=property,proto3" json:"property,omitempty"`
	// Optional. If set, only return changes if they are for a resource that
	// matches at least one of these types.
	ResourceType []ChangeHistoryResourceType `protobuf:"varint,3,rep,packed,name=resource_type,json=resourceType,proto3,enum=google.analytics.admin.v1alpha.ChangeHistoryResourceType" json:"resource_type,omitempty"`
	// Optional. If set, only return changes that match one or more of these types
	// of actions.
	Action []ActionType `protobuf:"varint,4,rep,packed,name=action,proto3,enum=google.analytics.admin.v1alpha.ActionType" json:"action,omitempty"`
	// Optional. If set, only return changes if they are made by a user in this
	// list.
	ActorEmail []string `protobuf:"bytes,5,rep,name=actor_email,json=actorEmail,proto3" json:"actor_email,omitempty"`
	// Optional. If set, only return changes made after this time (inclusive).
	EarliestChangeTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=earliest_change_time,json=earliestChangeTime,proto3" json:"earliest_change_time,omitempty"`
	// Optional. If set, only return changes made before this time (inclusive).
	LatestChangeTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=latest_change_time,json=latestChangeTime,proto3" json:"latest_change_time,omitempty"`
	// Optional. The maximum number of ChangeHistoryEvent items to return.
	// The service may return fewer than this value, even if there are additional
	// pages. If unspecified, at most 50 items will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `SearchChangeHistoryEvents` call. Provide this to retrieve the subsequent
	// page. When paginating, all other parameters provided to
	// `SearchChangeHistoryEvents` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,9,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsRequest) Reset() {
	*x = SearchChangeHistoryEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsRequest) ProtoMessage() {}

func (x *SearchChangeHistoryEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsRequest.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{30}
}

func (x *SearchChangeHistoryEventsRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetResourceType() []ChangeHistoryResourceType {
	if x != nil {
		return x.ResourceType
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetAction() []ActionType {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetActorEmail() []string {
	if x != nil {
		return x.ActorEmail
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetEarliestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetLatestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchChangeHistoryEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SearchAccounts RPC.
type SearchChangeHistoryEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	ChangeHistoryEvents []*ChangeHistoryEvent `protobuf:"bytes,1,rep,name=change_history_events,json=changeHistoryEvents,proto3" json:"change_history_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsResponse) Reset() {
	*x = SearchChangeHistoryEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsResponse) ProtoMessage() {}

func (x *SearchChangeHistoryEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsResponse.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{31}
}

func (x *SearchChangeHistoryEventsResponse) GetChangeHistoryEvents() []*ChangeHistoryEvent {
	if x != nil {
		return x.ChangeHistoryEvents
	}
	return nil
}

func (x *SearchChangeHistoryEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetMeasurementProtocolSecret RPC.
type GetMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the measurement protocol secret to lookup.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMeasurementProtocolSecretRequest) Reset() {
	*x = GetMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *GetMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*GetMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{32}
}

func (x *GetMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateMeasurementProtocolSecret RPC
type CreateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this secret will be created.
	// Format: properties/{property}/dataStreams/{dataStream}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The measurement protocol secret to create.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,2,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
}

func (x *CreateMeasurementProtocolSecretRequest) Reset() {
	*x = CreateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *CreateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*CreateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{33}
}

func (x *CreateMeasurementProtocolSecretRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

// Request message for DeleteMeasurementProtocolSecret RPC
type DeleteMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MeasurementProtocolSecret to delete.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMeasurementProtocolSecretRequest) Reset() {
	*x = DeleteMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *DeleteMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*DeleteMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateMeasurementProtocolSecret RPC
type UpdateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The measurement protocol secret to update.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,1,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMeasurementProtocolSecretRequest) Reset() {
	*x = UpdateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *UpdateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*UpdateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

func (x *UpdateMeasurementProtocolSecretRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent stream.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 10 resources will be returned.
	// The maximum value is 10. Higher values will be coerced to the maximum.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMeasurementProtocolSecrets`
	// call. Provide this to retrieve the subsequent page. When paginating, all
	// other parameters provided to `ListMeasurementProtocolSecrets` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsRequest) Reset() {
	*x = ListMeasurementProtocolSecretsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsRequest) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsRequest.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{36}
}

func (x *ListMeasurementProtocolSecretsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of secrets for the parent stream specified in the request.
	MeasurementProtocolSecrets []*MeasurementProtocolSecret `protobuf:"bytes,1,rep,name=measurement_protocol_secrets,json=measurementProtocolSecrets,proto3" json:"measurement_protocol_secrets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsResponse) Reset() {
	*x = ListMeasurementProtocolSecretsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsResponse) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsResponse.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{37}
}

func (x *ListMeasurementProtocolSecretsResponse) GetMeasurementProtocolSecrets() []*MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecrets
	}
	return nil
}

func (x *ListMeasurementProtocolSecretsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetSKAdNetworkConversionValueSchema RPC.
type GetSKAdNetworkConversionValueSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of SKAdNetwork conversion value schema to look
	// up. Format:
	// properties/{property}/dataStreams/{dataStream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSKAdNetworkConversionValueSchemaRequest) Reset() {
	*x = GetSKAdNetworkConversionValueSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSKAdNetworkConversionValueSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSKAdNetworkConversionValueSchemaRequest) ProtoMessage() {}

func (x *GetSKAdNetworkConversionValueSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSKAdNetworkConversionValueSchemaRequest.ProtoReflect.Descriptor instead.
func (*GetSKAdNetworkConversionValueSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{38}
}

func (x *GetSKAdNetworkConversionValueSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateSKAdNetworkConversionValueSchema RPC.
type CreateSKAdNetworkConversionValueSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this schema will be created.
	// Format: properties/{property}/dataStreams/{dataStream}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. SKAdNetwork conversion value schema to create.
	SkadnetworkConversionValueSchema *SKAdNetworkConversionValueSchema `protobuf:"bytes,2,opt,name=skadnetwork_conversion_value_schema,json=skadnetworkConversionValueSchema,proto3" json:"skadnetwork_conversion_value_schema,omitempty"`
}

func (x *CreateSKAdNetworkConversionValueSchemaRequest) Reset() {
	*x = CreateSKAdNetworkConversionValueSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSKAdNetworkConversionValueSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSKAdNetworkConversionValueSchemaRequest) ProtoMessage() {}

func (x *CreateSKAdNetworkConversionValueSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSKAdNetworkConversionValueSchemaRequest.ProtoReflect.Descriptor instead.
func (*CreateSKAdNetworkConversionValueSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{39}
}

func (x *CreateSKAdNetworkConversionValueSchemaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSKAdNetworkConversionValueSchemaRequest) GetSkadnetworkConversionValueSchema() *SKAdNetworkConversionValueSchema {
	if x != nil {
		return x.SkadnetworkConversionValueSchema
	}
	return nil
}

// Request message for DeleteSKAdNetworkConversionValueSchema RPC.
type DeleteSKAdNetworkConversionValueSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SKAdNetworkConversionValueSchema to delete.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSKAdNetworkConversionValueSchemaRequest) Reset() {
	*x = DeleteSKAdNetworkConversionValueSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSKAdNetworkConversionValueSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSKAdNetworkConversionValueSchemaRequest) ProtoMessage() {}

func (x *DeleteSKAdNetworkConversionValueSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSKAdNetworkConversionValueSchemaRequest.ProtoReflect.Descriptor instead.
func (*DeleteSKAdNetworkConversionValueSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{40}
}

func (x *DeleteSKAdNetworkConversionValueSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateSKAdNetworkConversionValueSchema RPC.
type UpdateSKAdNetworkConversionValueSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. SKAdNetwork conversion value schema to update.
	SkadnetworkConversionValueSchema *SKAdNetworkConversionValueSchema `protobuf:"bytes,1,opt,name=skadnetwork_conversion_value_schema,json=skadnetworkConversionValueSchema,proto3" json:"skadnetwork_conversion_value_schema,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSKAdNetworkConversionValueSchemaRequest) Reset() {
	*x = UpdateSKAdNetworkConversionValueSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSKAdNetworkConversionValueSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSKAdNetworkConversionValueSchemaRequest) ProtoMessage() {}

func (x *UpdateSKAdNetworkConversionValueSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSKAdNetworkConversionValueSchemaRequest.ProtoReflect.Descriptor instead.
func (*UpdateSKAdNetworkConversionValueSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{41}
}

func (x *UpdateSKAdNetworkConversionValueSchemaRequest) GetSkadnetworkConversionValueSchema() *SKAdNetworkConversionValueSchema {
	if x != nil {
		return x.SkadnetworkConversionValueSchema
	}
	return nil
}

func (x *UpdateSKAdNetworkConversionValueSchemaRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListSKAdNetworkConversionValueSchemas RPC
type ListSKAdNetworkConversionValueSchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DataStream resource to list schemas for.
	// Format:
	// properties/{property_id}/dataStreams/{dataStream}
	// Example: properties/1234/dataStreams/5678
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// `ListSKAdNetworkConversionValueSchemas` call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// `ListSKAdNetworkConversionValueSchema` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSKAdNetworkConversionValueSchemasRequest) Reset() {
	*x = ListSKAdNetworkConversionValueSchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSKAdNetworkConversionValueSchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSKAdNetworkConversionValueSchemasRequest) ProtoMessage() {}

func (x *ListSKAdNetworkConversionValueSchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSKAdNetworkConversionValueSchemasRequest.ProtoReflect.Descriptor instead.
func (*ListSKAdNetworkConversionValueSchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{42}
}

func (x *ListSKAdNetworkConversionValueSchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSKAdNetworkConversionValueSchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSKAdNetworkConversionValueSchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListSKAdNetworkConversionValueSchemas RPC
type ListSKAdNetworkConversionValueSchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of SKAdNetworkConversionValueSchemas. This will have at most one
	// value.
	SkadnetworkConversionValueSchemas []*SKAdNetworkConversionValueSchema `protobuf:"bytes,1,rep,name=skadnetwork_conversion_value_schemas,json=skadnetworkConversionValueSchemas,proto3" json:"skadnetwork_conversion_value_schemas,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	// Currently, Google Analytics supports only one
	// SKAdNetworkConversionValueSchema per dataStream, so this will never be
	// populated.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSKAdNetworkConversionValueSchemasResponse) Reset() {
	*x = ListSKAdNetworkConversionValueSchemasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSKAdNetworkConversionValueSchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSKAdNetworkConversionValueSchemasResponse) ProtoMessage() {}

func (x *ListSKAdNetworkConversionValueSchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSKAdNetworkConversionValueSchemasResponse.ProtoReflect.Descriptor instead.
func (*ListSKAdNetworkConversionValueSchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{43}
}

func (x *ListSKAdNetworkConversionValueSchemasResponse) GetSkadnetworkConversionValueSchemas() []*SKAdNetworkConversionValueSchema {
	if x != nil {
		return x.SkadnetworkConversionValueSchemas
	}
	return nil
}

func (x *ListSKAdNetworkConversionValueSchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetGoogleSignalsSettings RPC
type GetGoogleSignalsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the google signals settings to retrieve.
	// Format: properties/{property}/googleSignalsSettings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGoogleSignalsSettingsRequest) Reset() {
	*x = GetGoogleSignalsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGoogleSignalsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoogleSignalsSettingsRequest) ProtoMessage() {}

func (x *GetGoogleSignalsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGoogleSignalsSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetGoogleSignalsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{44}
}

func (x *GetGoogleSignalsSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateGoogleSignalsSettings RPC
type UpdateGoogleSignalsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	GoogleSignalsSettings *GoogleSignalsSettings `protobuf:"bytes,1,opt,name=google_signals_settings,json=googleSignalsSettings,proto3" json:"google_signals_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleSignalsSettingsRequest) Reset() {
	*x = UpdateGoogleSignalsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleSignalsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleSignalsSettingsRequest) ProtoMessage() {}

func (x *UpdateGoogleSignalsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleSignalsSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleSignalsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{45}
}

func (x *UpdateGoogleSignalsSettingsRequest) GetGoogleSignalsSettings() *GoogleSignalsSettings {
	if x != nil {
		return x.GoogleSignalsSettings
	}
	return nil
}

func (x *UpdateGoogleSignalsSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateConversionEvent RPC
type CreateConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversion event to create.
	ConversionEvent *ConversionEvent `protobuf:"bytes,1,opt,name=conversion_event,json=conversionEvent,proto3" json:"conversion_event,omitempty"`
	// Required. The resource name of the parent property where this conversion
	// event will be created. Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateConversionEventRequest) Reset() {
	*x = CreateConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversionEventRequest) ProtoMessage() {}

func (x *CreateConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversionEventRequest.ProtoReflect.Descriptor instead.
func (*CreateConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{46}
}

func (x *CreateConversionEventRequest) GetConversionEvent() *ConversionEvent {
	if x != nil {
		return x.ConversionEvent
	}
	return nil
}

func (x *CreateConversionEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for UpdateConversionEvent RPC
type UpdateConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversion event to update.
	// The `name` field is used to identify the settings to be updated.
	ConversionEvent *ConversionEvent `protobuf:"bytes,1,opt,name=conversion_event,json=conversionEvent,proto3" json:"conversion_event,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConversionEventRequest) Reset() {
	*x = UpdateConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversionEventRequest) ProtoMessage() {}

func (x *UpdateConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversionEventRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateConversionEventRequest) GetConversionEvent() *ConversionEvent {
	if x != nil {
		return x.ConversionEvent
	}
	return nil
}

func (x *UpdateConversionEventRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetConversionEvent RPC
type GetConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to retrieve.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversionEventRequest) Reset() {
	*x = GetConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversionEventRequest) ProtoMessage() {}

func (x *GetConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversionEventRequest.ProtoReflect.Descriptor instead.
func (*GetConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{48}
}

func (x *GetConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteConversionEvent RPC
type DeleteConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to delete.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversionEventRequest) Reset() {
	*x = DeleteConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversionEventRequest) ProtoMessage() {}

func (x *DeleteConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversionEventRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{49}
}

func (x *DeleteConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListConversionEvents RPC
type ListConversionEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent property.
	// Example: 'properties/123'
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListConversionEvents` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListConversionEvents`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversionEventsRequest) Reset() {
	*x = ListConversionEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsRequest) ProtoMessage() {}

func (x *ListConversionEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsRequest.ProtoReflect.Descriptor instead.
func (*ListConversionEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{50}
}

func (x *ListConversionEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversionEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversionEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListConversionEvents RPC.
type ListConversionEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested conversion events
	ConversionEvents []*ConversionEvent `protobuf:"bytes,1,rep,name=conversion_events,json=conversionEvents,proto3" json:"conversion_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversionEventsResponse) Reset() {
	*x = ListConversionEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsResponse) ProtoMessage() {}

func (x *ListConversionEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsResponse.ProtoReflect.Descriptor instead.
func (*ListConversionEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{51}
}

func (x *ListConversionEventsResponse) GetConversionEvents() []*ConversionEvent {
	if x != nil {
		return x.ConversionEvents
	}
	return nil
}

func (x *ListConversionEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDisplayVideo360AdvertiserLink RPC.
type GetDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLink to get.
	// Example format: properties/1234/displayVideo360AdvertiserLink/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = GetDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *GetDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*GetDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{52}
}

func (x *GetDisplayVideo360AdvertiserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDisplayVideo360AdvertiserLinks RPC.
type ListDisplayVideo360AdvertiserLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDisplayVideo360AdvertiserLinks`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDisplayVideo360AdvertiserLinks` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) Reset() {
	*x = ListDisplayVideo360AdvertiserLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinksRequest) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinksRequest.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{53}
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDisplayVideo360AdvertiserLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDisplayVideo360AdvertiserLinks RPC.
type ListDisplayVideo360AdvertiserLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DisplayVideo360AdvertiserLinks.
	DisplayVideo_360AdvertiserLinks []*DisplayVideo360AdvertiserLink `protobuf:"bytes,1,rep,name=display_video_360_advertiser_links,json=displayVideo360AdvertiserLinks,proto3" json:"display_video_360_advertiser_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) Reset() {
	*x = ListDisplayVideo360AdvertiserLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinksResponse) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinksResponse.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{54}
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) GetDisplayVideo_360AdvertiserLinks() []*DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinks
	}
	return nil
}

func (x *ListDisplayVideo360AdvertiserLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateDisplayVideo360AdvertiserLink RPC.
type CreateDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DisplayVideo360AdvertiserLink to create.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,2,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = CreateDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{55}
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisplayVideo360AdvertiserLinkRequest) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

// Request message for DeleteDisplayVideo360AdvertiserLink RPC.
type DeleteDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLink to delete.
	// Example format: properties/1234/displayVideo360AdvertiserLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = DeleteDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{56}
}

func (x *DeleteDisplayVideo360AdvertiserLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDisplayVideo360AdvertiserLink RPC.
type UpdateDisplayVideo360AdvertiserLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DisplayVideo360AdvertiserLink to update
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,1,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated. To replace the entire entity, use one path with the string "*" to
	// match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) Reset() {
	*x = UpdateDisplayVideo360AdvertiserLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDisplayVideo360AdvertiserLinkRequest) ProtoMessage() {}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDisplayVideo360AdvertiserLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateDisplayVideo360AdvertiserLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{57}
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

func (x *UpdateDisplayVideo360AdvertiserLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDisplayVideo360AdvertiserLinkProposal RPC.
type GetDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to get.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = GetDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*GetDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{58}
}

func (x *GetDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDisplayVideo360AdvertiserLinkProposals RPC.
type ListDisplayVideo360AdvertiserLinkProposalsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// `ListDisplayVideo360AdvertiserLinkProposals` call. Provide this to retrieve
	// the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDisplayVideo360AdvertiserLinkProposals` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) Reset() {
	*x = ListDisplayVideo360AdvertiserLinkProposalsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinkProposalsRequest) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinkProposalsRequest.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinkProposalsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{59}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDisplayVideo360AdvertiserLinkProposals RPC.
type ListDisplayVideo360AdvertiserLinkProposalsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DisplayVideo360AdvertiserLinkProposals.
	DisplayVideo_360AdvertiserLinkProposals []*DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,1,rep,name=display_video_360_advertiser_link_proposals,json=displayVideo360AdvertiserLinkProposals,proto3" json:"display_video_360_advertiser_link_proposals,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) Reset() {
	*x = ListDisplayVideo360AdvertiserLinkProposalsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDisplayVideo360AdvertiserLinkProposalsResponse) ProtoMessage() {}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDisplayVideo360AdvertiserLinkProposalsResponse.ProtoReflect.Descriptor instead.
func (*ListDisplayVideo360AdvertiserLinkProposalsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{60}
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) GetDisplayVideo_360AdvertiserLinkProposals() []*DisplayVideo360AdvertiserLinkProposal {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinkProposals
	}
	return nil
}

func (x *ListDisplayVideo360AdvertiserLinkProposalsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateDisplayVideo360AdvertiserLinkProposal RPC.
type CreateDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DisplayVideo360AdvertiserLinkProposal to create.
	DisplayVideo_360AdvertiserLinkProposal *DisplayVideo360AdvertiserLinkProposal `protobuf:"bytes,2,opt,name=display_video_360_advertiser_link_proposal,json=displayVideo360AdvertiserLinkProposal,proto3" json:"display_video_360_advertiser_link_proposal,omitempty"`
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = CreateDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*CreateDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{61}
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDisplayVideo360AdvertiserLinkProposalRequest) GetDisplayVideo_360AdvertiserLinkProposal() *DisplayVideo360AdvertiserLinkProposal {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLinkProposal
	}
	return nil
}

// Request message for DeleteDisplayVideo360AdvertiserLinkProposal RPC.
type DeleteDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = DeleteDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*DeleteDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{62}
}

func (x *DeleteDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type ApproveDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = ApproveDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*ApproveDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{63}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type ApproveDisplayVideo360AdvertiserLinkProposalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DisplayVideo360AdvertiserLink created as a result of approving the
	// proposal.
	DisplayVideo_360AdvertiserLink *DisplayVideo360AdvertiserLink `protobuf:"bytes,1,opt,name=display_video_360_advertiser_link,json=displayVideo360AdvertiserLink,proto3" json:"display_video_360_advertiser_link,omitempty"`
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) Reset() {
	*x = ApproveDisplayVideo360AdvertiserLinkProposalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDisplayVideo360AdvertiserLinkProposalResponse) ProtoMessage() {}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDisplayVideo360AdvertiserLinkProposalResponse.ProtoReflect.Descriptor instead.
func (*ApproveDisplayVideo360AdvertiserLinkProposalResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{64}
}

func (x *ApproveDisplayVideo360AdvertiserLinkProposalResponse) GetDisplayVideo_360AdvertiserLink() *DisplayVideo360AdvertiserLink {
	if x != nil {
		return x.DisplayVideo_360AdvertiserLink
	}
	return nil
}

// Request message for CancelDisplayVideo360AdvertiserLinkProposal RPC.
type CancelDisplayVideo360AdvertiserLinkProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel.
	// Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) Reset() {
	*x = CancelDisplayVideo360AdvertiserLinkProposalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDisplayVideo360AdvertiserLinkProposalRequest) ProtoMessage() {}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDisplayVideo360AdvertiserLinkProposalRequest.ProtoReflect.Descriptor instead.
func (*CancelDisplayVideo360AdvertiserLinkProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{65}
}

func (x *CancelDisplayVideo360AdvertiserLinkProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetSearchAds360Link RPC.
type GetSearchAds360LinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SearchAds360Link to get.
	// Example format: properties/1234/SearchAds360Link/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSearchAds360LinkRequest) Reset() {
	*x = GetSearchAds360LinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSearchAds360LinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSearchAds360LinkRequest) ProtoMessage() {}

func (x *GetSearchAds360LinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSearchAds360LinkRequest.ProtoReflect.Descriptor instead.
func (*GetSearchAds360LinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{66}
}

func (x *GetSearchAds360LinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListSearchAds360Links RPC.
type ListSearchAds360LinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSearchAds360Links`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListSearchAds360Links` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSearchAds360LinksRequest) Reset() {
	*x = ListSearchAds360LinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchAds360LinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchAds360LinksRequest) ProtoMessage() {}

func (x *ListSearchAds360LinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchAds360LinksRequest.ProtoReflect.Descriptor instead.
func (*ListSearchAds360LinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{67}
}

func (x *ListSearchAds360LinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSearchAds360LinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSearchAds360LinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListSearchAds360Links RPC.
type ListSearchAds360LinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of SearchAds360Links.
	SearchAds_360Links []*SearchAds360Link `protobuf:"bytes,1,rep,name=search_ads_360_links,json=searchAds360Links,proto3" json:"search_ads_360_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSearchAds360LinksResponse) Reset() {
	*x = ListSearchAds360LinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchAds360LinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchAds360LinksResponse) ProtoMessage() {}

func (x *ListSearchAds360LinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchAds360LinksResponse.ProtoReflect.Descriptor instead.
func (*ListSearchAds360LinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{68}
}

func (x *ListSearchAds360LinksResponse) GetSearchAds_360Links() []*SearchAds360Link {
	if x != nil {
		return x.SearchAds_360Links
	}
	return nil
}

func (x *ListSearchAds360LinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateSearchAds360Link RPC.
type CreateSearchAds360LinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SearchAds360Link to create.
	SearchAds_360Link *SearchAds360Link `protobuf:"bytes,2,opt,name=search_ads_360_link,json=searchAds360Link,proto3" json:"search_ads_360_link,omitempty"`
}

func (x *CreateSearchAds360LinkRequest) Reset() {
	*x = CreateSearchAds360LinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSearchAds360LinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSearchAds360LinkRequest) ProtoMessage() {}

func (x *CreateSearchAds360LinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSearchAds360LinkRequest.ProtoReflect.Descriptor instead.
func (*CreateSearchAds360LinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{69}
}

func (x *CreateSearchAds360LinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSearchAds360LinkRequest) GetSearchAds_360Link() *SearchAds360Link {
	if x != nil {
		return x.SearchAds_360Link
	}
	return nil
}

// Request message for DeleteSearchAds360Link RPC.
type DeleteSearchAds360LinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SearchAds360Link to delete.
	// Example format: properties/1234/SearchAds360Links/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSearchAds360LinkRequest) Reset() {
	*x = DeleteSearchAds360LinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSearchAds360LinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSearchAds360LinkRequest) ProtoMessage() {}

func (x *DeleteSearchAds360LinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSearchAds360LinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteSearchAds360LinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{70}
}

func (x *DeleteSearchAds360LinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateSearchAds360Link RPC.
type UpdateSearchAds360LinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SearchAds360Link to update
	SearchAds_360Link *SearchAds360Link `protobuf:"bytes,1,opt,name=search_ads_360_link,json=searchAds360Link,proto3" json:"search_ads_360_link,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated. To replace the entire entity, use one path with the string "*" to
	// match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSearchAds360LinkRequest) Reset() {
	*x = UpdateSearchAds360LinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSearchAds360LinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSearchAds360LinkRequest) ProtoMessage() {}

func (x *UpdateSearchAds360LinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSearchAds360LinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateSearchAds360LinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{71}
}

func (x *UpdateSearchAds360LinkRequest) GetSearchAds_360Link() *SearchAds360Link {
	if x != nil {
		return x.SearchAds_360Link
	}
	return nil
}

func (x *UpdateSearchAds360LinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateCustomDimension RPC.
type CreateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomDimension to create.
	CustomDimension *CustomDimension `protobuf:"bytes,2,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
}

func (x *CreateCustomDimensionRequest) Reset() {
	*x = CreateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomDimensionRequest) ProtoMessage() {}

func (x *CreateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{72}
}

func (x *CreateCustomDimensionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

// Request message for UpdateCustomDimension RPC.
type UpdateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomDimension to update
	CustomDimension *CustomDimension `protobuf:"bytes,1,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated. To replace the entire entity, use one path with the string "*" to
	// match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomDimensionRequest) Reset() {
	*x = UpdateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomDimensionRequest) ProtoMessage() {}

func (x *UpdateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{73}
}

func (x *UpdateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

func (x *UpdateCustomDimensionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomDimensions RPC.
type ListCustomDimensionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomDimensions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomDimensions`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomDimensionsRequest) Reset() {
	*x = ListCustomDimensionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsRequest) ProtoMessage() {}

func (x *ListCustomDimensionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{74}
}

func (x *ListCustomDimensionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomDimensionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomDimensionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomDimensions RPC.
type ListCustomDimensionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomDimensions.
	CustomDimensions []*CustomDimension `protobuf:"bytes,1,rep,name=custom_dimensions,json=customDimensions,proto3" json:"custom_dimensions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomDimensionsResponse) Reset() {
	*x = ListCustomDimensionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsResponse) ProtoMessage() {}

func (x *ListCustomDimensionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{75}
}

func (x *ListCustomDimensionsResponse) GetCustomDimensions() []*CustomDimension {
	if x != nil {
		return x.CustomDimensions
	}
	return nil
}

func (x *ListCustomDimensionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomDimension RPC.
type ArchiveCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to archive.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomDimensionRequest) Reset() {
	*x = ArchiveCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomDimensionRequest) ProtoMessage() {}

func (x *ArchiveCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{76}
}

func (x *ArchiveCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomDimension RPC.
type GetCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to get.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomDimensionRequest) Reset() {
	*x = GetCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomDimensionRequest) ProtoMessage() {}

func (x *GetCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*GetCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{77}
}

func (x *GetCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCustomMetric RPC.
type CreateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomMetric to create.
	CustomMetric *CustomMetric `protobuf:"bytes,2,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
}

func (x *CreateCustomMetricRequest) Reset() {
	*x = CreateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomMetricRequest) ProtoMessage() {}

func (x *CreateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{78}
}

func (x *CreateCustomMetricRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

// Request message for UpdateCustomMetric RPC.
type UpdateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomMetric to update
	CustomMetric *CustomMetric `protobuf:"bytes,1,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated. To replace the entire entity, use one path with the string "*" to
	// match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomMetricRequest) Reset() {
	*x = UpdateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomMetricRequest) ProtoMessage() {}

func (x *UpdateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{79}
}

func (x *UpdateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

func (x *UpdateCustomMetricRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomMetrics RPC.
type ListCustomMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomMetrics` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomMetrics` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomMetricsRequest) Reset() {
	*x = ListCustomMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsRequest) ProtoMessage() {}

func (x *ListCustomMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{80}
}

func (x *ListCustomMetricsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomMetricsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomMetricsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomMetrics RPC.
type ListCustomMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomMetrics.
	CustomMetrics []*CustomMetric `protobuf:"bytes,1,rep,name=custom_metrics,json=customMetrics,proto3" json:"custom_metrics,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomMetricsResponse) Reset() {
	*x = ListCustomMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsResponse) ProtoMessage() {}

func (x *ListCustomMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{81}
}

func (x *ListCustomMetricsResponse) GetCustomMetrics() []*CustomMetric {
	if x != nil {
		return x.CustomMetrics
	}
	return nil
}

func (x *ListCustomMetricsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomMetric RPC.
type ArchiveCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to archive.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomMetricRequest) Reset() {
	*x = ArchiveCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomMetricRequest) ProtoMessage() {}

func (x *ArchiveCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{82}
}

func (x *ArchiveCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomMetric RPC.
type GetCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to get.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomMetricRequest) Reset() {
	*x = GetCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomMetricRequest) ProtoMessage() {}

func (x *GetCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*GetCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{83}
}

func (x *GetCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCalculatedMetric RPC.
type CreateCalculatedMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the calculated metric which will become the
	// final component of the calculated metric's resource name.
	//
	// This value should be 1-80 characters and valid characters are
	// /[a-zA-Z0-9_]/, no spaces allowed. calculated_metric_id must be unique
	// between all calculated metrics under a property. The calculated_metric_id
	// is used when referencing this calculated metric from external APIs, for
	// example, "calcMetric:{calculated_metric_id}".
	CalculatedMetricId string `protobuf:"bytes,2,opt,name=calculated_metric_id,json=calculatedMetricId,proto3" json:"calculated_metric_id,omitempty"`
	// Required. The CalculatedMetric to create.
	CalculatedMetric *CalculatedMetric `protobuf:"bytes,3,opt,name=calculated_metric,json=calculatedMetric,proto3" json:"calculated_metric,omitempty"`
}

func (x *CreateCalculatedMetricRequest) Reset() {
	*x = CreateCalculatedMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCalculatedMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCalculatedMetricRequest) ProtoMessage() {}

func (x *CreateCalculatedMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCalculatedMetricRequest.ProtoReflect.Descriptor instead.
func (*CreateCalculatedMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{84}
}

func (x *CreateCalculatedMetricRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCalculatedMetricRequest) GetCalculatedMetricId() string {
	if x != nil {
		return x.CalculatedMetricId
	}
	return ""
}

func (x *CreateCalculatedMetricRequest) GetCalculatedMetric() *CalculatedMetric {
	if x != nil {
		return x.CalculatedMetric
	}
	return nil
}

// Request message for UpdateCalculatedMetric RPC.
type UpdateCalculatedMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CalculatedMetric to update
	CalculatedMetric *CalculatedMetric `protobuf:"bytes,1,opt,name=calculated_metric,json=calculatedMetric,proto3" json:"calculated_metric,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated. To replace the entire entity, use one path with the string "*" to
	// match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCalculatedMetricRequest) Reset() {
	*x = UpdateCalculatedMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCalculatedMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCalculatedMetricRequest) ProtoMessage() {}

func (x *UpdateCalculatedMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCalculatedMetricRequest.ProtoReflect.Descriptor instead.
func (*UpdateCalculatedMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{85}
}

func (x *UpdateCalculatedMetricRequest) GetCalculatedMetric() *CalculatedMetric {
	if x != nil {
		return x.CalculatedMetric
	}
	return nil
}

func (x *UpdateCalculatedMetricRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteCalculatedMetric RPC.
type DeleteCalculatedMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CalculatedMetric to delete.
	// Format: properties/{property_id}/calculatedMetrics/{calculated_metric_id}
	// Example: properties/1234/calculatedMetrics/Metric01
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCalculatedMetricRequest) Reset() {
	*x = DeleteCalculatedMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCalculatedMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCalculatedMetricRequest) ProtoMessage() {}

func (x *DeleteCalculatedMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCalculatedMetricRequest.ProtoReflect.Descriptor instead.
func (*DeleteCalculatedMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{86}
}

func (x *DeleteCalculatedMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListCalculatedMetrics RPC.
type ListCalculatedMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListCalculatedMetrics`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCalculatedMetrics`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCalculatedMetricsRequest) Reset() {
	*x = ListCalculatedMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCalculatedMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCalculatedMetricsRequest) ProtoMessage() {}

func (x *ListCalculatedMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCalculatedMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListCalculatedMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{87}
}

func (x *ListCalculatedMetricsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCalculatedMetricsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCalculatedMetricsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCalculatedMetrics RPC.
type ListCalculatedMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CalculatedMetrics.
	CalculatedMetrics []*CalculatedMetric `protobuf:"bytes,1,rep,name=calculated_metrics,json=calculatedMetrics,proto3" json:"calculated_metrics,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCalculatedMetricsResponse) Reset() {
	*x = ListCalculatedMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCalculatedMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCalculatedMetricsResponse) ProtoMessage() {}

func (x *ListCalculatedMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCalculatedMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListCalculatedMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{88}
}

func (x *ListCalculatedMetricsResponse) GetCalculatedMetrics() []*CalculatedMetric {
	if x != nil {
		return x.CalculatedMetrics
	}
	return nil
}

func (x *ListCalculatedMetricsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetCalculatedMetric RPC.
type GetCalculatedMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CalculatedMetric to get.
	// Format: properties/{property_id}/calculatedMetrics/{calculated_metric_id}
	// Example: properties/1234/calculatedMetrics/Metric01
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCalculatedMetricRequest) Reset() {
	*x = GetCalculatedMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCalculatedMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCalculatedMetricRequest) ProtoMessage() {}

func (x *GetCalculatedMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCalculatedMetricRequest.ProtoReflect.Descriptor instead.
func (*GetCalculatedMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{89}
}

func (x *GetCalculatedMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetDataRetentionSettings RPC.
type GetDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property}/dataRetentionSettings
	// Example: "properties/1000/dataRetentionSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataRetentionSettingsRequest) Reset() {
	*x = GetDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataRetentionSettingsRequest) ProtoMessage() {}

func (x *GetDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{90}
}

func (x *GetDataRetentionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataRetentionSettings RPC.
type UpdateDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	DataRetentionSettings *DataRetentionSettings `protobuf:"bytes,1,opt,name=data_retention_settings,json=dataRetentionSettings,proto3" json:"data_retention_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataRetentionSettingsRequest) Reset() {
	*x = UpdateDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataRetentionSettingsRequest) ProtoMessage() {}

func (x *UpdateDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{91}
}

func (x *UpdateDataRetentionSettingsRequest) GetDataRetentionSettings() *DataRetentionSettings {
	if x != nil {
		return x.DataRetentionSettings
	}
	return nil
}

func (x *UpdateDataRetentionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateDataStream RPC.
type CreateDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DataStream to create.
	DataStream *DataStream `protobuf:"bytes,2,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
}

func (x *CreateDataStreamRequest) Reset() {
	*x = CreateDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataStreamRequest) ProtoMessage() {}

func (x *CreateDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{92}
}

func (x *CreateDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataStreamRequest) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

// Request message for DeleteDataStream RPC.
type DeleteDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DataStream to delete.
	// Example format: properties/1234/dataStreams/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataStreamRequest) Reset() {
	*x = DeleteDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataStreamRequest) ProtoMessage() {}

func (x *DeleteDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{93}
}

func (x *DeleteDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataStream RPC.
type UpdateDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DataStream to update
	DataStream *DataStream `protobuf:"bytes,1,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be
	// updated. To replace the entire entity, use one path with the string "*" to
	// match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataStreamRequest) Reset() {
	*x = UpdateDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataStreamRequest) ProtoMessage() {}

func (x *UpdateDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{94}
}

func (x *UpdateDataStreamRequest) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

func (x *UpdateDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListDataStreams RPC.
type ListDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDataStreams` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDataStreams` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataStreamsRequest) Reset() {
	*x = ListDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataStreamsRequest) ProtoMessage() {}

func (x *ListDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{95}
}

func (x *ListDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDataStreams RPC.
type ListDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DataStreams.
	DataStreams []*DataStream `protobuf:"bytes,1,rep,name=data_streams,json=dataStreams,proto3" json:"data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataStreamsResponse) Reset() {
	*x = ListDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataStreamsResponse) ProtoMessage() {}

func (x *ListDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{96}
}

func (x *ListDataStreamsResponse) GetDataStreams() []*DataStream {
	if x != nil {
		return x.DataStreams
	}
	return nil
}

func (x *ListDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataStream RPC.
type GetDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DataStream to get.
	// Example format: properties/1234/dataStreams/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataStreamRequest) Reset() {
	*x = GetDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataStreamRequest) ProtoMessage() {}

func (x *GetDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{97}
}

func (x *GetDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetAudience RPC.
type GetAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Audience to get.
	// Example format: properties/1234/audiences/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAudienceRequest) Reset() {
	*x = GetAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAudienceRequest) ProtoMessage() {}

func (x *GetAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAudienceRequest.ProtoReflect.Descriptor instead.
func (*GetAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{98}
}

func (x *GetAudienceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAudiences RPC.
type ListAudiencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAudiences` call. Provide this
	// to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAudiences` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAudiencesRequest) Reset() {
	*x = ListAudiencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAudiencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAudiencesRequest) ProtoMessage() {}

func (x *ListAudiencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAudiencesRequest.ProtoReflect.Descriptor instead.
func (*ListAudiencesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{99}
}

func (x *ListAudiencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAudiencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAudiencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAudiences RPC.
type ListAudiencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Audiences.
	Audiences []*Audience `protobuf:"bytes,1,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAudiencesResponse) Reset() {
	*x = ListAudiencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAudiencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAudiencesResponse) ProtoMessage() {}

func (x *ListAudiencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAudiencesResponse.ProtoReflect.Descriptor instead.
func (*ListAudiencesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{100}
}

func (x *ListAudiencesResponse) GetAudiences() []*Audience {
	if x != nil {
		return x.Audiences
	}
	return nil
}

func (x *ListAudiencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateAudience RPC.
type CreateAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The audience to create.
	Audience *Audience `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *CreateAudienceRequest) Reset() {
	*x = CreateAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAudienceRequest) ProtoMessage() {}

func (x *CreateAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAudienceRequest.ProtoReflect.Descriptor instead.
func (*CreateAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{101}
}

func (x *CreateAudienceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAudienceRequest) GetAudience() *Audience {
	if x != nil {
		return x.Audience
	}
	return nil
}

// Request message for UpdateAudience RPC.
type UpdateAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The audience to update.
	// The audience's `name` field is used to identify the audience to be updated.
	Audience *Audience `protobuf:"bytes,1,opt,name=audience,proto3" json:"audience,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAudienceRequest) Reset() {
	*x = UpdateAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAudienceRequest) ProtoMessage() {}

func (x *UpdateAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAudienceRequest.ProtoReflect.Descriptor instead.
func (*UpdateAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{102}
}

func (x *UpdateAudienceRequest) GetAudience() *Audience {
	if x != nil {
		return x.Audience
	}
	return nil
}

func (x *UpdateAudienceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ArchiveAudience RPC.
type ArchiveAudienceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/audiences/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveAudienceRequest) Reset() {
	*x = ArchiveAudienceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveAudienceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveAudienceRequest) ProtoMessage() {}

func (x *ArchiveAudienceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveAudienceRequest.ProtoReflect.Descriptor instead.
func (*ArchiveAudienceRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{103}
}

func (x *ArchiveAudienceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetAttributionSettings RPC.
type GetAttributionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the attribution settings to retrieve.
	// Format: properties/{property}/attributionSettings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttributionSettingsRequest) Reset() {
	*x = GetAttributionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAttributionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttributionSettingsRequest) ProtoMessage() {}

func (x *GetAttributionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttributionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetAttributionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{104}
}

func (x *GetAttributionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAttributionSettings RPC
type UpdateAttributionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The attribution settings to update.
	// The `name` field is used to identify the settings to be updated.
	AttributionSettings *AttributionSettings `protobuf:"bytes,1,opt,name=attribution_settings,json=attributionSettings,proto3" json:"attribution_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAttributionSettingsRequest) Reset() {
	*x = UpdateAttributionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAttributionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAttributionSettingsRequest) ProtoMessage() {}

func (x *UpdateAttributionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAttributionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateAttributionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{105}
}

func (x *UpdateAttributionSettingsRequest) GetAttributionSettings() *AttributionSettings {
	if x != nil {
		return x.AttributionSettings
	}
	return nil
}

func (x *UpdateAttributionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetAccessBinding RPC.
type GetAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the access binding to retrieve.
	// Formats:
	// - accounts/{account}/accessBindings/{accessBinding}
	// - properties/{property}/accessBindings/{accessBinding}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccessBindingRequest) Reset() {
	*x = GetAccessBindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccessBindingRequest) ProtoMessage() {}

func (x *GetAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*GetAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{106}
}

func (x *GetAccessBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchGetAccessBindings RPC.
type BatchGetAccessBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that owns the access bindings. The parent
	// of all provided values for the 'names' field must match this field.
	// Formats:
	// - accounts/{account}
	// - properties/{property}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the access bindings to retrieve.
	// A maximum of 1000 access bindings can be retrieved in a batch.
	// Formats:
	// - accounts/{account}/accessBindings/{accessBinding}
	// - properties/{property}/accessBindings/{accessBinding}
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetAccessBindingsRequest) Reset() {
	*x = BatchGetAccessBindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAccessBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAccessBindingsRequest) ProtoMessage() {}

func (x *BatchGetAccessBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAccessBindingsRequest.ProtoReflect.Descriptor instead.
func (*BatchGetAccessBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{107}
}

func (x *BatchGetAccessBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetAccessBindingsRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for BatchGetAccessBindings RPC.
type BatchGetAccessBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested access bindings.
	AccessBindings []*AccessBinding `protobuf:"bytes,1,rep,name=access_bindings,json=accessBindings,proto3" json:"access_bindings,omitempty"`
}

func (x *BatchGetAccessBindingsResponse) Reset() {
	*x = BatchGetAccessBindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAccessBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAccessBindingsResponse) ProtoMessage() {}

func (x *BatchGetAccessBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAccessBindingsResponse.ProtoReflect.Descriptor instead.
func (*BatchGetAccessBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{108}
}

func (x *BatchGetAccessBindingsResponse) GetAccessBindings() []*AccessBinding {
	if x != nil {
		return x.AccessBindings
	}
	return nil
}

// Request message for ListAccessBindings RPC.
type ListAccessBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Formats:
	// - accounts/{account}
	// - properties/{property}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of access bindings to return.
	// The service may return fewer than this value.
	// If unspecified, at most 200 access bindings will be returned.
	// The maximum value is 500; values above 500 will be coerced to 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccessBindings` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccessBindings` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccessBindingsRequest) Reset() {
	*x = ListAccessBindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccessBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccessBindingsRequest) ProtoMessage() {}

func (x *ListAccessBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccessBindingsRequest.ProtoReflect.Descriptor instead.
func (*ListAccessBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{109}
}

func (x *ListAccessBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAccessBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccessBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAccessBindings RPC.
type ListAccessBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of AccessBindings. These will be ordered stably, but in an arbitrary
	// order.
	AccessBindings []*AccessBinding `protobuf:"bytes,1,rep,name=access_bindings,json=accessBindings,proto3" json:"access_bindings,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccessBindingsResponse) Reset() {
	*x = ListAccessBindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccessBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccessBindingsResponse) ProtoMessage() {}

func (x *ListAccessBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccessBindingsResponse.ProtoReflect.Descriptor instead.
func (*ListAccessBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{110}
}

func (x *ListAccessBindingsResponse) GetAccessBindings() []*AccessBinding {
	if x != nil {
		return x.AccessBindings
	}
	return nil
}

func (x *ListAccessBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateAccessBinding RPC.
type CreateAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Formats:
	// - accounts/{account}
	// - properties/{property}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The access binding to create.
	AccessBinding *AccessBinding `protobuf:"bytes,2,opt,name=access_binding,json=accessBinding,proto3" json:"access_binding,omitempty"`
}

func (x *CreateAccessBindingRequest) Reset() {
	*x = CreateAccessBindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAccessBindingRequest) ProtoMessage() {}

func (x *CreateAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*CreateAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{111}
}

func (x *CreateAccessBindingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAccessBindingRequest) GetAccessBinding() *AccessBinding {
	if x != nil {
		return x.AccessBinding
	}
	return nil
}

// Request message for BatchCreateAccessBindings RPC.
type BatchCreateAccessBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that owns the access bindings. The parent
	// field in the CreateAccessBindingRequest messages must either be empty or
	// match this field. Formats:
	// - accounts/{account}
	// - properties/{property}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the access bindings to create.
	// A maximum of 1000 access bindings can be created in a batch.
	Requests []*CreateAccessBindingRequest `protobuf:"bytes,3,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateAccessBindingsRequest) Reset() {
	*x = BatchCreateAccessBindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateAccessBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateAccessBindingsRequest) ProtoMessage() {}

func (x *BatchCreateAccessBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateAccessBindingsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateAccessBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{112}
}

func (x *BatchCreateAccessBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateAccessBindingsRequest) GetRequests() []*CreateAccessBindingRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchCreateAccessBindings RPC.
type BatchCreateAccessBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The access bindings created.
	AccessBindings []*AccessBinding `protobuf:"bytes,1,rep,name=access_bindings,json=accessBindings,proto3" json:"access_bindings,omitempty"`
}

func (x *BatchCreateAccessBindingsResponse) Reset() {
	*x = BatchCreateAccessBindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateAccessBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateAccessBindingsResponse) ProtoMessage() {}

func (x *BatchCreateAccessBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateAccessBindingsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateAccessBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{113}
}

func (x *BatchCreateAccessBindingsResponse) GetAccessBindings() []*AccessBinding {
	if x != nil {
		return x.AccessBindings
	}
	return nil
}

// Request message for UpdateAccessBinding RPC.
type UpdateAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The access binding to update.
	AccessBinding *AccessBinding `protobuf:"bytes,1,opt,name=access_binding,json=accessBinding,proto3" json:"access_binding,omitempty"`
}

func (x *UpdateAccessBindingRequest) Reset() {
	*x = UpdateAccessBindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccessBindingRequest) ProtoMessage() {}

func (x *UpdateAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{114}
}

func (x *UpdateAccessBindingRequest) GetAccessBinding() *AccessBinding {
	if x != nil {
		return x.AccessBinding
	}
	return nil
}

// Request message for BatchUpdateAccessBindings RPC.
type BatchUpdateAccessBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that owns the access bindings. The parent
	// of all provided AccessBinding in UpdateAccessBindingRequest messages must
	// match this field.
	// Formats:
	// - accounts/{account}
	// - properties/{property}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the access bindings to update.
	// A maximum of 1000 access bindings can be updated in a batch.
	Requests []*UpdateAccessBindingRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateAccessBindingsRequest) Reset() {
	*x = BatchUpdateAccessBindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateAccessBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateAccessBindingsRequest) ProtoMessage() {}

func (x *BatchUpdateAccessBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateAccessBindingsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateAccessBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{115}
}

func (x *BatchUpdateAccessBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateAccessBindingsRequest) GetRequests() []*UpdateAccessBindingRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchUpdateAccessBindings RPC.
type BatchUpdateAccessBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The access bindings updated.
	AccessBindings []*AccessBinding `protobuf:"bytes,1,rep,name=access_bindings,json=accessBindings,proto3" json:"access_bindings,omitempty"`
}

func (x *BatchUpdateAccessBindingsResponse) Reset() {
	*x = BatchUpdateAccessBindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateAccessBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateAccessBindingsResponse) ProtoMessage() {}

func (x *BatchUpdateAccessBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateAccessBindingsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateAccessBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{116}
}

func (x *BatchUpdateAccessBindingsResponse) GetAccessBindings() []*AccessBinding {
	if x != nil {
		return x.AccessBindings
	}
	return nil
}

// Request message for DeleteAccessBinding RPC.
type DeleteAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Formats:
	// - accounts/{account}/accessBindings/{accessBinding}
	// - properties/{property}/accessBindings/{accessBinding}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccessBindingRequest) Reset() {
	*x = DeleteAccessBindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccessBindingRequest) ProtoMessage() {}

func (x *DeleteAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{117}
}

func (x *DeleteAccessBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchDeleteAccessBindings RPC.
type BatchDeleteAccessBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account or property that owns the access bindings. The parent
	// of all provided values for the 'names' field in DeleteAccessBindingRequest
	// messages must match this field. Formats:
	// - accounts/{account}
	// - properties/{property}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The requests specifying the access bindings to delete.
	// A maximum of 1000 access bindings can be deleted in a batch.
	Requests []*DeleteAccessBindingRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchDeleteAccessBindingsRequest) Reset() {
	*x = BatchDeleteAccessBindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteAccessBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteAccessBindingsRequest) ProtoMessage() {}

func (x *BatchDeleteAccessBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteAccessBindingsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteAccessBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{118}
}

func (x *BatchDeleteAccessBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteAccessBindingsRequest) GetRequests() []*DeleteAccessBindingRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Request message for CreateExpandedDataSet RPC.
type CreateExpandedDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ExpandedDataSet to create.
	ExpandedDataSet *ExpandedDataSet `protobuf:"bytes,2,opt,name=expanded_data_set,json=expandedDataSet,proto3" json:"expanded_data_set,omitempty"`
}

func (x *CreateExpandedDataSetRequest) Reset() {
	*x = CreateExpandedDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateExpandedDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExpandedDataSetRequest) ProtoMessage() {}

func (x *CreateExpandedDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExpandedDataSetRequest.ProtoReflect.Descriptor instead.
func (*CreateExpandedDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{119}
}

func (x *CreateExpandedDataSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateExpandedDataSetRequest) GetExpandedDataSet() *ExpandedDataSet {
	if x != nil {
		return x.ExpandedDataSet
	}
	return nil
}

// Request message for UpdateExpandedDataSet RPC.
type UpdateExpandedDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ExpandedDataSet to update.
	// The resource's `name` field is used to identify the ExpandedDataSet to be
	// updated.
	ExpandedDataSet *ExpandedDataSet `protobuf:"bytes,1,opt,name=expanded_data_set,json=expandedDataSet,proto3" json:"expanded_data_set,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExpandedDataSetRequest) Reset() {
	*x = UpdateExpandedDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateExpandedDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExpandedDataSetRequest) ProtoMessage() {}

func (x *UpdateExpandedDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExpandedDataSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateExpandedDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{120}
}

func (x *UpdateExpandedDataSetRequest) GetExpandedDataSet() *ExpandedDataSet {
	if x != nil {
		return x.ExpandedDataSet
	}
	return nil
}

func (x *UpdateExpandedDataSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteExpandedDataSet RPC.
type DeleteExpandedDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/expandedDataSets/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteExpandedDataSetRequest) Reset() {
	*x = DeleteExpandedDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExpandedDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExpandedDataSetRequest) ProtoMessage() {}

func (x *DeleteExpandedDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExpandedDataSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteExpandedDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{121}
}

func (x *DeleteExpandedDataSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetExpandedDataSet RPC.
type GetExpandedDataSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ExpandedDataSet to get.
	// Example format: properties/1234/expandedDataSets/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetExpandedDataSetRequest) Reset() {
	*x = GetExpandedDataSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExpandedDataSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExpandedDataSetRequest) ProtoMessage() {}

func (x *GetExpandedDataSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExpandedDataSetRequest.ProtoReflect.Descriptor instead.
func (*GetExpandedDataSetRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{122}
}

func (x *GetExpandedDataSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListExpandedDataSets RPC.
type ListExpandedDataSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListExpandedDataSets` call. Provide
	// this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListExpandedDataSet`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListExpandedDataSetsRequest) Reset() {
	*x = ListExpandedDataSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListExpandedDataSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExpandedDataSetsRequest) ProtoMessage() {}

func (x *ListExpandedDataSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExpandedDataSetsRequest.ProtoReflect.Descriptor instead.
func (*ListExpandedDataSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{123}
}

func (x *ListExpandedDataSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListExpandedDataSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListExpandedDataSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListExpandedDataSets RPC.
type ListExpandedDataSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ExpandedDataSet. These will be ordered stably, but in an arbitrary
	// order.
	ExpandedDataSets []*ExpandedDataSet `protobuf:"bytes,1,rep,name=expanded_data_sets,json=expandedDataSets,proto3" json:"expanded_data_sets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListExpandedDataSetsResponse) Reset() {
	*x = ListExpandedDataSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListExpandedDataSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExpandedDataSetsResponse) ProtoMessage() {}

func (x *ListExpandedDataSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExpandedDataSetsResponse.ProtoReflect.Descriptor instead.
func (*ListExpandedDataSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{124}
}

func (x *ListExpandedDataSetsResponse) GetExpandedDataSets() []*ExpandedDataSet {
	if x != nil {
		return x.ExpandedDataSets
	}
	return nil
}

func (x *ListExpandedDataSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateChannelGroup RPC.
type CreateChannelGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property for which to create a ChannelGroup.
	// Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ChannelGroup to create.
	ChannelGroup *ChannelGroup `protobuf:"bytes,2,opt,name=channel_group,json=channelGroup,proto3" json:"channel_group,omitempty"`
}

func (x *CreateChannelGroupRequest) Reset() {
	*x = CreateChannelGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChannelGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChannelGroupRequest) ProtoMessage() {}

func (x *CreateChannelGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChannelGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateChannelGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{125}
}

func (x *CreateChannelGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChannelGroupRequest) GetChannelGroup() *ChannelGroup {
	if x != nil {
		return x.ChannelGroup
	}
	return nil
}

// Request message for UpdateChannelGroup RPC.
type UpdateChannelGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ChannelGroup to update.
	// The resource's `name` field is used to identify the ChannelGroup to be
	// updated.
	ChannelGroup *ChannelGroup `protobuf:"bytes,1,opt,name=channel_group,json=channelGroup,proto3" json:"channel_group,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateChannelGroupRequest) Reset() {
	*x = UpdateChannelGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelGroupRequest) ProtoMessage() {}

func (x *UpdateChannelGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateChannelGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{126}
}

func (x *UpdateChannelGroupRequest) GetChannelGroup() *ChannelGroup {
	if x != nil {
		return x.ChannelGroup
	}
	return nil
}

func (x *UpdateChannelGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteChannelGroup RPC.
type DeleteChannelGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ChannelGroup to delete.
	// Example format: properties/1234/channelGroups/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteChannelGroupRequest) Reset() {
	*x = DeleteChannelGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteChannelGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteChannelGroupRequest) ProtoMessage() {}

func (x *DeleteChannelGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteChannelGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteChannelGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{127}
}

func (x *DeleteChannelGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetChannelGroup RPC.
type GetChannelGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ChannelGroup to get.
	// Example format: properties/1234/channelGroups/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetChannelGroupRequest) Reset() {
	*x = GetChannelGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetChannelGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetChannelGroupRequest) ProtoMessage() {}

func (x *GetChannelGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetChannelGroupRequest.ProtoReflect.Descriptor instead.
func (*GetChannelGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{128}
}

func (x *GetChannelGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListChannelGroups RPC.
type ListChannelGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property for which to list ChannelGroups.
	// Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListChannelGroups` call. Provide
	// this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListChannelGroups`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListChannelGroupsRequest) Reset() {
	*x = ListChannelGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelGroupsRequest) ProtoMessage() {}

func (x *ListChannelGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListChannelGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{129}
}

func (x *ListChannelGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListChannelGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListChannelGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListChannelGroups RPC.
type ListChannelGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ChannelGroup. These will be ordered stably, but in an arbitrary
	// order.
	ChannelGroups []*ChannelGroup `protobuf:"bytes,1,rep,name=channel_groups,json=channelGroups,proto3" json:"channel_groups,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListChannelGroupsResponse) Reset() {
	*x = ListChannelGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelGroupsResponse) ProtoMessage() {}

func (x *ListChannelGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListChannelGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{130}
}

func (x *ListChannelGroupsResponse) GetChannelGroups() []*ChannelGroup {
	if x != nil {
		return x.ChannelGroups
	}
	return nil
}

func (x *ListChannelGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for setting the opt out status for the automated GA4 setup process.
type SetAutomatedGa4ConfigurationOptOutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The UA property to set the opt out status. Note this request uses
	// the internal property ID, not the tracking ID of the form UA-XXXXXX-YY.
	// Format: properties/{internalWebPropertyId}
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The status to set.
	OptOut bool `protobuf:"varint,2,opt,name=opt_out,json=optOut,proto3" json:"opt_out,omitempty"`
}

func (x *SetAutomatedGa4ConfigurationOptOutRequest) Reset() {
	*x = SetAutomatedGa4ConfigurationOptOutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetAutomatedGa4ConfigurationOptOutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAutomatedGa4ConfigurationOptOutRequest) ProtoMessage() {}

func (x *SetAutomatedGa4ConfigurationOptOutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAutomatedGa4ConfigurationOptOutRequest.ProtoReflect.Descriptor instead.
func (*SetAutomatedGa4ConfigurationOptOutRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{131}
}

func (x *SetAutomatedGa4ConfigurationOptOutRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *SetAutomatedGa4ConfigurationOptOutRequest) GetOptOut() bool {
	if x != nil {
		return x.OptOut
	}
	return false
}

// Response message for setting the opt out status for the automated GA4 setup
// process.
type SetAutomatedGa4ConfigurationOptOutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetAutomatedGa4ConfigurationOptOutResponse) Reset() {
	*x = SetAutomatedGa4ConfigurationOptOutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetAutomatedGa4ConfigurationOptOutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAutomatedGa4ConfigurationOptOutResponse) ProtoMessage() {}

func (x *SetAutomatedGa4ConfigurationOptOutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAutomatedGa4ConfigurationOptOutResponse.ProtoReflect.Descriptor instead.
func (*SetAutomatedGa4ConfigurationOptOutResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{132}
}

// Request for fetching the opt out status for the automated GA4 setup process.
type FetchAutomatedGa4ConfigurationOptOutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The UA property to get the opt out status. Note this request uses
	// the internal property ID, not the tracking ID of the form UA-XXXXXX-YY.
	// Format: properties/{internalWebPropertyId}
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *FetchAutomatedGa4ConfigurationOptOutRequest) Reset() {
	*x = FetchAutomatedGa4ConfigurationOptOutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchAutomatedGa4ConfigurationOptOutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchAutomatedGa4ConfigurationOptOutRequest) ProtoMessage() {}

func (x *FetchAutomatedGa4ConfigurationOptOutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchAutomatedGa4ConfigurationOptOutRequest.ProtoReflect.Descriptor instead.
func (*FetchAutomatedGa4ConfigurationOptOutRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{133}
}

func (x *FetchAutomatedGa4ConfigurationOptOutRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

// Response message for fetching the opt out status for the automated GA4 setup
// process.
type FetchAutomatedGa4ConfigurationOptOutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The opt out status for the UA property.
	OptOut bool `protobuf:"varint,1,opt,name=opt_out,json=optOut,proto3" json:"opt_out,omitempty"`
}

func (x *FetchAutomatedGa4ConfigurationOptOutResponse) Reset() {
	*x = FetchAutomatedGa4ConfigurationOptOutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchAutomatedGa4ConfigurationOptOutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchAutomatedGa4ConfigurationOptOutResponse) ProtoMessage() {}

func (x *FetchAutomatedGa4ConfigurationOptOutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchAutomatedGa4ConfigurationOptOutResponse.ProtoReflect.Descriptor instead.
func (*FetchAutomatedGa4ConfigurationOptOutResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{134}
}

func (x *FetchAutomatedGa4ConfigurationOptOutResponse) GetOptOut() bool {
	if x != nil {
		return x.OptOut
	}
	return false
}

// Request message for GetBigQueryLink RPC.
type GetBigQueryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the BigQuery link to lookup.
	// Format: properties/{property_id}/bigQueryLinks/{bigquery_link_id}
	// Example: properties/123/bigQueryLinks/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBigQueryLinkRequest) Reset() {
	*x = GetBigQueryLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBigQueryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBigQueryLinkRequest) ProtoMessage() {}

func (x *GetBigQueryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBigQueryLinkRequest.ProtoReflect.Descriptor instead.
func (*GetBigQueryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{135}
}

func (x *GetBigQueryLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListBigQueryLinks RPC.
type ListBigQueryLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the property to list BigQuery links under.
	// Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListBigQueryLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListBigQueryLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBigQueryLinksRequest) Reset() {
	*x = ListBigQueryLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBigQueryLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBigQueryLinksRequest) ProtoMessage() {}

func (x *ListBigQueryLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBigQueryLinksRequest.ProtoReflect.Descriptor instead.
func (*ListBigQueryLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{136}
}

func (x *ListBigQueryLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBigQueryLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBigQueryLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListBigQueryLinks RPC
type ListBigQueryLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of BigQueryLinks.
	BigqueryLinks []*BigQueryLink `protobuf:"bytes,1,rep,name=bigquery_links,json=bigqueryLinks,proto3" json:"bigquery_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBigQueryLinksResponse) Reset() {
	*x = ListBigQueryLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBigQueryLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBigQueryLinksResponse) ProtoMessage() {}

func (x *ListBigQueryLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBigQueryLinksResponse.ProtoReflect.Descriptor instead.
func (*ListBigQueryLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{137}
}

func (x *ListBigQueryLinksResponse) GetBigqueryLinks() []*BigQueryLink {
	if x != nil {
		return x.BigqueryLinks
	}
	return nil
}

func (x *ListBigQueryLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetEnhancedMeasurementSettings RPC.
type GetEnhancedMeasurementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property}/dataStreams/{data_stream}/enhancedMeasurementSettings
	// Example: "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEnhancedMeasurementSettingsRequest) Reset() {
	*x = GetEnhancedMeasurementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEnhancedMeasurementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnhancedMeasurementSettingsRequest) ProtoMessage() {}

func (x *GetEnhancedMeasurementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnhancedMeasurementSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetEnhancedMeasurementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{138}
}

func (x *GetEnhancedMeasurementSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateEnhancedMeasurementSettings RPC.
type UpdateEnhancedMeasurementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	EnhancedMeasurementSettings *EnhancedMeasurementSettings `protobuf:"bytes,1,opt,name=enhanced_measurement_settings,json=enhancedMeasurementSettings,proto3" json:"enhanced_measurement_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEnhancedMeasurementSettingsRequest) Reset() {
	*x = UpdateEnhancedMeasurementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEnhancedMeasurementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEnhancedMeasurementSettingsRequest) ProtoMessage() {}

func (x *UpdateEnhancedMeasurementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEnhancedMeasurementSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateEnhancedMeasurementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{139}
}

func (x *UpdateEnhancedMeasurementSettingsRequest) GetEnhancedMeasurementSettings() *EnhancedMeasurementSettings {
	if x != nil {
		return x.EnhancedMeasurementSettings
	}
	return nil
}

func (x *UpdateEnhancedMeasurementSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDataRedactionSettings RPC.
type GetDataRedactionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property}/dataStreams/{data_stream}/dataRedactionSettings
	// Example: "properties/1000/dataStreams/2000/dataRedactionSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataRedactionSettingsRequest) Reset() {
	*x = GetDataRedactionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataRedactionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataRedactionSettingsRequest) ProtoMessage() {}

func (x *GetDataRedactionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataRedactionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataRedactionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{140}
}

func (x *GetDataRedactionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataRedactionSettings RPC.
type UpdateDataRedactionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	DataRedactionSettings *DataRedactionSettings `protobuf:"bytes,1,opt,name=data_redaction_settings,json=dataRedactionSettings,proto3" json:"data_redaction_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataRedactionSettingsRequest) Reset() {
	*x = UpdateDataRedactionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataRedactionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataRedactionSettingsRequest) ProtoMessage() {}

func (x *UpdateDataRedactionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataRedactionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataRedactionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{141}
}

func (x *UpdateDataRedactionSettingsRequest) GetDataRedactionSettings() *DataRedactionSettings {
	if x != nil {
		return x.DataRedactionSettings
	}
	return nil
}

func (x *UpdateDataRedactionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateConnectedSiteTag RPC.
type CreateConnectedSiteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Universal Analytics property to create connected site tags for.
	// This API does not support GA4 properties.
	// Format: properties/{universalAnalyticsPropertyId}
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. The tag to add to the Universal Analytics property
	ConnectedSiteTag *ConnectedSiteTag `protobuf:"bytes,2,opt,name=connected_site_tag,json=connectedSiteTag,proto3" json:"connected_site_tag,omitempty"`
}

func (x *CreateConnectedSiteTagRequest) Reset() {
	*x = CreateConnectedSiteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectedSiteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectedSiteTagRequest) ProtoMessage() {}

func (x *CreateConnectedSiteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectedSiteTagRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectedSiteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{142}
}

func (x *CreateConnectedSiteTagRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *CreateConnectedSiteTagRequest) GetConnectedSiteTag() *ConnectedSiteTag {
	if x != nil {
		return x.ConnectedSiteTag
	}
	return nil
}

// Response message for CreateConnectedSiteTag RPC.
type CreateConnectedSiteTagResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateConnectedSiteTagResponse) Reset() {
	*x = CreateConnectedSiteTagResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectedSiteTagResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectedSiteTagResponse) ProtoMessage() {}

func (x *CreateConnectedSiteTagResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectedSiteTagResponse.ProtoReflect.Descriptor instead.
func (*CreateConnectedSiteTagResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{143}
}

// Request message for DeleteConnectedSiteTag RPC.
type DeleteConnectedSiteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Universal Analytics property to delete connected site tags for.
	// This API does not support GA4 properties.
	// Format: properties/{universalAnalyticsPropertyId}
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Tag ID to forward events to. Also known as the Measurement ID, or the
	// "G-ID"  (For example: G-12345).
	TagId string `protobuf:"bytes,2,opt,name=tag_id,json=tagId,proto3" json:"tag_id,omitempty"`
}

func (x *DeleteConnectedSiteTagRequest) Reset() {
	*x = DeleteConnectedSiteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConnectedSiteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectedSiteTagRequest) ProtoMessage() {}

func (x *DeleteConnectedSiteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectedSiteTagRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectedSiteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{144}
}

func (x *DeleteConnectedSiteTagRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *DeleteConnectedSiteTagRequest) GetTagId() string {
	if x != nil {
		return x.TagId
	}
	return ""
}

// Request message for ListConnectedSiteTags RPC.
type ListConnectedSiteTagsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Universal Analytics property to fetch connected site tags for.
	// This does not work on GA4 properties. A maximum of 20 connected site tags
	// will be returned.
	// Example Format: `properties/1234`
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *ListConnectedSiteTagsRequest) Reset() {
	*x = ListConnectedSiteTagsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectedSiteTagsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectedSiteTagsRequest) ProtoMessage() {}

func (x *ListConnectedSiteTagsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectedSiteTagsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectedSiteTagsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{145}
}

func (x *ListConnectedSiteTagsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

// Response message for ListConnectedSiteTags RPC.
type ListConnectedSiteTagsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The site tags for the Universal Analytics property. A maximum of 20
	// connected site tags will be returned.
	ConnectedSiteTags []*ConnectedSiteTag `protobuf:"bytes,1,rep,name=connected_site_tags,json=connectedSiteTags,proto3" json:"connected_site_tags,omitempty"`
}

func (x *ListConnectedSiteTagsResponse) Reset() {
	*x = ListConnectedSiteTagsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectedSiteTagsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectedSiteTagsResponse) ProtoMessage() {}

func (x *ListConnectedSiteTagsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectedSiteTagsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectedSiteTagsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{146}
}

func (x *ListConnectedSiteTagsResponse) GetConnectedSiteTags() []*ConnectedSiteTag {
	if x != nil {
		return x.ConnectedSiteTags
	}
	return nil
}

// Request message to be passed to CreateAdSenseLink method.
type CreateAdSenseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property for which to create an AdSense Link.
	// Format: properties/{propertyId}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The AdSense Link to create
	AdsenseLink *AdSenseLink `protobuf:"bytes,2,opt,name=adsense_link,json=adsenseLink,proto3" json:"adsense_link,omitempty"`
}

func (x *CreateAdSenseLinkRequest) Reset() {
	*x = CreateAdSenseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[147]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAdSenseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAdSenseLinkRequest) ProtoMessage() {}

func (x *CreateAdSenseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[147]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAdSenseLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateAdSenseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{147}
}

func (x *CreateAdSenseLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAdSenseLinkRequest) GetAdsenseLink() *AdSenseLink {
	if x != nil {
		return x.AdsenseLink
	}
	return nil
}

// Request message to be passed to GetAdSenseLink method.
type GetAdSenseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique identifier for the AdSense Link requested.
	// Format: properties/{propertyId}/adSenseLinks/{linkId}
	// Example: properties/1234/adSenseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAdSenseLinkRequest) Reset() {
	*x = GetAdSenseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[148]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAdSenseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAdSenseLinkRequest) ProtoMessage() {}

func (x *GetAdSenseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[148]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAdSenseLinkRequest.ProtoReflect.Descriptor instead.
func (*GetAdSenseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{148}
}

func (x *GetAdSenseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to be passed to DeleteAdSenseLink method.
type DeleteAdSenseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique identifier for the AdSense Link to be deleted.
	// Format: properties/{propertyId}/adSenseLinks/{linkId}
	// Example: properties/1234/adSenseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAdSenseLinkRequest) Reset() {
	*x = DeleteAdSenseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[149]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAdSenseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAdSenseLinkRequest) ProtoMessage() {}

func (x *DeleteAdSenseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[149]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAdSenseLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteAdSenseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{149}
}

func (x *DeleteAdSenseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to be passed to ListAdSenseLinks method.
type ListAdSenseLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent property.
	// Format: properties/{propertyId}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token received from a previous `ListAdSenseLinks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAdSenseLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAdSenseLinksRequest) Reset() {
	*x = ListAdSenseLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[150]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdSenseLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdSenseLinksRequest) ProtoMessage() {}

func (x *ListAdSenseLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[150]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdSenseLinksRequest.ProtoReflect.Descriptor instead.
func (*ListAdSenseLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{150}
}

func (x *ListAdSenseLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAdSenseLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAdSenseLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAdSenseLinks method.
type ListAdSenseLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of AdSenseLinks.
	AdsenseLinks []*AdSenseLink `protobuf:"bytes,1,rep,name=adsense_links,json=adsenseLinks,proto3" json:"adsense_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAdSenseLinksResponse) Reset() {
	*x = ListAdSenseLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdSenseLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdSenseLinksResponse) ProtoMessage() {}

func (x *ListAdSenseLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdSenseLinksResponse.ProtoReflect.Descriptor instead.
func (*ListAdSenseLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{151}
}

func (x *ListAdSenseLinksResponse) GetAdsenseLinks() []*AdSenseLink {
	if x != nil {
		return x.AdsenseLinks
	}
	return nil
}

func (x *ListAdSenseLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for looking up GA4 property connected to a UA property.
type FetchConnectedGa4PropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The UA property for which to look up the connected GA4 property.
	// Note this request uses the
	// internal property ID, not the tracking ID of the form UA-XXXXXX-YY.
	// Format: properties/{internal_web_property_id}
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *FetchConnectedGa4PropertyRequest) Reset() {
	*x = FetchConnectedGa4PropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchConnectedGa4PropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchConnectedGa4PropertyRequest) ProtoMessage() {}

func (x *FetchConnectedGa4PropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchConnectedGa4PropertyRequest.ProtoReflect.Descriptor instead.
func (*FetchConnectedGa4PropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{152}
}

func (x *FetchConnectedGa4PropertyRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

// Response for looking up GA4 property connected to a UA property.
type FetchConnectedGa4PropertyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GA4 property connected to the UA property. An empty string is returned
	// when there is no connected GA4 property.
	// Format: properties/{property_id}
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *FetchConnectedGa4PropertyResponse) Reset() {
	*x = FetchConnectedGa4PropertyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchConnectedGa4PropertyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchConnectedGa4PropertyResponse) ProtoMessage() {}

func (x *FetchConnectedGa4PropertyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchConnectedGa4PropertyResponse.ProtoReflect.Descriptor instead.
func (*FetchConnectedGa4PropertyResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{153}
}

func (x *FetchConnectedGa4PropertyResponse) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

// Request message for CreateEventCreateRule RPC.
type CreateEventCreateRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/123/dataStreams/456
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The EventCreateRule to create.
	EventCreateRule *EventCreateRule `protobuf:"bytes,2,opt,name=event_create_rule,json=eventCreateRule,proto3" json:"event_create_rule,omitempty"`
}

func (x *CreateEventCreateRuleRequest) Reset() {
	*x = CreateEventCreateRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[154]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEventCreateRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEventCreateRuleRequest) ProtoMessage() {}

func (x *CreateEventCreateRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[154]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEventCreateRuleRequest.ProtoReflect.Descriptor instead.
func (*CreateEventCreateRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{154}
}

func (x *CreateEventCreateRuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEventCreateRuleRequest) GetEventCreateRule() *EventCreateRule {
	if x != nil {
		return x.EventCreateRule
	}
	return nil
}

// Request message for UpdateEventCreateRule RPC.
type UpdateEventCreateRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The EventCreateRule to update.
	// The resource's `name` field is used to identify the EventCreateRule to be
	// updated.
	EventCreateRule *EventCreateRule `protobuf:"bytes,1,opt,name=event_create_rule,json=eventCreateRule,proto3" json:"event_create_rule,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake
	// case (e.g., "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEventCreateRuleRequest) Reset() {
	*x = UpdateEventCreateRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEventCreateRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEventCreateRuleRequest) ProtoMessage() {}

func (x *UpdateEventCreateRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEventCreateRuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateEventCreateRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{155}
}

func (x *UpdateEventCreateRuleRequest) GetEventCreateRule() *EventCreateRule {
	if x != nil {
		return x.EventCreateRule
	}
	return nil
}

func (x *UpdateEventCreateRuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteEventCreateRule RPC.
type DeleteEventCreateRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format:
	// properties/123/dataStreams/456/eventCreateRules/789
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEventCreateRuleRequest) Reset() {
	*x = DeleteEventCreateRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEventCreateRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEventCreateRuleRequest) ProtoMessage() {}

func (x *DeleteEventCreateRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEventCreateRuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteEventCreateRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{156}
}

func (x *DeleteEventCreateRuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetEventCreateRule RPC.
type GetEventCreateRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EventCreateRule to get.
	// Example format: properties/123/dataStreams/456/eventCreateRules/789
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEventCreateRuleRequest) Reset() {
	*x = GetEventCreateRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEventCreateRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEventCreateRuleRequest) ProtoMessage() {}

func (x *GetEventCreateRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEventCreateRuleRequest.ProtoReflect.Descriptor instead.
func (*GetEventCreateRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{157}
}

func (x *GetEventCreateRuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListEventCreateRules RPC.
type ListEventCreateRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/123/dataStreams/456
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListEventCreateRules` call. Provide
	// this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListEventCreateRules`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEventCreateRulesRequest) Reset() {
	*x = ListEventCreateRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventCreateRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventCreateRulesRequest) ProtoMessage() {}

func (x *ListEventCreateRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventCreateRulesRequest.ProtoReflect.Descriptor instead.
func (*ListEventCreateRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{158}
}

func (x *ListEventCreateRulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEventCreateRulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEventCreateRulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListEventCreateRules RPC.
type ListEventCreateRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of EventCreateRules. These will be ordered stably, but in an arbitrary
	// order.
	EventCreateRules []*EventCreateRule `protobuf:"bytes,1,rep,name=event_create_rules,json=eventCreateRules,proto3" json:"event_create_rules,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEventCreateRulesResponse) Reset() {
	*x = ListEventCreateRulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[159]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventCreateRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventCreateRulesResponse) ProtoMessage() {}

func (x *ListEventCreateRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[159]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventCreateRulesResponse.ProtoReflect.Descriptor instead.
func (*ListEventCreateRulesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{159}
}

func (x *ListEventCreateRulesResponse) GetEventCreateRules() []*EventCreateRule {
	if x != nil {
		return x.EventCreateRules
	}
	return nil
}

func (x *ListEventCreateRulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateRollupProperty RPC.
type CreateRollupPropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The roll-up property to create.
	RollupProperty *Property `protobuf:"bytes,1,opt,name=rollup_property,json=rollupProperty,proto3" json:"rollup_property,omitempty"`
	// Optional. The resource names of properties that will be sources to the
	// created roll-up property.
	SourceProperties []string `protobuf:"bytes,2,rep,name=source_properties,json=sourceProperties,proto3" json:"source_properties,omitempty"`
}

func (x *CreateRollupPropertyRequest) Reset() {
	*x = CreateRollupPropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[160]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRollupPropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRollupPropertyRequest) ProtoMessage() {}

func (x *CreateRollupPropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[160]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRollupPropertyRequest.ProtoReflect.Descriptor instead.
func (*CreateRollupPropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{160}
}

func (x *CreateRollupPropertyRequest) GetRollupProperty() *Property {
	if x != nil {
		return x.RollupProperty
	}
	return nil
}

func (x *CreateRollupPropertyRequest) GetSourceProperties() []string {
	if x != nil {
		return x.SourceProperties
	}
	return nil
}

// Response message for CreateRollupProperty RPC.
type CreateRollupPropertyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created roll-up property.
	RollupProperty *Property `protobuf:"bytes,1,opt,name=rollup_property,json=rollupProperty,proto3" json:"rollup_property,omitempty"`
	// The created roll-up property source links.
	RollupPropertySourceLinks []*RollupPropertySourceLink `protobuf:"bytes,2,rep,name=rollup_property_source_links,json=rollupPropertySourceLinks,proto3" json:"rollup_property_source_links,omitempty"`
}

func (x *CreateRollupPropertyResponse) Reset() {
	*x = CreateRollupPropertyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[161]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRollupPropertyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRollupPropertyResponse) ProtoMessage() {}

func (x *CreateRollupPropertyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[161]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRollupPropertyResponse.ProtoReflect.Descriptor instead.
func (*CreateRollupPropertyResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{161}
}

func (x *CreateRollupPropertyResponse) GetRollupProperty() *Property {
	if x != nil {
		return x.RollupProperty
	}
	return nil
}

func (x *CreateRollupPropertyResponse) GetRollupPropertySourceLinks() []*RollupPropertySourceLink {
	if x != nil {
		return x.RollupPropertySourceLinks
	}
	return nil
}

// Request message for GetRollupPropertySourceLink RPC.
type GetRollupPropertySourceLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the roll-up property source link to lookup.
	// Format:
	// properties/{property_id}/rollupPropertySourceLinks/{rollup_property_source_link_id}
	// Example: properties/123/rollupPropertySourceLinks/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRollupPropertySourceLinkRequest) Reset() {
	*x = GetRollupPropertySourceLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[162]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRollupPropertySourceLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRollupPropertySourceLinkRequest) ProtoMessage() {}

func (x *GetRollupPropertySourceLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[162]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRollupPropertySourceLinkRequest.ProtoReflect.Descriptor instead.
func (*GetRollupPropertySourceLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{162}
}

func (x *GetRollupPropertySourceLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListRollupPropertySourceLinks RPC.
type ListRollupPropertySourceLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the roll-up property to list roll-up property source
	// links under. Format: properties/{property_id} Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `ListRollupPropertySourceLinks` call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// `ListRollupPropertySourceLinks` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRollupPropertySourceLinksRequest) Reset() {
	*x = ListRollupPropertySourceLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[163]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRollupPropertySourceLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRollupPropertySourceLinksRequest) ProtoMessage() {}

func (x *ListRollupPropertySourceLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[163]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRollupPropertySourceLinksRequest.ProtoReflect.Descriptor instead.
func (*ListRollupPropertySourceLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{163}
}

func (x *ListRollupPropertySourceLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRollupPropertySourceLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRollupPropertySourceLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListRollupPropertySourceLinks RPC.
type ListRollupPropertySourceLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of RollupPropertySourceLinks.
	RollupPropertySourceLinks []*RollupPropertySourceLink `protobuf:"bytes,1,rep,name=rollup_property_source_links,json=rollupPropertySourceLinks,proto3" json:"rollup_property_source_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRollupPropertySourceLinksResponse) Reset() {
	*x = ListRollupPropertySourceLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRollupPropertySourceLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRollupPropertySourceLinksResponse) ProtoMessage() {}

func (x *ListRollupPropertySourceLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRollupPropertySourceLinksResponse.ProtoReflect.Descriptor instead.
func (*ListRollupPropertySourceLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{164}
}

func (x *ListRollupPropertySourceLinksResponse) GetRollupPropertySourceLinks() []*RollupPropertySourceLink {
	if x != nil {
		return x.RollupPropertySourceLinks
	}
	return nil
}

func (x *ListRollupPropertySourceLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateRollupPropertySourceLink RPC.
type CreateRollupPropertySourceLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The roll-up property source link to create.
	RollupPropertySourceLink *RollupPropertySourceLink `protobuf:"bytes,2,opt,name=rollup_property_source_link,json=rollupPropertySourceLink,proto3" json:"rollup_property_source_link,omitempty"`
}

func (x *CreateRollupPropertySourceLinkRequest) Reset() {
	*x = CreateRollupPropertySourceLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[165]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRollupPropertySourceLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRollupPropertySourceLinkRequest) ProtoMessage() {}

func (x *CreateRollupPropertySourceLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[165]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRollupPropertySourceLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateRollupPropertySourceLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{165}
}

func (x *CreateRollupPropertySourceLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRollupPropertySourceLinkRequest) GetRollupPropertySourceLink() *RollupPropertySourceLink {
	if x != nil {
		return x.RollupPropertySourceLink
	}
	return nil
}

// Request message for DeleteRollupPropertySourceLink RPC.
type DeleteRollupPropertySourceLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// properties/{property_id}/rollupPropertySourceLinks/{rollup_property_source_link_id}
	// Example: properties/1234/rollupPropertySourceLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRollupPropertySourceLinkRequest) Reset() {
	*x = DeleteRollupPropertySourceLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[166]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRollupPropertySourceLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRollupPropertySourceLinkRequest) ProtoMessage() {}

func (x *DeleteRollupPropertySourceLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[166]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRollupPropertySourceLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteRollupPropertySourceLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{166}
}

func (x *DeleteRollupPropertySourceLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateSubproperty RPC.
type CreateSubpropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ordinary property for which to create a subproperty.
	// Format: properties/property_id
	// Example: properties/123
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The subproperty to create.
	Subproperty *Property `protobuf:"bytes,2,opt,name=subproperty,proto3" json:"subproperty,omitempty"`
	// Optional. The subproperty event filter to create on an ordinary property.
	SubpropertyEventFilter *SubpropertyEventFilter `protobuf:"bytes,3,opt,name=subproperty_event_filter,json=subpropertyEventFilter,proto3" json:"subproperty_event_filter,omitempty"`
}

func (x *CreateSubpropertyRequest) Reset() {
	*x = CreateSubpropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[167]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSubpropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSubpropertyRequest) ProtoMessage() {}

func (x *CreateSubpropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[167]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSubpropertyRequest.ProtoReflect.Descriptor instead.
func (*CreateSubpropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{167}
}

func (x *CreateSubpropertyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSubpropertyRequest) GetSubproperty() *Property {
	if x != nil {
		return x.Subproperty
	}
	return nil
}

func (x *CreateSubpropertyRequest) GetSubpropertyEventFilter() *SubpropertyEventFilter {
	if x != nil {
		return x.SubpropertyEventFilter
	}
	return nil
}

// Response message for CreateSubproperty RPC.
type CreateSubpropertyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created subproperty.
	Subproperty *Property `protobuf:"bytes,1,opt,name=subproperty,proto3" json:"subproperty,omitempty"`
	// The created subproperty event filter.
	SubpropertyEventFilter *SubpropertyEventFilter `protobuf:"bytes,2,opt,name=subproperty_event_filter,json=subpropertyEventFilter,proto3" json:"subproperty_event_filter,omitempty"`
}

func (x *CreateSubpropertyResponse) Reset() {
	*x = CreateSubpropertyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[168]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSubpropertyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSubpropertyResponse) ProtoMessage() {}

func (x *CreateSubpropertyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[168]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSubpropertyResponse.ProtoReflect.Descriptor instead.
func (*CreateSubpropertyResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{168}
}

func (x *CreateSubpropertyResponse) GetSubproperty() *Property {
	if x != nil {
		return x.Subproperty
	}
	return nil
}

func (x *CreateSubpropertyResponse) GetSubpropertyEventFilter() *SubpropertyEventFilter {
	if x != nil {
		return x.SubpropertyEventFilter
	}
	return nil
}

// Request message for CreateSubpropertyEventFilter RPC.
type CreateSubpropertyEventFilterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ordinary property for which to create a subproperty event
	// filter. Format: properties/property_id Example: properties/123
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The subproperty event filter to create.
	SubpropertyEventFilter *SubpropertyEventFilter `protobuf:"bytes,2,opt,name=subproperty_event_filter,json=subpropertyEventFilter,proto3" json:"subproperty_event_filter,omitempty"`
}

func (x *CreateSubpropertyEventFilterRequest) Reset() {
	*x = CreateSubpropertyEventFilterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[169]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSubpropertyEventFilterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSubpropertyEventFilterRequest) ProtoMessage() {}

func (x *CreateSubpropertyEventFilterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[169]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSubpropertyEventFilterRequest.ProtoReflect.Descriptor instead.
func (*CreateSubpropertyEventFilterRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{169}
}

func (x *CreateSubpropertyEventFilterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSubpropertyEventFilterRequest) GetSubpropertyEventFilter() *SubpropertyEventFilter {
	if x != nil {
		return x.SubpropertyEventFilter
	}
	return nil
}

// Request message for GetSubpropertyEventFilter RPC.
type GetSubpropertyEventFilterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the subproperty event filter to lookup.
	// Format:
	// properties/property_id/subpropertyEventFilters/subproperty_event_filter
	// Example: properties/123/subpropertyEventFilters/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSubpropertyEventFilterRequest) Reset() {
	*x = GetSubpropertyEventFilterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[170]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSubpropertyEventFilterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSubpropertyEventFilterRequest) ProtoMessage() {}

func (x *GetSubpropertyEventFilterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[170]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSubpropertyEventFilterRequest.ProtoReflect.Descriptor instead.
func (*GetSubpropertyEventFilterRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{170}
}

func (x *GetSubpropertyEventFilterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListSubpropertyEventFilters RPC.
type ListSubpropertyEventFiltersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the ordinary property.
	// Format: properties/property_id
	// Example: properties/123
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages. If unspecified,
	// at most 50 resources will be returned. The maximum value is 200; (higher
	// values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `ListSubpropertyEventFilters` call. Provide this to retrieve the subsequent
	// page. When paginating, all other parameters provided to
	// `ListSubpropertyEventFilters` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubpropertyEventFiltersRequest) Reset() {
	*x = ListSubpropertyEventFiltersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[171]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubpropertyEventFiltersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubpropertyEventFiltersRequest) ProtoMessage() {}

func (x *ListSubpropertyEventFiltersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[171]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubpropertyEventFiltersRequest.ProtoReflect.Descriptor instead.
func (*ListSubpropertyEventFiltersRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{171}
}

func (x *ListSubpropertyEventFiltersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSubpropertyEventFiltersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubpropertyEventFiltersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListSubpropertyEventFilter RPC.
type ListSubpropertyEventFiltersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of subproperty event filters.
	SubpropertyEventFilters []*SubpropertyEventFilter `protobuf:"bytes,1,rep,name=subproperty_event_filters,json=subpropertyEventFilters,proto3" json:"subproperty_event_filters,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSubpropertyEventFiltersResponse) Reset() {
	*x = ListSubpropertyEventFiltersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[172]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubpropertyEventFiltersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubpropertyEventFiltersResponse) ProtoMessage() {}

func (x *ListSubpropertyEventFiltersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[172]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubpropertyEventFiltersResponse.ProtoReflect.Descriptor instead.
func (*ListSubpropertyEventFiltersResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{172}
}

func (x *ListSubpropertyEventFiltersResponse) GetSubpropertyEventFilters() []*SubpropertyEventFilter {
	if x != nil {
		return x.SubpropertyEventFilters
	}
	return nil
}

func (x *ListSubpropertyEventFiltersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateSubpropertyEventFilter RPC.
type UpdateSubpropertyEventFilterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subproperty event filter to update.
	SubpropertyEventFilter *SubpropertyEventFilter `protobuf:"bytes,1,opt,name=subproperty_event_filter,json=subpropertyEventFilter,proto3" json:"subproperty_event_filter,omitempty"`
	// Required. The list of fields to update. Field names must be in snake case
	// (for example, "field_to_update"). Omitted fields will not be updated. To
	// replace the entire entity, use one path with the string "*" to match all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSubpropertyEventFilterRequest) Reset() {
	*x = UpdateSubpropertyEventFilterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[173]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSubpropertyEventFilterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubpropertyEventFilterRequest) ProtoMessage() {}

func (x *UpdateSubpropertyEventFilterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[173]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubpropertyEventFilterRequest.ProtoReflect.Descriptor instead.
func (*UpdateSubpropertyEventFilterRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{173}
}

func (x *UpdateSubpropertyEventFilterRequest) GetSubpropertyEventFilter() *SubpropertyEventFilter {
	if x != nil {
		return x.SubpropertyEventFilter
	}
	return nil
}

func (x *UpdateSubpropertyEventFilterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteSubpropertyEventFilter RPC.
type DeleteSubpropertyEventFilterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the subproperty event filter to delete.
	// Format:
	// properties/property_id/subpropertyEventFilters/subproperty_event_filter
	// Example: properties/123/subpropertyEventFilters/456
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSubpropertyEventFilterRequest) Reset() {
	*x = DeleteSubpropertyEventFilterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[174]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSubpropertyEventFilterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSubpropertyEventFilterRequest) ProtoMessage() {}

func (x *DeleteSubpropertyEventFilterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[174]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSubpropertyEventFilterRequest.ProtoReflect.Descriptor instead.
func (*DeleteSubpropertyEventFilterRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP(), []int{174}
}

func (x *DeleteSubpropertyEventFilterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_analytics_admin_v1alpha_analytics_admin_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x65,
	0x64, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x05, 0x0a, 0x16, 0x52, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x50, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x12, 0x61, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x5b, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x4a, 0x0a, 0x09,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x41, 0x6c, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x22, 0xf7, 0x02, 0x0a, 0x17, 0x52, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x62, 0x0a, 0x11, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x59, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3d,
	0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x22, 0x56, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b,
	0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x59, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a,
	0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x85, 0x01, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x22, 0x4c, 0x0a, 0x1e, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63,
	0x6b, 0x65, 0x74, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x93, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x48, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x62, 0x0a, 0x15, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x5b, 0x0a,
	0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x19, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x63, 0x0a, 0x19,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x46,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x62, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5a, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xb5, 0x01,
	0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x57, 0x0a, 0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x59, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5b, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x10, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x24, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x2d, 0x0a, 0x0f, 0x61, 0x63, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x27, 0x0a, 0x25, 0x41, 0x63, 0x6b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xf3, 0x04, 0x0a, 0x20, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x47, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x51, 0x0a, 0x14, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12,
	0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb3, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a,
	0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7a, 0x0a,
	0x23, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x26, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x7e, 0x0a,
	0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x19, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x7d, 0x0a,
	0x26, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xea, 0x01, 0x0a,
	0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7e, 0x0a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbc, 0x01, 0x0a, 0x25, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x26, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x7b, 0x0a, 0x1c, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x52, 0x1a, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88, 0x01, 0x0a, 0x2a, 0x47, 0x65, 0x74,
	0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x0a, 0x3e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x4b, 0x41,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa6, 0x02, 0x0a, 0x2d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x4b,
	0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x12, 0x3e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x4b, 0x41,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x94, 0x01, 0x0a, 0x23, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x73, 0x6b, 0x61, 0x64,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x8b, 0x01, 0x0a,
	0x2d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x40, 0x0a, 0x3e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x02, 0x0a, 0x2d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x94, 0x01, 0x0a,
	0x23, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x4b, 0x41, 0x64,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x20, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xca, 0x01, 0x0a, 0x2c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x4b,
	0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x12, 0x3e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x4b,
	0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xeb, 0x01, 0x0a, 0x2d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x4b, 0x41, 0x64, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x24, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x21, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x72, 0x0a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0xce, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x22, 0xc1, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x69,
	0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x27,
	0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xc4, 0x01, 0x0a, 0x29, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x12, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe0, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x1e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x02, 0x0a, 0x2a, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x3d, 0x12, 0x3b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x85, 0x01, 0x0a, 0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf8, 0x01,
	0x0a, 0x2a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x87, 0x01, 0x0a,
	0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33,
	0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x92, 0x01, 0x0a, 0x2f, 0x47, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01,
	0x0a, 0x31, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x12, 0x43, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x02, 0x0a, 0x32, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x2b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36,
	0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x26, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc1, 0x02, 0x0a, 0x32, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x63, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x12, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xa5, 0x01, 0x0a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x25, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x95, 0x01, 0x0a,
	0x32, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x33, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x45, 0x0a, 0x43, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x01,
	0x0a, 0x34, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x22, 0x95, 0x01, 0x0a, 0x32, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x4b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x45, 0x0a, 0x43, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x68, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xaa, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64,
	0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x61, 0x0a, 0x14, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f,
	0x33, 0x36, 0x30, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x11, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd5, 0x01, 0x0a,
	0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73,
	0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33,
	0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x64,
	0x0a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30,
	0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x6b, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xc2, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64,
	0x73, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xce, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12,
	0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6a, 0x0a, 0x1d, 0x41, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a,
	0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0xb0,
	0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x64, 0x0a, 0x1a, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x02, 0x0a, 0x1d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x63,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x49, 0x64, 0x12, 0x62, 0x0a, 0x11, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0xc5, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x11, 0x63, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6b,
	0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x11, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x68, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x30, 0x0a, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35,
	0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x22,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x72, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x15, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x22, 0x5f, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9e, 0x01, 0x0a,
	0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12,
	0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x5c, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x58,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x61, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xaa, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x49, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xa4, 0x01, 0x0a,
	0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x5c, 0x0a, 0x16, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xd1, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x62, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x1d, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x05, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x22, 0x78, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xa4, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xc4, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x59, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xcc, 0x01, 0x0a, 0x20, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x7b, 0x0a, 0x21, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56,
	0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x77, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22,
	0xcc, 0x01, 0x0a, 0x20, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5b, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x7b,
	0x0a, 0x21, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x65, 0x0a, 0x1a, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xcc, 0x01, 0x0a, 0x20, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12,
	0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x22, 0xcf, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x61,
	0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x65, 0x74, 0x22, 0xc2, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x69, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1b,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x61, 0x6e,
	0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x65, 0x74, 0x52, 0x10, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbf,
	0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x22, 0xb5, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56,
	0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x63, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x65, 0x0a, 0x29, 0x53, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47,
	0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x17, 0x0a,
	0x07, 0x6f, 0x70, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x6f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x22, 0x2c, 0x0a, 0x2a, 0x53, 0x65, 0x74, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x0a, 0x2b, 0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x22, 0x47, 0x0a, 0x2c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x6f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x22, 0x60, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x7e, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x41, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3b, 0x0a, 0x39,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xf3, 0x01, 0x0a, 0x28, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x84, 0x01, 0x0a,
	0x1d, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1b, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x22, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x72, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa0, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x22, 0x20, 0x0a, 0x1e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x0a, 0x1d, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x15, 0x0a, 0x06, 0x74, 0x61, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x67, 0x49, 0x64, 0x22,
	0x3a, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x81, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74,
	0x65, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a,
	0x13, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x73, 0x22,
	0xba, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0c, 0x61, 0x64, 0x73, 0x65, 0x6e,
	0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5e, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x53, 0x65, 0x6e,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x61, 0x0a, 0x18,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64,
	0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa0, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2b, 0x12, 0x29, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x50, 0x0a, 0x0d, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x0c, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6e, 0x0a, 0x20, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x6c, 0x0a, 0x21, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0xcf, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x1c, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x69,
	0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa5, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a,
	0x12, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x10, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x6f,
	0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x30, 0x0a, 0x11,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xec,
	0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x51, 0x0a, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x79, 0x0a, 0x1c, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x19, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x78, 0x0a,
	0x22, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x38, 0x0a, 0x36, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x56, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x38, 0x12, 0x36, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xca,
	0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x79, 0x0a, 0x1c, 0x72, 0x6f, 0x6c, 0x6c,
	0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x19, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xfd, 0x01, 0x0a, 0x25,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x38, 0x12, 0x36, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c,
	0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x7c, 0x0a,
	0x1b, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x18, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x7b, 0x0a, 0x25, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x38, 0x0a, 0x36, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a,
	0x0b, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x75,
	0x0a, 0x18, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd9, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x70, 0x0a, 0x18, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x16, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0xf2, 0x01, 0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x36, 0x12, 0x34, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x75, 0x0a, 0x18, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16,
	0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x74, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x36,
	0x0a, 0x34, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x01, 0x0a,
	0x22, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x36, 0x12, 0x34, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xc1, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x72, 0x0a, 0x19, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x17, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75,
	0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x75, 0x0a, 0x18, 0x73,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x73, 0x75, 0x62, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x77, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75,
	0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x36, 0x0a, 0x34, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xe3, 0xf7,
	0x01, 0x0a, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x93, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x29, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x94,
	0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x13, 0x12, 0x11, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x29, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1c, 0x2a, 0x1a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xb9, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x49, 0xda, 0x41, 0x13, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x3a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x32, 0x22, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a,
	0x16, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x3a, 0x01,
	0x2a, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x12, 0xb4, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x22, 0x2b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12,
	0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c, 0x01,
	0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0xa3, 0x01, 0x0a,
	0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x22, 0x30, 0xda, 0x41, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1f, 0x3a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x13, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x9e, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x2a, 0x1c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc1, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x4e, 0xda, 0x41, 0x14, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x32, 0x25, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5a, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0xa4, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x47, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a,
	0x12, 0x38, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x13, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5f, 0xda,
	0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22,
	0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xf6,
	0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x22, 0x74, 0xda, 0x41, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa7, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f,
	0x12, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0xcb, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x3d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61,
	0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xf6, 0x01,
	0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x56,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x89, 0x02, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x12, 0xb8, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x91, 0x01, 0xda, 0x41, 0x22, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0xd9, 0x01,
	0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x2a, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda, 0x02, 0x0a, 0x1f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x22, 0xb3, 0x01, 0xda, 0x41, 0x27, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x82, 0x01, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x32, 0x63, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf7, 0x01, 0x0a, 0x1d, 0x41, 0x63, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a,
	0x22, 0x3e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x91, 0x02, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x4b, 0x41,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x5c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x02, 0x0a, 0x26, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x22, 0xa7, 0x01, 0xda, 0x41, 0x2a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6b, 0x61,
	0x64, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74, 0x3a, 0x23, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x4d, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x4b, 0x41, 0x64, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0xed, 0x01, 0x0a, 0x26, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x4b, 0x41,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5c, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x2a, 0x4d, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x2a, 0x7d, 0x12, 0x8d, 0x03, 0x0a, 0x26, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x4b, 0x41,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0xd1, 0x01, 0xda, 0x41, 0x2f, 0x73, 0x6b, 0x61, 0x64,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x98, 0x01, 0x3a, 0x23, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x32, 0x71, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x73, 0x6b, 0x61, 0x64, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x2a, 0x7d, 0x12, 0xa4, 0x02, 0x0a, 0x25, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x4b, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0xe4, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22,
	0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xd5, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x41, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d,
	0x12, 0xac, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x91, 0x01, 0xda, 0x41,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x3a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x32, 0x4a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12,
	0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x63, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x10, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x2f, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x81, 0x02,
	0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x79, 0xda, 0x41, 0x1c, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a, 0x10, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x32,
	0x40, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xf8, 0x01, 0x0a, 0x20, 0x47,
	0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8b, 0x02, 0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x49, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0xc6, 0x02, 0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x93, 0x01, 0xda, 0x41, 0x28, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x62, 0x3a, 0x21, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x3d, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xd7, 0x01, 0x0a,
	0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xee, 0x02, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30,
	0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xbb, 0x01, 0xda, 0x41, 0x2d, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30,
	0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x84, 0x01, 0x3a, 0x21, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x32, 0x5f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x02, 0x0a, 0x28, 0x47, 0x65, 0x74, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x12, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x54, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xab, 0x02, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x73, 0x12, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73,
	0x12, 0xf8, 0x02, 0x0a, 0x2b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x12, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0xad, 0x01, 0xda, 0x41,
	0x31, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x73, 0x3a, 0x2a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0xef, 0x01, 0x0a, 0x2b,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33,
	0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x54, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x2a, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb3, 0x02,
	0x0a, 0x2c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x53,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36,
	0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x12, 0xa1, 0x02, 0x0a, 0x2b, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x12, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x57,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x33, 0x36, 0x30, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x63, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x43, 0x3a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x81, 0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x79,
	0xda, 0x41, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0xba, 0x01, 0x0a, 0x16, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0xc0, 0x01, 0x0a,
	0x12, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22,
	0x5a, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x2c, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0xec, 0x01, 0x0a, 0x12,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x6d, 0xda, 0x41, 0x19,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a,
	0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x32, 0x3a,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0xb1, 0x01, 0x0a, 0x13, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a,
	0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x22, 0x3b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd5, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xac, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0x91, 0x01, 0xda, 0x41, 0x23, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x65, 0x3a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x4a, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xcd, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x22, 0x54, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x9e, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x39, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x22, 0x65, 0xda, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x45, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x32, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbf, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x0d, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x39,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa4, 0x01, 0x0a, 0x0b, 0x47, 0x65,
	0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xb7, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x39, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a,
	0x12, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xbf, 0x01, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x4c,
	0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x3a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xcd, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x22, 0x5a, 0xda, 0x41, 0x14, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a,
	0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x32, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9e, 0x01, 0x0a,
	0x0f, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x01, 0x2a, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0xc4, 0x01,
	0x0a, 0x13, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36,
	0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd7, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xf5,
	0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x6a, 0xda, 0x41, 0x1a, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73,
	0x5f, 0x33, 0x36, 0x30, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a,
	0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36,
	0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xb0, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36,
	0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8f, 0x02, 0x0a, 0x16, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x33, 0x36,
	0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x83, 0x01, 0xda, 0x41, 0x1f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b,
	0x3a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x33, 0x36, 0x30, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73,
	0x33, 0x36, 0x30, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcd, 0x01, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0x9b, 0x02, 0x0a, 0x19,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x86, 0x01, 0xda, 0x41, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x14, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x32, 0x45, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xf0, 0x01, 0x0a, 0x0f, 0x52, 0x75,
	0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52,
	0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x3a, 0x01, 0x2a, 0x5a, 0x31, 0x3a, 0x01, 0x2a, 0x22, 0x2c,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x2e, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x9f, 0x02, 0x0a,
	0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22,
	0x9c, 0x01, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7e,
	0x3a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5a, 0x3f, 0x3a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xe7,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x6b, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x2b, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xb4, 0x01, 0xda, 0x41,
	0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x9c, 0x01, 0x3a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5a, 0x4e, 0x3a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x3c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x6b,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x5a, 0x2f, 0x2a,
	0x2d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x2b,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6d, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2b, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xa5, 0x02, 0x0a, 0x19, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x82, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x7c, 0x3a, 0x01, 0x2a, 0x5a, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x12, 0x8f, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x76, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x70, 0x5a, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x12, 0x34, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47,
	0x65, 0x74, 0x12, 0xa5, 0x02, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7c, 0x3a, 0x01,
	0x2a, 0x5a, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0xfa, 0x01, 0x0a, 0x19, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7c, 0x3a, 0x01, 0x2a, 0x5a, 0x3e,
	0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x37,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x45,
	0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e,
	0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12,
	0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73,
	0x12, 0xed, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e,
	0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x22, 0x65, 0xda, 0x41, 0x18, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x11, 0x65, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x22,
	0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73,
	0x12, 0x84, 0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e,
	0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x22, 0x7c, 0xda, 0x41, 0x1d, 0x65, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x56, 0x3a, 0x11, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x65, 0x74, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65,
	0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x22, 0x3b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7,
	0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xd9, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x5a, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0xec, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x22, 0x6d, 0xda, 0x41, 0x19, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xa4, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfe, 0x01, 0x0a, 0x22, 0x53,
	0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75,
	0x74, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47,
	0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65,
	0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x12, 0x86, 0x02, 0x0a, 0x24,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61,
	0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x4f, 0x75, 0x74, 0x12, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x47, 0x61, 0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x47, 0x61,
	0x34, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x4f, 0x75, 0x74, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x3b,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xfb, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x68,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x68,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x55, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x12, 0xe5, 0x02, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0xb8, 0x01, 0xda, 0x41, 0x29, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x85, 0x01, 0x3a, 0x1d, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x64, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x16,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53,
	0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x01, 0x2a,
	0x22, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0xa6, 0x01, 0x0a,
	0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x35,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x01, 0x2a, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0xca, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x3a, 0x01, 0x2a, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x73, 0x12, 0xd7, 0x01, 0x0a, 0x19, 0x46, 0x65, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x47, 0x61, 0x34, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x47, 0x61, 0x34, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x47, 0x61, 0x34, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x47, 0x61, 0x34, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0xb0, 0x01, 0x0a,
	0x0e, 0x47, 0x65, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd3, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x53,
	0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x57, 0xda, 0x41,
	0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x64, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x0c, 0x61, 0x64, 0x73, 0x65,
	0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x53, 0x65, 0x6e, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x53,
	0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x3c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0xce, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xe1, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0xfb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x73, 0xda,
	0x41, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52,
	0x3a, 0x11, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x93, 0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x8a, 0x01, 0xda, 0x41,
	0x1d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x64, 0x3a, 0x11, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x32, 0x4f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x9f, 0x01, 0xda, 0x41, 0x23, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x73,
	0x3a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x58, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x12, 0xe3, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xc4, 0x01, 0x0a, 0x13, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22,
	0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x86, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x7b, 0xda, 0x41,
	0x2d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2c, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x3a, 0x11, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0xd7, 0x01, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x88, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22,
	0x7d, 0xda, 0x41, 0x1d, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x11, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x32, 0x42, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb0,
	0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a,
	0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x6c,
	0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc6, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c,
	0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x3a, 0x01, 0x2a,
	0x22, 0x28, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c,
	0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0xe4, 0x01, 0x0a, 0x1b, 0x47,
	0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x52,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xf7, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x49, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xa6, 0x02, 0x0a, 0x1e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22,
	0x82, 0x01, 0xda, 0x41, 0x22, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x6f, 0x6c, 0x6c,
	0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x1b, 0x72,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x75,
	0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0xc8, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xba, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2a, 0x3a, 0x01, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x97, 0x02, 0x0a,
	0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x7a, 0xda, 0x41, 0x1f, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x52, 0x3a, 0x18, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x36,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x53, 0x75,
	0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x45,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xef, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75,
	0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12,
	0x36, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0xb6, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x98, 0x01, 0xda, 0x41, 0x24, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x6b, 0x3a, 0x18, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x32,
	0x4f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xc2, 0x01, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x45,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0xfc, 0x01, 0xca, 0x41, 0x1d, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xd8, 0x01, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x65, 0x64, 0x69, 0x74, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x2e, 0x75, 0x73, 0x65, 0x72,
	0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c,
	0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64,
	0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x7b, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x13, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData = file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 175)
var file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes = []interface{}{
	(*RunAccessReportRequest)(nil),                               // 0: google.analytics.admin.v1alpha.RunAccessReportRequest
	(*RunAccessReportResponse)(nil),                              // 1: google.analytics.admin.v1alpha.RunAccessReportResponse
	(*GetAccountRequest)(nil),                                    // 2: google.analytics.admin.v1alpha.GetAccountRequest
	(*ListAccountsRequest)(nil),                                  // 3: google.analytics.admin.v1alpha.ListAccountsRequest
	(*ListAccountsResponse)(nil),                                 // 4: google.analytics.admin.v1alpha.ListAccountsResponse
	(*DeleteAccountRequest)(nil),                                 // 5: google.analytics.admin.v1alpha.DeleteAccountRequest
	(*UpdateAccountRequest)(nil),                                 // 6: google.analytics.admin.v1alpha.UpdateAccountRequest
	(*ProvisionAccountTicketRequest)(nil),                        // 7: google.analytics.admin.v1alpha.ProvisionAccountTicketRequest
	(*ProvisionAccountTicketResponse)(nil),                       // 8: google.analytics.admin.v1alpha.ProvisionAccountTicketResponse
	(*GetPropertyRequest)(nil),                                   // 9: google.analytics.admin.v1alpha.GetPropertyRequest
	(*ListPropertiesRequest)(nil),                                // 10: google.analytics.admin.v1alpha.ListPropertiesRequest
	(*ListPropertiesResponse)(nil),                               // 11: google.analytics.admin.v1alpha.ListPropertiesResponse
	(*UpdatePropertyRequest)(nil),                                // 12: google.analytics.admin.v1alpha.UpdatePropertyRequest
	(*CreatePropertyRequest)(nil),                                // 13: google.analytics.admin.v1alpha.CreatePropertyRequest
	(*DeletePropertyRequest)(nil),                                // 14: google.analytics.admin.v1alpha.DeletePropertyRequest
	(*CreateFirebaseLinkRequest)(nil),                            // 15: google.analytics.admin.v1alpha.CreateFirebaseLinkRequest
	(*DeleteFirebaseLinkRequest)(nil),                            // 16: google.analytics.admin.v1alpha.DeleteFirebaseLinkRequest
	(*ListFirebaseLinksRequest)(nil),                             // 17: google.analytics.admin.v1alpha.ListFirebaseLinksRequest
	(*ListFirebaseLinksResponse)(nil),                            // 18: google.analytics.admin.v1alpha.ListFirebaseLinksResponse
	(*GetGlobalSiteTagRequest)(nil),                              // 19: google.analytics.admin.v1alpha.GetGlobalSiteTagRequest
	(*CreateGoogleAdsLinkRequest)(nil),                           // 20: google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest
	(*UpdateGoogleAdsLinkRequest)(nil),                           // 21: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest
	(*DeleteGoogleAdsLinkRequest)(nil),                           // 22: google.analytics.admin.v1alpha.DeleteGoogleAdsLinkRequest
	(*ListGoogleAdsLinksRequest)(nil),                            // 23: google.analytics.admin.v1alpha.ListGoogleAdsLinksRequest
	(*ListGoogleAdsLinksResponse)(nil),                           // 24: google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse
	(*GetDataSharingSettingsRequest)(nil),                        // 25: google.analytics.admin.v1alpha.GetDataSharingSettingsRequest
	(*ListAccountSummariesRequest)(nil),                          // 26: google.analytics.admin.v1alpha.ListAccountSummariesRequest
	(*ListAccountSummariesResponse)(nil),                         // 27: google.analytics.admin.v1alpha.ListAccountSummariesResponse
	(*AcknowledgeUserDataCollectionRequest)(nil),                 // 28: google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionRequest
	(*AcknowledgeUserDataCollectionResponse)(nil),                // 29: google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionResponse
	(*SearchChangeHistoryEventsRequest)(nil),                     // 30: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest
	(*SearchChangeHistoryEventsResponse)(nil),                    // 31: google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse
	(*GetMeasurementProtocolSecretRequest)(nil),                  // 32: google.analytics.admin.v1alpha.GetMeasurementProtocolSecretRequest
	(*CreateMeasurementProtocolSecretRequest)(nil),               // 33: google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest
	(*DeleteMeasurementProtocolSecretRequest)(nil),               // 34: google.analytics.admin.v1alpha.DeleteMeasurementProtocolSecretRequest
	(*UpdateMeasurementProtocolSecretRequest)(nil),               // 35: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest
	(*ListMeasurementProtocolSecretsRequest)(nil),                // 36: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsRequest
	(*ListMeasurementProtocolSecretsResponse)(nil),               // 37: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse
	(*GetSKAdNetworkConversionValueSchemaRequest)(nil),           // 38: google.analytics.admin.v1alpha.GetSKAdNetworkConversionValueSchemaRequest
	(*CreateSKAdNetworkConversionValueSchemaRequest)(nil),        // 39: google.analytics.admin.v1alpha.CreateSKAdNetworkConversionValueSchemaRequest
	(*DeleteSKAdNetworkConversionValueSchemaRequest)(nil),        // 40: google.analytics.admin.v1alpha.DeleteSKAdNetworkConversionValueSchemaRequest
	(*UpdateSKAdNetworkConversionValueSchemaRequest)(nil),        // 41: google.analytics.admin.v1alpha.UpdateSKAdNetworkConversionValueSchemaRequest
	(*ListSKAdNetworkConversionValueSchemasRequest)(nil),         // 42: google.analytics.admin.v1alpha.ListSKAdNetworkConversionValueSchemasRequest
	(*ListSKAdNetworkConversionValueSchemasResponse)(nil),        // 43: google.analytics.admin.v1alpha.ListSKAdNetworkConversionValueSchemasResponse
	(*GetGoogleSignalsSettingsRequest)(nil),                      // 44: google.analytics.admin.v1alpha.GetGoogleSignalsSettingsRequest
	(*UpdateGoogleSignalsSettingsRequest)(nil),                   // 45: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest
	(*CreateConversionEventRequest)(nil),                         // 46: google.analytics.admin.v1alpha.CreateConversionEventRequest
	(*UpdateConversionEventRequest)(nil),                         // 47: google.analytics.admin.v1alpha.UpdateConversionEventRequest
	(*GetConversionEventRequest)(nil),                            // 48: google.analytics.admin.v1alpha.GetConversionEventRequest
	(*DeleteConversionEventRequest)(nil),                         // 49: google.analytics.admin.v1alpha.DeleteConversionEventRequest
	(*ListConversionEventsRequest)(nil),                          // 50: google.analytics.admin.v1alpha.ListConversionEventsRequest
	(*ListConversionEventsResponse)(nil),                         // 51: google.analytics.admin.v1alpha.ListConversionEventsResponse
	(*GetDisplayVideo360AdvertiserLinkRequest)(nil),              // 52: google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkRequest
	(*ListDisplayVideo360AdvertiserLinksRequest)(nil),            // 53: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksRequest
	(*ListDisplayVideo360AdvertiserLinksResponse)(nil),           // 54: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse
	(*CreateDisplayVideo360AdvertiserLinkRequest)(nil),           // 55: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest
	(*DeleteDisplayVideo360AdvertiserLinkRequest)(nil),           // 56: google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkRequest
	(*UpdateDisplayVideo360AdvertiserLinkRequest)(nil),           // 57: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest
	(*GetDisplayVideo360AdvertiserLinkProposalRequest)(nil),      // 58: google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkProposalRequest
	(*ListDisplayVideo360AdvertiserLinkProposalsRequest)(nil),    // 59: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsRequest
	(*ListDisplayVideo360AdvertiserLinkProposalsResponse)(nil),   // 60: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse
	(*CreateDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 61: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest
	(*DeleteDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 62: google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkProposalRequest
	(*ApproveDisplayVideo360AdvertiserLinkProposalRequest)(nil),  // 63: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalRequest
	(*ApproveDisplayVideo360AdvertiserLinkProposalResponse)(nil), // 64: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse
	(*CancelDisplayVideo360AdvertiserLinkProposalRequest)(nil),   // 65: google.analytics.admin.v1alpha.CancelDisplayVideo360AdvertiserLinkProposalRequest
	(*GetSearchAds360LinkRequest)(nil),                           // 66: google.analytics.admin.v1alpha.GetSearchAds360LinkRequest
	(*ListSearchAds360LinksRequest)(nil),                         // 67: google.analytics.admin.v1alpha.ListSearchAds360LinksRequest
	(*ListSearchAds360LinksResponse)(nil),                        // 68: google.analytics.admin.v1alpha.ListSearchAds360LinksResponse
	(*CreateSearchAds360LinkRequest)(nil),                        // 69: google.analytics.admin.v1alpha.CreateSearchAds360LinkRequest
	(*DeleteSearchAds360LinkRequest)(nil),                        // 70: google.analytics.admin.v1alpha.DeleteSearchAds360LinkRequest
	(*UpdateSearchAds360LinkRequest)(nil),                        // 71: google.analytics.admin.v1alpha.UpdateSearchAds360LinkRequest
	(*CreateCustomDimensionRequest)(nil),                         // 72: google.analytics.admin.v1alpha.CreateCustomDimensionRequest
	(*UpdateCustomDimensionRequest)(nil),                         // 73: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest
	(*ListCustomDimensionsRequest)(nil),                          // 74: google.analytics.admin.v1alpha.ListCustomDimensionsRequest
	(*ListCustomDimensionsResponse)(nil),                         // 75: google.analytics.admin.v1alpha.ListCustomDimensionsResponse
	(*ArchiveCustomDimensionRequest)(nil),                        // 76: google.analytics.admin.v1alpha.ArchiveCustomDimensionRequest
	(*GetCustomDimensionRequest)(nil),                            // 77: google.analytics.admin.v1alpha.GetCustomDimensionRequest
	(*CreateCustomMetricRequest)(nil),                            // 78: google.analytics.admin.v1alpha.CreateCustomMetricRequest
	(*UpdateCustomMetricRequest)(nil),                            // 79: google.analytics.admin.v1alpha.UpdateCustomMetricRequest
	(*ListCustomMetricsRequest)(nil),                             // 80: google.analytics.admin.v1alpha.ListCustomMetricsRequest
	(*ListCustomMetricsResponse)(nil),                            // 81: google.analytics.admin.v1alpha.ListCustomMetricsResponse
	(*ArchiveCustomMetricRequest)(nil),                           // 82: google.analytics.admin.v1alpha.ArchiveCustomMetricRequest
	(*GetCustomMetricRequest)(nil),                               // 83: google.analytics.admin.v1alpha.GetCustomMetricRequest
	(*CreateCalculatedMetricRequest)(nil),                        // 84: google.analytics.admin.v1alpha.CreateCalculatedMetricRequest
	(*UpdateCalculatedMetricRequest)(nil),                        // 85: google.analytics.admin.v1alpha.UpdateCalculatedMetricRequest
	(*DeleteCalculatedMetricRequest)(nil),                        // 86: google.analytics.admin.v1alpha.DeleteCalculatedMetricRequest
	(*ListCalculatedMetricsRequest)(nil),                         // 87: google.analytics.admin.v1alpha.ListCalculatedMetricsRequest
	(*ListCalculatedMetricsResponse)(nil),                        // 88: google.analytics.admin.v1alpha.ListCalculatedMetricsResponse
	(*GetCalculatedMetricRequest)(nil),                           // 89: google.analytics.admin.v1alpha.GetCalculatedMetricRequest
	(*GetDataRetentionSettingsRequest)(nil),                      // 90: google.analytics.admin.v1alpha.GetDataRetentionSettingsRequest
	(*UpdateDataRetentionSettingsRequest)(nil),                   // 91: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest
	(*CreateDataStreamRequest)(nil),                              // 92: google.analytics.admin.v1alpha.CreateDataStreamRequest
	(*DeleteDataStreamRequest)(nil),                              // 93: google.analytics.admin.v1alpha.DeleteDataStreamRequest
	(*UpdateDataStreamRequest)(nil),                              // 94: google.analytics.admin.v1alpha.UpdateDataStreamRequest
	(*ListDataStreamsRequest)(nil),                               // 95: google.analytics.admin.v1alpha.ListDataStreamsRequest
	(*ListDataStreamsResponse)(nil),                              // 96: google.analytics.admin.v1alpha.ListDataStreamsResponse
	(*GetDataStreamRequest)(nil),                                 // 97: google.analytics.admin.v1alpha.GetDataStreamRequest
	(*GetAudienceRequest)(nil),                                   // 98: google.analytics.admin.v1alpha.GetAudienceRequest
	(*ListAudiencesRequest)(nil),                                 // 99: google.analytics.admin.v1alpha.ListAudiencesRequest
	(*ListAudiencesResponse)(nil),                                // 100: google.analytics.admin.v1alpha.ListAudiencesResponse
	(*CreateAudienceRequest)(nil),                                // 101: google.analytics.admin.v1alpha.CreateAudienceRequest
	(*UpdateAudienceRequest)(nil),                                // 102: google.analytics.admin.v1alpha.UpdateAudienceRequest
	(*ArchiveAudienceRequest)(nil),                               // 103: google.analytics.admin.v1alpha.ArchiveAudienceRequest
	(*GetAttributionSettingsRequest)(nil),                        // 104: google.analytics.admin.v1alpha.GetAttributionSettingsRequest
	(*UpdateAttributionSettingsRequest)(nil),                     // 105: google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest
	(*GetAccessBindingRequest)(nil),                              // 106: google.analytics.admin.v1alpha.GetAccessBindingRequest
	(*BatchGetAccessBindingsRequest)(nil),                        // 107: google.analytics.admin.v1alpha.BatchGetAccessBindingsRequest
	(*BatchGetAccessBindingsResponse)(nil),                       // 108: google.analytics.admin.v1alpha.BatchGetAccessBindingsResponse
	(*ListAccessBindingsRequest)(nil),                            // 109: google.analytics.admin.v1alpha.ListAccessBindingsRequest
	(*ListAccessBindingsResponse)(nil),                           // 110: google.analytics.admin.v1alpha.ListAccessBindingsResponse
	(*CreateAccessBindingRequest)(nil),                           // 111: google.analytics.admin.v1alpha.CreateAccessBindingRequest
	(*BatchCreateAccessBindingsRequest)(nil),                     // 112: google.analytics.admin.v1alpha.BatchCreateAccessBindingsRequest
	(*BatchCreateAccessBindingsResponse)(nil),                    // 113: google.analytics.admin.v1alpha.BatchCreateAccessBindingsResponse
	(*UpdateAccessBindingRequest)(nil),                           // 114: google.analytics.admin.v1alpha.UpdateAccessBindingRequest
	(*BatchUpdateAccessBindingsRequest)(nil),                     // 115: google.analytics.admin.v1alpha.BatchUpdateAccessBindingsRequest
	(*BatchUpdateAccessBindingsResponse)(nil),                    // 116: google.analytics.admin.v1alpha.BatchUpdateAccessBindingsResponse
	(*DeleteAccessBindingRequest)(nil),                           // 117: google.analytics.admin.v1alpha.DeleteAccessBindingRequest
	(*BatchDeleteAccessBindingsRequest)(nil),                     // 118: google.analytics.admin.v1alpha.BatchDeleteAccessBindingsRequest
	(*CreateExpandedDataSetRequest)(nil),                         // 119: google.analytics.admin.v1alpha.CreateExpandedDataSetRequest
	(*UpdateExpandedDataSetRequest)(nil),                         // 120: google.analytics.admin.v1alpha.UpdateExpandedDataSetRequest
	(*DeleteExpandedDataSetRequest)(nil),                         // 121: google.analytics.admin.v1alpha.DeleteExpandedDataSetRequest
	(*GetExpandedDataSetRequest)(nil),                            // 122: google.analytics.admin.v1alpha.GetExpandedDataSetRequest
	(*ListExpandedDataSetsRequest)(nil),                          // 123: google.analytics.admin.v1alpha.ListExpandedDataSetsRequest
	(*ListExpandedDataSetsResponse)(nil),                         // 124: google.analytics.admin.v1alpha.ListExpandedDataSetsResponse
	(*CreateChannelGroupRequest)(nil),                            // 125: google.analytics.admin.v1alpha.CreateChannelGroupRequest
	(*UpdateChannelGroupRequest)(nil),                            // 126: google.analytics.admin.v1alpha.UpdateChannelGroupRequest
	(*DeleteChannelGroupRequest)(nil),                            // 127: google.analytics.admin.v1alpha.DeleteChannelGroupRequest
	(*GetChannelGroupRequest)(nil),                               // 128: google.analytics.admin.v1alpha.GetChannelGroupRequest
	(*ListChannelGroupsRequest)(nil),                             // 129: google.analytics.admin.v1alpha.ListChannelGroupsRequest
	(*ListChannelGroupsResponse)(nil),                            // 130: google.analytics.admin.v1alpha.ListChannelGroupsResponse
	(*SetAutomatedGa4ConfigurationOptOutRequest)(nil),            // 131: google.analytics.admin.v1alpha.SetAutomatedGa4ConfigurationOptOutRequest
	(*SetAutomatedGa4ConfigurationOptOutResponse)(nil),           // 132: google.analytics.admin.v1alpha.SetAutomatedGa4ConfigurationOptOutResponse
	(*FetchAutomatedGa4ConfigurationOptOutRequest)(nil),          // 133: google.analytics.admin.v1alpha.FetchAutomatedGa4ConfigurationOptOutRequest
	(*FetchAutomatedGa4ConfigurationOptOutResponse)(nil),         // 134: google.analytics.admin.v1alpha.FetchAutomatedGa4ConfigurationOptOutResponse
	(*GetBigQueryLinkRequest)(nil),                               // 135: google.analytics.admin.v1alpha.GetBigQueryLinkRequest
	(*ListBigQueryLinksRequest)(nil),                             // 136: google.analytics.admin.v1alpha.ListBigQueryLinksRequest
	(*ListBigQueryLinksResponse)(nil),                            // 137: google.analytics.admin.v1alpha.ListBigQueryLinksResponse
	(*GetEnhancedMeasurementSettingsRequest)(nil),                // 138: google.analytics.admin.v1alpha.GetEnhancedMeasurementSettingsRequest
	(*UpdateEnhancedMeasurementSettingsRequest)(nil),             // 139: google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest
	(*GetDataRedactionSettingsRequest)(nil),                      // 140: google.analytics.admin.v1alpha.GetDataRedactionSettingsRequest
	(*UpdateDataRedactionSettingsRequest)(nil),                   // 141: google.analytics.admin.v1alpha.UpdateDataRedactionSettingsRequest
	(*CreateConnectedSiteTagRequest)(nil),                        // 142: google.analytics.admin.v1alpha.CreateConnectedSiteTagRequest
	(*CreateConnectedSiteTagResponse)(nil),                       // 143: google.analytics.admin.v1alpha.CreateConnectedSiteTagResponse
	(*DeleteConnectedSiteTagRequest)(nil),                        // 144: google.analytics.admin.v1alpha.DeleteConnectedSiteTagRequest
	(*ListConnectedSiteTagsRequest)(nil),                         // 145: google.analytics.admin.v1alpha.ListConnectedSiteTagsRequest
	(*ListConnectedSiteTagsResponse)(nil),                        // 146: google.analytics.admin.v1alpha.ListConnectedSiteTagsResponse
	(*CreateAdSenseLinkRequest)(nil),                             // 147: google.analytics.admin.v1alpha.CreateAdSenseLinkRequest
	(*GetAdSenseLinkRequest)(nil),                                // 148: google.analytics.admin.v1alpha.GetAdSenseLinkRequest
	(*DeleteAdSenseLinkRequest)(nil),                             // 149: google.analytics.admin.v1alpha.DeleteAdSenseLinkRequest
	(*ListAdSenseLinksRequest)(nil),                              // 150: google.analytics.admin.v1alpha.ListAdSenseLinksRequest
	(*ListAdSenseLinksResponse)(nil),                             // 151: google.analytics.admin.v1alpha.ListAdSenseLinksResponse
	(*FetchConnectedGa4PropertyRequest)(nil),                     // 152: google.analytics.admin.v1alpha.FetchConnectedGa4PropertyRequest
	(*FetchConnectedGa4PropertyResponse)(nil),                    // 153: google.analytics.admin.v1alpha.FetchConnectedGa4PropertyResponse
	(*CreateEventCreateRuleRequest)(nil),                         // 154: google.analytics.admin.v1alpha.CreateEventCreateRuleRequest
	(*UpdateEventCreateRuleRequest)(nil),                         // 155: google.analytics.admin.v1alpha.UpdateEventCreateRuleRequest
	(*DeleteEventCreateRuleRequest)(nil),                         // 156: google.analytics.admin.v1alpha.DeleteEventCreateRuleRequest
	(*GetEventCreateRuleRequest)(nil),                            // 157: google.analytics.admin.v1alpha.GetEventCreateRuleRequest
	(*ListEventCreateRulesRequest)(nil),                          // 158: google.analytics.admin.v1alpha.ListEventCreateRulesRequest
	(*ListEventCreateRulesResponse)(nil),                         // 159: google.analytics.admin.v1alpha.ListEventCreateRulesResponse
	(*CreateRollupPropertyRequest)(nil),                          // 160: google.analytics.admin.v1alpha.CreateRollupPropertyRequest
	(*CreateRollupPropertyResponse)(nil),                         // 161: google.analytics.admin.v1alpha.CreateRollupPropertyResponse
	(*GetRollupPropertySourceLinkRequest)(nil),                   // 162: google.analytics.admin.v1alpha.GetRollupPropertySourceLinkRequest
	(*ListRollupPropertySourceLinksRequest)(nil),                 // 163: google.analytics.admin.v1alpha.ListRollupPropertySourceLinksRequest
	(*ListRollupPropertySourceLinksResponse)(nil),                // 164: google.analytics.admin.v1alpha.ListRollupPropertySourceLinksResponse
	(*CreateRollupPropertySourceLinkRequest)(nil),                // 165: google.analytics.admin.v1alpha.CreateRollupPropertySourceLinkRequest
	(*DeleteRollupPropertySourceLinkRequest)(nil),                // 166: google.analytics.admin.v1alpha.DeleteRollupPropertySourceLinkRequest
	(*CreateSubpropertyRequest)(nil),                             // 167: google.analytics.admin.v1alpha.CreateSubpropertyRequest
	(*CreateSubpropertyResponse)(nil),                            // 168: google.analytics.admin.v1alpha.CreateSubpropertyResponse
	(*CreateSubpropertyEventFilterRequest)(nil),                  // 169: google.analytics.admin.v1alpha.CreateSubpropertyEventFilterRequest
	(*GetSubpropertyEventFilterRequest)(nil),                     // 170: google.analytics.admin.v1alpha.GetSubpropertyEventFilterRequest
	(*ListSubpropertyEventFiltersRequest)(nil),                   // 171: google.analytics.admin.v1alpha.ListSubpropertyEventFiltersRequest
	(*ListSubpropertyEventFiltersResponse)(nil),                  // 172: google.analytics.admin.v1alpha.ListSubpropertyEventFiltersResponse
	(*UpdateSubpropertyEventFilterRequest)(nil),                  // 173: google.analytics.admin.v1alpha.UpdateSubpropertyEventFilterRequest
	(*DeleteSubpropertyEventFilterRequest)(nil),                  // 174: google.analytics.admin.v1alpha.DeleteSubpropertyEventFilterRequest
	(*AccessDimension)(nil),                                      // 175: google.analytics.admin.v1alpha.AccessDimension
	(*AccessMetric)(nil),                                         // 176: google.analytics.admin.v1alpha.AccessMetric
	(*AccessDateRange)(nil),                                      // 177: google.analytics.admin.v1alpha.AccessDateRange
	(*AccessFilterExpression)(nil),                               // 178: google.analytics.admin.v1alpha.AccessFilterExpression
	(*AccessOrderBy)(nil),                                        // 179: google.analytics.admin.v1alpha.AccessOrderBy
	(*AccessDimensionHeader)(nil),                                // 180: google.analytics.admin.v1alpha.AccessDimensionHeader
	(*AccessMetricHeader)(nil),                                   // 181: google.analytics.admin.v1alpha.AccessMetricHeader
	(*AccessRow)(nil),                                            // 182: google.analytics.admin.v1alpha.AccessRow
	(*AccessQuota)(nil),                                          // 183: google.analytics.admin.v1alpha.AccessQuota
	(*Account)(nil),                                              // 184: google.analytics.admin.v1alpha.Account
	(*fieldmaskpb.FieldMask)(nil),                                // 185: google.protobuf.FieldMask
	(*Property)(nil),                                             // 186: google.analytics.admin.v1alpha.Property
	(*FirebaseLink)(nil),                                         // 187: google.analytics.admin.v1alpha.FirebaseLink
	(*GoogleAdsLink)(nil),                                        // 188: google.analytics.admin.v1alpha.GoogleAdsLink
	(*AccountSummary)(nil),                                       // 189: google.analytics.admin.v1alpha.AccountSummary
	(ChangeHistoryResourceType)(0),                               // 190: google.analytics.admin.v1alpha.ChangeHistoryResourceType
	(ActionType)(0),                                              // 191: google.analytics.admin.v1alpha.ActionType
	(*timestamppb.Timestamp)(nil),                                // 192: google.protobuf.Timestamp
	(*ChangeHistoryEvent)(nil),                                   // 193: google.analytics.admin.v1alpha.ChangeHistoryEvent
	(*MeasurementProtocolSecret)(nil),                            // 194: google.analytics.admin.v1alpha.MeasurementProtocolSecret
	(*SKAdNetworkConversionValueSchema)(nil),                     // 195: google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	(*GoogleSignalsSettings)(nil),                                // 196: google.analytics.admin.v1alpha.GoogleSignalsSettings
	(*ConversionEvent)(nil),                                      // 197: google.analytics.admin.v1alpha.ConversionEvent
	(*DisplayVideo360AdvertiserLink)(nil),                        // 198: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	(*DisplayVideo360AdvertiserLinkProposal)(nil),                // 199: google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	(*SearchAds360Link)(nil),                                     // 200: google.analytics.admin.v1alpha.SearchAds360Link
	(*CustomDimension)(nil),                                      // 201: google.analytics.admin.v1alpha.CustomDimension
	(*CustomMetric)(nil),                                         // 202: google.analytics.admin.v1alpha.CustomMetric
	(*CalculatedMetric)(nil),                                     // 203: google.analytics.admin.v1alpha.CalculatedMetric
	(*DataRetentionSettings)(nil),                                // 204: google.analytics.admin.v1alpha.DataRetentionSettings
	(*DataStream)(nil),                                           // 205: google.analytics.admin.v1alpha.DataStream
	(*Audience)(nil),                                             // 206: google.analytics.admin.v1alpha.Audience
	(*AttributionSettings)(nil),                                  // 207: google.analytics.admin.v1alpha.AttributionSettings
	(*AccessBinding)(nil),                                        // 208: google.analytics.admin.v1alpha.AccessBinding
	(*ExpandedDataSet)(nil),                                      // 209: google.analytics.admin.v1alpha.ExpandedDataSet
	(*ChannelGroup)(nil),                                         // 210: google.analytics.admin.v1alpha.ChannelGroup
	(*BigQueryLink)(nil),                                         // 211: google.analytics.admin.v1alpha.BigQueryLink
	(*EnhancedMeasurementSettings)(nil),                          // 212: google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	(*DataRedactionSettings)(nil),                                // 213: google.analytics.admin.v1alpha.DataRedactionSettings
	(*ConnectedSiteTag)(nil),                                     // 214: google.analytics.admin.v1alpha.ConnectedSiteTag
	(*AdSenseLink)(nil),                                          // 215: google.analytics.admin.v1alpha.AdSenseLink
	(*EventCreateRule)(nil),                                      // 216: google.analytics.admin.v1alpha.EventCreateRule
	(*RollupPropertySourceLink)(nil),                             // 217: google.analytics.admin.v1alpha.RollupPropertySourceLink
	(*SubpropertyEventFilter)(nil),                               // 218: google.analytics.admin.v1alpha.SubpropertyEventFilter
	(*emptypb.Empty)(nil),                                        // 219: google.protobuf.Empty
	(*GlobalSiteTag)(nil),                                        // 220: google.analytics.admin.v1alpha.GlobalSiteTag
	(*DataSharingSettings)(nil),                                  // 221: google.analytics.admin.v1alpha.DataSharingSettings
}
var file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs = []int32{
	175, // 0: google.analytics.admin.v1alpha.RunAccessReportRequest.dimensions:type_name -> google.analytics.admin.v1alpha.AccessDimension
	176, // 1: google.analytics.admin.v1alpha.RunAccessReportRequest.metrics:type_name -> google.analytics.admin.v1alpha.AccessMetric
	177, // 2: google.analytics.admin.v1alpha.RunAccessReportRequest.date_ranges:type_name -> google.analytics.admin.v1alpha.AccessDateRange
	178, // 3: google.analytics.admin.v1alpha.RunAccessReportRequest.dimension_filter:type_name -> google.analytics.admin.v1alpha.AccessFilterExpression
	178, // 4: google.analytics.admin.v1alpha.RunAccessReportRequest.metric_filter:type_name -> google.analytics.admin.v1alpha.AccessFilterExpression
	179, // 5: google.analytics.admin.v1alpha.RunAccessReportRequest.order_bys:type_name -> google.analytics.admin.v1alpha.AccessOrderBy
	180, // 6: google.analytics.admin.v1alpha.RunAccessReportResponse.dimension_headers:type_name -> google.analytics.admin.v1alpha.AccessDimensionHeader
	181, // 7: google.analytics.admin.v1alpha.RunAccessReportResponse.metric_headers:type_name -> google.analytics.admin.v1alpha.AccessMetricHeader
	182, // 8: google.analytics.admin.v1alpha.RunAccessReportResponse.rows:type_name -> google.analytics.admin.v1alpha.AccessRow
	183, // 9: google.analytics.admin.v1alpha.RunAccessReportResponse.quota:type_name -> google.analytics.admin.v1alpha.AccessQuota
	184, // 10: google.analytics.admin.v1alpha.ListAccountsResponse.accounts:type_name -> google.analytics.admin.v1alpha.Account
	184, // 11: google.analytics.admin.v1alpha.UpdateAccountRequest.account:type_name -> google.analytics.admin.v1alpha.Account
	185, // 12: google.analytics.admin.v1alpha.UpdateAccountRequest.update_mask:type_name -> google.protobuf.FieldMask
	184, // 13: google.analytics.admin.v1alpha.ProvisionAccountTicketRequest.account:type_name -> google.analytics.admin.v1alpha.Account
	186, // 14: google.analytics.admin.v1alpha.ListPropertiesResponse.properties:type_name -> google.analytics.admin.v1alpha.Property
	186, // 15: google.analytics.admin.v1alpha.UpdatePropertyRequest.property:type_name -> google.analytics.admin.v1alpha.Property
	185, // 16: google.analytics.admin.v1alpha.UpdatePropertyRequest.update_mask:type_name -> google.protobuf.FieldMask
	186, // 17: google.analytics.admin.v1alpha.CreatePropertyRequest.property:type_name -> google.analytics.admin.v1alpha.Property
	187, // 18: google.analytics.admin.v1alpha.CreateFirebaseLinkRequest.firebase_link:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	187, // 19: google.analytics.admin.v1alpha.ListFirebaseLinksResponse.firebase_links:type_name -> google.analytics.admin.v1alpha.FirebaseLink
	188, // 20: google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	188, // 21: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	185, // 22: google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	188, // 23: google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse.google_ads_links:type_name -> google.analytics.admin.v1alpha.GoogleAdsLink
	189, // 24: google.analytics.admin.v1alpha.ListAccountSummariesResponse.account_summaries:type_name -> google.analytics.admin.v1alpha.AccountSummary
	190, // 25: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.resource_type:type_name -> google.analytics.admin.v1alpha.ChangeHistoryResourceType
	191, // 26: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.action:type_name -> google.analytics.admin.v1alpha.ActionType
	192, // 27: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.earliest_change_time:type_name -> google.protobuf.Timestamp
	192, // 28: google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest.latest_change_time:type_name -> google.protobuf.Timestamp
	193, // 29: google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse.change_history_events:type_name -> google.analytics.admin.v1alpha.ChangeHistoryEvent
	194, // 30: google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	194, // 31: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	185, // 32: google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest.update_mask:type_name -> google.protobuf.FieldMask
	194, // 33: google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse.measurement_protocol_secrets:type_name -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	195, // 34: google.analytics.admin.v1alpha.CreateSKAdNetworkConversionValueSchemaRequest.skadnetwork_conversion_value_schema:type_name -> google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	195, // 35: google.analytics.admin.v1alpha.UpdateSKAdNetworkConversionValueSchemaRequest.skadnetwork_conversion_value_schema:type_name -> google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	185, // 36: google.analytics.admin.v1alpha.UpdateSKAdNetworkConversionValueSchemaRequest.update_mask:type_name -> google.protobuf.FieldMask
	195, // 37: google.analytics.admin.v1alpha.ListSKAdNetworkConversionValueSchemasResponse.skadnetwork_conversion_value_schemas:type_name -> google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	196, // 38: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest.google_signals_settings:type_name -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	185, // 39: google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	197, // 40: google.analytics.admin.v1alpha.CreateConversionEventRequest.conversion_event:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	197, // 41: google.analytics.admin.v1alpha.UpdateConversionEventRequest.conversion_event:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	185, // 42: google.analytics.admin.v1alpha.UpdateConversionEventRequest.update_mask:type_name -> google.protobuf.FieldMask
	197, // 43: google.analytics.admin.v1alpha.ListConversionEventsResponse.conversion_events:type_name -> google.analytics.admin.v1alpha.ConversionEvent
	198, // 44: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse.display_video_360_advertiser_links:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	198, // 45: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	198, // 46: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	185, // 47: google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	199, // 48: google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse.display_video_360_advertiser_link_proposals:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	199, // 49: google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest.display_video_360_advertiser_link_proposal:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	198, // 50: google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse.display_video_360_advertiser_link:type_name -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	200, // 51: google.analytics.admin.v1alpha.ListSearchAds360LinksResponse.search_ads_360_links:type_name -> google.analytics.admin.v1alpha.SearchAds360Link
	200, // 52: google.analytics.admin.v1alpha.CreateSearchAds360LinkRequest.search_ads_360_link:type_name -> google.analytics.admin.v1alpha.SearchAds360Link
	200, // 53: google.analytics.admin.v1alpha.UpdateSearchAds360LinkRequest.search_ads_360_link:type_name -> google.analytics.admin.v1alpha.SearchAds360Link
	185, // 54: google.analytics.admin.v1alpha.UpdateSearchAds360LinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	201, // 55: google.analytics.admin.v1alpha.CreateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	201, // 56: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1alpha.CustomDimension
	185, // 57: google.analytics.admin.v1alpha.UpdateCustomDimensionRequest.update_mask:type_name -> google.protobuf.FieldMask
	201, // 58: google.analytics.admin.v1alpha.ListCustomDimensionsResponse.custom_dimensions:type_name -> google.analytics.admin.v1alpha.CustomDimension
	202, // 59: google.analytics.admin.v1alpha.CreateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	202, // 60: google.analytics.admin.v1alpha.UpdateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1alpha.CustomMetric
	185, // 61: google.analytics.admin.v1alpha.UpdateCustomMetricRequest.update_mask:type_name -> google.protobuf.FieldMask
	202, // 62: google.analytics.admin.v1alpha.ListCustomMetricsResponse.custom_metrics:type_name -> google.analytics.admin.v1alpha.CustomMetric
	203, // 63: google.analytics.admin.v1alpha.CreateCalculatedMetricRequest.calculated_metric:type_name -> google.analytics.admin.v1alpha.CalculatedMetric
	203, // 64: google.analytics.admin.v1alpha.UpdateCalculatedMetricRequest.calculated_metric:type_name -> google.analytics.admin.v1alpha.CalculatedMetric
	185, // 65: google.analytics.admin.v1alpha.UpdateCalculatedMetricRequest.update_mask:type_name -> google.protobuf.FieldMask
	203, // 66: google.analytics.admin.v1alpha.ListCalculatedMetricsResponse.calculated_metrics:type_name -> google.analytics.admin.v1alpha.CalculatedMetric
	204, // 67: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest.data_retention_settings:type_name -> google.analytics.admin.v1alpha.DataRetentionSettings
	185, // 68: google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	205, // 69: google.analytics.admin.v1alpha.CreateDataStreamRequest.data_stream:type_name -> google.analytics.admin.v1alpha.DataStream
	205, // 70: google.analytics.admin.v1alpha.UpdateDataStreamRequest.data_stream:type_name -> google.analytics.admin.v1alpha.DataStream
	185, // 71: google.analytics.admin.v1alpha.UpdateDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	205, // 72: google.analytics.admin.v1alpha.ListDataStreamsResponse.data_streams:type_name -> google.analytics.admin.v1alpha.DataStream
	206, // 73: google.analytics.admin.v1alpha.ListAudiencesResponse.audiences:type_name -> google.analytics.admin.v1alpha.Audience
	206, // 74: google.analytics.admin.v1alpha.CreateAudienceRequest.audience:type_name -> google.analytics.admin.v1alpha.Audience
	206, // 75: google.analytics.admin.v1alpha.UpdateAudienceRequest.audience:type_name -> google.analytics.admin.v1alpha.Audience
	185, // 76: google.analytics.admin.v1alpha.UpdateAudienceRequest.update_mask:type_name -> google.protobuf.FieldMask
	207, // 77: google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest.attribution_settings:type_name -> google.analytics.admin.v1alpha.AttributionSettings
	185, // 78: google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	208, // 79: google.analytics.admin.v1alpha.BatchGetAccessBindingsResponse.access_bindings:type_name -> google.analytics.admin.v1alpha.AccessBinding
	208, // 80: google.analytics.admin.v1alpha.ListAccessBindingsResponse.access_bindings:type_name -> google.analytics.admin.v1alpha.AccessBinding
	208, // 81: google.analytics.admin.v1alpha.CreateAccessBindingRequest.access_binding:type_name -> google.analytics.admin.v1alpha.AccessBinding
	111, // 82: google.analytics.admin.v1alpha.BatchCreateAccessBindingsRequest.requests:type_name -> google.analytics.admin.v1alpha.CreateAccessBindingRequest
	208, // 83: google.analytics.admin.v1alpha.BatchCreateAccessBindingsResponse.access_bindings:type_name -> google.analytics.admin.v1alpha.AccessBinding
	208, // 84: google.analytics.admin.v1alpha.UpdateAccessBindingRequest.access_binding:type_name -> google.analytics.admin.v1alpha.AccessBinding
	114, // 85: google.analytics.admin.v1alpha.BatchUpdateAccessBindingsRequest.requests:type_name -> google.analytics.admin.v1alpha.UpdateAccessBindingRequest
	208, // 86: google.analytics.admin.v1alpha.BatchUpdateAccessBindingsResponse.access_bindings:type_name -> google.analytics.admin.v1alpha.AccessBinding
	117, // 87: google.analytics.admin.v1alpha.BatchDeleteAccessBindingsRequest.requests:type_name -> google.analytics.admin.v1alpha.DeleteAccessBindingRequest
	209, // 88: google.analytics.admin.v1alpha.CreateExpandedDataSetRequest.expanded_data_set:type_name -> google.analytics.admin.v1alpha.ExpandedDataSet
	209, // 89: google.analytics.admin.v1alpha.UpdateExpandedDataSetRequest.expanded_data_set:type_name -> google.analytics.admin.v1alpha.ExpandedDataSet
	185, // 90: google.analytics.admin.v1alpha.UpdateExpandedDataSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	209, // 91: google.analytics.admin.v1alpha.ListExpandedDataSetsResponse.expanded_data_sets:type_name -> google.analytics.admin.v1alpha.ExpandedDataSet
	210, // 92: google.analytics.admin.v1alpha.CreateChannelGroupRequest.channel_group:type_name -> google.analytics.admin.v1alpha.ChannelGroup
	210, // 93: google.analytics.admin.v1alpha.UpdateChannelGroupRequest.channel_group:type_name -> google.analytics.admin.v1alpha.ChannelGroup
	185, // 94: google.analytics.admin.v1alpha.UpdateChannelGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	210, // 95: google.analytics.admin.v1alpha.ListChannelGroupsResponse.channel_groups:type_name -> google.analytics.admin.v1alpha.ChannelGroup
	211, // 96: google.analytics.admin.v1alpha.ListBigQueryLinksResponse.bigquery_links:type_name -> google.analytics.admin.v1alpha.BigQueryLink
	212, // 97: google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest.enhanced_measurement_settings:type_name -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	185, // 98: google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	213, // 99: google.analytics.admin.v1alpha.UpdateDataRedactionSettingsRequest.data_redaction_settings:type_name -> google.analytics.admin.v1alpha.DataRedactionSettings
	185, // 100: google.analytics.admin.v1alpha.UpdateDataRedactionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	214, // 101: google.analytics.admin.v1alpha.CreateConnectedSiteTagRequest.connected_site_tag:type_name -> google.analytics.admin.v1alpha.ConnectedSiteTag
	214, // 102: google.analytics.admin.v1alpha.ListConnectedSiteTagsResponse.connected_site_tags:type_name -> google.analytics.admin.v1alpha.ConnectedSiteTag
	215, // 103: google.analytics.admin.v1alpha.CreateAdSenseLinkRequest.adsense_link:type_name -> google.analytics.admin.v1alpha.AdSenseLink
	215, // 104: google.analytics.admin.v1alpha.ListAdSenseLinksResponse.adsense_links:type_name -> google.analytics.admin.v1alpha.AdSenseLink
	216, // 105: google.analytics.admin.v1alpha.CreateEventCreateRuleRequest.event_create_rule:type_name -> google.analytics.admin.v1alpha.EventCreateRule
	216, // 106: google.analytics.admin.v1alpha.UpdateEventCreateRuleRequest.event_create_rule:type_name -> google.analytics.admin.v1alpha.EventCreateRule
	185, // 107: google.analytics.admin.v1alpha.UpdateEventCreateRuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	216, // 108: google.analytics.admin.v1alpha.ListEventCreateRulesResponse.event_create_rules:type_name -> google.analytics.admin.v1alpha.EventCreateRule
	186, // 109: google.analytics.admin.v1alpha.CreateRollupPropertyRequest.rollup_property:type_name -> google.analytics.admin.v1alpha.Property
	186, // 110: google.analytics.admin.v1alpha.CreateRollupPropertyResponse.rollup_property:type_name -> google.analytics.admin.v1alpha.Property
	217, // 111: google.analytics.admin.v1alpha.CreateRollupPropertyResponse.rollup_property_source_links:type_name -> google.analytics.admin.v1alpha.RollupPropertySourceLink
	217, // 112: google.analytics.admin.v1alpha.ListRollupPropertySourceLinksResponse.rollup_property_source_links:type_name -> google.analytics.admin.v1alpha.RollupPropertySourceLink
	217, // 113: google.analytics.admin.v1alpha.CreateRollupPropertySourceLinkRequest.rollup_property_source_link:type_name -> google.analytics.admin.v1alpha.RollupPropertySourceLink
	186, // 114: google.analytics.admin.v1alpha.CreateSubpropertyRequest.subproperty:type_name -> google.analytics.admin.v1alpha.Property
	218, // 115: google.analytics.admin.v1alpha.CreateSubpropertyRequest.subproperty_event_filter:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	186, // 116: google.analytics.admin.v1alpha.CreateSubpropertyResponse.subproperty:type_name -> google.analytics.admin.v1alpha.Property
	218, // 117: google.analytics.admin.v1alpha.CreateSubpropertyResponse.subproperty_event_filter:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	218, // 118: google.analytics.admin.v1alpha.CreateSubpropertyEventFilterRequest.subproperty_event_filter:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	218, // 119: google.analytics.admin.v1alpha.ListSubpropertyEventFiltersResponse.subproperty_event_filters:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	218, // 120: google.analytics.admin.v1alpha.UpdateSubpropertyEventFilterRequest.subproperty_event_filter:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	185, // 121: google.analytics.admin.v1alpha.UpdateSubpropertyEventFilterRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,   // 122: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccount:input_type -> google.analytics.admin.v1alpha.GetAccountRequest
	3,   // 123: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccounts:input_type -> google.analytics.admin.v1alpha.ListAccountsRequest
	5,   // 124: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccount:input_type -> google.analytics.admin.v1alpha.DeleteAccountRequest
	6,   // 125: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccount:input_type -> google.analytics.admin.v1alpha.UpdateAccountRequest
	7,   // 126: google.analytics.admin.v1alpha.AnalyticsAdminService.ProvisionAccountTicket:input_type -> google.analytics.admin.v1alpha.ProvisionAccountTicketRequest
	26,  // 127: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccountSummaries:input_type -> google.analytics.admin.v1alpha.ListAccountSummariesRequest
	9,   // 128: google.analytics.admin.v1alpha.AnalyticsAdminService.GetProperty:input_type -> google.analytics.admin.v1alpha.GetPropertyRequest
	10,  // 129: google.analytics.admin.v1alpha.AnalyticsAdminService.ListProperties:input_type -> google.analytics.admin.v1alpha.ListPropertiesRequest
	13,  // 130: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateProperty:input_type -> google.analytics.admin.v1alpha.CreatePropertyRequest
	14,  // 131: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteProperty:input_type -> google.analytics.admin.v1alpha.DeletePropertyRequest
	12,  // 132: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateProperty:input_type -> google.analytics.admin.v1alpha.UpdatePropertyRequest
	15,  // 133: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateFirebaseLink:input_type -> google.analytics.admin.v1alpha.CreateFirebaseLinkRequest
	16,  // 134: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteFirebaseLink:input_type -> google.analytics.admin.v1alpha.DeleteFirebaseLinkRequest
	17,  // 135: google.analytics.admin.v1alpha.AnalyticsAdminService.ListFirebaseLinks:input_type -> google.analytics.admin.v1alpha.ListFirebaseLinksRequest
	19,  // 136: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGlobalSiteTag:input_type -> google.analytics.admin.v1alpha.GetGlobalSiteTagRequest
	20,  // 137: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.CreateGoogleAdsLinkRequest
	21,  // 138: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.UpdateGoogleAdsLinkRequest
	22,  // 139: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteGoogleAdsLink:input_type -> google.analytics.admin.v1alpha.DeleteGoogleAdsLinkRequest
	23,  // 140: google.analytics.admin.v1alpha.AnalyticsAdminService.ListGoogleAdsLinks:input_type -> google.analytics.admin.v1alpha.ListGoogleAdsLinksRequest
	25,  // 141: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataSharingSettings:input_type -> google.analytics.admin.v1alpha.GetDataSharingSettingsRequest
	32,  // 142: google.analytics.admin.v1alpha.AnalyticsAdminService.GetMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.GetMeasurementProtocolSecretRequest
	36,  // 143: google.analytics.admin.v1alpha.AnalyticsAdminService.ListMeasurementProtocolSecrets:input_type -> google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsRequest
	33,  // 144: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.CreateMeasurementProtocolSecretRequest
	34,  // 145: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.DeleteMeasurementProtocolSecretRequest
	35,  // 146: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1alpha.UpdateMeasurementProtocolSecretRequest
	28,  // 147: google.analytics.admin.v1alpha.AnalyticsAdminService.AcknowledgeUserDataCollection:input_type -> google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionRequest
	38,  // 148: google.analytics.admin.v1alpha.AnalyticsAdminService.GetSKAdNetworkConversionValueSchema:input_type -> google.analytics.admin.v1alpha.GetSKAdNetworkConversionValueSchemaRequest
	39,  // 149: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSKAdNetworkConversionValueSchema:input_type -> google.analytics.admin.v1alpha.CreateSKAdNetworkConversionValueSchemaRequest
	40,  // 150: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteSKAdNetworkConversionValueSchema:input_type -> google.analytics.admin.v1alpha.DeleteSKAdNetworkConversionValueSchemaRequest
	41,  // 151: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateSKAdNetworkConversionValueSchema:input_type -> google.analytics.admin.v1alpha.UpdateSKAdNetworkConversionValueSchemaRequest
	42,  // 152: google.analytics.admin.v1alpha.AnalyticsAdminService.ListSKAdNetworkConversionValueSchemas:input_type -> google.analytics.admin.v1alpha.ListSKAdNetworkConversionValueSchemasRequest
	30,  // 153: google.analytics.admin.v1alpha.AnalyticsAdminService.SearchChangeHistoryEvents:input_type -> google.analytics.admin.v1alpha.SearchChangeHistoryEventsRequest
	44,  // 154: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGoogleSignalsSettings:input_type -> google.analytics.admin.v1alpha.GetGoogleSignalsSettingsRequest
	45,  // 155: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleSignalsSettings:input_type -> google.analytics.admin.v1alpha.UpdateGoogleSignalsSettingsRequest
	46,  // 156: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConversionEvent:input_type -> google.analytics.admin.v1alpha.CreateConversionEventRequest
	47,  // 157: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateConversionEvent:input_type -> google.analytics.admin.v1alpha.UpdateConversionEventRequest
	48,  // 158: google.analytics.admin.v1alpha.AnalyticsAdminService.GetConversionEvent:input_type -> google.analytics.admin.v1alpha.GetConversionEventRequest
	49,  // 159: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConversionEvent:input_type -> google.analytics.admin.v1alpha.DeleteConversionEventRequest
	50,  // 160: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConversionEvents:input_type -> google.analytics.admin.v1alpha.ListConversionEventsRequest
	52,  // 161: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkRequest
	53,  // 162: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinks:input_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksRequest
	55,  // 163: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkRequest
	56,  // 164: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkRequest
	57,  // 165: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDisplayVideo360AdvertiserLink:input_type -> google.analytics.admin.v1alpha.UpdateDisplayVideo360AdvertiserLinkRequest
	58,  // 166: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.GetDisplayVideo360AdvertiserLinkProposalRequest
	59,  // 167: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinkProposals:input_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsRequest
	61,  // 168: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.CreateDisplayVideo360AdvertiserLinkProposalRequest
	62,  // 169: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.DeleteDisplayVideo360AdvertiserLinkProposalRequest
	63,  // 170: google.analytics.admin.v1alpha.AnalyticsAdminService.ApproveDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalRequest
	65,  // 171: google.analytics.admin.v1alpha.AnalyticsAdminService.CancelDisplayVideo360AdvertiserLinkProposal:input_type -> google.analytics.admin.v1alpha.CancelDisplayVideo360AdvertiserLinkProposalRequest
	72,  // 172: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomDimension:input_type -> google.analytics.admin.v1alpha.CreateCustomDimensionRequest
	73,  // 173: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomDimension:input_type -> google.analytics.admin.v1alpha.UpdateCustomDimensionRequest
	74,  // 174: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomDimensions:input_type -> google.analytics.admin.v1alpha.ListCustomDimensionsRequest
	76,  // 175: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomDimension:input_type -> google.analytics.admin.v1alpha.ArchiveCustomDimensionRequest
	77,  // 176: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomDimension:input_type -> google.analytics.admin.v1alpha.GetCustomDimensionRequest
	78,  // 177: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomMetric:input_type -> google.analytics.admin.v1alpha.CreateCustomMetricRequest
	79,  // 178: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomMetric:input_type -> google.analytics.admin.v1alpha.UpdateCustomMetricRequest
	80,  // 179: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomMetrics:input_type -> google.analytics.admin.v1alpha.ListCustomMetricsRequest
	82,  // 180: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomMetric:input_type -> google.analytics.admin.v1alpha.ArchiveCustomMetricRequest
	83,  // 181: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomMetric:input_type -> google.analytics.admin.v1alpha.GetCustomMetricRequest
	90,  // 182: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRetentionSettings:input_type -> google.analytics.admin.v1alpha.GetDataRetentionSettingsRequest
	91,  // 183: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRetentionSettings:input_type -> google.analytics.admin.v1alpha.UpdateDataRetentionSettingsRequest
	92,  // 184: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDataStream:input_type -> google.analytics.admin.v1alpha.CreateDataStreamRequest
	93,  // 185: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDataStream:input_type -> google.analytics.admin.v1alpha.DeleteDataStreamRequest
	94,  // 186: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataStream:input_type -> google.analytics.admin.v1alpha.UpdateDataStreamRequest
	95,  // 187: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDataStreams:input_type -> google.analytics.admin.v1alpha.ListDataStreamsRequest
	97,  // 188: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataStream:input_type -> google.analytics.admin.v1alpha.GetDataStreamRequest
	98,  // 189: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAudience:input_type -> google.analytics.admin.v1alpha.GetAudienceRequest
	99,  // 190: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAudiences:input_type -> google.analytics.admin.v1alpha.ListAudiencesRequest
	101, // 191: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAudience:input_type -> google.analytics.admin.v1alpha.CreateAudienceRequest
	102, // 192: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAudience:input_type -> google.analytics.admin.v1alpha.UpdateAudienceRequest
	103, // 193: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveAudience:input_type -> google.analytics.admin.v1alpha.ArchiveAudienceRequest
	66,  // 194: google.analytics.admin.v1alpha.AnalyticsAdminService.GetSearchAds360Link:input_type -> google.analytics.admin.v1alpha.GetSearchAds360LinkRequest
	67,  // 195: google.analytics.admin.v1alpha.AnalyticsAdminService.ListSearchAds360Links:input_type -> google.analytics.admin.v1alpha.ListSearchAds360LinksRequest
	69,  // 196: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSearchAds360Link:input_type -> google.analytics.admin.v1alpha.CreateSearchAds360LinkRequest
	70,  // 197: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteSearchAds360Link:input_type -> google.analytics.admin.v1alpha.DeleteSearchAds360LinkRequest
	71,  // 198: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateSearchAds360Link:input_type -> google.analytics.admin.v1alpha.UpdateSearchAds360LinkRequest
	104, // 199: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAttributionSettings:input_type -> google.analytics.admin.v1alpha.GetAttributionSettingsRequest
	105, // 200: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAttributionSettings:input_type -> google.analytics.admin.v1alpha.UpdateAttributionSettingsRequest
	0,   // 201: google.analytics.admin.v1alpha.AnalyticsAdminService.RunAccessReport:input_type -> google.analytics.admin.v1alpha.RunAccessReportRequest
	111, // 202: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAccessBinding:input_type -> google.analytics.admin.v1alpha.CreateAccessBindingRequest
	106, // 203: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccessBinding:input_type -> google.analytics.admin.v1alpha.GetAccessBindingRequest
	114, // 204: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccessBinding:input_type -> google.analytics.admin.v1alpha.UpdateAccessBindingRequest
	117, // 205: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccessBinding:input_type -> google.analytics.admin.v1alpha.DeleteAccessBindingRequest
	109, // 206: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccessBindings:input_type -> google.analytics.admin.v1alpha.ListAccessBindingsRequest
	112, // 207: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchCreateAccessBindings:input_type -> google.analytics.admin.v1alpha.BatchCreateAccessBindingsRequest
	107, // 208: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchGetAccessBindings:input_type -> google.analytics.admin.v1alpha.BatchGetAccessBindingsRequest
	115, // 209: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchUpdateAccessBindings:input_type -> google.analytics.admin.v1alpha.BatchUpdateAccessBindingsRequest
	118, // 210: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchDeleteAccessBindings:input_type -> google.analytics.admin.v1alpha.BatchDeleteAccessBindingsRequest
	122, // 211: google.analytics.admin.v1alpha.AnalyticsAdminService.GetExpandedDataSet:input_type -> google.analytics.admin.v1alpha.GetExpandedDataSetRequest
	123, // 212: google.analytics.admin.v1alpha.AnalyticsAdminService.ListExpandedDataSets:input_type -> google.analytics.admin.v1alpha.ListExpandedDataSetsRequest
	119, // 213: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateExpandedDataSet:input_type -> google.analytics.admin.v1alpha.CreateExpandedDataSetRequest
	120, // 214: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateExpandedDataSet:input_type -> google.analytics.admin.v1alpha.UpdateExpandedDataSetRequest
	121, // 215: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteExpandedDataSet:input_type -> google.analytics.admin.v1alpha.DeleteExpandedDataSetRequest
	128, // 216: google.analytics.admin.v1alpha.AnalyticsAdminService.GetChannelGroup:input_type -> google.analytics.admin.v1alpha.GetChannelGroupRequest
	129, // 217: google.analytics.admin.v1alpha.AnalyticsAdminService.ListChannelGroups:input_type -> google.analytics.admin.v1alpha.ListChannelGroupsRequest
	125, // 218: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateChannelGroup:input_type -> google.analytics.admin.v1alpha.CreateChannelGroupRequest
	126, // 219: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateChannelGroup:input_type -> google.analytics.admin.v1alpha.UpdateChannelGroupRequest
	127, // 220: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteChannelGroup:input_type -> google.analytics.admin.v1alpha.DeleteChannelGroupRequest
	131, // 221: google.analytics.admin.v1alpha.AnalyticsAdminService.SetAutomatedGa4ConfigurationOptOut:input_type -> google.analytics.admin.v1alpha.SetAutomatedGa4ConfigurationOptOutRequest
	133, // 222: google.analytics.admin.v1alpha.AnalyticsAdminService.FetchAutomatedGa4ConfigurationOptOut:input_type -> google.analytics.admin.v1alpha.FetchAutomatedGa4ConfigurationOptOutRequest
	135, // 223: google.analytics.admin.v1alpha.AnalyticsAdminService.GetBigQueryLink:input_type -> google.analytics.admin.v1alpha.GetBigQueryLinkRequest
	136, // 224: google.analytics.admin.v1alpha.AnalyticsAdminService.ListBigQueryLinks:input_type -> google.analytics.admin.v1alpha.ListBigQueryLinksRequest
	138, // 225: google.analytics.admin.v1alpha.AnalyticsAdminService.GetEnhancedMeasurementSettings:input_type -> google.analytics.admin.v1alpha.GetEnhancedMeasurementSettingsRequest
	139, // 226: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateEnhancedMeasurementSettings:input_type -> google.analytics.admin.v1alpha.UpdateEnhancedMeasurementSettingsRequest
	142, // 227: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConnectedSiteTag:input_type -> google.analytics.admin.v1alpha.CreateConnectedSiteTagRequest
	144, // 228: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConnectedSiteTag:input_type -> google.analytics.admin.v1alpha.DeleteConnectedSiteTagRequest
	145, // 229: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConnectedSiteTags:input_type -> google.analytics.admin.v1alpha.ListConnectedSiteTagsRequest
	152, // 230: google.analytics.admin.v1alpha.AnalyticsAdminService.FetchConnectedGa4Property:input_type -> google.analytics.admin.v1alpha.FetchConnectedGa4PropertyRequest
	148, // 231: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAdSenseLink:input_type -> google.analytics.admin.v1alpha.GetAdSenseLinkRequest
	147, // 232: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAdSenseLink:input_type -> google.analytics.admin.v1alpha.CreateAdSenseLinkRequest
	149, // 233: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAdSenseLink:input_type -> google.analytics.admin.v1alpha.DeleteAdSenseLinkRequest
	150, // 234: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAdSenseLinks:input_type -> google.analytics.admin.v1alpha.ListAdSenseLinksRequest
	157, // 235: google.analytics.admin.v1alpha.AnalyticsAdminService.GetEventCreateRule:input_type -> google.analytics.admin.v1alpha.GetEventCreateRuleRequest
	158, // 236: google.analytics.admin.v1alpha.AnalyticsAdminService.ListEventCreateRules:input_type -> google.analytics.admin.v1alpha.ListEventCreateRulesRequest
	154, // 237: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateEventCreateRule:input_type -> google.analytics.admin.v1alpha.CreateEventCreateRuleRequest
	155, // 238: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateEventCreateRule:input_type -> google.analytics.admin.v1alpha.UpdateEventCreateRuleRequest
	156, // 239: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteEventCreateRule:input_type -> google.analytics.admin.v1alpha.DeleteEventCreateRuleRequest
	141, // 240: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRedactionSettings:input_type -> google.analytics.admin.v1alpha.UpdateDataRedactionSettingsRequest
	140, // 241: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRedactionSettings:input_type -> google.analytics.admin.v1alpha.GetDataRedactionSettingsRequest
	89,  // 242: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCalculatedMetric:input_type -> google.analytics.admin.v1alpha.GetCalculatedMetricRequest
	84,  // 243: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCalculatedMetric:input_type -> google.analytics.admin.v1alpha.CreateCalculatedMetricRequest
	87,  // 244: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCalculatedMetrics:input_type -> google.analytics.admin.v1alpha.ListCalculatedMetricsRequest
	85,  // 245: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCalculatedMetric:input_type -> google.analytics.admin.v1alpha.UpdateCalculatedMetricRequest
	86,  // 246: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteCalculatedMetric:input_type -> google.analytics.admin.v1alpha.DeleteCalculatedMetricRequest
	160, // 247: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateRollupProperty:input_type -> google.analytics.admin.v1alpha.CreateRollupPropertyRequest
	162, // 248: google.analytics.admin.v1alpha.AnalyticsAdminService.GetRollupPropertySourceLink:input_type -> google.analytics.admin.v1alpha.GetRollupPropertySourceLinkRequest
	163, // 249: google.analytics.admin.v1alpha.AnalyticsAdminService.ListRollupPropertySourceLinks:input_type -> google.analytics.admin.v1alpha.ListRollupPropertySourceLinksRequest
	165, // 250: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateRollupPropertySourceLink:input_type -> google.analytics.admin.v1alpha.CreateRollupPropertySourceLinkRequest
	166, // 251: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteRollupPropertySourceLink:input_type -> google.analytics.admin.v1alpha.DeleteRollupPropertySourceLinkRequest
	167, // 252: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSubproperty:input_type -> google.analytics.admin.v1alpha.CreateSubpropertyRequest
	169, // 253: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSubpropertyEventFilter:input_type -> google.analytics.admin.v1alpha.CreateSubpropertyEventFilterRequest
	170, // 254: google.analytics.admin.v1alpha.AnalyticsAdminService.GetSubpropertyEventFilter:input_type -> google.analytics.admin.v1alpha.GetSubpropertyEventFilterRequest
	171, // 255: google.analytics.admin.v1alpha.AnalyticsAdminService.ListSubpropertyEventFilters:input_type -> google.analytics.admin.v1alpha.ListSubpropertyEventFiltersRequest
	173, // 256: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateSubpropertyEventFilter:input_type -> google.analytics.admin.v1alpha.UpdateSubpropertyEventFilterRequest
	174, // 257: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteSubpropertyEventFilter:input_type -> google.analytics.admin.v1alpha.DeleteSubpropertyEventFilterRequest
	184, // 258: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccount:output_type -> google.analytics.admin.v1alpha.Account
	4,   // 259: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccounts:output_type -> google.analytics.admin.v1alpha.ListAccountsResponse
	219, // 260: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccount:output_type -> google.protobuf.Empty
	184, // 261: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccount:output_type -> google.analytics.admin.v1alpha.Account
	8,   // 262: google.analytics.admin.v1alpha.AnalyticsAdminService.ProvisionAccountTicket:output_type -> google.analytics.admin.v1alpha.ProvisionAccountTicketResponse
	27,  // 263: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccountSummaries:output_type -> google.analytics.admin.v1alpha.ListAccountSummariesResponse
	186, // 264: google.analytics.admin.v1alpha.AnalyticsAdminService.GetProperty:output_type -> google.analytics.admin.v1alpha.Property
	11,  // 265: google.analytics.admin.v1alpha.AnalyticsAdminService.ListProperties:output_type -> google.analytics.admin.v1alpha.ListPropertiesResponse
	186, // 266: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateProperty:output_type -> google.analytics.admin.v1alpha.Property
	186, // 267: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteProperty:output_type -> google.analytics.admin.v1alpha.Property
	186, // 268: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateProperty:output_type -> google.analytics.admin.v1alpha.Property
	187, // 269: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateFirebaseLink:output_type -> google.analytics.admin.v1alpha.FirebaseLink
	219, // 270: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteFirebaseLink:output_type -> google.protobuf.Empty
	18,  // 271: google.analytics.admin.v1alpha.AnalyticsAdminService.ListFirebaseLinks:output_type -> google.analytics.admin.v1alpha.ListFirebaseLinksResponse
	220, // 272: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGlobalSiteTag:output_type -> google.analytics.admin.v1alpha.GlobalSiteTag
	188, // 273: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateGoogleAdsLink:output_type -> google.analytics.admin.v1alpha.GoogleAdsLink
	188, // 274: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleAdsLink:output_type -> google.analytics.admin.v1alpha.GoogleAdsLink
	219, // 275: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteGoogleAdsLink:output_type -> google.protobuf.Empty
	24,  // 276: google.analytics.admin.v1alpha.AnalyticsAdminService.ListGoogleAdsLinks:output_type -> google.analytics.admin.v1alpha.ListGoogleAdsLinksResponse
	221, // 277: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataSharingSettings:output_type -> google.analytics.admin.v1alpha.DataSharingSettings
	194, // 278: google.analytics.admin.v1alpha.AnalyticsAdminService.GetMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	37,  // 279: google.analytics.admin.v1alpha.AnalyticsAdminService.ListMeasurementProtocolSecrets:output_type -> google.analytics.admin.v1alpha.ListMeasurementProtocolSecretsResponse
	194, // 280: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	219, // 281: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteMeasurementProtocolSecret:output_type -> google.protobuf.Empty
	194, // 282: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1alpha.MeasurementProtocolSecret
	29,  // 283: google.analytics.admin.v1alpha.AnalyticsAdminService.AcknowledgeUserDataCollection:output_type -> google.analytics.admin.v1alpha.AcknowledgeUserDataCollectionResponse
	195, // 284: google.analytics.admin.v1alpha.AnalyticsAdminService.GetSKAdNetworkConversionValueSchema:output_type -> google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	195, // 285: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSKAdNetworkConversionValueSchema:output_type -> google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	219, // 286: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteSKAdNetworkConversionValueSchema:output_type -> google.protobuf.Empty
	195, // 287: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateSKAdNetworkConversionValueSchema:output_type -> google.analytics.admin.v1alpha.SKAdNetworkConversionValueSchema
	43,  // 288: google.analytics.admin.v1alpha.AnalyticsAdminService.ListSKAdNetworkConversionValueSchemas:output_type -> google.analytics.admin.v1alpha.ListSKAdNetworkConversionValueSchemasResponse
	31,  // 289: google.analytics.admin.v1alpha.AnalyticsAdminService.SearchChangeHistoryEvents:output_type -> google.analytics.admin.v1alpha.SearchChangeHistoryEventsResponse
	196, // 290: google.analytics.admin.v1alpha.AnalyticsAdminService.GetGoogleSignalsSettings:output_type -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	196, // 291: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateGoogleSignalsSettings:output_type -> google.analytics.admin.v1alpha.GoogleSignalsSettings
	197, // 292: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	197, // 293: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	197, // 294: google.analytics.admin.v1alpha.AnalyticsAdminService.GetConversionEvent:output_type -> google.analytics.admin.v1alpha.ConversionEvent
	219, // 295: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConversionEvent:output_type -> google.protobuf.Empty
	51,  // 296: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConversionEvents:output_type -> google.analytics.admin.v1alpha.ListConversionEventsResponse
	198, // 297: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	54,  // 298: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinks:output_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinksResponse
	198, // 299: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	219, // 300: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLink:output_type -> google.protobuf.Empty
	198, // 301: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDisplayVideo360AdvertiserLink:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLink
	199, // 302: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	60,  // 303: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDisplayVideo360AdvertiserLinkProposals:output_type -> google.analytics.admin.v1alpha.ListDisplayVideo360AdvertiserLinkProposalsResponse
	199, // 304: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	219, // 305: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDisplayVideo360AdvertiserLinkProposal:output_type -> google.protobuf.Empty
	64,  // 306: google.analytics.admin.v1alpha.AnalyticsAdminService.ApproveDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.ApproveDisplayVideo360AdvertiserLinkProposalResponse
	199, // 307: google.analytics.admin.v1alpha.AnalyticsAdminService.CancelDisplayVideo360AdvertiserLinkProposal:output_type -> google.analytics.admin.v1alpha.DisplayVideo360AdvertiserLinkProposal
	201, // 308: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	201, // 309: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	75,  // 310: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomDimensions:output_type -> google.analytics.admin.v1alpha.ListCustomDimensionsResponse
	219, // 311: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomDimension:output_type -> google.protobuf.Empty
	201, // 312: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomDimension:output_type -> google.analytics.admin.v1alpha.CustomDimension
	202, // 313: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	202, // 314: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	81,  // 315: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCustomMetrics:output_type -> google.analytics.admin.v1alpha.ListCustomMetricsResponse
	219, // 316: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveCustomMetric:output_type -> google.protobuf.Empty
	202, // 317: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCustomMetric:output_type -> google.analytics.admin.v1alpha.CustomMetric
	204, // 318: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRetentionSettings:output_type -> google.analytics.admin.v1alpha.DataRetentionSettings
	204, // 319: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRetentionSettings:output_type -> google.analytics.admin.v1alpha.DataRetentionSettings
	205, // 320: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateDataStream:output_type -> google.analytics.admin.v1alpha.DataStream
	219, // 321: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteDataStream:output_type -> google.protobuf.Empty
	205, // 322: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataStream:output_type -> google.analytics.admin.v1alpha.DataStream
	96,  // 323: google.analytics.admin.v1alpha.AnalyticsAdminService.ListDataStreams:output_type -> google.analytics.admin.v1alpha.ListDataStreamsResponse
	205, // 324: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataStream:output_type -> google.analytics.admin.v1alpha.DataStream
	206, // 325: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAudience:output_type -> google.analytics.admin.v1alpha.Audience
	100, // 326: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAudiences:output_type -> google.analytics.admin.v1alpha.ListAudiencesResponse
	206, // 327: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAudience:output_type -> google.analytics.admin.v1alpha.Audience
	206, // 328: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAudience:output_type -> google.analytics.admin.v1alpha.Audience
	219, // 329: google.analytics.admin.v1alpha.AnalyticsAdminService.ArchiveAudience:output_type -> google.protobuf.Empty
	200, // 330: google.analytics.admin.v1alpha.AnalyticsAdminService.GetSearchAds360Link:output_type -> google.analytics.admin.v1alpha.SearchAds360Link
	68,  // 331: google.analytics.admin.v1alpha.AnalyticsAdminService.ListSearchAds360Links:output_type -> google.analytics.admin.v1alpha.ListSearchAds360LinksResponse
	200, // 332: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSearchAds360Link:output_type -> google.analytics.admin.v1alpha.SearchAds360Link
	219, // 333: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteSearchAds360Link:output_type -> google.protobuf.Empty
	200, // 334: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateSearchAds360Link:output_type -> google.analytics.admin.v1alpha.SearchAds360Link
	207, // 335: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAttributionSettings:output_type -> google.analytics.admin.v1alpha.AttributionSettings
	207, // 336: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAttributionSettings:output_type -> google.analytics.admin.v1alpha.AttributionSettings
	1,   // 337: google.analytics.admin.v1alpha.AnalyticsAdminService.RunAccessReport:output_type -> google.analytics.admin.v1alpha.RunAccessReportResponse
	208, // 338: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAccessBinding:output_type -> google.analytics.admin.v1alpha.AccessBinding
	208, // 339: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAccessBinding:output_type -> google.analytics.admin.v1alpha.AccessBinding
	208, // 340: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateAccessBinding:output_type -> google.analytics.admin.v1alpha.AccessBinding
	219, // 341: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAccessBinding:output_type -> google.protobuf.Empty
	110, // 342: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAccessBindings:output_type -> google.analytics.admin.v1alpha.ListAccessBindingsResponse
	113, // 343: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchCreateAccessBindings:output_type -> google.analytics.admin.v1alpha.BatchCreateAccessBindingsResponse
	108, // 344: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchGetAccessBindings:output_type -> google.analytics.admin.v1alpha.BatchGetAccessBindingsResponse
	116, // 345: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchUpdateAccessBindings:output_type -> google.analytics.admin.v1alpha.BatchUpdateAccessBindingsResponse
	219, // 346: google.analytics.admin.v1alpha.AnalyticsAdminService.BatchDeleteAccessBindings:output_type -> google.protobuf.Empty
	209, // 347: google.analytics.admin.v1alpha.AnalyticsAdminService.GetExpandedDataSet:output_type -> google.analytics.admin.v1alpha.ExpandedDataSet
	124, // 348: google.analytics.admin.v1alpha.AnalyticsAdminService.ListExpandedDataSets:output_type -> google.analytics.admin.v1alpha.ListExpandedDataSetsResponse
	209, // 349: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateExpandedDataSet:output_type -> google.analytics.admin.v1alpha.ExpandedDataSet
	209, // 350: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateExpandedDataSet:output_type -> google.analytics.admin.v1alpha.ExpandedDataSet
	219, // 351: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteExpandedDataSet:output_type -> google.protobuf.Empty
	210, // 352: google.analytics.admin.v1alpha.AnalyticsAdminService.GetChannelGroup:output_type -> google.analytics.admin.v1alpha.ChannelGroup
	130, // 353: google.analytics.admin.v1alpha.AnalyticsAdminService.ListChannelGroups:output_type -> google.analytics.admin.v1alpha.ListChannelGroupsResponse
	210, // 354: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateChannelGroup:output_type -> google.analytics.admin.v1alpha.ChannelGroup
	210, // 355: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateChannelGroup:output_type -> google.analytics.admin.v1alpha.ChannelGroup
	219, // 356: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteChannelGroup:output_type -> google.protobuf.Empty
	132, // 357: google.analytics.admin.v1alpha.AnalyticsAdminService.SetAutomatedGa4ConfigurationOptOut:output_type -> google.analytics.admin.v1alpha.SetAutomatedGa4ConfigurationOptOutResponse
	134, // 358: google.analytics.admin.v1alpha.AnalyticsAdminService.FetchAutomatedGa4ConfigurationOptOut:output_type -> google.analytics.admin.v1alpha.FetchAutomatedGa4ConfigurationOptOutResponse
	211, // 359: google.analytics.admin.v1alpha.AnalyticsAdminService.GetBigQueryLink:output_type -> google.analytics.admin.v1alpha.BigQueryLink
	137, // 360: google.analytics.admin.v1alpha.AnalyticsAdminService.ListBigQueryLinks:output_type -> google.analytics.admin.v1alpha.ListBigQueryLinksResponse
	212, // 361: google.analytics.admin.v1alpha.AnalyticsAdminService.GetEnhancedMeasurementSettings:output_type -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	212, // 362: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateEnhancedMeasurementSettings:output_type -> google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	143, // 363: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateConnectedSiteTag:output_type -> google.analytics.admin.v1alpha.CreateConnectedSiteTagResponse
	219, // 364: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteConnectedSiteTag:output_type -> google.protobuf.Empty
	146, // 365: google.analytics.admin.v1alpha.AnalyticsAdminService.ListConnectedSiteTags:output_type -> google.analytics.admin.v1alpha.ListConnectedSiteTagsResponse
	153, // 366: google.analytics.admin.v1alpha.AnalyticsAdminService.FetchConnectedGa4Property:output_type -> google.analytics.admin.v1alpha.FetchConnectedGa4PropertyResponse
	215, // 367: google.analytics.admin.v1alpha.AnalyticsAdminService.GetAdSenseLink:output_type -> google.analytics.admin.v1alpha.AdSenseLink
	215, // 368: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateAdSenseLink:output_type -> google.analytics.admin.v1alpha.AdSenseLink
	219, // 369: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteAdSenseLink:output_type -> google.protobuf.Empty
	151, // 370: google.analytics.admin.v1alpha.AnalyticsAdminService.ListAdSenseLinks:output_type -> google.analytics.admin.v1alpha.ListAdSenseLinksResponse
	216, // 371: google.analytics.admin.v1alpha.AnalyticsAdminService.GetEventCreateRule:output_type -> google.analytics.admin.v1alpha.EventCreateRule
	159, // 372: google.analytics.admin.v1alpha.AnalyticsAdminService.ListEventCreateRules:output_type -> google.analytics.admin.v1alpha.ListEventCreateRulesResponse
	216, // 373: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateEventCreateRule:output_type -> google.analytics.admin.v1alpha.EventCreateRule
	216, // 374: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateEventCreateRule:output_type -> google.analytics.admin.v1alpha.EventCreateRule
	219, // 375: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteEventCreateRule:output_type -> google.protobuf.Empty
	213, // 376: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateDataRedactionSettings:output_type -> google.analytics.admin.v1alpha.DataRedactionSettings
	213, // 377: google.analytics.admin.v1alpha.AnalyticsAdminService.GetDataRedactionSettings:output_type -> google.analytics.admin.v1alpha.DataRedactionSettings
	203, // 378: google.analytics.admin.v1alpha.AnalyticsAdminService.GetCalculatedMetric:output_type -> google.analytics.admin.v1alpha.CalculatedMetric
	203, // 379: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateCalculatedMetric:output_type -> google.analytics.admin.v1alpha.CalculatedMetric
	88,  // 380: google.analytics.admin.v1alpha.AnalyticsAdminService.ListCalculatedMetrics:output_type -> google.analytics.admin.v1alpha.ListCalculatedMetricsResponse
	203, // 381: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateCalculatedMetric:output_type -> google.analytics.admin.v1alpha.CalculatedMetric
	219, // 382: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteCalculatedMetric:output_type -> google.protobuf.Empty
	161, // 383: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateRollupProperty:output_type -> google.analytics.admin.v1alpha.CreateRollupPropertyResponse
	217, // 384: google.analytics.admin.v1alpha.AnalyticsAdminService.GetRollupPropertySourceLink:output_type -> google.analytics.admin.v1alpha.RollupPropertySourceLink
	164, // 385: google.analytics.admin.v1alpha.AnalyticsAdminService.ListRollupPropertySourceLinks:output_type -> google.analytics.admin.v1alpha.ListRollupPropertySourceLinksResponse
	217, // 386: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateRollupPropertySourceLink:output_type -> google.analytics.admin.v1alpha.RollupPropertySourceLink
	219, // 387: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteRollupPropertySourceLink:output_type -> google.protobuf.Empty
	168, // 388: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSubproperty:output_type -> google.analytics.admin.v1alpha.CreateSubpropertyResponse
	218, // 389: google.analytics.admin.v1alpha.AnalyticsAdminService.CreateSubpropertyEventFilter:output_type -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	218, // 390: google.analytics.admin.v1alpha.AnalyticsAdminService.GetSubpropertyEventFilter:output_type -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	172, // 391: google.analytics.admin.v1alpha.AnalyticsAdminService.ListSubpropertyEventFilters:output_type -> google.analytics.admin.v1alpha.ListSubpropertyEventFiltersResponse
	218, // 392: google.analytics.admin.v1alpha.AnalyticsAdminService.UpdateSubpropertyEventFilter:output_type -> google.analytics.admin.v1alpha.SubpropertyEventFilter
	219, // 393: google.analytics.admin.v1alpha.AnalyticsAdminService.DeleteSubpropertyEventFilter:output_type -> google.protobuf.Empty
	258, // [258:394] is the sub-list for method output_type
	122, // [122:258] is the sub-list for method input_type
	122, // [122:122] is the sub-list for extension type_name
	122, // [122:122] is the sub-list for extension extendee
	0,   // [0:122] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_analytics_admin_proto_init() }
func file_google_analytics_admin_v1alpha_analytics_admin_proto_init() {
	if File_google_analytics_admin_v1alpha_analytics_admin_proto != nil {
		return
	}
	file_google_analytics_admin_v1alpha_access_report_proto_init()
	file_google_analytics_admin_v1alpha_audience_proto_init()
	file_google_analytics_admin_v1alpha_channel_group_proto_init()
	file_google_analytics_admin_v1alpha_event_create_and_edit_proto_init()
	file_google_analytics_admin_v1alpha_expanded_data_set_proto_init()
	file_google_analytics_admin_v1alpha_resources_proto_init()
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunAccessReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunAccessReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGlobalSiteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataSharingSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcknowledgeUserDataCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcknowledgeUserDataCollectionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSKAdNetworkConversionValueSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSKAdNetworkConversionValueSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSKAdNetworkConversionValueSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSKAdNetworkConversionValueSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSKAdNetworkConversionValueSchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSKAdNetworkConversionValueSchemasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGoogleSignalsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleSignalsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDisplayVideo360AdvertiserLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinkProposalsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDisplayVideo360AdvertiserLinkProposalsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDisplayVideo360AdvertiserLinkProposalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelDisplayVideo360AdvertiserLinkProposalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSearchAds360LinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchAds360LinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchAds360LinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSearchAds360LinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSearchAds360LinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSearchAds360LinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCalculatedMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCalculatedMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCalculatedMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCalculatedMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCalculatedMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCalculatedMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAudiencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAudiencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveAudienceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAttributionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAttributionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccessBindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAccessBindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAccessBindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccessBindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccessBindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAccessBindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateAccessBindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateAccessBindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccessBindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateAccessBindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateAccessBindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccessBindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteAccessBindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateExpandedDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateExpandedDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExpandedDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExpandedDataSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListExpandedDataSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListExpandedDataSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[125].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChannelGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[126].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[127].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteChannelGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[128].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetChannelGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[129].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[130].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[131].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetAutomatedGa4ConfigurationOptOutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[132].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetAutomatedGa4ConfigurationOptOutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[133].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchAutomatedGa4ConfigurationOptOutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[134].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchAutomatedGa4ConfigurationOptOutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[135].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBigQueryLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[136].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBigQueryLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[137].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBigQueryLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[138].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEnhancedMeasurementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[139].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEnhancedMeasurementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[140].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataRedactionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[141].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataRedactionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[142].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectedSiteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[143].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectedSiteTagResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[144].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConnectedSiteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[145].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectedSiteTagsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[146].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectedSiteTagsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[147].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAdSenseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[148].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAdSenseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[149].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAdSenseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[150].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdSenseLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[151].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdSenseLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[152].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchConnectedGa4PropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[153].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchConnectedGa4PropertyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[154].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEventCreateRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[155].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEventCreateRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[156].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEventCreateRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[157].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEventCreateRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[158].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEventCreateRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[159].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEventCreateRulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[160].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRollupPropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[161].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRollupPropertyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[162].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRollupPropertySourceLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[163].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRollupPropertySourceLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[164].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRollupPropertySourceLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[165].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRollupPropertySourceLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[166].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRollupPropertySourceLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[167].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSubpropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[168].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSubpropertyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[169].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSubpropertyEventFilterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[170].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSubpropertyEventFilterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[171].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubpropertyEventFiltersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[172].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubpropertyEventFiltersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[173].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSubpropertyEventFilterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes[174].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSubpropertyEventFilterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   175,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs,
		MessageInfos:      file_google_analytics_admin_v1alpha_analytics_admin_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_analytics_admin_proto = out.File
	file_google_analytics_admin_v1alpha_analytics_admin_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_analytics_admin_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_analytics_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyticsAdminServiceClient is the client API for AnalyticsAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyticsAdminServiceClient interface {
	// Lookup for a single Account.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// AccessBindings) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not a GA4 Property.
	DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Updates a property.
	UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or through this API) before MeasurementProtocolSecret resources may be
	// created.
	AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error)
	// Looks up a single SKAdNetworkConversionValueSchema.
	GetSKAdNetworkConversionValueSchema(ctx context.Context, in *GetSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error)
	// Creates a SKAdNetworkConversionValueSchema.
	CreateSKAdNetworkConversionValueSchema(ctx context.Context, in *CreateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error)
	// Deletes target SKAdNetworkConversionValueSchema.
	DeleteSKAdNetworkConversionValueSchema(ctx context.Context, in *DeleteSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a SKAdNetworkConversionValueSchema.
	UpdateSKAdNetworkConversionValueSchema(ctx context.Context, in *UpdateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error)
	// Lists SKAdNetworkConversionValueSchema on a stream.
	// Properties can have at most one SKAdNetworkConversionValueSchema.
	ListSKAdNetworkConversionValueSchemas(ctx context.Context, in *ListSKAdNetworkConversionValueSchemasRequest, opts ...grpc.CallOption) (*ListSKAdNetworkConversionValueSchemasResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Updates a conversion event with the specified attributes.
	UpdateConversionEvent(ctx context.Context, in *UpdateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lookup for a single Audience.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	GetAudience(ctx context.Context, in *GetAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Lists Audiences on a property.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	ListAudiences(ctx context.Context, in *ListAudiencesRequest, opts ...grpc.CallOption) (*ListAudiencesResponse, error)
	// Creates an Audience.
	CreateAudience(ctx context.Context, in *CreateAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Updates an Audience on a property.
	UpdateAudience(ctx context.Context, in *UpdateAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Archives an Audience on a property.
	ArchiveAudience(ctx context.Context, in *ArchiveAudienceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Look up a single SearchAds360Link
	GetSearchAds360Link(ctx context.Context, in *GetSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error)
	// Lists all SearchAds360Links on a property.
	ListSearchAds360Links(ctx context.Context, in *ListSearchAds360LinksRequest, opts ...grpc.CallOption) (*ListSearchAds360LinksResponse, error)
	// Creates a SearchAds360Link.
	CreateSearchAds360Link(ctx context.Context, in *CreateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error)
	// Deletes a SearchAds360Link on a property.
	DeleteSearchAds360Link(ctx context.Context, in *DeleteSearchAds360LinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a SearchAds360Link on a property.
	UpdateSearchAds360Link(ctx context.Context, in *UpdateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error)
	// Lookup for a AttributionSettings singleton.
	GetAttributionSettings(ctx context.Context, in *GetAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error)
	// Updates attribution settings on a property.
	UpdateAttributionSettings(ctx context.Context, in *UpdateAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error)
	// Returns a customized report of data access records. The report provides
	// records of each time a user reads Google Analytics reporting data. Access
	// records are retained for up to 2 years.
	//
	// Data Access Reports can be requested for a property. Reports may be
	// requested for any property, but dimensions that aren't related to quota can
	// only be requested on Google Analytics 360 properties. This method is only
	// available to Administrators.
	//
	// These data access records include GA4 UI Reporting, GA4 UI Explorations,
	// GA4 Data API, and other products like Firebase & Admob that can retrieve
	// data from Google Analytics through a linkage. These records don't include
	// property configuration changes like adding a stream or changing a
	// property's time zone. For configuration change history, see
	// [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
	RunAccessReport(ctx context.Context, in *RunAccessReportRequest, opts ...grpc.CallOption) (*RunAccessReportResponse, error)
	// Creates an access binding on an account or property.
	CreateAccessBinding(ctx context.Context, in *CreateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error)
	// Gets information about an access binding.
	GetAccessBinding(ctx context.Context, in *GetAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error)
	// Updates an access binding on an account or property.
	UpdateAccessBinding(ctx context.Context, in *UpdateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error)
	// Deletes an access binding on an account or property.
	DeleteAccessBinding(ctx context.Context, in *DeleteAccessBindingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all access bindings on an account or property.
	ListAccessBindings(ctx context.Context, in *ListAccessBindingsRequest, opts ...grpc.CallOption) (*ListAccessBindingsResponse, error)
	// Creates information about multiple access bindings to an account or
	// property.
	//
	// This method is transactional. If any AccessBinding cannot be created, none
	// of the AccessBindings will be created.
	BatchCreateAccessBindings(ctx context.Context, in *BatchCreateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchCreateAccessBindingsResponse, error)
	// Gets information about multiple access bindings to an account or property.
	BatchGetAccessBindings(ctx context.Context, in *BatchGetAccessBindingsRequest, opts ...grpc.CallOption) (*BatchGetAccessBindingsResponse, error)
	// Updates information about multiple access bindings to an account or
	// property.
	BatchUpdateAccessBindings(ctx context.Context, in *BatchUpdateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchUpdateAccessBindingsResponse, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteAccessBindings(ctx context.Context, in *BatchDeleteAccessBindingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single ExpandedDataSet.
	GetExpandedDataSet(ctx context.Context, in *GetExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error)
	// Lists ExpandedDataSets on a property.
	ListExpandedDataSets(ctx context.Context, in *ListExpandedDataSetsRequest, opts ...grpc.CallOption) (*ListExpandedDataSetsResponse, error)
	// Creates a ExpandedDataSet.
	CreateExpandedDataSet(ctx context.Context, in *CreateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error)
	// Updates a ExpandedDataSet on a property.
	UpdateExpandedDataSet(ctx context.Context, in *UpdateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error)
	// Deletes a ExpandedDataSet on a property.
	DeleteExpandedDataSet(ctx context.Context, in *DeleteExpandedDataSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single ChannelGroup.
	GetChannelGroup(ctx context.Context, in *GetChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error)
	// Lists ChannelGroups on a property.
	ListChannelGroups(ctx context.Context, in *ListChannelGroupsRequest, opts ...grpc.CallOption) (*ListChannelGroupsResponse, error)
	// Creates a ChannelGroup.
	CreateChannelGroup(ctx context.Context, in *CreateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error)
	// Updates a ChannelGroup.
	UpdateChannelGroup(ctx context.Context, in *UpdateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error)
	// Deletes a ChannelGroup on a property.
	DeleteChannelGroup(ctx context.Context, in *DeleteChannelGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Sets the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	SetAutomatedGa4ConfigurationOptOut(ctx context.Context, in *SetAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*SetAutomatedGa4ConfigurationOptOutResponse, error)
	// Fetches the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	FetchAutomatedGa4ConfigurationOptOut(ctx context.Context, in *FetchAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*FetchAutomatedGa4ConfigurationOptOutResponse, error)
	// Lookup for a single BigQuery Link.
	GetBigQueryLink(ctx context.Context, in *GetBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error)
	// Lists BigQuery Links on a property.
	ListBigQueryLinks(ctx context.Context, in *ListBigQueryLinksRequest, opts ...grpc.CallOption) (*ListBigQueryLinksResponse, error)
	// Returns the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Updates the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Creates a connected site tag for a Universal Analytics property. You can
	// create a maximum of 20 connected site tags per property.
	// Note: This API cannot be used on GA4 properties.
	CreateConnectedSiteTag(ctx context.Context, in *CreateConnectedSiteTagRequest, opts ...grpc.CallOption) (*CreateConnectedSiteTagResponse, error)
	// Deletes a connected site tag for a Universal Analytics property.
	// Note: this has no effect on GA4 properties.
	DeleteConnectedSiteTag(ctx context.Context, in *DeleteConnectedSiteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the connected site tags for a Universal Analytics property. A maximum
	// of 20 connected site tags will be returned. Note: this has no effect on GA4
	// property.
	ListConnectedSiteTags(ctx context.Context, in *ListConnectedSiteTagsRequest, opts ...grpc.CallOption) (*ListConnectedSiteTagsResponse, error)
	// Given a specified UA property, looks up the GA4 property connected to it.
	// Note: this cannot be used with GA4 properties.
	FetchConnectedGa4Property(ctx context.Context, in *FetchConnectedGa4PropertyRequest, opts ...grpc.CallOption) (*FetchConnectedGa4PropertyResponse, error)
	// Looks up a single AdSenseLink.
	GetAdSenseLink(ctx context.Context, in *GetAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error)
	// Creates an AdSenseLink.
	CreateAdSenseLink(ctx context.Context, in *CreateAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error)
	// Deletes an AdSenseLink.
	DeleteAdSenseLink(ctx context.Context, in *DeleteAdSenseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists AdSenseLinks on a property.
	ListAdSenseLinks(ctx context.Context, in *ListAdSenseLinksRequest, opts ...grpc.CallOption) (*ListAdSenseLinksResponse, error)
	// Lookup for a single EventCreateRule.
	GetEventCreateRule(ctx context.Context, in *GetEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error)
	// Lists EventCreateRules on a web data stream.
	ListEventCreateRules(ctx context.Context, in *ListEventCreateRulesRequest, opts ...grpc.CallOption) (*ListEventCreateRulesResponse, error)
	// Creates an EventCreateRule.
	CreateEventCreateRule(ctx context.Context, in *CreateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error)
	// Updates an EventCreateRule.
	UpdateEventCreateRule(ctx context.Context, in *UpdateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error)
	// Deletes an EventCreateRule.
	DeleteEventCreateRule(ctx context.Context, in *DeleteEventCreateRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DataRedactionSettings on a property.
	UpdateDataRedactionSettings(ctx context.Context, in *UpdateDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error)
	// Lookup for a single DataRedactionSettings.
	GetDataRedactionSettings(ctx context.Context, in *GetDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error)
	// Lookup for a single CalculatedMetric.
	GetCalculatedMetric(ctx context.Context, in *GetCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error)
	// Creates a CalculatedMetric.
	CreateCalculatedMetric(ctx context.Context, in *CreateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error)
	// Lists CalculatedMetrics on a property.
	ListCalculatedMetrics(ctx context.Context, in *ListCalculatedMetricsRequest, opts ...grpc.CallOption) (*ListCalculatedMetricsResponse, error)
	// Updates a CalculatedMetric on a property.
	UpdateCalculatedMetric(ctx context.Context, in *UpdateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error)
	// Deletes a CalculatedMetric on a property.
	DeleteCalculatedMetric(ctx context.Context, in *DeleteCalculatedMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a roll-up property and all roll-up property source links.
	CreateRollupProperty(ctx context.Context, in *CreateRollupPropertyRequest, opts ...grpc.CallOption) (*CreateRollupPropertyResponse, error)
	// Lookup for a single roll-up property source Link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	GetRollupPropertySourceLink(ctx context.Context, in *GetRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error)
	// Lists roll-up property source Links on a property.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	ListRollupPropertySourceLinks(ctx context.Context, in *ListRollupPropertySourceLinksRequest, opts ...grpc.CallOption) (*ListRollupPropertySourceLinksResponse, error)
	// Creates a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	CreateRollupPropertySourceLink(ctx context.Context, in *CreateRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error)
	// Deletes a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	DeleteRollupPropertySourceLink(ctx context.Context, in *DeleteRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a subproperty and a subproperty event filter that applies to the
	// created subproperty.
	CreateSubproperty(ctx context.Context, in *CreateSubpropertyRequest, opts ...grpc.CallOption) (*CreateSubpropertyResponse, error)
	// Creates a subproperty Event Filter.
	CreateSubpropertyEventFilter(ctx context.Context, in *CreateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error)
	// Lookup for a single subproperty Event Filter.
	GetSubpropertyEventFilter(ctx context.Context, in *GetSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error)
	// List all subproperty Event Filters on a property.
	ListSubpropertyEventFilters(ctx context.Context, in *ListSubpropertyEventFiltersRequest, opts ...grpc.CallOption) (*ListSubpropertyEventFiltersResponse, error)
	// Updates a subproperty Event Filter.
	UpdateSubpropertyEventFilter(ctx context.Context, in *UpdateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error)
	// Deletes a subproperty event filter.
	DeleteSubpropertyEventFilter(ctx context.Context, in *DeleteSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type analyticsAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsAdminServiceClient(cc grpc.ClientConnInterface) AnalyticsAdminServiceClient {
	return &analyticsAdminServiceClient{cc}
}

func (c *analyticsAdminServiceClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error) {
	out := new(ProvisionAccountTicketResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionAccountTicket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error) {
	out := new(ListAccountSummariesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccountSummaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error) {
	out := new(ListPropertiesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListProperties", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error) {
	out := new(ListFirebaseLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListFirebaseLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error) {
	out := new(GlobalSiteTag)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGlobalSiteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error) {
	out := new(ListGoogleAdsLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListGoogleAdsLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error) {
	out := new(DataSharingSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataSharingSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error) {
	out := new(ListMeasurementProtocolSecretsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListMeasurementProtocolSecrets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error) {
	out := new(AcknowledgeUserDataCollectionResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/AcknowledgeUserDataCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetSKAdNetworkConversionValueSchema(ctx context.Context, in *GetSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error) {
	out := new(SKAdNetworkConversionValueSchema)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetSKAdNetworkConversionValueSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSKAdNetworkConversionValueSchema(ctx context.Context, in *CreateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error) {
	out := new(SKAdNetworkConversionValueSchema)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSKAdNetworkConversionValueSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteSKAdNetworkConversionValueSchema(ctx context.Context, in *DeleteSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteSKAdNetworkConversionValueSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateSKAdNetworkConversionValueSchema(ctx context.Context, in *UpdateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error) {
	out := new(SKAdNetworkConversionValueSchema)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateSKAdNetworkConversionValueSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListSKAdNetworkConversionValueSchemas(ctx context.Context, in *ListSKAdNetworkConversionValueSchemasRequest, opts ...grpc.CallOption) (*ListSKAdNetworkConversionValueSchemasResponse, error) {
	out := new(ListSKAdNetworkConversionValueSchemasResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListSKAdNetworkConversionValueSchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error) {
	out := new(SearchChangeHistoryEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/SearchChangeHistoryEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGoogleSignalsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleSignalsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateConversionEvent(ctx context.Context, in *UpdateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error) {
	out := new(ListConversionEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConversionEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDisplayVideo360AdvertiserLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinkProposalsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinkProposals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	out := new(ApproveDisplayVideo360AdvertiserLinkProposalResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ApproveDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CancelDisplayVideo360AdvertiserLinkProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error) {
	out := new(ListCustomDimensionsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomDimensions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error) {
	out := new(ListCustomMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error) {
	out := new(ListDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAudience(ctx context.Context, in *GetAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAudiences(ctx context.Context, in *ListAudiencesRequest, opts ...grpc.CallOption) (*ListAudiencesResponse, error) {
	out := new(ListAudiencesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAudiences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAudience(ctx context.Context, in *CreateAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAudience(ctx context.Context, in *UpdateAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveAudience(ctx context.Context, in *ArchiveAudienceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveAudience", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetSearchAds360Link(ctx context.Context, in *GetSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error) {
	out := new(SearchAds360Link)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetSearchAds360Link", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListSearchAds360Links(ctx context.Context, in *ListSearchAds360LinksRequest, opts ...grpc.CallOption) (*ListSearchAds360LinksResponse, error) {
	out := new(ListSearchAds360LinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListSearchAds360Links", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSearchAds360Link(ctx context.Context, in *CreateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error) {
	out := new(SearchAds360Link)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSearchAds360Link", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteSearchAds360Link(ctx context.Context, in *DeleteSearchAds360LinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteSearchAds360Link", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateSearchAds360Link(ctx context.Context, in *UpdateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error) {
	out := new(SearchAds360Link)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateSearchAds360Link", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAttributionSettings(ctx context.Context, in *GetAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error) {
	out := new(AttributionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAttributionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAttributionSettings(ctx context.Context, in *UpdateAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error) {
	out := new(AttributionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAttributionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) RunAccessReport(ctx context.Context, in *RunAccessReportRequest, opts ...grpc.CallOption) (*RunAccessReportResponse, error) {
	out := new(RunAccessReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/RunAccessReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAccessBinding(ctx context.Context, in *CreateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error) {
	out := new(AccessBinding)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAccessBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAccessBinding(ctx context.Context, in *GetAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error) {
	out := new(AccessBinding)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccessBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccessBinding(ctx context.Context, in *UpdateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error) {
	out := new(AccessBinding)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccessBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccessBinding(ctx context.Context, in *DeleteAccessBindingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccessBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccessBindings(ctx context.Context, in *ListAccessBindingsRequest, opts ...grpc.CallOption) (*ListAccessBindingsResponse, error) {
	out := new(ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchCreateAccessBindings(ctx context.Context, in *BatchCreateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchCreateAccessBindingsResponse, error) {
	out := new(BatchCreateAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchCreateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchGetAccessBindings(ctx context.Context, in *BatchGetAccessBindingsRequest, opts ...grpc.CallOption) (*BatchGetAccessBindingsResponse, error) {
	out := new(BatchGetAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchGetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchUpdateAccessBindings(ctx context.Context, in *BatchUpdateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchUpdateAccessBindingsResponse, error) {
	out := new(BatchUpdateAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchUpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchDeleteAccessBindings(ctx context.Context, in *BatchDeleteAccessBindingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchDeleteAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetExpandedDataSet(ctx context.Context, in *GetExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error) {
	out := new(ExpandedDataSet)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetExpandedDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListExpandedDataSets(ctx context.Context, in *ListExpandedDataSetsRequest, opts ...grpc.CallOption) (*ListExpandedDataSetsResponse, error) {
	out := new(ListExpandedDataSetsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListExpandedDataSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateExpandedDataSet(ctx context.Context, in *CreateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error) {
	out := new(ExpandedDataSet)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateExpandedDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateExpandedDataSet(ctx context.Context, in *UpdateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error) {
	out := new(ExpandedDataSet)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateExpandedDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteExpandedDataSet(ctx context.Context, in *DeleteExpandedDataSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteExpandedDataSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetChannelGroup(ctx context.Context, in *GetChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error) {
	out := new(ChannelGroup)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetChannelGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListChannelGroups(ctx context.Context, in *ListChannelGroupsRequest, opts ...grpc.CallOption) (*ListChannelGroupsResponse, error) {
	out := new(ListChannelGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListChannelGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateChannelGroup(ctx context.Context, in *CreateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error) {
	out := new(ChannelGroup)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateChannelGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateChannelGroup(ctx context.Context, in *UpdateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error) {
	out := new(ChannelGroup)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateChannelGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteChannelGroup(ctx context.Context, in *DeleteChannelGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteChannelGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SetAutomatedGa4ConfigurationOptOut(ctx context.Context, in *SetAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*SetAutomatedGa4ConfigurationOptOutResponse, error) {
	out := new(SetAutomatedGa4ConfigurationOptOutResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/SetAutomatedGa4ConfigurationOptOut", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) FetchAutomatedGa4ConfigurationOptOut(ctx context.Context, in *FetchAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*FetchAutomatedGa4ConfigurationOptOutResponse, error) {
	out := new(FetchAutomatedGa4ConfigurationOptOutResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/FetchAutomatedGa4ConfigurationOptOut", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetBigQueryLink(ctx context.Context, in *GetBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error) {
	out := new(BigQueryLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetBigQueryLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListBigQueryLinks(ctx context.Context, in *ListBigQueryLinksRequest, opts ...grpc.CallOption) (*ListBigQueryLinksResponse, error) {
	out := new(ListBigQueryLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListBigQueryLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEnhancedMeasurementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEnhancedMeasurementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateConnectedSiteTag(ctx context.Context, in *CreateConnectedSiteTagRequest, opts ...grpc.CallOption) (*CreateConnectedSiteTagResponse, error) {
	out := new(CreateConnectedSiteTagResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConnectedSiteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteConnectedSiteTag(ctx context.Context, in *DeleteConnectedSiteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConnectedSiteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListConnectedSiteTags(ctx context.Context, in *ListConnectedSiteTagsRequest, opts ...grpc.CallOption) (*ListConnectedSiteTagsResponse, error) {
	out := new(ListConnectedSiteTagsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConnectedSiteTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) FetchConnectedGa4Property(ctx context.Context, in *FetchConnectedGa4PropertyRequest, opts ...grpc.CallOption) (*FetchConnectedGa4PropertyResponse, error) {
	out := new(FetchConnectedGa4PropertyResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/FetchConnectedGa4Property", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAdSenseLink(ctx context.Context, in *GetAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error) {
	out := new(AdSenseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAdSenseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAdSenseLink(ctx context.Context, in *CreateAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error) {
	out := new(AdSenseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAdSenseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAdSenseLink(ctx context.Context, in *DeleteAdSenseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAdSenseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAdSenseLinks(ctx context.Context, in *ListAdSenseLinksRequest, opts ...grpc.CallOption) (*ListAdSenseLinksResponse, error) {
	out := new(ListAdSenseLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAdSenseLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetEventCreateRule(ctx context.Context, in *GetEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error) {
	out := new(EventCreateRule)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEventCreateRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListEventCreateRules(ctx context.Context, in *ListEventCreateRulesRequest, opts ...grpc.CallOption) (*ListEventCreateRulesResponse, error) {
	out := new(ListEventCreateRulesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListEventCreateRules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateEventCreateRule(ctx context.Context, in *CreateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error) {
	out := new(EventCreateRule)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateEventCreateRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateEventCreateRule(ctx context.Context, in *UpdateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error) {
	out := new(EventCreateRule)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEventCreateRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteEventCreateRule(ctx context.Context, in *DeleteEventCreateRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteEventCreateRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRedactionSettings(ctx context.Context, in *UpdateDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error) {
	out := new(DataRedactionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRedactionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRedactionSettings(ctx context.Context, in *GetDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error) {
	out := new(DataRedactionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRedactionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCalculatedMetric(ctx context.Context, in *GetCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error) {
	out := new(CalculatedMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCalculatedMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCalculatedMetric(ctx context.Context, in *CreateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error) {
	out := new(CalculatedMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCalculatedMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCalculatedMetrics(ctx context.Context, in *ListCalculatedMetricsRequest, opts ...grpc.CallOption) (*ListCalculatedMetricsResponse, error) {
	out := new(ListCalculatedMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCalculatedMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCalculatedMetric(ctx context.Context, in *UpdateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error) {
	out := new(CalculatedMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCalculatedMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteCalculatedMetric(ctx context.Context, in *DeleteCalculatedMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteCalculatedMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateRollupProperty(ctx context.Context, in *CreateRollupPropertyRequest, opts ...grpc.CallOption) (*CreateRollupPropertyResponse, error) {
	out := new(CreateRollupPropertyResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateRollupProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetRollupPropertySourceLink(ctx context.Context, in *GetRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error) {
	out := new(RollupPropertySourceLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetRollupPropertySourceLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListRollupPropertySourceLinks(ctx context.Context, in *ListRollupPropertySourceLinksRequest, opts ...grpc.CallOption) (*ListRollupPropertySourceLinksResponse, error) {
	out := new(ListRollupPropertySourceLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListRollupPropertySourceLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateRollupPropertySourceLink(ctx context.Context, in *CreateRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error) {
	out := new(RollupPropertySourceLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateRollupPropertySourceLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteRollupPropertySourceLink(ctx context.Context, in *DeleteRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteRollupPropertySourceLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSubproperty(ctx context.Context, in *CreateSubpropertyRequest, opts ...grpc.CallOption) (*CreateSubpropertyResponse, error) {
	out := new(CreateSubpropertyResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSubproperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSubpropertyEventFilter(ctx context.Context, in *CreateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error) {
	out := new(SubpropertyEventFilter)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSubpropertyEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetSubpropertyEventFilter(ctx context.Context, in *GetSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error) {
	out := new(SubpropertyEventFilter)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetSubpropertyEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListSubpropertyEventFilters(ctx context.Context, in *ListSubpropertyEventFiltersRequest, opts ...grpc.CallOption) (*ListSubpropertyEventFiltersResponse, error) {
	out := new(ListSubpropertyEventFiltersResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListSubpropertyEventFilters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateSubpropertyEventFilter(ctx context.Context, in *UpdateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error) {
	out := new(SubpropertyEventFilter)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateSubpropertyEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteSubpropertyEventFilter(ctx context.Context, in *DeleteSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteSubpropertyEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsAdminServiceServer is the server API for AnalyticsAdminService service.
type AnalyticsAdminServiceServer interface {
	// Lookup for a single Account.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// AccessBindings) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(context.Context, *GetPropertyRequest) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not a GA4 Property.
	DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error)
	// Updates a property.
	UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or through this API) before MeasurementProtocolSecret resources may be
	// created.
	AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error)
	// Looks up a single SKAdNetworkConversionValueSchema.
	GetSKAdNetworkConversionValueSchema(context.Context, *GetSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error)
	// Creates a SKAdNetworkConversionValueSchema.
	CreateSKAdNetworkConversionValueSchema(context.Context, *CreateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error)
	// Deletes target SKAdNetworkConversionValueSchema.
	DeleteSKAdNetworkConversionValueSchema(context.Context, *DeleteSKAdNetworkConversionValueSchemaRequest) (*emptypb.Empty, error)
	// Updates a SKAdNetworkConversionValueSchema.
	UpdateSKAdNetworkConversionValueSchema(context.Context, *UpdateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error)
	// Lists SKAdNetworkConversionValueSchema on a stream.
	// Properties can have at most one SKAdNetworkConversionValueSchema.
	ListSKAdNetworkConversionValueSchemas(context.Context, *ListSKAdNetworkConversionValueSchemasRequest) (*ListSKAdNetworkConversionValueSchemasResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error)
	// Updates a conversion event with the specified attributes.
	UpdateConversionEvent(context.Context, *UpdateConversionEventRequest) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error)
	// Lookup for a single Audience.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	GetAudience(context.Context, *GetAudienceRequest) (*Audience, error)
	// Lists Audiences on a property.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	ListAudiences(context.Context, *ListAudiencesRequest) (*ListAudiencesResponse, error)
	// Creates an Audience.
	CreateAudience(context.Context, *CreateAudienceRequest) (*Audience, error)
	// Updates an Audience on a property.
	UpdateAudience(context.Context, *UpdateAudienceRequest) (*Audience, error)
	// Archives an Audience on a property.
	ArchiveAudience(context.Context, *ArchiveAudienceRequest) (*emptypb.Empty, error)
	// Look up a single SearchAds360Link
	GetSearchAds360Link(context.Context, *GetSearchAds360LinkRequest) (*SearchAds360Link, error)
	// Lists all SearchAds360Links on a property.
	ListSearchAds360Links(context.Context, *ListSearchAds360LinksRequest) (*ListSearchAds360LinksResponse, error)
	// Creates a SearchAds360Link.
	CreateSearchAds360Link(context.Context, *CreateSearchAds360LinkRequest) (*SearchAds360Link, error)
	// Deletes a SearchAds360Link on a property.
	DeleteSearchAds360Link(context.Context, *DeleteSearchAds360LinkRequest) (*emptypb.Empty, error)
	// Updates a SearchAds360Link on a property.
	UpdateSearchAds360Link(context.Context, *UpdateSearchAds360LinkRequest) (*SearchAds360Link, error)
	// Lookup for a AttributionSettings singleton.
	GetAttributionSettings(context.Context, *GetAttributionSettingsRequest) (*AttributionSettings, error)
	// Updates attribution settings on a property.
	UpdateAttributionSettings(context.Context, *UpdateAttributionSettingsRequest) (*AttributionSettings, error)
	// Returns a customized report of data access records. The report provides
	// records of each time a user reads Google Analytics reporting data. Access
	// records are retained for up to 2 years.
	//
	// Data Access Reports can be requested for a property. Reports may be
	// requested for any property, but dimensions that aren't related to quota can
	// only be requested on Google Analytics 360 properties. This method is only
	// available to Administrators.
	//
	// These data access records include GA4 UI Reporting, GA4 UI Explorations,
	// GA4 Data API, and other products like Firebase & Admob that can retrieve
	// data from Google Analytics through a linkage. These records don't include
	// property configuration changes like adding a stream or changing a
	// property's time zone. For configuration change history, see
	// [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
	RunAccessReport(context.Context, *RunAccessReportRequest) (*RunAccessReportResponse, error)
	// Creates an access binding on an account or property.
	CreateAccessBinding(context.Context, *CreateAccessBindingRequest) (*AccessBinding, error)
	// Gets information about an access binding.
	GetAccessBinding(context.Context, *GetAccessBindingRequest) (*AccessBinding, error)
	// Updates an access binding on an account or property.
	UpdateAccessBinding(context.Context, *UpdateAccessBindingRequest) (*AccessBinding, error)
	// Deletes an access binding on an account or property.
	DeleteAccessBinding(context.Context, *DeleteAccessBindingRequest) (*emptypb.Empty, error)
	// Lists all access bindings on an account or property.
	ListAccessBindings(context.Context, *ListAccessBindingsRequest) (*ListAccessBindingsResponse, error)
	// Creates information about multiple access bindings to an account or
	// property.
	//
	// This method is transactional. If any AccessBinding cannot be created, none
	// of the AccessBindings will be created.
	BatchCreateAccessBindings(context.Context, *BatchCreateAccessBindingsRequest) (*BatchCreateAccessBindingsResponse, error)
	// Gets information about multiple access bindings to an account or property.
	BatchGetAccessBindings(context.Context, *BatchGetAccessBindingsRequest) (*BatchGetAccessBindingsResponse, error)
	// Updates information about multiple access bindings to an account or
	// property.
	BatchUpdateAccessBindings(context.Context, *BatchUpdateAccessBindingsRequest) (*BatchUpdateAccessBindingsResponse, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteAccessBindings(context.Context, *BatchDeleteAccessBindingsRequest) (*emptypb.Empty, error)
	// Lookup for a single ExpandedDataSet.
	GetExpandedDataSet(context.Context, *GetExpandedDataSetRequest) (*ExpandedDataSet, error)
	// Lists ExpandedDataSets on a property.
	ListExpandedDataSets(context.Context, *ListExpandedDataSetsRequest) (*ListExpandedDataSetsResponse, error)
	// Creates a ExpandedDataSet.
	CreateExpandedDataSet(context.Context, *CreateExpandedDataSetRequest) (*ExpandedDataSet, error)
	// Updates a ExpandedDataSet on a property.
	UpdateExpandedDataSet(context.Context, *UpdateExpandedDataSetRequest) (*ExpandedDataSet, error)
	// Deletes a ExpandedDataSet on a property.
	DeleteExpandedDataSet(context.Context, *DeleteExpandedDataSetRequest) (*emptypb.Empty, error)
	// Lookup for a single ChannelGroup.
	GetChannelGroup(context.Context, *GetChannelGroupRequest) (*ChannelGroup, error)
	// Lists ChannelGroups on a property.
	ListChannelGroups(context.Context, *ListChannelGroupsRequest) (*ListChannelGroupsResponse, error)
	// Creates a ChannelGroup.
	CreateChannelGroup(context.Context, *CreateChannelGroupRequest) (*ChannelGroup, error)
	// Updates a ChannelGroup.
	UpdateChannelGroup(context.Context, *UpdateChannelGroupRequest) (*ChannelGroup, error)
	// Deletes a ChannelGroup on a property.
	DeleteChannelGroup(context.Context, *DeleteChannelGroupRequest) (*emptypb.Empty, error)
	// Sets the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	SetAutomatedGa4ConfigurationOptOut(context.Context, *SetAutomatedGa4ConfigurationOptOutRequest) (*SetAutomatedGa4ConfigurationOptOutResponse, error)
	// Fetches the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	FetchAutomatedGa4ConfigurationOptOut(context.Context, *FetchAutomatedGa4ConfigurationOptOutRequest) (*FetchAutomatedGa4ConfigurationOptOutResponse, error)
	// Lookup for a single BigQuery Link.
	GetBigQueryLink(context.Context, *GetBigQueryLinkRequest) (*BigQueryLink, error)
	// Lists BigQuery Links on a property.
	ListBigQueryLinks(context.Context, *ListBigQueryLinksRequest) (*ListBigQueryLinksResponse, error)
	// Returns the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Updates the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Creates a connected site tag for a Universal Analytics property. You can
	// create a maximum of 20 connected site tags per property.
	// Note: This API cannot be used on GA4 properties.
	CreateConnectedSiteTag(context.Context, *CreateConnectedSiteTagRequest) (*CreateConnectedSiteTagResponse, error)
	// Deletes a connected site tag for a Universal Analytics property.
	// Note: this has no effect on GA4 properties.
	DeleteConnectedSiteTag(context.Context, *DeleteConnectedSiteTagRequest) (*emptypb.Empty, error)
	// Lists the connected site tags for a Universal Analytics property. A maximum
	// of 20 connected site tags will be returned. Note: this has no effect on GA4
	// property.
	ListConnectedSiteTags(context.Context, *ListConnectedSiteTagsRequest) (*ListConnectedSiteTagsResponse, error)
	// Given a specified UA property, looks up the GA4 property connected to it.
	// Note: this cannot be used with GA4 properties.
	FetchConnectedGa4Property(context.Context, *FetchConnectedGa4PropertyRequest) (*FetchConnectedGa4PropertyResponse, error)
	// Looks up a single AdSenseLink.
	GetAdSenseLink(context.Context, *GetAdSenseLinkRequest) (*AdSenseLink, error)
	// Creates an AdSenseLink.
	CreateAdSenseLink(context.Context, *CreateAdSenseLinkRequest) (*AdSenseLink, error)
	// Deletes an AdSenseLink.
	DeleteAdSenseLink(context.Context, *DeleteAdSenseLinkRequest) (*emptypb.Empty, error)
	// Lists AdSenseLinks on a property.
	ListAdSenseLinks(context.Context, *ListAdSenseLinksRequest) (*ListAdSenseLinksResponse, error)
	// Lookup for a single EventCreateRule.
	GetEventCreateRule(context.Context, *GetEventCreateRuleRequest) (*EventCreateRule, error)
	// Lists EventCreateRules on a web data stream.
	ListEventCreateRules(context.Context, *ListEventCreateRulesRequest) (*ListEventCreateRulesResponse, error)
	// Creates an EventCreateRule.
	CreateEventCreateRule(context.Context, *CreateEventCreateRuleRequest) (*EventCreateRule, error)
	// Updates an EventCreateRule.
	UpdateEventCreateRule(context.Context, *UpdateEventCreateRuleRequest) (*EventCreateRule, error)
	// Deletes an EventCreateRule.
	DeleteEventCreateRule(context.Context, *DeleteEventCreateRuleRequest) (*emptypb.Empty, error)
	// Updates a DataRedactionSettings on a property.
	UpdateDataRedactionSettings(context.Context, *UpdateDataRedactionSettingsRequest) (*DataRedactionSettings, error)
	// Lookup for a single DataRedactionSettings.
	GetDataRedactionSettings(context.Context, *GetDataRedactionSettingsRequest) (*DataRedactionSettings, error)
	// Lookup for a single CalculatedMetric.
	GetCalculatedMetric(context.Context, *GetCalculatedMetricRequest) (*CalculatedMetric, error)
	// Creates a CalculatedMetric.
	CreateCalculatedMetric(context.Context, *CreateCalculatedMetricRequest) (*CalculatedMetric, error)
	// Lists CalculatedMetrics on a property.
	ListCalculatedMetrics(context.Context, *ListCalculatedMetricsRequest) (*ListCalculatedMetricsResponse, error)
	// Updates a CalculatedMetric on a property.
	UpdateCalculatedMetric(context.Context, *UpdateCalculatedMetricRequest) (*CalculatedMetric, error)
	// Deletes a CalculatedMetric on a property.
	DeleteCalculatedMetric(context.Context, *DeleteCalculatedMetricRequest) (*emptypb.Empty, error)
	// Create a roll-up property and all roll-up property source links.
	CreateRollupProperty(context.Context, *CreateRollupPropertyRequest) (*CreateRollupPropertyResponse, error)
	// Lookup for a single roll-up property source Link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	GetRollupPropertySourceLink(context.Context, *GetRollupPropertySourceLinkRequest) (*RollupPropertySourceLink, error)
	// Lists roll-up property source Links on a property.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	ListRollupPropertySourceLinks(context.Context, *ListRollupPropertySourceLinksRequest) (*ListRollupPropertySourceLinksResponse, error)
	// Creates a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	CreateRollupPropertySourceLink(context.Context, *CreateRollupPropertySourceLinkRequest) (*RollupPropertySourceLink, error)
	// Deletes a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	DeleteRollupPropertySourceLink(context.Context, *DeleteRollupPropertySourceLinkRequest) (*emptypb.Empty, error)
	// Create a subproperty and a subproperty event filter that applies to the
	// created subproperty.
	CreateSubproperty(context.Context, *CreateSubpropertyRequest) (*CreateSubpropertyResponse, error)
	// Creates a subproperty Event Filter.
	CreateSubpropertyEventFilter(context.Context, *CreateSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error)
	// Lookup for a single subproperty Event Filter.
	GetSubpropertyEventFilter(context.Context, *GetSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error)
	// List all subproperty Event Filters on a property.
	ListSubpropertyEventFilters(context.Context, *ListSubpropertyEventFiltersRequest) (*ListSubpropertyEventFiltersResponse, error)
	// Updates a subproperty Event Filter.
	UpdateSubpropertyEventFilter(context.Context, *UpdateSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error)
	// Deletes a subproperty event filter.
	DeleteSubpropertyEventFilter(context.Context, *DeleteSubpropertyEventFilterRequest) (*emptypb.Empty, error)
}

// UnimplementedAnalyticsAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyticsAdminServiceServer struct {
}

func (*UnimplementedAnalyticsAdminServiceServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionAccountTicket not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountSummaries not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetProperty(context.Context, *GetPropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProperties not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirebaseLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlobalSiteTag not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleAdsLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataSharingSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMeasurementProtocolSecrets not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeUserDataCollection not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetSKAdNetworkConversionValueSchema(context.Context, *GetSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSKAdNetworkConversionValueSchema not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateSKAdNetworkConversionValueSchema(context.Context, *CreateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSKAdNetworkConversionValueSchema not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteSKAdNetworkConversionValueSchema(context.Context, *DeleteSKAdNetworkConversionValueSchemaRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSKAdNetworkConversionValueSchema not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateSKAdNetworkConversionValueSchema(context.Context, *UpdateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSKAdNetworkConversionValueSchema not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListSKAdNetworkConversionValueSchemas(context.Context, *ListSKAdNetworkConversionValueSchemasRequest) (*ListSKAdNetworkConversionValueSchemasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSKAdNetworkConversionValueSchemas not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchChangeHistoryEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleSignalsSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleSignalsSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateConversionEvent(context.Context, *UpdateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDisplayVideo360AdvertiserLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinkProposals not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomDimensions not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomMetrics not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCu