/**
 * MIT License
 * 
 * Copyright (c) 2021-2022 Bosch Rexroth AG
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "_cgo_export.h"

#include <stdio.h>
#include <stdbool.h>

#include <variant.h>

void notifyResponseCallback(DLR_RESULT status, NotifyItem *items, uint32_t count, void *userdata)
{
    notifyResponseCallbackGo(status, items, count, (unsigned long long)userdata);
}

// Wrapper for DLR_clientCreateSubscriptionSync with notifyKey instead of userdata
DLR_RESULT ClientCreateSubscriptionSync(DLR_CLIENT client, DLR_VARIANT ruleset, unsigned long long notifyKey, const char *token)
{
    return DLR_clientCreateSubscriptionSync(client, ruleset, notifyResponseCallback, (void *)notifyKey, token);
}
