// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbs

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// This table defines all elements that can be used to set a diagnostic log.
/// It is used for diagnostic messages, warnings and errors.
type LogParametersT struct {
	MainDiagnosisCode string
	DetailedDiagnosisCode string
	UserId string
	Entity string
	Origin string
	UnitName string
	FileName string
	FunctionName string
	LineNumber uint32
	DynamicDescription string
}

func (t *LogParametersT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	mainDiagnosisCodeOffset := builder.CreateString(t.MainDiagnosisCode)
	detailedDiagnosisCodeOffset := builder.CreateString(t.DetailedDiagnosisCode)
	userIdOffset := builder.CreateString(t.UserId)
	entityOffset := builder.CreateString(t.Entity)
	originOffset := builder.CreateString(t.Origin)
	unitNameOffset := builder.CreateString(t.UnitName)
	fileNameOffset := builder.CreateString(t.FileName)
	functionNameOffset := builder.CreateString(t.FunctionName)
	dynamicDescriptionOffset := builder.CreateString(t.DynamicDescription)
	LogParametersStart(builder)
	LogParametersAddMainDiagnosisCode(builder, mainDiagnosisCodeOffset)
	LogParametersAddDetailedDiagnosisCode(builder, detailedDiagnosisCodeOffset)
	LogParametersAddUserId(builder, userIdOffset)
	LogParametersAddEntity(builder, entityOffset)
	LogParametersAddOrigin(builder, originOffset)
	LogParametersAddUnitName(builder, unitNameOffset)
	LogParametersAddFileName(builder, fileNameOffset)
	LogParametersAddFunctionName(builder, functionNameOffset)
	LogParametersAddLineNumber(builder, t.LineNumber)
	LogParametersAddDynamicDescription(builder, dynamicDescriptionOffset)
	return LogParametersEnd(builder)
}

func (rcv *LogParameters) UnPackTo(t *LogParametersT) {
	t.MainDiagnosisCode = string(rcv.MainDiagnosisCode())
	t.DetailedDiagnosisCode = string(rcv.DetailedDiagnosisCode())
	t.UserId = string(rcv.UserId())
	t.Entity = string(rcv.Entity())
	t.Origin = string(rcv.Origin())
	t.UnitName = string(rcv.UnitName())
	t.FileName = string(rcv.FileName())
	t.FunctionName = string(rcv.FunctionName())
	t.LineNumber = rcv.LineNumber()
	t.DynamicDescription = string(rcv.DynamicDescription())
}

func (rcv *LogParameters) UnPack() *LogParametersT {
	if rcv == nil { return nil }
	t := &LogParametersT{}
	rcv.UnPackTo(t)
	return t
}

type LogParameters struct {
	_tab flatbuffers.Table
}

func GetRootAsLogParameters(buf []byte, offset flatbuffers.UOffsetT) *LogParameters {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &LogParameters{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsLogParameters(buf []byte, offset flatbuffers.UOffsetT) *LogParameters {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &LogParameters{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *LogParameters) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *LogParameters) Table() flatbuffers.Table {
	return rcv._tab
}

/// Main diagnostic number.
func (rcv *LogParameters) MainDiagnosisCode() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Main diagnostic number.
/// Detailed diagnostic number.
func (rcv *LogParameters) DetailedDiagnosisCode() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Detailed diagnostic number.
/// User id of the user who sends the log.
func (rcv *LogParameters) UserId() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// User id of the user who sends the log.
/// Object/resource that notifies the log (e.g. motion/axs/axisY).
func (rcv *LogParameters) Entity() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Object/resource that notifies the log (e.g. motion/axs/axisY).
/// Application that notifies the log (e.g. rexroth-automationcore).
func (rcv *LogParameters) Origin() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Application that notifies the log (e.g. rexroth-automationcore).
/// Unit name of the component that notifies the log (e.g. comm.datalayer).
func (rcv *LogParameters) UnitName() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Unit name of the component that notifies the log (e.g. comm.datalayer).
/// Name of the file from where the log is set.
func (rcv *LogParameters) FileName() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Name of the file from where the log is set.
/// Name of the function from where the log is set.
func (rcv *LogParameters) FunctionName() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Name of the function from where the log is set.
/// Line number from where the log is set.
func (rcv *LogParameters) LineNumber() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

/// Line number from where the log is set.
func (rcv *LogParameters) MutateLineNumber(n uint32) bool {
	return rcv._tab.MutateUint32Slot(20, n)
}

/// Dynamic description to set additional dynamic elements.
func (rcv *LogParameters) DynamicDescription() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(22))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Dynamic description to set additional dynamic elements.
func LogParametersStart(builder *flatbuffers.Builder) {
	builder.StartObject(10)
}
func LogParametersAddMainDiagnosisCode(builder *flatbuffers.Builder, mainDiagnosisCode flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(mainDiagnosisCode), 0)
}
func LogParametersAddDetailedDiagnosisCode(builder *flatbuffers.Builder, detailedDiagnosisCode flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(detailedDiagnosisCode), 0)
}
func LogParametersAddUserId(builder *flatbuffers.Builder, userId flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(userId), 0)
}
func LogParametersAddEntity(builder *flatbuffers.Builder, entity flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(entity), 0)
}
func LogParametersAddOrigin(builder *flatbuffers.Builder, origin flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(origin), 0)
}
func LogParametersAddUnitName(builder *flatbuffers.Builder, unitName flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(unitName), 0)
}
func LogParametersAddFileName(builder *flatbuffers.Builder, fileName flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(fileName), 0)
}
func LogParametersAddFunctionName(builder *flatbuffers.Builder, functionName flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(functionName), 0)
}
func LogParametersAddLineNumber(builder *flatbuffers.Builder, lineNumber uint32) {
	builder.PrependUint32Slot(8, lineNumber, 0)
}
func LogParametersAddDynamicDescription(builder *flatbuffers.Builder, dynamicDescription flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(9, flatbuffers.UOffsetT(dynamicDescription), 0)
}
func LogParametersEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
