#!/bin/bash -eux
# Copyright 2014 The ChromiumOS Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

me=${0##*/}
TMP="$me.tmp"

# Work in scratch directory
cd "$OUTDIR"

# some stuff we'll need
DEVKEYS="${SRCDIR}/tests/devkeys"

# The show command exits with 0 if the data is consistent.
# The verify command exits with 0 only if all the data is verified.

####  keyblock

"${FUTILITY}" show "${DEVKEYS}/firmware.keyblock"

if "${FUTILITY}" verify "${DEVKEYS}/firmware.keyblock" ; then false; fi

"${FUTILITY}" verify "${DEVKEYS}/firmware.keyblock" \
  --publickey "${DEVKEYS}/root_key.vbpubk"


#### firmware vblock

# Get some bits to look at
"${FUTILITY}" dump_fmap -x "${SCRIPT_DIR}/futility/data/bios_peppy_mp.bin" \
  "GBB:${TMP}.gbb" "VBLOCK_A:${TMP}.vblock_a" "FW_MAIN_A:${TMP}.fw_main_a"
"${FUTILITY}" gbb -g -k "${TMP}.rootkey" "${TMP}.gbb"


"${FUTILITY}" show "${TMP}.vblock_a"

"${FUTILITY}" show "${TMP}.vblock_a" --publickey "${TMP}.rootkey"

"${FUTILITY}" show "${TMP}.vblock_a" \
  --publickey "${TMP}.rootkey" \
  --fv "${TMP}.fw_main_a"

if "${FUTILITY}" verify "${TMP}.vblock_a" ; then false ; fi

if "${FUTILITY}" verify "${TMP}.vblock_a" \
  --publickey "${TMP}.rootkey" ; then false ; fi

"${FUTILITY}" verify "${TMP}.vblock_a" \
  --publickey "${TMP}.rootkey" \
  --fv "${TMP}.fw_main_a"


#### kernel partition

"${FUTILITY}" show "${SCRIPT_DIR}/futility/data/rec_kernel_part.bin"

"${FUTILITY}" show "${SCRIPT_DIR}/futility/data/rec_kernel_part.bin" \
  --publickey "${DEVKEYS}/kernel_subkey.vbpubk"

"${FUTILITY}" show "${SCRIPT_DIR}/futility/data/rec_kernel_part.bin" \
  --publickey "${DEVKEYS}/recovery_key.vbpubk"

if "${FUTILITY}" verify "${SCRIPT_DIR}/futility/data/rec_kernel_part.bin" ; \
  then false ; fi

if "${FUTILITY}" verify "${SCRIPT_DIR}/futility/data/rec_kernel_part.bin" \
  --publickey "${DEVKEYS}/kernel_subkey.vbpubk" ; then false ; fi

"${FUTILITY}" verify "${SCRIPT_DIR}/futility/data/rec_kernel_part.bin" \
  --publickey "${DEVKEYS}/recovery_key.vbpubk"


# cleanup
rm -rf "${TMP}"*
exit 0
