package english_vocab_test

import (
	"testing"

	"github.com/kljensen/snowball/english"
)

// Test a large set of words for which we know
// the correct stemmed form.
//
func Test_EnglishVocabulary(t *testing.T) {
	testCases := []struct {
		in  string
		out string
	}{
		{"'a", "'a"},
		{"'s", "'s"},
		{"'aa", "aa"},
		{"'as", "as"},
		{"'a'", "a"},
		{"'s'", "s"},
		{"'aa'", "aa"},
		{"'as'", "as"},
		{"a", "a"},
		{"a'", "a'"},
		{"a''", "a'"},
		{"aa'", "aa"},
		{"aback", "aback"},
		{"abandon", "abandon"},
		{"abandoned", "abandon"},
		{"abandoning", "abandon"},
		{"abandonment", "abandon"},
		{"abandons", "abandon"},
		{"abasement", "abas"},
		{"abashed", "abash"},
		{"abate", "abat"},
		{"abated", "abat"},
		{"abbey", "abbey"},
		{"abbott", "abbott"},
		{"abbreviation", "abbrevi"},
		{"abdicate", "abdic"},
		{"abdicating", "abdic"},
		{"abdomen", "abdomen"},
		{"abdominal", "abdomin"},
		{"abe", "abe"},
		{"abear", "abear"},
		{"abed", "abe"},
		{"abel", "abel"},
		{"aberration", "aberr"},
		{"abershaw", "abershaw"},
		{"abet", "abet"},
		{"abettor", "abettor"},
		{"abeyance", "abey"},
		{"abhorred", "abhor"},
		{"abhorrence", "abhorr"},
		{"abhorring", "abhor"},
		{"abide", "abid"},
		{"abiding", "abid"},
		{"abilities", "abil"},
		{"ability", "abil"},
		{"abimee", "abime"},
		{"abingdon", "abingdon"},
		{"abipones", "abipon"},
		{"abject", "abject"},
		{"abjectly", "abject"},
		{"abjectness", "abject"},
		{"abjure", "abjur"},
		{"abjured", "abjur"},
		{"abl", "abl"},
		{"able", "abl"},
		{"ablutions", "ablut"},
		{"abnegation", "abneg"},
		{"abnormal", "abnorm"},
		{"abnormality", "abnorm"},
		{"abnormally", "abnorm"},
		{"aboard", "aboard"},
		{"abode", "abod"},
		{"abodes", "abod"},
		{"abolish", "abolish"},
		{"abolished", "abolish"},
		{"abolishing", "abolish"},
		{"abolition", "abolit"},
		{"abominable", "abomin"},
		{"abominably", "abomin"},
		{"abominated", "abomin"},
		{"abomination", "abomin"},
		{"aboot", "aboot"},
		{"aboriginal", "aborigin"},
		{"aboriginally", "aborigin"},
		{"aborigines", "aborigin"},
		{"abortion", "abort"},
		{"abortions", "abort"},
		{"abortive", "abort"},
		{"abound", "abound"},
		{"abounded", "abound"},
		{"abounding", "abound"},
		{"abounds", "abound"},
		{"about", "about"},
		{"above", "abov"},
		{"aboveboard", "aboveboard"},
		{"abraham", "abraham"},
		{"abreast", "abreast"},
		{"abridge", "abridg"},
		{"abridged", "abridg"},
		{"abroad", "abroad"},
		{"abrogated", "abrog"},
		{"abrolhos", "abrolho"},
		{"abrupt", "abrupt"},
		{"abruptly", "abrupt"},
		{"abruptness", "abrupt"},
		{"abscess", "abscess"},
		{"absence", "absenc"},
		{"absent", "absent"},
		{"absenting", "absent"},
		{"absolute", "absolut"},
		{"absolutely", "absolut"},
		{"absolve", "absolv"},
		{"absolved", "absolv"},
		{"absorb", "absorb"},
		{"absorbed", "absorb"},
		{"absorbent", "absorb"},
		{"absorbing", "absorb"},
		{"absorbs", "absorb"},
		{"absorption", "absorpt"},
		{"abstain", "abstain"},
		{"abstained", "abstain"},
		{"abstaining", "abstain"},
		{"abstinence", "abstin"},
		{"abstract", "abstract"},
		{"abstracted", "abstract"},
		{"abstractedly", "abstract"},
		{"abstraction", "abstract"},
		{"abstracts", "abstract"},
		{"abstruse", "abstrus"},
		{"absurd", "absurd"},
		{"absurdities", "absurd"},
		{"absurdity", "absurd"},
		{"absurdly", "absurd"},
		{"abt", "abt"},
		{"abundance", "abund"},
		{"abundant", "abund"},
		{"abundantly", "abund"},
		{"abuse", "abus"},
		{"abused", "abus"},
		{"abuses", "abus"},
		{"abusing", "abus"},
		{"abusive", "abus"},
		{"abut", "abut"},
		{"abuts", "abut"},
		{"abutting", "abut"},
		{"abyss", "abyss"},
		{"abysses", "abyss"},
		{"abyssinia", "abyssinia"},
		{"ac", "ac"},
		{"acacia", "acacia"},
		{"acacias", "acacia"},
		{"academy", "academi"},
		{"acalypha", "acalypha"},
		{"acapulco", "acapulco"},
		{"accede", "acced"},
		{"acceded", "acced"},
		{"accedes", "acced"},
		{"accelerate", "acceler"},
		{"accelerated", "acceler"},
		{"accent", "accent"},
		{"accents", "accent"},
		{"accept", "accept"},
		{"acceptable", "accept"},
		{"acceptance", "accept"},
		{"acceptances", "accept"},
		{"acceptation", "accept"},
		{"accepted", "accept"},
		{"accepting", "accept"},
		{"accepts", "accept"},
		{"access", "access"},
		{"accessible", "access"},
		{"accession", "access"},
		{"accessories", "accessori"},
		{"accessory", "accessori"},
		{"accident", "accid"},
		{"accidental", "accident"},
		{"accidentally", "accident"},
		{"accidents", "accid"},
		{"acclamations", "acclam"},
		{"acclivity", "accliv"},
		{"accommodate", "accommod"},
		{"accommodated", "accommod"},
		{"accommodating", "accommod"},
		{"accommodation", "accommod"},
		{"accommodations", "accommod"},
		{"accompanied", "accompani"},
		{"accompanies", "accompani"},
		{"accompaniment", "accompani"},
		{"accompaniments", "accompani"},
		{"accompany", "accompani"},
		{"accompanying", "accompani"},
		{"accomplice", "accomplic"},
		{"accomplices", "accomplic"},
		{"accomplish", "accomplish"},
		{"accomplished", "accomplish"},
		{"accomplishes", "accomplish"},
		{"accomplishing", "accomplish"},
		{"accomplishment", "accomplish"},
		{"accomplishments", "accomplish"},
		{"accord", "accord"},
		{"accordance", "accord"},
		{"accorded", "accord"},
		{"according", "accord"},
		{"accordingly", "accord"},
		{"accosted", "accost"},
		{"accosting", "accost"},
		{"accoun", "accoun"},
		{"account", "account"},
		{"accountabilities", "account"},
		{"accountability", "account"},
		{"accountable", "account"},
		{"accountant", "account"},
		{"accounted", "account"},
		{"accounting", "account"},
		{"accounts", "account"},
		{"accoutred", "accoutr"},
		{"accoutrements", "accoutr"},
		{"accredited", "accredit"},
		{"accrue", "accru"},
		{"accrued", "accru"},
		{"accruing", "accru"},
		{"accumulate", "accumul"},
		{"accumulated", "accumul"},
		{"accumulating", "accumul"},
		{"accumulation", "accumul"},
		{"accumulations", "accumul"},
		{"accuracy", "accuraci"},
		{"accurate", "accur"},
		{"accurately", "accur"},
		{"accursed", "accurs"},
		{"accusation", "accus"},
		{"accusations", "accus"},
		{"accuse", "accus"},
		{"accused", "accus"},
		{"accuser", "accus"},
		{"accusers", "accus"},
		{"accuses", "accus"},
		{"accusing", "accus"},
		{"accustom", "accustom"},
		{"accustomed", "accustom"},
		{"accustoming", "accustom"},
		{"ace", "ace"},
		{"acerbity", "acerb"},
		{"aces", "ace"},
		{"ach", "ach"},
		{"ache", "ach"},
		{"ached", "ach"},
		{"aches", "ach"},
		{"achieve", "achiev"},
		{"achieved", "achiev"},
		{"achievement", "achiev"},
		{"achievements", "achiev"},
		{"achieves", "achiev"},
		{"achieving", "achiev"},
		{"achilles", "achill"},
		{"aching", "ach"},
		{"acid", "acid"},
		{"acids", "acid"},
		{"ack", "ack"},
		{"ackney", "ackney"},
		{"acknowledge", "acknowledg"},
		{"acknowledged", "acknowledg"},
		{"acknowledgement", "acknowledg"},
		{"acknowledges", "acknowledg"},
		{"acknowledging", "acknowledg"},
		{"acknowledgment", "acknowledg"},
		{"acknowledgments", "acknowledg"},
		{"aconcagua", "aconcagua"},
		{"acorn", "acorn"},
		{"acquaint", "acquaint"},
		{"acquaintance", "acquaint"},
		{"acquaintances", "acquaint"},
		{"acquainted", "acquaint"},
		{"acquainting", "acquaint"},
		{"acquaints", "acquaint"},
		{"acquiesce", "acquiesc"},
		{"acquiesced", "acquiesc"},
		{"acquiescence", "acquiesc"},
		{"acquiescent", "acquiesc"},
		{"acquiesces", "acquiesc"},
		{"acquiescing", "acquiesc"},
		{"acquire", "acquir"},
		{"acquired", "acquir"},
		{"acquirement", "acquir"},
		{"acquirements", "acquir"},
		{"acquires", "acquir"},
		{"acquiring", "acquir"},
		{"acquisition", "acquisit"},
		{"acquit", "acquit"},
		{"acquittal", "acquitt"},
		{"acquitted", "acquit"},
		{"acqulred", "acqulr"},
		{"acre", "acr"},
		{"acres", "acr"},
		{"acrid", "acrid"},
		{"acrimonious", "acrimoni"},
		{"acrimoniously", "acrimoni"},
		{"across", "across"},
		{"acrydium", "acrydium"},
		{"act", "act"},
		{"acted", "act"},
		{"acting", "act"},
		{"actinia", "actinia"},
		{"action", "action"},
		{"actions", "action"},
		{"active", "activ"},
		{"actively", "activ"},
		{"activity", "activ"},
		{"actor", "actor"},
		{"actors", "actor"},
		{"actress", "actress"},
		{"actresses", "actress"},
		{"acts", "act"},
		{"actual", "actual"},
		{"actuality", "actual"},
		{"actually", "actual"},
		{"actuate", "actuat"},
		{"actuated", "actuat"},
		{"actuating", "actuat"},
		{"acumen", "acumen"},
		{"acunha", "acunha"},
		{"acut", "acut"},
		{"acute", "acut"},
		{"acutely", "acut"},
		{"acuteness", "acut"},
		{"acuter", "acut"},
		{"ad", "ad"},
		{"ada", "ada"},
		{"adage", "adag"},
		{"adages", "adag"},
		{"adam", "adam"},
		{"adamant", "adam"},
		{"adams", "adam"},
		{"adapt", "adapt"},
		{"adaptability", "adapt"},
		{"adaptable", "adapt"},
		{"adaptation", "adapt"},
		{"adapted", "adapt"},
		{"adapter", "adapt"},
		{"adapting", "adapt"},
		{"adapts", "adapt"},
		{"adas", "ada"},
		{"add", "add"},
		{"added", "ad"},
		{"adder", "adder"},
		{"addicted", "addict"},
		{"adding", "ad"},
		{"addition", "addit"},
		{"additional", "addit"},
		{"additionally", "addit"},
		{"additions", "addit"},
		{"addled", "addl"},
		{"address", "address"},
		{"addressed", "address"},
		{"addresses", "address"},
		{"addressing", "address"},
		{"adds", "add"},
		{"adduced", "adduc"},
		{"adducing", "adduc"},
		{"adequate", "adequ"},
		{"adhere", "adher"},
		{"adhered", "adher"},
		{"adherence", "adher"},
		{"adherent", "adher"},
		{"adherents", "adher"},
		{"adheres", "adher"},
		{"adhering", "adher"},
		{"adhesive", "adhes"},
		{"adieu", "adieu"},
		{"adieux", "adieux"},
		{"adimonia", "adimonia"},
		{"adios", "adio"},
		{"adjacent", "adjac"},
		{"adjective", "adject"},
		{"adjoined", "adjoin"},
		{"adjoining", "adjoin"},
		{"adjourned", "adjourn"},
		{"adjournment", "adjourn"},
		{"adjuration", "adjur"},
		{"adjurations", "adjur"},
		{"adjured", "adjur"},
		{"adjuring", "adjur"},
		{"adjust", "adjust"},
		{"adjusted", "adjust"},
		{"adjusting", "adjust"},
		{"adjustment", "adjust"},
		{"adjusts", "adjust"},
		{"adjutant", "adjut"},
		{"administer", "administ"},
		{"administered", "administ"},
		{"administering", "administ"},
		{"administration", "administr"},
		{"administrative", "administr"},
		{"administrator", "administr"},
		{"administrators", "administr"},
		{"admirable", "admir"},
		{"admirably", "admir"},
		{"admiral", "admir"},
		{"admiralty", "admiralti"},
		{"admiration", "admir"},
		{"admire", "admir"},
		{"admired", "admir"},
		{"admirer", "admir"},
		{"admirers", "admir"},
		{"admires", "admir"},
		{"admiring", "admir"},
		{"admiringly", "admir"},
		{"admission", "admiss"},
		{"admissions", "admiss"},
		{"admit", "admit"},
		{"admits", "admit"},
		{"admittance", "admitt"},
		{"admitted", "admit"},
		{"admitting", "admit"},
		{"admixture", "admixtur"},
		{"admonished", "admonish"},
		{"admonishes", "admonish"},
		{"admonishing", "admonish"},
		{"admonition", "admonit"},
		{"admonitions", "admonit"},
		{"admonitory", "admonitori"},
		{"adn", "adn"},
		{"ado", "ado"},
		{"adopt", "adopt"},
		{"adopted", "adopt"},
		{"adopting", "adopt"},
		{"adoption", "adopt"},
		{"adoration", "ador"},
		{"adorations", "ador"},
		{"adore", "ador"},
		{"adored", "ador"},
		{"adores", "ador"},
		{"adoring", "ador"},
		{"adorned", "adorn"},
		{"adorning", "adorn"},
		{"adornment", "adorn"},
		{"adornments", "adorn"},
		{"adorns", "adorn"},
		{"adrianople", "adrianopl"},
		{"adrift", "adrift"},
		{"adroit", "adroit"},
		{"adulation", "adul"},
		{"adulatory", "adulatori"},
		{"adult", "adult"},
		{"adultery", "adulteri"},
		{"advance", "advanc"},
		{"advanced", "advanc"},
		{"advancement", "advanc"},
		{"advances", "advanc"},
		{"advancing", "advanc"},
		{"advantage", "advantag"},
		{"advantageous", "advantag"},
		{"advantageously", "advantag"},
		{"advantages", "advantag"},
		{"advent", "advent"},
		{"adventure", "adventur"},
		{"adventurer", "adventur"},
		{"adventurers", "adventur"},
		{"adventures", "adventur"},
		{"adventuresses", "adventuress"},
		{"adventurous", "adventur"},
		{"adventurously", "adventur"},
		{"adversaries", "adversari"},
		{"adversary", "adversari"},
		{"adverse", "advers"},
		{"adversity", "advers"},
		{"advert", "advert"},
		{"adverted", "advert"},
		{"adverting", "advert"},
		{"advertise", "advertis"},
		{"advertised", "advertis"},
		{"advertisement", "advertis"},
		{"advertisements", "advertis"},
		{"advertiser", "advertis"},
		{"advertising", "advertis"},
		{"advice", "advic"},
		{"advisability", "advis"},
		{"advisable", "advis"},
		{"advise", "advis"},
		{"advised", "advis"},
		{"advisedly", "advis"},
		{"adviser", "advis"},
		{"advises", "advis"},
		{"advising", "advis"},
		{"advocacy", "advocaci"},
		{"advocate", "advoc"},
		{"advocated", "advoc"},
		{"advocating", "advoc"},
		{"adwiser", "adwis"},
		{"aeqam", "aeqam"},
		{"aerial", "aerial"},
		{"aeriform", "aeriform"},
		{"aeronaut", "aeronaut"},
		{"aeronautics", "aeronaut"},
		{"aery", "aeri"},
		{"aeschylus", "aeschylus"},
		{"aesop", "aesop"},
		{"aesthetic", "aesthet"},
		{"aesthetically", "aesthet"},
		{"aesthetics", "aesthet"},
		{"aestivation", "aestiv"},
		{"afanasy", "afanasi"},
		{"afanasyvitch", "afanasyvitch"},
		{"afar", "afar"},
		{"afeard", "afeard"},
		{"afeared", "afear"},
		{"afer", "afer"},
		{"affability", "affabl"},
		{"affable", "affabl"},
		{"affably", "affabl"},
		{"affair", "affair"},
		{"affairs", "affair"},
		{"affect", "affect"},
		{"affectation", "affect"},
		{"affected", "affect"},
		{"affectedly", "affect"},
		{"affecting", "affect"},
		{"affection", "affect"},
		{"affectionate", "affection"},
		{"affectionately", "affection"},
		{"affections", "affect"},
		{"affects", "affect"},
		{"afferdavid", "afferdavid"},
		{"affidavit", "affidavit"},
		{"affidavits", "affidavit"},
		{"affinity", "affin"},
		{"affirm", "affirm"},
		{"affirmative", "affirm"},
		{"affirmed", "affirm"},
		{"affirms", "affirm"},
		{"afflict", "afflict"},
		{"afflicted", "afflict"},
		{"afflicting", "afflict"},
		{"affliction", "afflict"},
		{"afflictions", "afflict"},
		{"affluence", "affluenc"},
		{"affluent", "affluent"},
		{"afford", "afford"},
		{"afforded", "afford"},
		{"affording", "afford"},
		{"affords", "afford"},
		{"affright", "affright"},
		{"affrighted", "affright"},
		{"affront", "affront"},
		{"affronted", "affront"},
		{"afield", "afield"},
		{"aflicto", "aflicto"},
		{"afloat", "afloat"},
		{"afoot", "afoot"},
		{"afore", "afor"},
		{"aforementioned", "aforement"},
		{"aforesaid", "aforesaid"},
		{"afraid", "afraid"},
		{"afresh", "afresh"},
		{"africa", "africa"},
		{"african", "african"},
		{"afrique", "afriqu"},
		{"afrosinya", "afrosinya"},
		{"afsd", "afsd"},
		{"aft", "aft"},
		{"after", "after"},
		{"afternoon", "afternoon"},
		{"afternoons", "afternoon"},
		{"afterthought", "afterthought"},
		{"afterwards", "afterward"},
		{"agai", "agai"},
		{"again", "again"},
		{"against", "against"},
		{"agate", "agat"},
		{"agave", "agav"},
		{"agaves", "agav"},
		{"age", "age"},
		{"agean", "agean"},
		{"aged", "age"},
		{"agency", "agenc"},
		{"agent", "agent"},
		{"agents", "agent"},
		{"agers", "ager"},
		{"ages", "age"},
		{"aggeravating", "aggerav"},
		{"agglomeration", "agglomer"},
		{"agglutinated", "agglutin"},
		{"aggrandizement", "aggrandiz"},
		{"aggravate", "aggrav"},
		{"aggravated", "aggrav"},
		{"aggravates", "aggrav"},
		{"aggravating", "aggrav"},
		{"aggravation", "aggrav"},
		{"aggravations", "aggrav"},
		{"aggregate", "aggreg"},
		{"aggregated", "aggreg"},
		{"aggression", "aggress"},
		{"aggressor", "aggressor"},
		{"aggrieved", "aggriev"},
		{"aghast", "aghast"},
		{"agility", "agil"},
		{"agin", "agin"},
		{"agitate", "agit"},
		{"agitated", "agit"},
		{"agitating", "agit"},
		{"agitation", "agit"},
		{"agitators", "agit"},
		{"aglow", "aglow"},
		{"agnes", "agn"},
		{"ago", "ago"},
		{"agonies", "agoni"},
		{"agonised", "agonis"},
		{"agonising", "agonis"},
		{"agonisingly", "agonis"},
		{"agonizing", "agon"},
		{"agony", "agoni"},
		{"agouti", "agouti"},
		{"agoutis", "agouti"},
		{"agrarian", "agrarian"},
		{"agree", "agre"},
		{"agreeable", "agreeabl"},
		{"agreeably", "agreeabl"},
		{"agreed", "agre"},
		{"agreeing", "agre"},
		{"agreement", "agreement"},
		{"agrees", "agre"},
		{"agricult", "agricult"},
		{"agricultural", "agricultur"},
		{"agriculture", "agricultur"},
		{"agriculturists", "agriculturist"},
		{"aground", "aground"},
		{"agua", "agua"},
		{"ague", "agu"},
		{"agueros", "aguero"},
		{"ah", "ah"},
		{"aha", "aha"},
		{"ahead", "ahead"},
		{"ai", "ai"},
		{"aid", "aid"},
		{"aided", "aid"},
		{"aider", "aider"},
		{"aiding", "aid"},
		{"aids", "aid"},
		{"aie", "aie"},
		{"ailing", "ail"},
		{"ailment", "ailment"},
		{"ailments", "ailment"},
		{"ails", "ail"},
		{"aim", "aim"},
		{"aimed", "aim"},
		{"aiming", "aim"},
		{"aimless", "aimless"},
		{"aimlessly", "aimless"},
		{"aims", "aim"},
		{"ain", "ain"},
		{"air", "air"},
		{"aired", "air"},
		{"airily", "airili"},
		{"airing", "air"},
		{"airlessness", "airless"},
		{"airnest", "airnest"},
		{"airs", "air"},
		{"airy", "airi"},
		{"aisle", "aisl"},
		{"aits", "ait"},
		{"ajar", "ajar"},
		{"ajax", "ajax"},
		{"akad", "akad"},
		{"ake", "ake"},
		{"akeady", "akeadi"},
		{"akimbo", "akimbo"},
		{"akin", "akin"},
		{"al", "al"},
		{"alabaster", "alabast"},
		{"alacrity", "alacr"},
		{"alameda", "alameda"},
		{"alarm", "alarm"},
		{"alarmed", "alarm"},
		{"alarming", "alarm"},
		{"alarmingly", "alarm"},
		{"alarms", "alarm"},
		{"alas", "ala"},
		{"alba", "alba"},
		{"albania", "albania"},
		{"albanians", "albanian"},
		{"albans", "alban"},
		{"albatross", "albatross"},
		{"albeit", "albeit"},
		{"albemarle", "albemarl"},
		{"albert", "albert"},
		{"albertine", "albertin"},
		{"albiceps", "albicep"},
		{"albicollis", "albicolli"},
		{"albicores", "albicor"},
		{"albino", "albino"},
		{"albion", "albion"},
		{"album", "album"},
		{"albuminous", "albumin"},
		{"albury", "alburi"},
		{"alcicornis", "alcicorni"},
		{"alcide", "alcid"},
		{"alcohol", "alcohol"},
		{"alder", "alder"},
		{"alderman", "alderman"},
		{"aldershot", "aldershot"},
		{"aldgate", "aldgat"},
		{"ale", "ale"},
		{"alehouse", "alehous"},
		{"alehouses", "alehous"},
		{"aleide", "aleid"},
		{"alerce", "alerc"},
		{"alert", "alert"},
		{"alexander", "alexand"},
		{"alexandr", "alexandr"},
		{"alexandrovna", "alexandrovna"},
		{"alexey", "alexey"},
		{"alfalfa", "alfalfa"},
		{"alfonso", "alfonso"},
		{"alford", "alford"},
		{"alfred", "alfr"},
		{"algarroba", "algarroba"},
		{"algebra", "algebra"},
		{"alice", "alic"},
		{"alienated", "alien"},
		{"alight", "alight"},
		{"alighted", "alight"},
		{"alighting", "alight"},
		{"alights", "alight"},
		{"alike", "alik"},
		{"alive", "aliv"},
		{"all", "all"},
		{"allah", "allah"},
		{"allan", "allan"},
		{"allay", "allay"},
		{"allayed", "allay"},
		{"allays", "allay"},
		{"allegation", "alleg"},
		{"allegations", "alleg"},
		{"alleged", "alleg"},
		{"allegiance", "allegi"},
		{"alleging", "alleg"},
		{"allegorical", "allegor"},
		{"allegories", "allegori"},
		{"allegory", "allegori"},
		{"allenby", "allenbi"},
		{"aller", "aller"},
		{"alleviate", "allevi"},
		{"alleviated", "allevi"},
		{"alley", "alley"},
		{"alleys", "alley"},
		{"alliance", "allianc"},
		{"alliances", "allianc"},
		{"allied", "alli"},
		{"allies", "alli"},
		{"alligators", "allig"},
		{"allotted", "allot"},
		{"allotting", "allot"},
		{"allow", "allow"},
		{"allowable", "allow"},
		{"allowance", "allow"},
		{"allowances", "allow"},
		{"allowed", "allow"},
		{"allowing", "allow"},
		{"allows", "allow"},
		{"alloyed", "alloy"},
		{"allude", "allud"},
		{"alluded", "allud"},
		{"alludes", "allud"},
		{"alluding", "allud"},
		{"allure", "allur"},
		{"allured", "allur"},
		{"allurement", "allur"},
		{"allurements", "allur"},
		{"alluring", "allur"},
		{"allus", "allus"},
		{"allusion", "allus"},
		{"allusions", "allus"},
		{"alluvial", "alluvi"},
		{"alluvium", "alluvium"},
		{"ally", "alli"},
		{"alma", "alma"},
		{"almac", "almac"},
		{"almanac", "almanac"},
		{"almanacs", "almanac"},
		{"almighty", "almighti"},
		{"almos", "almo"},
		{"almost", "almost"},
		{"alms", "alm"},
		{"almshouses", "almshous"},
		{"aloe", "alo"},
		{"aloft", "aloft"},
		{"alone", "alon"},
		{"along", "along"},
		{"alongside", "alongsid"},
		{"aloof", "aloof"},
		{"aloud", "aloud"},
		{"alphabet", "alphabet"},
		{"alphabets", "alphabet"},
		{"alphonse", "alphons"},
		{"alpine", "alpin"},
		{"alps", "alp"},
		{"already", "alreadi"},
		{"also", "also"},
		{"alta", "alta"},
		{"altar", "altar"},
		{"altars", "altar"},
		{"alter", "alter"},
		{"alteration", "alter"},
		{"alterations", "alter"},
		{"altercation", "alterc"},
		{"altered", "alter"},
		{"altering", "alter"},
		{"alternate", "altern"},
		{"alternately", "altern"},
		{"alternating", "altern"},
		{"alternation", "altern"},
		{"alternations", "altern"},
		{"alternative", "altern"},
		{"alternatives", "altern"},
		{"alters", "alter"},
		{"althoug", "althoug"},
		{"although", "although"},
		{"altisidora", "altisidora"},
		{"altitude", "altitud"},
		{"alto", "alto"},
		{"altogether", "altogeth"},
		{"alured", "alur"},
		{"alway", "alway"},
		{"always", "alway"},
		{"alyona", "alyona"},
		{"alyoshka", "alyoshka"},
		{"am", "am"},
		{"ama", "ama"},
		{"amalgamate", "amalgam"},
		{"amalgamated", "amalgam"},
		{"amalgamation", "amalgam"},
		{"amalia", "amalia"},
		{"amancaes", "amanca"},
		{"amang", "amang"},
		{"amanuensis", "amanuensi"},
		{"amarga", "amarga"},
		{"amass", "amass"},
		{"amassed", "amass"},
		{"amassing", "amass"},
		{"amateur", "amateur"},
		{"amaze", "amaz"},
		{"amazed", "amaz"},
		{"amazedly", "amaz"},
		{"amazement", "amaz"},
		{"amazes", "amaz"},
		{"amazing", "amaz"},
		{"amazingly", "amaz"},
		{"ambassadors", "ambassador"},
		{"ambassadress", "ambassadress"},
		{"amber", "amber"},
		{"ambient", "ambient"},
		{"ambiguous", "ambigu"},
		{"ambition", "ambit"},
		{"ambitious", "ambiti"},
		{"amble", "ambl"},
		{"ambling", "ambl"},
		{"amblyrhynchus", "amblyrhynchus"},
		{"ambox", "ambox"},
		{"ambuscade", "ambuscad"},
		{"ambush", "ambush"},
		{"amd", "amd"},
		{"amelioration", "amelior"},
		{"amen", "amen"},
		{"amenable", "amen"},
		{"amend", "amend"},
		{"amended", "amend"},
		{"amendment", "amend"},
		{"amendments", "amend"},
		{"amends", "amend"},
		{"america", "america"},
		{"american", "american"},
		{"americana", "americana"},
		{"americans", "american"},
		{"americas", "america"},
		{"amerique", "ameriqu"},
		{"amethysts", "amethyst"},
		{"ami", "ami"},
		{"amiabilities", "amiabl"},
		{"amiability", "amiabl"},
		{"amiable", "amiabl"},
		{"amiably", "amiabl"},
		{"amicability", "amic"},
		{"amicable", "amic"},
		{"amicably", "amic"},
		{"amid", "amid"},
		{"amidst", "amidst"},
		{"amiss", "amiss"},
		{"amity", "amiti"},
		{"ammunition", "ammunit"},
		{"amn", "amn"},
		{"amoncelees", "amoncele"},
		{"among", "among"},
		{"amongst", "amongst"},
		{"amorites", "amorit"},
		{"amorous", "amor"},
		{"amost", "amost"},
		{"amount", "amount"},
		{"amounted", "amount"},
		{"amounting", "amount"},
		{"amounts", "amount"},
		{"amphibious", "amphibi"},
		{"amphitheatre", "amphitheatr"},
		{"amphitheatrical", "amphitheatr"},
		{"ample", "ampl"},
		{"amply", "ampli"},
		{"ampullariae", "ampullaria"},
		{"amputated", "amput"},
		{"amputation", "amput"},
		{"amuse", "amus"},
		{"amused", "amus"},
		{"amusement", "amus"},
		{"amusements", "amus"},
		{"amuses", "amus"},
		{"amusing", "amus"},
		{"an", "an"},
		{"ana", "ana"},
		{"anadeers", "anad"},
		{"anaemic", "anaem"},
		{"analogies", "analog"},
		{"analogous", "analog"},
		{"analogue", "analogu"},
		{"analogy", "analog"},
		{"analyse", "analys"},
		{"analysed", "analys"},
		{"analysing", "analys"},
		{"analysis", "analysi"},
		{"analyze", "analyz"},
		{"analyzed", "analyz"},
		{"anarchy", "anarchi"},
		{"anas", "ana"},
		{"anastasia", "anastasia"},
		{"anat", "anat"},
		{"anathematising", "anathematis"},
		{"anathematizing", "anathemat"},
		{"anatolia", "anatolia"},
		{"anatomical", "anatom"},
		{"anatomists", "anatomist"},
		{"anatomy", "anatomi"},
		{"ancestor", "ancestor"},
		{"ancestors", "ancestor"},
		{"ancestral", "ancestr"},
		{"ancestress", "ancestress"},
		{"ancestry", "ancestri"},
		{"anchor", "anchor"},
		{"anchorage", "anchorag"},
		{"anchored", "anchor"},
		{"anchoring", "anchor"},
		{"anchors", "anchor"},
		{"anchovies", "anchovi"},
		{"ancient", "ancient"},
		{"anciently", "ancient"},
		{"ancients", "ancient"},
		{"and", "and"},
		{"andalusia", "andalusia"},
		{"ande", "and"},
		{"andes", "andes"},
		{"andle", "andl"},
		{"andled", "andl"},
		{"andrew", "andrew"},
		{"andrews", "andrew"},
		{"andrey", "andrey"},
		{"anecdote", "anecdot"},
		{"anecdotes", "anecdot"},
		{"anemone", "anemon"},
		{"anew", "anew"},
		{"angel", "angel"},
		{"angela", "angela"},
		{"angelic", "angel"},
		{"angelica", "angelica"},
		{"angels", "angel"},
		{"anger", "anger"},
		{"angered", "anger"},
		{"angerless", "angerless"},
		{"angers", "anger"},
		{"angle", "angl"},
		{"angler", "angler"},
		{"angles", "angl"},
		{"anglican", "anglican"},
		{"anglicanism", "anglican"},
		{"anglified", "anglifi"},
		{"angriest", "angriest"},
		{"angrily", "angrili"},
		{"angry", "angri"},
		{"anguish", "anguish"},
		{"angula", "angula"},
		{"angular", "angular"},
		{"anima", "anima"},
		{"animadvert", "animadvert"},
		{"animal", "anim"},
		{"animalcula", "animalcula"},
		{"animalcule", "animalcul"},
		{"animalized", "anim"},
		{"animals", "anim"},
		{"animas", "anima"},
		{"animate", "anim"},
		{"animated", "anim"},
		{"animates", "anim"},
		{"animating", "anim"},
		{"animation", "anim"},
		{"animosity", "animos"},
		{"aniska", "aniska"},
		{"ankle", "ankl"},
		{"ankles", "ankl"},
		{"ann", "ann"},
		{"anna", "anna"},
		{"annal", "annal"},
		{"annales", "annal"},
		{"annals", "annal"},
		{"anne", "ann"},
		{"annelidous", "annelid"},
		{"annette", "annett"},
		{"annewum", "annewum"},
		{"annexed", "annex"},
		{"annie", "anni"},
		{"annihilate", "annihil"},
		{"annihilated", "annihil"},
		{"annihilation", "annihil"},
		{"anniversaries", "anniversari"},
		{"anniversary", "anniversari"},
		{"annoucing", "annouc"},
		{"announce", "announc"},
		{"announced", "announc"},
		{"announcement", "announc"},
		{"announcements", "announc"},
		{"announces", "announc"},
		{"announcing", "announc"},
		{"annoy", "annoy"},
		{"annoyance", "annoy"},
		{"annoyances", "annoy"},
		{"annoyed", "annoy"},
		{"annoying", "annoy"},
		{"annoys", "annoy"},
		{"annual", "annual"},
		{"annually", "annual"},
		{"annuals", "annual"},
		{"annuelle", "annuell"},
		{"annuity", "annuiti"},
		{"annul", "annul"},
		{"annum", "annum"},
		{"anomalies", "anomali"},
		{"anomalous", "anomal"},
		{"anomaly", "anomali"},
		{"anon", "anon"},
		{"anonymous", "anonym"},
		{"anoother", "anooth"},
		{"another", "anoth"},
		{"anson", "anson"},
		{"anstice", "anstic"},
		{"answer", "answer"},
		{"answerable", "answer"},
		{"answered", "answer"},
		{"answering", "answer"},
		{"answers", "answer"},
		{"ant", "ant"},
		{"antagonism", "antagon"},
		{"antagonist", "antagonist"},
		{"antagonistic", "antagonist"},
		{"antarctic", "antarct"},
		{"antarctica", "antarctica"},
		{"antarcticus", "antarcticus"},
		{"anteater", "anteat"},
		{"antecedent", "anteced"},
		{"antecedents", "anteced"},
		{"antechamber", "antechamb"},
		{"antechambers", "antechamb"},
		{"antediluvian", "antediluvian"},
		{"antelope", "antelop"},
		{"antelopes", "antelop"},
		{"antennae", "antenna"},
		{"antennatus", "antennatus"},
		{"anterior", "anterior"},
		{"anthem", "anthem"},
		{"anthony", "anthoni"},
		{"anthus", "anthus"},
		{"anti", "anti"},
		{"anticipate", "anticip"},
		{"anticipated", "anticip"},
		{"anticipates", "anticip"},
		{"anticipating", "anticip"},
		{"anticipation", "anticip"},
		{"anticipations", "anticip"},
		{"anticipative", "anticip"},
		{"antics", "antic"},
		{"antilles", "antill"},
		{"antipodean", "antipodean"},
		{"antipodes", "antipod"},
		{"antiquarian", "antiquarian"},
		{"antiquaries", "antiquari"},
		{"antiquated", "antiqu"},
		{"antiques", "antiqu"},
		{"antiquities", "antiqu"},
		{"antiquity", "antiqu"},
		{"antlers", "antler"},
		{"antonio", "antonio"},
		{"antony", "antoni"},
		{"antrum", "antrum"},
		{"ants", "ant"},
		{"antuco", "antuco"},
		{"anxieties", "anxieti"},
		{"anxiety", "anxieti"},
		{"anxious", "anxious"},
		{"anxiously", "anxious"},
		{"any", "ani"},
		{"anybody", "anybodi"},
		{"anyhow", "anyhow"},
		{"anymore", "anymor"},
		{"anyone", "anyon"},
		{"anything", "anyth"},
		{"anythink", "anythink"},
		{"anyvays", "anyvay"},
		{"anyway", "anyway"},
		{"anyways", "anyway"},
		{"anywhere", "anywher"},
		{"anywheres", "anywher"},
		{"ap", "ap"},
		{"apace", "apac"},
		{"apar", "apar"},
		{"apart", "apart"},
		{"apartment", "apart"},
		{"apartments", "apart"},
		{"apate", "apat"},
		{"apathy", "apathi"},
		{"ape", "ape"},
		{"apennines", "apennin"},
		{"aperient", "aperi"},
		{"aperture", "apertur"},
		{"apertures", "apertur"},
		{"apex", "apex"},
		{"aphodius", "aphodius"},
		{"apiece", "apiec"},
		{"apire", "apir"},
		{"apires", "apir"},
		{"aplysia", "aplysia"},
		{"apollinaris", "apollinari"},
		{"apollo", "apollo"},
		{"apologetic", "apologet"},
		{"apologetically", "apologet"},
		{"apologies", "apolog"},
		{"apologise", "apologis"},
		{"apologised", "apologis"},
		{"apologising", "apologis"},
		{"apologists", "apologist"},
		{"apologize", "apolog"},
		{"apologized", "apolog"},
		{"apologizes", "apolog"},
		{"apologizing", "apolog"},
		{"apology", "apolog"},
		{"apoplectic", "apoplect"},
		{"apoplexy", "apoplexi"},
		{"apostle", "apostl"},
		{"apostles", "apostl"},
		{"apostolica", "apostolica"},
		{"apostrophe", "apostroph"},
		{"apostrophised", "apostrophis"},
		{"apostrophized", "apostroph"},
		{"apostrophizing", "apostroph"},
		{"apothecaries", "apothecari"},
		{"apothecary", "apothecari"},
		{"appalled", "appal"},
		{"appalling", "appal"},
		{"appallingly", "appal"},
		{"appanage", "appanag"},
		{"apparatus", "apparatus"},
		{"apparel", "apparel"},
		{"apparent", "appar"},
		{"apparently", "appar"},
		{"apparition", "apparit"},
		{"apparitions", "apparit"},
		{"appea", "appea"},
		{"appeal", "appeal"},
		{"appealed", "appeal"},
		{"appealing", "appeal"},
		{"appealingly", "appeal"},
		{"appeals", "appeal"},
		{"appear", "appear"},
		{"appearance", "appear"},
		{"appearances", "appear"},
		{"appeared", "appear"},
		{"appearing", "appear"},
		{"appears", "appear"},
		{"appease", "appeas"},
		{"appeased", "appeas"},
		{"appellation", "appel"},
		{"append", "append"},
		{"appendage", "appendag"},
		{"appendages", "appendag"},
		{"appended", "append"},
		{"appendix", "appendix"},
		{"appertained", "appertain"},
		{"appertaining", "appertain"},
		{"apperton", "apperton"},
		{"appetite", "appetit"},
		{"appetites", "appetit"},
		{"appiness", "appi"},
		{"applauded", "applaud"},
		{"applauding", "applaud"},
		{"applause", "applaus"},
		{"apple", "appl"},
		{"apples", "appl"},
		{"appliances", "applianc"},
		{"applicable", "applic"},
		{"applicant", "applic"},
		{"application", "applic"},
		{"applications", "applic"},
		{"applied", "appli"},
		{"applies", "appli"},
		{"apply", "appli"},
		{"applying", "appli"},
		{"appoint", "appoint"},
		{"appointed", "appoint"},
		{"appointment", "appoint"},
		{"appointments", "appoint"},
		{"appoints", "appoint"},
		{"apportioned", "apport"},
		{"appreciable", "appreci"},
		{"appreciate", "appreci"},
		{"appreciated", "appreci"},
		{"appreciates", "appreci"},
		{"appreciating", "appreci"},
		{"appreciation", "appreci"},
		{"apprehend", "apprehend"},
		{"apprehended", "apprehend"},
		{"apprehending", "apprehend"},
		{"apprehension", "apprehens"},
		{"apprehensions", "apprehens"},
		{"apprehensive", "apprehens"},
		{"apprentice", "apprentic"},
		{"apprenticed", "apprent"},
		{"apprentices", "apprentic"},
		{"apprenticeship", "apprenticeship"},
		{"apprise", "appris"},
		{"apprised", "appris"},
		{"apprising", "appris"},
		{"approach", "approach"},
		{"approached", "approach"},
		{"approaches", "approach"},
		{"approachin", "approachin"},
		{"approaching", "approach"},
		{"approbation", "approb"},
		{"appropriate", "appropri"},
		{"appropriated", "appropri"},
		{"appropriately", "appropri"},
		{"appropriateness", "appropri"},
		{"appropriating", "appropri"},
		{"appropriation", "appropri"},
		{"approval", "approv"},
		{"approve", "approv"},
		{"approved", "approv"},
		{"approves", "approv"},
		{"approving", "approv"},
		{"approvingly", "approv"},
		{"approximate", "approxim"},
		{"approximately", "approxim"},
		{"appurtenance", "appurten"},
		{"appurtenances", "appurten"},
		{"apricots", "apricot"},
		{"april", "april"},
		{"apron", "apron"},
		{"aprons", "apron"},
		{"apropos", "apropo"},
		{"apt", "apt"},
		{"aptenodytes", "aptenodyt"},
		{"apteryz", "apteryz"},
		{"aptitude", "aptitud"},
		{"aptly", "apt"},
		{"aptness", "apt"},
		{"aptnesses", "apt"},
		{"aquatic", "aquat"},
		{"aqueous", "aqueous"},
		{"aqui", "aqui"},
		{"aquiline", "aquilin"},
		{"aquilines", "aquilin"},
		{"aquinas", "aquina"},
		{"ar", "ar"},
		{"arab", "arab"},
		{"arabian", "arabian"},
		{"arabic", "arab"},
		{"arachnidae", "arachnida"},
		{"arago", "arago"},
		{"araucanians", "araucanian"},
		{"araucarian", "araucarian"},
		{"arauco", "arauco"},
		{"arbiter", "arbit"},
		{"arbitrarily", "arbitrarili"},
		{"arbitrary", "arbitrari"},
		{"arborescent", "arboresc"},
		{"arbour", "arbour"},
		{"arbours", "arbour"},
		{"arbutus", "arbutus"},
		{"arcade", "arcad"},
		{"arcades", "arcad"},
		{"arcadia", "arcadia"},
		{"arch", "arch"},
		{"archaeologists", "archaeologist"},
		{"archbishop", "archbishop"},
		{"archducal", "archduc"},
		{"arched", "arch"},
		{"archer", "archer"},
		{"archery", "archeri"},
		{"arches", "arch"},
		{"archest", "archest"},
		{"archipelago", "archipelago"},
		{"archipelagoes", "archipelago"},
		{"architect", "architect"},
		{"architects", "architect"},
		{"architectural", "architectur"},
		{"architecture", "architectur"},
		{"archly", "arch"},
		{"archness", "arch"},
		{"archway", "archway"},
		{"archways", "archway"},
		{"arctic", "arctic"},
		{"ard", "ard"},
		{"ardent", "ardent"},
		{"ardently", "ardent"},
		{"ardness", "ard"},
		{"ardour", "ardour"},
		{"ards", "ard"},
		{"arduous", "arduous"},
		{"are", "are"},
		{"area", "area"},
		{"aready", "areadi"},
		{"areas", "area"},
		{"areco", "areco"},
		{"aren", "aren"},
		{"arena", "arena"},
		{"arenales", "arenal"},
		{"arequipa", "arequipa"},
		{"arethusa", "arethusa"},
		{"argillaceo", "argillaceo"},
		{"argillaceous", "argillac"},
		{"argue", "argu"},
		{"argued", "argu"},
		{"argues", "argu"},
		{"arguing", "argu"},
		{"argument", "argument"},
		{"argumentative", "argument"},
		{"arguments", "argument"},
		{"argus", "argus"},
		{"argyroneta", "argyroneta"},
		{"ari", "ari"},
		{"arica", "arica"},
		{"arid", "arid"},
		{"aridity", "arid"},
		{"ariel", "ariel"},
		{"aright", "aright"},
		{"arise", "aris"},
		{"arisen", "arisen"},
		{"arises", "aris"},
		{"arising", "aris"},
		{"aristides", "aristid"},
		{"aristocracy", "aristocraci"},
		{"aristocrat", "aristocrat"},
		{"aristocratic", "aristocrat"},
		{"aristocrats", "aristocrat"},
		{"arithmetic", "arithmet"},
		{"arithmetical", "arithmet"},
		{"arithmeticians", "arithmetician"},
		{"ark", "ark"},
		{"arkady", "arkadi"},
		{"arm", "arm"},
		{"armadillo", "armadillo"},
		{"armadilloes", "armadillo"},
		{"armadillos", "armadillo"},
		{"armado", "armado"},
		{"armaments", "armament"},
		{"armchair", "armchair"},
		{"armchairs", "armchair"},
		{"armed", "arm"},
		{"armful", "arm"},
		{"armhole", "armhol"},
		{"armies", "armi"},
		{"arming", "arm"},
		{"armorial", "armori"},
		{"armour", "armour"},
		{"armourer", "armour"},
		{"arms", "arm"},
		{"armstrong", "armstrong"},
		{"army", "armi"},
		{"arn", "arn"},
		{"arnold", "arnold"},
		{"arnong", "arnong"},
		{"aromatic", "aromat"},
		{"arose", "aros"},
		{"around", "around"},
		{"arouse", "arous"},
		{"aroused", "arous"},
		{"arqueros", "arquero"},
		{"arragonite", "arragonit"},
		{"arrange", "arrang"},
		{"arranged", "arrang"},
		{"arrangement", "arrang"},
		{"arrangements", "arrang"},
		{"arranges", "arrang"},
		{"arranging", "arrang"},
		{"arrant", "arrant"},
		{"array", "array"},
		{"arrayed", "array"},
		{"arraying", "array"},
		{"arrear", "arrear"},
		{"arrears", "arrear"},
		{"arrecife", "arrecif"},
		{"arrest", "arrest"},
		{"arrested", "arrest"},
		{"arresting", "arrest"},
		{"arriero", "arriero"},
		{"arrival", "arriv"},
		{"arrivals", "arriv"},
		{"arrive", "arriv"},
		{"arrived", "arriv"},
		{"arrives", "arriv"},
		{"arriving", "arriv"},
		{"arrngd", "arrngd"},
		{"arrogance", "arrog"},
		{"arrogant", "arrog"},
		{"arrow", "arrow"},
		{"arrowing", "arrow"},
		{"arrows", "arrow"},
		{"arroyo", "arroyo"},
		{"arson", "arson"},
		{"art", "art"},
		{"arter", "arter"},
		{"artevelde", "arteveld"},
		{"artful", "art"},
		{"artfully", "art"},
		{"artfulness", "art"},
		{"arthur", "arthur"},
		{"arthurs", "arthur"},
		{"artichoke", "artichok"},
		{"artichokes", "artichok"},
		{"article", "articl"},
		{"articled", "articl"},
		{"articles", "articl"},
		{"articulate", "articul"},
		{"articulated", "articul"},
		{"articulately", "articul"},
		{"articulating", "articul"},
		{"artifice", "artific"},
		{"artifices", "artific"},
		{"artificial", "artifici"},
		{"artificially", "artifici"},
		{"artillery", "artilleri"},
		{"artilleryman", "artilleryman"},
		{"artisan", "artisan"},
		{"artist", "artist"},
		{"artistic", "artist"},
		{"artistical", "artist"},
		{"artistically", "artist"},
		{"artists", "artist"},
		{"artless", "artless"},
		{"artlessness", "artless"},
		{"arts", "art"},
		{"arum", "arum"},
		{"as", "as"},
		{"ascal", "ascal"},
		{"ascend", "ascend"},
		{"ascendancy", "ascend"},
		{"ascendant", "ascend"},
		{"ascended", "ascend"},
		{"ascendency", "ascend"},
		{"ascending", "ascend"},
		{"ascends", "ascend"},
		{"ascension", "ascens"},
		{"ascent", "ascent"},
		{"ascertain", "ascertain"},
		{"ascertained", "ascertain"},
		{"ascertaining", "ascertain"},
		{"ascetic", "ascet"},
		{"ascidiae", "ascidia"},
		{"ascribable", "ascrib"},
		{"ascribe", "ascrib"},
		{"ascribed", "ascrib"},
		{"ascribes", "ascrib"},
		{"ash", "ash"},
		{"ashamed", "asham"},
		{"asheamed", "asheam"},
		{"ashes", "ash"},
		{"ashore", "ashor"},
		{"ashy", "ashi"},
		{"asia", "asia"},
		{"asiat", "asiat"},
		{"asiatic", "asiat"},
		{"asiatiques", "asiatiqu"},
		{"aside", "asid"},
		{"ask", "ask"},
		{"askance", "askanc"},
		{"askant", "askant"},
		{"asked", "ask"},
		{"askew", "askew"},
		{"asking", "ask"},
		{"askmg", "askmg"},
		{"asks", "ask"},
		{"aslant", "aslant"},
		{"asleep", "asleep"},
		{"asparagus", "asparagus"},
		{"aspect", "aspect"},
		{"aspects", "aspect"},
		{"aspen", "aspen"},
		{"asperity", "asper"},
		{"asphalax", "asphalax"},
		{"aspirant", "aspir"},
		{"aspirants", "aspir"},
		{"aspirate", "aspir"},
		{"aspirated", "aspir"},
		{"aspiration", "aspir"},
		{"aspirations", "aspir"},
		{"aspire", "aspir"},
		{"aspired", "aspir"},
		{"aspires", "aspir"},
		{"aspiring", "aspir"},
		{"ass", "ass"},
		{"assailant", "assail"},
		{"assassin", "assassin"},
		{"assassinating", "assassin"},
		{"assault", "assault"},
		{"assaulted", "assault"},
		{"assaults", "assault"},
		{"assay", "assay"},
		{"assayer", "assay"},
		{"assemblage", "assemblag"},
		{"assemble", "assembl"},
		{"assembled", "assembl"},
		{"assembles", "assembl"},
		{"assemblies", "assembl"},
		{"assembling", "assembl"},
		{"assembly", "assembl"},
		{"assent", "assent"},
		{"assented", "assent"},
		{"assenting", "assent"},
		{"assents", "assent"},
		{"assert", "assert"},
		{"asserted", "assert"},
		{"asserting", "assert"},
		{"assertion", "assert"},
		{"assertions", "assert"},
		{"asserts", "assert"},
		{"asses", "ass"},
		{"assessor", "assessor"},
		{"asset", "asset"},
		{"assets", "asset"},
		{"asseverations", "assever"},
		{"assez", "assez"},
		{"assiduity", "assidu"},
		{"assiduous", "assidu"},
		{"assiduously", "assidu"},
		{"assign", "assign"},
		{"assignable", "assign"},
		{"assigned", "assign"},
		{"assignment", "assign"},
		{"assigns", "assign"},
		{"assimilation", "assimil"},
		{"assist", "assist"},
		{"assistance", "assist"},
		{"assistant", "assist"},
		{"assistants", "assist"},
		{"assisted", "assist"},
		{"assisting", "assist"},
		{"assists", "assist"},
		{"assize", "assiz"},
		{"assizes", "assiz"},
		{"assoc", "assoc"},
		{"associate", "associ"},
		{"associated", "associ"},
		{"associates", "associ"},
		{"associating", "associ"},
		{"association", "associ"},
		{"associations", "associ"},
		{"assoiled", "assoil"},
		{"assort", "assort"},
		{"assorted", "assort"},
		{"assortment", "assort"},
		{"assume", "assum"},
		{"assumed", "assum"},
		{"assumes", "assum"},
		{"assuming", "assum"},
		{"assumption", "assumpt"},
		{"assumptions", "assumpt"},
		{"assurance", "assur"},
		{"assurances", "assur"},
		{"assure", "assur"},
		{"assured", "assur"},
		{"assuredly", "assur"},
		{"assures", "assur"},
		{"assuring", "assur"},
		{"astelia", "astelia"},
		{"astern", "astern"},
		{"asthma", "asthma"},
		{"astir", "astir"},
		{"astley", "astley"},
		{"astonish", "astonish"},
		{"astonished", "astonish"},
		{"astonishes", "astonish"},
		{"astonishinent", "astonishin"},
		{"astonishing", "astonish"},
		{"astonishingly", "astonish"},
		{"astonishment", "astonish"},
		{"astounded", "astound"},
		{"astounding", "astound"},
		{"astray", "astray"},
		{"astride", "astrid"},
		{"astringent", "astring"},
		{"astrolabe", "astrolab"},
		{"astronomical", "astronom"},
		{"astronomy", "astronomi"},
		{"astute", "astut"},
		{"asunder", "asund"},
		{"asylum", "asylum"},
		{"asylums", "asylum"},
		{"at", "at"},
		{"atacama", "atacama"},
		{"ate", "ate"},
		{"ated", "ate"},
		{"atheists", "atheist"},
		{"athenaeum", "athenaeum"},
		{"athene", "athen"},
		{"athenian", "athenian"},
		{"athletic", "athlet"},
		{"athos", "atho"},
		{"athwart", "athwart"},
		{"atlantic", "atlant"},
		{"atmosphere", "atmospher"},
		{"atmospheric", "atmospher"},
		{"atoll", "atol"},
		{"atollons", "atollon"},
		{"atolls", "atol"},
		{"atom", "atom"},
		{"atoms", "atom"},
		{"atone", "aton"},
		{"atonement", "aton"},
		{"atra", "atra"},
		{"atratus", "atratus"},
		{"atrocious", "atroci"},
		{"atrocities", "atroc"},
		{"attach", "attach"},
		{"attache", "attach"},
		{"attached", "attach"},
		{"attaches", "attach"},
		{"attaching", "attach"},
		{"attachment", "attach"},
		{"attachments", "attach"},
		{"attack", "attack"},
		{"attacked", "attack"},
		{"attacking", "attack"},
		{"attacks", "attack"},
		{"attagis", "attagi"},
		{"attain", "attain"},
		{"attainable", "attain"},
		{"attained", "attain"},
		{"attaining", "attain"},
		{"attainment", "attain"},
		{"attainments", "attain"},
		{"attains", "attain"},
		{"attempt", "attempt"},
		{"attempted", "attempt"},
		{"attempting", "attempt"},
		{"attempts", "attempt"},
		{"attend", "attend"},
		{"attendance", "attend"},
		{"attendances", "attend"},
		{"attendant", "attend"},
		{"attendants", "attend"},
		{"attended", "attend"},
		{"attending", "attend"},
		{"attends", "attend"},
		{"attention", "attent"},
		{"attentions", "attent"},
		{"attentive", "attent"},
		{"attentively", "attent"},
		{"attenuated", "attenu"},
		{"attest", "attest"},
		{"attested", "attest"},
		{"attesting", "attest"},
		{"attic", "attic"},
		{"attics", "attic"},
		{"attire", "attir"},
		{"attired", "attir"},
		{"attitude", "attitud"},
		{"attitudes", "attitud"},
		{"attorney", "attorney"},
		{"attorneys", "attorney"},
		{"attract", "attract"},
		{"attracted", "attract"},
		{"attracting", "attract"},
		{"attraction", "attract"},
		{"attractions", "attract"},
		{"attractive", "attract"},
		{"attracts", "attract"},
		{"attrapped", "attrap"},
		{"attributable", "attribut"},
		{"attribute", "attribut"},
		{"attributed", "attribut"},
		{"attributes", "attribut"},
		{"attrition", "attrit"},
		{"atwater", "atwat"},
		{"au", "au"},
		{"auckland", "auckland"},
		{"auction", "auction"},
		{"aud", "aud"},
		{"audacious", "audaci"},
		{"audaciously", "audaci"},
		{"audacity", "audac"},
		{"audible", "audibl"},
		{"audibly", "audibl"},
		{"audience", "audienc"},
		{"audiences", "audienc"},
		{"auditor", "auditor"},
		{"auditors", "auditor"},
		{"audubon", "audubon"},
		{"aug", "aug"},
		{"augean", "augean"},
		{"augen", "augen"},
		{"aught", "aught"},
		{"augment", "augment"},
		{"augmentation", "augment"},
		{"augmented", "augment"},
		{"augmenting", "augment"},
		{"augments", "augment"},
		{"augur", "augur"},
		{"augured", "augur"},
		{"auguries", "auguri"},
		{"augurs", "augur"},
		{"august", "august"},
		{"augusta", "augusta"},
		{"auguste", "august"},
		{"augustus", "augustus"},
		{"auk", "auk"},
		{"auks", "auk"},
		{"auld", "auld"},
		{"aunt", "aunt"},
		{"aunts", "aunt"},
		{"aura", "aura"},
		{"aureole", "aureol"},
		{"auriferous", "aurifer"},
		{"aus", "aus"},
		{"auspices", "auspic"},
		{"auspicious", "auspici"},
		{"austell", "austel"},
		{"austere", "auster"},
		{"austerity", "auster"},
		{"australes", "austral"},
		{"australey", "australey"},
		{"australia", "australia"},
		{"australian", "australian"},
		{"australians", "australian"},
		{"austrian", "austrian"},
		{"authentic", "authent"},
		{"authentically", "authent"},
		{"authenticated", "authent"},
		{"authenticity", "authent"},
		{"author", "author"},
		{"authoress", "authoress"},
		{"authoritative", "authorit"},
		{"authoritatively", "authorit"},
		{"authorities", "author"},
		{"authority", "author"},
		{"authorized", "author"},
		{"authors", "author"},
		{"authorship", "authorship"},
		{"autobiographies", "autobiographi"},
		{"autocratic", "autocrat"},
		{"autograph", "autograph"},
		{"autographs", "autograph"},
		{"automaton", "automaton"},
		{"autour", "autour"},
		{"autre", "autr"},
		{"autres", "autr"},
		{"autumn", "autumn"},
		{"autumnal", "autumn"},
		{"auvergne", "auvergn"},
		{"aux", "aux"},
		{"auxiliaries", "auxiliari"},
		{"auxiliary", "auxiliari"},
		{"ava", "ava"},
		{"avail", "avail"},
		{"available", "avail"},
		{"availed", "avail"},
		{"availing", "avail"},
		{"avails", "avail"},
		{"avarice", "avaric"},
		{"avaricious", "avarici"},
		{"avatar", "avatar"},
		{"avatars", "avatar"},
		{"avaunt", "avaunt"},
		{"avdotya", "avdotya"},
		{"ave", "ave"},
		{"avenge", "aveng"},
		{"avenger", "aveng"},
		{"avenges", "aveng"},
		{"avenging", "aveng"},
		{"avenue", "avenu"},
		{"avenues", "avenu"},
		{"average", "averag"},
		{"averaging", "averag"},
		{"averred", "aver"},
		{"averring", "aver"},
		{"avers", "aver"},
		{"averse", "avers"},
		{"aversion", "avers"},
		{"aversions", "avers"},
		{"avert", "avert"},
		{"averted", "avert"},
		{"averting", "avert"},
		{"avestruz", "avestruz"},
		{"aviary", "aviari"},
		{"avicularia", "avicularia"},
		{"avidity", "avid"},
		{"avignon", "avignon"},
		{"avocations", "avoc"},
		{"avoid", "avoid"},
		{"avoidable", "avoid"},
		{"avoidance", "avoid"},
		{"avoided", "avoid"},
		{"avoiding", "avoid"},
		{"avoids", "avoid"},
		{"avoient", "avoient"},
		{"avons", "avon"},
		{"avow", "avow"},
		{"avowal", "avow"},
		{"avowed", "avow"},
		{"avowedly", "avow"},
		{"avowing", "avow"},
		{"awa", "awa"},
		{"await", "await"},
		{"awaited", "await"},
		{"awaiting", "await"},
		{"awaits", "await"},
		{"awake", "awak"},
		{"awaken", "awaken"},
		{"awakened", "awaken"},
		{"awakening", "awaken"},
		{"awakens", "awaken"},
		{"awakes", "awak"},
		{"awaking", "awak"},
		{"aware", "awar"},
		{"away", "away"},
		{"awe", "awe"},
		{"awed", "awe"},
		{"awful", "aw"},
		{"awfullest", "awfullest"},
		{"awfully", "aw"},
		{"awhile", "awhil"},
		{"awhiles", "awhil"},
		{"awkward", "awkward"},
		{"awkwardly", "awkward"},
		{"awkwardness", "awkward"},
		{"awl", "awl"},
		{"awoided", "awoid"},
		{"awoke", "awok"},
		{"awry", "awri"},
		{"axe", "axe"},
		{"axes", "axe"},
		{"axiom", "axiom"},
		{"axis", "axi"},
		{"axles", "axl"},
		{"ay", "ay"},
		{"ayant", "ayant"},
		{"aye", "aye"},
		{"ayres", "ayr"},
		{"azalea", "azalea"},
		{"azara", "azara"},
		{"azarae", "azara"},
		{"azingly", "aze"},
		{"azores", "azor"},
		{"azucar", "azucar"},
		{"azure", "azur"},
		{"b", "b"},
		{"ba", "ba"},
		{"babble", "babbl"},
		{"babbled", "babbl"},
		{"babbling", "babbl"},
		{"babby", "babbi"},
		{"babe", "babe"},
		{"babel", "babel"},
		{"babes", "babe"},
		{"babies", "babi"},
		{"baboon", "baboon"},
		{"babushkin", "babushkin"},
		{"baby", "babi"},
		{"babylon", "babylon"},
		{"bac", "bac"},
		{"bacchus", "bacchus"},
		{"bachapins", "bachapin"},
		{"bachelor", "bachelor"},
		{"bachelorship", "bachelorship"},
		{"bachman", "bachman"},
		{"back", "back"},
		{"backbone", "backbon"},
		{"backed", "back"},
		{"backer", "backer"},
		{"backers", "backer"},
		{"backgammon", "backgammon"},
		{"background", "background"},
		{"backing", "back"},
		{"backs", "back"},
		{"backsheesh", "backsheesh"},
		{"backslidings", "backslid"},
		{"backward", "backward"},
		{"backwardness", "backward"},
		{"backwards", "backward"},
		{"backyard", "backyard"},
		{"bacon", "bacon"},
		{"bad", "bad"},
		{"bade", "bade"},
		{"baden", "baden"},
		{"badge", "badg"},
		{"badger", "badger"},
		{"badgered", "badger"},
		{"badges", "badg"},
		{"badinage", "badinag"},
		{"badly", "bad"},
		{"badness", "bad"},
		{"baffled", "baffl"},
		{"bag", "bag"},
		{"bagatelle", "bagatell"},
		{"baggage", "baggag"},
		{"bagnet", "bagnet"},
		{"bagnets", "bagnet"},
		{"bags", "bag"},
		{"baguet", "baguet"},
		{"bah", "bah"},
		{"bahama", "bahama"},
		{"bahia", "bahia"},
		{"bail", "bail"},
		{"bailed", "bail"},
		{"bailey", "bailey"},
		{"bailiff", "bailiff"},
		{"baillie", "bailli"},
		{"bairn", "bairn"},
		{"bairns", "bairn"},
		{"bait", "bait"},
		{"baited", "bait"},
		{"baize", "baiz"},
		{"bajada", "bajada"},
		{"bakaleyev", "bakaleyev"},
		{"baked", "bake"},
		{"baker", "baker"},
		{"bakers", "baker"},
		{"baking", "bake"},
		{"balalaika", "balalaika"},
		{"balance", "balanc"},
		{"balanced", "balanc"},
		{"balancing", "balanc"},
		{"balandra", "balandra"},
		{"balbi", "balbi"},
		{"balcarce", "balcarc"},
		{"balci", "balci"},
		{"balconies", "balconi"},
		{"balcony", "balconi"},
		{"bald", "bald"},
		{"bale", "bale"},
		{"baleful", "bale"},
		{"bales", "bale"},
		{"balked", "balk"},
		{"balking", "balk"},
		{"balks", "balk"},
		{"ball", "ball"},
		{"ballad", "ballad"},
		{"ballast", "ballast"},
		{"balled", "ball"},
		{"ballenagh", "ballenagh"},
		{"ballenar", "ballenar"},
		{"ballet", "ballet"},
		{"balloon", "balloon"},
		{"balloons", "balloon"},
		{"ballot", "ballot"},
		{"balls", "ball"},
		{"balm", "balm"},
		{"balmy", "balmi"},
		{"balsam", "balsam"},
		{"balusters", "balust"},
		{"balustrade", "balustrad"},
		{"balustrades", "balustrad"},
		{"bamboo", "bamboo"},
		{"bamboos", "bamboo"},
		{"bamford", "bamford"},
		{"banana", "banana"},
		{"bananas", "banana"},
		{"banc", "banc"},
		{"band", "band"},
		{"banda", "banda"},
		{"bandage", "bandag"},
		{"bandages", "bandag"},
		{"bandbox", "bandbox"},
		{"bandboxes", "bandbox"},
		{"bandied", "bandi"},
		{"bandit", "bandit"},
		{"banditti", "banditti"},
		{"bandmaster", "bandmast"},
		{"bands", "band"},
		{"bandy", "bandi"},
		{"bandying", "bandi"},
		{"bane", "bane"},
		{"baneful", "bane"},
		{"bang", "bang"},
		{"banged", "bang"},
		{"banging", "bang"},
		{"banish", "banish"},
		{"banishe", "banish"},
		{"banished", "banish"},
		{"banishes", "banish"},
		{"banishing", "banish"},
		{"banishment", "banish"},
		{"banisters", "banist"},
		{"bank", "bank"},
		{"banked", "bank"},
		{"banker", "banker"},
		{"bankers", "banker"},
		{"banking", "bank"},
		{"banknotes", "banknot"},
		{"bankrupt", "bankrupt"},
		{"bankruptcies", "bankruptci"},
		{"bankruptcy", "bankruptci"},
		{"bankrupts", "bankrupt"},
		{"banks", "bank"},
		{"banner", "banner"},
		{"banners", "banner"},
		{"banns", "bann"},
		{"banquet", "banquet"},
		{"banqueting", "banquet"},
		{"banquetings", "banquet"},
		{"banquets", "banquet"},
		{"banshee", "banshe"},
		{"bantam", "bantam"},
		{"banter", "banter"},
		{"bantering", "banter"},
		{"banters", "banter"},
		{"baptism", "baptism"},
		{"baptismal", "baptism"},
		{"baptistery", "baptisteri"},
		{"baptized", "baptiz"},
		{"baptizing", "baptiz"},
		{"bar", "bar"},
		{"barbare", "barbar"},
		{"barbarian", "barbarian"},
		{"barbarians", "barbarian"},
		{"barbarism", "barbar"},
		{"barbarous", "barbar"},
		{"barbary", "barbari"},
		{"barbauld", "barbauld"},
		{"barbecued", "barbecu"},
		{"barber", "barber"},
		{"barbs", "barb"},
		{"barbuda", "barbuda"},
		{"barcaroles", "barcarol"},
		{"bard", "bard"},
		{"bare", "bare"},
		{"bared", "bare"},
		{"barefaced", "barefac"},
		{"barefoot", "barefoot"},
		{"barefooted", "barefoot"},
		{"bareheaded", "barehead"},
		{"barely", "bare"},
		{"barest", "barest"},
		{"bargain", "bargain"},
		{"bargained", "bargain"},
		{"bargaining", "bargain"},
		{"bargains", "bargain"},
		{"barge", "barg"},
		{"barges", "barg"},
		{"baring", "bare"},
		{"bark", "bark"},
		{"barker", "barker"},
		{"barking", "bark"},
		{"barks", "bark"},
		{"barley", "barley"},
		{"barmaid", "barmaid"},
		{"barmherzige", "barmherzig"},
		{"barn", "barn"},
		{"barnacles", "barnacl"},
		{"barnard", "barnard"},
		{"barnet", "barnet"},
		{"barnevelts", "barnevelt"},
		{"barnton", "barnton"},
		{"barometer", "baromet"},
		{"baron", "baron"},
		{"baroness", "baro"},
		{"baronesses", "baro"},
		{"baronet", "baronet"},
		{"baronetcy", "baronetci"},
		{"baronets", "baronet"},
		{"baronial", "baroni"},
		{"barons", "baron"},
		{"barouche", "barouch"},
		{"barrack", "barrack"},
		{"barracks", "barrack"},
		{"barre", "barr"},
		{"barred", "bar"},
		{"barrel", "barrel"},
		{"barrels", "barrel"},
		{"barren", "barren"},
		{"barrenness", "barren"},
		{"barrett", "barrett"},
		{"barricade", "barricad"},
		{"barricaded", "barricad"},
		{"barrier", "barrier"},
		{"barriers", "barrier"},
		{"barrington", "barrington"},
		{"barrister", "barrist"},
		{"barristers", "barrist"},
		{"barrows", "barrow"},
		{"bars", "bar"},
		{"bart", "bart"},
		{"barter", "barter"},
		{"bartholomew", "bartholomew"},
		{"barton", "barton"},
		{"bas", "bas"},
		{"basa", "basa"},
		{"basal", "basal"},
		{"basalt", "basalt"},
		{"basalti", "basalti"},
		{"basaltic", "basalt"},
		{"base", "base"},
		{"based", "base"},
		{"basely", "base"},
		{"basement", "basement"},
		{"basements", "basement"},
		{"baseness", "base"},
		{"baser", "baser"},
		{"bases", "base"},
		{"basest", "basest"},
		{"bashful", "bash"},
		{"bashfully", "bash"},
		{"bashfulness", "bash"},
		{"basilisk", "basilisk"},
		{"basin", "basin"},
		{"basins", "basin"},
		{"basis", "basi"},
		{"bask", "bask"},
		{"basked", "bask"},
		{"basket", "basket"},
		{"basketful", "basket"},
		{"baskets", "basket"},
		{"basking", "bask"},
		{"basks", "bask"},
		{"basque", "basqu"},
		{"bass", "bass"},
		{"bassoon", "bassoon"},
		{"bastard", "bastard"},
		{"bat", "bat"},
		{"batch", "batch"},
		{"bate", "bate"},
		{"bath", "bath"},
		{"bathe", "bath"},
		{"bathed", "bath"},
		{"bathers", "bather"},
		{"bathes", "bath"},
		{"bathing", "bath"},
		{"baths", "bath"},
		{"bathurst", "bathurst"},
		{"batrachian", "batrachian"},
		{"bats", "bat"},
		{"battalion", "battalion"},
		{"batter", "batter"},
		{"battered", "batter"},
		{"battering", "batter"},
		{"battery", "batteri"},
		{"battle", "battl"},
		{"battled", "battl"},
		{"battlefield", "battlefield"},
		{"battlements", "battlement"},
		{"battles", "battl"},
		{"bauble", "baubl"},
		{"baubles", "baubl"},
		{"baudi", "baudi"},
		{"bawl", "bawl"},
		{"bawled", "bawl"},
		{"bawling", "bawl"},
		{"bawls", "bawl"},
		{"bay", "bay"},
		{"bayard", "bayard"},
		{"bayham", "bayham"},
		{"baying", "bay"},
		{"baynoe", "bayno"},
		{"bayonet", "bayonet"},
		{"bays", "bay"},
		{"bazaar", "bazaar"},
		{"be", "be"},
		{"bea", "bea"},
		{"beach", "beach"},
		{"beaches", "beach"},
		{"beachheads", "beachhead"},
		{"beacon", "beacon"},
		{"beacons", "beacon"},
		{"bead", "bead"},
		{"beaded", "bead"},
		{"beadle", "beadl"},
		{"beadles", "beadl"},
		{"beads", "bead"},
		{"beagle", "beagl"},
		{"beak", "beak"},
		{"beaks", "beak"},
		{"beam", "beam"},
		{"beamed", "beam"},
		{"beaming", "beam"},
		{"beamingly", "beam"},
		{"beams", "beam"},
		{"bean", "bean"},
		{"beans", "bean"},
		{"bear", "bear"},
		{"beard", "beard"},
		{"bearded", "beard"},
		{"beardless", "beardless"},
		{"beards", "beard"},
		{"bearer", "bearer"},
		{"bearers", "bearer"},
		{"bearing", "bear"},
		{"bearings", "bear"},
		{"bearish", "bearish"},
		{"bears", "bear"},
		{"beast", "beast"},
		{"beastliness", "beastli"},
		{"beastly", "beast"},
		{"beasts", "beast"},
		{"beat", "beat"},
		{"beaten", "beaten"},
		{"beaters", "beater"},
		{"beating", "beat"},
		{"beatings", "beat"},
		{"beats", "beat"},
		{"beatson", "beatson"},
		{"beatten", "beatten"},
		{"beau", "beau"},
		{"beauchamp", "beauchamp"},
		{"beaufort", "beaufort"},
		{"beauteous", "beauteous"},
		{"beauties", "beauti"},
		{"beautiful", "beauti"},
		{"beautifullest", "beautifullest"},
		{"beautifully", "beauti"},
		{"beauty", "beauti"},
		{"beaux", "beaux"},
		{"beaver", "beaver"},
		{"becalmed", "becalm"},
		{"became", "becam"},
		{"because", "becaus"},
		{"beck", "beck"},
		{"beckon", "beckon"},
		{"beckoned", "beckon"},
		{"beckoning", "beckon"},
		{"beckons", "beckon"},
		{"become", "becom"},
		{"becomes", "becom"},
		{"becoming", "becom"},
		{"bed", "bed"},
		{"bedabbled", "bedabbl"},
		{"bedaubed", "bedaub"},
		{"bedchamber", "bedchamb"},
		{"bedchambers", "bedchamb"},
		{"bedclothes", "bedcloth"},
		{"bedding", "bed"},
		{"bedecked", "bedeck"},
		{"bedecks", "bedeck"},
		{"bedevilment", "bedevil"},
		{"bedfellows", "bedfellow"},
		{"bedlam", "bedlam"},
		{"bedridden", "bedridden"},
		{"bedroom", "bedroom"},
		{"bedrooms", "bedroom"},
		{"beds", "bed"},
		{"bedside", "bedsid"},
		{"bedstead", "bedstead"},
		{"bedsteads", "bedstead"},
		{"bedtime", "bedtim"},
		{"bee", "bee"},
		{"beech", "beech"},
		{"beechey", "beechey"},
		{"beef", "beef"},
		{"beefsteak", "beefsteak"},
		{"beehive", "beehiv"},
		{"been", "been"},
		{"beer", "beer"},
		{"bees", "bee"},
		{"beeswax", "beeswax"},
		{"beeswaxes", "beeswax"},
		{"beetle", "beetl"},
		{"beetles", "beetl"},
		{"befall", "befal"},
		{"befallen", "befallen"},
		{"befell", "befel"},
		{"befillaire", "befillair"},
		{"befit", "befit"},
		{"befits", "befit"},
		{"befitting", "befit"},
		{"befogged", "befog"},
		{"before", "befor"},
		{"beforehand", "beforehand"},
		{"befriend", "befriend"},
		{"befriended", "befriend"},
		{"befriending", "befriend"},
		{"beg", "beg"},
		{"bega", "bega"},
		{"began", "began"},
		{"begat", "begat"},
		{"beget", "beget"},
		{"beggar", "beggar"},
		{"beggared", "beggar"},
		{"beggarly", "beggar"},
		{"beggars", "beggar"},
		{"beggary", "beggari"},
		{"begged", "beg"},
		{"begging", "beg"},
		{"begin", "begin"},
		{"beginning", "begin"},
		{"beginnings", "begin"},
		{"begins", "begin"},
		{"begludship", "begludship"},
		{"begone", "begon"},
		{"begotten", "begotten"},
		{"begrimed", "begrim"},
		{"begrimes", "begrim"},
		{"begrudge", "begrudg"},
		{"begrudged", "begrudg"},
		{"begs", "beg"},
		{"beguile", "beguil"},
		{"beguiled", "beguil"},
		{"begun", "begun"},
		{"behalf", "behalf"},
		{"behave", "behav"},
		{"behaved", "behav"},
		{"behaves", "behav"},
		{"behaving", "behav"},
		{"behavior", "behavior"},
		{"behaviour", "behaviour"},
		{"beheaded", "behead"},
		{"beheld", "beheld"},
		{"behest", "behest"},
		{"behests", "behest"},
		{"behind", "behind"},
		{"behindhand", "behindhand"},
		{"behold", "behold"},
		{"beholden", "beholden"},
		{"beholder", "behold"},
		{"beholders", "behold"},
		{"beholding", "behold"},
		{"beholds", "behold"},
		{"behoof", "behoof"},
		{"behoved", "behov"},
		{"behoves", "behov"},
		{"behring", "behr"},
		{"being", "be"},
		{"beings", "be"},
		{"beknown", "beknown"},
		{"belated", "belat"},
		{"belauded", "belaud"},
		{"beldame", "beldam"},
		{"belfry", "belfri"},
		{"belgrave", "belgrav"},
		{"belgravia", "belgravia"},
		{"belgravian", "belgravian"},
		{"belie", "beli"},
		{"belied", "beli"},
		{"belief", "belief"},
		{"beliefs", "belief"},
		{"believe", "believ"},
		{"believed", "believ"},
		{"believer", "believ"},
		{"believers", "believ"},
		{"believes", "believ"},
		{"believest", "believest"},
		{"believeth", "believeth"},
		{"believing", "believ"},
		{"bell", "bell"},
		{"bellavista", "bellavista"},
		{"belle", "bell"},
		{"belled", "bell"},
		{"bellies", "belli"},
		{"belligerents", "belliger"},
		{"belling", "bell"},
		{"bellmen", "bellmen"},
		{"bellow", "bellow"},
		{"bellower", "bellow"},
		{"bellowing", "bellow"},
		{"bellows", "bellow"},
		{"bells", "bell"},
		{"belly", "belli"},
		{"belong", "belong"},
		{"belonged", "belong"},
		{"belonging", "belong"},
		{"belongings", "belong"},
		{"belongs", "belong"},
		{"beloved", "belov"},
		{"below", "below"},
		{"belt", "belt"},
		{"belts", "belt"},
		{"belvawney", "belvawney"},
		{"belvedere", "belveder"},
		{"bemoaned", "bemoan"},
		{"ben", "ben"},
		{"bench", "bench"},
		{"bencher", "bencher"},
		{"benchers", "bencher"},
		{"benches", "bench"},
		{"benchuca", "benchuca"},
		{"bend", "bend"},
		{"bended", "bend"},
		{"bending", "bend"},
		{"bends", "bend"},
		{"beneath", "beneath"},
		{"benedict", "benedict"},
		{"benediction", "benedict"},
		{"benefactor", "benefactor"},
		{"benefactors", "benefactor"},
		{"beneficent", "benefic"},
		{"beneficently", "benefic"},
		{"beneficial", "benefici"},
		{"benefit", "benefit"},
		{"benefited", "benefit"},
		{"benefiting", "benefit"},
		{"benefits", "benefit"},
		{"benet", "benet"},
		{"benevolence", "benevol"},
		{"benevolent", "benevol"},
		{"bengal", "bengal"},
		{"benguela", "benguela"},
		{"benighted", "benight"},
		{"benign", "benign"},
		{"benignant", "benign"},
		{"benignantly", "benign"},
		{"benignity", "benign"},
		{"benignly", "benign"},
		{"benito", "benito"},
		{"bennet", "bennet"},
		{"bennett", "bennett"},
		{"benson", "benson"},
		{"bent", "bent"},
		{"benumbed", "benumb"},
		{"bequeath", "bequeath"},
		{"bequeathed", "bequeath"},
		{"bequeathing", "bequeath"},
		{"bequest", "bequest"},
		{"berardi", "berardi"},
		{"bereaved", "bereav"},
		{"bereft", "bereft"},
		{"berg", "berg"},
		{"berkele", "berkel"},
		{"berkeley", "berkeley"},
		{"berlin", "berlin"},
		{"bermudas", "bermuda"},
		{"bernantio", "bernantio"},
		{"beroe", "bero"},
		{"berquelo", "berquelo"},
		{"berrid", "berrid"},
		{"berried", "berri"},
		{"berries", "berri"},
		{"berrin", "berrin"},
		{"berry", "berri"},
		{"berryin", "berryin"},
		{"berteroii", "berteroii"},
		{"berth", "berth"},
		{"berthelot", "berthelot"},
		{"bertram", "bertram"},
		{"beryl", "beryl"},
		{"berzelius", "berzelius"},
		{"beseech", "beseech"},
		{"beseeches", "beseech"},
		{"beseeching", "beseech"},
		{"beseechingly", "beseech"},
		{"beseeltes", "beseelt"},
		{"beseems", "beseem"},
		{"beset", "beset"},
		{"besetting", "beset"},
		{"beside", "besid"},
		{"besides", "besid"},
		{"besieged", "besieg"},
		{"besmeared", "besmear"},
		{"besought", "besought"},
		{"bespattered", "bespatt"},
		{"bespeak", "bespeak"},
		{"bespeaking", "bespeak"},
		{"bespeaks", "bespeak"},
		{"bespeckled", "bespeckl"},
		{"bespoke", "bespok"},
		{"besprinkled", "besprinkl"},
		{"best", "best"},
		{"bestest", "bestest"},
		{"bestir", "bestir"},
		{"bestow", "bestow"},
		{"bestowal", "bestow"},
		{"bestowed", "bestow"},
		{"bestowing", "bestow"},
		{"bestows", "bestow"},
		{"bet", "bet"},
		{"betake", "betak"},
		{"betaken", "betaken"},
		{"bethany", "bethani"},
		{"bethel", "bethel"},
		{"bethlehem", "bethlehem"},
		{"bethought", "bethought"},
		{"betimes", "betim"},
		{"betokened", "betoken"},
		{"betokening", "betoken"},
		{"betook", "betook"},
		{"betray", "betray"},
		{"betrayal", "betray"},
		{"betrayed", "betray"},
		{"betraying", "betray"},
		{"betrays", "betray"},
		{"betrothed", "betroth"},
		{"bets", "bet"},
		{"better", "better"},
		{"betters", "better"},
		{"betther", "betther"},
		{"betting", "bet"},
		{"betty", "betti"},
		{"betuloides", "betuloid"},
		{"betwee", "betwe"},
		{"between", "between"},
		{"betwixt", "betwixt"},
		{"beudant", "beudant"},
		{"bevan", "bevan"},
		{"beverage", "beverag"},
		{"beverley", "beverley"},
		{"bewail", "bewail"},
		{"bewailed", "bewail"},
		{"bewailing", "bewail"},
		{"beware", "bewar"},
		{"bewilder", "bewild"},
		{"bewildered", "bewild"},
		{"bewildering", "bewild"},
		{"bewilderment", "bewilder"},
		{"bewitched", "bewitch"},
		{"bewitching", "bewitch"},
		{"beyond", "beyond"},
		{"bezants", "bezant"},
		{"bezzemelny", "bezzemelni"},
		{"bianchini", "bianchini"},
		{"bias", "bias"},
		{"bible", "bibl"},
		{"bibo", "bibo"},
		{"bibron", "bibron"},
		{"bid", "bid"},
		{"biddable", "biddabl"},
		{"bidden", "bidden"},
		{"bidder", "bidder"},
		{"bidding", "bid"},
		{"biddy", "biddi"},
		{"bide", "bide"},
		{"biding", "bide"},
		{"bids", "bid"},
		{"bien", "bien"},
		{"biffin", "biffin"},
		{"bifurcating", "bifurc"},
		{"bifurcation", "bifurc"},
		{"big", "big"},
		{"bigamy", "bigami"},
		{"bigger", "bigger"},
		{"biggest", "biggest"},
		{"bigness", "big"},
		{"bigoted", "bigot"},
		{"bigotry", "bigotri"},
		{"bile", "bile"},
		{"bileing", "bile"},
		{"bilious", "bilious"},
		{"bill", "bill"},
		{"billed", "bill"},
		{"billet", "billet"},
		{"billeted", "billet"},
		{"billiard", "billiard"},
		{"billiards", "billiard"},
		{"billing", "bill"},
		{"billows", "billow"},
		{"bills", "bill"},
		{"bin", "bin"},
		{"bind", "bind"},
		{"binding", "bind"},
		{"bindings", "bind"},
		{"bindloes", "bindlo"},
		{"binds", "bind"},
		{"bingley", "bingley"},
		{"binn", "binn"},
		{"biographical", "biograph"},
		{"biography", "biographi"},
		{"bios", "bio"},
		{"biped", "bipe"},
		{"birch", "birch"},
		{"bird", "bird"},
		{"birdcage", "birdcag"},
		{"birds", "bird"},
		{"birgos", "birgo"},
		{"birmingham", "birmingham"},
		{"birth", "birth"},
		{"birthday", "birthday"},
		{"birthdays", "birthday"},
		{"birthplace", "birthplac"},
		{"birthright", "birthright"},
		{"births", "birth"},
		{"biscuit", "biscuit"},
		{"biscuits", "biscuit"},
		{"bisecting", "bisect"},
		{"bisection", "bisect"},
		{"bishop", "bishop"},
		{"bishopgate", "bishopg"},
		{"bishopric", "bishopr"},
		{"bishops", "bishop"},
		{"bishopsgate", "bishopsg"},
		{"bismarcks", "bismarck"},
		{"bisness", "bis"},
		{"bit", "bit"},
		{"bitch", "bitch"},
		{"bite", "bite"},
		{"bites", "bite"},
		{"biting", "bite"},
		{"bits", "bit"},
		{"bitted", "bit"},
		{"bitten", "bitten"},
		{"bitter", "bitter"},
		{"bitterer", "bitter"},
		{"bitterest", "bitterest"},
		{"bitterly", "bitter"},
		{"bitterness", "bitter"},
		{"bivalves", "bivalv"},
		{"bivouac", "bivouac"},
		{"bivouacked", "bivouack"},
		{"bivouacking", "bivouack"},
		{"bizcacha", "bizcacha"},
		{"bizcachas", "bizcacha"},
		{"blab", "blab"},
		{"black", "black"},
		{"blackamoor", "blackamoor"},
		{"blackberries", "blackberri"},
		{"blackberry", "blackberri"},
		{"blackbird", "blackbird"},
		{"blacken", "blacken"},
		{"blackened", "blacken"},
		{"blackens", "blacken"},
		{"blacker", "blacker"},
		{"blackest", "blackest"},
		{"blackfriars", "blackfriar"},
		{"blackguard", "blackguard"},
		{"blackguardly", "blackguard"},
		{"blackguards", "blackguard"},
		{"blackhaired", "blackhair"},
		{"blackheath", "blackheath"},
		{"blacking", "black"},
		{"blackish", "blackish"},
		{"blacklead", "blacklead"},
		{"blackleg", "blackleg"},
		{"blacks", "black"},
		{"blacksmith", "blacksmith"},
		{"blacksmiths", "blacksmith"},
		{"blackstone", "blackston"},
		{"blackwall", "blackwal"},
		{"bladder", "bladder"},
		{"bladders", "bladder"},
		{"blade", "blade"},
		{"bladed", "blade"},
		{"blades", "blade"},
		{"blain", "blain"},
		{"blamable", "blamabl"},
		{"blame", "blame"},
		{"blameable", "blameabl"},
		{"blamed", "blame"},
		{"blameless", "blameless"},
		{"blamelessness", "blameless"},
		{"blames", "blame"},
		{"blaming", "blame"},
		{"blanc", "blanc"},
		{"blanca", "blanca"},
		{"blanche", "blanch"},
		{"blanched", "blanch"},
		{"blanco", "blanco"},
		{"bland", "bland"},
		{"blandest", "blandest"},
		{"blandishments", "blandish"},
		{"blandly", "bland"},
		{"blank", "blank"},
		{"blanket", "blanket"},
		{"blankets", "blanket"},
		{"blankly", "blank"},
		{"blankness", "blank"},
		{"blanks", "blank"},
		{"blas", "blas"},
		{"blasphemer", "blasphem"},
		{"blasphemy", "blasphemi"},
		{"blast", "blast"},
		{"blasted", "blast"},
		{"blasts", "blast"},
		{"blatta", "blatta"},
		{"blaze", "blaze"},
		{"blazing", "blaze"},
		{"blazoned", "blazon"},
		{"bleached", "bleach"},
		{"bleak", "bleak"},
		{"bleakness", "bleak"},
		{"blear", "blear"},
		{"bleared", "blear"},
		{"bled", "bled"},
		{"bleed", "bleed"},
		{"bleeding", "bleed"},
		{"blemish", "blemish"},
		{"blemishes", "blemish"},
		{"blench", "blench"},
		{"blended", "blend"},
		{"blending", "blend"},
		{"blends", "blend"},
		{"bless", "bless"},
		{"blessed", "bless"},
		{"blessedness", "blessed"},
		{"blesses", "bless"},
		{"blessing", "bless"},
		{"blessings", "bless"},
		{"blest", "blest"},
		{"blew", "blew"},
		{"blight", "blight"},
		{"blighted", "blight"},
		{"blighting", "blight"},
		{"blights", "blight"},
		{"blind", "blind"},
		{"blinded", "blind"},
		{"blinder", "blinder"},
		{"blindfolding", "blindfold"},
		{"blinding", "blind"},
		{"blindly", "blind"},
		{"blindness", "blind"},
		{"blindnesses", "blind"},
		{"blinds", "blind"},
		{"blink", "blink"},
		{"blinkers", "blinker"},
		{"blinking", "blink"},
		{"blinks", "blink"},
		{"bliss", "bliss"},
		{"blissful", "bliss"},
		{"blister", "blister"},
		{"blistered", "blister"},
		{"blistering", "blister"},
		{"blithe", "blith"},
		{"blitheness", "blith"},
		{"blo", "blo"},
		{"bloated", "bloat"},
		{"block", "block"},
		{"blockade", "blockad"},
		{"blockaded", "blockad"},
		{"blocked", "block"},
		{"blockhead", "blockhead"},
		{"blockheads", "blockhead"},
		{"blocking", "block"},
		{"blocks", "block"},
		{"blockson", "blockson"},
		{"blood", "blood"},
		{"blooded", "blood"},
		{"bloodhound", "bloodhound"},
		{"bloodless", "bloodless"},
		{"bloodlessness", "bloodless"},
		{"bloods", "blood"},
		{"bloodshed", "bloodsh"},
		{"bloodshot", "bloodshot"},
		{"bloodthirsty", "bloodthirsti"},
		{"bloody", "bloodi"},
		{"bloom", "bloom"},
		{"bloometh", "bloometh"},
		{"blooming", "bloom"},
		{"bloomsbury", "bloomsburi"},
		{"blossom", "blossom"},
		{"blossomed", "blossom"},
		{"blossoming", "blossom"},
		{"blossoms", "blossom"},
		{"blot", "blot"},
		{"blotches", "blotch"},
		{"blotchy", "blotchi"},
		{"blots", "blot"},
		{"blotted", "blot"},
		{"blotting", "blot"},
		{"blow", "blow"},
		{"blowed", "blow"},
		{"blower", "blower"},
		{"blowers", "blower"},
		{"blowing", "blow"},
		{"blown", "blown"},
		{"blowpipe", "blowpip"},
		{"blows", "blow"},
		{"blubber", "blubber"},
		{"blubbered", "blubber"},
		{"bludgeon", "bludgeon"},
		{"bludgeons", "bludgeon"},
		{"blue", "blue"},
		{"bluebells", "bluebel"},
		{"blues", "blue"},
		{"bluff", "bluff"},
		{"bluffy", "bluffi"},
		{"bluid", "bluid"},
		{"bluish", "bluish"},
		{"blulfy", "blulfi"},
		{"blunder", "blunder"},
		{"blunderbore", "blunderbor"},
		{"blunderbus", "blunderbus"},
		{"blunderbuss", "blunderbuss"},
		{"blundered", "blunder"},
		{"blundering", "blunder"},
		{"blunders", "blunder"},
		{"blunt", "blunt"},
		{"blunted", "blunt"},
		{"bluntly", "blunt"},
		{"bluntness", "blunt"},
		{"blur", "blur"},
		{"blurs", "blur"},
		{"blurt", "blurt"},
		{"blurted", "blurt"},
		{"blurting", "blurt"},
		{"blurts", "blurt"},
		{"blush", "blush"},
		{"blushed", "blush"},
		{"blushes", "blush"},
		{"blushing", "blush"},
		{"blushingly", "blush"},
		{"bluster", "bluster"},
		{"blusterers", "bluster"},
		{"blustering", "bluster"},
		{"bo", "bo"},
		{"boa", "boa"},
		{"boan", "boan"},
		{"boans", "boan"},
		{"boar", "boar"},
		{"board", "board"},
		{"boarded", "board"},
		{"boarder", "boarder"},
		{"boarders", "boarder"},
		{"boarding", "board"},
		{"boards", "board"},
		{"boars", "boar"},
		{"boas", "boa"},
		{"boast", "boast"},
		{"boasted", "boast"},
		{"boastful", "boast"},
		{"boastfully", "boast"},
		{"boastfulness", "boast"},
		{"boasting", "boast"},
		{"boasts", "boast"},
		{"boat", "boat"},
		{"boating", "boat"},
		{"boats", "boat"},
		{"bob", "bob"},
		{"bobbed", "bob"},
		{"bobbing", "bob"},
		{"bobbish", "bobbish"},
		{"bobs", "bob"},
		{"bobster", "bobster"},
		{"bod", "bod"},
		{"boddy", "boddi"},
		{"bodice", "bodic"},
		{"bodied", "bodi"},
		{"bodies", "bodi"},
		{"bodilessness", "bodiless"},
		{"bodily", "bodili"},
		{"boding", "bode"},
		{"bodkins", "bodkin"},
		{"body", "bodi"},
		{"boer", "boer"},
		{"boffin", "boffin"},
		{"boffinites", "boffinit"},
		{"bog", "bog"},
		{"bogg", "bogg"},
		{"bogsby", "bogsbi"},
		{"boguey", "boguey"},
		{"bohemianism", "bohemian"},
		{"bohemond", "bohemond"},
		{"boil", "boil"},
		{"boiled", "boil"},
		{"boiler", "boiler"},
		{"boilers", "boiler"},
		{"boiling", "boil"},
		{"boils", "boil"},
		{"bois", "boi"},
		{"boisterous", "boister"},
		{"boisterously", "boister"},
		{"bolabola", "bolabola"},
		{"bolas", "bola"},
		{"bold", "bold"},
		{"bolder", "bolder"},
		{"boldest", "boldest"},
		{"boldly", "bold"},
		{"boldness", "bold"},
		{"bole", "bole"},
		{"boles", "bole"},
		{"bolivia", "bolivia"},
		{"bolivian", "bolivian"},
		{"bolster", "bolster"},
		{"bolt", "bolt"},
		{"bolted", "bolt"},
		{"bolter", "bolter"},
		{"bolting", "bolt"},
		{"bolts", "bolt"},
		{"bomb", "bomb"},
		{"bombarding", "bombard"},
		{"bombs", "bomb"},
		{"bon", "bon"},
		{"bona", "bona"},
		{"bond", "bond"},
		{"bondage", "bondag"},
		{"bonds", "bond"},
		{"bone", "bone"},
		{"boned", "bone"},
		{"bones", "bone"},
		{"bonfires", "bonfir"},
		{"bonitos", "bonito"},
		{"bonjour", "bonjour"},
		{"bonn", "bonn"},
		{"bonne", "bonn"},
		{"bonnet", "bonnet"},
		{"bonnets", "bonnet"},
		{"bonney", "bonney"},
		{"bonny", "bonni"},
		{"bonpland", "bonpland"},
		{"bons", "bon"},
		{"bony", "boni"},
		{"booby", "boobi"},
		{"boodle", "boodl"},
		{"boody", "boodi"},
		{"book", "book"},
		{"bookcase", "bookcas"},
		{"booked", "book"},
		{"booker", "booker"},
		{"booking", "book"},
		{"bookish", "bookish"},
		{"books", "book"},
		{"bookseller", "booksel"},
		{"booksellers", "booksel"},
		{"bookstall", "bookstal"},
		{"bookworms", "bookworm"},
		{"boom", "boom"},
		{"boomerang", "boomerang"},
		{"boon", "boon"},
		{"boorioboola", "boorioboola"},
		{"boorly", "boor"},
		{"boost", "boost"},
		{"boot", "boot"},
		{"booth", "booth"},
		{"booths", "booth"},
		{"boots", "boot"},
		{"bootuns", "bootun"},
		{"booty", "booti"},
		{"boozed", "booz"},
		{"boozums", "boozum"},
		{"bor", "bor"},
		{"bord", "bord"},
		{"border", "border"},
		{"bordered", "border"},
		{"bordering", "border"},
		{"borders", "border"},
		{"bore", "bore"},
		{"boreali", "boreali"},
		{"boreas", "borea"},
		{"bored", "bore"},
		{"boredom", "boredom"},
		{"bores", "bore"},
		{"boring", "bore"},
		{"born", "born"},
		{"borne", "born"},
		{"borneo", "borneo"},
		{"borough", "borough"},
		{"boroughbridge", "boroughbridg"},
		{"boroughmongering", "boroughmong"},
		{"boroughs", "borough"},
		{"borreria", "borreria"},
		{"borrioboola", "borrioboola"},
		{"borrioboolan", "borrioboolan"},
		{"borriohoola", "borriohoola"},
		{"borrow", "borrow"},
		{"borrowed", "borrow"},
		{"borrower", "borrow"},
		{"borrowers", "borrow"},
		{"borrowing", "borrow"},
		{"borrows", "borrow"},
		{"borum", "borum"},
		{"bory", "bori"},
		{"bos", "bos"},
		{"bosh", "bosh"},
		{"bosom", "bosom"},
		{"bosomer", "bosom"},
		{"bosoms", "bosom"},
		{"bosses", "boss"},
		{"boston", "boston"},
		{"bot", "bot"},
		{"botanic", "botan"},
		{"botanical", "botan"},
		{"botanist", "botanist"},
		{"botanists", "botanist"},
		{"botanizing", "botan"},
		{"botany", "botani"},
		{"both", "both"},
		{"bother", "bother"},
		{"botheration", "bother"},
		{"bothered", "bother"},
		{"bothering", "bother"},
		{"botofogo", "botofogo"},
		{"bott", "bott"},
		{"bottin", "bottin"},
		{"bottinney", "bottinney"},
		{"bottle", "bottl"},
		{"bottled", "bottl"},
		{"bottles", "bottl"},
		{"bottom", "bottom"},
		{"bottomed", "bottom"},
		{"bottomless", "bottomless"},
		{"bottoms", "bottom"},
		{"boudoir", "boudoir"},
		{"bougainville", "bougainvill"},
		{"boughs", "bough"},
		{"bought", "bought"},
		{"boulder", "boulder"},
		{"boulders", "boulder"},
		{"boulevard", "boulevard"},
		{"bouleversees", "bouleverse"},
		{"boulogne", "boulogn"},
		{"boulong", "boulong"},
		{"bounced", "bounc"},
		{"bouncing", "bounc"},
		{"bound", "bound"},
		{"boundaries", "boundari"},
		{"boundary", "boundari"},
		{"bounde", "bound"},
		{"bounded", "bound"},
		{"bounden", "bounden"},
		{"bounding", "bound"},
		{"boundless", "boundless"},
		{"bounds", "bound"},
		{"boung", "boung"},
		{"boungites", "boungit"},
		{"bountiful", "bounti"},
		{"bounty", "bounti"},
		{"bouquet", "bouquet"},
		{"bouquets", "bouquet"},
		{"bourbon", "bourbon"},
		{"bourgeois", "bourgeoi"},
		{"bourne", "bourn"},
		{"bout", "bout"},
		{"bow", "bow"},
		{"bowed", "bow"},
		{"bowels", "bowel"},
		{"bower", "bower"},
		{"bowered", "bower"},
		{"bowers", "bower"},
		{"bowery", "boweri"},
		{"bowing", "bow"},
		{"bowl", "bowl"},
		{"bowled", "bowl"},
		{"bowling", "bowl"},
		{"bowls", "bowl"},
		{"bows", "bow"},
		{"box", "box"},
		{"boxed", "box"},
		{"boxes", "box"},
		{"boxing", "box"},
		{"boy", "boy"},
		{"boyhood", "boyhood"},
		{"boyish", "boyish"},
		{"boys", "boy"},
		{"boytborn", "boytborn"},
		{"boythorn", "boythorn"},
		{"brabantio", "brabantio"},
		{"brace", "brace"},
		{"braced", "brace"},
		{"bracelet", "bracelet"},
		{"bracelets", "bracelet"},
		{"braces", "brace"},
		{"brachelytra", "brachelytra"},
		{"brachiotis", "brachioti"},
		{"brachyptera", "brachyptera"},
		{"bracing", "brace"},
		{"brackish", "brackish"},
		{"bradshaw", "bradshaw"},
		{"brag", "brag"},
		{"braggadocio", "braggadocio"},
		{"braggart", "braggart"},
		{"bragging", "brag"},
		{"braid", "braid"},
		{"braided", "braid"},
		{"braids", "braid"},
		{"brain", "brain"},
		{"brained", "brain"},
		{"brainless", "brainless"},
		{"brains", "brain"},
		{"brak", "brak"},
		{"brake", "brake"},
		{"brakes", "brake"},
		{"bramador", "bramador"},
		{"brambles", "brambl"},
		{"bran", "bran"},
		{"branc", "branc"},
		{"branch", "branch"},
		{"branched", "branch"},
		{"branches", "branch"},
		{"branchiae", "branchia"},
		{"branchial", "branchial"},
		{"branching", "branch"},
		{"brand", "brand"},
		{"branded", "brand"},
		{"branding", "brand"},
		{"brandished", "brandish"},
		{"brandishing", "brandish"},
		{"brandon", "brandon"},
		{"brandons", "brandon"},
		{"brandy", "brandi"},
		{"brash", "brash"},
		{"brasiliensis", "brasiliensi"},
		{"brass", "brass"},
		{"brasses", "brass"},
		{"brat", "brat"},
		{"brats", "brat"},
		{"bravado", "bravado"},
		{"bravard", "bravard"},
		{"bravassa", "bravassa"},
		{"brave", "brave"},
		{"braved", "brave"},
		{"bravely", "brave"},
		{"bravery", "braveri"},
		{"bravest", "bravest"},
		{"braving", "brave"},
		{"bravo", "bravo"},
		{"brawl", "brawl"},
		{"brawler", "brawler"},
		{"brawling", "brawl"},
		{"brawny", "brawni"},
		{"braxon", "braxon"},
		{"bray", "bray"},
		{"braying", "bray"},
		{"brazen", "brazen"},
		{"brazened", "brazen"},
		{"brazil", "brazil"},
		{"brazilian", "brazilian"},
		{"brazilians", "brazilian"},
		{"brazils", "brazil"},
		{"breach", "breach"},
		{"breached", "breach"},
		{"breaches", "breach"},
		{"bread", "bread"},
		{"breads", "bread"},
		{"breadth", "breadth"},
		{"break", "break"},
		{"breaker", "breaker"},
		{"breakers", "breaker"},
		{"breakfast", "breakfast"},
		{"breakfasted", "breakfast"},
		{"breakfasting", "breakfast"},
		{"breakfasts", "breakfast"},
		{"breakin", "breakin"},
		{"breaking", "break"},
		{"breaks", "break"},
		{"breakwater", "breakwat"},
		{"breakwaters", "breakwat"},
		{"breast", "breast"},
		{"breasted", "breast"},
		{"breasts", "breast"},
		{"breastwork", "breastwork"},
		{"breath", "breath"},
		{"breathe", "breath"},
		{"breathed", "breath"},
		{"breathes", "breath"},
		{"breathing", "breath"},
		{"breathings", "breath"},
		{"breathless", "breathless"},
		{"breathlessly", "breathless"},
		{"breathlessness", "breathless"},
		{"breaths", "breath"},
		{"breccia", "breccia"},
		{"bred", "bred"},
		{"bree", "bree"},
		{"breeches", "breech"},
		{"breed", "breed"},
		{"breeder", "breeder"},
		{"breeding", "breed"},
		{"breeds", "breed"},
		{"breeze", "breez"},
		{"breezes", "breez"},
		{"breezy", "breezi"},
		{"brethren", "brethren"},
		{"brevity", "breviti"},
		{"brew", "brew"},
		{"brewed", "brew"},
		{"brewer", "brewer"},
		{"brewers", "brewer"},
		{"brewery", "breweri"},
		{"brewing", "brew"},
		{"brewster", "brewster"},
		{"bribe", "bribe"},
		{"bribed", "bribe"},
		{"bribery", "briberi"},
		{"bribes", "bribe"},
		{"bribing", "bribe"},
		{"brick", "brick"},
		{"bricked", "brick"},
		{"bricklayers", "bricklay"},
		{"brickmaker", "brickmak"},
		{"brickmakers", "brickmak"},
		{"bricks", "brick"},
		{"brickwork", "brickwork"},
		{"bridal", "bridal"},
		{"bride", "bride"},
		{"bridegroom", "bridegroom"},
		{"bridesmaid", "bridesmaid"},
		{"bridesmaids", "bridesmaid"},
		{"bridge", "bridg"},
		{"bridged", "bridg"},
		{"bridges", "bridg"},
		{"bridle", "bridl"},
		{"bridling", "bridl"},
		{"brief", "brief"},
		{"briefly", "briefli"},
		{"briefs", "brief"},
		{"brier", "brier"},
		{"briers", "brier"},
		{"brig", "brig"},
		{"brigade", "brigad"},
		{"brigand", "brigand"},
		{"brigands", "brigand"},
		{"bright", "bright"},
		{"brighten", "brighten"},
		{"brightened", "brighten"},
		{"brightening", "brighten"},
		{"brightens", "brighten"},
		{"brighter", "brighter"},
		{"brightest", "brightest"},
		{"brightly", "bright"},
		{"brightness", "bright"},
		{"brighton", "brighton"},
		{"brigs", "brig"},
		{"brilliance", "brillianc"},
		{"brilliancy", "brillianc"},
		{"brilliant", "brilliant"},
		{"brilliantly", "brilliant"},
		{"brim", "brim"},
		{"brimful", "brim"},
		{"brimless", "brimless"},
		{"brimmed", "brim"},
		{"brimming", "brim"},
		{"brimmy", "brimmi"},
		{"brims", "brim"},
		{"brimstone", "brimston"},
		{"brindle", "brindl"},
		{"brine", "brine"},
		{"bring", "bring"},
		{"bringing", "bring"},
		{"brings", "bring"},
		{"brink", "brink"},
		{"briny", "brini"},
		{"brisk", "brisk"},
		{"brisker", "brisker"},
		{"briskly", "brisk"},
		{"briskness", "brisk"},
		{"bristle", "bristl"},
		{"bristled", "bristl"},
		{"bristles", "bristl"},
		{"bristly", "brist"},
		{"bristol", "bristol"},
		{"brit", "brit"},
		{"britain", "britain"},
		{"britannia", "britannia"},
		{"british", "british"},
		{"briton", "briton"},
		{"brittann", "brittann"},
		{"brittle", "brittl"},
		{"broach", "broach"},
		{"broached", "broach"},
		{"broad", "broad"},
		{"broadcast", "broadcast"},
		{"broadened", "broaden"},
		{"broader", "broader"},
		{"broadly", "broad"},
		{"broadside", "broadsid"},
		{"broadsides", "broadsid"},
		{"broadsword", "broadsword"},
		{"broadwise", "broadwis"},
		{"brocade", "brocad"},
		{"brochure", "brochur"},
		{"brock", "brock"},
		{"brogden", "brogden"},
		{"broide", "broid"},
		{"broiled", "broil"},
		{"broiling", "broil"},
		{"broke", "broke"},
		{"broken", "broken"},
		{"brokenly", "broken"},
		{"broker", "broker"},
		{"brokers", "broker"},
		{"brokken", "brokken"},
		{"bromelia", "bromelia"},
		{"bromley", "bromley"},
		{"brompton", "brompton"},
		{"bronchial", "bronchial"},
		{"bronchitis", "bronchiti"},
		{"bronze", "bronz"},
		{"bronzed", "bronz"},
		{"broo", "broo"},
		{"brooch", "brooch"},
		{"brood", "brood"},
		{"brooded", "brood"},
		{"brooding", "brood"},
		{"broodingly", "brood"},
		{"brook", "brook"},
		{"brooker", "brooker"},
		{"brooks", "brook"},
		{"broom", "broom"},
		{"brooms", "broom"},
		{"broomstick", "broomstick"},
		{"brooses", "broos"},
		{"broth", "broth"},
		{"brother", "brother"},
		{"brotherhood", "brotherhood"},
		{"brotherly", "brother"},
		{"brothers", "brother"},
		{"brougham", "brougham"},
		{"brought", "brought"},
		{"broune", "broun"},
		{"brout", "brout"},
		{"brow", "brow"},
		{"browdie", "browdi"},
		{"browdies", "browdi"},
		{"brown", "brown"},
		{"browndock", "browndock"},
		{"browne", "brown"},
		{"browner", "browner"},
		{"browning", "brown"},
		{"brownish", "brownish"},
		{"browns", "brown"},
		{"brows", "brow"},
		{"browsed", "brows"},
		{"browsing", "brows"},
		{"bruce", "bruce"},
		{"bruise", "bruis"},
		{"bruised", "bruis"},
		{"bruises", "bruis"},
		{"bruising", "bruis"},
		{"brun", "brun"},
		{"brunswick", "brunswick"},
		{"brunt", "brunt"},
		{"brush", "brush"},
		{"brushed", "brush"},
		{"brushes", "brush"},
		{"brushing", "brush"},
		{"brushwood", "brushwood"},
		{"brusque", "brusqu"},
		{"brussels", "brussel"},
		{"brutal", "brutal"},
		{"brutality", "brutal"},
		{"brutally", "brutal"},
		{"brute", "brute"},
		{"brutes", "brute"},
		{"brutish", "brutish"},
		{"bryanstone", "bryanston"},
		{"bu", "bu"},
		{"bubble", "bubbl"},
		{"bubbles", "bubbl"},
		{"bubblin", "bubblin"},
		{"bubbling", "bubbl"},
		{"bucaniers", "bucani"},
		{"buccaneering", "buccan"},
		{"buccaneers", "buccan"},
		{"buch", "buch"},
		{"buck", "buck"},
		{"bucket", "bucket"},
		{"bucketful", "bucket"},
		{"buckets", "bucket"},
		{"buckingham", "buckingham"},
		{"buckland", "buckland"},
		{"buckle", "buckl"},
		{"buckler", "buckler"},
		{"buckles", "buckl"},
		{"buckram", "buckram"},
		{"buckskins", "buckskin"},
		{"bud", "bud"},
		{"budded", "bud"},
		{"budding", "bud"},
		{"budge", "budg"},
		{"budget", "budget"},
		{"budgets", "budget"},
		{"buds", "bud"},
		{"buena", "buena"},
		{"buenos", "bueno"},
		{"buey", "buey"},
		{"buff", "buff"},
		{"buffer", "buffer"},
		{"buffet", "buffet"},
		{"buffeting", "buffet"},
		{"buffetings", "buffet"},
		{"buffets", "buffet"},
		{"buffon", "buffon"},
		{"buffoon", "buffoon"},
		{"buffoonery", "buffooneri"},
		{"buffoons", "buffoon"},
		{"buffy", "buffi"},
		{"bug", "bug"},
		{"bugged", "bug"},
		{"bugle", "bugl"},
		{"bugs", "bug"},
		{"buil", "buil"},
		{"build", "build"},
		{"builder", "builder"},
		{"buildin", "buildin"},
		{"building", "build"},
		{"buildings", "build"},
		{"builds", "build"},
		{"built", "built"},
		{"bulbous", "bulbous"},
		{"bulgaria", "bulgaria"},
		{"bulged", "bulg"},
		{"bulimus", "bulimus"},
		{"bulk", "bulk"},
		{"bulkeley", "bulkeley"},
		{"bulky", "bulki"},
		{"bull", "bull"},
		{"bulldog", "bulldog"},
		{"bullen", "bullen"},
		{"bullet", "bullet"},
		{"bulletin", "bulletin"},
		{"bulletins", "bulletin"},
		{"bullets", "bullet"},
		{"bullfinch", "bullfinch"},
		{"bullied", "bulli"},
		{"bullies", "bulli"},
		{"bullion", "bullion"},
		{"bullock", "bullock"},
		{"bullocks", "bullock"},
		{"bulls", "bull"},
		{"bully", "bulli"},
		{"bullying", "bulli"},
		{"bulph", "bulph"},
		{"bulwarks", "bulwark"},
		{"bump", "bump"},
		{"bumped", "bump"},
		{"bumper", "bumper"},
		{"bumpers", "bumper"},
		{"bumping", "bump"},
		{"bun", "bun"},
		{"bunch", "bunch"},
		{"bunches", "bunch"},
		{"buncombe", "buncomb"},
		{"bundle", "bundl"},
		{"bundled", "bundl"},
		{"bundles", "bundl"},
		{"bung", "bung"},
		{"bungay", "bungay"},
		{"bungays", "bungay"},
		{"bungle", "bungl"},
		{"bungling", "bungl"},
		{"buns", "bun"},
		{"bunting", "bunt"},
		{"buoy", "buoy"},
		{"buoyancy", "buoyanc"},
		{"buoyant", "buoyant"},
		{"buoyantly", "buoyant"},
		{"buoyed", "buoy"},
		{"burchell", "burchel"},
		{"burchess", "burchess"},
		{"burden", "burden"},
		{"burdened", "burden"},
		{"burdening", "burden"},
		{"burdens", "burden"},
		{"burdensome", "burdensom"},
		{"bureau", "bureau"},
		{"burglars", "burglar"},
		{"burgomaster", "burgomast"},
		{"burgomeister", "burgomeist"},
		{"burial", "burial"},
		{"buried", "buri"},
		{"buries", "buri"},
		{"burlesque", "burlesqu"},
		{"burlinghammer", "burlinghamm"},
		{"burly", "bur"},
		{"burn", "burn"},
		{"burned", "burn"},
		{"burnet", "burnet"},
		{"burning", "burn"},
		{"burnings", "burn"},
		{"burnished", "burnish"},
		{"burnous", "burnous"},
		{"burns", "burn"},
		{"burnt", "burnt"},
		{"burrow", "burrow"},
		{"burrowed", "burrow"},
		{"burrowing", "burrow"},
		{"burrowings", "burrow"},
		{"burrows", "burrow"},
		{"burst", "burst"},
		{"bursting", "burst"},
		{"bursts", "burst"},
		{"burthen", "burthen"},
		{"burton", "burton"},
		{"bury", "buri"},
		{"burying", "buri"},
		{"bus", "bus"},
		{"bush", "bush"},
		{"bushby", "bushbi"},
		{"bushe", "bush"},
		{"bushel", "bushel"},
		{"bushels", "bushel"},
		{"bushes", "bush"},
		{"bushy", "bushi"},
		{"busied", "busi"},
		{"busier", "busier"},
		{"busies", "busi"},
		{"busily", "busili"},
		{"business", "busi"},
		{"businesslike", "businesslik"},
		{"buskin", "buskin"},
		{"bust", "bust"},
		{"busted", "bust"},
		{"bustle", "bustl"},
		{"bustled", "bustl"},
		{"bustling", "bustl"},
		{"busts", "bust"},
		{"busy", "busi"},
		{"busybody", "busybodi"},
		{"busying", "busi"},
		{"but", "but"},
		{"butcher", "butcher"},
		{"butchered", "butcher"},
		{"butchers", "butcher"},
		{"butler", "butler"},
		{"buts", "but"},
		{"butt", "butt"},
		{"butter", "butter"},
		{"buttered", "butter"},
		{"butterflies", "butterfli"},
		{"butterfly", "butterfli"},
		{"butterman", "butterman"},
		{"butther", "butther"},
		{"butting", "but"},
		{"button", "button"},
		{"buttoned", "button"},
		{"buttonhole", "buttonhol"},
		{"buttoning", "button"},
		{"buttons", "button"},
		{"buttresses", "buttress"},
		{"butts", "butt"},
		{"buxom", "buxom"},
		{"buy", "buy"},
		{"buyers", "buyer"},
		{"buying", "buy"},
		{"buyings", "buy"},
		{"buys", "buy"},
		{"buzz", "buzz"},
		{"buzzard", "buzzard"},
		{"buzzed", "buzz"},
		{"buzzing", "buzz"},
		{"bwoken", "bwoken"},
		{"by", "by"},
		{"bye", "bye"},
		{"byelinsky", "byelinski"},
		{"bygone", "bygon"},
		{"bygones", "bygon"},
		{"bynoe", "byno"},
		{"byron", "byron"},
		{"bystanders", "bystand"},
		{"byways", "byway"},
		{"byzantine", "byzantin"},
		{"c", "c"},
		{"ca", "ca"},
		{"cab", "cab"},
		{"cabalistic", "cabalist"},
		{"caballed", "cabal"},
		{"cabals", "cabal"},
		{"cabbage", "cabbag"},
		{"cabbages", "cabbag"},
		{"cabbery", "cabberi"},
		{"cabeza", "cabeza"},
		{"cabin", "cabin"},
		{"cabinet", "cabinet"},
		{"cabinets", "cabinet"},
		{"cabins", "cabin"},
		{"cable", "cabl"},
		{"cables", "cabl"},
		{"cabman", "cabman"},
		{"cabooses", "caboos"},
		{"cabriolet", "cabriolet"},
		{"cabriolets", "cabriolet"},
		{"cabs", "cab"},
		{"cachapual", "cachapu"},
		{"cacique", "caciqu"},
		{"caciques", "caciqu"},
		{"cackle", "cackl"},
		{"cackled", "cackl"},
		{"cacti", "cacti"},
		{"cactornis", "cactorni"},
		{"cactus", "cactus"},
		{"cactuses", "cactus"},
		{"cad", "cad"},
		{"cadaverous", "cadaver"},
		{"caddy", "caddi"},
		{"cadesses", "cadess"},
		{"cadet", "cadet"},
		{"cadets", "cadet"},
		{"cadogan", "cadogan"},
		{"cads", "cad"},
		{"caesar", "caesar"},
		{"cafe", "cafe"},
		{"caffer", "caffer"},
		{"caffre", "caffr"},
		{"caffres", "caffr"},
		{"cage", "cage"},
		{"caged", "cage"},
		{"cages", "cage"},
		{"cajoled", "cajol"},
		{"cajoling", "cajol"},
		{"cake", "cake"},
		{"cakes", "cake"},
		{"calabria", "calabria"},
		{"calais", "calai"},
		{"calamities", "calam"},
		{"calamitous", "calamit"},
		{"calamity", "calam"},
		{"calandria", "calandria"},
		{"calcareo", "calcareo"},
		{"calcareous", "calcar"},
		{"calculate", "calcul"},
		{"calculated", "calcul"},
		{"calculates", "calcul"},
		{"calculating", "calcul"},
		{"calculation", "calcul"},
		{"calculations", "calcul"},
		{"calculus", "calculus"},
		{"caldcleugh", "caldcleugh"},
		{"caldeleugh", "caldeleugh"},
		{"caldrons", "caldron"},
		{"caledonia", "caledonia"},
		{"caledonian", "caledonian"},
		{"calendar", "calendar"},
		{"calendars", "calendar"},
		{"calf", "calf"},
		{"calibre", "calibr"},
		{"calico", "calico"},
		{"california", "california"},
		{"call", "call"},
		{"callao", "callao"},
		{"calle", "call"},
		{"called", "call"},
		{"callems", "callem"},
		{"calling", "call"},
		{"callings", "call"},
		{"callous", "callous"},
		{"callousness", "callous"},
		{"calls", "call"},
		{"calm", "calm"},
		{"calmed", "calm"},
		{"calmer", "calmer"},
		{"calmest", "calmest"},
		{"calming", "calm"},
		{"calmly", "calm"},
		{"calmness", "calm"},
		{"calms", "calm"},
		{"caln", "caln"},
		{"calodera", "calodera"},
		{"calomel", "calomel"},
		{"calosoma", "calosoma"},
		{"calumniated", "calumni"},
		{"calumnies", "calumni"},
		{"calumniously", "calumni"},
		{"calumny", "calumni"},
		{"calve", "calv"},
		{"calves", "calv"},
		{"camarhynchus", "camarhynchus"},
		{"camberwell", "camberwel"},
		{"cambric", "cambric"},
		{"cambridge", "cambridg"},
		{"cambridgeshire", "cambridgeshir"},
		{"came", "came"},
		{"camel", "camel"},
		{"camels", "camel"},
		{"camlet", "camlet"},
		{"camp", "camp"},
		{"campaign", "campaign"},
		{"campana", "campana"},
		{"campany", "campani"},
		{"campestris", "campestri"},
		{"camphor", "camphor"},
		{"campo", "campo"},
		{"campos", "campo"},
		{"can", "can"},
		{"canada", "canada"},
		{"canal", "canal"},
		{"canals", "canal"},
		{"canaries", "canari"},
		{"canary", "canari"},
		{"cancan", "cancan"},
		{"cancellaria", "cancellaria"},
		{"cancelled", "cancel"},
		{"cancelling", "cancel"},
		{"cancer", "cancer"},
		{"candid", "candid"},
		{"candidate", "candid"},
		{"candidates", "candid"},
		{"candidateship", "candidateship"},
		{"candidature", "candidatur"},
		{"candidly", "candid"},
		{"candle", "candl"},
		{"candlelight", "candlelight"},
		{"candles", "candl"},
		{"candlestick", "candlestick"},
		{"candlesticks", "candlestick"},
		{"candour", "candour"},
		{"cane", "cane"},
		{"caned", "cane"},
		{"canelones", "canelon"},
		{"canes", "cane"},
		{"cangrejales", "cangrejal"},
		{"canis", "cani"},
		{"canister", "canist"},
		{"cannibal", "cannib"},
		{"cannibalism", "cannib"},
		{"cannibals", "cannib"},
		{"canning", "canning"},
		{"canno", "canno"},
		{"cannon", "cannon"},
		{"cannons", "cannon"},
		{"cannot", "cannot"},
		{"canoe", "cano"},
		{"canoes", "cano"},
		{"canons", "canon"},
		{"canopy", "canopi"},
		{"cant", "cant"},
		{"cantal", "cantal"},
		{"canter", "canter"},
		{"canterbury", "canterburi"},
		{"cantered", "canter"},
		{"canting", "cant"},
		{"cantrip", "cantrip"},
		{"cantrips", "cantrip"},
		{"canvas", "canva"},
		{"canvass", "canvass"},
		{"canvassed", "canvass"},
		{"canvassing", "canvass"},
		{"cap", "cap"},
		{"capabilities", "capabl"},
		{"capability", "capabl"},
		{"capable", "capabl"},
		{"capacious", "capaci"},
		{"capacities", "capac"},
		{"capacity", "capac"},
		{"cape", "cape"},
		{"capella", "capella"},
		{"capers", "caper"},
		{"capita", "capita"},
		{"capital", "capit"},
		{"capitalist", "capitalist"},
		{"capitalists", "capitalist"},
		{"capitally", "capit"},
		{"capitals", "capit"},
		{"capitol", "capitol"},
		{"capitulate", "capitul"},
		{"capped", "cap"},
		{"capping", "cap"},
		{"caprice", "capric"},
		{"caprices", "capric"},
		{"capricious", "caprici"},
		{"capriciously", "caprici"},
		{"capricorn", "capricorn"},
		{"caps", "cap"},
		{"capsicum", "capsicum"},
		{"capstans", "capstan"},
		{"capsule", "capsul"},
		{"capt", "capt"},
		{"captain", "captain"},
		{"captains", "captain"},
		{"captious", "captious"},
		{"captivate", "captiv"},
		{"captivated", "captiv"},
		{"captivater", "captivat"},
		{"captivating", "captiv"},
		{"captivator", "captiv"},
		{"captive", "captiv"},
		{"captives", "captiv"},
		{"captivity", "captiv"},
		{"capture", "captur"},
		{"captured", "captur"},
		{"capybara", "capybara"},
		{"capybaras", "capybara"},
		{"carabidae", "carabida"},
		{"caracara", "caracara"},
		{"caracaras", "caracara"},
		{"caracter", "caract"},
		{"caravan", "caravan"},
		{"caravansary", "caravansari"},
		{"caravanserai", "caravanserai"},
		{"caravels", "caravel"},
		{"carbine", "carbin"},
		{"carbonaceous", "carbonac"},
		{"carbonate", "carbon"},
		{"carboniferous", "carbonifer"},
		{"carboy", "carboy"},
		{"carbury", "carburi"},
		{"carcase", "carcas"},
		{"carcass", "carcass"},
		{"carcasses", "carcass"},
		{"card", "card"},
		{"cardinal", "cardin"},
		{"cardoon", "cardoon"},
		{"cards", "card"},
		{"cardui", "cardui"},
		{"cardunculus", "cardunculus"},
		{"care", "care"},
		{"cared", "care"},
		{"career", "career"},
		{"careers", "career"},
		{"careful", "care"},
		{"carefully", "care"},
		{"carefulness", "care"},
		{"careless", "careless"},
		{"carelessly", "careless"},
		{"carelessness", "careless"},
		{"cares", "care"},
		{"caress", "caress"},
		{"caressed", "caress"},
		{"caresses", "caress"},
		{"caressing", "caress"},
		{"caressingly", "caress"},
		{"careworn", "careworn"},
		{"cargo", "cargo"},
		{"cargoes", "cargo"},
		{"caricature", "caricatur"},
		{"caricatures", "caricatur"},
		{"caring", "care"},
		{"carizal", "cariz"},
		{"carking", "cark"},
		{"carlos", "carlo"},
		{"carlton", "carlton"},
		{"carmen", "carmen"},
		{"carmichael", "carmichael"},
		{"carmine", "carmin"},
		{"carnage", "carnag"},
		{"carnation", "carnat"},
		{"carne", "carn"},
		{"carnegie", "carnegi"},
		{"carnivorous", "carnivor"},
		{"caroline", "carolin"},
		{"carolling", "carol"},
		{"carp", "carp"},
		{"carpacho", "carpacho"},
		{"carpenter", "carpent"},
		{"carpenters", "carpent"},
		{"carpet", "carpet"},
		{"carpeted", "carpet"},
		{"carpeting", "carpet"},
		{"carpetless", "carpetless"},
		{"carpets", "carpet"},
		{"carping", "carp"},
		{"carrancha", "carrancha"},
		{"carranchas", "carrancha"},
		{"carriage", "carriag"},
		{"carriages", "carriag"},
		{"carrie", "carri"},
		{"carried", "carri"},
		{"carrier", "carrier"},
		{"carries", "carri"},
		{"carrion", "carrion"},
		{"carrot", "carrot"},
		{"carrots", "carrot"},
		{"carry", "carri"},
		{"carrying", "carri"},
		{"carse", "cars"},
		{"carstone", "carston"},
		{"cart", "cart"},
		{"carte", "cart"},
		{"cartel", "cartel"},
		{"carthagena", "carthagena"},
		{"cartload", "cartload"},
		{"cartloads", "cartload"},
		{"cartridge", "cartridg"},
		{"cartridges", "cartridg"},
		{"carts", "cart"},
		{"carve", "carv"},
		{"carved", "carv"},
		{"carving", "carv"},
		{"carvings", "carv"},
		{"casara", "casara"},
		{"casarita", "casarita"},
		{"cascade", "cascad"},
		{"cascades", "cascad"},
		{"case", "case"},
		{"casement", "casement"},
		{"casements", "casement"},
		{"cases", "case"},
		{"cash", "cash"},
		{"cashmere", "cashmer"},
		{"cashup", "cashup"},
		{"cask", "cask"},
		{"casket", "casket"},
		{"caskets", "casket"},
		{"casks", "cask"},
		{"casma", "casma"},
		{"caspian", "caspian"},
		{"cassada", "cassada"},
		{"cassio", "cassio"},
		{"cast", "cast"},
		{"castanet", "castanet"},
		{"castaway", "castaway"},
		{"caste", "cast"},
		{"castigate", "castig"},
		{"castigation", "castig"},
		{"casting", "cast"},
		{"castle", "castl"},
		{"castles", "castl"},
		{"castor", "castor"},
		{"castrated", "castrat"},
		{"castro", "castro"},
		{"casts", "cast"},
		{"casual", "casual"},
		{"casually", "casual"},
		{"casualties", "casualti"},
		{"casuarina", "casuarina"},
		{"casucha", "casucha"},
		{"casuchas", "casucha"},
		{"casuistry", "casuistri"},
		{"casuists", "casuist"},
		{"cat", "cat"},
		{"catacomb", "catacomb"},
		{"cataleptic", "catalept"},
		{"catalogue", "catalogu"},
		{"catalogued", "catalogu"},
		{"catalonian", "catalonian"},
		{"catamaran", "catamaran"},
		{"cataract", "cataract"},
		{"cataracts", "cataract"},
		{"catastrophe", "catastroph"},
		{"catastrophes", "catastroph"},
		{"catch", "catch"},
		{"catched", "catch"},
		{"catchers", "catcher"},
		{"catches", "catch"},
		{"catching", "catch"},
		{"catchings", "catch"},
		{"catechism", "catech"},
		{"categories", "categori"},
		{"category", "categori"},
		{"caterpillar", "caterpillar"},
		{"caterpillars", "caterpillar"},
		{"catgut", "catgut"},
		{"cathartes", "cathart"},
		{"cathedral", "cathedr"},
		{"cathedrals", "cathedr"},
		{"catherine", "catherin"},
		{"catholic", "cathol"},
		{"catholics", "cathol"},
		{"cats", "cat"},
		{"cattle", "cattl"},
		{"caucahue", "caucahu"},
		{"caught", "caught"},
		{"cauldron", "cauldron"},
		{"cauliflowers", "cauliflow"},
		{"cauquenes", "cauquen"},
		{"caus", "caus"},
		{"cause", "caus"},
		{"caused", "caus"},
		{"causeless", "causeless"},
		{"causes", "caus"},
		{"causing", "caus"},
		{"caustic", "caustic"},
		{"caution", "caution"},
		{"cautioned", "caution"},
		{"cautioning", "caution"},
		{"cautions", "caution"},
		{"cautious", "cautious"},
		{"cautiously", "cautious"},
		{"cavalry", "cavalri"},
		{"cave", "cave"},
		{"caveat", "caveat"},
		{"cavendish", "cavendish"},
		{"cavern", "cavern"},
		{"cavernous", "cavern"},
		{"caverns", "cavern"},
		{"caves", "cave"},
		{"cavia", "cavia"},
		{"cavies", "cavi"},
		{"cavil", "cavil"},
		{"cavillers", "cavil"},
		{"cavities", "caviti"},
		{"cavity", "caviti"},
		{"cavy", "cavi"},
		{"caw", "caw"},
		{"cawa", "cawa"},
		{"cawing", "caw"},
		{"cayanus", "cayanus"},
		{"cayenne", "cayenn"},
		{"caylen", "caylen"},
		{"cease", "ceas"},
		{"ceased", "ceas"},
		{"ceaseless", "ceaseless"},
		{"ceaselessly", "ceaseless"},
		{"ceases", "ceas"},
		{"ceasing", "ceas"},
		{"cebrionidae", "cebrionida"},
		{"cecilia", "cecilia"},
		{"cedar", "cedar"},
		{"cedars", "cedar"},
		{"ceedingly", "ceed"},
		{"ceiling", "ceil"},
		{"ceilings", "ceil"},
		{"ceillhg", "ceillhg"},
		{"cel", "cel"},
		{"celebes", "celeb"},
		{"celebrate", "celebr"},
		{"celebrated", "celebr"},
		{"celebration", "celebr"},
		{"celebrity", "celebr"},
		{"celery", "celeri"},
		{"celestial", "celesti"},
		{"cell", "cell"},
		{"cellar", "cellar"},
		{"cellarage", "cellarag"},
		{"cellaria", "cellaria"},
		{"cellars", "cellar"},
		{"cells", "cell"},
		{"cellular", "cellular"},
		{"cement", "cement"},
		{"cemented", "cement"},
		{"cementing", "cement"},
		{"cemetery", "cemeteri"},
		{"cenotherae", "cenothera"},
		{"censorious", "censori"},
		{"censorship", "censorship"},
		{"censure", "censur"},
		{"censured", "censur"},
		{"censures", "censur"},
		{"censuring", "censur"},
		{"census", "census"},
		{"cent", "cent"},
		{"centaurs", "centaur"},
		{"centered", "center"},
		{"centra", "centra"},
		{"central", "central"},
		{"centre", "centr"},
		{"centred", "centr"},
		{"centres", "centr"},
		{"centrifugal", "centrifug"},
		{"centring", "centr"},
		{"cents", "cent"},
		{"centuries", "centuri"},
		{"century", "centuri"},
		{"cependent", "cepend"},
		{"cephalopoda", "cephalopoda"},
		{"cereal", "cereal"},
		{"ceremonial", "ceremoni"},
		{"ceremonies", "ceremoni"},
		{"ceremonious", "ceremoni"},
		{"ceremoniously", "ceremoni"},
		{"ceremony", "ceremoni"},
		{"cerro", "cerro"},
		{"certain", "certain"},
		{"certainl", "certainl"},
		{"certainly", "certain"},
		{"certainties", "certainti"},
		{"certainty", "certainti"},
		{"certhia", "certhia"},
		{"certhidea", "certhidea"},
		{"certificate", "certif"},
		{"certificates", "certif"},
		{"certified", "certifi"},
		{"certifiket", "certifiket"},
		{"certify", "certifi"},
		{"certifying", "certifi"},
		{"cervicem", "cervicem"},
		{"cervus", "cervus"},
		{"ceryle", "ceryl"},
		{"ces", "ces"},
		{"cesenate", "cesen"},
		{"cessation", "cessat"},
		{"cesspool", "cesspool"},
		{"cesspools", "cesspool"},
		{"cetaceous", "cetac"},
		{"cetera", "cetera"},
		{"ceteras", "cetera"},
		{"cetrer", "cetrer"},
		{"chacao", "chacao"},
		{"chacun", "chacun"},
		{"chadband", "chadband"},
		{"chadbands", "chadband"},
		{"chafe", "chafe"},
		{"chafed", "chafe"},
		{"chafes", "chafe"},
		{"chaff", "chaff"},
		{"chaffers", "chaffer"},
		{"chaffinch", "chaffinch"},
		{"chafing", "chafe"},
		{"chagos", "chago"},
		{"chagrin", "chagrin"},
		{"chai", "chai"},
		{"chain", "chain"},
		{"chained", "chain"},
		{"chains", "chain"},
		{"chair", "chair"},
		{"chairing", "chair"},
		{"chairman", "chairman"},
		{"chairs", "chair"},
		{"chaise", "chais"},
		{"chalk", "chalk"},
		{"chalked", "chalk"},
		{"chalking", "chalk"},
		{"challenge", "challeng"},
		{"challenged", "challeng"},
		{"challenger", "challeng"},
		{"challenging", "challeng"},
		{"chalr", "chalr"},
		{"chama", "chama"},
		{"chamber", "chamber"},
		{"chamberlain", "chamberlain"},
		{"chambers", "chamber"},
		{"chambre", "chambr"},
		{"chameleon", "chameleon"},
		{"chamisso", "chamisso"},
		{"chamois", "chamoi"},
		{"champagne", "champagn"},
		{"champion", "champion"},
		{"champions", "champion"},
		{"chance", "chanc"},
		{"chanced", "chanc"},
		{"chancellor", "chancellor"},
		{"chancellors", "chancellor"},
		{"chancelor", "chancelor"},
		{"chancery", "chanceri"},
		{"chances", "chanc"},
		{"chancing", "chanc"},
		{"chandelier", "chandeli"},
		{"chandeliers", "chandeli"},
		{"chandler", "chandler"},
		{"chaneral", "chaner"},
		{"change", "chang"},
		{"changeable", "changeabl"},
		{"changed", "chang"},
		{"changeling", "changel"},
		{"changes", "chang"},
		{"changing", "chang"},
		{"channel", "channel"},
		{"channels", "channel"},
		{"chantant", "chantant"},
		{"chanted", "chant"},
		{"chanting", "chant"},
		{"chants", "chant"},
		{"chanuncillo", "chanuncillo"},
		{"chaos", "chao"},
		{"chaotic", "chaotic"},
		{"chap", "chap"},
		{"chapel", "chapel"},
		{"chapels", "chapel"},
		{"chaperon", "chaperon"},
		{"chaperone", "chaperon"},
		{"chaperons", "chaperon"},
		{"chaplain", "chaplain"},
		{"chaps", "chap"},
		{"chapter", "chapter"},
		{"chapters", "chapter"},
		{"chaquaio", "chaquaio"},
		{"character", "charact"},
		{"characteristic", "characterist"},
		{"characteristically", "characterist"},
		{"characteristics", "characterist"},
		{"characterize", "character"},
		{"characterized", "character"},
		{"characterizes", "character"},
		{"characterizing", "character"},
		{"characters", "charact"},
		{"charade", "charad"},
		{"charcoal", "charcoal"},
		{"charcoaled", "charcoal"},
		{"charge", "charg"},
		{"chargeable", "chargeabl"},
		{"charged", "charg"},
		{"chargers", "charger"},
		{"charges", "charg"},
		{"charging", "charg"},
		{"chariey", "chariey"},
		{"charing", "chare"},
		{"chariot", "chariot"},
		{"chariots", "chariot"},
		{"charitable", "charit"},
		{"charitably", "charit"},
		{"charities", "chariti"},
		{"charity", "chariti"},
		{"charlatanism", "charlatan"},
		{"charles", "charl"},
		{"charley", "charley"},
		{"charlie", "charli"},
		{"charlotte", "charlott"},
		{"charm", "charm"},
		{"charmed", "charm"},
		{"charmer", "charmer"},
		{"charmers", "charmer"},
		{"charming", "charm"},
		{"charmingly", "charm"},
		{"charms", "charm"},
		{"charnel", "charnel"},
		{"charon", "charon"},
		{"charqui", "charqui"},
		{"charred", "char"},
		{"chart", "chart"},
		{"chartered", "charter"},
		{"chartism", "chartism"},
		{"chartist", "chartist"},
		{"charts", "chart"},
		{"charwoman", "charwoman"},
		{"chary", "chari"},
		{"chase", "chase"},
		{"chased", "chase"},
		{"chases", "chase"},
		{"chasing", "chase"},
		{"chasm", "chasm"},
		{"chasms", "chasm"},
		{"chaste", "chast"},
		{"chastened", "chasten"},
		{"chastening", "chasten"},
		{"chastise", "chastis"},
		{"chastisement", "chastis"},
		{"chastity", "chastiti"},
		{"chat", "chat"},
		{"chateau", "chateau"},
		{"chatham", "chatham"},
		{"chatted", "chat"},
		{"chattels", "chattel"},
		{"chatter", "chatter"},
		{"chatterbox", "chatterbox"},
		{"chattered", "chatter"},
		{"chatterer", "chatter"},
		{"chattering", "chatter"},
		{"chatters", "chatter"},
		{"chatting", "chat"},
		{"chatty", "chatti"},
		{"chaunt", "chaunt"},
		{"cheap", "cheap"},
		{"cheaper", "cheaper"},
		{"cheapest", "cheapest"},
		{"cheaply", "cheapli"},
		{"cheapside", "cheapsid"},
		{"cheat", "cheat"},
		{"cheated", "cheat"},
		{"cheating", "cheat"},
		{"cheats", "cheat"},
		{"chec", "chec"},
		{"check", "check"},
		{"checked", "check"},
		{"checking", "check"},
		{"checks", "check"},
		{"cheek", "cheek"},
		{"cheeked", "cheek"},
		{"cheeks", "cheek"},
		{"cheer", "cheer"},
		{"cheered", "cheer"},
		{"cheerful", "cheer"},
		{"cheerfully", "cheer"},
		{"cheerfulness", "cheer"},
		{"cheerily", "cheerili"},
		{"cheeriness", "cheeri"},
		{"cheering", "cheer"},
		{"cheerless", "cheerless"},
		{"cheers", "cheer"},
		{"cheery", "cheeri"},
		{"cheeryble", "cheerybl"},
		{"cheerybles", "cheerybl"},
		{"cheese", "chees"},
		{"cheeseming", "cheesem"},
		{"chefs", "chef"},
		{"chelsea", "chelsea"},
		{"cheltenham", "cheltenham"},
		{"chem", "chem"},
		{"chemical", "chemic"},
		{"chemins", "chemin"},
		{"chemise", "chemis"},
		{"chemist", "chemist"},
		{"chemistry", "chemistri"},
		{"chemists", "chemist"},
		{"chenille", "chenill"},
		{"chepones", "chepon"},
		{"cheque", "chequ"},
		{"chequered", "chequer"},
		{"cheques", "chequ"},
		{"cher", "cher"},
		{"chere", "chere"},
		{"cherish", "cherish"},
		{"cherished", "cherish"},
		{"cherishes", "cherish"},
		{"cherishing", "cherish"},
		{"cherizette", "cherizett"},
		{"cherries", "cherri"},
		{"cherry", "cherri"},
		{"cherryble", "cherrybl"},
		{"cherrybles", "cherrybl"},
		{"cherty", "cherti"},
		{"cherubim", "cherubim"},
		{"cheshires", "cheshir"},
		{"chesney", "chesney"},
		{"chess", "chess"},
		{"chest", "chest"},
		{"chested", "chest"},
		{"chesterfield", "chesterfield"},
		{"chestnut", "chestnut"},
		{"chestnuts", "chestnut"},
		{"chests", "chest"},
		{"cheucau", "cheucau"},
		{"cheval", "cheval"},
		{"chevaux", "chevaux"},
		{"chevy", "chevi"},
		{"chew", "chew"},
		{"chewed", "chew"},
		{"chewing", "chew"},
		{"chichester", "chichest"},
		{"chichi", "chichi"},
		{"chick", "chick"},
		{"chicken", "chicken"},
		{"chickens", "chicken"},
		{"chiduco", "chiduco"},
		{"chief", "chief"},
		{"chiefest", "chiefest"},
		{"chiefly", "chiefli"},
		{"chiefs", "chief"},
		{"chiel", "chiel"},
		{"chiens", "chien"},
		{"child", "child"},
		{"childhood", "childhood"},
		{"childish", "childish"},
		{"childishly", "childish"},
		{"childishness", "childish"},
		{"childless", "childless"},
		{"childlike", "childlik"},
		{"children", "children"},
		{"chile", "chile"},
		{"chilean", "chilean"},
		{"chileno", "chileno"},
		{"chilenos", "chileno"},
		{"chilian", "chilian"},
		{"chilicauquen", "chilicauquen"},
		{"chilipa", "chilipa"},
		{"chill", "chill"},
		{"chilled", "chill"},
		{"chilling", "chill"},
		{"chills", "chill"},
		{"chilly", "chilli"},
		{"chiloe", "chilo"},
		{"chilotan", "chilotan"},
		{"chilotans", "chilotan"},
		{"chiltern", "chiltern"},
		{"chimango", "chimango"},
		{"chimbley", "chimbley"},
		{"chimborazo", "chimborazo"},
		{"chimes", "chime"},
		{"chimie", "chimi"},
		{"chimney", "chimney"},
		{"chimneypiece", "chimneypiec"},
		{"chimneys", "chimney"},
		{"chin", "chin"},
		{"china", "china"},
		{"chinas", "china"},
		{"chinchilloides", "chinchilloid"},
		{"chinese", "chines"},
		{"chink", "chink"},
		{"chinking", "chink"},
		{"chinks", "chink"},
		{"chins", "chin"},
		{"chintz", "chintz"},
		{"chionis", "chioni"},
		{"chip", "chip"},
		{"chipping", "chip"},
		{"chirp", "chirp"},
		{"chirped", "chirp"},
		{"chirping", "chirp"},
		{"chirps", "chirp"},
		{"chirrup", "chirrup"},
		{"chirruped", "chirrup"},
		{"chirruping", "chirrup"},
		{"chisel", "chisel"},
		{"chiselled", "chisel"},
		{"chit", "chit"},
		{"chitons", "chiton"},
		{"chivalrous", "chivalr"},
		{"chivalrously", "chivalr"},
		{"chivalry", "chivalri"},
		{"chivied", "chivi"},
		{"chivying", "chivi"},
		{"chizzle", "chizzl"},
		{"chlorides", "chlorid"},
		{"chock", "chock"},
		{"chocolate", "chocol"},
		{"choice", "choic"},
		{"choiceness", "choic"},
		{"choicest", "choicest"},
		{"choir", "choir"},
		{"choiseul", "choiseul"},
		{"choke", "choke"},
		{"choked", "choke"},
		{"chokes", "choke"},
		{"choking", "choke"},
		{"cholechel", "cholechel"},
		{"cholera", "cholera"},
		{"chonchi", "chonchi"},
		{"chonos", "chono"},
		{"choose", "choos"},
		{"chooses", "choos"},
		{"choosing", "choos"},
		{"chop", "chop"},
		{"chopkins", "chopkin"},
		{"chopped", "chop"},
		{"chopping", "chop"},
		{"chops", "chop"},
		{"chord", "chord"},
		{"chords", "chord"},
		{"choristers", "chorist"},
		{"chorus", "chorus"},
		{"choruses", "chorus"},
		{"chose", "chose"},
		{"chosen", "chosen"},
		{"chowser", "chowser"},
		{"christ", "christ"},
		{"christabel", "christabel"},
		{"christen", "christen"},
		{"christendom", "christendom"},
		{"christened", "christen"},
		{"christening", "christen"},
		{"christi", "christi"},
		{"christian", "christian"},
		{"christianity", "christian"},
		{"christians", "christian"},
		{"christmas", "christma"},
		{"christopher", "christoph"},
		{"chronic", "chronic"},
		{"chronicle", "chronicl"},
		{"chronicled", "chronicl"},
		{"chroniclers", "chronicl"},
		{"chronicles", "chronicl"},
		{"chronometrical", "chronometr"},
		{"chrysalis", "chrysali"},
		{"chrysomelidae", "chrysomelida"},
		{"chrysopa", "chrysopa"},
		{"chubby", "chubbi"},
		{"chuck", "chuck"},
		{"chucked", "chuck"},
		{"chuckle", "chuckl"},
		{"chuckled", "chuckl"},
		{"chuckling", "chuckl"},
		{"chunk", "chunk"},
		{"chunks", "chunk"},
		{"chupat", "chupat"},
		{"church", "church"},
		{"churches", "church"},
		{"churchgoing", "churchgo"},
		{"churchyard", "churchyard"},
		{"churchyards", "churchyard"},
		{"churlishness", "churlish"},
		{"churls", "churl"},
		{"churned", "churn"},
		{"churning", "churn"},
		{"chut", "chut"},
		{"chuzo", "chuzo"},
		{"chuzos", "chuzo"},
		{"chy", "chi"},
		{"cicadae", "cicada"},
		{"cicadas", "cicada"},
		{"cicidae", "cicida"},
		{"cider", "cider"},
		{"cigar", "cigar"},
		{"cigarette", "cigarett"},
		{"cigarettes", "cigarett"},
		{"cigaritos", "cigarito"},
		{"cigars", "cigar"},
		{"ciliae", "cilia"},
		{"cimabue", "cimabu"},
		{"cincindela", "cincindela"},
		{"cincinnatus", "cincinnatus"},
		{"cincinnatuses", "cincinnatus"},
		{"cinder", "cinder"},
		{"cinderella", "cinderella"},
		{"cinders", "cinder"},
		{"cindery", "cinderi"},
		{"cinereus", "cinereus"},
		{"cinnamon", "cinnamon"},
		{"cinq", "cinq"},
		{"ciphering", "cipher"},
		{"cir", "cir"},
		{"circle", "circl"},
		{"circles", "circl"},
		{"circling", "circl"},
		{"circuit", "circuit"},
		{"circuitous", "circuit"},
		{"circuits", "circuit"},
		{"circular", "circular"},
		{"circulars", "circular"},
		{"circulated", "circul"},
		{"circulates", "circul"},
		{"circulating", "circul"},
		{"circulation", "circul"},
		{"circumambient", "circumambi"},
		{"circumference", "circumfer"},
		{"circumjacent", "circumjac"},
		{"circumlocution", "circumlocut"},
		{"circumnavigate", "circumnavig"},
		{"circumnavigation", "circumnavig"},
		{"circumscribed", "circumscrib"},
		{"circumspect", "circumspect"},
		{"circumstance", "circumst"},
		{"circumstanced", "circumstanc"},
		{"circumstances", "circumst"},
		{"circumstantial", "circumstanti"},
		{"circumstantially", "circumstanti"},
		{"circus", "circus"},
		{"cistern", "cistern"},
		{"cisterns", "cistern"},
		{"citadel", "citadel"},
		{"citation", "citat"},
		{"cite", "cite"},
		{"cited", "cite"},
		{"cities", "citi"},
		{"citigrade", "citigrad"},
		{"citizen", "citizen"},
		{"citizens", "citizen"},
		{"city", "citi"},
		{"cive", "cive"},
		{"civil", "civil"},
		{"civilian", "civilian"},
		{"civilians", "civilian"},
		{"civilised", "civilis"},
		{"civilities", "civil"},
		{"civility", "civil"},
		{"civilization", "civil"},
		{"civilized", "civil"},
		{"civilly", "civilli"},
		{"clad", "clad"},
		{"cladonia", "cladonia"},
		{"claim", "claim"},
		{"claimant", "claimant"},
		{"claimed", "claim"},
		{"claiming", "claim"},
		{"claims", "claim"},
		{"clairvoyante", "clairvoyant"},
		{"clambered", "clamber"},
		{"clamorous", "clamor"},
		{"clamour", "clamour"},
		{"clamouring", "clamour"},
		{"clandestinely", "clandestin"},
		{"clang", "clang"},
		{"clanging", "clang"},
		{"clangour", "clangour"},
		{"clank", "clank"},
		{"clanking", "clank"},
		{"clanks", "clank"},
		{"clap", "clap"},
		{"clapped", "clap"},
		{"clapping", "clap"},
		{"clappings", "clap"},
		{"claps", "clap"},
		{"clara", "clara"},
		{"clare", "clare"},
		{"claret", "claret"},
		{"clarionet", "clarionet"},
		{"clark", "clark"},
		{"clarke", "clark"},
		{"clash", "clash"},
		{"clashed", "clash"},
		{"clashes", "clash"},
		{"clashing", "clash"},
		{"clasp", "clasp"},
		{"clasped", "clasp"},
		{"clasping", "clasp"},
		{"claspknife", "claspknif"},
		{"clasps", "clasp"},
		{"class", "class"},
		{"classed", "class"},
		{"classes", "class"},
		{"classic", "classic"},
		{"classical", "classic"},
		{"classicality", "classic"},
		{"classify", "classifi"},
		{"clatter", "clatter"},
		{"clattered", "clatter"},
		{"clattering", "clatter"},
		{"clause", "claus"},
		{"clausen", "clausen"},
		{"clauses", "claus"},
		{"clavipes", "clavip"},
		{"claw", "claw"},
		{"clawing", "claw"},
		{"claws", "claw"},
		{"clay", "clay"},
		{"clayey", "clayey"},
		{"claying", "clay"},
		{"clayver", "clayver"},
		{"clean", "clean"},
		{"cleaned", "clean"},
		{"cleaner", "cleaner"},
		{"cleanest", "cleanest"},
		{"cleaning", "clean"},
		{"cleanliest", "cleanliest"},
		{"cleanliness", "cleanli"},
		{"cleanly", "clean"},
		{"cleans", "clean"},
		{"cleanse", "cleans"},
		{"cleanses", "cleans"},
		{"cleansing", "cleans"},
		{"clear", "clear"},
		{"clearance", "clearanc"},
		{"cleared", "clear"},
		{"clearer", "clearer"},
		{"clearest", "clearest"},
		{"clearing", "clear"},
		{"clearly", "clear"},
		{"clearness", "clear"},
		{"cleavage", "cleavag"},
		{"cleft", "cleft"},
		{"clefts", "cleft"},
		{"clematis", "clemati"},
		{"clemency", "clemenc"},
		{"clench", "clench"},
		{"clenched", "clench"},
		{"clenches", "clench"},
		{"clenching", "clench"},
		{"cleopatra", "cleopatra"},
		{"clergyman", "clergyman"},
		{"clergymen", "clergymen"},
		{"clerical", "cleric"},
		{"clerk", "clerk"},
		{"clerkenwell", "clerkenwel"},
		{"clerkly", "clerk"},
		{"clerks", "clerk"},
		{"clerkship", "clerkship"},
		{"cleveland", "cleveland"},
		{"clever", "clever"},
		{"cleverer", "clever"},
		{"cleverest", "cleverest"},
		{"cleverly", "clever"},
		{"cleverness", "clever"},
		{"click", "click"},
		{"clicked", "click"},
		{"clicking", "click"},
		{"client", "client"},
		{"clients", "client"},
		{"cliff", "cliff"},
		{"clifford", "clifford"},
		{"cliffs", "cliff"},
		{"clifton", "clifton"},
		{"clima", "clima"},
		{"climate", "climat"},
		{"climates", "climat"},
		{"climax", "climax"},
		{"climb", "climb"},
		{"climbed", "climb"},
		{"climbers", "climber"},
		{"climbing", "climb"},
		{"clime", "clime"},
		{"climes", "clime"},
		{"clinched", "clinch"},
		{"cling", "cling"},
		{"clinging", "cling"},
		{"clings", "cling"},
		{"clink", "clink"},
		{"clinked", "clink"},
		{"clinking", "clink"},
		{"clip", "clip"},
		{"clipped", "clip"},
		{"clippers", "clipper"},
		{"clipping", "clip"},
		{"cliquot", "cliquot"},
		{"clks", "clks"},
		{"cloak", "cloak"},
		{"cloaks", "cloak"},
		{"clock", "clock"},
		{"clocks", "clock"},
		{"clods", "clod"},
		{"cloe", "cloe"},
		{"clogged", "clog"},
		{"cloister", "cloister"},
		{"cloistered", "cloister"},
		{"cloisterly", "cloister"},
		{"cloisters", "cloister"},
		{"close", "close"},
		{"closed", "close"},
		{"closely", "close"},
		{"closeness", "close"},
		{"closer", "closer"},
		{"closes", "close"},
		{"closest", "closest"},
		{"closet", "closet"},
		{"closeted", "closet"},
		{"closets", "closet"},
		{"closing", "close"},
		{"cloth", "cloth"},
		{"clothe", "cloth"},
		{"clothed", "cloth"},
		{"clother", "clother"},
		{"clothes", "cloth"},
		{"clothing", "cloth"},
		{"cloths", "cloth"},
		{"clotted", "clot"},
		{"cloud", "cloud"},
		{"clouded", "cloud"},
		{"cloudily", "cloudili"},
		{"cloudless", "cloudless"},
		{"clouds", "cloud"},
		{"cloudy", "cloudi"},
		{"clout", "clout"},
		{"clove", "clove"},
		{"clover", "clover"},
		{"cloves", "clove"},
		{"clown", "clown"},
		{"clt", "clt"},
		{"club", "club"},
		{"clubs", "club"},
		{"cluck", "cluck"},
		{"clue", "clue"},
		{"clump", "clump"},
		{"clumps", "clump"},
		{"clumsily", "clumsili"},
		{"clumsiness", "clumsi"},
		{"clumsy", "clumsi"},
		{"clung", "clung"},
		{"cluskie", "cluski"},
		{"cluster", "cluster"},
		{"clustered", "cluster"},
		{"clustering", "cluster"},
		{"clusters", "cluster"},
		{"clutch", "clutch"},
		{"clutched", "clutch"},
		{"clutches", "clutch"},
		{"clutching", "clutch"},
		{"clytia", "clytia"},
		{"co", "co"},
		{"coach", "coach"},
		{"coaches", "coach"},
		{"coaching", "coach"},
		{"coachmaker", "coachmak"},
		{"coachman", "coachman"},
		{"coachmen", "coachmen"},
		{"coachyard", "coachyard"},
		{"coadjutor", "coadjutor"},
		{"coal", "coal"},
		{"coalesced", "coalesc"},
		{"coalescing", "coalesc"},
		{"coalition", "coalit"},
		{"coalitions", "coalit"},
		{"coals", "coal"},
		{"coalworth", "coalworth"},
		{"coarse", "coars"},
		{"coarsely", "coars"},
		{"coarsened", "coarsen"},
		{"coarseness", "coars"},
		{"coarser", "coarser"},
		{"coarsest", "coarsest"},
		{"coast", "coast"},
		{"coasts", "coast"},
		{"coat", "coat"},
		{"coated", "coat"},
		{"coating", "coat"},
		{"coatings", "coat"},
		{"coats", "coat"},
		{"coavins", "coavin"},
		{"coavinses", "coavins"},
		{"coaxed", "coax"},
		{"coaxin", "coaxin"},
		{"coaxing", "coax"},
		{"coaxingly", "coax"},
		{"cob", "cob"},
		{"cobbey", "cobbey"},
		{"cobbler", "cobbler"},
		{"cobblesborough", "cobblesborough"},
		{"coburg", "coburg"},
		{"cobweb", "cobweb"},
		{"cobwebs", "cobweb"},
		{"cochlogena", "cochlogena"},
		{"cochrane", "cochran"},
		{"cock", "cock"},
		{"cockaded", "cockad"},
		{"cockades", "cockad"},
		{"cockatoo", "cockatoo"},
		{"cocked", "cock"},
		{"cocking", "cock"},
		{"cockney", "cockney"},
		{"cockroaches", "cockroach"},
		{"coco", "coco"},
		{"cocoa", "cocoa"},
		{"cocoon", "cocoon"},
		{"cocos", "coco"},
		{"cod", "cod"},
		{"coddle", "coddl"},
		{"coddled", "coddl"},
		{"coddling", "coddl"},
		{"code", "code"},
		{"codes", "code"},
		{"codger", "codger"},
		{"codicil", "codicil"},
		{"codified", "codifi"},
		{"codlings", "codl"},
		{"coelum", "coelum"},
		{"coerced", "coerc"},
		{"coercive", "coerciv"},
		{"coeur", "coeur"},
		{"coeval", "coeval"},
		{"coextensive", "coextens"},
		{"coffee", "coffe"},
		{"coffeehouse", "coffeehous"},
		{"coffers", "coffer"},
		{"coffin", "coffin"},
		{"coffins", "coffin"},
		{"cogitated", "cogit"},
		{"cogitating", "cogit"},
		{"cogitation", "cogit"},
		{"cogitations", "cogit"},
		{"cognate", "cognat"},
		{"cognisant", "cognis"},
		{"cognizant", "cogniz"},
		{"cognovits", "cognovit"},
		{"cogs", "cog"},
		{"coherence", "coher"},
		{"coherent", "coher"},
		{"cohesion", "cohes"},
		{"coil", "coil"},
		{"coiled", "coil"},
		{"coils", "coil"},
		{"coin", "coin"},
		{"coinage", "coinag"},
		{"coincide", "coincid"},
		{"coincided", "coincid"},
		{"coincidence", "coincid"},
		{"coincidences", "coincid"},
		{"coincides", "coincid"},
		{"coiner", "coiner"},
		{"coiners", "coiner"},
		{"coining", "coin"},
		{"coins", "coin"},
		{"coinstantaneous", "coinstantan"},
		{"coinstantaneously", "coinstantan"},
		{"coke", "coke"},
		{"cold", "cold"},
		{"colder", "colder"},
		{"coldest", "coldest"},
		{"coldly", "cold"},
		{"coldness", "cold"},
		{"coldnesses", "cold"},
		{"colds", "cold"},
		{"coleman", "coleman"},
		{"coleoptera", "coleoptera"},
		{"coleridge", "coleridg"},
		{"colias", "colia"},
		{"colla", "colla"},
		{"collapse", "collaps"},
		{"collapsed", "collaps"},
		{"collapses", "collaps"},
		{"collar", "collar"},
		{"collars", "collar"},
		{"collateral", "collater"},
		{"collation", "collat"},
		{"colleague", "colleagu"},
		{"colleagues", "colleagu"},
		{"collect", "collect"},
		{"collected", "collect"},
		{"collectedly", "collect"},
		{"collecting", "collect"},
		{"collection", "collect"},
		{"collections", "collect"},
		{"collectively", "collect"},
		{"collector", "collector"},
		{"collectors", "collector"},
		{"collects", "collect"},
		{"college", "colleg"},
		{"collier", "collier"},
		{"collieries", "collieri"},
		{"colliers", "collier"},
		{"colliery", "collieri"},
		{"collision", "collis"},
		{"collnet", "collnet"},
		{"collnett", "collnett"},
		{"colloquial", "colloqui"},
		{"colloquially", "colloqui"},
		{"colloquy", "colloquy"},
		{"colman", "colman"},
		{"colnett", "colnett"},
		{"cologne", "cologn"},
		{"colonel", "colonel"},
		{"colonia", "colonia"},
		{"colonies", "coloni"},
		{"colonist", "colonist"},
		{"colonists", "colonist"},
		{"colonize", "colon"},
		{"colonized", "colon"},
		{"colonnade", "colonnad"},
		{"colonnades", "colonnad"},
		{"colony", "coloni"},
		{"color", "color"},
		{"colorado", "colorado"},
		{"colored", "color"},
		{"colossal", "coloss"},
		{"colour", "colour"},
		{"coloured", "colour"},
		{"colouring", "colour"},
		{"colourless", "colourless"},
		{"colours", "colour"},
		{"colt", "colt"},
		{"colts", "colt"},
		{"columbus", "columbus"},
		{"column", "column"},
		{"columnar", "columnar"},
		{"columns", "column"},
		{"colymbetes", "colymbet"},
		{"com", "com"},
		{"comb", "comb"},
		{"combat", "combat"},
		{"combatants", "combat"},
		{"combative", "combat"},
		{"combativeness", "combat"},
		{"combats", "combat"},
		{"combatted", "combat"},
		{"combed", "comb"},
		{"combination", "combin"},
		{"combinations", "combin"},
		{"combine", "combin"},
		{"combined", "combin"},
		{"combines", "combin"},
		{"combing", "comb"},
		{"combining", "combin"},
		{"combs", "comb"},
		{"combusted", "combust"},
		{"combusting", "combust"},
		{"combustion", "combust"},
		{"come", "come"},
		{"comedies", "comedi"},
		{"comedy", "comedi"},
		{"comeliness", "comeli"},
		{"comely", "come"},
		{"comer", "comer"},
		{"comers", "comer"},
		{"comes", "come"},
		{"comestibles", "comest"},
		{"cometh", "cometh"},
		{"comfort", "comfort"},
		{"comfortable", "comfort"},
		{"comfortabler", "comfortabl"},
		{"comfortablest", "comfortablest"},
		{"comfortably", "comfort"},
		{"comforted", "comfort"},
		{"comforter", "comfort"},
		{"comforters", "comfort"},
		{"comforting", "comfort"},
		{"comfortingly", "comfort"},
		{"comfortless", "comfortless"},
		{"comforts", "comfort"},
		{"comic", "comic"},
		{"comical", "comic"},
		{"comicality", "comic"},
		{"comin", "comin"},
		{"coming", "come"},
		{"comings", "come"},
		{"command", "command"},
		{"commandant", "command"},
		{"commanded", "command"},
		{"commander", "command"},
		{"commanding", "command"},
		{"commands", "command"},
		{"comme", "comm"},
		{"commemorate", "commemor"},
		{"commemorated", "commemor"},
		{"commemoration", "commemor"},
		{"commemorative", "commemor"},
		{"commence", "commenc"},
		{"commenced", "commenc"},
		{"commencement", "commenc"},
		{"commencements", "commenc"},
		{"commences", "commenc"},
		{"commencing", "commenc"},
		{"commend", "commend"},
		{"commendable", "commend"},
		{"commendation", "commend"},
		{"commendations", "commend"},
		{"commended", "commend"},
		{"commending", "commend"},
		{"commendingly", "commend"},
		{"commends", "commend"},
		{"comment", "comment"},
		{"commentary", "commentari"},
		{"commented", "comment"},
		{"commenting", "comment"},
		{"comments", "comment"},
		{"commerce", "commerc"},
		{"commercial", "commerci"},
		{"commiserating", "commiser"},
		{"commiseration", "commiser"},
		{"commissariat", "commissariat"},
		{"commission", "commiss"},
		{"commissioned", "commiss"},
		{"commissioner", "commission"},
		{"commissioners", "commission"},
		{"commissions", "commiss"},
		{"commit", "commit"},
		{"commits", "commit"},
		{"committed", "commit"},
		{"committee", "committe"},
		{"committees", "committe"},
		{"committing", "commit"},
		{"commixta", "commixta"},
		{"commo", "commo"},
		{"commodious", "commodi"},
		{"commodities", "commod"},
		{"commodity", "commod"},
		{"commodore", "commodor"},
		{"common", "common"},
		{"commoner", "common"},
		{"commoners", "common"},
		{"commonest", "commonest"},
		{"commonl", "commonl"},
		{"commonly", "common"},
		{"commonplace", "commonplac"},
		{"commonplaces", "commonplac"},
		{"commons", "common"},
		{"commonwealth", "commonwealth"},
		{"commotion", "commot"},
		{"commotions", "commot"},
		{"commttted", "commtt"},
		{"commune", "commune"},
		{"communicant", "communic"},
		{"communicate", "communic"},
		{"communicated", "communic"},
		{"communicates", "communic"},
		{"communicating", "communic"},
		{"communication", "communic"},
		{"communications", "communic"},
		{"communicative", "communic"},
		{"communing", "commune"},
		{"communion", "communion"},
		{"communism", "communism"},
		{"communities", "communiti"},
		{"community", "communiti"},
		{"commuted", "commut"},
		{"commuuity", "commuuiti"},
		{"como", "como"},
		{"compact", "compact"},
		{"compactness", "compact"},
		{"compacts", "compact"},
		{"companies", "compani"},
		{"companion", "companion"},
		{"companions", "companion"},
		{"companionship", "companionship"},
		{"company", "compani"},
		{"comparable", "compar"},
		{"comparative", "compar"},
		{"comparatively", "compar"},
		{"compare", "compar"},
		{"compared", "compar"},
		{"compares", "compar"},
		{"comparing", "compar"},
		{"comparison", "comparison"},
		{"comparisons", "comparison"},
		{"compartments", "compart"},
		{"compass", "compass"},
		{"compassion", "compass"},
		{"compassionate", "compassion"},
		{"compassionated", "compassion"},
		{"compassionately", "compassion"},
		{"compassionating", "compassion"},
		{"compatible", "compat"},
		{"compatriots", "compatriot"},
		{"compel", "compel"},
		{"compelled", "compel"},
		{"compelling", "compel"},
		{"compels", "compel"},
		{"compensate", "compens"},
		{"compensated", "compens"},
		{"compensating", "compens"},
		{"compensation", "compens"},
		{"compete", "compet"},
		{"competency", "compet"},
		{"competent", "compet"},
		{"competitions", "competit"},
		{"competitor", "competitor"},
		{"compilers", "compil"},
		{"complacency", "complac"},
		{"complacent", "complac"},
		{"complacently", "complac"},
		{"complain", "complain"},
		{"complained", "complain"},
		{"complaining", "complain"},
		{"complainings", "complain"},
		{"complains", "complain"},
		{"complaint", "complaint"},
		{"complaints", "complaint"},
		{"complanata", "complanata"},
		{"complement", "complement"},
		{"complete", "complet"},
		{"completed", "complet"},
		{"completel", "completel"},
		{"completely", "complet"},
		{"completeness", "complet"},
		{"completes", "complet"},
		{"completest", "completest"},
		{"completing", "complet"},
		{"completion", "complet"},
		{"complex", "complex"},
		{"complexion", "complexion"},
		{"complexioned", "complexion"},
		{"complexions", "complexion"},
		{"compliance", "complianc"},
		{"complicated", "complic"},
		{"complication", "complic"},
		{"complications", "complic"},
		{"complied", "compli"},
		{"complies", "compli"},
		{"compliment", "compliment"},
		{"complimentary", "complimentari"},
		{"complimented", "compliment"},
		{"complimenting", "compliment"},
		{"compliments", "compliment"},
		{"comply", "compli"},
		{"complying", "compli"},
		{"compn", "compn"},
		{"component", "compon"},
		{"compose", "compos"},
		{"composed", "compos"},
		{"composedly", "compos"},
		{"composer", "compos"},
		{"composes", "compos"},
		{"composing", "compos"},
		{"compositae", "composita"},
		{"composite", "composit"},
		{"composition", "composit"},
		{"compositions", "composit"},
		{"composure", "composur"},
		{"compound", "compound"},
		{"compounded", "compound"},
		{"comprehen", "comprehen"},
		{"comprehend", "comprehend"},
		{"comprehended", "comprehend"},
		{"comprehending", "comprehend"},
		{"comprehends", "comprehend"},
		{"comprehensible", "comprehens"},
		{"comprehension", "comprehens"},
		{"comprehensive", "comprehens"},
		{"compressed", "compress"},
		{"compressible", "compress"},
		{"compressing", "compress"},
		{"compression", "compress"},
		{"comprise", "compris"},
		{"comprised", "compris"},
		{"comprises", "compris"},
		{"comprising", "compris"},
		{"compromise", "compromis"},
		{"compromised", "compromis"},
		{"compromises", "compromis"},
		{"compromising", "compromis"},
		{"compter", "compter"},
		{"comptes", "compt"},
		{"compulsion", "compuls"},
		{"compulsory", "compulsori"},
		{"compunction", "compunct"},
		{"computation", "comput"},
		{"comrade", "comrad"},
		{"comrades", "comrad"},
		{"con", "con"},
		{"concatenation", "concaten"},
		{"concave", "concav"},
		{"conceal", "conceal"},
		{"concealed", "conceal"},
		{"concealing", "conceal"},
		{"concealment", "conceal"},
		{"concealments", "conceal"},
		{"concebida", "concebida"},
		{"concede", "conced"},
		{"conceded", "conced"},
		{"concedes", "conced"},
		{"conceit", "conceit"},
		{"conceited", "conceit"},
		{"conceivable", "conceiv"},
		{"conceive", "conceiv"},
		{"conceived", "conceiv"},
		{"conceives", "conceiv"},
		{"conceiving", "conceiv"},
		{"concentrate", "concentr"},
		{"concentrated", "concentr"},
		{"concentrating", "concentr"},
		{"concentration", "concentr"},
		{"concepcion", "concepcion"},
		{"conception", "concept"},
		{"conceptions", "concept"},
		{"concern", "concern"},
		{"concerned", "concern"},
		{"concerning", "concern"},
		{"concerns", "concern"},
		{"concert", "concert"},
		{"concerted", "concert"},
		{"concertina", "concertina"},
		{"concerts", "concert"},
		{"concession", "concess"},
		{"concessions", "concess"},
		{"conchalee", "conchale"},
		{"conchas", "concha"},
		{"conchological", "concholog"},
		{"conciliate", "concili"},
		{"conciliated", "concili"},
		{"conciliation", "concili"},
		{"conciliations", "concili"},
		{"conciliatory", "conciliatori"},
		{"concise", "concis"},
		{"conclave", "conclav"},
		{"conclaves", "conclav"},
		{"conclude", "conclud"},
		{"concluded", "conclud"},
		{"concludes", "conclud"},
		{"concluding", "conclud"},
		{"conclusion", "conclus"},
		{"conclusions", "conclus"},
		{"conclusive", "conclus"},
		{"conclusively", "conclus"},
		{"concoct", "concoct"},
		{"concocted", "concoct"},
		{"concord", "concord"},
		{"concourse", "concours"},
		{"concretions", "concret"},
		{"concubine", "concubin"},
		{"concur", "concur"},
		{"concurrence", "concurr"},
		{"concurrent", "concurr"},
		{"concurs", "concur"},
		{"condemn", "condemn"},
		{"condemnation", "condemn"},
		{"condemned", "condemn"},
		{"condemning", "condemn"},
		{"condemns", "condemn"},
		{"condense", "condens"},
		{"condensed", "condens"},
		{"condescend", "condescend"},
		{"condescended", "condescend"},
		{"condescending", "condescend"},
		{"condescendingly", "condescend"},
		{"condescends", "condescend"},
		{"condescension", "condescens"},
		{"condescent", "condesc"},
		{"condeseending", "condeseend"},
		{"condign", "condign"},
		{"condition", "condit"},
		{"conditional", "condit"},
		{"conditioned", "condit"},
		{"conditions", "condit"},
		{"condole", "condol"},
		{"condoled", "condol"},
		{"condolence", "condol"},
		{"condolences", "condol"},
		{"condor", "condor"},
		{"condors", "condor"},
		{"conduce", "conduc"},
		{"conducive", "conduc"},
		{"conduct", "conduct"},
		{"conducted", "conduct"},
		{"conducting", "conduct"},
		{"conductor", "conductor"},
		{"conductors", "conductor"},
		{"conductress", "conductress"},
		{"conducts", "conduct"},
		{"conduits", "conduit"},
		{"cone", "cone"},
		{"conejos", "conejo"},
		{"cones", "cone"},
		{"confabulation", "confabul"},
		{"confabulations", "confabul"},
		{"confectioner", "confection"},
		{"confederate", "confeder"},
		{"confederates", "confeder"},
		{"confer", "confer"},
		{"conference", "confer"},
		{"conferences", "confer"},
		{"conferred", "confer"},
		{"conferring", "confer"},
		{"confers", "confer"},
		{"confervae", "conferva"},
		{"confess", "confess"},
		{"confessed", "confess"},
		{"confessedly", "confess"},
		{"confessing", "confess"},
		{"confession", "confess"},
		{"confessions", "confess"},
		{"confessor", "confessor"},
		{"confidante", "confidant"},
		{"confidantes", "confidant"},
		{"confide", "confid"},
		{"confided", "confid"},
		{"confidence", "confid"},
		{"confidences", "confid"},
		{"confident", "confid"},
		{"confidential", "confidenti"},
		{"confidentially", "confidenti"},
		{"confidently", "confid"},
		{"confides", "confid"},
		{"confiding", "confid"},
		{"confidingly", "confid"},
		{"configuration", "configur"},
		{"confine", "confin"},
		{"confined", "confin"},
		{"confinement", "confin"},
		{"confines", "confin"},
		{"confining", "confin"},
		{"confirm", "confirm"},
		{"confirmation", "confirm"},
		{"confirmatory", "confirmatori"},
		{"confirmed", "confirm"},
		{"confirming", "confirm"},
		{"confirms", "confirm"},
		{"confiscate", "confisc"},
		{"confiscation", "confisc"},
		{"conflagrations", "conflagr"},
		{"conflict", "conflict"},
		{"conflicting", "conflict"},
		{"conform", "conform"},
		{"conforming", "conform"},
		{"conformity", "conform"},
		{"confound", "confound"},
		{"confounded", "confound"},
		{"confoundedly", "confound"},
		{"confounding", "confound"},
		{"confront", "confront"},
		{"confronted", "confront"},
		{"confronting", "confront"},
		{"confronts", "confront"},
		{"confuse", "confus"},
		{"confused", "confus"},
		{"confusedly", "confus"},
		{"confuses", "confus"},
		{"confusing", "confus"},
		{"confusion", "confus"},
		{"confute", "confut"},
		{"confuting", "confut"},
		{"congealed", "congeal"},
		{"congelation", "congel"},
		{"congeners", "congen"},
		{"congenial", "congeni"},
		{"congenially", "congeni"},
		{"conglomerate", "conglomer"},
		{"conglomeration", "conglomer"},
		{"congo", "congo"},
		{"congratulate", "congratul"},
		{"congratulated", "congratul"},
		{"congratulating", "congratul"},
		{"congratulation", "congratul"},
		{"congratulations", "congratul"},
		{"congratulatory", "congratulatori"},
		{"congregate", "congreg"},
		{"congregated", "congreg"},
		{"congregation", "congreg"},
		{"congruous", "congruous"},
		{"conica", "conica"},
		{"conical", "conic"},
		{"conjecture", "conjectur"},
		{"conjectured", "conjectur"},
		{"conjectures", "conjectur"},
		{"conjecturing", "conjectur"},
		{"conjoint", "conjoint"},
		{"conjointly", "conjoint"},
		{"conjugal", "conjug"},
		{"conjunction", "conjunct"},
		{"conjuncture", "conjunctur"},
		{"conjuration", "conjur"},
		{"conjure", "conjur"},
		{"conjured", "conjur"},
		{"conjures", "conjur"},
		{"conjuring", "conjur"},
		{"conjuror", "conjuror"},
		{"connect", "connect"},
		{"connected", "connect"},
		{"connecting", "connect"},
		{"connection", "connect"},
		{"connections", "connect"},
		{"connects", "connect"},
		{"connexion", "connexion"},
		{"connexions", "connexion"},
		{"conning", "con"},
		{"connivance", "conniv"},
		{"connoisseur", "connoisseur"},
		{"connubialities", "connubi"},
		{"conquer", "conquer"},
		{"conquerable", "conquer"},
		{"conquered", "conquer"},
		{"conquering", "conquer"},
		{"conqueror", "conqueror"},
		{"conquerors", "conqueror"},
		{"conquest", "conquest"},
		{"consanguinity", "consanguin"},
		{"consarn", "consarn"},
		{"conscience", "conscienc"},
		{"consciences", "conscienc"},
		{"conscientious", "conscienti"},
		{"conscientiously", "conscienti"},
		{"conscientiousness", "conscienti"},
		{"conscious", "conscious"},
		{"consciously", "conscious"},
		{"consciousness", "conscious"},
		{"consecrated", "consecr"},
		{"consecrating", "consecr"},
		{"consecutive", "consecut"},
		{"consecutively", "consecut"},
		{"consent", "consent"},
		{"consented", "consent"},
		{"consenting", "consent"},
		{"consents", "consent"},
		{"consequence", "consequ"},
		{"consequences", "consequ"},
		{"consequent", "consequ"},
		{"consequential", "consequenti"},
		{"consequently", "consequ"},
		{"conservatism", "conservat"},
		{"conservative", "conserv"},
		{"conservatives", "conserv"},
		{"conservatories", "conservatori"},
		{"conservatory", "conservatori"},
		{"conserved", "conserv"},
		{"consider", "consid"},
		{"considerable", "consider"},
		{"considerably", "consider"},
		{"considerate", "consider"},
		{"considerately", "consider"},
		{"consideration", "consider"},
		{"considerations", "consider"},
		{"considered", "consid"},
		{"considering", "consid"},
		{"considers", "consid"},
		{"consign", "consign"},
		{"consigned", "consign"},
		{"consigning", "consign"},
		{"consignment", "consign"},
		{"consist", "consist"},
		{"consisted", "consist"},
		{"consistency", "consist"},
		{"consistent", "consist"},
		{"consistently", "consist"},
		{"consisting", "consist"},
		{"consists", "consist"},
		{"consolation", "consol"},
		{"consolations", "consol"},
		{"consolatory", "consolatori"},
		{"console", "consol"},
		{"consoled", "consol"},
		{"consoles", "consol"},
		{"consolidate", "consolid"},
		{"consolidated", "consolid"},
		{"consolidating", "consolid"},
		{"consoling", "consol"},
		{"consolingly", "consol"},
		{"consols", "consol"},
		{"consonant", "conson"},
		{"consort", "consort"},
		{"consorted", "consort"},
		{"consorting", "consort"},
		{"conspicuous", "conspicu"},
		{"conspicuously", "conspicu"},
		{"conspiracy", "conspiraci"},
		{"conspirator", "conspir"},
		{"conspirators", "conspir"},
		{"conspire", "conspir"},
		{"conspired", "conspir"},
		{"conspiring", "conspir"},
		{"constable", "constabl"},
		{"constables", "constabl"},
		{"constance", "constanc"},
		{"constancy", "constanc"},
		{"constant", "constant"},
		{"constantinople", "constantinopl"},
		{"constantly", "constant"},
		{"constellations", "constel"},
		{"consternation", "constern"},
		{"constitootion", "constitoot"},
		{"constituencies", "constitu"},
		{"constituency", "constitu"},
		{"constituent", "constitu"},
		{"constituents", "constitu"},
		{"constitute", "constitut"},
		{"constituted", "constitut"},
		{"constitutes", "constitut"},
		{"constituting", "constitut"},
		{"constitution", "constitut"},
		{"constitutional", "constitut"},
		{"constitutionally", "constitut"},
		{"constrain", "constrain"},
		{"constrained", "constrain"},
		{"constraining", "constrain"},
		{"constrains", "constrain"},
		{"constraint", "constraint"},
		{"construct", "construct"},
		{"constructed", "construct"},
		{"constructing", "construct"},
		{"construction", "construct"},
		{"constructions", "construct"},
		{"construe", "constru"},
		{"consul", "consul"},
		{"consult", "consult"},
		{"consultation", "consult"},
		{"consultations", "consult"},
		{"consulted", "consult"},
		{"consulting", "consult"},
		{"consults", "consult"},
		{"consume", "consum"},
		{"consumed", "consum"},
		{"consumedly", "consum"},
		{"consumers", "consum"},
		{"consuming", "consum"},
		{"consummate", "consumm"},
		{"consummation", "consumm"},
		{"consumption", "consumpt"},
		{"consumptive", "consumpt"},
		{"contact", "contact"},
		{"contagion", "contagion"},
		{"contagious", "contagi"},
		{"contain", "contain"},
		{"contained", "contain"},
		{"containing", "contain"},
		{"contains", "contain"},
		{"contaminated", "contamin"},
		{"contaminating", "contamin"},
		{"contamination", "contamin"},
		{"contemned", "contemn"},
		{"contemning", "contemn"},
		{"contemns", "contemn"},
		{"contemplate", "contempl"},
		{"contemplated", "contempl"},
		{"contemplates", "contempl"},
		{"contemplating", "contempl"},
		{"contemplation", "contempl"},
		{"contemplations", "contempl"},
		{"contemplative", "contempl"},
		{"contemporaneous", "contemporan"},
		{"contemporaneously", "contemporan"},
		{"contemporaneousness", "contemporan"},
		{"contemporaries", "contemporari"},
		{"contempt", "contempt"},
		{"contemptible", "contempt"},
		{"contemptuous", "contemptu"},
		{"contemptuously", "contemptu"},
		{"conten", "conten"},
		{"contend", "contend"},
		{"contended", "contend"},
		{"contending", "contend"},
		{"contends", "contend"},
		{"content", "content"},
		{"contented", "content"},
		{"contentedly", "content"},
		{"contenting", "content"},
		{"contention", "content"},
		{"contentions", "content"},
		{"contentious", "contenti"},
		{"contentment", "content"},
		{"contents", "content"},
		{"contest", "contest"},
		{"contested", "contest"},
		{"contests", "contest"},
		{"continent", "contin"},
		{"continental", "continent"},
		{"continents", "contin"},
		{"contingencies", "conting"},
		{"contingency", "conting"},
		{"contingent", "conting"},
		{"continney", "continney"},
		{"continual", "continu"},
		{"continually", "continu"},
		{"continuance", "continu"},
		{"continuation", "continu"},
		{"continue", "continu"},
		{"continued", "continu"},
		{"continues", "continu"},
		{"continuing", "continu"},
		{"continuous", "continu"},
		{"continuously", "continu"},
		{"contorted", "contort"},
		{"contorting", "contort"},
		{"contortions", "contort"},
		{"contra", "contra"},
		{"contract", "contract"},
		{"contracted", "contract"},
		{"contracting", "contract"},
		{"contraction", "contract"},
		{"contractors", "contractor"},
		{"contracts", "contract"},
		{"contradict", "contradict"},
		{"contradicted", "contradict"},
		{"contradicting", "contradict"},
		{"contradiction", "contradict"},
		{"contradictions", "contradict"},
		{"contradictory", "contradictori"},
		{"contradicts", "contradict"},
		{"contradistinction", "contradistinct"},
		{"contrairy", "contrairi"},
		{"contralto", "contralto"},
		{"contrarieties", "contrarieti"},
		{"contrary", "contrari"},
		{"contrast", "contrast"},
		{"contrasted", "contrast"},
		{"contrasting", "contrast"},
		{"contrasts", "contrast"},
		{"contrees", "contre"},
		{"contribute", "contribut"},
		{"contributed", "contribut"},
		{"contributes", "contribut"},
		{"contributing", "contribut"},
		{"contribution", "contribut"},
		{"contributions", "contribut"},
		{"contributors", "contributor"},
		{"contrite", "contrit"},
		{"contrition", "contrit"},
		{"contrivance", "contriv"},
		{"contrivances", "contriv"},
		{"contrive", "contriv"},
		{"contrived", "contriv"},
		{"contriving", "contriv"},
		{"control", "control"},
		{"controlled", "control"},
		{"controlling", "control"},
		{"controls", "control"},
		{"controvert", "controvert"},
		{"controverted", "controvert"},
		{"contumelious", "contumeli"},
		{"contumely", "contum"},
		{"contusion", "contus"},
		{"conundrums", "conundrum"},
		{"conurus", "conurus"},
		{"convalescence", "convalesc"},
		{"convalescent", "convalesc"},
		{"convened", "conven"},
		{"convenience", "conveni"},
		{"convenient", "conveni"},
		{"conveniently", "conveni"},
		{"convent", "convent"},
		{"convention", "convent"},
		{"conventional", "convent"},
		{"conventionalities", "convent"},
		{"conventionality", "convent"},
		{"conventionally", "convent"},
		{"conventions", "convent"},
		{"convents", "convent"},
		{"conventual", "conventu"},
		{"converge", "converg"},
		{"converged", "converg"},
		{"convergent", "converg"},
		{"conversant", "convers"},
		{"conversation", "convers"},
		{"conversational", "convers"},
		{"conversationally", "convers"},
		{"conversations", "convers"},
		{"converse", "convers"},
		{"conversed", "convers"},
		{"converses", "convers"},
		{"conversing", "convers"},
		{"conversion", "convers"},
		{"convert", "convert"},
		{"converted", "convert"},
		{"convertible", "convert"},
		{"converting", "convert"},
		{"convertion", "convert"},
		{"converts", "convert"},
		{"convex", "convex"},
		{"convey", "convey"},
		{"conveyance", "convey"},
		{"conveyancer", "conveyanc"},
		{"conveyances", "convey"},
		{"conveyed", "convey"},
		{"conveying", "convey"},
		{"conveys", "convey"},
		{"convict", "convict"},
		{"convicted", "convict"},
		{"conviction", "convict"},
		{"convictions", "convict"},
		{"convicts", "convict"},
		{"convince", "convinc"},
		{"convinced", "convinc"},
		{"convinces", "convinc"},
		{"convincing", "convinc"},
		{"convivial", "convivi"},
		{"conviviality", "convivi"},
		{"convolvulus", "convolvulus"},
		{"convulsed", "convuls"},
		{"convulsion", "convuls"},
		{"convulsions", "convuls"},
		{"convulsive", "convuls"},
		{"convulsively", "convuls"},
		{"conwenient", "conweni"},
		{"conwulsions", "conwuls"},
		{"coodle", "coodl"},
		{"coodleites", "coodleit"},
		{"cooing", "coo"},
		{"cook", "cook"},
		{"cooked", "cook"},
		{"cookery", "cookeri"},
		{"cooking", "cook"},
		{"cookites", "cookit"},
		{"cooks", "cook"},
		{"cookshop", "cookshop"},
		{"cool", "cool"},
		{"cooled", "cool"},
		{"cooler", "cooler"},
		{"coolest", "coolest"},
		{"cooling", "cool"},
		{"coolly", "coolli"},
		{"coolness", "cool"},
		{"coom", "coom"},
		{"coomin", "coomin"},
		{"cooms", "coom"},
		{"coop", "coop"},
		{"cooped", "coop"},
		{"coorch", "coorch"},
		{"coot", "coot"},
		{"cope", "cope"},
		{"copeck", "copeck"},
		{"copecks", "copeck"},
		{"cophias", "cophia"},
		{"copiapo", "copiapo"},
		{"copied", "copi"},
		{"copies", "copi"},
		{"coping", "cope"},
		{"copious", "copious"},
		{"copiously", "copious"},
		{"copper", "copper"},
		{"coppers", "copper"},
		{"coppery", "copperi"},
		{"coppice", "coppic"},
		{"copse", "cops"},
		{"copy", "copi"},
		{"copying", "copi"},
		{"coquetry", "coquetri"},
		{"coquette", "coquett"},
		{"coquettish", "coquettish"},
		{"coquille", "coquill"},
		{"coquimbo", "coquimbo"},
		{"cora", "cora"},
		{"coral", "coral"},
		{"coralline", "corallin"},
		{"corallines", "corallin"},
		{"corals", "coral"},
		{"corcovado", "corcovado"},
		{"cord", "cord"},
		{"cordage", "cordag"},
		{"corded", "cord"},
		{"cordial", "cordial"},
		{"cordiality", "cordial"},
		{"cordially", "cordial"},
		{"cordials", "cordial"},
		{"cordillera", "cordillera"},
		{"cords", "cord"},
		{"corduroy", "corduroy"},
		{"core", "core"},
		{"corfield", "corfield"},
		{"coriaceous", "coriac"},
		{"coriolanus", "coriolanus"},
		{"cork", "cork"},
		{"corks", "cork"},
		{"corkscrew", "corkscrew"},
		{"corkscrewed", "corkscrew"},
		{"cormoran", "cormoran"},
		{"cormorant", "cormor"},
		{"cormorants", "cormor"},
		{"corn", "corn"},
		{"corned", "corn"},
		{"cornelia", "cornelia"},
		{"cornelian", "cornelian"},
		{"corner", "corner"},
		{"cornered", "corner"},
		{"corners", "corner"},
		{"cornerstone", "cornerston"},
		{"cornfield", "cornfield"},
		{"cornice", "cornic"},
		{"cornish", "cornish"},
		{"corns", "corn"},
		{"cornwall", "cornwal"},
		{"coronal", "coron"},
		{"coroner", "coron"},
		{"coroners", "coron"},
		{"coronet", "coronet"},
		{"coronets", "coronet"},
		{"corporal", "corpor"},
		{"corporation", "corpor"},
		{"corporations", "corpor"},
		{"corporeal", "corpor"},
		{"corps", "corp"},
		{"corpse", "corps"},
		{"corpses", "corps"},
		{"corpulence", "corpul"},
		{"corpulent", "corpul"},
		{"corpus", "corpus"},
		{"corral", "corral"},
		{"corrales", "corral"},
		{"corrals", "corral"},
		{"correct", "correct"},
		{"corrected", "correct"},
		{"correcting", "correct"},
		{"correction", "correct"},
		{"corrective", "correct"},
		{"correctly", "correct"},
		{"correctness", "correct"},
		{"corrects", "correct"},
		{"correndera", "correndera"},
		{"correspond", "correspond"},
		{"corresponded", "correspond"},
		{"correspondence", "correspond"},
		{"correspondent", "correspond"},
		{"correspondents", "correspond"},
		{"corresponding", "correspond"},
		{"correspondingly", "correspond"},
		{"corridor", "corridor"},
		{"corrientes", "corrient"},
		{"corrobery", "corroberi"},
		{"corroborate", "corrobor"},
		{"corroborated", "corrobor"},
		{"corroboration", "corrobor"},
		{"corroborative", "corrobor"},
		{"corroboratory", "corroboratori"},
		{"corroded", "corrod"},
		{"corroding", "corrod"},
		{"corrugated", "corrug"},
		{"corrupt", "corrupt"},
		{"corrupted", "corrupt"},
		{"corrupting", "corrupt"},
		{"corruption", "corrupt"},
		{"corrupts", "corrupt"},
		{"corse", "cors"},
		{"cortez", "cortez"},
		{"corunda", "corunda"},
		{"corynetes", "corynet"},
		{"cos", "cos"},
		{"cosa", "cosa"},
		{"coseguina", "coseguina"},
		{"cosgrave", "cosgrav"},
		{"cosily", "cosili"},
		{"cosmopolitan", "cosmopolitan"},
		{"cost", "cost"},
		{"costal", "costal"},
		{"costermongers", "costermong"},
		{"costlier", "costlier"},
		{"costliest", "costliest"},
		{"costly", "cost"},
		{"costs", "cost"},
		{"costume", "costum"},
		{"costumes", "costum"},
		{"cosy", "cosi"},
		{"cot", "cot"},
		{"cote", "cote"},
		{"cottage", "cottag"},
		{"cottager", "cottag"},
		{"cottagers", "cottag"},
		{"cottages", "cottag"},
		{"cotton", "cotton"},
		{"cottoned", "cotton"},
		{"cottons", "cotton"},
		{"couch", "couch"},
		{"couched", "couch"},
		{"couches", "couch"},
		{"cough", "cough"},
		{"coughed", "cough"},
		{"coughing", "cough"},
		{"coughs", "cough"},
		{"could", "could"},
		{"couldn", "couldn"},
		{"couldst", "couldst"},
		{"council", "council"},
		{"councillor", "councillor"},
		{"councillors", "councillor"},
		{"councils", "council"},
		{"counsel", "counsel"},
		{"counselled", "counsel"},
		{"counsellor", "counsellor"},
		{"counsellors", "counsellor"},
		{"counsels", "counsel"},
		{"count", "count"},
		{"counted", "count"},
		{"countenance", "counten"},
		{"countenanced", "countenanc"},
		{"countenances", "counten"},
		{"counter", "counter"},
		{"counteract", "counteract"},
		{"counteracted", "counteract"},
		{"counterbalance", "counterbal"},
		{"counterbalanced", "counterbalanc"},
		{"counterfeit", "counterfeit"},
		{"counterfeited", "counterfeit"},
		{"counterfeiting", "counterfeit"},
		{"counterfeits", "counterfeit"},
		{"counterpane", "counterpan"},
		{"counterpart", "counterpart"},
		{"counterplot", "counterplot"},
		{"counterpoise", "counterpois"},
		{"counters", "counter"},
		{"countess", "countess"},
		{"countesses", "countess"},
		{"counties", "counti"},
		{"counting", "count"},
		{"countless", "countless"},
		{"countree", "countre"},
		{"countries", "countri"},
		{"countrified", "countrifi"},
		{"country", "countri"},
		{"countryman", "countryman"},
		{"countrymen", "countrymen"},
		{"countryrmen", "countryrmen"},
		{"countrywomen", "countrywomen"},
		{"counts", "count"},
		{"county", "counti"},
		{"coup", "coup"},
		{"couple", "coupl"},
		{"coupled", "coupl"},
		{"couples", "coupl"},
		{"coupling", "coupl"},
		{"courage", "courag"},
		{"courageous", "courag"},
		{"courageously", "courag"},
		{"courcy", "courci"},
		{"courcys", "courci"},
		{"courier", "courier"},
		{"course", "cours"},
		{"coursed", "cours"},
		{"coursers", "courser"},
		{"courses", "cours"},
		{"coursing", "cours"},
		{"court", "court"},
		{"courted", "court"},
		{"courteous", "courteous"},
		{"courteously", "courteous"},
		{"courtesies", "courtesi"},
		{"courtesy", "courtesi"},
		{"courtier", "courtier"},
		{"courtiers", "courtier"},
		{"courting", "court"},
		{"courtly", "court"},
		{"courts", "court"},
		{"courtship", "courtship"},
		{"courtships", "courtship"},
		{"courtyard", "courtyard"},
		{"courtyards", "courtyard"},
		{"cousin", "cousin"},
		{"cousinly", "cousin"},
		{"cousins", "cousin"},
		{"cousinship", "cousinship"},
		{"couthouy", "couthouy"},
		{"cove", "cove"},
		{"covenanted", "coven"},
		{"covent", "covent"},
		{"coventry", "coventri"},
		{"cover", "cover"},
		{"covered", "cover"},
		{"covering", "cover"},
		{"coverings", "cover"},
		{"coverlet", "coverlet"},
		{"coverley", "coverley"},
		{"covers", "cover"},
		{"covert", "covert"},
		{"covertly", "covert"},
		{"coverts", "covert"},
		{"coverture", "covertur"},
		{"coves", "cove"},
		{"covet", "covet"},
		{"coveted", "covet"},
		{"covetous", "covet"},
		{"covetousness", "covet"},
		{"coveys", "covey"},
		{"cow", "cow"},
		{"coward", "coward"},
		{"cowardice", "cowardic"},
		{"cowardly", "coward"},
		{"cowards", "coward"},
		{"cowboy", "cowboy"},
		{"cowcumber", "cowcumb"},
		{"cowed", "cow"},
		{"cower", "cower"},
		{"cowered", "cower"},
		{"cowering", "cower"},
		{"cowers", "cower"},
		{"cowl", "cowl"},
		{"cowley", "cowley"},
		{"cows", "cow"},
		{"cowshed", "cowsh"},
		{"cowslip", "cowslip"},
		{"cowslips", "cowslip"},
		{"cox", "cox"},
		{"coxcomb", "coxcomb"},
		{"coxcombical", "coxcomb"},
		{"coxcombs", "coxcomb"},
		{"coxswain", "coxswain"},
		{"coy", "coy"},
		{"coyness", "coy"},
		{"coypus", "coypus"},
		{"cozened", "cozen"},
		{"cozily", "cozili"},
		{"crab", "crab"},
		{"crabbe", "crabb"},
		{"crabbed", "crab"},
		{"crabberies", "crabberi"},
		{"crabs", "crab"},
		{"crack", "crack"},
		{"cracked", "crack"},
		{"cracking", "crack"},
		{"crackle", "crackl"},
		{"crackled", "crackl"},
		{"crackling", "crackl"},
		{"cracks", "crack"},
		{"cradle", "cradl"},
		{"cradles", "cradl"},
		{"craft", "craft"},
		{"craftier", "craftier"},
		{"craftiest", "craftiest"},
		{"crafts", "craft"},
		{"crafty", "crafti"},
		{"crags", "crag"},
		{"cram", "cram"},
		{"cramble", "crambl"},
		{"crammed", "cram"},
		{"cramming", "cram"},
		{"cramp", "cramp"},
		{"cramped", "cramp"},
		{"cramping", "cramp"},
		{"cranberry", "cranberri"},
		{"crancrivora", "crancrivora"},
		{"cranes", "crane"},
		{"craning", "crane"},
		{"cranks", "crank"},
		{"crannies", "cranni"},
		{"crape", "crape"},
		{"crash", "crash"},
		{"crashed", "crash"},
		{"crashing", "crash"},
		{"crater", "crater"},
		{"crateriform", "crateriform"},
		{"craters", "crater"},
		{"cravat", "cravat"},
		{"cravats", "cravat"},
		{"crave", "crave"},
		{"craved", "crave"},
		{"craven", "craven"},
		{"craving", "crave"},
		{"craw", "craw"},
		{"crawl", "crawl"},
		{"crawled", "crawl"},
		{"crawling", "crawl"},
		{"crawls", "crawl"},
		{"craws", "craw"},
		{"cray", "cray"},
		{"crayons", "crayon"},
		{"craze", "craze"},
		{"crazed", "craze"},
		{"crazy", "crazi"},
		{"creak", "creak"},
		{"creaked", "creak"},
		{"creaking", "creak"},
		{"cream", "cream"},
		{"crease", "creas"},
		{"creases", "creas"},
		{"creasing", "creas"},
		{"create", "creat"},
		{"created", "creat"},
		{"creating", "creat"},
		{"creation", "creation"},
		{"creations", "creation"},
		{"creative", "creativ"},
		{"creator", "creator"},
		{"creature", "creatur"},
		{"creatures", "creatur"},
		{"credence", "credenc"},
		{"credentials", "credenti"},
		{"credibility", "credibl"},
		{"credible", "credibl"},
		{"credibly", "credibl"},
		{"credit", "credit"},
		{"creditable", "credit"},
		{"creditably", "credit"},
		{"credited", "credit"},
		{"crediting", "credit"},
		{"creditor", "creditor"},
		{"creditors", "creditor"},
		{"credulity", "credul"},
		{"credulous", "credul"},
		{"cree", "cree"},
		{"creed", "creed"},
		{"creek", "creek"},
		{"creeks", "creek"},
		{"creep", "creep"},
		{"creeper", "creeper"},
		{"creepers", "creeper"},
		{"creeping", "creep"},
		{"creeps", "creep"},
		{"creetur", "creetur"},
		{"creeturs", "creetur"},
		{"creevy", "creevi"},
		{"crepitans", "crepitan"},
		{"crept", "crept"},
		{"crescent", "crescent"},
		{"crest", "crest"},
		{"crested", "crest"},
		{"crestfallen", "crestfallen"},
		{"crests", "crest"},
		{"crevez", "crevez"},
		{"crevice", "crevic"},
		{"crevices", "crevic"},
		{"crew", "crew"},
		{"crib", "crib"},
		{"cribs", "crib"},
		{"crichton", "crichton"},
		{"cricket", "cricket"},
		{"crickets", "cricket"},
		{"cried", "cri"},
		{"crier", "crier"},
		{"criers", "crier"},
		{"cries", "cri"},
		{"crime", "crime"},
		{"crimes", "crime"},
		{"criminal", "crimin"},
		{"criminality", "crimin"},
		{"criminals", "crimin"},
		{"criminate", "crimin"},
		{"criminations", "crimin"},
		{"crimson", "crimson"},
		{"crimsoned", "crimson"},
		{"cringe", "cring"},
		{"cringing", "cring"},
		{"cringingly", "cring"},
		{"crinoline", "crinolin"},
		{"cripple", "crippl"},
		{"crippled", "crippl"},
		{"crippler", "crippler"},
		{"crisia", "crisia"},
		{"crisis", "crisi"},
		{"crisp", "crisp"},
		{"cristal", "cristal"},
		{"cristatus", "cristatus"},
		{"cristiandad", "cristiandad"},
		{"cristianos", "cristiano"},
		{"criterion", "criterion"},
		{"critic", "critic"},
		{"critical", "critic"},
		{"criticise", "criticis"},
		{"criticised", "criticis"},
		{"criticism", "critic"},
		{"criticisms", "critic"},
		{"criticize", "critic"},
		{"criticizing", "critic"},
		{"critics", "critic"},
		{"critique", "critiqu"},
		{"critturs", "crittur"},
		{"croak", "croak"},
		{"croaked", "croak"},
		{"croaking", "croak"},
		{"croaks", "croak"},
		{"crockery", "crockeri"},
		{"crockford", "crockford"},
		{"crocking", "crock"},
		{"crocodile", "crocodil"},
		{"crocodiles", "crocodil"},
		{"croesus", "croesus"},
		{"crois", "croi"},
		{"crook", "crook"},
		{"crooked", "crook"},
		{"crookedly", "crook"},
		{"crooks", "crook"},
		{"crop", "crop"},
		{"cropley", "cropley"},
		{"crops", "crop"},
		{"cros", "cros"},
		{"cross", "cross"},
		{"crosse", "cross"},
		{"crossed", "cross"},
		{"crosses", "cross"},
		{"crossgrained", "crossgrain"},
		{"crossin", "crossin"},
		{"crossing", "cross"},
		{"crossings", "cross"},
		{"crossly", "crossli"},
		{"crost", "crost"},
		{"crotchet", "crotchet"},
		{"crotchets", "crotchet"},
		{"crouched", "crouch"},
		{"crouches", "crouch"},
		{"crouching", "crouch"},
		{"croup", "croup"},
		{"crow", "crow"},
		{"crowbar", "crowbar"},
		{"crowd", "crowd"},
		{"crowded", "crowd"},
		{"crowding", "crowd"},
		{"crowds", "crowd"},
		{"crowed", "crow"},
		{"crowin", "crowin"},
		{"crowing", "crow"},
		{"crowl", "crowl"},
		{"crown", "crown"},
		{"crowned", "crown"},
		{"crowning", "crown"},
		{"crowns", "crown"},
		{"crowquill", "crowquil"},
		{"crows", "crow"},
		{"crucified", "crucifi"},
		{"crucify", "crucifi"},
		{"crucifying", "crucifi"},
		{"crude", "crude"},
		{"crudely", "crude"},
		{"crudest", "crudest"},
		{"cruel", "cruel"},
		{"cruellest", "cruellest"},
		{"cruelly", "cruelli"},
		{"cruelties", "cruelti"},
		{"cruelty", "cruelti"},
		{"cruenta", "cruenta"},
		{"cruet", "cruet"},
		{"cruise", "cruis"},
		{"cruises", "cruis"},
		{"crumb", "crumb"},
		{"crumber", "crumber"},
		{"crumble", "crumbl"},
		{"crumbled", "crumbl"},
		{"crumbling", "crumbl"},
		{"crumbs", "crumb"},
		{"crumlinwallinwer", "crumlinwallinw"},
		{"crummles", "crumml"},
		{"crummleses", "crummles"},
		{"crumpet", "crumpet"},
		{"crumpets", "crumpet"},
		{"crumpled", "crumpl"},
		{"crumpling", "crumpl"},
		{"crumpy", "crumpi"},
		{"crupper", "crupper"},
		{"crusade", "crusad"},
		{"crusader", "crusad"},
		{"crusaders", "crusad"},
		{"crusades", "crusad"},
		{"crusading", "crusad"},
		{"crush", "crush"},
		{"crushed", "crush"},
		{"crushes", "crush"},
		{"crushing", "crush"},
		{"crusoe", "cruso"},
		{"crust", "crust"},
		{"crustacea", "crustacea"},
		{"crustaceous", "crustac"},
		{"crusts", "crust"},
		{"crusty", "crusti"},
		{"crutches", "crutch"},
		{"cruz", "cruz"},
		{"cry", "cri"},
		{"crying", "cri"},
		{"crypt", "crypt"},
		{"cryptogamic", "cryptogam"},
		{"crystal", "crystal"},
		{"crystalline", "crystallin"},
		{"crystallization", "crystal"},
		{"crystallized", "crystal"},
		{"crystals", "crystal"},
		{"crystial", "crystial"},
		{"ct", "ct"},
		{"ctenomys", "ctenomi"},
		{"cu", "cu"},
		{"cubes", "cube"},
		{"cubic", "cubic"},
		{"cubs", "cub"},
		{"cucao", "cucao"},
		{"cuchilla", "cuchilla"},
		{"cuckoo", "cuckoo"},
		{"cuckoos", "cuckoo"},
		{"cucumber", "cucumb"},
		{"cucumbers", "cucumb"},
		{"cudgel", "cudgel"},
		{"cudgelled", "cudgel"},
		{"cudgels", "cudgel"},
		{"cudico", "cudico"},
		{"cue", "cue"},
		{"cuentas", "cuenta"},
		{"cuero", "cuero"},
		{"cues", "cue"},
		{"cueva", "cueva"},
		{"cuff", "cuff"},
		{"cuffs", "cuff"},
		{"cuffy", "cuffi"},
		{"cufre", "cufr"},
		{"cul", "cul"},
		{"culpability", "culpabl"},
		{"culpeu", "culpeu"},
		{"culprit", "culprit"},
		{"cultivate", "cultiv"},
		{"cultivated", "cultiv"},
		{"cultivating", "cultiv"},
		{"cultivation", "cultiv"},
		{"culture", "cultur"},
		{"culver", "culver"},
		{"cum", "cum"},
		{"cumber", "cumber"},
		{"cumberland", "cumberland"},
		{"cumbre", "cumbr"},
		{"cumbrously", "cumbrous"},
		{"cumfbler", "cumfbler"},
		{"cumin", "cumin"},
		{"cuming", "cume"},
		{"cummin", "cummin"},
		{"cumnor", "cumnor"},
		{"cums", "cum"},
		{"cumuli", "cumuli"},
		{"cunicularia", "cunicularia"},
		{"cunicularius", "cunicularius"},
		{"cunning", "cun"},
		{"cunningest", "cunningest"},
		{"cunningly", "cun"},
		{"cup", "cup"},
		{"cupboard", "cupboard"},
		{"cupboards", "cupboard"},
		{"cupid", "cupid"},
		{"cupidity", "cupid"},
		{"cupids", "cupid"},
		{"cupola", "cupola"},
		{"cups", "cup"},
		{"cur", "cur"},
		{"cura", "cura"},
		{"curacy", "curaci"},
		{"curate", "curat"},
		{"curb", "curb"},
		{"curbed", "curb"},
		{"curdle", "curdl"},
		{"curds", "curd"},
		{"cure", "cure"},
		{"cured", "cure"},
		{"cures", "cure"},
		{"curing", "cure"},
		{"curiosities", "curios"},
		{"curiosity", "curios"},
		{"curious", "curious"},
		{"curiously", "curious"},
		{"curl", "curl"},
		{"curled", "curl"},
		{"curlew", "curlew"},
		{"curling", "curl"},
		{"curlings", "curl"},
		{"curls", "curl"},
		{"curly", "cur"},
		{"curmudgeon", "curmudgeon"},
		{"curragh", "curragh"},
		{"currant", "currant"},
		{"currants", "currant"},
		{"currency", "currenc"},
		{"current", "current"},
		{"currently", "current"},
		{"currents", "current"},
		{"curricle", "curricl"},
		{"curries", "curri"},
		{"curry", "curri"},
		{"curs", "cur"},
		{"curse", "curs"},
		{"cursed", "curs"},
		{"curses", "curs"},
		{"cursing", "curs"},
		{"cursitor", "cursitor"},
		{"cursory", "cursori"},
		{"curt", "curt"},
		{"curtain", "curtain"},
		{"curtained", "curtain"},
		{"curtaining", "curtain"},
		{"curtains", "curtain"},
		{"curtness", "curt"},
		{"curtsey", "curtsey"},
		{"curtseyed", "curtsey"},
		{"curtseying", "curtsey"},
		{"curtseys", "curtsey"},
		{"curtsied", "curtsi"},
		{"curtsy", "curtsi"},
		{"curtsying", "curtsi"},
		{"curtsys", "curtsi"},
		{"curvature", "curvatur"},
		{"curve", "curv"},
		{"curved", "curv"},
		{"curves", "curv"},
		{"curvidens", "curviden"},
		{"curving", "curv"},
		{"cushion", "cushion"},
		{"cushioned", "cushion"},
		{"cushioning", "cushion"},
		{"cushions", "cushion"},
		{"custodian", "custodian"},
		{"custodians", "custodian"},
		{"custody", "custodi"},
		{"custom", "custom"},
		{"customarily", "customarili"},
		{"customary", "customari"},
		{"customer", "custom"},
		{"customers", "custom"},
		{"customs", "custom"},
		{"cut", "cut"},
		{"cutaneous", "cutan"},
		{"cute", "cute"},
		{"cutlass", "cutlass"},
		{"cutler", "cutler"},
		{"cutlery", "cutleri"},
		{"cutlets", "cutlet"},
		{"cuts", "cut"},
		{"cutter", "cutter"},
		{"cutters", "cutter"},
		{"cutthroat", "cutthroat"},
		{"cutting", "cut"},
		{"cuttle", "cuttl"},
		{"cuvier", "cuvier"},
		{"cycle", "cycl"},
		{"cycles", "cycl"},
		{"cyclopean", "cyclopean"},
		{"cylinder", "cylind"},
		{"cylinders", "cylind"},
		{"cylindrical", "cylindr"},
		{"cymbal", "cymbal"},
		{"cymindis", "cymindi"},
		{"cynara", "cynara"},
		{"cynic", "cynic"},
		{"cynical", "cynic"},
		{"cynicism", "cynic"},
		{"cynucus", "cynucus"},
		{"cyperus", "cyperus"},
		{"cypress", "cypress"},
		{"cyprus", "cyprus"},
		{"cyrus", "cyrus"},
		{"cyttaria", "cyttaria"},
		{"d", "d"},
		{"da", "da"},
		{"daark", "daark"},
		{"dab", "dab"},
		{"dabber", "dabber"},
		{"dabbing", "dab"},
		{"dabbled", "dabbl"},
		{"dabblers", "dabbler"},
		{"dabbling", "dabbl"},
		{"dabs", "dab"},
		{"dacelo", "dacelo"},
		{"dacia", "dacia"},
		{"dadass", "dadass"},
		{"daft", "daft"},
		{"dagestan", "dagestan"},
		{"dagger", "dagger"},
		{"daggers", "dagger"},
		{"dail", "dail"},
		{"daily", "daili"},
		{"dainties", "dainti"},
		{"daintily", "daintili"},
		{"dainty", "dainti"},
		{"dairy", "dairi"},
		{"dais", "dai"},
		{"daisy", "daisi"},
		{"dale", "dale"},
		{"dalliance", "dallianc"},
		{"dallied", "dalli"},
		{"dally", "dalli"},
		{"damage", "damag"},
		{"damaged", "damag"},
		{"damages", "damag"},
		{"damaging", "damag"},
		{"damask", "damask"},
		{"dame", "dame"},
		{"dames", "dame"},
		{"damme", "damm"},
		{"dammed", "dam"},
		{"damn", "damn"},
		{"damnable", "damnabl"},
		{"damnably", "damnabl"},
		{"damnation", "damnat"},
		{"damnatory", "damnatori"},
		{"damned", "damn"},
		{"damp", "damp"},
		{"damped", "damp"},
		{"damper", "damper"},
		{"dampest", "dampest"},
		{"dampier", "dampier"},
		{"damping", "damp"},
		{"dampness", "damp"},
		{"damsel", "damsel"},
		{"damsels", "damsel"},
		{"dan", "dan"},
		{"dance", "danc"},
		{"danced", "danc"},
		{"dancer", "dancer"},
		{"dancers", "dancer"},
		{"dances", "danc"},
		{"dancing", "danc"},
		{"dancings", "danc"},
		{"dandified", "dandifi"},
		{"dandling", "dandl"},
		{"dandy", "dandi"},
		{"dandyism", "dandyism"},
		{"dang", "dang"},
		{"danger", "danger"},
		{"dangerous", "danger"},
		{"dangerously", "danger"},
		{"dangers", "danger"},
		{"dangle", "dangl"},
		{"dangling", "dangl"},
		{"daniel", "daniel"},
		{"daniell", "daniel"},
		{"dank", "dank"},
		{"danke", "dank"},
		{"dans", "dan"},
		{"danse", "dans"},
		{"dante", "dant"},
		{"dapibus", "dapibus"},
		{"darby", "darbi"},
		{"dare", "dare"},
		{"dared", "dare"},
		{"daren", "daren"},
		{"dares", "dare"},
		{"daresay", "daresay"},
		{"daring", "dare"},
		{"dark", "dark"},
		{"darken", "darken"},
		{"darkened", "darken"},
		{"darkening", "darken"},
		{"darkens", "darken"},
		{"darker", "darker"},
		{"darkest", "darkest"},
		{"darkly", "dark"},
		{"darkness", "dark"},
		{"darling", "darl"},
		{"darlings", "darl"},
		{"darn", "darn"},
		{"darned", "darn"},
		{"darning", "darn"},
		{"dart", "dart"},
		{"darted", "dart"},
		{"darting", "dart"},
		{"darts", "dart"},
		{"darwin", "darwin"},
		{"darwinian", "darwinian"},
		{"darwinii", "darwinii"},
		{"darya", "darya"},
		{"das", "das"},
		{"dash", "dash"},
		{"dashed", "dash"},
		{"dashes", "dash"},
		{"dashing", "dash"},
		{"dastard", "dastard"},
		{"dastardly", "dastard"},
		{"dasypus", "dasypus"},
		{"data", "data"},
		{"date", "date"},
		{"dated", "date"},
		{"dates", "date"},
		{"dating", "date"},
		{"daubed", "daub"},
		{"daubeny", "daubeni"},
		{"daubney", "daubney"},
		{"daughter", "daughter"},
		{"daughters", "daughter"},
		{"daunt", "daunt"},
		{"daunted", "daunt"},
		{"daverous", "daver"},
		{"david", "david"},
		{"davies", "davi"},
		{"davis", "davi"},
		{"davy", "davi"},
		{"dawdle", "dawdl"},
		{"dawdling", "dawdl"},
		{"dawlish", "dawlish"},
		{"dawn", "dawn"},
		{"dawned", "dawn"},
		{"dawning", "dawn"},
		{"dawns", "dawn"},
		{"day", "day"},
		{"daybreak", "daybreak"},
		{"daylight", "daylight"},
		{"days", "day"},
		{"daytime", "daytim"},
		{"dayvle", "dayvl"},
		{"dazed", "daze"},
		{"dazzle", "dazzl"},
		{"dazzled", "dazzl"},
		{"dazzler", "dazzler"},
		{"dazzling", "dazzl"},
		{"dcar", "dcar"},
		{"de", "de"},
		{"dea", "dea"},
		{"dead", "dead"},
		{"deaden", "deaden"},
		{"deadened", "deaden"},
		{"deadens", "deaden"},
		{"deadliest", "deadliest"},
		{"deadlock", "deadlock"},
		{"deadly", "dead"},
		{"deadwood", "deadwood"},
		{"deaf", "deaf"},
		{"deafen", "deafen"},
		{"deafening", "deafen"},
		{"deafness", "deaf"},
		{"deal", "deal"},
		{"dealer", "dealer"},
		{"dealers", "dealer"},
		{"dealing", "deal"},
		{"dealings", "deal"},
		{"dealt", "dealt"},
		{"dean", "dean"},
		{"deane", "dean"},
		{"deans", "dean"},
		{"dear", "dear"},
		{"dearer", "dearer"},
		{"dearest", "dearest"},
		{"dearly", "dear"},
		{"dears", "dear"},
		{"dearth", "dearth"},
		{"dease", "deas"},
		{"death", "death"},
		{"deathbed", "deathb"},
		{"deathless", "deathless"},
		{"deathlike", "deathlik"},
		{"deathly", "death"},
		{"deaths", "death"},
		{"debacle", "debacl"},
		{"debar", "debar"},
		{"debarred", "debar"},
		{"debase", "debas"},
		{"debased", "debas"},
		{"debasement", "debas"},
		{"debasing", "debas"},
		{"debate", "debat"},
		{"debated", "debat"},
		{"debater", "debat"},
		{"debates", "debat"},
		{"debating", "debat"},
		{"debauch", "debauch"},
		{"debauchery", "debaucheri"},
		{"debilitated", "debilit"},
		{"debility", "debil"},
		{"debris", "debri"},
		{"debt", "debt"},
		{"debtor", "debtor"},
		{"debtors", "debtor"},
		{"debts", "debt"},
		{"dec", "dec"},
		{"decamp", "decamp"},
		{"decamped", "decamp"},
		{"decanter", "decant"},
		{"decanters", "decant"},
		{"decapitated", "decapit"},
		{"decay", "decay"},
		{"decayed", "decay"},
		{"decaying", "decay"},
		{"decease", "deceas"},
		{"deceased", "deceas"},
		{"deceit", "deceit"},
		{"deceitful", "deceit"},
		{"deceitfulness", "deceit"},
		{"deceive", "deceiv"},
		{"deceived", "deceiv"},
		{"deceivers", "deceiv"},
		{"deceives", "deceiv"},
		{"deceiving", "deceiv"},
		{"december", "decemb"},
		{"decencies", "decenc"},
		{"decency", "decenc"},
		{"decent", "decent"},
		{"decently", "decent"},
		{"deception", "decept"},
		{"deceptions", "decept"},
		{"deceptive", "decept"},
		{"decide", "decid"},
		{"decided", "decid"},
		{"decidedly", "decid"},
		{"decides", "decid"},
		{"deciding", "decid"},
		{"deciduous", "decidu"},
		{"decimal", "decim"},
		{"decimals", "decim"},
		{"decipher", "deciph"},
		{"deciphered", "deciph"},
		{"deciphering", "deciph"},
		{"decision", "decis"},
		{"decisions", "decis"},
		{"decisive", "decis"},
		{"decisively", "decis"},
		{"deck", "deck"},
		{"decked", "deck"},
		{"decking", "deck"},
		{"declaim", "declaim"},
		{"declaimed", "declaim"},
		{"declamation", "declam"},
		{"declaration", "declar"},
		{"declarations", "declar"},
		{"declaratory", "declaratori"},
		{"declare", "declar"},
		{"declared", "declar"},
		{"declares", "declar"},
		{"declaring", "declar"},
		{"decline", "declin"},
		{"declined", "declin"},
		{"declines", "declin"},
		{"declining", "declin"},
		{"decompose", "decompos"},
		{"decomposed", "decompos"},
		{"decomposing", "decompos"},
		{"decomposition", "decomposit"},
		{"decorate", "decor"},
		{"decorated", "decor"},
		{"decorates", "decor"},
		{"decoration", "decor"},
		{"decorations", "decor"},
		{"decorative", "decor"},
		{"decorous", "decor"},
		{"decorously", "decor"},
		{"decorum", "decorum"},
		{"decoy", "decoy"},
		{"decrease", "decreas"},
		{"decreased", "decreas"},
		{"decreasing", "decreas"},
		{"decree", "decre"},
		{"decreed", "decre"},
		{"decrees", "decre"},
		{"decrepit", "decrepit"},
		{"decrepitude", "decrepitud"},
		{"dedicated", "dedic"},
		{"dedlock", "dedlock"},
		{"dedlocks", "dedlock"},
		{"deduced", "deduc"},
		{"deducible", "deduc"},
		{"deduct", "deduct"},
		{"deducted", "deduct"},
		{"deducting", "deduct"},
		{"deduction", "deduct"},
		{"deductions", "deduct"},
		{"dee", "dee"},
		{"deead", "deead"},
		{"deed", "deed"},
		{"deedn", "deedn"},
		{"deeds", "deed"},
		{"deein", "deein"},
		{"deem", "deem"},
		{"deemed", "deem"},
		{"deeming", "deem"},
		{"deems", "deem"},
		{"deep", "deep"},
		{"deepen", "deepen"},
		{"deepened", "deepen"},
		{"deepening", "deepen"},
		{"deepens", "deepen"},
		{"deeper", "deeper"},
		{"deepest", "deepest"},
		{"deeply", "deepli"},
		{"deer", "deer"},
		{"deering", "deer"},
		{"defacing", "defac"},
		{"defalcation", "defalc"},
		{"default", "default"},
		{"defeat", "defeat"},
		{"defeated", "defeat"},
		{"defect", "defect"},
		{"defection", "defect"},
		{"defective", "defect"},
		{"defects", "defect"},
		{"defence", "defenc"},
		{"defenceless", "defenceless"},
		{"defend", "defend"},
		{"defendant", "defend"},
		{"defendants", "defend"},
		{"defended", "defend"},
		{"defenders", "defend"},
		{"defending", "defend"},
		{"defer", "defer"},
		{"deference", "defer"},
		{"deferential", "deferenti"},
		{"deferentially", "deferenti"},
		{"deferred", "defer"},
		{"deferring", "defer"},
		{"defers", "defer"},
		{"defiance", "defianc"},
		{"defiances", "defianc"},
		{"defiant", "defiant"},
		{"defiantly", "defiant"},
		{"deficiencies", "defici"},
		{"deficiency", "defici"},
		{"deficient", "defici"},
		{"defied", "defi"},
		{"defies", "defi"},
		{"defile", "defil"},
		{"defiled", "defil"},
		{"defiles", "defil"},
		{"define", "defin"},
		{"defined", "defin"},
		{"defining", "defin"},
		{"definite", "definit"},
		{"definitely", "definit"},
		{"definition", "definit"},
		{"definitions", "definit"},
		{"definitively", "definit"},
		{"deflected", "deflect"},
		{"deflecting", "deflect"},
		{"deformed", "deform"},
		{"deformities", "deform"},
		{"deformity", "deform"},
		{"defrauded", "defraud"},
		{"defrauding", "defraud"},
		{"defray", "defray"},
		{"defrayed", "defray"},
		{"defraying", "defray"},
		{"deftly", "deft"},
		{"defunct", "defunct"},
		{"defy", "defi"},
		{"defying", "defi"},
		{"degage", "degag"},
		{"degenerate", "degener"},
		{"degenerated", "degener"},
		{"degenerating", "degener"},
		{"degeneration", "degener"},
		{"degradation", "degrad"},
		{"degrade", "degrad"},
		{"degraded", "degrad"},
		{"degrading", "degrad"},
		{"degree", "degre"},
		{"degrees", "degre"},
		{"degs", "deg"},
		{"deified", "deifi"},
		{"deigned", "deign"},
		{"deigning", "deign"},
		{"deinornis", "deinorni"},
		{"deity", "deiti"},
		{"dejected", "deject"},
		{"dejectedly", "deject"},
		{"dejection", "deject"},
		{"del", "del"},
		{"delaval", "delav"},
		{"delavals", "delav"},
		{"delay", "delay"},
		{"delayed", "delay"},
		{"delaying", "delay"},
		{"delays", "delay"},
		{"delectable", "delect"},
		{"delegates", "deleg"},
		{"deleterious", "deleteri"},
		{"deliberate", "deliber"},
		{"deliberated", "deliber"},
		{"deliberately", "deliber"},
		{"deliberating", "deliber"},
		{"deliberation", "deliber"},
		{"deliberations", "deliber"},
		{"delicacies", "delicaci"},
		{"delicacy", "delicaci"},
		{"delicate", "delic"},
		{"delicately", "delic"},
		{"delicater", "delicat"},
		{"delicious", "delici"},
		{"deliciously", "delici"},
		{"delight", "delight"},
		{"delighted", "delight"},
		{"delightful", "delight"},
		{"delightfully", "delight"},
		{"delighting", "delight"},
		{"delights", "delight"},
		{"delinquency", "delinqu"},
		{"deliquescent", "deliquesc"},
		{"delirious", "deliri"},
		{"deliriously", "deliri"},
		{"delirium", "delirium"},
		{"deliver", "deliv"},
		{"deliverance", "deliver"},
		{"delivered", "deliv"},
		{"deliverer", "deliver"},
		{"delivering", "deliv"},
		{"delivers", "deliv"},
		{"delivery", "deliveri"},
		{"delude", "delud"},
		{"deluded", "delud"},
		{"deludes", "delud"},
		{"deluding", "delud"},
		{"deluge", "delug"},
		{"deluges", "delug"},
		{"delusion", "delus"},
		{"delusions", "delus"},
		{"delusive", "delus"},
		{"delving", "delv"},
		{"dem", "dem"},
		{"demagogue", "demagogu"},
		{"demand", "demand"},
		{"demanded", "demand"},
		{"demanding", "demand"},
		{"demands", "demand"},
		{"demarlii", "demarlii"},
		{"demd", "demd"},
		{"demder", "demder"},
		{"demdest", "demdest"},
		{"demeaning", "demean"},
		{"demeanour", "demeanour"},
		{"demented", "dement"},
		{"dementyev", "dementyev"},
		{"demerits", "demerit"},
		{"demersa", "demersa"},
		{"demi", "demi"},
		{"demigods", "demigod"},
		{"demmit", "demmit"},
		{"demneble", "demnebl"},
		{"demnebly", "demnebl"},
		{"demnition", "demnit"},
		{"democracy", "democraci"},
		{"democratic", "democrat"},
		{"demolished", "demolish"},
		{"demolition", "demolit"},
		{"demon", "demon"},
		{"demoniacs", "demoniac"},
		{"demons", "demon"},
		{"demonstrate", "demonstr"},
		{"demonstrated", "demonstr"},
		{"demonstrates", "demonstr"},
		{"demonstration", "demonstr"},
		{"demonstrations", "demonstr"},
		{"demonstrative", "demonstr"},
		{"demoralisation", "demoralis"},
		{"demoralize", "demor"},
		{"demoralized", "demor"},
		{"demur", "demur"},
		{"demure", "demur"},
		{"demurely", "demur"},
		{"demurred", "demur"},
		{"den", "den"},
		{"denial", "denial"},
		{"denied", "deni"},
		{"denies", "deni"},
		{"denizens", "denizen"},
		{"denmark", "denmark"},
		{"dennison", "dennison"},
		{"denominated", "denomin"},
		{"denomination", "denomin"},
		{"denominations", "denomin"},
		{"denote", "denot"},
		{"denoted", "denot"},
		{"denotes", "denot"},
		{"denoting", "denot"},
		{"denouement", "denouement"},
		{"denounce", "denounc"},
		{"denounced", "denounc"},
		{"denouncing", "denounc"},
		{"dens", "den"},
		{"dense", "dens"},
		{"densely", "dens"},
		{"denser", "denser"},
		{"densest", "densest"},
		{"density", "densiti"},
		{"dent", "dent"},
		{"dentist", "dentist"},
		{"dentistical", "dentist"},
		{"denudation", "denud"},
		{"denuded", "denud"},
		{"denuding", "denud"},
		{"denunciation", "denunci"},
		{"denunciations", "denunci"},
		{"deny", "deni"},
		{"denying", "deni"},
		{"deodara", "deodara"},
		{"deos", "deo"},
		{"depairture", "depairtur"},
		{"depart", "depart"},
		{"departed", "depart"},
		{"departing", "depart"},
		{"department", "depart"},
		{"departs", "depart"},
		{"departure", "departur"},
		{"departures", "departur"},
		{"depend", "depend"},
		{"dependant", "depend"},
		{"dependants", "depend"},
		{"depended", "depend"},
		{"dependence", "depend"},
		{"dependencies", "depend"},
		{"dependent", "depend"},
		{"dependents", "depend"},
		{"depending", "depend"},
		{"depends", "depend"},
		{"depict", "depict"},
		{"depicted", "depict"},
		{"depicter", "depict"},
		{"depicts", "depict"},
		{"deplorable", "deplor"},
		{"deplorably", "deplor"},
		{"deplore", "deplor"},
		{"deplored", "deplor"},
		{"deploring", "deplor"},
		{"deploy", "deploy"},
		{"deport", "deport"},
		{"deportation", "deport"},
		{"deporting", "deport"},
		{"deportment", "deport"},
		{"depose", "depos"},
		{"deposed", "depos"},
		{"deposer", "depos"},
		{"deposit", "deposit"},
		{"deposited", "deposit"},
		{"depositing", "deposit"},
		{"deposition", "deposit"},
		{"depository", "depositori"},
		{"deposits", "deposit"},
		{"depraved", "deprav"},
		{"depraving", "deprav"},
		{"depravity", "deprav"},
		{"deprecating", "deprec"},
		{"deprecation", "deprec"},
		{"depreciate", "depreci"},
		{"depreciated", "depreci"},
		{"depreciating", "depreci"},
		{"depreciation", "depreci"},
		{"depress", "depress"},
		{"depressed", "depress"},
		{"depresses", "depress"},
		{"depressing", "depress"},
		{"depression", "depress"},
		{"depressions", "depress"},
		{"deprivation", "depriv"},
		{"deprive", "depriv"},
		{"deprived", "depriv"},
		{"deprives", "depriv"},
		{"depriving", "depriv"},
		{"deptford", "deptford"},
		{"depth", "depth"},
		{"depths", "depth"},
		{"deputation", "deput"},
		{"deputations", "deput"},
		{"depute", "deput"},
		{"deputed", "deput"},
		{"deputies", "deputi"},
		{"deputy", "deputi"},
		{"der", "der"},
		{"deranged", "derang"},
		{"derangement", "derang"},
		{"derby", "derbi"},
		{"derided", "derid"},
		{"derision", "deris"},
		{"derisive", "deris"},
		{"derisively", "deris"},
		{"derivable", "deriv"},
		{"derivation", "deriv"},
		{"derive", "deriv"},
		{"derived", "deriv"},
		{"derives", "deriv"},
		{"deriving", "deriv"},
		{"dermestes", "dermest"},
		{"derogatory", "derogatori"},
		{"derwent", "derwent"},
		{"des", "des"},
		{"desc", "desc"},
		{"descanted", "descant"},
		{"descanting", "descant"},
		{"descen", "descen"},
		{"descend", "descend"},
		{"descendant", "descend"},
		{"descendants", "descend"},
		{"descended", "descend"},
		{"descendin", "descendin"},
		{"descending", "descend"},
		{"descends", "descend"},
		{"descent", "descent"},
		{"describe", "describ"},
		{"described", "describ"},
		{"describes", "describ"},
		{"describing", "describ"},
		{"descried", "descri"},
		{"descries", "descri"},
		{"descrip", "descrip"},
		{"description", "descript"},
		{"descriptions", "descript"},
		{"descriptive", "descript"},
		{"descripts", "descript"},
		{"descry", "descri"},
		{"desert", "desert"},
		{"deserted", "desert"},
		{"deserting", "desert"},
		{"desertion", "desert"},
		{"deserts", "desert"},
		{"deserve", "deserv"},
		{"deserved", "deserv"},
		{"deservedly", "deserv"},
		{"deserves", "deserv"},
		{"deserving", "deserv"},
		{"design", "design"},
		{"designates", "design"},
		{"designation", "design"},
		{"designed", "design"},
		{"designer", "design"},
		{"designing", "design"},
		{"designs", "design"},
		{"desirable", "desir"},
		{"desire", "desir"},
		{"desired", "desir"},
		{"desires", "desir"},
		{"desiring", "desir"},
		{"desirous", "desir"},
		{"desist", "desist"},
		{"desisted", "desist"},
		{"desists", "desist"},
		{"desk", "desk"},
		{"desks", "desk"},
		{"desmodus", "desmodus"},
		{"desolate", "desol"},
		{"desolated", "desol"},
		{"desolately", "desol"},
		{"desolateness", "desol"},
		{"desolation", "desol"},
		{"desolee", "desole"},
		{"despair", "despair"},
		{"despaired", "despair"},
		{"despairing", "despair"},
		{"despairingly", "despair"},
		{"despairs", "despair"},
		{"despatch", "despatch"},
		{"despatched", "despatch"},
		{"desperate", "desper"},
		{"desperately", "desper"},
		{"desperation", "desper"},
		{"despicable", "despic"},
		{"despicably", "despic"},
		{"despise", "despis"},
		{"despised", "despis"},
		{"despises", "despis"},
		{"despising", "despis"},
		{"despite", "despit"},
		{"despoblado", "despoblado"},
		{"despoil", "despoil"},
		{"despoiled", "despoil"},
		{"despond", "despond"},
		{"desponded", "despond"},
		{"despondence", "despond"},
		{"despondency", "despond"},
		{"despondent", "despond"},
		{"despondently", "despond"},
		{"desponding", "despond"},
		{"despondingly", "despond"},
		{"despot", "despot"},
		{"despotic", "despot"},
		{"despotism", "despot"},
		{"dessert", "dessert"},
		{"desserts", "dessert"},
		{"destination", "destin"},
		{"destinction", "destinct"},
		{"destined", "destin"},
		{"destinies", "destini"},
		{"destiny", "destini"},
		{"destitute", "destitut"},
		{"destitution", "destitut"},
		{"destro", "destro"},
		{"destroy", "destroy"},
		{"destroyed", "destroy"},
		{"destroyer", "destroy"},
		{"destroyers", "destroy"},
		{"destroying", "destroy"},
		{"destroys", "destroy"},
		{"destruction", "destruct"},
		{"destructive", "destruct"},
		{"desultory", "desultori"},
		{"det", "det"},
		{"detach", "detach"},
		{"detached", "detach"},
		{"detaches", "detach"},
		{"detachment", "detach"},
		{"detail", "detail"},
		{"detailed", "detail"},
		{"details", "detail"},
		{"detain", "detain"},
		{"detained", "detain"},
		{"detainer", "detain"},
		{"detaining", "detain"},
		{"detect", "detect"},
		{"detected", "detect"},
		{"detecting", "detect"},
		{"detection", "detect"},
		{"detective", "detect"},
		{"detects", "detect"},
		{"detenined", "detenin"},
		{"detention", "detent"},
		{"deter", "deter"},
		{"deteriorate", "deterior"},
		{"deteriorated", "deterior"},
		{"deteriorating", "deterior"},
		{"determination", "determin"},
		{"determine", "determin"},
		{"determined", "determin"},
		{"determines", "determin"},
		{"determining", "determin"},
		{"deterred", "deter"},
		{"detest", "detest"},
		{"detestable", "detest"},
		{"detestation", "detest"},
		{"detested", "detest"},
		{"detesting", "detest"},
		{"dethronement", "dethron"},
		{"detour", "detour"},
		{"detract", "detract"},
		{"detriment", "detriment"},
		{"detrimental", "detriment"},
		{"detritus", "detritus"},
		{"deuce", "deuc"},
		{"deuced", "deuc"},
		{"deum", "deum"},
		{"deus", "deus"},
		{"deux", "deux"},
		{"devastate", "devast"},
		{"devastation", "devast"},
		{"develop", "develop"},
		{"developed", "develop"},
		{"developes", "develop"},
		{"developing", "develop"},
		{"development", "develop"},
		{"develops", "develop"},
		{"deviated", "deviat"},
		{"deviation", "deviat"},
		{"device", "devic"},
		{"devices", "devic"},
		{"devil", "devil"},
		{"devilish", "devilish"},
		{"devilry", "devilri"},
		{"devils", "devil"},
		{"devious", "devious"},
		{"devise", "devis"},
		{"devised", "devis"},
		{"deviser", "devis"},
		{"devising", "devis"},
		{"devoid", "devoid"},
		{"devoir", "devoir"},
		{"devolved", "devolv"},
		{"devolves", "devolv"},
		{"devon", "devon"},
		{"devonian", "devonian"},
		{"devonport", "devonport"},
		{"devonshire", "devonshir"},
		{"devote", "devot"},
		{"devoted", "devot"},
		{"devotedly", "devot"},
		{"devotedness", "devoted"},
		{"devotes", "devot"},
		{"devoting", "devot"},
		{"devotion", "devot"},
		{"devotions", "devot"},
		{"devour", "devour"},
		{"devoured", "devour"},
		{"devourers", "devour"},
		{"devouring", "devour"},
		{"devout", "devout"},
		{"devoutly", "devout"},
		{"dew", "dew"},
		{"dewdrop", "dewdrop"},
		{"dewdrops", "dewdrop"},
		{"deweloping", "dewelop"},
		{"dewiness", "dewi"},
		{"dews", "dew"},
		{"dewy", "dewi"},
		{"dexterity", "dexter"},
		{"dexterous", "dexter"},
		{"dexterously", "dexter"},
		{"dey", "dey"},
		{"deyvle", "deyvl"},
		{"deyvlish", "deyvlish"},
		{"di", "di"},
		{"diabolical", "diabol"},
		{"diabolicus", "diabolicus"},
		{"diagnosed", "diagnos"},
		{"diagonal", "diagon"},
		{"dial", "dial"},
		{"dialect", "dialect"},
		{"dialects", "dialect"},
		{"dialogue", "dialogu"},
		{"dialogues", "dialogu"},
		{"dials", "dial"},
		{"diamanten", "diamanten"},
		{"diameter", "diamet"},
		{"diametrically", "diametr"},
		{"diamond", "diamond"},
		{"diamonds", "diamond"},
		{"dianaea", "dianaea"},
		{"diaphragm", "diaphragm"},
		{"diappointments", "diappoint"},
		{"diaries", "diari"},
		{"diary", "diari"},
		{"diatribes", "diatrib"},
		{"dibabs", "dibab"},
		{"dibabses", "dibabs"},
		{"dick", "dick"},
		{"dickens", "dicken"},
		{"dicks", "dick"},
		{"dictate", "dictat"},
		{"dictated", "dictat"},
		{"dictates", "dictat"},
		{"dictating", "dictat"},
		{"dictation", "dictat"},
		{"dictator", "dictat"},
		{"dictatorial", "dictatori"},
		{"dictionary", "dictionari"},
		{"dictum", "dictum"},
		{"did", "did"},
		{"diddler", "diddler"},
		{"didelphis", "didelphi"},
		{"didn", "didn"},
		{"didst", "didst"},
		{"die", "die"},
		{"died", "die"},
		{"dieffenbach", "dieffenbach"},
		{"diego", "diego"},
		{"dieman", "dieman"},
		{"diemen", "diemen"},
		{"diernan", "diernan"},
		{"dies", "die"},
		{"diet", "diet"},
		{"differ", "differ"},
		{"differed", "differ"},
		{"difference", "differ"},
		{"differences", "differ"},
		{"different", "differ"},
		{"differently", "differ"},
		{"differing", "differ"},
		{"differs", "differ"},
		{"difficult", "difficult"},
		{"difficulties", "difficulti"},
		{"difficulty", "difficulti"},
		{"diffidence", "diffid"},
		{"diffident", "diffid"},
		{"diffidently", "diffid"},
		{"diffused", "diffus"},
		{"diffusing", "diffus"},
		{"diffusion", "diffus"},
		{"dig", "dig"},
		{"digby", "digbi"},
		{"diges", "dige"},
		{"digest", "digest"},
		{"digester", "digest"},
		{"digestio", "digestio"},
		{"digestion", "digest"},
		{"digestive", "digest"},
		{"digger", "digger"},
		{"digging", "dig"},
		{"digitated", "digit"},
		{"digitatus", "digitatus"},
		{"dignified", "dignifi"},
		{"dignities", "digniti"},
		{"dignity", "digniti"},
		{"digression", "digress"},
		{"dilapidated", "dilapid"},
		{"dilapidation", "dilapid"},
		{"dilatation", "dilat"},
		{"dilate", "dilat"},
		{"dilated", "dilat"},
		{"dilates", "dilat"},
		{"dilating", "dilat"},
		{"dilatory", "dilatori"},
		{"dilemma", "dilemma"},
		{"dilettanti", "dilettanti"},
		{"diligence", "dilig"},
		{"diligent", "dilig"},
		{"diligently", "dilig"},
		{"diluted", "dilut"},
		{"dim", "dim"},
		{"dimension", "dimens"},
		{"dimensions", "dimens"},
		{"diminish", "diminish"},
		{"diminished", "diminish"},
		{"diminishes", "diminish"},
		{"diminishing", "diminish"},
		{"diminution", "diminut"},
		{"diminutive", "diminut"},
		{"dimity", "dimiti"},
		{"dimly", "dim"},
		{"dimmed", "dim"},
		{"dimple", "dimpl"},
		{"dimpled", "dimpl"},
		{"dimpling", "dimpl"},
		{"din", "din"},
		{"dine", "dine"},
		{"dined", "dine"},
		{"dines", "dine"},
		{"ding", "ding"},
		{"dingey", "dingey"},
		{"dingleby", "dinglebi"},
		{"dingo", "dingo"},
		{"dingy", "dingi"},
		{"dining", "dine"},
		{"dinner", "dinner"},
		{"dinners", "dinner"},
		{"dinnot", "dinnot"},
		{"dint", "dint"},
		{"diocese", "dioces"},
		{"diodon", "diodon"},
		{"diopaea", "diopaea"},
		{"diorgeenes", "diorgeen"},
		{"dios", "dio"},
		{"dip", "dip"},
		{"diplomacy", "diplomaci"},
		{"diplomatic", "diplomat"},
		{"diplomatical", "diplomat"},
		{"diplomats", "diplomat"},
		{"dipped", "dip"},
		{"dipping", "dip"},
		{"dips", "dip"},
		{"diptera", "diptera"},
		{"dire", "dire"},
		{"direcfly", "direcfli"},
		{"direct", "direct"},
		{"directed", "direct"},
		{"directing", "direct"},
		{"direction", "direct"},
		{"directions", "direct"},
		{"directly", "direct"},
		{"director", "director"},
		{"directors", "director"},
		{"directory", "directori"},
		{"directress", "directress"},
		{"directs", "direct"},
		{"direfully", "dire"},
		{"dirt", "dirt"},
		{"dirtied", "dirti"},
		{"dirtier", "dirtier"},
		{"dirtiest", "dirtiest"},
		{"dirty", "dirti"},
		{"disable", "disabl"},
		{"disabled", "disabl"},
		{"disadvantage", "disadvantag"},
		{"disadvantages", "disadvantag"},
		{"disagree", "disagre"},
		{"disagreeable", "disagre"},
		{"disagreeably", "disagre"},
		{"disagreed", "disagre"},
		{"disagreeing", "disagre"},
		{"disagreement", "disagr"},
		{"disappear", "disappear"},
		{"disappearance", "disappear"},
		{"disappeared", "disappear"},
		{"disappearing", "disappear"},
		{"disappears", "disappear"},
		{"disappoint", "disappoint"},
		{"disappointed", "disappoint"},
		{"disappointing", "disappoint"},
		{"disappointment", "disappoint"},
		{"disappointments", "disappoint"},
		{"disappoints", "disappoint"},
		{"disapprobation", "disapprob"},
		{"disapproval", "disapprov"},
		{"disapprove", "disapprov"},
		{"disapproved", "disapprov"},
		{"disapproves", "disapprov"},
		{"disapproving", "disapprov"},
		{"disarm", "disarm"},
		{"disarmed", "disarm"},
		{"disarming", "disarm"},
		{"disarranged", "disarrang"},
		{"disarrangement", "disarrang"},
		{"disarray", "disarray"},
		{"disaster", "disast"},
		{"disastrous", "disastr"},
		{"disavow", "disavow"},
		{"disavowal", "disavow"},
		{"disavowals", "disavow"},
		{"disband", "disband"},
		{"disbelief", "disbelief"},
		{"disbelieve", "disbeliev"},
		{"disbelieved", "disbeliev"},
		{"disbelieving", "disbeliev"},
		{"discard", "discard"},
		{"discarded", "discard"},
		{"discern", "discern"},
		{"discerned", "discern"},
		{"discernible", "discern"},
		{"discerning", "discern"},
		{"discernment", "discern"},
		{"discharge", "discharg"},
		{"discharged", "discharg"},
		{"discharges", "discharg"},
		{"discharging", "discharg"},
		{"disciples", "discipl"},
		{"disciplinary", "disciplinari"},
		{"discipline", "disciplin"},
		{"disciplined", "disciplin"},
		{"disciplining", "disciplin"},
		{"disclaimed", "disclaim"},
		{"disclose", "disclos"},
		{"disclosed", "disclos"},
		{"disclosing", "disclos"},
		{"disclosure", "disclosur"},
		{"disclosures", "disclosur"},
		{"discoloration", "discolor"},
		{"discoloured", "discolour"},
		{"discolouring", "discolour"},
		{"discomfited", "discomfit"},
		{"discomfiture", "discomfitur"},
		{"discomfort", "discomfort"},
		{"discomforts", "discomfort"},
		{"discompose", "discompos"},
		{"discomposed", "discompos"},
		{"discomposure", "discomposur"},
		{"disconcert", "disconcert"},
		{"disconcerted", "disconcert"},
		{"disconnected", "disconnect"},
		{"disconsolate", "disconsol"},
		{"disconsolately", "disconsol"},
		{"discontended", "discontend"},
		{"discontent", "discont"},
		{"discontented", "discont"},
		{"discontentedly", "discont"},
		{"discontinuance", "discontinu"},
		{"discontinue", "discontinu"},
		{"discontinued", "discontinu"},
		{"discord", "discord"},
		{"discordant", "discord"},
		{"discordantly", "discord"},
		{"discords", "discord"},
		{"discount", "discount"},
		{"discountenanced", "discountenanc"},
		{"discounters", "discount"},
		{"discounting", "discount"},
		{"discourage", "discourag"},
		{"discouraged", "discourag"},
		{"discouragement", "discourag"},
		{"discourages", "discourag"},
		{"discouraging", "discourag"},
		{"discourse", "discours"},
		{"discoursed", "discours"},
		{"discourses", "discours"},
		{"discoursing", "discours"},
		{"discourteous", "discourt"},
		{"discourtesy", "discourtesi"},
		{"discover", "discov"},
		{"discoverable", "discover"},
		{"discovered", "discov"},
		{"discoverer", "discover"},
		{"discoverers", "discover"},
		{"discoveries", "discoveri"},
		{"discoverin", "discoverin"},
		{"discovering", "discov"},
		{"discovers", "discov"},
		{"discovery", "discoveri"},
		{"discredit", "discredit"},
		{"discreditable", "discredit"},
		{"discreet", "discreet"},
		{"discreetest", "discreetest"},
		{"discreetly", "discreet"},
		{"discretion", "discret"},
		{"discriminate", "discrimin"},
		{"discrimination", "discrimin"},
		{"discursive", "discurs"},
		{"discuss", "discuss"},
		{"discussed", "discuss"},
		{"discusses", "discuss"},
		{"discussing", "discuss"},
		{"discussion", "discuss"},
		{"discussions", "discuss"},
		{"disdain", "disdain"},
		{"disdained", "disdain"},
		{"disdainful", "disdain"},
		{"disdainfully", "disdain"},
		{"disdaining", "disdain"},
		{"disease", "diseas"},
		{"diseased", "diseas"},
		{"diseases", "diseas"},
		{"disembarrassed", "disembarrass"},
		{"disenchanted", "disench"},
		{"disenchantment", "disenchant"},
		{"disengage", "disengag"},
		{"disengaged", "disengag"},
		{"disengages", "disengag"},
		{"disengaging", "disengag"},
		{"disentangle", "disentangl"},
		{"disentangles", "disentangl"},
		{"disestablished", "disestablish"},
		{"disfavour", "disfavour"},
		{"disfigured", "disfigur"},
		{"disfigurement", "disfigur"},
		{"disfigurements", "disfigur"},
		{"disgorged", "disgorg"},
		{"disgorging", "disgorg"},
		{"disgrace", "disgrac"},
		{"disgraced", "disgrac"},
		{"disgraceful", "disgrac"},
		{"disgraces", "disgrac"},
		{"disgracing", "disgrac"},
		{"disguise", "disguis"},
		{"disguised", "disguis"},
		{"disguises", "disguis"},
		{"disguising", "disguis"},
		{"disgust", "disgust"},
		{"disgusted", "disgust"},
		{"disgusting", "disgust"},
		{"disgustingly", "disgust"},
		{"disgusts", "disgust"},
		{"dish", "dish"},
		{"dishabille", "dishabill"},
		{"disheartened", "dishearten"},
		{"disheartening", "dishearten"},
		{"dished", "dish"},
		{"dishes", "dish"},
		{"dishevelled", "dishevel"},
		{"dishonest", "dishonest"},
		{"dishonestly", "dishonest"},
		{"dishonesty", "dishonesti"},
		{"dishonour", "dishonour"},
		{"dishonourable", "dishonour"},
		{"dishonoured", "dishonour"},
		{"dishonouring", "dishonour"},
		{"disillusion", "disillus"},
		{"disillusioned", "disillus"},
		{"disinclination", "disinclin"},
		{"disinclined", "disinclin"},
		{"disinherit", "disinherit"},
		{"disinherits", "disinherit"},
		{"disintegration", "disintegr"},
		{"disinterested", "disinterest"},
		{"disinterestedly", "disinterest"},
		{"disinterestedness", "disinterested"},
		{"disjoin", "disjoin"},
		{"disjointed", "disjoint"},
		{"disk", "disk"},
		{"dislike", "dislik"},
		{"disliked", "dislik"},
		{"dislikes", "dislik"},
		{"disliking", "dislik"},
		{"dislocated", "disloc"},
		{"dislocation", "disloc"},
		{"dislodge", "dislodg"},
		{"dismal", "dismal"},
		{"dismally", "dismal"},
		{"dismantle", "dismantl"},
		{"dismantled", "dismantl"},
		{"dismay", "dismay"},
		{"dismayed", "dismay"},
		{"dismiss", "dismiss"},
		{"dismissal", "dismiss"},
		{"dismissed", "dismiss"},
		{"dismisses", "dismiss"},
		{"dismissing", "dismiss"},
		{"dismount", "dismount"},
		{"dismounted", "dismount"},
		{"disobedience", "disobedi"},
		{"disobedient", "disobedi"},
		{"disobey", "disobey"},
		{"disobeyed", "disobey"},
		{"disorder", "disord"},
		{"disordered", "disord"},
		{"disorderly", "disord"},
		{"disorders", "disord"},
		{"disorganization", "disorgan"},
		{"disown", "disown"},
		{"disowned", "disown"},
		{"disparage", "disparag"},
		{"disparagement", "disparag"},
		{"disparaging", "disparag"},
		{"dispassionate", "dispassion"},
		{"dispassionately", "dispassion"},
		{"dispatch", "dispatch"},
		{"dispatched", "dispatch"},
		{"dispatching", "dispatch"},
		{"dispel", "dispel"},
		{"dispelled", "dispel"},
		{"dispensation", "dispens"},
		{"dispense", "dispens"},
		{"dispensed", "dispens"},
		{"dispenses", "dispens"},
		{"dispensing", "dispens"},
		{"disperse", "dispers"},
		{"dispersed", "dispers"},
		{"disperses", "dispers"},
		{"dispersing", "dispers"},
		{"dispirited", "dispirit"},
		{"displaced", "displac"},
		{"displacement", "displac"},
		{"displaces", "displac"},
		{"displacing", "displac"},
		{"display", "display"},
		{"displayed", "display"},
		{"displaying", "display"},
		{"displays", "display"},
		{"displease", "displeas"},
		{"displeased", "displeas"},
		{"displeases", "displeas"},
		{"displeasing", "displeas"},
		{"displeasure", "displeasur"},
		{"disposal", "dispos"},
		{"dispose", "dispos"},
		{"disposed", "dispos"},
		{"disposes", "dispos"},
		{"disposing", "dispos"},
		{"disposition", "disposit"},
		{"dispositions", "disposit"},
		{"dispossess", "dispossess"},
		{"dispossessed", "dispossess"},
		{"dispraise", "disprais"},
		{"disproof", "disproof"},
		{"disproportionate", "disproportion"},
		{"disproportionately", "disproportion"},
		{"disproved", "disprov"},
		{"disproving", "disprov"},
		{"disputation", "disput"},
		{"disputations", "disput"},
		{"dispute", "disput"},
		{"disputed", "disput"},
		{"disputes", "disput"},
		{"disputing", "disput"},
		{"disqualification", "disqualif"},
		{"disquiet", "disquiet"},
		{"disquietude", "disquietud"},
		{"disregard", "disregard"},
		{"disregarded", "disregard"},
		{"disregardful", "disregard"},
		{"disregarding", "disregard"},
		{"disregards", "disregard"},
		{"disreputable", "disreput"},
		{"disrespect", "disrespect"},
		{"disrespectful", "disrespect"},
		{"disrespectfully", "disrespect"},
		{"disruption", "disrupt"},
		{"dissatisfaction", "dissatisfact"},
		{"dissatisfied", "dissatisfi"},
		{"dissected", "dissect"},
		{"dissecting", "dissect"},
		{"dissection", "dissect"},
		{"dissemble", "dissembl"},
		{"dissembler", "dissembl"},
		{"disseminated", "dissemin"},
		{"dissemination", "dissemin"},
		{"dissension", "dissens"},
		{"dissensions", "dissens"},
		{"dissent", "dissent"},
		{"dissenter", "dissent"},
		{"dissertation", "dissert"},
		{"dissimilar", "dissimilar"},
		{"dissimulation", "dissimul"},
		{"dissipate", "dissip"},
		{"dissipated", "dissip"},
		{"dissipating", "dissip"},
		{"dissipation", "dissip"},
		{"dissolute", "dissolut"},
		{"dissolution", "dissolut"},
		{"dissolve", "dissolv"},
		{"dissolved", "dissolv"},
		{"dissuade", "dissuad"},
		{"dissuaded", "dissuad"},
		{"dissuasions", "dissuas"},
		{"distanc", "distanc"},
		{"distance", "distanc"},
		{"distanced", "distanc"},
		{"distances", "distanc"},
		{"distant", "distant"},
		{"distantly", "distant"},
		{"distaste", "distast"},
		{"distasteful", "distast"},
		{"distempered", "distemp"},
		{"distended", "distend"},
		{"distending", "distend"},
		{"distilled", "distil"},
		{"distinct", "distinct"},
		{"distinction", "distinct"},
		{"distinctions", "distinct"},
		{"distinctive", "distinct"},
		{"distinctly", "distinct"},
		{"distinctness", "distinct"},
		{"distinguish", "distinguish"},
		{"distinguishable", "distinguish"},
		{"distinguished", "distinguish"},
		{"distinguishes", "distinguish"},
		{"distinguishing", "distinguish"},
		{"distinguons", "distinguon"},
		{"distort", "distort"},
		{"distorted", "distort"},
		{"distortion", "distort"},
		{"distortions", "distort"},
		{"distract", "distract"},
		{"distracted", "distract"},
		{"distractedly", "distract"},
		{"distracting", "distract"},
		{"distraction", "distract"},
		{"distracts", "distract"},
		{"distraught", "distraught"},
		{"distress", "distress"},
		{"distressed", "distress"},
		{"distresses", "distress"},
		{"distressful", "distress"},
		{"distressfully", "distress"},
		{"distressing", "distress"},
		{"distribute", "distribut"},
		{"distributed", "distribut"},
		{"distributing", "distribut"},
		{"distribution", "distribut"},
		{"district", "district"},
		{"districts", "district"},
		{"distrust", "distrust"},
		{"distrusted", "distrust"},
		{"distrustful", "distrust"},
		{"distrustfully", "distrust"},
		{"disturb", "disturb"},
		{"disturbance", "disturb"},
		{"disturbances", "disturb"},
		{"disturbed", "disturb"},
		{"disturbing", "disturb"},
		{"disturbs", "disturb"},
		{"disused", "disus"},
		{"ditch", "ditch"},
		{"ditches", "ditch"},
		{"ditching", "ditch"},
		{"ditties", "ditti"},
		{"ditto", "ditto"},
		{"ditty", "ditti"},
		{"diurnal", "diurnal"},
		{"divan", "divan"},
		{"dive", "dive"},
		{"dived", "dive"},
		{"diver", "diver"},
		{"diverge", "diverg"},
		{"diverged", "diverg"},
		{"divergence", "diverg"},
		{"diverging", "diverg"},
		{"divers", "diver"},
		{"diverse", "divers"},
		{"diversified", "diversifi"},
		{"diversifying", "diversifi"},
		{"diversion", "divers"},
		{"diversions", "divers"},
		{"diversity", "divers"},
		{"divert", "divert"},
		{"diverted", "divert"},
		{"diverting", "divert"},
		{"dives", "dive"},
		{"divest", "divest"},
		{"divested", "divest"},
		{"divesting", "divest"},
		{"divide", "divid"},
		{"divided", "divid"},
		{"dividend", "dividend"},
		{"divides", "divid"},
		{"dividing", "divid"},
		{"divine", "divin"},
		{"divined", "divin"},
		{"diviner", "divin"},
		{"divines", "divin"},
		{"diving", "dive"},
		{"divining", "divin"},
		{"divinities", "divin"},
		{"divinity", "divin"},
		{"divisio", "divisio"},
		{"division", "divis"},
		{"divisions", "divis"},
		{"divn", "divn"},
		{"divorce", "divorc"},
		{"divorced", "divorc"},
		{"divulge", "divulg"},
		{"divulges", "divulg"},
		{"dixon", "dixon"},
		{"dizzier", "dizzier"},
		{"dizziness", "dizzi"},
		{"dizzy", "dizzi"},
		{"dmitri", "dmitri"},
		{"do", "do"},
		{"doant", "doant"},
		{"dobrizhoffen", "dobrizhoffen"},
		{"dobrizhoffer", "dobrizhoff"},
		{"docile", "docil"},
		{"dock", "dock"},
		{"docks", "dock"},
		{"dockyard", "dockyard"},
		{"dockyards", "dockyard"},
		{"doctor", "doctor"},
		{"doctoring", "doctor"},
		{"doctors", "doctor"},
		{"doctrine", "doctrin"},
		{"doctrines", "doctrin"},
		{"document", "document"},
		{"documentary", "documentari"},
		{"documents", "document"},
		{"dod", "dod"},
		{"dodge", "dodg"},
		{"dodged", "dodg"},
		{"dodges", "dodg"},
		{"dodging", "dodg"},
		{"dodo", "dodo"},
		{"doe", "doe"},
		{"doers", "doer"},
		{"does", "doe"},
		{"doesn", "doesn"},
		{"dog", "dog"},
		{"dogged", "dog"},
		{"doggedly", "dog"},
		{"doggedness", "dogged"},
		{"doggies", "doggi"},
		{"dogging", "dog"},
		{"dogs", "dog"},
		{"doin", "doin"},
		{"doing", "do"},
		{"doings", "do"},
		{"dole", "dole"},
		{"doleful", "dole"},
		{"dolefully", "dole"},
		{"dolichonyx", "dolichonyx"},
		{"doll", "doll"},
		{"dollar", "dollar"},
		{"dollars", "dollar"},
		{"dolls", "doll"},
		{"dolly", "dolli"},
		{"dolorous", "dolor"},
		{"dolt", "dolt"},
		{"dom", "dom"},
		{"domain", "domain"},
		{"domains", "domain"},
		{"dome", "dome"},
		{"domestic", "domest"},
		{"domesticated", "domest"},
		{"domestication", "domest"},
		{"domestics", "domest"},
		{"domiciled", "domicil"},
		{"domidor", "domidor"},
		{"domidors", "domidor"},
		{"dominant", "domin"},
		{"domination", "domin"},
		{"domineer", "domin"},
		{"domineered", "domin"},
		{"domineering", "domin"},
		{"domingo", "domingo"},
		{"dominion", "dominion"},
		{"dominions", "dominion"},
		{"domino", "domino"},
		{"domo", "domo"},
		{"don", "don"},
		{"donatia", "donatia"},
		{"donation", "donat"},
		{"done", "done"},
		{"dong", "dong"},
		{"donkey", "donkey"},
		{"donkeys", "donkey"},
		{"donnez", "donnez"},
		{"donny", "donni"},
		{"donnys", "donni"},
		{"dont", "dont"},
		{"dooble", "doobl"},
		{"dooced", "dooc"},
		{"doodle", "doodl"},
		{"doodleites", "doodleit"},
		{"doom", "doom"},
		{"doomed", "doom"},
		{"dooms", "doom"},
		{"doomsday", "doomsday"},
		{"doon", "doon"},
		{"doonstairs", "doonstair"},
		{"door", "door"},
		{"doorkeeper", "doorkeep"},
		{"doors", "door"},
		{"doorway", "doorway"},
		{"doorways", "doorway"},
		{"doos", "doo"},
		{"doozen", "doozen"},
		{"dora", "dora"},
		{"doris", "dori"},
		{"dorker", "dorker"},
		{"dormant", "dormant"},
		{"dormitory", "dormitori"},
		{"dormouse", "dormous"},
		{"dorsal", "dorsal"},
		{"dose", "dose"},
		{"dosed", "dose"},
		{"doses", "dose"},
		{"dost", "dost"},
		{"dostoevsky", "dostoevski"},
		{"dotage", "dotag"},
		{"dotard", "dotard"},
		{"dote", "dote"},
		{"doted", "dote"},
		{"dotes", "dote"},
		{"doth", "doth"},
		{"dotheboys", "dotheboy"},
		{"dothebys", "dothebi"},
		{"doting", "dote"},
		{"dots", "dot"},
		{"dotted", "dot"},
		{"double", "doubl"},
		{"doubled", "doubl"},
		{"doubleday", "doubleday"},
		{"doubles", "doubl"},
		{"doubling", "doubl"},
		{"doubly", "doubli"},
		{"doubt", "doubt"},
		{"doubted", "doubt"},
		{"doubtful", "doubt"},
		{"doubtfully", "doubt"},
		{"doubting", "doubt"},
		{"doubtingly", "doubt"},
		{"doubtless", "doubtless"},
		{"doubts", "doubt"},
		{"douches", "douch"},
		{"douglas", "dougla"},
		{"dounia", "dounia"},
		{"dourov", "dourov"},
		{"dove", "dove"},
		{"dover", "dover"},
		{"dovercourt", "dovercourt"},
		{"doves", "dove"},
		{"dovetailedness", "dovetailed"},
		{"doveton", "doveton"},
		{"dowager", "dowag"},
		{"dowagers", "dowag"},
		{"dowdles", "dowdl"},
		{"dowdy", "dowdi"},
		{"dower", "dower"},
		{"down", "down"},
		{"downcast", "downcast"},
		{"downfall", "downfal"},
		{"downfallings", "downfal"},
		{"downhearted", "downheart"},
		{"downing", "down"},
		{"downright", "downright"},
		{"downs", "down"},
		{"downstairs", "downstair"},
		{"downward", "downward"},
		{"downwards", "downward"},
		{"downy", "downi"},
		{"dowry", "dowri"},
		{"doze", "doze"},
		{"dozed", "doze"},
		{"dozen", "dozen"},
		{"dozens", "dozen"},
		{"dozenth", "dozenth"},
		{"dozes", "doze"},
		{"dozing", "doze"},
		{"dr", "dr"},
		{"dra", "dra"},
		{"drab", "drab"},
		{"drabs", "drab"},
		{"draft", "draft"},
		{"drafts", "draft"},
		{"drag", "drag"},
		{"dragged", "drag"},
		{"dragging", "drag"},
		{"draggled", "draggl"},
		{"draggletails", "draggletail"},
		{"dragon", "dragon"},
		{"dragoon", "dragoon"},
		{"dragooning", "dragoon"},
		{"dragoons", "dragoon"},
		{"drags", "drag"},
		{"drain", "drain"},
		{"drainage", "drainag"},
		{"drained", "drain"},
		{"draining", "drain"},
		{"drains", "drain"},
		{"drake", "drake"},
		{"drakes", "drake"},
		{"dram", "dram"},
		{"drama", "drama"},
		{"dramatic", "dramat"},
		{"dramatically", "dramat"},
		{"dramaticus", "dramaticus"},
		{"dramatise", "dramatis"},
		{"dramatised", "dramatis"},
		{"dramatist", "dramatist"},
		{"dramatists", "dramatist"},
		{"drank", "drank"},
		{"drap", "drap"},
		{"draperies", "draperi"},
		{"drapery", "draperi"},
		{"drat", "drat"},
		{"draught", "draught"},
		{"draughts", "draught"},
		{"draughtsman", "draughtsman"},
		{"draw", "draw"},
		{"drawback", "drawback"},
		{"drawbacks", "drawback"},
		{"drawbridge", "drawbridg"},
		{"drawed", "draw"},
		{"drawer", "drawer"},
		{"drawers", "drawer"},
		{"drawing", "draw"},
		{"drawings", "draw"},
		{"drawl", "drawl"},
		{"drawled", "drawl"},
		{"drawling", "drawl"},
		{"drawls", "drawl"},
		{"drawn", "drawn"},
		{"draws", "draw"},
		{"dray", "dray"},
		{"drays", "dray"},
		{"dread", "dread"},
		{"dreaded", "dread"},
		{"dreadful", "dread"},
		{"dreadfully", "dread"},
		{"dreading", "dread"},
		{"dreadnought", "dreadnought"},
		{"dream", "dream"},
		{"dreamed", "dream"},
		{"dreamer", "dreamer"},
		{"dreamily", "dreamili"},
		{"dreaminess", "dreami"},
		{"dreaming", "dream"},
		{"dreamings", "dream"},
		{"dreams", "dream"},
		{"dreamt", "dreamt"},
		{"dreamy", "dreami"},
		{"drear", "drear"},
		{"dreariness", "dreari"},
		{"dreary", "dreari"},
		{"dregs", "dreg"},
		{"drenched", "drench"},
		{"dresden", "dresden"},
		{"dress", "dress"},
		{"dressed", "dress"},
		{"dresser", "dresser"},
		{"dresses", "dress"},
		{"dressing", "dress"},
		{"dressmaker", "dressmak"},
		{"dressmakers", "dressmak"},
		{"dressmaking", "dressmak"},
		{"drest", "drest"},
		{"drew", "drew"},
		{"driblets", "driblet"},
		{"dried", "dri"},
		{"drier", "drier"},
		{"dries", "dri"},
		{"driest", "driest"},
		{"drift", "drift"},
		{"drifte", "drift"},
		{"drifted", "drift"},
		{"drifting", "drift"},
		{"drifts", "drift"},
		{"drigg", "drigg"},
		{"drilled", "drill"},
		{"drily", "drili"},
		{"drink", "drink"},
		{"drinkable", "drinkabl"},
		{"drinker", "drinker"},
		{"drinkers", "drinker"},
		{"drinking", "drink"},
		{"drinkings", "drink"},
		{"drinks", "drink"},
		{"drip", "drip"},
		{"dripping", "drip"},
		{"drips", "drip"},
		{"drive", "drive"},
		{"drivelling", "drivel"},
		{"driven", "driven"},
		{"driver", "driver"},
		{"drivers", "driver"},
		{"drives", "drive"},
		{"driving", "drive"},
		{"drizzle", "drizzl"},
		{"drizzling", "drizzl"},
		{"drizzly", "drizzli"},
		{"dro", "dro"},
		{"droite", "droit"},
		{"droll", "droll"},
		{"drollery", "drolleri"},
		{"drolly", "drolli"},
		{"drone", "drone"},
		{"drones", "drone"},
		{"droonk", "droonk"},
		{"droop", "droop"},
		{"drooped", "droop"},
		{"drooping", "droop"},
		{"droops", "droop"},
		{"drop", "drop"},
		{"droppe", "dropp"},
		{"dropped", "drop"},
		{"dropping", "drop"},
		{"droppings", "drop"},
		{"drops", "drop"},
		{"dropsy", "dropsi"},
		{"dross", "dross"},
		{"drought", "drought"},
		{"droughts", "drought"},
		{"drove", "drove"},
		{"drover", "drover"},
		{"drovers", "drover"},
		{"droves", "drove"},
		{"drown", "drown"},
		{"drownded", "drownd"},
		{"drowned", "drown"},
		{"drowning", "drown"},
		{"drowsily", "drowsili"},
		{"drowsiness", "drowsi"},
		{"drowsy", "drowsi"},
		{"drubbing", "drub"},
		{"drudge", "drudg"},
		{"drudgery", "drudgeri"},
		{"drudges", "drudg"},
		{"drugs", "drug"},
		{"druidical", "druidic"},
		{"drum", "drum"},
		{"drummer", "drummer"},
		{"drummers", "drummer"},
		{"drummond", "drummond"},
		{"drummonds", "drummond"},
		{"drums", "drum"},
		{"drunk", "drunk"},
		{"drunkard", "drunkard"},
		{"drunkards", "drunkard"},
		{"drunken", "drunken"},
		{"drunkenness", "drunken"},
		{"drury", "druri"},
		{"dry", "dri"},
		{"dryer", "dryer"},
		{"drying", "dri"},
		{"dryly", "dryli"},
		{"dryness", "dryness"},
		{"dst", "dst"},
		{"du", "du"},
		{"dubious", "dubious"},
		{"dublin", "dublin"},
		{"ducal", "ducal"},
		{"duchess", "duchess"},
		{"duchesses", "duchess"},
		{"duchy", "duchi"},
		{"duck", "duck"},
		{"ducking", "duck"},
		{"ducklings", "duckl"},
		{"ducks", "duck"},
		{"duclida", "duclida"},
		{"dudgeon", "dudgeon"},
		{"due", "due"},
		{"duel", "duel"},
		{"duenna", "duenna"},
		{"dues", "due"},
		{"duets", "duet"},
		{"duffer", "duffer"},
		{"duffy", "duffi"},
		{"dug", "dug"},
		{"dugong", "dugong"},
		{"duke", "duke"},
		{"dukedom", "dukedom"},
		{"dukes", "duke"},
		{"dulcet", "dulcet"},
		{"dull", "dull"},
		{"dullards", "dullard"},
		{"duller", "duller"},
		{"dullest", "dullest"},
		{"dullish", "dullish"},
		{"dullness", "dull"},
		{"dully", "dulli"},
		{"dulness", "dul"},
		{"dulwich", "dulwich"},
		{"duly", "duli"},
		{"dumb", "dumb"},
		{"dumbbell", "dumbbel"},
		{"dumbfounded", "dumbfound"},
		{"dumbfoundered", "dumbfound"},
		{"dumbly", "dumbl"},
		{"dummy", "dummi"},
		{"dumpling", "dumpl"},
		{"dun", "dun"},
		{"duncan", "duncan"},
		{"dunes", "dune"},
		{"dung", "dung"},
		{"dungeon", "dungeon"},
		{"dungeons", "dungeon"},
		{"dunghill", "dunghil"},
		{"dunheved", "dunhev"},
		{"dunlops", "dunlop"},
		{"duns", "dun"},
		{"duodecimos", "duodecimo"},
		{"duodenum", "duodenum"},
		{"dupe", "dupe"},
		{"duped", "dupe"},
		{"duping", "dupe"},
		{"duplicate", "duplic"},
		{"duplicates", "duplic"},
		{"duplicity", "duplic"},
		{"durability", "durabl"},
		{"duratio", "duratio"},
		{"duration", "durat"},
		{"durden", "durden"},
		{"durer", "durer"},
		{"durham", "durham"},
		{"during", "dure"},
		{"dursn", "dursn"},
		{"durst", "durst"},
		{"durstn", "durstn"},
		{"dushkin", "dushkin"},
		{"dusk", "dusk"},
		{"duskier", "duskier"},
		{"dusky", "duski"},
		{"dussauts", "dussaut"},
		{"dust", "dust"},
		{"dusted", "dust"},
		{"duster", "duster"},
		{"dustier", "dustier"},
		{"dusting", "dust"},
		{"dustman", "dustman"},
		{"dustn", "dustn"},
		{"dusty", "dusti"},
		{"dutch", "dutch"},
		{"dutchman", "dutchman"},
		{"duties", "duti"},
		{"dutiful", "duti"},
		{"dutifully", "duti"},
		{"duty", "duti"},
		{"dwarf", "dwarf"},
		{"dwell", "dwell"},
		{"dweller", "dweller"},
		{"dwelling", "dwell"},
		{"dwellings", "dwell"},
		{"dwells", "dwell"},
		{"dwelt", "dwelt"},
		{"dwindled", "dwindl"},
		{"dwindling", "dwindl"},
		{"dy", "dy"},
		{"dye", "dye"},
		{"dyed", "dy"},
		{"dyer", "dyer"},
		{"dyes", "dye"},
		{"dying", "die"},
		{"dykes", "dyke"},
		{"dynasty", "dynasti"},
		{"dysentery", "dysenteri"},
		{"e", "e"},
		{"each", "each"},
		{"ead", "ead"},
		{"eager", "eager"},
		{"eagerly", "eager"},
		{"eagerness", "eager"},
		{"eagle", "eagl"},
		{"eagles", "eagl"},
		{"ealthiest", "ealthiest"},
		{"ear", "ear"},
		{"eard", "eard"},
		{"eared", "ear"},
		{"earings", "ear"},
		{"earl", "earl"},
		{"earlier", "earlier"},
		{"earliest", "earliest"},
		{"earls", "earl"},
		{"early", "earli"},
		{"earlybird", "earlybird"},
		{"earn", "earn"},
		{"earned", "earn"},
		{"earnest", "earnest"},
		{"earnestly", "earnest"},
		{"earnestness", "earnest"},
		{"earning", "earn"},
		{"earnings", "earn"},
		{"earring", "earring"},
		{"earrings", "earring"},
		{"ears", "ear"},
		{"eart", "eart"},
		{"earth", "earth"},
		{"earthen", "earthen"},
		{"earthenware", "earthenwar"},
		{"earthly", "earth"},
		{"earthquake", "earthquak"},
		{"earthquakes", "earthquak"},
		{"earths", "earth"},
		{"earthy", "earthi"},
		{"earwigs", "earwig"},
		{"eas", "ea"},
		{"ease", "eas"},
		{"eased", "eas"},
		{"easier", "easier"},
		{"easiest", "easiest"},
		{"easily", "easili"},
		{"easiness", "easi"},
		{"east", "east"},
		{"easter", "easter"},
		{"easterly", "easter"},
		{"eastern", "eastern"},
		{"eastward", "eastward"},
		{"eastwards", "eastward"},
		{"easy", "easi"},
		{"eat", "eat"},
		{"eatable", "eatabl"},
		{"eatables", "eatabl"},
		{"eaten", "eaten"},
		{"eater", "eater"},
		{"eaters", "eater"},
		{"eating", "eat"},
		{"eats", "eat"},
		{"eau", "eau"},
		{"eaves", "eav"},
		{"ebb", "ebb"},
		{"ebbed", "eb"},
		{"ebbing", "eb"},
		{"ebullitions", "ebullit"},
		{"eccentric", "eccentr"},
		{"eccentricities", "eccentr"},
		{"eccentricity", "eccentr"},
		{"ecclesiastical", "ecclesiast"},
		{"ech", "ech"},
		{"echo", "echo"},
		{"echoed", "echo"},
		{"echoes", "echo"},
		{"echoing", "echo"},
		{"echoings", "echo"},
		{"eclipse", "eclips"},
		{"eclipsed", "eclips"},
		{"ecod", "ecod"},
		{"economic", "econom"},
		{"economical", "econom"},
		{"economically", "econom"},
		{"economists", "economist"},
		{"economize", "econom"},
		{"economizing", "econom"},
		{"economy", "economi"},
		{"ecstasies", "ecstasi"},
		{"ecstasy", "ecstasi"},
		{"ecstatic", "ecstat"},
		{"ecstatically", "ecstat"},
		{"ed", "ed"},
		{"eddication", "eddic"},
		{"eddies", "eddi"},
		{"eddying", "eddi"},
		{"eden", "eden"},
		{"edental", "edent"},
		{"edentata", "edentata"},
		{"edge", "edg"},
		{"edged", "edg"},
		{"edgeless", "edgeless"},
		{"edges", "edg"},
		{"edgeware", "edgewar"},
		{"edgeways", "edgeway"},
		{"edging", "edg"},
		{"edible", "edibl"},
		{"edict", "edict"},
		{"edification", "edif"},
		{"edifice", "edific"},
		{"edifices", "edific"},
		{"edified", "edifi"},
		{"edify", "edifi"},
		{"edifying", "edifi"},
		{"edin", "edin"},
		{"edinburgh", "edinburgh"},
		{"edition", "edit"},
		{"editor", "editor"},
		{"editors", "editor"},
		{"educate", "educ"},
		{"educated", "educ"},
		{"educating", "educ"},
		{"education", "educ"},
		{"educational", "educ"},
		{"educator", "educ"},
		{"edusa", "edusa"},
		{"edward", "edward"},
		{"edwards", "edward"},
		{"edwin", "edwin"},
		{"ee", "ee"},
		{"eel", "eel"},
		{"eels", "eel"},
		{"ees", "ee"},
		{"efface", "effac"},
		{"effaceable", "effac"},
		{"effect", "effect"},
		{"effected", "effect"},
		{"effecting", "effect"},
		{"effective", "effect"},
		{"effectiveness", "effect"},
		{"effects", "effect"},
		{"effectual", "effectu"},
		{"effectually", "effectu"},
		{"effeminate", "effemin"},
		{"effervescence", "effervesc"},
		{"effervescent", "effervesc"},
		{"effets", "effet"},
		{"efficacious", "efficaci"},
		{"efficacy", "efficaci"},
		{"efficiency", "effici"},
		{"efficient", "effici"},
		{"effigy", "effigi"},
		{"effloresce", "effloresc"},
		{"efflorescence", "effloresc"},
		{"effluvia", "effluvia"},
		{"effluvium", "effluvium"},
		{"effort", "effort"},
		{"efforts", "effort"},
		{"effrontery", "effronteri"},
		{"effulgence", "effulg"},
		{"effusion", "effus"},
		{"effusions", "effus"},
		{"efther", "efther"},
		{"egad", "egad"},
		{"egbert", "egbert"},
		{"egg", "egg"},
		{"eggs", "egg"},
		{"eggshells", "eggshel"},
		{"eghert", "eghert"},
		{"eglantine", "eglantin"},
		{"egoist", "egoist"},
		{"egotistically", "egotist"},
		{"egregious", "egregi"},
		{"egregiously", "egregi"},
		{"egress", "egress"},
		{"egrets", "egret"},
		{"egypt", "egypt"},
		{"egyptian", "egyptian"},
		{"egyptians", "egyptian"},
		{"eh", "eh"},
		{"ehrenberg", "ehrenberg"},
		{"eight", "eight"},
		{"eighteen", "eighteen"},
		{"eighteenpence", "eighteenp"},
		{"eighteenpences", "eighteenp"},
		{"eighteenpenny", "eighteenpenni"},
		{"eighth", "eighth"},
		{"eighthly", "eighth"},
		{"eighths", "eighth"},
		{"eightpence", "eightpenc"},
		{"eighty", "eighti"},
		{"eimeo", "eimeo"},
		{"eine", "ein"},
		{"either", "either"},
		{"ejaculate", "ejacul"},
		{"ejaculated", "ejacul"},
		{"ejaculates", "ejacul"},
		{"ejaculating", "ejacul"},
		{"ejaculations", "ejacul"},
		{"eject", "eject"},
		{"ejected", "eject"},
		{"ejecting", "eject"},
		{"ekaterininsky", "ekaterininski"},
		{"eke", "eke"},
		{"eked", "eke"},
		{"eking", "eke"},
		{"el", "el"},
		{"elaborate", "elabor"},
		{"elaborated", "elabor"},
		{"elaboration", "elabor"},
		{"elan", "elan"},
		{"elapse", "elaps"},
		{"elapsed", "elaps"},
		{"elapses", "elaps"},
		{"elastic", "elast"},
		{"elasticity", "elast"},
		{"elated", "elat"},
		{"elater", "elat"},
		{"elateridae", "elaterida"},
		{"elaters", "elat"},
		{"elation", "elat"},
		{"elber", "elber"},
		{"elbers", "elber"},
		{"elbow", "elbow"},
		{"elbowed", "elbow"},
		{"elbowing", "elbow"},
		{"elbows", "elbow"},
		{"elder", "elder"},
		{"elderly", "elder"},
		{"elders", "elder"},
		{"eldest", "eldest"},
		{"eldon", "eldon"},
		{"elect", "elect"},
		{"elected", "elect"},
		{"electing", "elect"},
		{"election", "elect"},
		{"electioneering", "election"},
		{"elections", "elect"},
		{"elector", "elector"},
		{"electors", "elector"},
		{"electric", "electr"},
		{"electrical", "electr"},
		{"electricity", "electr"},
		{"elegance", "eleg"},
		{"elegancies", "eleg"},
		{"elegans", "elegan"},
		{"elegant", "eleg"},
		{"elegantly", "eleg"},
		{"element", "element"},
		{"elementary", "elementari"},
		{"elements", "element"},
		{"elephant", "eleph"},
		{"elephantine", "elephantin"},
		{"elephants", "eleph"},
		{"elevate", "elev"},
		{"elevated", "elev"},
		{"elevates", "elev"},
		{"elevating", "elev"},
		{"elevation", "elev"},
		{"elevations", "elev"},
		{"elevatory", "elevatori"},
		{"eleven", "eleven"},
		{"elevens", "eleven"},
		{"eleventh", "eleventh"},
		{"elewated", "elew"},
		{"elf", "elf"},
		{"elfin", "elfin"},
		{"elgble", "elgbl"},
		{"elicit", "elicit"},
		{"elicited", "elicit"},
		{"eliciting", "elicit"},
		{"elicits", "elicit"},
		{"eligible", "elig"},
		{"eliminate", "elimin"},
		{"elite", "elit"},
		{"elizabeth", "elizabeth"},
		{"ell", "ell"},
		{"elle", "ell"},
		{"ellen", "ellen"},
		{"elles", "ell"},
		{"ellesmere", "ellesmer"},
		{"elliptic", "ellipt"},
		{"ellis", "elli"},
		{"ellore", "ellor"},
		{"elm", "elm"},
		{"elmo", "elmo"},
		{"elms", "elm"},
		{"elocution", "elocut"},
		{"elongated", "elong"},
		{"elongation", "elong"},
		{"elope", "elop"},
		{"eloped", "elop"},
		{"elopement", "elop"},
		{"eloquence", "eloqu"},
		{"eloquent", "eloqu"},
		{"eloquently", "eloqu"},
		{"elscholchias", "elscholchia"},
		{"elsdale", "elsdal"},
		{"else", "els"},
		{"elsewhere", "elsewher"},
		{"elucidate", "elucid"},
		{"elucidated", "elucid"},
		{"elude", "elud"},
		{"eluded", "elud"},
		{"eluding", "elud"},
		{"elves", "elv"},
		{"elwes", "elw"},
		{"elysian", "elysian"},
		{"elysium", "elysium"},
		{"em", "em"},
		{"emaciated", "emaci"},
		{"emanated", "eman"},
		{"emanating", "eman"},
		{"emanation", "eman"},
		{"emancipated", "emancip"},
		{"emancipation", "emancip"},
		{"emancipist", "emancipist"},
		{"emasculate", "emascul"},
		{"embankment", "embank"},
		{"embankments", "embank"},
		{"embarassed", "embarass"},
		{"embargo", "embargo"},
		{"embark", "embark"},
		{"embarked", "embark"},
		{"embarking", "embark"},
		{"embarrass", "embarrass"},
		{"embarrassed", "embarrass"},
		{"embarrassing", "embarrass"},
		{"embarrassment", "embarrass"},
		{"embarrassments", "embarrass"},
		{"embassy", "embassi"},
		{"embedded", "embed"},
		{"embellish", "embellish"},
		{"embellished", "embellish"},
		{"embellishes", "embellish"},
		{"embellishing", "embellish"},
		{"embellishment", "embellish"},
		{"embellishments", "embellish"},
		{"ember", "ember"},
		{"embers", "ember"},
		{"embitter", "embitt"},
		{"embittered", "embitt"},
		{"emblazoned", "emblazon"},
		{"emblem", "emblem"},
		{"emblems", "emblem"},
		{"embodied", "embodi"},
		{"embodiment", "embodi"},
		{"emboldened", "embolden"},
		{"emboldening", "embolden"},
		{"emboldens", "embolden"},
		{"embossed", "emboss"},
		{"embowed", "embow"},
		{"embrace", "embrac"},
		{"embraced", "embrac"},
		{"embracer", "embrac"},
		{"embraces", "embrac"},
		{"embracing", "embrac"},
		{"embroidered", "embroid"},
		{"embroidering", "embroid"},
		{"embroiders", "embroid"},
		{"embroidery", "embroideri"},
		{"embroil", "embroil"},
		{"embryo", "embryo"},
		{"emerald", "emerald"},
		{"emerge", "emerg"},
		{"emerged", "emerg"},
		{"emergency", "emerg"},
		{"emerges", "emerg"},
		{"emerging", "emerg"},
		{"emigrate", "emigr"},
		{"emigrated", "emigr"},
		{"emigration", "emigr"},
		{"emilia", "emilia"},
		{"emily", "emili"},
		{"eminence", "emin"},
		{"eminent", "emin"},
		{"eminently", "emin"},
		{"emit", "emit"},
		{"emits", "emit"},
		{"emitted", "emit"},
		{"emitting", "emit"},
		{"emma", "emma"},
		{"emollient", "emolli"},
		{"emoluments", "emolu"},
		{"emotion", "emot"},
		{"emotional", "emot"},
		{"emotions", "emot"},
		{"emperor", "emperor"},
		{"empetrum", "empetrum"},
		{"emphasis", "emphasi"},
		{"emphasise", "emphasis"},
		{"emphasising", "emphasis"},
		{"emphasizing", "emphas"},
		{"emphatic", "emphat"},
		{"emphatically", "emphat"},
		{"empire", "empir"},
		{"employ", "employ"},
		{"employed", "employ"},
		{"employer", "employ"},
		{"employers", "employ"},
		{"employing", "employ"},
		{"employment", "employ"},
		{"employments", "employ"},
		{"employs", "employ"},
		{"emporium", "emporium"},
		{"emporiums", "emporium"},
		{"empower", "empow"},
		{"empowered", "empow"},
		{"empress", "empress"},
		{"emptied", "empti"},
		{"empties", "empti"},
		{"emptiness", "empti"},
		{"emptor", "emptor"},
		{"empty", "empti"},
		{"emptying", "empti"},
		{"emu", "emu"},
		{"emulation", "emul"},
		{"emus", "emus"},
		{"en", "en"},
		{"enable", "enabl"},
		{"enabled", "enabl"},
		{"enables", "enabl"},
		{"enabling", "enabl"},
		{"enact", "enact"},
		{"enacted", "enact"},
		{"enacting", "enact"},
		{"enamel", "enamel"},
		{"enamelled", "enamel"},
		{"enamoured", "enamour"},
		{"encamped", "encamp"},
		{"encampment", "encamp"},
		{"encamps", "encamp"},
		{"encased", "encas"},
		{"encerrado", "encerrado"},
		{"enchanted", "enchant"},
		{"enchanter", "enchant"},
		{"enchanting", "enchant"},
		{"encircle", "encircl"},
		{"encircled", "encircl"},
		{"encircles", "encircl"},
		{"encircling", "encircl"},
		{"enclos", "enclo"},
		{"enclose", "enclos"},
		{"enclosed", "enclos"},
		{"enclosing", "enclos"},
		{"enclosure", "enclosur"},
		{"enclosures", "enclosur"},
		{"encomium", "encomium"},
		{"encomiums", "encomium"},
		{"encompassed", "encompass"},
		{"encompassing", "encompass"},
		{"encore", "encor"},
		{"encounter", "encount"},
		{"encountered", "encount"},
		{"encountering", "encount"},
		{"encounters", "encount"},
		{"encourage", "encourag"},
		{"encouraged", "encourag"},
		{"encouragement", "encourag"},
		{"encouragements", "encourag"},
		{"encourager", "encourag"},
		{"encourages", "encourag"},
		{"encouraging", "encourag"},
		{"encouragingly", "encourag"},
		{"encroach", "encroach"},
		{"encroached", "encroach"},
		{"encroaches", "encroach"},
		{"encroachment", "encroach"},
		{"encroachments", "encroach"},
		{"encrusted", "encrust"},
		{"encumber", "encumb"},
		{"encumbered", "encumb"},
		{"encumbering", "encumb"},
		{"encyclop", "encyclop"},
		{"end", "end"},
		{"endanger", "endang"},
		{"endangered", "endang"},
		{"endear", "endear"},
		{"endeared", "endear"},
		{"endearing", "endear"},
		{"endearment", "endear"},
		{"endearments", "endear"},
		{"endeavour", "endeavour"},
		{"endeavoured", "endeavour"},
		{"endeavouring", "endeavour"},
		{"endeavours", "endeavour"},
		{"ended", "end"},
		{"endemic", "endem"},
		{"enderby", "enderbi"},
		{"enders", "ender"},
		{"ending", "end"},
		{"endless", "endless"},
		{"endlessly", "endless"},
		{"endow", "endow"},
		{"endowed", "endow"},
		{"endowing", "endow"},
		{"endowment", "endow"},
		{"endowments", "endow"},
		{"endroits", "endroit"},
		{"ends", "end"},
		{"endurable", "endur"},
		{"endurance", "endur"},
		{"endure", "endur"},
		{"endured", "endur"},
		{"enduring", "endur"},
		{"eneaf", "eneaf"},
		{"enemies", "enemi"},
		{"enemy", "enemi"},
		{"energetic", "energet"},
		{"energetically", "energet"},
		{"energies", "energi"},
		{"energy", "energi"},
		{"enervated", "enerv"},
		{"enfant", "enfant"},
		{"enfeebled", "enfeebl"},
		{"enfolded", "enfold"},
		{"enfolding", "enfold"},
		{"enforce", "enforc"},
		{"enforced", "enforc"},
		{"enforcing", "enforc"},
		{"engaddi", "engaddi"},
		{"engage", "engag"},
		{"engaged", "engag"},
		{"engagement", "engag"},
		{"engagements", "engag"},
		{"engages", "engag"},
		{"engaging", "engag"},
		{"engagingness", "engaging"},
		{"engagmg", "engagmg"},
		{"engender", "engend"},
		{"engendered", "engend"},
		{"engenhodo", "engenhodo"},
		{"engine", "engin"},
		{"engineer", "engin"},
		{"engineering", "engin"},
		{"engines", "engin"},
		{"england", "england"},
		{"english", "english"},
		{"englishman", "englishman"},
		{"englishmen", "englishmen"},
		{"englishwoman", "englishwoman"},
		{"engraved", "engrav"},
		{"engraven", "engraven"},
		{"engraver", "engrav"},
		{"engraving", "engrav"},
		{"engravings", "engrav"},
		{"engrossed", "engross"},
		{"engrosser", "engross"},
		{"engrossing", "engross"},
		{"enhance", "enhanc"},
		{"enhanced", "enhanc"},
		{"enhancing", "enhanc"},
		{"enigma", "enigma"},
		{"enigmatic", "enigmat"},
		{"enigmatically", "enigmat"},
		{"enjoin", "enjoin"},
		{"enjoined", "enjoin"},
		{"enjoins", "enjoin"},
		{"enjoy", "enjoy"},
		{"enjoyable", "enjoy"},
		{"enjoyed", "enjoy"},
		{"enjoying", "enjoy"},
		{"enjoyingly", "enjoy"},
		{"enjoyment", "enjoy"},
		{"enjoys", "enjoy"},
		{"enlarge", "enlarg"},
		{"enlarged", "enlarg"},
		{"enlarging", "enlarg"},
		{"enlighten", "enlighten"},
		{"enlightened", "enlighten"},
		{"enlightenment", "enlighten"},
		{"enlist", "enlist"},
		{"enlisted", "enlist"},
		{"enlisting", "enlist"},
		{"enlistment", "enlist"},
		{"enliven", "enliven"},
		{"enlivened", "enliven"},
		{"enlivening", "enliven"},
		{"enlivenment", "enliven"},
		{"enmity", "enmiti"},
		{"ennoble", "ennobl"},
		{"ennobled", "ennobl"},
		{"ennobles", "ennobl"},
		{"ennui", "ennui"},
		{"enormity", "enorm"},
		{"enormous", "enorm"},
		{"enormously", "enorm"},
		{"enough", "enough"},
		{"enrage", "enrag"},
		{"enraged", "enrag"},
		{"enraptured", "enraptur"},
		{"enriched", "enrich"},
		{"enriching", "enrich"},
		{"enrichment", "enrich"},
		{"enrobed", "enrob"},
		{"enrol", "enrol"},
		{"enrolled", "enrol"},
		{"enshrined", "enshrin"},
		{"enshrouded", "enshroud"},
		{"ensign", "ensign"},
		{"enslaver", "enslav"},
		{"enslaving", "enslav"},
		{"ensnare", "ensnar"},
		{"ensnared", "ensnar"},
		{"ensue", "ensu"},
		{"ensued", "ensu"},
		{"ensues", "ensu"},
		{"ensuing", "ensu"},
		{"ensure", "ensur"},
		{"entail", "entail"},
		{"entailed", "entail"},
		{"entangle", "entangl"},
		{"entangled", "entangl"},
		{"entanglement", "entangl"},
		{"enter", "enter"},
		{"entered", "enter"},
		{"entering", "enter"},
		{"enterprise", "enterpris"},
		{"enterprising", "enterpris"},
		{"enters", "enter"},
		{"entertain", "entertain"},
		{"entertained", "entertain"},
		{"entertainer", "entertain"},
		{"entertaining", "entertain"},
		{"entertainment", "entertain"},
		{"entertainments", "entertain"},
		{"entertains", "entertain"},
		{"enthralled", "enthral"},
		{"enthusiasm", "enthusiasm"},
		{"enthusiastic", "enthusiast"},
		{"enthusiastically", "enthusiast"},
		{"enticed", "entic"},
		{"enticing", "entic"},
		{"entire", "entir"},
		{"entirely", "entir"},
		{"entirety", "entireti"},
		{"entitle", "entitl"},
		{"entitled", "entitl"},
		{"entitling", "entitl"},
		{"entombed", "entomb"},
		{"entombment", "entomb"},
		{"entomol", "entomol"},
		{"entomological", "entomolog"},
		{"entomologist", "entomologist"},
		{"entomology", "entomolog"},
		{"entomostraca", "entomostraca"},
		{"entomostracous", "entomostrac"},
		{"entrails", "entrail"},
		{"entrance", "entranc"},
		{"entrances", "entranc"},
		{"entrap", "entrap"},
		{"entrapped", "entrap"},
		{"entre", "entr"},
		{"entreat", "entreat"},
		{"entreated", "entreat"},
		{"entreaties", "entreati"},
		{"entreating", "entreat"},
		{"entreats", "entreat"},
		{"entreaty", "entreati"},
		{"entree", "entre"},
		{"entrenched", "entrench"},
		{"entries", "entri"},
		{"entrust", "entrust"},
		{"entrusted", "entrust"},
		{"entry", "entri"},
		{"entwine", "entwin"},
		{"entwined", "entwin"},
		{"entwines", "entwin"},
		{"enumerate", "enumer"},
		{"enumerated", "enumer"},
		{"enunciated", "enunci"},
		{"enunciation", "enunci"},
		{"envelope", "envelop"},
		{"enveloped", "envelop"},
		{"envelopes", "envelop"},
		{"envelops", "envelop"},
		{"envenomed", "envenom"},
		{"enviable", "enviabl"},
		{"envied", "envi"},
		{"envies", "envi"},
		{"envious", "envious"},
		{"environ", "environ"},
		{"environment", "environ"},
		{"environne", "environn"},
		{"envy", "envi"},
		{"epaulets", "epaulet"},
		{"epaulette", "epaulett"},
		{"epeira", "epeira"},
		{"ephemeral", "ephemer"},
		{"epicure", "epicur"},
		{"epicurean", "epicurean"},
		{"epidemics", "epidem"},
		{"epilepsy", "epilepsi"},
		{"epileptic", "epilept"},
		{"epilogue", "epilogu"},
		{"episode", "episod"},
		{"episodes", "episod"},
		{"epistle", "epistl"},
		{"epithet", "epithet"},
		{"epithets", "epithet"},
		{"epitome", "epitom"},
		{"epoch", "epoch"},
		{"epochs", "epoch"},
		{"eprise", "epris"},
		{"epsom", "epsom"},
		{"equable", "equabl"},
		{"equal", "equal"},
		{"equality", "equal"},
		{"equalle", "equall"},
		{"equalled", "equal"},
		{"equalling", "equal"},
		{"equally", "equal"},
		{"equals", "equal"},
		{"equanimity", "equanim"},
		{"equator", "equat"},
		{"equatorial", "equatori"},
		{"equestrian", "equestrian"},
		{"equidistant", "equidist"},
		{"equilibrium", "equilibrium"},
		{"equinox", "equinox"},
		{"equipage", "equipag"},
		{"equipages", "equipag"},
		{"equipment", "equip"},
		{"equipped", "equip"},
		{"equitable", "equit"},
		{"equitably", "equit"},
		{"equitem", "equitem"},
		{"equity", "equiti"},
		{"equivalent", "equival"},
		{"equivocal", "equivoc"},
		{"equivocation", "equivoc"},
		{"equus", "equus"},
		{"er", "er"},
		{"era", "era"},
		{"eradicate", "erad"},
		{"eradicated", "erad"},
		{"eras", "era"},
		{"erased", "eras"},
		{"ercharged", "ercharg"},
		{"ere", "ere"},
		{"erec", "erec"},
		{"erect", "erect"},
		{"erected", "erect"},
		{"erections", "erect"},
		{"erectness", "erect"},
		{"erects", "erect"},
		{"erichson", "erichson"},
		{"erle", "erl"},
		{"erme", "erm"},
		{"ermine", "ermin"},
		{"erosio", "erosio"},
		{"err", "err"},
		{"errand", "errand"},
		{"errands", "errand"},
		{"erratic", "errat"},
		{"erred", "er"},
		{"erring", "er"},
		{"erroneous", "erron"},
		{"error", "error"},
		{"errors", "error"},
		{"erst", "erst"},
		{"erstan", "erstan"},
		{"eructans", "eructan"},
		{"erudite", "erudit"},
		{"erudition", "erudit"},
		{"erupted", "erupt"},
		{"eruption", "erupt"},
		{"eruptions", "erupt"},
		{"eruptive", "erupt"},
		{"eryngium", "eryngium"},
		{"erysipelas", "erysipela"},
		{"erythraeum", "erythraeum"},
		{"es", "es"},
		{"escape", "escap"},
		{"escaped", "escap"},
		{"escapes", "escap"},
		{"escaping", "escap"},
		{"escarpment", "escarp"},
		{"escarpments", "escarp"},
		{"eschara", "eschara"},
		{"escheated", "escheat"},
		{"escort", "escort"},
		{"escorted", "escort"},
		{"escorting", "escort"},
		{"esculentus", "esculentus"},
		{"escutcheons", "escutcheon"},
		{"esk", "esk"},
		{"espagne", "espagn"},
		{"especial", "especi"},
		{"especially", "especi"},
		{"espied", "espi"},
		{"esplanades", "esplanad"},
		{"espouse", "espous"},
		{"espoused", "espous"},
		{"esprit", "esprit"},
		{"esq", "esq"},
		{"esquimau", "esquimau"},
		{"esquire", "esquir"},
		{"essay", "essay"},
		{"essayed", "essay"},
		{"essays", "essay"},
		{"esse", "ess"},
		{"essence", "essenc"},
		{"essential", "essenti"},
		{"essentially", "essenti"},
		{"essentials", "essenti"},
		{"essex", "essex"},
		{"est", "est"},
		{"establish", "establish"},
		{"established", "establish"},
		{"establishes", "establish"},
		{"establishing", "establish"},
		{"establishment", "establish"},
		{"establishments", "establish"},
		{"estacado", "estacado"},
		{"estancia", "estancia"},
		{"estancias", "estancia"},
		{"estanciero", "estanciero"},
		{"estate", "estat"},
		{"estates", "estat"},
		{"esteem", "esteem"},
		{"esteemed", "esteem"},
		{"esteeming", "esteem"},
		{"esteems", "esteem"},
		{"esther", "esther"},
		{"esthers", "esther"},
		{"estimable", "estim"},
		{"estimate", "estim"},
		{"estimated", "estim"},
		{"estimates", "estim"},
		{"estimating", "estim"},
		{"estimation", "estim"},
		{"estrange", "estrang"},
		{"estranged", "estrang"},
		{"estrangement", "estrang"},
		{"estranging", "estrang"},
		{"estuaries", "estuari"},
		{"estuary", "estuari"},
		{"et", "et"},
		{"etage", "etag"},
		{"etc", "etc"},
		{"ete", "ete"},
		{"eternal", "etern"},
		{"eternally", "etern"},
		{"eternelle", "eternell"},
		{"eternity", "etern"},
		{"etes", "ete"},
		{"ethereal", "ether"},
		{"etiquette", "etiquett"},
		{"etiquettes", "etiquett"},
		{"etna", "etna"},
		{"eton", "eton"},
		{"etonnement", "etonn"},
		{"etymology", "etymolog"},
		{"eucalypti", "eucalypti"},
		{"eucalyptus", "eucalyptus"},
		{"eudromia", "eudromia"},
		{"eulogistic", "eulogist"},
		{"eulogium", "eulogium"},
		{"euphorbia", "euphorbia"},
		{"euphorbiaceae", "euphorbiacea"},
		{"europe", "europ"},
		{"european", "european"},
		{"europeans", "european"},
		{"eustace", "eustac"},
		{"euston", "euston"},
		{"ev", "ev"},
		{"evade", "evad"},
		{"evaded", "evad"},
		{"evading", "evad"},
		{"evans", "evan"},
		{"evaporate", "evapor"},
		{"evaporated", "evapor"},
		{"evaporates", "evapor"},
		{"evaporation", "evapor"},
		{"evasion", "evas"},
		{"evasions", "evas"},
		{"evasive", "evas"},
		{"evasively", "evas"},
		{"evasiveness", "evas"},
		{"eve", "eve"},
		{"evelyn", "evelyn"},
		{"evelyns", "evelyn"},
		{"even", "even"},
		{"evening", "even"},
		{"evenings", "even"},
		{"evenlng", "evenlng"},
		{"evenly", "even"},
		{"evenness", "even"},
		{"event", "event"},
		{"eventful", "event"},
		{"events", "event"},
		{"eventually", "eventu"},
		{"ever", "ever"},
		{"everbody", "everbodi"},
		{"everbrowns", "everbrown"},
		{"everett", "everett"},
		{"evergreen", "evergreen"},
		{"evergreens", "evergreen"},
		{"everlasting", "everlast"},
		{"everlastingly", "everlast"},
		{"evermore", "evermor"},
		{"evervwhere", "evervwher"},
		{"every", "everi"},
		{"everybody", "everybodi"},
		{"everybodys", "everybodi"},
		{"everyday", "everyday"},
		{"everyone", "everyon"},
		{"everything", "everyth"},
		{"everythink", "everythink"},
		{"everyways", "everyway"},
		{"everywhere", "everywher"},
		{"everywheres", "everywher"},
		{"evidence", "evid"},
		{"evidences", "evid"},
		{"evidenfly", "evidenfli"},
		{"evident", "evid"},
		{"evidently", "evid"},
		{"evil", "evil"},
		{"evils", "evil"},
		{"evince", "evinc"},
		{"evinced", "evinc"},
		{"evincing", "evinc"},
		{"evins", "evin"},
		{"evoke", "evok"},
		{"evoked", "evok"},
		{"evokes", "evok"},
		{"evolution", "evolut"},
		{"evolutions", "evolut"},
		{"ew", "ew"},
		{"ewe", "ewe"},
		{"ewent", "ewent"},
		{"ex", "ex"},
		{"exact", "exact"},
		{"exacted", "exact"},
		{"exacting", "exact"},
		{"exactions", "exact"},
		{"exactitude", "exactitud"},
		{"exactly", "exact"},
		{"exactness", "exact"},
		{"exaggerate", "exagger"},
		{"exaggerated", "exagger"},
		{"exaggerates", "exagger"},
		{"exaggerating", "exagger"},
		{"exaggeration", "exagger"},
		{"exaggerations", "exagger"},
		{"exalt", "exalt"},
		{"exaltation", "exalt"},
		{"exalted", "exalt"},
		{"exalting", "exalt"},
		{"examination", "examin"},
		{"examinations", "examin"},
		{"examine", "examin"},
		{"examined", "examin"},
		{"examines", "examin"},
		{"examining", "examin"},
		{"example", "exampl"},
		{"examples", "exampl"},
		{"exasperated", "exasper"},
		{"exasperating", "exasper"},
		{"exasperation", "exasper"},
		{"excavated", "excav"},
		{"excavation", "excav"},
		{"excavations", "excav"},
		{"exceed", "exceed"},
		{"exceeded", "exceed"},
		{"exceeding", "exceed"},
		{"exceedingly", "exceed"},
		{"exceeds", "exceed"},
		{"excelled", "excel"},
		{"excellence", "excel"},
		{"excellences", "excel"},
		{"excellencies", "excel"},
		{"excellency", "excel"},
		{"excellent", "excel"},
		{"excellently", "excel"},
		{"except", "except"},
		{"excepted", "except"},
		{"excepting", "except"},
		{"exception", "except"},
		{"exceptional", "except"},
		{"exceptionally", "except"},
		{"exceptionalness", "exception"},
		{"exceptions", "except"},
		{"excess", "excess"},
		{"excesses", "excess"},
		{"excessive", "excess"},
		{"excessively", "excess"},
		{"exchange", "exchang"},
		{"exchanged", "exchang"},
		{"exchanges", "exchang"},
		{"exchanging", "exchang"},
		{"exchequer", "exchequ"},
		{"excitable", "excit"},
		{"excitableness", "excit"},
		{"excite", "excit"},
		{"excited", "excit"},
		{"excitedly", "excit"},
		{"excitement", "excit"},
		{"excitements", "excit"},
		{"excites", "excit"},
		{"exciting", "excit"},
		{"exclaim", "exclaim"},
		{"exclaimed", "exclaim"},
		{"exclaiming", "exclaim"},
		{"exclaims", "exclaim"},
		{"exclamation", "exclam"},
		{"exclamations", "exclam"},
		{"exclude", "exclud"},
		{"excluded", "exclud"},
		{"excluding", "exclud"},
		{"exclusion", "exclus"},
		{"exclusions", "exclus"},
		{"exclusive", "exclus"},
		{"exclusively", "exclus"},
		{"exclusiveness", "exclus"},
		{"excoriate", "excori"},
		{"excremens", "excremen"},
		{"excrescence", "excresc"},
		{"excruciatingly", "excruci"},
		{"excursion", "excurs"},
		{"excursions", "excurs"},
		{"excusable", "excus"},
		{"excuse", "excus"},
		{"excused", "excus"},
		{"excuses", "excus"},
		{"excusing", "excus"},
		{"execrable", "execr"},
		{"execrate", "execr"},
		{"execrating", "execr"},
		{"execute", "execut"},
		{"executed", "execut"},
		{"executing", "execut"},
		{"execution", "execut"},
		{"executioner", "execution"},
		{"executions", "execut"},
		{"executive", "execut"},
		{"executor", "executor"},
		{"executors", "executor"},
		{"exemplary", "exemplari"},
		{"exemplified", "exemplifi"},
		{"exemplifies", "exemplifi"},
		{"exemplify", "exemplifi"},
		{"exempt", "exempt"},
		{"exempted", "exempt"},
		{"exemption", "exempt"},
		{"exercise", "exercis"},
		{"exercised", "exercis"},
		{"exercises", "exercis"},
		{"exercising", "exercis"},
		{"exert", "exert"},
		{"exerted", "exert"},
		{"exerting", "exert"},
		{"exertion", "exert"},
		{"exertions", "exert"},
		{"exerts", "exert"},
		{"exeter", "exet"},
		{"exhalations", "exhal"},
		{"exhale", "exhal"},
		{"exhaled", "exhal"},
		{"exhaust", "exhaust"},
		{"exhausted", "exhaust"},
		{"exhausting", "exhaust"},
		{"exhaustion", "exhaust"},
		{"exhaustless", "exhaustless"},
		{"exhausts", "exhaust"},
		{"exhibit", "exhibit"},
		{"exhibited", "exhibit"},
		{"exhibiting", "exhibit"},
		{"exhibition", "exhibit"},
		{"exhibitions", "exhibit"},
		{"exhibits", "exhibit"},
		{"exhilarated", "exhilar"},
		{"exhilarating", "exhilar"},
		{"exhilaration", "exhilar"},
		{"exhort", "exhort"},
		{"exhortation", "exhort"},
		{"exhortations", "exhort"},
		{"exhorted", "exhort"},
		{"exhorting", "exhort"},
		{"exhorts", "exhort"},
		{"exigencies", "exig"},
		{"exile", "exil"},
		{"exiled", "exil"},
		{"exiles", "exil"},
		{"exist", "exist"},
		{"existe", "exist"},
		{"existed", "exist"},
		{"existence", "exist"},
		{"existent", "exist"},
		{"existing", "exist"},
		{"exists", "exist"},
		{"exit", "exit"},
		{"exorbitant", "exorbit"},
		{"exordium", "exordium"},
		{"exotic", "exot"},
		{"exotically", "exot"},
		{"exotics", "exot"},
		{"expand", "expand"},
		{"expande", "expand"},
		{"expanded", "expand"},
		{"expanding", "expand"},
		{"expands", "expand"},
		{"expanse", "expans"},
		{"expanses", "expans"},
		{"expansion", "expans"},
		{"expansions", "expans"},
		{"expansive", "expans"},
		{"expatiate", "expati"},
		{"expatiated", "expati"},
		{"expatiating", "expati"},
		{"expatriated", "expatri"},
		{"expatriation", "expatri"},
		{"expect", "expect"},
		{"expectancy", "expect"},
		{"expectant", "expect"},
		{"expectants", "expect"},
		{"expectation", "expect"},
		{"expectations", "expect"},
		{"expected", "expect"},
		{"expecting", "expect"},
		{"expects", "expect"},
		{"exped", "exp"},
		{"expedience", "expedi"},
		{"expediency", "expedi"},
		{"expedient", "expedi"},
		{"expedients", "expedi"},
		{"expedite", "expedit"},
		{"expedition", "expedit"},
		{"expeditions", "expedit"},
		{"expeditious", "expediti"},
		{"expeditiously", "expediti"},
		{"expel", "expel"},
		{"expelled", "expel"},
		{"expelling", "expel"},
		{"expend", "expend"},
		{"expended", "expend"},
		{"expenditure", "expenditur"},
		{"expense", "expens"},
		{"expenses", "expens"},
		{"expensive", "expens"},
		{"expensively", "expens"},
		{"experience", "experi"},
		{"experienced", "experienc"},
		{"experiences", "experi"},
		{"experiment", "experi"},
		{"experimental", "experiment"},
		{"experimented", "experi"},
		{"experiments", "experi"},
		{"expert", "expert"},
		{"expiate", "expiat"},
		{"expiating", "expiat"},
		{"expiation", "expiat"},
		{"expiration", "expir"},
		{"expire", "expir"},
		{"expired", "expir"},
		{"expiring", "expir"},
		{"explain", "explain"},
		{"explained", "explain"},
		{"explaining", "explain"},
		{"explains", "explain"},
		{"explanation", "explan"},
		{"explanations", "explan"},
		{"explanatory", "explanatori"},
		{"expletive", "explet"},
		{"expletives", "explet"},
		{"expletus", "expletus"},
		{"explicit", "explicit"},
		{"explode", "explod"},
		{"explodes", "explod"},
		{"exploding", "explod"},
		{"exploit", "exploit"},
		{"exploits", "exploit"},
		{"explore", "explor"},
		{"explored", "explor"},
		{"explorer", "explor"},
		{"exploring", "explor"},
		{"explosion", "explos"},
		{"explosions", "explos"},
		{"explosive", "explos"},
		{"exponent", "expon"},
		{"export", "export"},
		{"exportation", "export"},
		{"exported", "export"},
		{"exports", "export"},
		{"expose", "expos"},
		{"exposed", "expos"},
		{"exposes", "expos"},
		{"exposing", "expos"},
		{"exposition", "exposit"},
		{"expostulate", "expostul"},
		{"expostulated", "expostul"},
		{"expostulating", "expostul"},
		{"expostulation", "expostul"},
		{"exposure", "exposur"},
		{"expound", "expound"},
		{"expounding", "expound"},
		{"express", "express"},
		{"expressed", "express"},
		{"expresses", "express"},
		{"expressing", "express"},
		{"expression", "express"},
		{"expressionless", "expressionless"},
		{"expressions", "express"},
		{"expressive", "express"},
		{"expressively", "express"},
		{"expressly", "expressli"},
		{"expulsion", "expuls"},
		{"exquisite", "exquisit"},
		{"exquisitely", "exquisit"},
		{"exquisites", "exquisit"},
		{"exserted", "exsert"},
		{"extant", "extant"},
		{"extemporaneously", "extemporan"},
		{"extemporary", "extemporari"},
		{"extemporized", "extempor"},
		{"extend", "extend"},
		{"extended", "extend"},
		{"extending", "extend"},
		{"extends", "extend"},
		{"extensile", "extensil"},
		{"extension", "extens"},
		{"extensive", "extens"},
		{"extensively", "extens"},
		{"extent", "extent"},
		{"extenuating", "extenu"},
		{"extenuation", "extenu"},
		{"exterior", "exterior"},
		{"exterminated", "extermin"},
		{"exterminating", "extermin"},
		{"extermination", "extermin"},
		{"exterminations", "extermin"},
		{"external", "extern"},
		{"externally", "extern"},
		{"extinct", "extinct"},
		{"extinction", "extinct"},
		{"extinguish", "extinguish"},
		{"extinguished", "extinguish"},
		{"extinguisher", "extinguish"},
		{"extinguishers", "extinguish"},
		{"extinguishes", "extinguish"},
		{"extinguishing", "extinguish"},
		{"extirpating", "extirp"},
		{"extol", "extol"},
		{"extolled", "extol"},
		{"extolling", "extol"},
		{"extort", "extort"},
		{"extorted", "extort"},
		{"extorting", "extort"},
		{"extortion", "extort"},
		{"extortions", "extort"},
		{"extra", "extra"},
		{"extract", "extract"},
		{"extracted", "extract"},
		{"extracting", "extract"},
		{"extraction", "extract"},
		{"extracts", "extract"},
		{"extraneous", "extran"},
		{"extraordinarily", "extraordinarili"},
		{"extraordinary", "extraordinari"},
		{"extras", "extra"},
		{"extravagance", "extravag"},
		{"extravagances", "extravag"},
		{"extravagant", "extravag"},
		{"extreme", "extrem"},
		{"extremely", "extrem"},
		{"extremes", "extrem"},
		{"extremest", "extremest"},
		{"extremities", "extrem"},
		{"extremity", "extrem"},
		{"extremum", "extremum"},
		{"extricate", "extric"},
		{"extricated", "extric"},
		{"extricating", "extric"},
		{"extrication", "extric"},
		{"exuberant", "exuber"},
		{"exudations", "exud"},
		{"exuded", "exud"},
		{"exultation", "exult"},
		{"exulted", "exult"},
		{"exulting", "exult"},
		{"exultingly", "exult"},
		{"exults", "exult"},
		{"ey", "ey"},
		{"eye", "eye"},
		{"eyeball", "eyebal"},
		{"eyebrow", "eyebrow"},
		{"eyebrows", "eyebrow"},
		{"eyed", "eye"},
		{"eyeglass", "eyeglass"},
		{"eyeing", "eye"},
		{"eyelash", "eyelash"},
		{"eyelashes", "eyelash"},
		{"eyelid", "eyelid"},
		{"eyelids", "eyelid"},
		{"eyes", "eye"},
		{"eyesight", "eyesight"},
		{"eyesore", "eyesor"},
		{"eyre", "eyr"},
		{"ezactly", "ezact"},
		{"f", "f"},
		{"fa", "fa"},
		{"fable", "fabl"},
		{"fabled", "fabl"},
		{"fables", "fabl"},
		{"fabric", "fabric"},
		{"fabricated", "fabric"},
		{"fabricius", "fabricius"},
		{"fabulous", "fabul"},
		{"fabulously", "fabul"},
		{"facade", "facad"},
		{"face", "face"},
		{"faced", "face"},
		{"faces", "face"},
		{"facetious", "faceti"},
		{"facetiously", "faceti"},
		{"facetiousness", "faceti"},
		{"facial", "facial"},
		{"facile", "facil"},
		{"facilitate", "facilit"},
		{"facilitates", "facilit"},
		{"facilitating", "facilit"},
		{"facilities", "facil"},
		{"facility", "facil"},
		{"facing", "face"},
		{"facings", "face"},
		{"fact", "fact"},
		{"faction", "faction"},
		{"factor", "factor"},
		{"factors", "factor"},
		{"factory", "factori"},
		{"facts", "fact"},
		{"faculties", "faculti"},
		{"faculty", "faculti"},
		{"fade", "fade"},
		{"faded", "fade"},
		{"fadedly", "fade"},
		{"fades", "fade"},
		{"fading", "fade"},
		{"fag", "fag"},
		{"fagged", "fag"},
		{"faggot", "faggot"},
		{"fagus", "fagus"},
		{"fah", "fah"},
		{"fail", "fail"},
		{"failed", "fail"},
		{"failing", "fail"},
		{"failings", "fail"},
		{"fails", "fail"},
		{"failure", "failur"},
		{"failures", "failur"},
		{"fain", "fain"},
		{"faineant", "faineant"},
		{"faineants", "faineant"},
		{"faint", "faint"},
		{"fainted", "faint"},
		{"fainter", "fainter"},
		{"faintest", "faintest"},
		{"fainting", "faint"},
		{"faintings", "faint"},
		{"faintly", "faint"},
		{"faintness", "faint"},
		{"faints", "faint"},
		{"fair", "fair"},
		{"faire", "fair"},
		{"fairer", "fairer"},
		{"fairest", "fairest"},
		{"fairies", "fairi"},
		{"fairish", "fairish"},
		{"fairly", "fair"},
		{"fairness", "fair"},
		{"fairy", "fairi"},
		{"fait", "fait"},
		{"faith", "faith"},
		{"faithful", "faith"},
		{"faithfuller", "faithful"},
		{"faithfully", "faith"},
		{"faithfulness", "faith"},
		{"falconer", "falcon"},
		{"falkland", "falkland"},
		{"falklands", "falkland"},
		{"fall", "fall"},
		{"fallacy", "fallaci"},
		{"fallen", "fallen"},
		{"fallible", "fallibl"},
		{"fallin", "fallin"},
		{"falling", "fall"},
		{"falls", "fall"},
		{"falmouth", "falmouth"},
		{"false", "fals"},
		{"falsehood", "falsehood"},
		{"falsehoods", "falsehood"},
		{"falsely", "fals"},
		{"falseness", "fals"},
		{"falser", "falser"},
		{"falsetto", "falsetto"},
		{"falsify", "falsifi"},
		{"falsity", "falsiti"},
		{"falter", "falter"},
		{"faltered", "falter"},
		{"faltering", "falter"},
		{"falteringly", "falter"},
		{"falters", "falter"},
		{"fame", "fame"},
		{"famed", "fame"},
		{"familiar", "familiar"},
		{"familiaris", "familiari"},
		{"familiarised", "familiaris"},
		{"familiarities", "familiar"},
		{"familiarity", "familiar"},
		{"familiarized", "familiar"},
		{"familiarly", "familiar"},
		{"familiars", "familiar"},
		{"families", "famili"},
		{"family", "famili"},
		{"famine", "famin"},
		{"famines", "famin"},
		{"famished", "famish"},
		{"famoso", "famoso"},
		{"famous", "famous"},
		{"famously", "famous"},
		{"fan", "fan"},
		{"fanaticism", "fanatic"},
		{"fancied", "fanci"},
		{"fancier", "fancier"},
		{"fancies", "fanci"},
		{"fanciful", "fanci"},
		{"fancy", "fanci"},
		{"fancying", "fanci"},
		{"faneant", "faneant"},
		{"fangs", "fang"},
		{"fanlight", "fanlight"},
		{"fanned", "fan"},
		{"fanny", "fanni"},
		{"fans", "fan"},
		{"fanshawe", "fanshaw"},
		{"fantastic", "fantast"},
		{"fantastical", "fantast"},
		{"fantastically", "fantast"},
		{"fantasy", "fantasi"},
		{"far", "far"},
		{"farce", "farc"},
		{"fare", "fare"},
		{"fared", "fare"},
		{"fares", "fare"},
		{"farewell", "farewel"},
		{"farewells", "farewel"},
		{"farinha", "farinha"},
		{"farm", "farm"},
		{"farmed", "farm"},
		{"farmer", "farmer"},
		{"farmers", "farmer"},
		{"farmhouse", "farmhous"},
		{"farmhouses", "farmhous"},
		{"farming", "farm"},
		{"farms", "farm"},
		{"farrago", "farrago"},
		{"farther", "farther"},
		{"farthest", "farthest"},
		{"farthing", "farth"},
		{"farthings", "farth"},
		{"fascinate", "fascin"},
		{"fascinated", "fascin"},
		{"fascinating", "fascin"},
		{"fascination", "fascin"},
		{"fascinations", "fascin"},
		{"fascinator", "fascin"},
		{"fash", "fash"},
		{"fashion", "fashion"},
		{"fashionable", "fashion"},
		{"fashionably", "fashion"},
		{"fashionahle", "fashionahl"},
		{"fashioned", "fashion"},
		{"fashions", "fashion"},
		{"fast", "fast"},
		{"fasten", "fasten"},
		{"fastened", "fasten"},
		{"fastening", "fasten"},
		{"fastenings", "fasten"},
		{"fastens", "fasten"},
		{"faster", "faster"},
		{"fastest", "fastest"},
		{"fastidious", "fastidi"},
		{"fastidiousness", "fastidi"},
		{"fasting", "fast"},
		{"fastness", "fast"},
		{"fat", "fat"},
		{"fatal", "fatal"},
		{"fate", "fate"},
		{"fated", "fate"},
		{"fateful", "fate"},
		{"fates", "fate"},
		{"father", "father"},
		{"fatherland", "fatherland"},
		{"fatherless", "fatherless"},
		{"fatherly", "father"},
		{"fathers", "father"},
		{"fathom", "fathom"},
		{"fathomless", "fathomless"},
		{"fathoms", "fathom"},
		{"fatigue", "fatigu"},
		{"fatigued", "fatigu"},
		{"fatigues", "fatigu"},
		{"fatiguing", "fatigu"},
		{"fatima", "fatima"},
		{"fatly", "fat"},
		{"fatness", "fat"},
		{"fatten", "fatten"},
		{"fattened", "fatten"},
		{"fattening", "fatten"},
		{"fatter", "fatter"},
		{"fattish", "fattish"},
		{"fatuity", "fatuiti"},
		{"faugh", "faugh"},
		{"fault", "fault"},
		{"faultless", "faultless"},
		{"faults", "fault"},
		{"fauna", "fauna"},
		{"faux", "faux"},
		{"favour", "favour"},
		{"favourable", "favour"},
		{"favourably", "favour"},
		{"favoured", "favour"},
		{"favouring", "favour"},
		{"favourite", "favourit"},
		{"favourites", "favourit"},
		{"favours", "favour"},
		{"fawn", "fawn"},
		{"fawned", "fawn"},
		{"fawning", "fawn"},
		{"fawns", "fawn"},
		{"fazenda", "fazenda"},
		{"fazendas", "fazenda"},
		{"fe", "fe"},
		{"feace", "feac"},
		{"feaced", "feac"},
		{"fealty", "fealti"},
		{"fear", "fear"},
		{"feared", "fear"},
		{"feareth", "feareth"},
		{"fearful", "fear"},
		{"fearfully", "fear"},
		{"fearfulty", "fearfulti"},
		{"fearing", "fear"},
		{"feariocious", "fearioci"},
		{"fearless", "fearless"},
		{"fearlessly", "fearless"},
		{"fears", "fear"},
		{"feasible", "feasibl"},
		{"feast", "feast"},
		{"feasted", "feast"},
		{"feasting", "feast"},
		{"feasts", "feast"},
		{"feat", "feat"},
		{"feather", "feather"},
		{"featherbed", "featherb"},
		{"feathered", "feather"},
		{"feathers", "feather"},
		{"feathery", "featheri"},
		{"feats", "feat"},
		{"feature", "featur"},
		{"featured", "featur"},
		{"features", "featur"},
		{"feb", "feb"},
		{"februa", "februa"},
		{"february", "februari"},
		{"fed", "fed"},
		{"fedosya", "fedosya"},
		{"fedyaev", "fedyaev"},
		{"fee", "fee"},
		{"feeble", "feebl"},
		{"feebleness", "feebl"},
		{"feebler", "feebler"},
		{"feebly", "feebli"},
		{"feeckle", "feeckl"},
		{"feed", "feed"},
		{"feeder", "feeder"},
		{"feeders", "feeder"},
		{"feeding", "feed"},
		{"feeds", "feed"},
		{"feel", "feel"},
		{"feeling", "feel"},
		{"feelingly", "feel"},
		{"feelings", "feel"},
		{"feels", "feel"},
		{"fees", "fee"},
		{"feet", "feet"},
		{"feign", "feign"},
		{"feigned", "feign"},
		{"feigning", "feign"},
		{"feigns", "feign"},
		{"feijao", "feijao"},
		{"feint", "feint"},
		{"feints", "feint"},
		{"fel", "fel"},
		{"feldspathic", "feldspath"},
		{"felicitations", "felicit"},
		{"felicitous", "felicit"},
		{"felicitously", "felicit"},
		{"felicity", "felic"},
		{"feline", "felin"},
		{"felipe", "felip"},
		{"felix", "felix"},
		{"fell", "fell"},
		{"felled", "fell"},
		{"feller", "feller"},
		{"fellow", "fellow"},
		{"fellows", "fellow"},
		{"fellowship", "fellowship"},
		{"felo", "felo"},
		{"felon", "felon"},
		{"feloniously", "feloni"},
		{"felons", "felon"},
		{"felony", "feloni"},
		{"felspar", "felspar"},
		{"felspathic", "felspath"},
		{"felt", "felt"},
		{"female", "femal"},
		{"females", "femal"},
		{"feminine", "feminin"},
		{"fen", "fen"},
		{"fence", "fenc"},
		{"fenced", "fenc"},
		{"fences", "fenc"},
		{"fencing", "fenc"},
		{"fender", "fender"},
		{"fennel", "fennel"},
		{"fens", "fen"},
		{"ferdinand", "ferdinand"},
		{"ferdy", "ferdi"},
		{"ferguson", "ferguson"},
		{"ferment", "ferment"},
		{"fermentable", "ferment"},
		{"fermenting", "ferment"},
		{"fern", "fern"},
		{"fernal", "fernal"},
		{"fernandez", "fernandez"},
		{"fernando", "fernando"},
		{"fernery", "ferneri"},
		{"ferns", "fern"},
		{"ferocious", "feroci"},
		{"ferociously", "feroci"},
		{"ferocity", "feroc"},
		{"feronia", "feronia"},
		{"ferret", "ferret"},
		{"ferreted", "ferret"},
		{"ferried", "ferri"},
		{"ferruginous", "ferrugin"},
		{"ferrule", "ferrul"},
		{"ferry", "ferri"},
		{"fertile", "fertil"},
		{"fertility", "fertil"},
		{"fertilizing", "fertil"},
		{"ferule", "ferul"},
		{"fervency", "fervenc"},
		{"fervent", "fervent"},
		{"fervently", "fervent"},
		{"fervid", "fervid"},
		{"fervour", "fervour"},
		{"fester", "fester"},
		{"festering", "fester"},
		{"festival", "festiv"},
		{"festivals", "festiv"},
		{"festive", "festiv"},
		{"festivities", "festiv"},
		{"festivity", "festiv"},
		{"festoon", "festoon"},
		{"festoons", "festoon"},
		{"fetch", "fetch"},
		{"fetched", "fetch"},
		{"fetches", "fetch"},
		{"fetching", "fetch"},
		{"feted", "fete"},
		{"fetid", "fetid"},
		{"fetlock", "fetlock"},
		{"fetlocks", "fetlock"},
		{"fetters", "fetter"},
		{"feud", "feud"},
		{"feudal", "feudal"},
		{"feury", "feuri"},
		{"fever", "fever"},
		{"fevered", "fever"},
		{"feverish", "feverish"},
		{"feverishly", "feverish"},
		{"feverishness", "feverish"},
		{"fevers", "fever"},
		{"few", "few"},
		{"fewer", "fewer"},
		{"fewest", "fewest"},
		{"fewness", "few"},
		{"feyther", "feyther"},
		{"feythers", "feyther"},
		{"fiance", "fianc"},
		{"fiancee", "fiance"},
		{"fiat", "fiat"},
		{"fib", "fib"},
		{"fibbing", "fib"},
		{"fibre", "fibr"},
		{"fibres", "fibr"},
		{"fibrous", "fibrous"},
		{"fibs", "fib"},
		{"fichy", "fichi"},
		{"fickle", "fickl"},
		{"fickleness", "fickl"},
		{"fico", "fico"},
		{"fiction", "fiction"},
		{"fictions", "fiction"},
		{"fictitious", "fictiti"},
		{"fiddle", "fiddl"},
		{"fiddles", "fiddl"},
		{"fiddlesticks", "fiddlestick"},
		{"fide", "fide"},
		{"fidelity", "fidel"},
		{"fidget", "fidget"},
		{"fidgeted", "fidget"},
		{"fidgeting", "fidget"},
		{"fidgett", "fidgett"},
		{"fidgetts", "fidgett"},
		{"fidgety", "fidgeti"},
		{"fie", "fie"},
		{"field", "field"},
		{"fieldfare", "fieldfar"},
		{"fieldingsby", "fieldingsbi"},
		{"fields", "field"},
		{"fiend", "fiend"},
		{"fiendish", "fiendish"},
		{"fierce", "fierc"},
		{"fiercely", "fierc"},
		{"fierceness", "fierc"},
		{"fiercer", "fiercer"},
		{"fiercest", "fiercest"},
		{"fiery", "fieri"},
		{"fife", "fife"},
		{"fifer", "fifer"},
		{"fifteen", "fifteen"},
		{"fifteenth", "fifteenth"},
		{"fifth", "fifth"},
		{"fifthly", "fifth"},
		{"fifths", "fifth"},
		{"fifty", "fifti"},
		{"fig", "fig"},
		{"fight", "fight"},
		{"fighter", "fighter"},
		{"fighting", "fight"},
		{"fights", "fight"},
		{"figment", "figment"},
		{"figs", "fig"},
		{"figuireda", "figuireda"},
		{"figurative", "figur"},
		{"figure", "figur"},
		{"figured", "figur"},
		{"figures", "figur"},
		{"figuring", "figur"},
		{"filamentous", "filament"},
		{"filched", "filch"},
		{"file", "file"},
		{"filed", "file"},
		{"files", "file"},
		{"filial", "filial"},
		{"filigree", "filigre"},
		{"filing", "file"},
		{"filka", "filka"},
		{"fill", "fill"},
		{"fille", "fill"},
		{"filled", "fill"},
		{"fillet", "fillet"},
		{"filling", "fill"},
		{"fillip", "fillip"},
		{"fills", "fill"},
		{"film", "film"},
		{"films", "film"},
		{"filtered", "filter"},
		{"filtering", "filter"},
		{"filth", "filth"},
		{"filthily", "filthili"},
		{"filthiness", "filthi"},
		{"filthy", "filthi"},
		{"fin", "fin"},
		{"final", "final"},
		{"finally", "final"},
		{"finance", "financ"},
		{"finances", "financ"},
		{"financial", "financi"},
		{"finch", "finch"},
		{"finches", "finch"},
		{"find", "find"},
		{"finding", "find"},
		{"finds", "find"},
		{"fine", "fine"},
		{"finely", "fine"},
		{"finer", "finer"},
		{"finery", "fineri"},
		{"finest", "finest"},
		{"finger", "finger"},
		{"fingered", "finger"},
		{"fingerends", "fingerend"},
		{"fingerless", "fingerless"},
		{"fingers", "finger"},
		{"finis", "fini"},
		{"finish", "finish"},
		{"finished", "finish"},
		{"finishes", "finish"},
		{"finishing", "finish"},
		{"finlshed", "finlsh"},
		{"finn", "finn"},
		{"finnish", "finnish"},
		{"fins", "fin"},
		{"finsbury", "finsburi"},
		{"fiord", "fiord"},
		{"fir", "fir"},
		{"fire", "fire"},
		{"firearms", "firearm"},
		{"firebrand", "firebrand"},
		{"fired", "fire"},
		{"fireflies", "firefli"},
		{"firelight", "firelight"},
		{"fireman", "fireman"},
		{"fireplace", "fireplac"},
		{"fires", "fire"},
		{"fireside", "firesid"},
		{"firesides", "firesid"},
		{"firewood", "firewood"},
		{"firework", "firework"},
		{"fireworks", "firework"},
		{"firing", "fire"},
		{"firm", "firm"},
		{"firma", "firma"},
		{"firmament", "firmament"},
		{"firmaments", "firmament"},
		{"firmer", "firmer"},
		{"firmest", "firmest"},
		{"firmly", "firm"},
		{"firmness", "firm"},
		{"firs", "fir"},
		{"first", "first"},
		{"firstborn", "firstborn"},
		{"firstly", "first"},
		{"fis", "fis"},
		{"fiscal", "fiscal"},
		{"fish", "fish"},
		{"fished", "fish"},
		{"fisherman", "fisherman"},
		{"fishermen", "fishermen"},
		{"fishes", "fish"},
		{"fishing", "fish"},
		{"fishmonger", "fishmong"},
		{"fissure", "fissur"},
		{"fissured", "fissur"},
		{"fissurella", "fissurella"},
		{"fissurellae", "fissurella"},
		{"fissures", "fissur"},
		{"fist", "fist"},
		{"fisted", "fist"},
		{"fists", "fist"},
		{"fit", "fit"},
		{"fitful", "fit"},
		{"fitfully", "fit"},
		{"fitly", "fit"},
		{"fitness", "fit"},
		{"fitnesses", "fit"},
		{"fits", "fit"},
		{"fitted", "fit"},
		{"fitter", "fitter"},
		{"fittest", "fittest"},
		{"fitting", "fit"},
		{"fittings", "fit"},
		{"fitz", "fitz"},
		{"fitzgibbon", "fitzgibbon"},
		{"fitzgibbons", "fitzgibbon"},
		{"fitzhugh", "fitzhugh"},
		{"fitzroy", "fitzroy"},
		{"five", "five"},
		{"fiver", "fiver"},
		{"fives", "five"},
		{"fix", "fix"},
		{"fixed", "fix"},
		{"fixedly", "fix"},
		{"fixes", "fix"},
		{"fixing", "fix"},
		{"fixity", "fixiti"},
		{"fixture", "fixtur"},
		{"fixtures", "fixtur"},
		{"flabbily", "flabbili"},
		{"flabby", "flabbi"},
		{"flabella", "flabella"},
		{"flaco", "flaco"},
		{"flag", "flag"},
		{"flagellation", "flagel"},
		{"flagellator", "flagel"},
		{"flagged", "flag"},
		{"flagging", "flag"},
		{"flagrant", "flagrant"},
		{"flagrantly", "flagrant"},
		{"flags", "flag"},
		{"flagstaff", "flagstaff"},
		{"flake", "flake"},
		{"flakes", "flake"},
		{"flambeaux", "flambeaux"},
		{"flame", "flame"},
		{"flames", "flame"},
		{"flaming", "flame"},
		{"flamingoes", "flamingo"},
		{"flank", "flank"},
		{"flanked", "flank"},
		{"flanks", "flank"},
		{"flannel", "flannel"},
		{"flap", "flap"},
		{"flapped", "flap"},
		{"flapping", "flap"},
		{"flaps", "flap"},
		{"flare", "flare"},
		{"flares", "flare"},
		{"flaring", "flare"},
		{"flash", "flash"},
		{"flashed", "flash"},
		{"flashes", "flash"},
		{"flashing", "flash"},
		{"flashy", "flashi"},
		{"flask", "flask"},
		{"flat", "flat"},
		{"flatly", "flat"},
		{"flatness", "flat"},
		{"flats", "flat"},
		{"flattened", "flatten"},
		{"flattening", "flatten"},
		{"flatter", "flatter"},
		{"flattered", "flatter"},
		{"flatterer", "flatter"},
		{"flatterers", "flatter"},
		{"flattering", "flatter"},
		{"flatters", "flatter"},
		{"flattery", "flatteri"},
		{"flattest", "flattest"},
		{"flattish", "flattish"},
		{"flavor", "flavor"},
		{"flavour", "flavour"},
		{"flavoured", "flavour"},
		{"flaw", "flaw"},
		{"flawed", "flaw"},
		{"flaws", "flaw"},
		{"flax", "flax"},
		{"flaxen", "flaxen"},
		{"flaying", "flay"},
		{"flea", "flea"},
		{"fleas", "flea"},
		{"fleck", "fleck"},
		{"flecked", "fleck"},
		{"fled", "fled"},
		{"fledged", "fledg"},
		{"fledgling", "fledgl"},
		{"fledglings", "fledgl"},
		{"flee", "flee"},
		{"fleece", "fleec"},
		{"fleecy", "fleeci"},
		{"fleet", "fleet"},
		{"fleeting", "fleet"},
		{"fleetingly", "fleet"},
		{"flemish", "flemish"},
		{"fler", "fler"},
		{"flesh", "flesh"},
		{"fleshing", "flesh"},
		{"fleshly", "flesh"},
		{"fleshy", "fleshi"},
		{"fletcher", "fletcher"},
		{"fletcherites", "fletcherit"},
		{"fletchers", "fletcher"},
		{"flew", "flew"},
		{"flexibility", "flexibl"},
		{"flexible", "flexibl"},
		{"flexure", "flexur"},
		{"flickering", "flicker"},
		{"flickers", "flicker"},
		{"flicking", "flick"},
		{"flier", "flier"},
		{"flies", "fli"},
		{"flight", "flight"},
		{"flights", "flight"},
		{"flighty", "flighti"},
		{"flinch", "flinch"},
		{"flinching", "flinch"},
		{"flinder", "flinder"},
		{"flinders", "flinder"},
		{"fling", "fling"},
		{"flinging", "fling"},
		{"flings", "fling"},
		{"flint", "flint"},
		{"flinty", "flinti"},
		{"flippant", "flippant"},
		{"flipping", "flip"},
		{"flirt", "flirt"},
		{"flirtation", "flirtat"},
		{"flirtations", "flirtat"},
		{"flirted", "flirt"},
		{"flirting", "flirt"},
		{"flirts", "flirt"},
		{"flit", "flit"},
		{"flite", "flite"},
		{"flits", "flit"},
		{"flitted", "flit"},
		{"flitting", "flit"},
		{"float", "float"},
		{"floated", "float"},
		{"floating", "float"},
		{"floats", "float"},
		{"flocculent", "floccul"},
		{"flock", "flock"},
		{"flocked", "flock"},
		{"flocking", "flock"},
		{"flocks", "flock"},
		{"flog", "flog"},
		{"flogged", "flog"},
		{"flogging", "flog"},
		{"flood", "flood"},
		{"flooded", "flood"},
		{"floodgates", "floodgat"},
		{"flooding", "flood"},
		{"floods", "flood"},
		{"floor", "floor"},
		{"floored", "floor"},
		{"flooring", "floor"},
		{"floors", "floor"},
		{"flop", "flop"},
		{"flora", "flora"},
		{"floral", "floral"},
		{"florence", "florenc"},
		{"florian", "florian"},
		{"floriated", "floriat"},
		{"florid", "florid"},
		{"florist", "florist"},
		{"florula", "florula"},
		{"flotilla", "flotilla"},
		{"flounce", "flounc"},
		{"flounced", "flounc"},
		{"flounces", "flounc"},
		{"flouncing", "flounc"},
		{"floundered", "flounder"},
		{"floundering", "flounder"},
		{"flour", "flour"},
		{"floured", "flour"},
		{"flourish", "flourish"},
		{"flourished", "flourish"},
		{"flourishes", "flourish"},
		{"flourishing", "flourish"},
		{"flow", "flow"},
		{"flowed", "flow"},
		{"flower", "flower"},
		{"flowering", "flower"},
		{"flowers", "flower"},
		{"flowing", "flow"},
		{"flown", "flown"},
		{"flows", "flow"},
		{"flrst", "flrst"},
		{"flu", "flu"},
		{"fluctuate", "fluctuat"},
		{"fluctuated", "fluctuat"},
		{"fluctuating", "fluctuat"},
		{"flue", "flue"},
		{"fluent", "fluent"},
		{"fluently", "fluentli"},
		{"fluffles", "fluffl"},
		{"fluggers", "flugger"},
		{"fluid", "fluid"},
		{"fluidified", "fluidifi"},
		{"fluids", "fluid"},
		{"flung", "flung"},
		{"flunkey", "flunkey"},
		{"flurried", "flurri"},
		{"flurries", "flurri"},
		{"flurry", "flurri"},
		{"flush", "flush"},
		{"flushed", "flush"},
		{"flushes", "flush"},
		{"flushing", "flush"},
		{"flustered", "fluster"},
		{"flustra", "flustra"},
		{"flustraceae", "flustracea"},
		{"flute", "flute"},
		{"flutes", "flute"},
		{"flutings", "flute"},
		{"flutter", "flutter"},
		{"fluttered", "flutter"},
		{"flutterers", "flutter"},
		{"fluttering", "flutter"},
		{"flutteringiy", "flutteringiy"},
		{"flutters", "flutter"},
		{"fly", "fli"},
		{"flycatcher", "flycatch"},
		{"flycatchers", "flycatch"},
		{"flying", "fli"},
		{"flys", "flys"},
		{"fo", "fo"},
		{"foal", "foal"},
		{"foals", "foal"},
		{"foam", "foam"},
		{"foaming", "foam"},
		{"fob", "fob"},
		{"focus", "focus"},
		{"fodere", "foder"},
		{"foe", "foe"},
		{"foes", "foe"},
		{"foetid", "foetid"},
		{"fog", "fog"},
		{"fogeys", "fogey"},
		{"foggy", "foggi"},
		{"fogies", "fogi"},
		{"fogs", "fog"},
		{"fogy", "fogi"},
		{"foh", "foh"},
		{"foibles", "foibl"},
		{"foil", "foil"},
		{"foiled", "foil"},
		{"foind", "foind"},
		{"foinds", "foind"},
		{"folair", "folair"},
		{"fold", "fold"},
		{"folded", "fold"},
		{"folding", "fold"},
		{"folds", "fold"},
		{"foliaceous", "foliac"},
		{"foliage", "foliag"},
		{"folio", "folio"},
		{"folk", "folk"},
		{"folkestone", "folkeston"},
		{"folks", "folk"},
		{"foller", "foller"},
		{"follerer", "foller"},
		{"follerers", "foller"},
		{"follering", "foller"},
		{"follies", "folli"},
		{"follow", "follow"},
		{"followed", "follow"},
		{"follower", "follow"},
		{"followers", "follow"},
		{"following", "follow"},
		{"follows", "follow"},
		{"folly", "folli"},
		{"fomentation", "foment"},
		{"fomitch", "fomitch"},
		{"fond", "fond"},
		{"fonder", "fonder"},
		{"fondest", "fondest"},
		{"fondle", "fondl"},
		{"fondles", "fondl"},
		{"fondling", "fondl"},
		{"fondly", "fond"},
		{"fondness", "fond"},
		{"font", "font"},
		{"foo", "foo"},
		{"food", "food"},
		{"foodle", "foodl"},
		{"fool", "fool"},
		{"fooled", "fool"},
		{"fooleries", "fooleri"},
		{"foolery", "fooleri"},
		{"fooling", "fool"},
		{"foolish", "foolish"},
		{"foolishly", "foolish"},
		{"foolishness", "foolish"},
		{"fools", "fool"},
		{"foolscap", "foolscap"},
		{"foot", "foot"},
		{"football", "footbal"},
		{"footboy", "footboy"},
		{"footed", "foot"},
		{"footer", "footer"},
		{"footfall", "footfal"},
		{"footguards", "footguard"},
		{"foothold", "foothold"},
		{"footing", "foot"},
		{"footlights", "footlight"},
		{"footman", "footman"},
		{"footmen", "footmen"},
		{"footpad", "footpad"},
		{"footpath", "footpath"},
		{"footprint", "footprint"},
		{"footprints", "footprint"},
		{"footsore", "footsor"},
		{"footstep", "footstep"},
		{"footsteps", "footstep"},
		{"footstool", "footstool"},
		{"footstools", "footstool"},
		{"footway", "footway"},
		{"footways", "footway"},
		{"foppish", "foppish"},
		{"for", "for"},
		{"foragers", "forag"},
		{"forard", "forard"},
		{"forards", "forard"},
		{"forasmuch", "forasmuch"},
		{"forbade", "forbad"},
		{"forbear", "forbear"},
		{"forbearance", "forbear"},
		{"forbearing", "forbear"},
		{"forbearingly", "forbear"},
		{"forbears", "forbear"},
		{"forbes", "forb"},
		{"forbid", "forbid"},
		{"forbidden", "forbidden"},
		{"forbidding", "forbid"},
		{"forbids", "forbid"},
		{"forbore", "forbor"},
		{"force", "forc"},
		{"forced", "forc"},
		{"forceps", "forcep"},
		{"forces", "forc"},
		{"forcible", "forcibl"},
		{"forcibly", "forcibl"},
		{"forcing", "forc"},
		{"ford", "ford"},
		{"forded", "ford"},
		{"fore", "fore"},
		{"foreboded", "forebod"},
		{"foreboding", "forebod"},
		{"forebodings", "forebod"},
		{"forecast", "forecast"},
		{"forecoming", "forecom"},
		{"forefathers", "forefath"},
		{"forefinger", "forefing"},
		{"forefingers", "forefing"},
		{"foregathered", "foregath"},
		{"forego", "forego"},
		{"foregoing", "forego"},
		{"foregone", "foregon"},
		{"foreground", "foreground"},
		{"forehead", "forehead"},
		{"foreheads", "forehead"},
		{"foreign", "foreign"},
		{"foreigner", "foreign"},
		{"foreigners", "foreign"},
		{"forelock", "forelock"},
		{"foreman", "foreman"},
		{"foremost", "foremost"},
		{"forenoon", "forenoon"},
		{"forensic", "forens"},
		{"forerunner", "forerunn"},
		{"foresaw", "foresaw"},
		{"foresee", "forese"},
		{"foreseeing", "forese"},
		{"foreseen", "foreseen"},
		{"foresees", "forese"},
		{"foreshadow", "foreshadow"},
		{"foreshadowing", "foreshadow"},
		{"foreshortened", "foreshorten"},
		{"foresight", "foresight"},
		{"forest", "forest"},
		{"forests", "forest"},
		{"foretaste", "foretast"},
		{"foretell", "foretel"},
		{"foretelling", "foretel"},
		{"forethought", "forethought"},
		{"foretold", "foretold"},
		{"forever", "forev"},
		{"forewarned", "forewarn"},
		{"forewarning", "forewarn"},
		{"forewarnings", "forewarn"},
		{"forewoman", "forewoman"},
		{"forfeit", "forfeit"},
		{"forfeited", "forfeit"},
		{"forfeiting", "forfeit"},
		{"forfeits", "forfeit"},
		{"forficatus", "forficatus"},
		{"forgave", "forgav"},
		{"forge", "forg"},
		{"forged", "forg"},
		{"forgeries", "forgeri"},
		{"forgery", "forgeri"},
		{"forget", "forget"},
		{"forgetful", "forget"},
		{"forgetfulness", "forget"},
		{"forgets", "forget"},
		{"forgetting", "forget"},
		{"forgi", "forgi"},
		{"forging", "forg"},
		{"forgive", "forgiv"},
		{"forgiven", "forgiven"},
		{"forgiveness", "forgiv"},
		{"forgives", "forgiv"},
		{"forgiving", "forgiv"},
		{"forgivingly", "forgiv"},
		{"forgot", "forgot"},
		{"forgotten", "forgotten"},
		{"fork", "fork"},
		{"forked", "fork"},
		{"forks", "fork"},
		{"forlorn", "forlorn"},
		{"forlornest", "forlornest"},
		{"forlornly", "forlorn"},
		{"form", "form"},
		{"formal", "formal"},
		{"formalities", "formal"},
		{"formality", "formal"},
		{"formally", "formal"},
		{"formation", "format"},
		{"formations", "format"},
		{"formed", "form"},
		{"former", "former"},
		{"formerly", "former"},
		{"formidable", "formid"},
		{"forming", "form"},
		{"forms", "form"},
		{"forrard", "forrard"},
		{"forrenner", "forrenn"},
		{"forres", "forr"},
		{"forsake", "forsak"},
		{"forsaken", "forsaken"},
		{"forsaking", "forsak"},
		{"forsook", "forsook"},
		{"forster", "forster"},
		{"forsworn", "forsworn"},
		{"fort", "fort"},
		{"forte", "fort"},
		{"forth", "forth"},
		{"forthcoming", "forthcom"},
		{"forthwith", "forthwith"},
		{"fortification", "fortif"},
		{"fortifications", "fortif"},
		{"fortified", "fortifi"},
		{"fortifying", "fortifi"},
		{"fortis", "forti"},
		{"fortitude", "fortitud"},
		{"fortnight", "fortnight"},
		{"fortress", "fortress"},
		{"forts", "fort"},
		{"fortuitous", "fortuit"},
		{"fortunate", "fortun"},
		{"fortunately", "fortun"},
		{"fortunatus", "fortunatus"},
		{"fortune", "fortun"},
		{"fortunes", "fortun"},
		{"forty", "forti"},
		{"forward", "forward"},
		{"forwarded", "forward"},
		{"forwarding", "forward"},
		{"forwardness", "forward"},
		{"forwards", "forward"},
		{"fossil", "fossil"},
		{"fossiles", "fossil"},
		{"fossiliferous", "fossilifer"},
		{"fossils", "fossil"},
		{"foster", "foster"},
		{"fostered", "foster"},
		{"fostering", "foster"},
		{"fothergill", "fothergil"},
		{"fotheringham", "fotheringham"},
		{"fotheringhams", "fotheringham"},
		{"fou", "fou"},
		{"fought", "fought"},
		{"foul", "foul"},
		{"fouled", "foul"},
		{"foulest", "foulest"},
		{"foun", "foun"},
		{"found", "found"},
		{"foundation", "foundat"},
		{"foundations", "foundat"},
		{"founded", "found"},
		{"founding", "found"},
		{"foundling", "foundl"},
		{"foundries", "foundri"},
		{"founds", "found"},
		{"fount", "fount"},
		{"fountain", "fountain"},
		{"fountains", "fountain"},
		{"fouque", "fouqu"},
		{"four", "four"},
		{"fourier", "fourier"},
		{"fourpence", "fourpenc"},
		{"fours", "four"},
		{"fourteen", "fourteen"},
		{"fourteenpenny", "fourteenpenni"},
		{"fourteenth", "fourteenth"},
		{"fourth", "fourth"},
		{"fourthly", "fourth"},
		{"fourths", "fourth"},
		{"fower", "fower"},
		{"fowl", "fowl"},
		{"fowler", "fowler"},
		{"fowls", "fowl"},
		{"fox", "fox"},
		{"foxes", "fox"},
		{"foxgloves", "foxglov"},
		{"fra", "fra"},
		{"fraction", "fraction"},
		{"fractious", "fractious"},
		{"fracture", "fractur"},
		{"fractured", "fractur"},
		{"fractures", "fractur"},
		{"fragile", "fragil"},
		{"fragility", "fragil"},
		{"fragm", "fragm"},
		{"fragment", "fragment"},
		{"fragmentary", "fragmentari"},
		{"fragments", "fragment"},
		{"fragrance", "fragranc"},
		{"fragrant", "fragrant"},
		{"frail", "frail"},
		{"frame", "frame"},
		{"framed", "frame"},
		{"frames", "frame"},
		{"framework", "framework"},
		{"framing", "frame"},
		{"francais", "francai"},
		{"france", "franc"},
		{"franchise", "franchis"},
		{"franchises", "franchis"},
		{"francia", "francia"},
		{"francis", "franci"},
		{"francisco", "francisco"},
		{"frank", "frank"},
		{"frankest", "frankest"},
		{"frankfort", "frankfort"},
		{"frankly", "frank"},
		{"frankness", "frank"},
		{"franks", "frank"},
		{"frantic", "frantic"},
		{"frantically", "frantic"},
		{"frantsovna", "frantsovna"},
		{"frantsovnas", "frantsovna"},
		{"fraternal", "fratern"},
		{"fraternity", "fratern"},
		{"fraud", "fraud"},
		{"fraudulent", "fraudul"},
		{"fraudulently", "fraudul"},
		{"fraught", "fraught"},
		{"fray", "fray"},
		{"frayed", "fray"},
		{"freak", "freak"},
		{"freaks", "freak"},
		{"freckled", "freckl"},
		{"frederick", "frederick"},
		{"free", "free"},
		{"freed", "freed"},
		{"freedom", "freedom"},
		{"freeholders", "freehold"},
		{"freeing", "free"},
		{"freely", "freeli"},
		{"freemason", "freemason"},
		{"freemasonry", "freemasonri"},
		{"freer", "freer"},
		{"frees", "free"},
		{"freestone", "freeston"},
		{"freeze", "freez"},
		{"freezes", "freez"},
		{"freezing", "freez"},
		{"freight", "freight"},
		{"freischutz", "freischutz"},
		{"french", "french"},
		{"frenchman", "frenchman"},
		{"frenchmen", "frenchmen"},
		{"frenchwoman", "frenchwoman"},
		{"frenchwomen", "frenchwomen"},
		{"frenzied", "frenzi"},
		{"frenzy", "frenzi"},
		{"frequency", "frequenc"},
		{"frequenfly", "frequenfli"},
		{"frequent", "frequent"},
		{"frequented", "frequent"},
		{"frequenters", "frequent"},
		{"frequenting", "frequent"},
		{"frequentl", "frequentl"},
		{"frequently", "frequent"},
		{"frequents", "frequent"},
		{"fres", "fres"},
		{"fresco", "fresco"},
		{"fresh", "fresh"},
		{"freshen", "freshen"},
		{"freshened", "freshen"},
		{"freshening", "freshen"},
		{"fresher", "fresher"},
		{"freshest", "freshest"},
		{"freshly", "fresh"},
		{"freshness", "fresh"},
		{"freshwater", "freshwat"},
		{"fret", "fret"},
		{"fretful", "fret"},
		{"fretfully", "fret"},
		{"fretfulness", "fret"},
		{"fretted", "fret"},
		{"fretting", "fret"},
		{"frever", "frever"},
		{"freyrina", "freyrina"},
		{"friable", "friabl"},
		{"friar", "friar"},
		{"fricassee", "fricasse"},
		{"friction", "friction"},
		{"friday", "friday"},
		{"fridays", "friday"},
		{"fridolin", "fridolin"},
		{"fried", "fri"},
		{"friend", "friend"},
		{"friendless", "friendless"},
		{"friendliest", "friendliest"},
		{"friendliness", "friendli"},
		{"friendly", "friend"},
		{"friends", "friend"},
		{"friendship", "friendship"},
		{"friendships", "friendship"},
		{"frigate", "frigat"},
		{"fright", "fright"},
		{"frighten", "frighten"},
		{"frightened", "frighten"},
		{"frightening", "frighten"},
		{"frightens", "frighten"},
		{"frightful", "fright"},
		{"frightfully", "fright"},
		{"frights", "fright"},
		{"frigid", "frigid"},
		{"frigidity", "frigid"},
		{"frill", "frill"},
		{"frilled", "frill"},
		{"frills", "frill"},
		{"fringe", "fring"},
		{"fringed", "fring"},
		{"fringes", "fring"},
		{"fringing", "fring"},
		{"frio", "frio"},
		{"frippery", "fripperi"},
		{"frisk", "frisk"},
		{"frisking", "frisk"},
		{"friths", "frith"},
		{"fritter", "fritter"},
		{"frittered", "fritter"},
		{"frivolities", "frivol"},
		{"frivolity", "frivol"},
		{"frivolous", "frivol"},
		{"frizzling", "frizzl"},
		{"fro", "fro"},
		{"frock", "frock"},
		{"frocks", "frock"},
		{"frog", "frog"},
		{"frogs", "frog"},
		{"frolic", "frolic"},
		{"frolics", "frolic"},
		{"frolicsome", "frolicsom"},
		{"from", "from"},
		{"frond", "frond"},
		{"fronds", "frond"},
		{"front", "front"},
		{"fronte", "front"},
		{"fronted", "front"},
		{"frontier", "frontier"},
		{"fronting", "front"},
		{"frontispiece", "frontispiec"},
		{"fronts", "front"},
		{"frost", "frost"},
		{"frosted", "frost"},
		{"frosts", "frost"},
		{"frosty", "frosti"},
		{"froth", "froth"},
		{"frothed", "froth"},
		{"frothy", "frothi"},
		{"frouzy", "frouzi"},
		{"frown", "frown"},
		{"frowned", "frown"},
		{"frowning", "frown"},
		{"frowns", "frown"},
		{"frowsy", "frowsi"},
		{"froze", "froze"},
		{"frozen", "frozen"},
		{"fructifying", "fructifi"},
		{"frugal", "frugal"},
		{"frugality", "frugal"},
		{"fruit", "fruit"},
		{"fruitful", "fruit"},
		{"fruitless", "fruitless"},
		{"fruitlessly", "fruitless"},
		{"fruits", "fruit"},
		{"frusta", "frusta"},
		{"fry", "fri"},
		{"frying", "fri"},
		{"fuchsia", "fuchsia"},
		{"fucus", "fucus"},
		{"fuddled", "fuddl"},
		{"fuega", "fuega"},
		{"fuegia", "fuegia"},
		{"fuegian", "fuegian"},
		{"fuegians", "fuegian"},
		{"fuego", "fuego"},
		{"fuel", "fuel"},
		{"fuentes", "fuent"},
		{"fuffy", "fuffi"},
		{"fugitive", "fugit"},
		{"fugitives", "fugit"},
		{"fulcrum", "fulcrum"},
		{"fule", "fule"},
		{"fulfil", "fulfil"},
		{"fulfilled", "fulfil"},
		{"fulfilling", "fulfil"},
		{"fulfilment", "fulfil"},
		{"fulgurites", "fulgurit"},
		{"fulils", "fulil"},
		{"full", "full"},
		{"fuller", "fuller"},
		{"fullest", "fullest"},
		{"fullness", "full"},
		{"fully", "fulli"},
		{"fulness", "ful"},
		{"fulvipes", "fulvip"},
		{"fumbled", "fumbl"},
		{"fumbling", "fumbl"},
		{"fume", "fume"},
		{"fumed", "fume"},
		{"fumes", "fume"},
		{"fumigation", "fumig"},
		{"fuming", "fume"},
		{"fun", "fun"},
		{"function", "function"},
		{"functionary", "functionari"},
		{"functions", "function"},
		{"fund", "fund"},
		{"fundamental", "fundament"},
		{"fundamentally", "fundament"},
		{"funds", "fund"},
		{"funebre", "funebr"},
		{"funeral", "funer"},
		{"funerals", "funer"},
		{"funereal", "funer"},
		{"fungi", "fungi"},
		{"fungus", "fungus"},
		{"funk", "funk"},
		{"funnel", "funnel"},
		{"funniest", "funniest"},
		{"funny", "funni"},
		{"fur", "fur"},
		{"furbished", "furbish"},
		{"furder", "furder"},
		{"furies", "furi"},
		{"furious", "furious"},
		{"furiously", "furious"},
		{"furlongs", "furlong"},
		{"furnace", "furnac"},
		{"furnaces", "furnac"},
		{"furnarius", "furnarius"},
		{"furnish", "furnish"},
		{"furnished", "furnish"},
		{"furnishes", "furnish"},
		{"furnishing", "furnish"},
		{"furniter", "furnit"},
		{"furniture", "furnitur"},
		{"furrowed", "furrow"},
		{"furrows", "furrow"},
		{"furry", "furri"},
		{"furs", "fur"},
		{"further", "further"},
		{"furtherance", "further"},
		{"furthermore", "furthermor"},
		{"furthest", "furthest"},
		{"furtive", "furtiv"},
		{"furtively", "furtiv"},
		{"fury", "furi"},
		{"furze", "furz"},
		{"fuse", "fuse"},
		{"fused", "fuse"},
		{"fusibility", "fusibl"},
		{"fuss", "fuss"},
		{"fussily", "fussili"},
		{"fussy", "fussi"},
		{"fust", "fust"},
		{"fustian", "fustian"},
		{"futile", "futil"},
		{"futur", "futur"},
		{"future", "futur"},
		{"futures", "futur"},
		{"fyodor", "fyodor"},
		{"fyodorovna", "fyodorovna"},
		{"fypunnote", "fypunnot"},
		{"g", "g"},
		{"ga", "ga"},
		{"gab", "gab"},
		{"gabble", "gabbl"},
		{"gabbled", "gabbl"},
		{"gable", "gabl"},
		{"gables", "gabl"},
		{"gad", "gad"},
		{"gadfly", "gadfli"},
		{"gadzooks", "gadzook"},
		{"gags", "gag"},
		{"gaieties", "gaieti"},
		{"gaiety", "gaieti"},
		{"gaily", "gaili"},
		{"gaimard", "gaimard"},
		{"gain", "gain"},
		{"gained", "gain"},
		{"gainer", "gainer"},
		{"gaining", "gain"},
		{"gains", "gain"},
		{"gainsaid", "gainsaid"},
		{"gainsay", "gainsay"},
		{"gainsaying", "gainsay"},
		{"gait", "gait"},
		{"gaiters", "gaiter"},
		{"gal", "gal"},
		{"gala", "gala"},
		{"galapageian", "galapageian"},
		{"galapagoensis", "galapagoensi"},
		{"galapagos", "galapago"},
		{"galaxy", "galaxi"},
		{"gale", "gale"},
		{"gales", "gale"},
		{"gall", "gall"},
		{"gallanbile", "gallanbil"},
		{"gallant", "gallant"},
		{"gallantly", "gallant"},
		{"gallantries", "gallantri"},
		{"gallantry", "gallantri"},
		{"gallants", "gallant"},
		{"galled", "gall"},
		{"gallegos", "gallego"},
		{"galleries", "galleri"},
		{"gallery", "galleri"},
		{"galley", "galley"},
		{"galleys", "galley"},
		{"gallinaceous", "gallinac"},
		{"gallinazo", "gallinazo"},
		{"gallinazos", "gallinazo"},
		{"galling", "gall"},
		{"gallivanting", "galliv"},
		{"gallon", "gallon"},
		{"gallons", "gallon"},
		{"gallop", "gallop"},
		{"galloped", "gallop"},
		{"galloping", "gallop"},
		{"gallops", "gallop"},
		{"gallows", "gallow"},
		{"gals", "gal"},
		{"galvanism", "galvan"},
		{"gambier", "gambier"},
		{"gamble", "gambl"},
		{"gambled", "gambl"},
		{"gambler", "gambler"},
		{"gamblers", "gambler"},
		{"gambles", "gambl"},
		{"gambling", "gambl"},
		{"gambolling", "gambol"},
		{"gambrinus", "gambrinus"},
		{"game", "game"},
		{"gamekeepers", "gamekeep"},
		{"games", "game"},
		{"gamester", "gamest"},
		{"gamesters", "gamest"},
		{"gaming", "game"},
		{"gammon", "gammon"},
		{"gammoning", "gammon"},
		{"gamut", "gamut"},
		{"gander", "gander"},
		{"gane", "gane"},
		{"gang", "gang"},
		{"ganges", "gang"},
		{"ganging", "gang"},
		{"ganglion", "ganglion"},
		{"gangs", "gang"},
		{"gangway", "gangway"},
		{"gannet", "gannet"},
		{"gannets", "gannet"},
		{"ganz", "ganz"},
		{"gap", "gap"},
		{"gape", "gape"},
		{"gaped", "gape"},
		{"gapes", "gape"},
		{"gaping", "gape"},
		{"gaps", "gap"},
		{"gar", "gar"},
		{"garb", "garb"},
		{"garbled", "garbl"},
		{"garbs", "garb"},
		{"garde", "gard"},
		{"garden", "garden"},
		{"gardener", "garden"},
		{"gardeners", "garden"},
		{"gardening", "garden"},
		{"gardens", "garden"},
		{"gardner", "gardner"},
		{"gardners", "gardner"},
		{"garish", "garish"},
		{"garland", "garland"},
		{"garlanded", "garland"},
		{"garlands", "garland"},
		{"garment", "garment"},
		{"garments", "garment"},
		{"garnet", "garnet"},
		{"garnett", "garnett"},
		{"garnish", "garnish"},
		{"garnished", "garnish"},
		{"garnishing", "garnish"},
		{"garniture", "garnitur"},
		{"garran", "garran"},
		{"garret", "garret"},
		{"garrets", "garret"},
		{"garrison", "garrison"},
		{"garter", "garter"},
		{"gartered", "garter"},
		{"garters", "garter"},
		{"garth", "garth"},
		{"garthers", "garther"},
		{"gas", "gas"},
		{"gases", "gase"},
		{"gash", "gash"},
		{"gashed", "gash"},
		{"gaslights", "gaslight"},
		{"gasp", "gasp"},
		{"gasped", "gasp"},
		{"gasping", "gasp"},
		{"gaspingly", "gasp"},
		{"gasps", "gasp"},
		{"gate", "gate"},
		{"gates", "gate"},
		{"gateway", "gateway"},
		{"gateways", "gateway"},
		{"gather", "gather"},
		{"gathered", "gather"},
		{"gatherer", "gather"},
		{"gatherers", "gather"},
		{"gathering", "gather"},
		{"gatherings", "gather"},
		{"gatherlng", "gatherlng"},
		{"gathers", "gather"},
		{"gatherum", "gatherum"},
		{"gato", "gato"},
		{"gauch", "gauch"},
		{"gaucho", "gaucho"},
		{"gauchos", "gaucho"},
		{"gaudiest", "gaudiest"},
		{"gaudy", "gaudi"},
		{"gaul", "gaul"},
		{"gaunt", "gaunt"},
		{"gauntlet", "gauntlet"},
		{"gauntlets", "gauntlet"},
		{"gauntly", "gaunt"},
		{"gauze", "gauz"},
		{"gauzy", "gauzi"},
		{"gave", "gave"},
		{"gavia", "gavia"},
		{"gawky", "gawki"},
		{"gay", "gay"},
		{"gayest", "gayest"},
		{"gaze", "gaze"},
		{"gazed", "gaze"},
		{"gazelle", "gazell"},
		{"gazelles", "gazell"},
		{"gazes", "gaze"},
		{"gazette", "gazett"},
		{"gazing", "gaze"},
		{"gazingi", "gazingi"},
		{"gear", "gear"},
		{"geese", "gees"},
		{"geist", "geist"},
		{"gelatinous", "gelatin"},
		{"gem", "gem"},
		{"gemmules", "gemmul"},
		{"gen", "gen"},
		{"gender", "gender"},
		{"genealogical", "genealog"},
		{"genealogist", "genealogist"},
		{"genelman", "genelman"},
		{"genelmen", "genelmen"},
		{"genera", "genera"},
		{"general", "general"},
		{"generalities", "general"},
		{"generality", "general"},
		{"generalization", "general"},
		{"generally", "general"},
		{"generals", "general"},
		{"generalship", "generalship"},
		{"generate", "generat"},
		{"generated", "generat"},
		{"generation", "generat"},
		{"generations", "generat"},
		{"generic", "generic"},
		{"generosity", "generos"},
		{"generous", "generous"},
		{"generously", "generous"},
		{"genesis", "genesi"},
		{"geneva", "geneva"},
		{"genfleman", "genfleman"},
		{"genial", "genial"},
		{"genially", "genial"},
		{"genie", "geni"},
		{"genius", "genius"},
		{"geniuses", "genius"},
		{"genlmen", "genlmen"},
		{"genlmn", "genlmn"},
		{"genteel", "genteel"},
		{"genteelest", "genteelest"},
		{"genteelly", "genteelli"},
		{"gentile", "gentil"},
		{"gentility", "gentil"},
		{"gentle", "gentl"},
		{"gentlefolk", "gentlefolk"},
		{"gentlefolks", "gentlefolk"},
		{"gentlema", "gentlema"},
		{"gentleman", "gentleman"},
		{"gentlemanlike", "gentlemanlik"},
		{"gentlemanly", "gentleman"},
		{"gentlemen", "gentlemen"},
		{"gentleness", "gentl"},
		{"gentler", "gentler"},
		{"gentlest", "gentlest"},
		{"gentlewoman", "gentlewoman"},
		{"gently", "gentl"},
		{"gentry", "gentri"},
		{"genuine", "genuin"},
		{"genuinely", "genuin"},
		{"genus", "genus"},
		{"geoffroi", "geoffroi"},
		{"geoffroy", "geoffroy"},
		{"geograph", "geograph"},
		{"geographer", "geograph"},
		{"geographica", "geographica"},
		{"geographical", "geograph"},
		{"geography", "geographi"},
		{"geolog", "geolog"},
		{"geological", "geolog"},
		{"geologically", "geolog"},
		{"geologicas", "geologica"},
		{"geologist", "geologist"},
		{"geologists", "geologist"},
		{"geologize", "geolog"},
		{"geologizing", "geolog"},
		{"geology", "geolog"},
		{"geometrical", "geometr"},
		{"geometry", "geometri"},
		{"george", "georg"},
		{"georges", "georg"},
		{"georgia", "georgia"},
		{"georgina", "georgina"},
		{"geospiza", "geospiza"},
		{"geously", "geousli"},
		{"geraldine", "geraldin"},
		{"geranium", "geranium"},
		{"geraniums", "geranium"},
		{"germ", "germ"},
		{"german", "german"},
		{"germans", "german"},
		{"germany", "germani"},
		{"germinating", "germin"},
		{"germs", "germ"},
		{"gerous", "gerous"},
		{"gervais", "gervai"},
		{"geschichte", "geschicht"},
		{"gesticulating", "gesticul"},
		{"gesticulations", "gesticul"},
		{"gesture", "gestur"},
		{"gestures", "gestur"},
		{"get", "get"},
		{"gets", "get"},
		{"getting", "get"},
		{"gettings", "get"},
		{"gewgaws", "gewgaw"},
		{"gha", "gha"},
		{"ghastlier", "ghastlier"},
		{"ghastly", "ghast"},
		{"ghirlandajo", "ghirlandajo"},
		{"ghost", "ghost"},
		{"ghostly", "ghost"},
		{"ghosts", "ghost"},
		{"ght", "ght"},
		{"gi", "gi"},
		{"giant", "giant"},
		{"giants", "giant"},
		{"gibing", "gibe"},
		{"gibraltar", "gibraltar"},
		{"giddily", "giddili"},
		{"giddiness", "giddi"},
		{"giddy", "giddi"},
		{"gift", "gift"},
		{"gifted", "gift"},
		{"gifts", "gift"},
		{"gig", "gig"},
		{"gigantea", "gigantea"},
		{"gigantic", "gigant"},
		{"gigas", "giga"},
		{"giggle", "giggl"},
		{"giggled", "giggl"},
		{"giggles", "giggl"},
		{"giggling", "giggl"},
		{"gild", "gild"},
		{"gilded", "gild"},
		{"gilding", "gild"},
		{"gilds", "gild"},
		{"giles", "gile"},
		{"gill", "gill"},
		{"gillies", "gilli"},
		{"gillingwater", "gillingwat"},
		{"gilt", "gilt"},
		{"gimlet", "gimlet"},
		{"gimlets", "gimlet"},
		{"gin", "gin"},
		{"ginger", "ginger"},
		{"gingerbread", "gingerbread"},
		{"gingery", "gingeri"},
		{"gipsy", "gipsi"},
		{"giraffe", "giraff"},
		{"giraffes", "giraff"},
		{"gird", "gird"},
		{"girdle", "girdl"},
		{"girdled", "girdl"},
		{"girl", "girl"},
		{"girlhood", "girlhood"},
		{"girlish", "girlish"},
		{"girlishly", "girlish"},
		{"girls", "girl"},
		{"girt", "girt"},
		{"girth", "girth"},
		{"girths", "girth"},
		{"gist", "gist"},
		{"git", "git"},
		{"giuseppe", "giusepp"},
		{"giv", "giv"},
		{"give", "give"},
		{"given", "given"},
		{"giver", "giver"},
		{"gives", "give"},
		{"giving", "give"},
		{"gizzard", "gizzard"},
		{"gl", "gl"},
		{"glacier", "glacier"},
		{"glaciers", "glacier"},
		{"glad", "glad"},
		{"gladden", "gladden"},
		{"gladdened", "gladden"},
		{"glades", "glade"},
		{"gladiator", "gladiat"},
		{"gladly", "glad"},
		{"gladness", "glad"},
		{"gladsome", "gladsom"},
		{"gladsomeness", "gladsom"},
		{"glance", "glanc"},
		{"glanced", "glanc"},
		{"glances", "glanc"},
		{"glancing", "glanc"},
		{"glare", "glare"},
		{"glared", "glare"},
		{"glares", "glare"},
		{"glaring", "glare"},
		{"glaringly", "glare"},
		{"glass", "glass"},
		{"glasses", "glass"},
		{"glassful", "glass"},
		{"glassy", "glassi"},
		{"glavormelly", "glavormelli"},
		{"glaze", "glaze"},
		{"glazed", "glaze"},
		{"gleam", "gleam"},
		{"gleamed", "gleam"},
		{"gleaming", "gleam"},
		{"gleams", "gleam"},
		{"glean", "glean"},
		{"gleaned", "glean"},
		{"glee", "glee"},
		{"gleefully", "gleefulli"},
		{"gleesome", "gleesom"},
		{"glen", "glen"},
		{"glencora", "glencora"},
		{"glib", "glib"},
		{"glide", "glide"},
		{"glided", "glide"},
		{"glides", "glide"},
		{"gliding", "glide"},
		{"glimmer", "glimmer"},
		{"glimmered", "glimmer"},
		{"glimmering", "glimmer"},
		{"glimmerings", "glimmer"},
		{"glimpse", "glimps"},
		{"glimpses", "glimps"},
		{"glissez", "glissez"},
		{"glisten", "glisten"},
		{"glistened", "glisten"},
		{"glistening", "glisten"},
		{"glistens", "glisten"},
		{"glitter", "glitter"},
		{"glittered", "glitter"},
		{"glittering", "glitter"},
		{"gloated", "gloat"},
		{"gloating", "gloat"},
		{"globe", "globe"},
		{"globes", "globe"},
		{"globular", "globular"},
		{"globules", "globul"},
		{"glod", "glod"},
		{"gloom", "gloom"},
		{"gloomier", "gloomier"},
		{"gloomily", "gloomili"},
		{"gloominess", "gloomi"},
		{"gloomy", "gloomi"},
		{"gloried", "glori"},
		{"glories", "glori"},
		{"glorious", "glorious"},
		{"glory", "glori"},
		{"glorying", "glori"},
		{"gloss", "gloss"},
		{"glossary", "glossari"},
		{"glossy", "glossi"},
		{"gloucester", "gloucest"},
		{"glove", "glove"},
		{"gloved", "glove"},
		{"gloves", "glove"},
		{"glow", "glow"},
		{"glowed", "glow"},
		{"glowered", "glower"},
		{"glowing", "glow"},
		{"glows", "glow"},
		{"glowworm", "glowworm"},
		{"glowworms", "glowworm"},
		{"glue", "glue"},
		{"glum", "glum"},
		{"glutinous", "glutin"},
		{"glutton", "glutton"},
		{"gluttons", "glutton"},
		{"gnarled", "gnarl"},
		{"gnashed", "gnash"},
		{"gnashing", "gnash"},
		{"gnats", "gnat"},
		{"gnaw", "gnaw"},
		{"gnawed", "gnaw"},
		{"gnawer", "gnawer"},
		{"gnawers", "gnawer"},
		{"gnawing", "gnaw"},
		{"gneiss", "gneiss"},
		{"gnus", "gnus"},
		{"go", "go"},
		{"goa", "goa"},
		{"goad", "goad"},
		{"goaded", "goad"},
		{"goads", "goad"},
		{"goal", "goal"},
		{"goar", "goar"},
		{"goat", "goat"},
		{"goatherd", "goatherd"},
		{"goats", "goat"},
		{"goatskin", "goatskin"},
		{"goatsucker", "goatsuck"},
		{"goblet", "goblet"},
		{"goblets", "goblet"},
		{"goblin", "goblin"},
		{"god", "god"},
		{"godalming", "godalm"},
		{"godchild", "godchild"},
		{"goddess", "goddess"},
		{"godfather", "godfath"},
		{"godfeyther", "godfeyth"},
		{"godfrey", "godfrey"},
		{"godless", "godless"},
		{"godlike", "godlik"},
		{"godly", "god"},
		{"godmother", "godmoth"},
		{"gods", "god"},
		{"godsend", "godsend"},
		{"godson", "godson"},
		{"goeree", "goere"},
		{"goes", "goe"},
		{"goesler", "goesler"},
		{"goeth", "goeth"},
		{"goethe", "goeth"},
		{"gog", "gog"},
		{"goggle", "goggl"},
		{"gogol", "gogol"},
		{"going", "go"},
		{"goings", "go"},
		{"goitre", "goitr"},
		{"gold", "gold"},
		{"golden", "golden"},
		{"goldfinch", "goldfinch"},
		{"goldfinches", "goldfinch"},
		{"goldfish", "goldfish"},
		{"goldingsby", "goldingsbi"},
		{"goldsmith", "goldsmith"},
		{"golgotha", "golgotha"},
		{"goloshes", "golosh"},
		{"gomez", "gomez"},
		{"gondola", "gondola"},
		{"gone", "gone"},
		{"gong", "gong"},
		{"gonoph", "gonoph"},
		{"gonzales", "gonzal"},
		{"goo", "goo"},
		{"good", "good"},
		{"goodbye", "goodby"},
		{"goodle", "goodl"},
		{"goodly", "good"},
		{"goodnaturedly", "goodnatur"},
		{"goodness", "good"},
		{"goods", "good"},
		{"goodwill", "goodwil"},
		{"goodwood", "goodwood"},
		{"goose", "goos"},
		{"gooseberries", "gooseberri"},
		{"gooseberry", "gooseberri"},
		{"gootther", "gootther"},
		{"gorda", "gorda"},
		{"gore", "gore"},
		{"gorge", "gorg"},
		{"gorged", "gorg"},
		{"gorgeous", "gorgeous"},
		{"gorgeously", "gorgeous"},
		{"gorgeousness", "gorgeous"},
		{"gorges", "gorg"},
		{"gorging", "gorg"},
		{"gormandize", "gormand"},
		{"gorse", "gors"},
		{"gory", "gori"},
		{"gospel", "gospel"},
		{"gossamer", "gossam"},
		{"gossip", "gossip"},
		{"gossiper", "gossip"},
		{"gossiping", "gossip"},
		{"gossips", "gossip"},
		{"got", "got"},
		{"gothic", "gothic"},
		{"gothlands", "gothland"},
		{"gott", "gott"},
		{"gotten", "gotten"},
		{"gould", "gould"},
		{"gourmand", "gourmand"},
		{"gourmands", "gourmand"},
		{"gout", "gout"},
		{"gouty", "gouti"},
		{"gov", "gov"},
		{"gove", "gove"},
		{"govemment", "govem"},
		{"govern", "govern"},
		{"governed", "govern"},
		{"governess", "gover"},
		{"governesses", "gover"},
		{"governessing", "gover"},
		{"governing", "govern"},
		{"government", "govern"},
		{"governments", "govern"},
		{"governor", "governor"},
		{"governors", "governor"},
		{"governorship", "governorship"},
		{"governs", "govern"},
		{"govett", "govett"},
		{"govvernor", "govvernor"},
		{"gower", "gower"},
		{"gown", "gown"},
		{"gownd", "gownd"},
		{"gowns", "gown"},
		{"gra", "gra"},
		{"grace", "grace"},
		{"gracechurch", "gracechurch"},
		{"graced", "grace"},
		{"graceful", "grace"},
		{"gracefully", "grace"},
		{"graceless", "graceless"},
		{"graces", "grace"},
		{"gracing", "grace"},
		{"gracious", "gracious"},
		{"graciously", "gracious"},
		{"graciousness", "gracious"},
		{"gradation", "gradat"},
		{"gradations", "gradat"},
		{"grade", "grade"},
		{"grades", "grade"},
		{"gradual", "gradual"},
		{"gradually", "gradual"},
		{"graduate", "graduat"},
		{"graduated", "graduat"},
		{"grafted", "graft"},
		{"grafts", "graft"},
		{"grain", "grain"},
		{"grained", "grain"},
		{"grains", "grain"},
		{"grammar", "grammar"},
		{"grammarian", "grammarian"},
		{"grammars", "grammar"},
		{"grammatical", "grammat"},
		{"gran", "gran"},
		{"granaries", "granari"},
		{"grand", "grand"},
		{"grandchild", "grandchild"},
		{"grandchildren", "grandchildren"},
		{"granddaughter", "granddaught"},
		{"grande", "grand"},
		{"grandee", "grande"},
		{"grandees", "grande"},
		{"grander", "grander"},
		{"grandest", "grandest"},
		{"grandeur", "grandeur"},
		{"grandeurs", "grandeur"},
		{"grandfather", "grandfath"},
		{"grandfathers", "grandfath"},
		{"grandiflorus", "grandiflorus"},
		{"grandiloquent", "grandiloqu"},
		{"grandiloquently", "grandiloqu"},
		{"grandly", "grand"},
		{"grandmama", "grandmama"},
		{"grandmamma", "grandmamma"},
		{"grandmother", "grandmoth"},
		{"grandmothers", "grandmoth"},
		{"grandpapa", "grandpapa"},
		{"grandsire", "grandsir"},
		{"grandson", "grandson"},
		{"granite", "granit"},
		{"granitic", "granit"},
		{"granny", "granni"},
		{"grant", "grant"},
		{"granted", "grant"},
		{"grantham", "grantham"},
		{"granting", "grant"},
		{"granular", "granular"},
		{"granulo", "granulo"},
		{"grape", "grape"},
		{"grapes", "grape"},
		{"grapevine", "grapevin"},
		{"grapple", "grappl"},
		{"grappled", "grappl"},
		{"grappling", "grappl"},
		{"grasp", "grasp"},
		{"grasped", "grasp"},
		{"grasping", "grasp"},
		{"grasps", "grasp"},
		{"graspus", "graspus"},
		{"grass", "grass"},
		{"grasses", "grass"},
		{"grasshopper", "grasshopp"},
		{"grasshoppers", "grasshopp"},
		{"grassy", "grassi"},
		{"grate", "grate"},
		{"grated", "grate"},
		{"grateful", "grate"},
		{"gratefully", "grate"},
		{"grater", "grater"},
		{"grates", "grate"},
		{"gratful", "grat"},
		{"gratification", "gratif"},
		{"gratified", "gratifi"},
		{"gratifies", "gratifi"},
		{"gratify", "gratifi"},
		{"gratifying", "gratifi"},
		{"grating", "grate"},
		{"gratitude", "gratitud"},
		{"gratuitous", "gratuit"},
		{"gratuitously", "gratuit"},
		{"gratulation", "gratul"},
		{"gravamen", "gravamen"},
		{"grave", "grave"},
		{"graveclothes", "gravecloth"},
		{"gravel", "gravel"},
		{"gravelled", "gravel"},
		{"gravelly", "gravelli"},
		{"gravely", "grave"},
		{"graver", "graver"},
		{"graves", "grave"},
		{"gravesend", "gravesend"},
		{"gravest", "gravest"},
		{"gravestone", "graveston"},
		{"gravestones", "graveston"},
		{"graveyard", "graveyard"},
		{"gravies", "gravi"},
		{"gravity", "graviti"},
		{"gravy", "gravi"},
		{"gray", "gray"},
		{"graymarsh", "graymarsh"},
		{"graze", "graze"},
		{"grazed", "graze"},
		{"grazes", "graze"},
		{"grazier", "grazier"},
		{"grazing", "graze"},
		{"grea", "grea"},
		{"grease", "greas"},
		{"greased", "greas"},
		{"greasily", "greasili"},
		{"greasy", "greasi"},
		{"great", "great"},
		{"greatcoat", "greatcoat"},
		{"greateful", "great"},
		{"greater", "greater"},
		{"greatest", "greatest"},
		{"greatl", "greatl"},
		{"greatly", "great"},
		{"greatness", "great"},
		{"grecian", "grecian"},
		{"grecians", "grecian"},
		{"greece", "greec"},
		{"greed", "greed"},
		{"greedily", "greedili"},
		{"greediness", "greedi"},
		{"greedy", "greedi"},
		{"greek", "greek"},
		{"green", "green"},
		{"greener", "greener"},
		{"greengrocer", "greengroc"},
		{"greengrocery", "greengroceri"},
		{"greenhorn", "greenhorn"},
		{"greenish", "greenish"},
		{"greenland", "greenland"},
		{"greenleaf", "greenleaf"},
		{"greenly", "green"},
		{"greenness", "green"},
		{"greens", "green"},
		{"greenstone", "greenston"},
		{"greensward", "greensward"},
		{"greenwich", "greenwich"},
		{"greet", "greet"},
		{"greeted", "greet"},
		{"greeting", "greet"},
		{"greetings", "greet"},
		{"greets", "greet"},
		{"gregarious", "gregari"},
		{"gregory", "gregori"},
		{"gregsbury", "gregsburi"},
		{"grenadier", "grenadi"},
		{"grenadiers", "grenadi"},
		{"gresham", "gresham"},
		{"greshambury", "greshamburi"},
		{"greta", "greta"},
		{"grew", "grew"},
		{"grey", "grey"},
		{"greyhound", "greyhound"},
		{"greyhounds", "greyhound"},
		{"greyish", "greyish"},
		{"gride", "gride"},
		{"gridiron", "gridiron"},
		{"gridley", "gridley"},
		{"grief", "grief"},
		{"griefs", "grief"},
		{"grievance", "grievanc"},
		{"grievances", "grievanc"},
		{"grieve", "griev"},
		{"grieved", "griev"},
		{"grieves", "griev"},
		{"grieving", "griev"},
		{"grievous", "grievous"},
		{"grievously", "grievous"},
		{"griffin", "griffin"},
		{"griffith", "griffith"},
		{"griffiths", "griffith"},
		{"grig", "grig"},
		{"grigorievitch", "grigorievitch"},
		{"grigoryev", "grigoryev"},
		{"grim", "grim"},
		{"grimace", "grimac"},
		{"grimaces", "grimac"},
		{"grimacing", "grimac"},
		{"grimalkin", "grimalkin"},
		{"grimble", "grimbl"},
		{"grimbles", "grimbl"},
		{"grime", "grime"},
		{"grimed", "grime"},
		{"grimes", "grime"},
		{"grimly", "grim"},
		{"grimy", "grimi"},
		{"grin", "grin"},
		{"grind", "grind"},
		{"grinder", "grinder"},
		{"grinders", "grinder"},
		{"grinding", "grind"},
		{"grinned", "grin"},
		{"grinning", "grin"},
		{"grins", "grin"},
		{"grip", "grip"},
		{"griping", "gripe"},
		{"gripped", "grip"},
		{"gripping", "grip"},
		{"grips", "grip"},
		{"grisly", "grisli"},
		{"grist", "grist"},
		{"gritting", "grit"},
		{"grizzled", "grizzl"},
		{"groan", "groan"},
		{"groaned", "groan"},
		{"groaning", "groan"},
		{"groans", "groan"},
		{"grocer", "grocer"},
		{"grogram", "grogram"},
		{"grogzwig", "grogzwig"},
		{"groom", "groom"},
		{"groomed", "groom"},
		{"grooms", "groom"},
		{"groove", "groov"},
		{"grooves", "groov"},
		{"grooving", "groov"},
		{"grope", "grope"},
		{"groped", "grope"},
		{"gropes", "grope"},
		{"gropin", "gropin"},
		{"groping", "grope"},
		{"grose", "grose"},
		{"gross", "gross"},
		{"grosser", "grosser"},
		{"grossest", "grossest"},
		{"grossly", "grossli"},
		{"grossness", "gross"},
		{"grosvenor", "grosvenor"},
		{"grotesque", "grotesqu"},
		{"grotesquely", "grotesqu"},
		{"grottoes", "grotto"},
		{"ground", "ground"},
		{"grounded", "ground"},
		{"groundless", "groundless"},
		{"groundlessness", "groundless"},
		{"grounds", "ground"},
		{"groundwork", "groundwork"},
		{"group", "group"},
		{"grouped", "group"},
		{"grouping", "group"},
		{"groups", "group"},
		{"grouse", "grous"},
		{"grove", "grove"},
		{"grovel", "grovel"},
		{"grovelling", "grovel"},
		{"groves", "grove"},
		{"grow", "grow"},
		{"groweth", "groweth"},
		{"growin", "growin"},
		{"growing", "grow"},
		{"growl", "growl"},
		{"growled", "growl"},
		{"growlery", "growleri"},
		{"growling", "growl"},
		{"growlings", "growl"},
		{"growls", "growl"},
		{"grown", "grown"},
		{"grows", "grow"},
		{"growth", "growth"},
		{"grub", "grub"},
		{"grubbed", "grub"},
		{"grubbing", "grub"},
		{"grubble", "grubbl"},
		{"grudden", "grudden"},
		{"grudge", "grudg"},
		{"grudged", "grudg"},
		{"grudges", "grudg"},
		{"grudgingly", "grudg"},
		{"gruff", "gruff"},
		{"gruffly", "gruffli"},
		{"grumble", "grumbl"},
		{"grumbled", "grumbl"},
		{"grumbler", "grumbler"},
		{"grumblers", "grumbler"},
		{"grumbling", "grumbl"},
		{"grumblings", "grumbl"},
		{"grund", "grund"},
		{"grunt", "grunt"},
		{"grunted", "grunt"},
		{"grunts", "grunt"},
		{"gryllus", "gryllus"},
		{"guanaco", "guanaco"},
		{"guanacos", "guanaco"},
		{"guano", "guano"},
		{"guantajaya", "guantajaya"},
		{"guarantee", "guarante"},
		{"guaranteed", "guarante"},
		{"guard", "guard"},
		{"guardage", "guardag"},
		{"guarded", "guard"},
		{"guardedness", "guarded"},
		{"guardhouse", "guardhous"},
		{"guardia", "guardia"},
		{"guardian", "guardian"},
		{"guardians", "guardian"},
		{"guardianship", "guardianship"},
		{"guarding", "guard"},
		{"guards", "guard"},
		{"guardsman", "guardsman"},
		{"guardsmen", "guardsmen"},
		{"guasco", "guasco"},
		{"guascos", "guasco"},
		{"guaso", "guaso"},
		{"guasos", "guaso"},
		{"guatemala", "guatemala"},
		{"guava", "guava"},
		{"guayaquil", "guayaquil"},
		{"guayatecas", "guayateca"},
		{"guayavita", "guayavita"},
		{"gucho", "gucho"},
		{"gude", "gude"},
		{"guerre", "guerr"},
		{"guess", "guess"},
		{"guessed", "guess"},
		{"guesses", "guess"},
		{"guessing", "guess"},
		{"guest", "guest"},
		{"guests", "guest"},
		{"guffaw", "guffaw"},
		{"guffawed", "guffaw"},
		{"guffawing", "guffaw"},
		{"guffy", "guffi"},
		{"guid", "guid"},
		{"guidance", "guidanc"},
		{"guide", "guid"},
		{"guided", "guid"},
		{"guides", "guid"},
		{"guiding", "guid"},
		{"guilandina", "guilandina"},
		{"guildford", "guildford"},
		{"guile", "guil"},
		{"guileless", "guileless"},
		{"guilt", "guilt"},
		{"guiltily", "guiltili"},
		{"guiltiness", "guilti"},
		{"guiltless", "guiltless"},
		{"guilty", "guilti"},
		{"guinea", "guinea"},
		{"guineas", "guinea"},
		{"guise", "guis"},
		{"guitar", "guitar"},
		{"guitron", "guitron"},
		{"gulf", "gulf"},
		{"gulfs", "gulf"},
		{"gull", "gull"},
		{"gulled", "gull"},
		{"gullet", "gullet"},
		{"gulleys", "gulley"},
		{"gullies", "gulli"},
		{"gulliver", "gulliv"},
		{"gulls", "gull"},
		{"gully", "gulli"},
		{"gulp", "gulp"},
		{"gulped", "gulp"},
		{"gulping", "gulp"},
		{"gulps", "gulp"},
		{"gum", "gum"},
		{"gums", "gum"},
		{"gumwood", "gumwood"},
		{"gun", "gun"},
		{"gunless", "gunless"},
		{"gunner", "gunner"},
		{"gunnera", "gunnera"},
		{"gunners", "gunner"},
		{"gunnners", "gunnner"},
		{"gunpowder", "gunpowd"},
		{"guns", "gun"},
		{"gunsmith", "gunsmith"},
		{"gunther", "gunther"},
		{"gunwale", "gunwal"},
		{"gunwales", "gunwal"},
		{"gup", "gup"},
		{"guppy", "guppi"},
		{"gurgled", "gurgl"},
		{"gurgling", "gurgl"},
		{"gush", "gush"},
		{"gushed", "gush"},
		{"gusher", "gusher"},
		{"gushing", "gush"},
		{"gust", "gust"},
		{"guster", "guster"},
		{"gusts", "gust"},
		{"gusty", "gusti"},
		{"gutta", "gutta"},
		{"gutter", "gutter"},
		{"guttered", "gutter"},
		{"guttering", "gutter"},
		{"gutters", "gutter"},
		{"guttural", "guttur"},
		{"guv", "guv"},
		{"guy", "guy"},
		{"guyaquil", "guyaquil"},
		{"guzzling", "guzzl"},
		{"gwyneth", "gwyneth"},
		{"gymnasium", "gymnasium"},
		{"gymnastic", "gymnast"},
		{"gypsies", "gypsi"},
		{"gypsum", "gypsum"},
		{"gypsy", "gypsi"},
		{"gyrations", "gyrat"},
		{"h", "h"},
		{"ha", "ha"},
		{"habeas", "habea"},
		{"haberdasher", "haberdash"},
		{"habiliments", "habili"},
		{"habit", "habit"},
		{"habitable", "habit"},
		{"habitation", "habit"},
		{"habitations", "habit"},
		{"habited", "habit"},
		{"habits", "habit"},
		{"habitual", "habitu"},
		{"habitually", "habitu"},
		{"habituated", "habitu"},
		{"hachette", "hachett"},
		{"hacienda", "hacienda"},
		{"haciendero", "haciendero"},
		{"hack", "hack"},
		{"hackney", "hackney"},
		{"hacks", "hack"},
		{"had", "had"},
		{"hadn", "hadn"},
		{"hadst", "hadst"},
		{"hag", "hag"},
		{"haggard", "haggard"},
		{"haggardly", "haggard"},
		{"haggardness", "haggard"},
		{"haggle", "haggl"},
		{"hah", "hah"},
		{"hail", "hail"},
		{"hailed", "hail"},
		{"hailing", "hail"},
		{"hailstones", "hailston"},
		{"hair", "hair"},
		{"hairbrush", "hairbrush"},
		{"hairdresser", "hairdress"},
		{"haired", "hair"},
		{"hairless", "hairless"},
		{"hairs", "hair"},
		{"hairy", "hairi"},
		{"halcyon", "halcyon"},
		{"hale", "hale"},
		{"half", "half"},
		{"halfpence", "halfpenc"},
		{"halfpenny", "halfpenni"},
		{"halfpennyworth", "halfpennyworth"},
		{"halfway", "halfway"},
		{"hall", "hall"},
		{"hallo", "hallo"},
		{"halloa", "halloa"},
		{"halloo", "halloo"},
		{"hallooing", "halloo"},
		{"hallowed", "hallow"},
		{"halls", "hall"},
		{"hallucination", "hallucin"},
		{"halo", "halo"},
		{"halt", "halt"},
		{"halted", "halt"},
		{"halter", "halter"},
		{"haltica", "haltica"},
		{"halting", "halt"},
		{"halts", "halt"},
		{"halves", "halv"},
		{"ham", "ham"},
		{"hamilton", "hamilton"},
		{"hamlet", "hamlet"},
		{"hamlets", "hamlet"},
		{"hammer", "hammer"},
		{"hammercloths", "hammercloth"},
		{"hammered", "hammer"},
		{"hammering", "hammer"},
		{"hammers", "hammer"},
		{"hammersmith", "hammersmith"},
		{"hammond", "hammond"},
		{"hampdens", "hampden"},
		{"hamper", "hamper"},
		{"hampered", "hamper"},
		{"hampering", "hamper"},
		{"hampers", "hamper"},
		{"hampshire", "hampshir"},
		{"hampstead", "hampstead"},
		{"hampton", "hampton"},
		{"hams", "ham"},
		{"hamstrings", "hamstr"},
		{"hand", "hand"},
		{"handcuff", "handcuff"},
		{"handcuffed", "handcuf"},
		{"handcuffs", "handcuff"},
		{"hande", "hand"},
		{"handed", "hand"},
		{"handeder", "handed"},
		{"handel", "handel"},
		{"handful", "hand"},
		{"handfuls", "hand"},
		{"handing", "hand"},
		{"handkercher", "handkerch"},
		{"handkerchief", "handkerchief"},
		{"handkerchiefs", "handkerchief"},
		{"handle", "handl"},
		{"handled", "handl"},
		{"handles", "handl"},
		{"handling", "handl"},
		{"handmaid", "handmaid"},
		{"handmaiden", "handmaiden"},
		{"handrail", "handrail"},
		{"hands", "hand"},
		{"handsome", "handsom"},
		{"handsomely", "handsom"},
		{"handsomer", "handsom"},
		{"handsomest", "handsomest"},
		{"handwriting", "handwrit"},
		{"handy", "handi"},
		{"hang", "hang"},
		{"hangdog", "hangdog"},
		{"hanged", "hang"},
		{"hanger", "hanger"},
		{"hangers", "hanger"},
		{"hanging", "hang"},
		{"hangings", "hang"},
		{"hangman", "hangman"},
		{"hangs", "hang"},
		{"hankering", "hanker"},
		{"hankers", "hanker"},
		{"hannah", "hannah"},
		{"hanover", "hanov"},
		{"hansome", "hansom"},
		{"hap", "hap"},
		{"haphazard", "haphazard"},
		{"hapless", "hapless"},
		{"haply", "hapli"},
		{"happen", "happen"},
		{"happened", "happen"},
		{"happening", "happen"},
		{"happens", "happen"},
		{"happerton", "happerton"},
		{"happertons", "happerton"},
		{"happier", "happier"},
		{"happiest", "happiest"},
		{"happily", "happili"},
		{"happiness", "happi"},
		{"happy", "happi"},
		{"harangue", "harangu"},
		{"harangued", "harangu"},
		{"harass", "harass"},
		{"harassed", "harass"},
		{"harassing", "harass"},
		{"harbinger", "harbing"},
		{"harbour", "harbour"},
		{"harboured", "harbour"},
		{"harbouring", "harbour"},
		{"harbours", "harbour"},
		{"hard", "hard"},
		{"harden", "harden"},
		{"hardened", "harden"},
		{"hardening", "harden"},
		{"harder", "harder"},
		{"hardest", "hardest"},
		{"hardihood", "hardihood"},
		{"harding", "hard"},
		{"hardly", "hard"},
		{"hardness", "hard"},
		{"hardship", "hardship"},
		{"hardships", "hardship"},
		{"hardworking", "hardwork"},
		{"hardy", "hardi"},
		{"hare", "hare"},
		{"hares", "hare"},
		{"hareskin", "hareskin"},
		{"hark", "hark"},
		{"harkee", "harke"},
		{"harkov", "harkov"},
		{"harkye", "harky"},
		{"harlamov", "harlamov"},
		{"harlequin", "harlequin"},
		{"harlot", "harlot"},
		{"harm", "harm"},
		{"harmattan", "harmattan"},
		{"harmful", "harm"},
		{"harmless", "harmless"},
		{"harmlessly", "harmless"},
		{"harmonic", "harmon"},
		{"harmonious", "harmoni"},
		{"harmoniously", "harmoni"},
		{"harmonised", "harmonis"},
		{"harmony", "harmoni"},
		{"harn", "harn"},
		{"harness", "har"},
		{"harnessed", "har"},
		{"harnessing", "har"},
		{"harold", "harold"},
		{"harp", "harp"},
		{"harpalidae", "harpalida"},
		{"harpalus", "harpalus"},
		{"harpies", "harpi"},
		{"harping", "harp"},
		{"harps", "harp"},
		{"harpy", "harpi"},
		{"harriet", "harriet"},
		{"harriett", "harriett"},
		{"harrington", "harrington"},
		{"harris", "harri"},
		{"harrison", "harrison"},
		{"harrow", "harrow"},
		{"harrowgate", "harrowg"},
		{"harrowing", "harrow"},
		{"harrows", "harrow"},
		{"harse", "hars"},
		{"harsh", "harsh"},
		{"harsher", "harsher"},
		{"harshest", "harshest"},
		{"harshly", "harsh"},
		{"harshness", "harsh"},
		{"hart", "hart"},
		{"hartlepod", "hartlepod"},
		{"hartlepool", "hartlepool"},
		{"hartshorn", "hartshorn"},
		{"harum", "harum"},
		{"harurn", "harurn"},
		{"harvest", "harvest"},
		{"has", "has"},
		{"hash", "hash"},
		{"hashed", "hash"},
		{"hasn", "hasn"},
		{"hasp", "hasp"},
		{"hassan", "hassan"},
		{"hast", "hast"},
		{"haste", "hast"},
		{"hasten", "hasten"},
		{"hastened", "hasten"},
		{"hastening", "hasten"},
		{"hastens", "hasten"},
		{"hastily", "hastili"},
		{"hasty", "hasti"},
		{"hat", "hat"},
		{"hatch", "hatch"},
		{"hatched", "hatch"},
		{"hatches", "hatch"},
		{"hatchet", "hatchet"},
		{"hatching", "hatch"},
		{"hatchings", "hatch"},
		{"hatchment", "hatchment"},
		{"hate", "hate"},
		{"hated", "hate"},
		{"hateful", "hate"},
		{"hater", "hater"},
		{"hates", "hate"},
		{"hath", "hath"},
		{"hating", "hate"},
		{"hatless", "hatless"},
		{"hatred", "hatr"},
		{"hatreds", "hatr"},
		{"hats", "hat"},
		{"hatter", "hatter"},
		{"hatton", "hatton"},
		{"haughtiest", "haughtiest"},
		{"haughtily", "haughtili"},
		{"haughtiness", "haughti"},
		{"haughtinesses", "haughti"},
		{"haughty", "haughti"},
		{"haul", "haul"},
		{"hauled", "haul"},
		{"hauling", "haul"},
		{"haunches", "haunch"},
		{"haunt", "haunt"},
		{"haunted", "haunt"},
		{"haunting", "haunt"},
		{"haunts", "haunt"},
		{"hav", "hav"},
		{"have", "have"},
		{"haven", "haven"},
		{"having", "have"},
		{"havoc", "havoc"},
		{"hawdon", "hawdon"},
		{"hawed", "haw"},
		{"hawfinch", "hawfinch"},
		{"hawk", "hawk"},
		{"hawkinses", "hawkins"},
		{"hawks", "hawk"},
		{"hawthorns", "hawthorn"},
		{"hay", "hay"},
		{"haycock", "haycock"},
		{"hayes", "hay"},
		{"haymakers", "haymak"},
		{"haymaking", "haymak"},
		{"haymarket", "haymarket"},
		{"haystacks", "haystack"},
		{"hazard", "hazard"},
		{"hazarded", "hazard"},
		{"hazarding", "hazard"},
		{"hazardous", "hazard"},
		{"hazards", "hazard"},
		{"haze", "haze"},
		{"hazel", "hazel"},
		{"hazy", "hazi"},
		{"hd", "hd"},
		{"he", "he"},
		{"hea", "hea"},
		{"head", "head"},
		{"headache", "headach"},
		{"headaches", "headach"},
		{"headdress", "headdress"},
		{"headed", "head"},
		{"headgear", "headgear"},
		{"heading", "head"},
		{"headland", "headland"},
		{"headlands", "headland"},
		{"headless", "headless"},
		{"headlong", "headlong"},
		{"headmost", "headmost"},
		{"headquarters", "headquart"},
		{"heads", "head"},
		{"headstrong", "headstrong"},
		{"heal", "heal"},
		{"healed", "heal"},
		{"healing", "heal"},
		{"health", "health"},
		{"healthful", "health"},
		{"healthier", "healthier"},
		{"healthiness", "healthi"},
		{"healths", "health"},
		{"healthy", "healthi"},
		{"heap", "heap"},
		{"heaped", "heap"},
		{"heaping", "heap"},
		{"heaps", "heap"},
		{"hear", "hear"},
		{"heard", "heard"},
		{"hearer", "hearer"},
		{"hearers", "hearer"},
		{"hearest", "hearest"},
		{"hearing", "hear"},
		{"hearken", "hearken"},
		{"hearne", "hearn"},
		{"hears", "hear"},
		{"hearse", "hears"},
		{"heart", "heart"},
		{"heartache", "heartach"},
		{"heartbroken", "heartbroken"},
		{"heartburns", "heartburn"},
		{"hearted", "heart"},
		{"heartedest", "heartedest"},
		{"heartedness", "hearted"},
		{"heartfelt", "heartfelt"},
		{"hearth", "hearth"},
		{"hearths", "hearth"},
		{"hearthstone", "hearthston"},
		{"heartiest", "heartiest"},
		{"heartily", "heartili"},
		{"heartiness", "hearti"},
		{"heartless", "heartless"},
		{"heartlessly", "heartless"},
		{"heartlessness", "heartless"},
		{"heartrending", "heartrend"},
		{"hearts", "heart"},
		{"heartsease", "heartseas"},
		{"heartsore", "heartsor"},
		{"heartstrings", "heartstr"},
		{"hearty", "hearti"},
		{"heat", "heat"},
		{"heated", "heat"},
		{"heater", "heater"},
		{"heath", "heath"},
		{"heathen", "heathen"},
		{"heather", "heather"},
		{"heaths", "heath"},
		{"heav", "heav"},
		{"heave", "heav"},
		{"heaved", "heav"},
		{"heaven", "heaven"},
		{"heavenly", "heaven"},
		{"heavens", "heaven"},
		{"heaver", "heaver"},
		{"heaves", "heav"},
		{"heavier", "heavier"},
		{"heaviest", "heaviest"},
		{"heavily", "heavili"},
		{"heaviness", "heavi"},
		{"heaving", "heav"},
		{"heavings", "heav"},
		{"heavv", "heavv"},
		{"heavy", "heavi"},
		{"hebrew", "hebrew"},
		{"hecla", "hecla"},
		{"hectic", "hectic"},
		{"hectoring", "hector"},
		{"hedge", "hedg"},
		{"hedgehog", "hedgehog"},
		{"hedgerows", "hedgerow"},
		{"hedges", "hedg"},
		{"hedging", "hedg"},
		{"heed", "heed"},
		{"heeded", "heed"},
		{"heeding", "heed"},
		{"heedless", "heedless"},
		{"heedlessly", "heedless"},
		{"heedlessness", "heedless"},
		{"heeds", "heed"},
		{"heel", "heel"},
		{"heeled", "heel"},
		{"heels", "heel"},
		{"heerd", "heerd"},
		{"heern", "heern"},
		{"heigh", "heigh"},
		{"heigho", "heigho"},
		{"height", "height"},
		{"heighten", "heighten"},
		{"heightened", "heighten"},
		{"heightening", "heighten"},
		{"heightens", "heighten"},
		{"heighth", "heighth"},
		{"heights", "height"},
		{"heinous", "heinous"},
		{"heir", "heir"},
		{"heiress", "heiress"},
		{"heiresses", "heiress"},
		{"heirlooms", "heirloom"},
		{"heirs", "heir"},
		{"heirship", "heirship"},
		{"held", "held"},
		{"helden", "helden"},
		{"helen", "helen"},
		{"helena", "helena"},
		{"heliotrope", "heliotrop"},
		{"helix", "helix"},
		{"hell", "hell"},
		{"helm", "helm"},
		{"helmet", "helmet"},
		{"helmets", "helmet"},
		{"help", "help"},
		{"helped", "help"},
		{"helper", "helper"},
		{"helpers", "helper"},
		{"helpful", "help"},
		{"helping", "help"},
		{"helpless", "helpless"},
		{"helplessly", "helpless"},
		{"helplessness", "helpless"},
		{"helpmate", "helpmat"},
		{"helps", "help"},
		{"helvellyn", "helvellyn"},
		{"hem", "hem"},
		{"hemiptera", "hemiptera"},
		{"hemisphere", "hemispher"},
		{"hemispheres", "hemispher"},
		{"hemmed", "hem"},
		{"hemming", "hem"},
		{"hempen", "hempen"},
		{"hen", "hen"},
		{"hence", "henc"},
		{"henceforth", "henceforth"},
		{"henceforward", "henceforward"},
		{"hend", "hend"},
		{"henemies", "henemi"},
		{"henrietta", "henrietta"},
		{"henriette", "henriett"},
		{"henry", "henri"},
		{"hens", "hen"},
		{"henslow", "henslow"},
		{"heptarchy", "heptarchi"},
		{"her", "her"},
		{"herald", "herald"},
		{"heralded", "herald"},
		{"heraldic", "herald"},
		{"herb", "herb"},
		{"herbaceous", "herbac"},
		{"herbage", "herbag"},
		{"herbarium", "herbarium"},
		{"herbert", "herbert"},
		{"herbivorous", "herbivor"},
		{"herbs", "herb"},
		{"herculean", "herculean"},
		{"hercules", "hercul"},
		{"herd", "herd"},
		{"herds", "herd"},
		{"here", "here"},
		{"hereabouts", "hereabout"},
		{"hereafter", "hereaft"},
		{"hereby", "herebi"},
		{"hereditary", "hereditari"},
		{"hereford", "hereford"},
		{"herein", "herein"},
		{"hereof", "hereof"},
		{"heresy", "heresi"},
		{"heretic", "heret"},
		{"heretick", "heretick"},
		{"hereticks", "heretick"},
		{"heretics", "heret"},
		{"heretofore", "heretofor"},
		{"hereupon", "hereupon"},
		{"herewith", "herewith"},
		{"heritage", "heritag"},
		{"hermit", "hermit"},
		{"hermitage", "hermitag"},
		{"hero", "hero"},
		{"herod", "herod"},
		{"heroded", "herod"},
		{"heroes", "hero"},
		{"heroic", "heroic"},
		{"heroine", "heroin"},
		{"heroism", "heroism"},
		{"herons", "heron"},
		{"herries", "herri"},
		{"herrings", "herring"},
		{"hers", "her"},
		{"herschel", "herschel"},
		{"herself", "herself"},
		{"hertfordshire", "hertfordshir"},
		{"heruvimov", "heruvimov"},
		{"hesitate", "hesit"},
		{"hesitated", "hesit"},
		{"hesitates", "hesit"},
		{"hesitating", "hesit"},
		{"hesitatingly", "hesit"},
		{"hesitation", "hesit"},
		{"hesitations", "hesit"},
		{"heterogeneous", "heterogen"},
		{"heteromera", "heteromera"},
		{"heteromerous", "heteromer"},
		{"heteromidae", "heteromida"},
		{"hever", "hever"},
		{"hew", "hew"},
		{"hewer", "hewer"},
		{"hewers", "hewer"},
		{"hewing", "hew"},
		{"hey", "hey"},
		{"heyday", "heyday"},
		{"hi", "hi"},
		{"hiatus", "hiatus"},
		{"hibiscus", "hibiscus"},
		{"hiccup", "hiccup"},
		{"hiccuped", "hiccup"},
		{"hid", "hid"},
		{"hidden", "hidden"},
		{"hide", "hide"},
		{"hideous", "hideous"},
		{"hideously", "hideous"},
		{"hideousness", "hideous"},
		{"hides", "hide"},
		{"hiding", "hide"},
		{"hierarchy", "hierarchi"},
		{"hieroglyphics", "hieroglyph"},
		{"higgenbottom", "higgenbottom"},
		{"higgins", "higgin"},
		{"high", "high"},
		{"higher", "higher"},
		{"highest", "highest"},
		{"highfaluting", "highfalut"},
		{"highgate", "highgat"},
		{"highl", "highl"},
		{"highland", "highland"},
		{"highlanders", "highland"},
		{"highlands", "highland"},
		{"highly", "high"},
		{"highness", "high"},
		{"highroad", "highroad"},
		{"highway", "highway"},
		{"highwayman", "highwayman"},
		{"highways", "highway"},
		{"hignominiousness", "hignomini"},
		{"hilaire", "hilair"},
		{"hilarious", "hilari"},
		{"hilariously", "hilari"},
		{"hilarity", "hilar"},
		{"hilda", "hilda"},
		{"hill", "hill"},
		{"hillock", "hillock"},
		{"hillocks", "hillock"},
		{"hills", "hill"},
		{"hillsides", "hillsid"},
		{"hilltops", "hilltop"},
		{"hilly", "hilli"},
		{"hilt", "hilt"},
		{"hilts", "hilt"},
		{"him", "him"},
		{"himalaya", "himalaya"},
		{"himantopus", "himantopus"},
		{"himsel", "himsel"},
		{"himself", "himself"},
		{"hind", "hind"},
		{"hinder", "hinder"},
		{"hindered", "hinder"},
		{"hindering", "hinder"},
		{"hindoos", "hindoo"},
		{"hindrance", "hindranc"},
		{"hinds", "hind"},
		{"hindu", "hindu"},
		{"hing", "hing"},
		{"hinges", "hing"},
		{"hint", "hint"},
		{"hinted", "hint"},
		{"hinting", "hint"},
		{"hints", "hint"},
		{"hip", "hip"},
		{"hippah", "hippah"},
		{"hippahs", "hippah"},
		{"hipped", "hip"},
		{"hippish", "hippish"},
		{"hippopotamus", "hippopotamus"},
		{"hippopotamuses", "hippopotamus"},
		{"hips", "hip"},
		{"hire", "hire"},
		{"hired", "hire"},
		{"hiring", "hire"},
		{"hirrold", "hirrold"},
		{"his", "his"},
		{"hiss", "hiss"},
		{"hisself", "hisself"},
		{"hisses", "hiss"},
		{"hissing", "hiss"},
		{"hist", "hist"},
		{"histoire", "histoir"},
		{"historian", "historian"},
		{"historical", "histor"},
		{"historically", "histor"},
		{"histories", "histori"},
		{"history", "histori"},
		{"histrionic", "histrion"},
		{"hit", "hit"},
		{"hitch", "hitch"},
		{"hitchcock", "hitchcock"},
		{"hitched", "hitch"},
		{"hitches", "hitch"},
		{"hitching", "hitch"},
		{"hither", "hither"},
		{"hitherto", "hitherto"},
		{"hitherward", "hitherward"},
		{"hits", "hit"},
		{"hitting", "hit"},
		{"hittites", "hittit"},
		{"hive", "hive"},
		{"hl", "hl"},
		{"hm", "hm"},
		{"ho", "ho"},
		{"hoar", "hoar"},
		{"hoard", "hoard"},
		{"hoarded", "hoard"},
		{"hoarding", "hoard"},
		{"hoardings", "hoard"},
		{"hoards", "hoard"},
		{"hoarse", "hoars"},
		{"hoarsely", "hoars"},
		{"hoarser", "hoarser"},
		{"hoary", "hoari"},
		{"hob", "hob"},
		{"hobart", "hobart"},
		{"hobbled", "hobbl"},
		{"hobbledehoy", "hobbledehoy"},
		{"hobbles", "hobbl"},
		{"hobbling", "hobbl"},
		{"hobby", "hobbi"},
		{"hobgoblin", "hobgoblin"},
		{"hoch", "hoch"},
		{"hochbeseeltes", "hochbeseelt"},
		{"hock", "hock"},
		{"hod", "hod"},
		{"hof", "hof"},
		{"hoffmanseggi", "hoffmanseggi"},
		{"hog", "hog"},
		{"hogoleu", "hogoleu"},
		{"hogs", "hog"},
		{"hoist", "hoist"},
		{"hoisted", "hoist"},
		{"hoity", "hoiti"},
		{"holborn", "holborn"},
		{"hold", "hold"},
		{"holden", "holden"},
		{"holder", "holder"},
		{"holders", "holder"},
		{"holding", "hold"},
		{"holds", "hold"},
		{"hole", "hole"},
		{"holes", "hole"},
		{"holiday", "holiday"},
		{"holidays", "holiday"},
		{"holies", "holi"},
		{"holily", "holili"},
		{"holiness", "holi"},
		{"holland", "holland"},
		{"hollies", "holli"},
		{"hollo", "hollo"},
		{"holloa", "holloa"},
		{"hollow", "hollow"},
		{"holloway", "holloway"},
		{"hollowed", "hollow"},
		{"hollower", "hollow"},
		{"hollowness", "hollow"},
		{"hollows", "hollow"},
		{"holly", "holli"},
		{"holman", "holman"},
		{"holstein", "holstein"},
		{"holuthuriae", "holuthuria"},
		{"holy", "holi"},
		{"holyhead", "holyhead"},
		{"homage", "homag"},
		{"hombre", "hombr"},
		{"home", "home"},
		{"homeless", "homeless"},
		{"homelessness", "homeless"},
		{"homelike", "homelik"},
		{"homely", "home"},
		{"homes", "home"},
		{"homeward", "homeward"},
		{"homewards", "homeward"},
		{"homicidal", "homicid"},
		{"homily", "homili"},
		{"homoptera", "homoptera"},
		{"hon", "hon"},
		{"hond", "hond"},
		{"honds", "hond"},
		{"honest", "honest"},
		{"honester", "honest"},
		{"honestest", "honestest"},
		{"honestly", "honest"},
		{"honesty", "honesti"},
		{"honey", "honey"},
		{"honeymoon", "honeymoon"},
		{"honeysuckle", "honeysuckl"},
		{"hong", "hong"},
		{"honoria", "honoria"},
		{"honour", "honour"},
		{"honourable", "honour"},
		{"honourably", "honour"},
		{"honourahle", "honourahl"},
		{"honoured", "honour"},
		{"honouring", "honour"},
		{"honourmg", "honourmg"},
		{"honours", "honour"},
		{"honysuckles", "honysuckl"},
		{"hoo", "hoo"},
		{"hood", "hood"},
		{"hooded", "hood"},
		{"hoodle", "hoodl"},
		{"hoodwinked", "hoodwink"},
		{"hoof", "hoof"},
		{"hoofs", "hoof"},
		{"hook", "hook"},
		{"hooked", "hook"},
		{"hooker", "hooker"},
		{"hooking", "hook"},
		{"hookites", "hookit"},
		{"hooks", "hook"},
		{"hoold", "hoold"},
		{"hoonger", "hoonger"},
		{"hoongry", "hoongri"},
		{"hoop", "hoop"},
		{"hooping", "hoop"},
		{"hoops", "hoop"},
		{"hoor", "hoor"},
		{"hooray", "hooray"},
		{"hoorly", "hoor"},
		{"hooted", "hoot"},
		{"hooting", "hoot"},
		{"hootings", "hoot"},
		{"hoots", "hoot"},
		{"hop", "hop"},
		{"hope", "hope"},
		{"hoped", "hope"},
		{"hopeful", "hope"},
		{"hopefully", "hope"},
		{"hopefulness", "hope"},
		{"hopeless", "hopeless"},
		{"hopelessly", "hopeless"},
		{"hopelessness", "hopeless"},
		{"hopes", "hope"},
		{"hoping", "hope"},
		{"hopped", "hop"},
		{"hopping", "hop"},
		{"hops", "hop"},
		{"horatio", "horatio"},
		{"horders", "horder"},
		{"horizon", "horizon"},
		{"horizonta", "horizonta"},
		{"horizontal", "horizont"},
		{"horizontally", "horizont"},
		{"horn", "horn"},
		{"horned", "horn"},
		{"horner", "horner"},
		{"hornet", "hornet"},
		{"hornos", "horno"},
		{"hornpipe", "hornpip"},
		{"hornpipes", "hornpip"},
		{"horns", "horn"},
		{"hornsey", "hornsey"},
		{"horny", "horni"},
		{"horrible", "horribl"},
		{"horribly", "horribl"},
		{"horrid", "horrid"},
		{"horridly", "horrid"},
		{"horrified", "horrifi"},
		{"horror", "horror"},
		{"horrors", "horror"},
		{"horse", "hors"},
		{"horseback", "horseback"},
		{"horsecloths", "horsecloth"},
		{"horseflesh", "horseflesh"},
		{"horsefly", "horsefli"},
		{"horsehair", "horsehair"},
		{"horseman", "horseman"},
		{"horsemanship", "horsemanship"},
		{"horsemen", "horsemen"},
		{"horsepittle", "horsepittl"},
		{"horses", "hors"},
		{"horsewhip", "horsewhip"},
		{"horsewhipped", "horsewhip"},
		{"horsewhipping", "horsewhip"},
		{"hortense", "hortens"},
		{"hortensio", "hortensio"},
		{"horticultural", "horticultur"},
		{"horticulture", "horticultur"},
		{"hose", "hose"},
		{"hospitable", "hospit"},
		{"hospitably", "hospit"},
		{"hospital", "hospit"},
		{"hospitalities", "hospit"},
		{"hospitality", "hospit"},
		{"hospitals", "hospit"},
		{"hospitility", "hospitil"},
		{"host", "host"},
		{"hostages", "hostag"},
		{"hoste", "host"},
		{"hostelry", "hostelri"},
		{"hostess", "hostess"},
		{"hostesses", "hostess"},
		{"hostile", "hostil"},
		{"hostilities", "hostil"},
		{"hostility", "hostil"},
		{"hostlers", "hostler"},
		{"hosts", "host"},
		{"hot", "hot"},
		{"hotel", "hotel"},
		{"hotels", "hotel"},
		{"hothouse", "hothous"},
		{"hotly", "hot"},
		{"hottentot", "hottentot"},
		{"hottentots", "hottentot"},
		{"hotter", "hotter"},
		{"hottest", "hottest"},
		{"hou", "hou"},
		{"hound", "hound"},
		{"hounded", "hound"},
		{"hounding", "hound"},
		{"hounds", "hound"},
		{"hour", "hour"},
		{"houri", "houri"},
		{"hourly", "hour"},
		{"hours", "hour"},
		{"house", "hous"},
		{"housebreaker", "housebreak"},
		{"housebuilder", "housebuild"},
		{"housed", "hous"},
		{"household", "household"},
		{"housekeeper", "housekeep"},
		{"housekeepers", "housekeep"},
		{"housekeeping", "housekeep"},
		{"housemaid", "housemaid"},
		{"housemaids", "housemaid"},
		{"housemaker", "housemak"},
		{"houses", "hous"},
		{"housetops", "housetop"},
		{"housewife", "housewif"},
		{"housewifery", "housewiferi"},
		{"hove", "hove"},
		{"hovel", "hovel"},
		{"hovels", "hovel"},
		{"hover", "hover"},
		{"hovered", "hover"},
		{"hovering", "hover"},
		{"hovers", "hover"},
		{"how", "how"},
		{"howard", "howard"},
		{"howbeit", "howbeit"},
		{"howell", "howel"},
		{"howeve", "howev"},
		{"however", "howev"},
		{"howitt", "howitt"},
		{"howl", "howl"},
		{"howled", "howl"},
		{"howling", "howl"},
		{"howls", "howl"},
		{"howsoever", "howsoev"},
		{"huacas", "huaca"},
		{"huachos", "huacho"},
		{"huantamo", "huantamo"},
		{"huapi", "huapi"},
		{"huaraz", "huaraz"},
		{"hubbard", "hubbard"},
		{"hubbub", "hubbub"},
		{"huckster", "huckster"},
		{"huddled", "huddl"},
		{"hue", "hue"},
		{"huechucucuy", "huechucucuy"},
		{"hues", "hue"},
		{"huff", "huff"},
		{"huffily", "huffili"},
		{"huffy", "huffi"},
		{"hug", "hug"},
		{"huge", "huge"},
		{"hugged", "hug"},
		{"hugging", "hug"},
		{"huggins", "huggin"},
		{"hugh", "hugh"},
		{"hugs", "hug"},
		{"huitreu", "huitreu"},
		{"hulk", "hulk"},
		{"hullo", "hullo"},
		{"hulloa", "hulloa"},
		{"hum", "hum"},
		{"humain", "humain"},
		{"humaine", "humain"},
		{"human", "human"},
		{"humane", "human"},
		{"humanely", "human"},
		{"humanising", "humanis"},
		{"humanity", "human"},
		{"humanizing", "human"},
		{"humanly", "human"},
		{"humanum", "humanum"},
		{"humble", "humbl"},
		{"humbled", "humbl"},
		{"humbleness", "humbl"},
		{"humbler", "humbler"},
		{"humblest", "humblest"},
		{"humbling", "humbl"},
		{"humbly", "humbl"},
		{"humboldt", "humboldt"},
		{"humbug", "humbug"},
		{"humbugging", "humbug"},
		{"humdrum", "humdrum"},
		{"humid", "humid"},
		{"humidity", "humid"},
		{"humiliate", "humili"},
		{"humiliated", "humili"},
		{"humiliating", "humili"},
		{"humiliation", "humili"},
		{"humility", "humil"},
		{"hummed", "hum"},
		{"humming", "hum"},
		{"hummingbirds", "hummingbird"},
		{"hummocks", "hummock"},
		{"humorous", "humor"},
		{"humorously", "humor"},
		{"humour", "humour"},
		{"humoured", "humour"},
		{"humouredly", "humour"},
		{"humouring", "humour"},
		{"humours", "humour"},
		{"hump", "hump"},
		{"humph", "humph"},
		{"hums", "hum"},
		{"hunchback", "hunchback"},
		{"hundred", "hundr"},
		{"hundreds", "hundr"},
		{"hundredth", "hundredth"},
		{"hundredweight", "hundredweight"},
		{"hung", "hung"},
		{"hunger", "hunger"},
		{"hungering", "hunger"},
		{"hungry", "hungri"},
		{"hunks", "hunk"},
		{"hunky", "hunki"},
		{"hunt", "hunt"},
		{"hunted", "hunt"},
		{"hunter", "hunter"},
		{"hunters", "hunter"},
		{"hunting", "hunt"},
		{"hunts", "hunt"},
		{"huntsman", "huntsman"},
		{"huntsmen", "huntsmen"},
		{"hurled", "hurl"},
		{"hurly", "hur"},
		{"hurrah", "hurrah"},
		{"hurrahed", "hurrah"},
		{"hurrahs", "hurrah"},
		{"hurricane", "hurrican"},
		{"hurried", "hurri"},
		{"hurriedly", "hurri"},
		{"hurries", "hurri"},
		{"hurry", "hurri"},
		{"hurrying", "hurri"},
		{"hurt", "hurt"},
		{"hurtado", "hurtado"},
		{"hurting", "hurt"},
		{"hurts", "hurt"},
		{"husband", "husband"},
		{"husbanded", "husband"},
		{"husbandman", "husbandman"},
		{"husbands", "husband"},
		{"hush", "hush"},
		{"hushed", "hush"},
		{"hushing", "hush"},
		{"husk", "husk"},
		{"huskily", "huskili"},
		{"huskiness", "huski"},
		{"husky", "huski"},
		{"hussar", "hussar"},
		{"hussy", "hussi"},
		{"hustings", "hust"},
		{"hustle", "hustl"},
		{"hustled", "hustl"},
		{"hustling", "hustl"},
		{"hut", "hut"},
		{"hutch", "hutch"},
		{"huts", "hut"},
		{"hutton", "hutton"},
		{"hy", "hy"},
		{"hyacinth", "hyacinth"},
		{"hyacinths", "hyacinth"},
		{"hyaena", "hyaena"},
		{"hybernate", "hybern"},
		{"hybernating", "hybern"},
		{"hybernation", "hybern"},
		{"hybrid", "hybrid"},
		{"hybrida", "hybrida"},
		{"hyde", "hyde"},
		{"hydra", "hydra"},
		{"hydraulic", "hydraul"},
		{"hydrobius", "hydrobius"},
		{"hydrochaerus", "hydrochaerus"},
		{"hydrogen", "hydrogen"},
		{"hydrographer", "hydrograph"},
		{"hydrophilidae", "hydrophilida"},
		{"hydrophilus", "hydrophilus"},
		{"hydrophobia", "hydrophobia"},
		{"hydroporus", "hydroporus"},
		{"hygrometer", "hygromet"},
		{"hyla", "hyla"},
		{"hymenophallus", "hymenophallus"},
		{"hymenoptera", "hymenoptera"},
		{"hymenopterous", "hymenopter"},
		{"hymn", "hymn"},
		{"hymns", "hymn"},
		{"hyperbolical", "hyperbol"},
		{"hyperion", "hyperion"},
		{"hypochondria", "hypochondria"},
		{"hypochondriac", "hypochondriac"},
		{"hypochondriacal", "hypochondriac"},
		{"hypocrisy", "hypocrisi"},
		{"hypocrite", "hypocrit"},
		{"hypocritical", "hypocrit"},
		{"hypocritically", "hypocrit"},
		{"hypotheses", "hypothes"},
		{"hypothesis", "hypothesi"},
		{"hypothetical", "hypothet"},
		{"hyseters", "hyset"},
		{"hysteric", "hyster"},
		{"hysterical", "hyster"},
		{"hysterically", "hyster"},
		{"hysterics", "hyster"},
		{"i", "i"},
		{"iagoensis", "iagoensi"},
		{"ibis", "ibi"},
		{"ica", "ica"},
		{"ice", "ice"},
		{"iceberg", "iceberg"},
		{"icebergs", "iceberg"},
		{"iced", "ice"},
		{"iceland", "iceland"},
		{"ices", "ice"},
		{"ich", "ich"},
		{"icterus", "icterus"},
		{"icy", "ici"},
		{"ide", "ide"},
		{"idea", "idea"},
		{"ideal", "ideal"},
		{"idealism", "ideal"},
		{"idealist", "idealist"},
		{"ideality", "ideal"},
		{"ideals", "ideal"},
		{"ideas", "idea"},
		{"identical", "ident"},
		{"identically", "ident"},
		{"identification", "identif"},
		{"identified", "identifi"},
		{"identifles", "identifl"},
		{"identifying", "identifi"},
		{"identity", "ident"},
		{"idiocy", "idioci"},
		{"idiosyncrasies", "idiosyncrasi"},
		{"idiosyncrasy", "idiosyncrasi"},
		{"idiot", "idiot"},
		{"idiotcy", "idiotci"},
		{"idiotic", "idiot"},
		{"idiotically", "idiot"},
		{"idiots", "idiot"},
		{"idle", "idl"},
		{"idleness", "idl"},
		{"idlers", "idler"},
		{"idlest", "idlest"},
		{"idling", "idl"},
		{"idly", "idl"},
		{"idol", "idol"},
		{"idolatrous", "idolatr"},
		{"idolatry", "idolatri"},
		{"idolized", "idol"},
		{"ie", "ie"},
		{"ied", "ie"},
		{"if", "if"},
		{"ies", "ie"},
		{"ight", "ight"},
		{"ighway", "ighway"},
		{"igneous", "igneous"},
		{"ignited", "ignit"},
		{"igniting", "ignit"},
		{"ignoble", "ignobl"},
		{"ignominious", "ignomini"},
		{"ignominy", "ignomini"},
		{"ignoramuses", "ignoramus"},
		{"ignorance", "ignor"},
		{"ignorant", "ignor"},
		{"ignorantly", "ignor"},
		{"ignore", "ignor"},
		{"ignored", "ignor"},
		{"ignoring", "ignor"},
		{"iguana", "iguana"},
		{"ii", "ii"},
		{"iii", "iii"},
		{"ikon", "ikon"},
		{"ikons", "ikon"},
		{"il", "il"},
		{"iles", "ile"},
		{"ill", "ill"},
		{"illapel", "illapel"},
		{"illegible", "illeg"},
		{"illegitimate", "illegitim"},
		{"illiberal", "illiber"},
		{"illig", "illig"},
		{"illimitable", "illimit"},
		{"illiterate", "illiter"},
		{"illness", "ill"},
		{"illnesses", "ill"},
		{"illuminate", "illumin"},
		{"illuminated", "illumin"},
		{"illuminating", "illumin"},
		{"illumined", "illumin"},
		{"illusion", "illus"},
		{"illusions", "illus"},
		{"illustrated", "illustr"},
		{"illustrates", "illustr"},
		{"illustrating", "illustr"},
		{"illustration", "illustr"},
		{"illustrations", "illustr"},
		{"illustrative", "illustr"},
		{"illustrious", "illustri"},
		{"ils", "il"},
		{"ilya", "ilya"},
		{"image", "imag"},
		{"images", "imag"},
		{"imaginable", "imagin"},
		{"imaginary", "imaginari"},
		{"imagination", "imagin"},
		{"imaginative", "imagin"},
		{"imagine", "imagin"},
		{"imagined", "imagin"},
		{"imagines", "imagin"},
		{"imagining", "imagin"},
		{"imaginings", "imagin"},
		{"imbecile", "imbecil"},
		{"imbecility", "imbecil"},
		{"imbedded", "imbed"},
		{"imbibed", "imbib"},
		{"imbue", "imbu"},
		{"imbued", "imbu"},
		{"imeantersay", "imeantersay"},
		{"imitate", "imit"},
		{"imitated", "imit"},
		{"imitating", "imit"},
		{"imitation", "imit"},
		{"imitations", "imit"},
		{"imitative", "imit"},
		{"imitator", "imit"},
		{"immaculate", "immacul"},
		{"immaterial", "immateri"},
		{"immature", "immatur"},
		{"immeasurable", "immeasur"},
		{"immeasurably", "immeasur"},
		{"immediate", "immedi"},
		{"immediately", "immedi"},
		{"immemorial", "immemori"},
		{"immense", "immens"},
		{"immensely", "immens"},
		{"immensity", "immens"},
		{"immensus", "immensus"},
		{"immersed", "immers"},
		{"immersion", "immers"},
		{"immigrants", "immigr"},
		{"imminent", "immin"},
		{"immoderate", "immoder"},
		{"immolate", "immol"},
		{"immolation", "immol"},
		{"immoral", "immor"},
		{"immorality", "immor"},
		{"immortal", "immort"},
		{"immortality", "immort"},
		{"immovability", "immov"},
		{"immovable", "immov"},
		{"immovably", "immov"},
		{"immoveable", "immov"},
		{"immured", "immur"},
		{"immutability", "immut"},
		{"immutable", "immut"},
		{"imp", "imp"},
		{"impair", "impair"},
		{"impaired", "impair"},
		{"impairing", "impair"},
		{"impaling", "impal"},
		{"impalpable", "impalp"},
		{"impalpably", "impalp"},
		{"impanelled", "impanel"},
		{"impart", "impart"},
		{"imparted", "impart"},
		{"impartial", "imparti"},
		{"impartiality", "imparti"},
		{"impartially", "imparti"},
		{"imparting", "impart"},
		{"imparts", "impart"},
		{"impassable", "impass"},
		{"impassibility", "impass"},
		{"impassible", "impass"},
		{"impassioned", "impass"},
		{"impassive", "impass"},
		{"impassiveness", "impass"},
		{"impatience", "impati"},
		{"impatient", "impati"},
		{"impatiently", "impati"},
		{"impeach", "impeach"},
		{"impeachment", "impeach"},
		{"impecuniosity", "impecunios"},
		{"impecunious", "impecuni"},
		{"impede", "imped"},
		{"impeded", "imped"},
		{"impediment", "impedi"},
		{"impediments", "impedi"},
		{"impel", "impel"},
		{"impelled", "impel"},
		{"impels", "impel"},
		{"impend", "impend"},
		{"impending", "impend"},
		{"impenetrabilities", "impenetr"},
		{"impenetrable", "impenetr"},
		{"imperative", "imper"},
		{"imperatively", "imper"},
		{"imperceptibly", "impercept"},
		{"imperfect", "imperfect"},
		{"imperfection", "imperfect"},
		{"imperfectly", "imperfect"},
		{"imperial", "imperi"},
		{"imperilled", "imperil"},
		{"imperils", "imperil"},
		{"imperious", "imperi"},
		{"imperiously", "imperi"},
		{"impersonal", "imperson"},
		{"impertinence", "impertin"},
		{"impertinent", "impertin"},
		{"impertinently", "impertin"},
		{"imperturbability", "imperturb"},
		{"imperturbable", "imperturb"},
		{"imperturbably", "imperturb"},
		{"impervious", "impervi"},
		{"impetuosity", "impetuos"},
		{"impetuous", "impetu"},
		{"impetuously", "impetu"},
		{"impiety", "impieti"},
		{"impious", "impious"},
		{"implacable", "implac"},
		{"implacably", "implac"},
		{"implanted", "implant"},
		{"implement", "implement"},
		{"implements", "implement"},
		{"implicate", "implic"},
		{"implicated", "implic"},
		{"implication", "implic"},
		{"implicit", "implicit"},
		{"implicitly", "implicit"},
		{"implied", "impli"},
		{"implies", "impli"},
		{"implore", "implor"},
		{"implored", "implor"},
		{"imploring", "implor"},
		{"imploringly", "implor"},
		{"imply", "impli"},
		{"implying", "impli"},
		{"impolitic", "impolit"},
		{"import", "import"},
		{"importance", "import"},
		{"important", "import"},
		{"importation", "import"},
		{"imported", "import"},
		{"importer", "import"},
		{"importing", "import"},
		{"importunate", "importun"},
		{"importunity", "importun"},
		{"impose", "impos"},
		{"imposed", "impos"},
		{"imposing", "impos"},
		{"imposition", "imposit"},
		{"impossibilities", "imposs"},
		{"impossibility", "imposs"},
		{"impossible", "imposs"},
		{"imposter", "impost"},
		{"impostors", "impostor"},
		{"imposture", "impostur"},
		{"impostures", "impostur"},
		{"impotence", "impot"},
		{"impotent", "impot"},
		{"impoverished", "impoverish"},
		{"impracticability", "impractic"},
		{"impracticable", "impractic"},
		{"impracticality", "impract"},
		{"imprecation", "imprec"},
		{"imprecations", "imprec"},
		{"impregnability", "impregn"},
		{"impregnable", "impregn"},
		{"impregnated", "impregn"},
		{"impress", "impress"},
		{"impressed", "impress"},
		{"impresses", "impress"},
		{"impressible", "impress"},
		{"impressing", "impress"},
		{"impression", "impress"},
		{"impressionable", "impression"},
		{"impressions", "impress"},
		{"impressive", "impress"},
		{"impressively", "impress"},
		{"imprinted", "imprint"},
		{"imprinting", "imprint"},
		{"imprisoned", "imprison"},
		{"imprisonment", "imprison"},
		{"improbability", "improb"},
		{"improbable", "improb"},
		{"improbably", "improb"},
		{"impromptu", "impromptu"},
		{"improper", "improp"},
		{"improperly", "improp"},
		{"impropriety", "improprieti"},
		{"improve", "improv"},
		{"improved", "improv"},
		{"improvement", "improv"},
		{"improvements", "improv"},
		{"improves", "improv"},
		{"improvident", "improvid"},
		{"improving", "improv"},
		{"improvisatrice", "improvisatric"},
		{"imprudence", "imprud"},
		{"imprudent", "imprud"},
		{"imprudently", "imprud"},
		{"imps", "imp"},
		{"impudence", "impud"},
		{"impudent", "impud"},
		{"impudently", "impud"},
		{"impugned", "impugn"},
		{"impulse", "impuls"},
		{"impulses", "impuls"},
		{"impulsive", "impuls"},
		{"impulsively", "impuls"},
		{"impulsiveness", "impuls"},
		{"impunity", "impun"},
		{"impure", "impur"},
		{"impurity", "impur"},
		{"imputation", "imput"},
		{"impute", "imput"},
		{"imputed", "imput"},
		{"imputing", "imput"},
		{"imself", "imself"},
		{"in", "in"},
		{"inability", "inabl"},
		{"inaccessible", "inaccess"},
		{"inaccurate", "inaccur"},
		{"inaccurately", "inaccur"},
		{"inaction", "inact"},
		{"inactive", "inact"},
		{"inactivity", "inact"},
		{"inadequate", "inadequ"},
		{"inadmissible", "inadmiss"},
		{"inadvertently", "inadvert"},
		{"inanimate", "inanim"},
		{"inanities", "inan"},
		{"inanity", "inan"},
		{"inappeasable", "inappeas"},
		{"inapplicable", "inapplic"},
		{"inappreciable", "inappreci"},
		{"inappropriate", "inappropri"},
		{"inappropriately", "inappropri"},
		{"inaptitude", "inaptitud"},
		{"inaptly", "inapt"},
		{"inarticulate", "inarticul"},
		{"inarticulately", "inarticul"},
		{"inartistic", "inartist"},
		{"inasmuch", "inasmuch"},
		{"inattention", "inattent"},
		{"inattentive", "inattent"},
		{"inaudible", "inaud"},
		{"inaudibly", "inaud"},
		{"inaugurate", "inaugur"},
		{"inaugurated", "inaugur"},
		{"inaugurates", "inaugur"},
		{"inauspicious", "inauspici"},
		{"inborn", "inborn"},
		{"inbred", "inbr"},
		{"incalculable", "incalcul"},
		{"incalculably", "incalcul"},
		{"incapable", "incap"},
		{"incapacitated", "incapacit"},
		{"incapacity", "incapac"},
		{"incarnation", "incarn"},
		{"incas", "inca"},
		{"incased", "incas"},
		{"incautious", "incauti"},
		{"incautiously", "incauti"},
		{"incense", "incens"},
		{"incensed", "incens"},
		{"incentive", "incent"},
		{"incessant", "incess"},
		{"incessantly", "incess"},
		{"inch", "inch"},
		{"inches", "inch"},
		{"incident", "incid"},
		{"incidental", "incident"},
		{"incidentally", "incident"},
		{"incidents", "incid"},
		{"incipient", "incipi"},
		{"incisions", "incis"},
		{"incisive", "incis"},
		{"incited", "incit"},
		{"incitement", "incit"},
		{"incivility", "incivil"},
		{"inclemency", "inclem"},
		{"inclement", "inclement"},
		{"inclination", "inclin"},
		{"inclinations", "inclin"},
		{"incline", "inclin"},
		{"inclined", "inclin"},
		{"inclines", "inclin"},
		{"inclining", "inclin"},
		{"inclosure", "inclosur"},
		{"include", "includ"},
		{"included", "includ"},
		{"includes", "includ"},
		{"including", "includ"},
		{"inclusive", "inclus"},
		{"incog", "incog"},
		{"incognita", "incognita"},
		{"incognito", "incognito"},
		{"incoherence", "incoher"},
		{"incoherent", "incoher"},
		{"incoherently", "incoher"},
		{"income", "incom"},
		{"incoming", "incom"},
		{"incommoded", "incommod"},
		{"incomparably", "incompar"},
		{"incompatibility", "incompat"},
		{"incompatible", "incompat"},
		{"incomplete", "incomplet"},
		{"incomprehensible", "incomprehens"},
		{"inconceivable", "inconceiv"},
		{"incongruity", "incongru"},
		{"incongruous", "incongru"},
		{"inconsiderable", "inconsider"},
		{"inconsiderate", "inconsider"},
		{"inconsiderately", "inconsider"},
		{"inconsiderateness", "inconsider"},
		{"inconsistencies", "inconsist"},
		{"inconsistency", "inconsist"},
		{"inconsistent", "inconsist"},
		{"inconsistently", "inconsist"},
		{"inconsolable", "inconsol"},
		{"inconstancy", "inconst"},
		{"inconstant", "inconst"},
		{"incontestable", "incontest"},
		{"incontestably", "incontest"},
		{"inconvenience", "inconveni"},
		{"inconvenienced", "inconvenienc"},
		{"inconveniences", "inconveni"},
		{"inconveniency", "inconveni"},
		{"inconvenient", "inconveni"},
		{"inconveniently", "inconveni"},
		{"incorrect", "incorrect"},
		{"incorrectly", "incorrect"},
		{"incorrigible", "incorrig"},
		{"incorruptible", "incorrupt"},
		{"increase", "increas"},
		{"increased", "increas"},
		{"increases", "increas"},
		{"increasing", "increas"},
		{"increasingly", "increas"},
		{"incredible", "incred"},
		{"incredibly", "incred"},
		{"incredulity", "incredul"},
		{"incredulous", "incredul"},
		{"incredulously", "incredul"},
		{"incrustation", "incrust"},
		{"incrustations", "incrust"},
		{"incrusted", "incrust"},
		{"incubation", "incub"},
		{"incubus", "incubus"},
		{"inculcate", "inculc"},
		{"inculcates", "inculc"},
		{"inculcating", "inculc"},
		{"incumbent", "incumb"},
		{"incumbrance", "incumbr"},
		{"incumbrances", "incumbr"},
		{"incur", "incur"},
		{"incurious", "incuri"},
		{"incurred", "incur"},
		{"incursion", "incurs"},
		{"indebted", "indebt"},
		{"indecency", "indec"},
		{"indecent", "indec"},
		{"indecently", "indec"},
		{"indecision", "indecis"},
		{"indecorous", "indecor"},
		{"indecorously", "indecor"},
		{"indeed", "inde"},
		{"indefatigable", "indefatig"},
		{"indefatigably", "indefatig"},
		{"indefinable", "indefin"},
		{"indefinably", "indefin"},
		{"indefinite", "indefinit"},
		{"indefinitely", "indefinit"},
		{"indelible", "indel"},
		{"indelibly", "indel"},
		{"indelicate", "indel"},
		{"indented", "indent"},
		{"indenting", "indent"},
		{"indenture", "indentur"},
		{"independence", "independ"},
		{"independent", "independ"},
		{"independently", "independ"},
		{"independeuce", "independeuc"},
		{"inder", "inder"},
		{"indescribable", "indescrib"},
		{"indescribably", "indescrib"},
		{"indestructible", "indestruct"},
		{"india", "india"},
		{"indiaman", "indiaman"},
		{"indian", "indian"},
		{"indians", "indian"},
		{"indica", "indica"},
		{"indicate", "indic"},
		{"indicated", "indic"},
		{"indicates", "indic"},
		{"indicating", "indic"},
		{"indication", "indic"},
		{"indications", "indic"},
		{"indicative", "indic"},
		{"indies", "indi"},
		{"indifference", "indiffer"},
		{"indifferent", "indiffer"},
		{"indifferently", "indiffer"},
		{"indigenous", "indigen"},
		{"indigent", "indig"},
		{"indigestion", "indigest"},
		{"indignant", "indign"},
		{"indignantly", "indign"},
		{"indignation", "indign"},
		{"indignities", "indign"},
		{"indignity", "indign"},
		{"indigo", "indigo"},
		{"indios", "indio"},
		{"indirect", "indirect"},
		{"indirectly", "indirect"},
		{"indiscreet", "indiscreet"},
		{"indiscreetness", "indiscreet"},
		{"indiscretion", "indiscret"},
		{"indiscretions", "indiscret"},
		{"indiscriminate", "indiscrimin"},
		{"indiscriminately", "indiscrimin"},
		{"indiscriminating", "indiscrimin"},
		{"indispensable", "indispens"},
		{"indispensably", "indispens"},
		{"indisposed", "indispos"},
		{"indisposition", "indisposit"},
		{"indisputably", "indisput"},
		{"indistinct", "indistinct"},
		{"indistinctly", "indistinct"},
		{"indistinctness", "indistinct"},
		{"indistinguishable", "indistinguish"},
		{"indited", "indit"},
		{"individua", "individua"},
		{"individual", "individu"},
		{"individualism", "individu"},
		{"individuality", "individu"},
		{"individually", "individu"},
		{"individuals", "individu"},
		{"indo", "indo"},
		{"indolence", "indol"},
		{"indolent", "indol"},
		{"indolently", "indol"},
		{"indomitable", "indomit"},
		{"indoor", "indoor"},
		{"indoors", "indoor"},
		{"indubitable", "indubit"},
		{"indubitably", "indubit"},
		{"induce", "induc"},
		{"induced", "induc"},
		{"inducement", "induc"},
		{"inducements", "induc"},
		{"induces", "induc"},
		{"inducing", "induc"},
		{"inducted", "induct"},
		{"inducts", "induct"},
		{"indulge", "indulg"},
		{"indulged", "indulg"},
		{"indulgence", "indulg"},
		{"indulgences", "indulg"},
		{"indulgent", "indulg"},
		{"indulging", "indulg"},
		{"indurated", "indur"},
		{"industrie", "industri"},
		{"industrious", "industri"},
		{"industriously", "industri"},
		{"industry", "industri"},
		{"inebriated", "inebri"},
		{"inebriety", "inebrieti"},
		{"ineffable", "ineff"},
		{"ineffective", "ineffect"},
		{"ineffectiveness", "ineffect"},
		{"ineffectual", "ineffectu"},
		{"ineffectually", "ineffectu"},
		{"inefficacious", "inefficaci"},
		{"inefficacy", "inefficaci"},
		{"inefficiency", "ineffici"},
		{"inefficient", "ineffici"},
		{"inelegance", "ineleg"},
		{"ineptitude", "ineptitud"},
		{"inequalities", "inequ"},
		{"inequality", "inequ"},
		{"ineradicable", "ineradic"},
		{"inermis", "inermi"},
		{"inert", "inert"},
		{"inertia", "inertia"},
		{"inertness", "inert"},
		{"inestimable", "inestim"},
		{"inestimably", "inestim"},
		{"inevitable", "inevit"},
		{"inevitably", "inevit"},
		{"inexcusable", "inexcus"},
		{"inexhaustible", "inexhaust"},
		{"inexorable", "inexor"},
		{"inexpedient", "inexpedi"},
		{"inexperience", "inexperi"},
		{"inexperienced", "inexperienc"},
		{"inexpiable", "inexpi"},
		{"inexplicable", "inexplic"},
		{"inexpressible", "inexpress"},
		{"inexpressibles", "inexpress"},
		{"inexpressibly", "inexpress"},
		{"inexpressive", "inexpress"},
		{"inexpressively", "inexpress"},
		{"inextinguishable", "inextinguish"},
		{"infallibility", "infal"},
		{"infallible", "infal"},
		{"infallibly", "infal"},
		{"infame", "infam"},
		{"infamies", "infami"},
		{"infamous", "infam"},
		{"infamy", "infami"},
		{"infancy", "infanc"},
		{"infant", "infant"},
		{"infanticide", "infanticid"},
		{"infantine", "infantin"},
		{"infantry", "infantri"},
		{"infants", "infant"},
		{"infatuated", "infatu"},
		{"infatuation", "infatu"},
		{"infect", "infect"},
		{"infected", "infect"},
		{"infection", "infect"},
		{"infectious", "infecti"},
		{"infer", "infer"},
		{"inference", "infer"},
		{"inferior", "inferior"},
		{"inferiorities", "inferior"},
		{"inferiority", "inferior"},
		{"inferiors", "inferior"},
		{"infernal", "infern"},
		{"inferred", "infer"},
		{"inferring", "infer"},
		{"infested", "infest"},
		{"infidel", "infidel"},
		{"infidelities", "infidel"},
		{"infidelity", "infidel"},
		{"infidels", "infidel"},
		{"infinite", "infinit"},
		{"infinitely", "infinit"},
		{"infinitesimal", "infinitesim"},
		{"infinitum", "infinitum"},
		{"infinity", "infin"},
		{"infirm", "infirm"},
		{"infirmities", "infirm"},
		{"infirmity", "infirm"},
		{"inflamed", "inflam"},
		{"inflammable", "inflamm"},
		{"inflammation", "inflamm"},
		{"inflated", "inflat"},
		{"inflates", "inflat"},
		{"inflation", "inflat"},
		{"inflexam", "inflexam"},
		{"inflexibility", "inflex"},
		{"inflexible", "inflex"},
		{"inflict", "inflict"},
		{"inflicted", "inflict"},
		{"inflicting", "inflict"},
		{"infliction", "inflict"},
		{"inflicts", "inflict"},
		{"influence", "influenc"},
		{"influenced", "influenc"},
		{"influences", "influenc"},
		{"influencing", "influenc"},
		{"influential", "influenti"},
		{"influx", "influx"},
		{"inform", "inform"},
		{"informant", "inform"},
		{"information", "inform"},
		{"informed", "inform"},
		{"informer", "inform"},
		{"informing", "inform"},
		{"informs", "inform"},
		{"infra", "infra"},
		{"infrequency", "infrequ"},
		{"infrequent", "infrequ"},
		{"infrequently", "infrequ"},
		{"infuriated", "infuri"},
		{"infuse", "infus"},
		{"infused", "infus"},
		{"infusing", "infus"},
		{"infusoria", "infusoria"},
		{"infusorial", "infusori"},
		{"ing", "ing"},
		{"ingenio", "ingenio"},
		{"ingenious", "ingeni"},
		{"ingeniously", "ingeni"},
		{"ingenuity", "ingenu"},
		{"ingenuous", "ingenu"},
		{"ingenuously", "ingenu"},
		{"ingleses", "ingles"},
		{"ingrained", "ingrain"},
		{"ingratiate", "ingrati"},
		{"ingratiated", "ingrati"},
		{"ingratiating", "ingrati"},
		{"ingratitude", "ingratitud"},
		{"ingredient", "ingredi"},
		{"ingredients", "ingredi"},
		{"inhabit", "inhabit"},
		{"inhabitant", "inhabit"},
		{"inhabitants", "inhabit"},
		{"inhabited", "inhabit"},
		{"inhabiting", "inhabit"},
		{"inhabits", "inhabit"},
		{"inhaled", "inhal"},
		{"inhaling", "inhal"},
		{"inharmonious", "inharmoni"},
		{"inherent", "inher"},
		{"inherit", "inherit"},
		{"inheritance", "inherit"},
		{"inherited", "inherit"},
		{"inheriting", "inherit"},
		{"inhospitable", "inhospit"},
		{"inhospitality", "inhospit"},
		{"inhuman", "inhuman"},
		{"inhumanity", "inhuman"},
		{"inhumanly", "inhuman"},
		{"inimical", "inim"},
		{"iniquities", "iniqu"},
		{"iniquity", "iniqu"},
		{"init", "init"},
		{"initial", "initi"},
		{"initiated", "initi"},
		{"initiation", "initi"},
		{"initiative", "initi"},
		{"initiatory", "initiatori"},
		{"injected", "inject"},
		{"injection", "inject"},
		{"injections", "inject"},
		{"injudicious", "injudici"},
		{"injudiciously", "injudici"},
		{"injunction", "injunct"},
		{"injunctions", "injunct"},
		{"injure", "injur"},
		{"injured", "injur"},
		{"injures", "injur"},
		{"injuries", "injuri"},
		{"injuring", "injur"},
		{"injurious", "injuri"},
		{"injury", "injuri"},
		{"injustice", "injustic"},
		{"ink", "ink"},
		{"inked", "ink"},
		{"inkling", "inkl"},
		{"inkpot", "inkpot"},
		{"inkstand", "inkstand"},
		{"inkstands", "inkstand"},
		{"inkwhich", "inkwhich"},
		{"inkwhiched", "inkwhich"},
		{"inky", "inki"},
		{"inlaid", "inlaid"},
		{"inland", "inland"},
		{"inlet", "inlet"},
		{"inlets", "inlet"},
		{"inmate", "inmat"},
		{"inmates", "inmat"},
		{"inmost", "inmost"},
		{"inn", "inn"},
		{"innate", "innat"},
		{"inner", "inner"},
		{"innings", "inning"},
		{"innkeeper", "innkeep"},
		{"innkeepers", "innkeep"},
		{"innocence", "innoc"},
		{"innocent", "innoc"},
		{"innocently", "innoc"},
		{"innocents", "innoc"},
		{"innocuous", "innocu"},
		{"innombrable", "innombr"},
		{"inns", "inn"},
		{"innuendo", "innuendo"},
		{"innuendoes", "innuendo"},
		{"innumerable", "innumer"},
		{"inoffensive", "inoffens"},
		{"inopportune", "inopportun"},
		{"inopportunely", "inopportun"},
		{"inorganic", "inorgan"},
		{"inquest", "inquest"},
		{"inquests", "inquest"},
		{"inquire", "inquir"},
		{"inquired", "inquir"},
		{"inquirer", "inquir"},
		{"inquirers", "inquir"},
		{"inquires", "inquir"},
		{"inquiries", "inquiri"},
		{"inquiring", "inquir"},
		{"inquiringly", "inquir"},
		{"inquiry", "inquiri"},
		{"inquisition", "inquisit"},
		{"inquisitive", "inquisit"},
		{"inquisitively", "inquisit"},
		{"inquisitiveness", "inquisit"},
		{"inroad", "inroad"},
		{"inroads", "inroad"},
		{"ins", "in"},
		{"insane", "insan"},
		{"insanity", "insan"},
		{"insatiable", "insati"},
		{"insatiate", "insati"},
		{"inscribed", "inscrib"},
		{"inscription", "inscript"},
		{"inscriptions", "inscript"},
		{"inscrutable", "inscrut"},
		{"insect", "insect"},
		{"insects", "insect"},
		{"insecure", "insecur"},
		{"insecurity", "insecur"},
		{"insense", "insens"},
		{"insensibility", "insens"},
		{"insensible", "insens"},
		{"insensibly", "insens"},
		{"inseparable", "insepar"},
		{"inserted", "insert"},
		{"inserting", "insert"},
		{"insertion", "insert"},
		{"inserts", "insert"},
		{"inside", "insid"},
		{"insides", "insid"},
		{"insight", "insight"},
		{"insignificance", "insignific"},
		{"insignificant", "insignific"},
		{"insinuate", "insinu"},
		{"insinuated", "insinu"},
		{"insinuating", "insinu"},
		{"insinuation", "insinu"},
		{"insinuations", "insinu"},
		{"insipid", "insipid"},
		{"insipidity", "insipid"},
		{"insist", "insist"},
		{"insisted", "insist"},
		{"insistence", "insist"},
		{"insistent", "insist"},
		{"insistently", "insist"},
		{"insistes", "insist"},
		{"insisting", "insist"},
		{"insists", "insist"},
		{"insolence", "insol"},
		{"insolent", "insol"},
		{"insolently", "insol"},
		{"insolvent", "insolv"},
		{"insomuch", "insomuch"},
		{"inspect", "inspect"},
		{"inspected", "inspect"},
		{"inspecting", "inspect"},
		{"inspection", "inspect"},
		{"inspector", "inspector"},
		{"inspects", "inspect"},
		{"inspiration", "inspir"},
		{"inspire", "inspir"},
		{"inspired", "inspir"},
		{"inspires", "inspir"},
		{"inspiring", "inspir"},
		{"inspirit", "inspirit"},
		{"inspiriting", "inspirit"},
		{"instability", "instabl"},
		{"installed", "instal"},
		{"instalment", "instal"},
		{"instance", "instanc"},
		{"instanced", "instanc"},
		{"instances", "instanc"},
		{"instant", "instant"},
		{"instantaneous", "instantan"},
		{"instantaneously", "instantan"},
		{"instantly", "instant"},
		{"instea", "instea"},
		{"instead", "instead"},
		{"instigated", "instig"},
		{"instigation", "instig"},
		{"instigator", "instig"},
		{"instil", "instil"},
		{"instinct", "instinct"},
		{"instinctive", "instinct"},
		{"instinctively", "instinct"},
		{"instincts", "instinct"},
		{"institut", "institut"},
		{"institute", "institut"},
		{"instituted", "institut"},
		{"institution", "institut"},
		{"institutions", "institut"},
		{"instruct", "instruct"},
		{"instructed", "instruct"},
		{"instructing", "instruct"},
		{"instruction", "instruct"},
		{"instructions", "instruct"},
		{"instructive", "instruct"},
		{"instructor", "instructor"},
		{"instructs", "instruct"},
		{"instrument", "instrument"},
		{"instrumental", "instrument"},
		{"instrumentality", "instrument"},
		{"instruments", "instrument"},
		{"insubordinate", "insubordin"},
		{"insubordination", "insubordin"},
		{"insufferable", "insuffer"},
		{"insufferably", "insuffer"},
		{"insufficient", "insuffici"},
		{"insufficiently", "insuffici"},
		{"insular", "insular"},
		{"insulated", "insul"},
		{"insult", "insult"},
		{"insulted", "insult"},
		{"insulting", "insult"},
		{"insults", "insult"},
		{"insuperable", "insuper"},
		{"insupportable", "insupport"},
		{"insure", "insur"},
		{"insured", "insur"},
		{"insuring", "insur"},
		{"insurmountable", "insurmount"},
		{"intact", "intact"},
		{"integral", "integr"},
		{"integrity", "integr"},
		{"intellect", "intellect"},
		{"intellects", "intellect"},
		{"intellectual", "intellectu"},
		{"intellectuality", "intellectu"},
		{"intellectually", "intellectu"},
		{"intelligence", "intellig"},
		{"intelligent", "intellig"},
		{"intelligently", "intellig"},
		{"intelligible", "intellig"},
		{"intelligibly", "intellig"},
		{"intemperance", "intemper"},
		{"intemperate", "intemper"},
		{"intend", "intend"},
		{"intended", "intend"},
		{"intendeds", "intend"},
		{"intending", "intend"},
		{"intends", "intend"},
		{"intense", "intens"},
		{"intensely", "intens"},
		{"intensest", "intensest"},
		{"intensifies", "intensifi"},
		{"intensifying", "intensifi"},
		{"intensity", "intens"},
		{"intent", "intent"},
		{"intention", "intent"},
		{"intentional", "intent"},
		{"intentionally", "intent"},
		{"intentioned", "intent"},
		{"intentions", "intent"},
		{"intently", "intent"},
		{"intents", "intent"},
		{"inter", "inter"},
		{"intercalated", "intercal"},
		{"intercede", "interced"},
		{"intercept", "intercept"},
		{"intercepted", "intercept"},
		{"intercepting", "intercept"},
		{"intercepts", "intercept"},
		{"intercession", "intercess"},
		{"interchange", "interchang"},
		{"interchangeable", "interchang"},
		{"interchanged", "interchang"},
		{"interchanging", "interchang"},
		{"intercourse", "intercours"},
		{"interest", "interest"},
		{"interested", "interest"},
		{"interestin", "interestin"},
		{"interesting", "interest"},
		{"interests", "interest"},
		{"interfere", "interfer"},
		{"interfered", "interf"},
		{"interference", "interfer"},
		{"interferes", "interfer"},
		{"interfering", "interf"},
		{"interior", "interior"},
		{"interjection", "interject"},
		{"interlacings", "interlac"},
		{"interleaved", "interleav"},
		{"interloper", "interlop"},
		{"interlopers", "interlop"},
		{"interlude", "interlud"},
		{"intermarriages", "intermarriag"},
		{"intermeddling", "intermeddl"},
		{"intermediate", "intermedi"},
		{"interminable", "intermin"},
		{"intermingling", "intermingl"},
		{"intermission", "intermiss"},
		{"intermittent", "intermitt"},
		{"internal", "intern"},
		{"internally", "intern"},
		{"international", "intern"},
		{"interpose", "interpos"},
		{"interposed", "interpos"},
		{"interposes", "interpos"},
		{"interposing", "interpos"},
		{"interposition", "interposit"},
		{"interpret", "interpret"},
		{"interpretation", "interpret"},
		{"interpretations", "interpret"},
		{"interpreted", "interpret"},
		{"interpreter", "interpret"},
		{"interrogate", "interrog"},
		{"interrogated", "interrog"},
		{"interrogating", "interrog"},
		{"interrogations", "interrog"},
		{"interrogator", "interrog"},
		{"interrogatories", "interrogatori"},
		{"interrogatory", "interrogatori"},
		{"interrupt", "interrupt"},
		{"interrupted", "interrupt"},
		{"interrupting", "interrupt"},
		{"interruption", "interrupt"},
		{"interruptions", "interrupt"},
		{"interrupts", "interrupt"},
		{"intersect", "intersect"},
		{"intersected", "intersect"},
		{"intersecting", "intersect"},
		{"intersection", "intersect"},
		{"interspersed", "interspers"},
		{"interspersing", "interspers"},
		{"interstices", "interstic"},
		{"interstratified", "interstratifi"},
		{"intertropical", "intertrop"},
		{"intertwined", "intertwin"},
		{"interval", "interv"},
		{"intervals", "interv"},
		{"intervened", "interven"},
		{"intervening", "interven"},
		{"interview", "interview"},
		{"interviews", "interview"},
		{"interwoven", "interwoven"},
		{"intestate", "intest"},
		{"intestinal", "intestin"},
		{"intestines", "intestin"},
		{"intimacy", "intimaci"},
		{"intimate", "intim"},
		{"intimated", "intim"},
		{"intimately", "intim"},
		{"intimates", "intim"},
		{"intimating", "intim"},
		{"intimation", "intim"},
		{"intimidated", "intimid"},
		{"intimidation", "intimid"},
		{"intiv", "intiv"},
		{"into", "into"},
		{"intolerable", "intoler"},
		{"intolerably", "intoler"},
		{"intombed", "intomb"},
		{"intonation", "inton"},
		{"intonations", "inton"},
		{"intoning", "inton"},
		{"intoxicated", "intox"},
		{"intoxicating", "intox"},
		{"intoxication", "intox"},
		{"intractable", "intract"},
		{"intreat", "intreat"},
		{"intrepid", "intrepid"},
		{"intrepidity", "intrepid"},
		{"intricacies", "intricaci"},
		{"intricate", "intric"},
		{"intrigue", "intrigu"},
		{"intrigued", "intrigu"},
		{"intrigues", "intrigu"},
		{"intriguing", "intrigu"},
		{"intrinsic", "intrins"},
		{"introduce", "introduc"},
		{"introduced", "introduc"},
		{"introduces", "introduc"},
		{"introducing", "introduc"},
		{"introduction", "introduct"},
		{"introductions", "introduct"},
		{"introductory", "introductori"},
		{"intrude", "intrud"},
		{"intruded", "intrud"},
		{"intruder", "intrud"},
		{"intrudes", "intrud"},
		{"intruding", "intrud"},
		{"intrusion", "intrus"},
		{"intrusive", "intrus"},
		{"intrust", "intrust"},
		{"intrusted", "intrust"},
		{"intuition", "intuit"},
		{"intuitive", "intuit"},
		{"intwined", "intwin"},
		{"intwining", "intwin"},
		{"inundated", "inund"},
		{"inundations", "inund"},
		{"inured", "inur"},
		{"inutility", "inutil"},
		{"invade", "invad"},
		{"invaded", "invad"},
		{"invaders", "invad"},
		{"invading", "invad"},
		{"invalid", "invalid"},
		{"invalidate", "invalid"},
		{"invalided", "invalid"},
		{"invalids", "invalid"},
		{"invaluable", "invalu"},
		{"invariable", "invari"},
		{"invariably", "invari"},
		{"invasion", "invas"},
		{"invective", "invect"},
		{"invectives", "invect"},
		{"inveighed", "inveigh"},
		{"inveigle", "inveigl"},
		{"inveigled", "inveigl"},
		{"invencion", "invencion"},
		{"invent", "invent"},
		{"invented", "invent"},
		{"inventing", "invent"},
		{"invention", "invent"},
		{"inventions", "invent"},
		{"inventory", "inventori"},
		{"invents", "invent"},
		{"inverness", "inver"},
		{"invertebrate", "invertebr"},
		{"inverted", "invert"},
		{"invest", "invest"},
		{"invested", "invest"},
		{"investigate", "investig"},
		{"investigated", "investig"},
		{"investigating", "investig"},
		{"investigation", "investig"},
		{"investigations", "investig"},
		{"investigators", "investig"},
		{"investment", "invest"},
		{"invests", "invest"},
		{"inveterate", "inveter"},
		{"invigorate", "invigor"},
		{"invigorated", "invigor"},
		{"invigorating", "invigor"},
		{"invigoration", "invigor"},
		{"invincible", "invinc"},
		{"invisible", "invis"},
		{"invisibly", "invis"},
		{"invitation", "invit"},
		{"invitations", "invit"},
		{"invite", "invit"},
		{"invited", "invit"},
		{"invites", "invit"},
		{"inviting", "invit"},
		{"invitingly", "invit"},
		{"invoking", "invok"},
		{"involuntarily", "involuntarili"},
		{"involuntary", "involuntari"},
		{"involutions", "involut"},
		{"involve", "involv"},
		{"involved", "involv"},
		{"involvement", "involv"},
		{"involves", "involv"},
		{"involving", "involv"},
		{"inward", "inward"},
		{"inwardly", "inward"},
		{"inwards", "inward"},
		{"inwentory", "inwentori"},
		{"iodic", "iodic"},
		{"ionic", "ionic"},
		{"iota", "iota"},
		{"iou", "iou"},
		{"iquique", "iquiqu"},
		{"irascibility", "irasc"},
		{"irascible", "irasc"},
		{"irascibly", "irasc"},
		{"irate", "irat"},
		{"ire", "ire"},
		{"ireland", "ireland"},
		{"iridescent", "iridesc"},
		{"iris", "iri"},
		{"irish", "irish"},
		{"irishman", "irishman"},
		{"irishmen", "irishmen"},
		{"irishwoman", "irishwoman"},
		{"irksome", "irksom"},
		{"irksomeness", "irksom"},
		{"iron", "iron"},
		{"ironed", "iron"},
		{"ironical", "iron"},
		{"ironically", "iron"},
		{"ironing", "iron"},
		{"ironmaster", "ironmast"},
		{"ironmasters", "ironmast"},
		{"ironmonger", "ironmong"},
		{"irons", "iron"},
		{"irony", "ironi"},
		{"irradiated", "irradi"},
		{"irrational", "irrat"},
		{"irreclaimable", "irreclaim"},
		{"irreconcilable", "irreconcil"},
		{"irrecoverable", "irrecover"},
		{"irredeemable", "irredeem"},
		{"irrefutable", "irrefut"},
		{"irregular", "irregular"},
		{"irregularities", "irregular"},
		{"irregularity", "irregular"},
		{"irregularly", "irregular"},
		{"irrelevant", "irrelev"},
		{"irrepressible", "irrepress"},
		{"irreproachable", "irreproach"},
		{"irresistible", "irresist"},
		{"irresistibly", "irresist"},
		{"irresolute", "irresolut"},
		{"irresolutely", "irresolut"},
		{"irresolution", "irresolut"},
		{"irrespective", "irrespect"},
		{"irresponsible", "irrespons"},
		{"irresponsive", "irrespons"},
		{"irretrievable", "irretriev"},
		{"irretrievably", "irretriev"},
		{"irreverent", "irrever"},
		{"irreverently", "irrever"},
		{"irrevocable", "irrevoc"},
		{"irrevocably", "irrevoc"},
		{"irrigate", "irrig"},
		{"irrigated", "irrig"},
		{"irrigating", "irrig"},
		{"irrigation", "irrig"},
		{"irritability", "irrit"},
		{"irritable", "irrit"},
		{"irritably", "irrit"},
		{"irritate", "irrit"},
		{"irritated", "irrit"},
		{"irritating", "irrit"},
		{"irritation", "irrit"},
		{"irruption", "irrupt"},
		{"irtish", "irtish"},
		{"is", "is"},
		{"isabel", "isabel"},
		{"isaiah", "isaiah"},
		{"isid", "isid"},
		{"isidro", "isidro"},
		{"island", "island"},
		{"islanders", "island"},
		{"islands", "island"},
		{"isle", "isl"},
		{"isles", "isl"},
		{"islet", "islet"},
		{"islets", "islet"},
		{"islington", "islington"},
		{"isn", "isn"},
		{"isobel", "isobel"},
		{"isolated", "isol"},
		{"isolation", "isol"},
		{"israelites", "israelit"},
		{"issue", "issu"},
		{"issued", "issu"},
		{"issues", "issu"},
		{"issuing", "issu"},
		{"ist", "ist"},
		{"isthmus", "isthmus"},
		{"it", "it"},
		{"italian", "italian"},
		{"italy", "itali"},
		{"itch", "itch"},
		{"itchen", "itchen"},
		{"itching", "itch"},
		{"item", "item"},
		{"items", "item"},
		{"ithacaia", "ithacaia"},
		{"itinerant", "itiner"},
		{"its", "it"},
		{"itself", "itself"},
		{"iv", "iv"},
		{"ivan", "ivan"},
		{"ivanitch", "ivanitch"},
		{"ivanovitch", "ivanovitch"},
		{"ivanovna", "ivanovna"},
		{"ivory", "ivori"},
		{"ivy", "ivi"},
		{"ix", "ix"},
		{"ixion", "ixion"},
		{"j", "j"},
		{"ja", "ja"},
		{"jabbers", "jabber"},
		{"jaca", "jaca"},
		{"jack", "jack"},
		{"jackals", "jackal"},
		{"jackanapes", "jackanap"},
		{"jackas", "jacka"},
		{"jackdaw", "jackdaw"},
		{"jackdaws", "jackdaw"},
		{"jacket", "jacket"},
		{"jackets", "jacket"},
		{"jacks", "jack"},
		{"jackson", "jackson"},
		{"jacob", "jacob"},
		{"jacuitque", "jacuitqu"},
		{"jaculation", "jacul"},
		{"jade", "jade"},
		{"jaded", "jade"},
		{"jading", "jade"},
		{"jag", "jag"},
		{"jagged", "jag"},
		{"jago", "jago"},
		{"jaguar", "jaguar"},
		{"jaguars", "jaguar"},
		{"jail", "jail"},
		{"jailer", "jailer"},
		{"jajuel", "jajuel"},
		{"jam", "jam"},
		{"jamaica", "jamaica"},
		{"james", "jame"},
		{"jammed", "jam"},
		{"jams", "jam"},
		{"jan", "jan"},
		{"jane", "jane"},
		{"janeiro", "janeiro"},
		{"janes", "jane"},
		{"jangled", "jangl"},
		{"jangling", "jangl"},
		{"january", "januari"},
		{"japan", "japan"},
		{"jar", "jar"},
		{"jargon", "jargon"},
		{"jargonelle", "jargonell"},
		{"jarnders", "jarnder"},
		{"jarndyce", "jarndyc"},
		{"jarndyces", "jarndyc"},
		{"jarodyce", "jarodyc"},
		{"jarring", "jar"},
		{"jasmine", "jasmin"},
		{"jaundice", "jaundic"},
		{"jaundiced", "jaundic"},
		{"jaunt", "jaunt"},
		{"jauntily", "jauntili"},
		{"jauntiness", "jaunti"},
		{"jaunty", "jaunti"},
		{"java", "java"},
		{"javelin", "javelin"},
		{"jaw", "jaw"},
		{"jawed", "jaw"},
		{"jawlly", "jawlli"},
		{"jaws", "jaw"},
		{"je", "je"},
		{"jea", "jea"},
		{"jealous", "jealous"},
		{"jealousies", "jealousi"},
		{"jealously", "jealous"},
		{"jealousy", "jealousi"},
		{"jean", "jean"},
		{"jeanie", "jeani"},
		{"jeer", "jeer"},
		{"jeered", "jeer"},
		{"jeering", "jeer"},
		{"jeeringly", "jeer"},
		{"jeers", "jeer"},
		{"jell", "jell"},
		{"jelly", "jelli"},
		{"jellyby", "jellybi"},
		{"jellybys", "jellybi"},
		{"jemmy", "jemmi"},
		{"jenkins", "jenkin"},
		{"jennings", "jen"},
		{"jenny", "jenni"},
		{"jennys", "jenni"},
		{"jenyns", "jenyn"},
		{"jeopardy", "jeopardi"},
		{"jeremy", "jeremi"},
		{"jericho", "jericho"},
		{"jerk", "jerk"},
		{"jerked", "jerk"},
		{"jerkily", "jerkili"},
		{"jerking", "jerk"},
		{"jerks", "jerk"},
		{"jerky", "jerki"},
		{"jerry", "jerri"},
		{"jerusalem", "jerusalem"},
		{"jest", "jest"},
		{"jesting", "jest"},
		{"jestingly", "jest"},
		{"jests", "jest"},
		{"jesuit", "jesuit"},
		{"jesuitical", "jesuit"},
		{"jesus", "jesus"},
		{"jet", "jet"},
		{"jets", "jet"},
		{"jew", "jew"},
		{"jewby", "jewbi"},
		{"jewel", "jewel"},
		{"jeweler", "jewel"},
		{"jewelled", "jewel"},
		{"jeweller", "jewel"},
		{"jewellers", "jewel"},
		{"jewellery", "jewelleri"},
		{"jewels", "jewel"},
		{"jewess", "jewess"},
		{"jewish", "jewish"},
		{"jews", "jew"},
		{"jezebel", "jezebel"},
		{"jilted", "jilt"},
		{"jingle", "jingl"},
		{"jingled", "jingl"},
		{"jingles", "jingl"},
		{"jingling", "jingl"},
		{"jist", "jist"},
		{"jo", "jo"},
		{"joan", "joan"},
		{"joanna", "joanna"},
		{"job", "job"},
		{"jobbed", "job"},
		{"jobling", "jobl"},
		{"jobs", "job"},
		{"jockey", "jockey"},
		{"jocose", "jocos"},
		{"jocosely", "jocos"},
		{"jocoseness", "jocos"},
		{"jocular", "jocular"},
		{"jocularity", "jocular"},
		{"jocularly", "jocular"},
		{"jocundity", "jocund"},
		{"joe", "joe"},
		{"joful", "joful"},
		{"jog", "jog"},
		{"jogg", "jogg"},
		{"jogged", "jog"},
		{"jogging", "jog"},
		{"johann", "johann"},
		{"john", "john"},
		{"johnnie", "johnni"},
		{"johnny", "johnni"},
		{"johnson", "johnson"},
		{"join", "join"},
		{"joined", "join"},
		{"joinin", "joinin"},
		{"joining", "join"},
		{"joins", "join"},
		{"joint", "joint"},
		{"jointly", "joint"},
		{"joints", "joint"},
		{"joke", "joke"},
		{"joked", "joke"},
		{"joker", "joker"},
		{"jokers", "joker"},
		{"jokes", "joke"},
		{"joking", "joke"},
		{"jolliest", "jolliest"},
		{"jollity", "jolliti"},
		{"jolly", "jolli"},
		{"jolquera", "jolquera"},
		{"jolt", "jolt"},
		{"jolted", "jolt"},
		{"jolter", "jolter"},
		{"jolting", "jolt"},
		{"jolts", "jolt"},
		{"jones", "jone"},
		{"joneses", "jones"},
		{"joodle", "joodl"},
		{"jordan", "jordan"},
		{"jorullo", "jorullo"},
		{"jose", "jose"},
		{"joseph", "joseph"},
		{"joshua", "joshua"},
		{"jostle", "jostl"},
		{"jostled", "jostl"},
		{"jostling", "jostl"},
		{"jot", "jot"},
		{"jour", "jour"},
		{"journ", "journ"},
		{"journal", "journal"},
		{"journalist", "journalist"},
		{"journalistic", "journalist"},
		{"journals", "journal"},
		{"journey", "journey"},
		{"journeyed", "journey"},
		{"journeying", "journey"},
		{"journeyings", "journey"},
		{"journeyman", "journeyman"},
		{"journeys", "journey"},
		{"jove", "jove"},
		{"jovial", "jovial"},
		{"joviality", "jovial"},
		{"jowl", "jowl"},
		{"joy", "joy"},
		{"joyed", "joy"},
		{"joyful", "joy"},
		{"joyfully", "joy"},
		{"joyous", "joyous"},
		{"joyously", "joyous"},
		{"joyousness", "joyous"},
		{"joys", "joy"},
		{"juan", "juan"},
		{"judah", "judah"},
		{"judge", "judg"},
		{"judged", "judg"},
		{"judgement", "judgement"},
		{"judges", "judg"},
		{"judging", "judg"},
		{"judgment", "judgment"},
		{"judgments", "judgment"},
		{"judicial", "judici"},
		{"judicious", "judici"},
		{"judiciously", "judici"},
		{"judith", "judith"},
		{"judy", "judi"},
		{"juffy", "juffi"},
		{"jug", "jug"},
		{"juggle", "juggl"},
		{"juggled", "juggl"},
		{"juggler", "juggler"},
		{"jugglery", "juggleri"},
		{"jugs", "jug"},
		{"jugular", "jugular"},
		{"juice", "juic"},
		{"juices", "juic"},
		{"juicy", "juici"},
		{"juillet", "juillet"},
		{"julia", "julia"},
		{"julian", "julian"},
		{"juliet", "juliet"},
		{"julius", "julius"},
		{"july", "juli"},
		{"jumble", "jumbl"},
		{"jumbled", "jumbl"},
		{"jumbling", "jumbl"},
		{"jump", "jump"},
		{"jumped", "jump"},
		{"jumping", "jump"},
		{"jumps", "jump"},
		{"junction", "junction"},
		{"juncture", "junctur"},
		{"juncus", "juncus"},
		{"june", "june"},
		{"jungle", "jungl"},
		{"jungles", "jungl"},
		{"junior", "junior"},
		{"juniorest", "juniorest"},
		{"juniors", "junior"},
		{"junk", "junk"},
		{"jupiter", "jupit"},
		{"jura", "jura"},
		{"juries", "juri"},
		{"jurisprudence", "jurisprud"},
		{"juror", "juror"},
		{"jurors", "juror"},
		{"jury", "juri"},
		{"juryman", "juryman"},
		{"jurymen", "jurymen"},
		{"just", "just"},
		{"juster", "juster"},
		{"justest", "justest"},
		{"justice", "justic"},
		{"justifiable", "justifi"},
		{"justification", "justif"},
		{"justifications", "justif"},
		{"justified", "justifi"},
		{"justifies", "justifi"},
		{"justify", "justifi"},
		{"justifying", "justifi"},
		{"justitia", "justitia"},
		{"justly", "just"},
		{"jute", "jute"},
		{"juvenile", "juvenil"},
		{"juxtaposition", "juxtaposit"},
		{"k", "k"},
		{"kalydor", "kalydor"},
		{"kammerjunker", "kammerjunk"},
		{"kampfes", "kampf"},
		{"kamtschatka", "kamtschatka"},
		{"kangaroo", "kangaroo"},
		{"kapernaumov", "kapernaumov"},
		{"kapernaumovs", "kapernaumov"},
		{"karl", "karl"},
		{"karros", "karro"},
		{"kate", "kate"},
		{"kater", "kater"},
		{"katerina", "katerina"},
		{"katharina", "katharina"},
		{"katia", "katia"},
		{"kattymaly", "kattymali"},
		{"kauri", "kauri"},
		{"kazan", "kazan"},
		{"keane", "kean"},
		{"keating", "keat"},
		{"keeling", "keel"},
		{"keen", "keen"},
		{"keener", "keener"},
		{"keenest", "keenest"},
		{"keenly", "keen"},
		{"keenness", "keen"},
		{"keep", "keep"},
		{"keeper", "keeper"},
		{"keepers", "keeper"},
		{"keeping", "keep"},
		{"keeps", "keep"},
		{"keepsake", "keepsak"},
		{"keepsakes", "keepsak"},
		{"keine", "kein"},
		{"kelp", "kelp"},
		{"ken", "ken"},
		{"kendall", "kendal"},
		{"kenge", "keng"},
		{"kennel", "kennel"},
		{"kennels", "kennel"},
		{"kennington", "kennington"},
		{"kensington", "kensington"},
		{"kent", "kent"},
		{"kentish", "kentish"},
		{"kenwigs", "kenwig"},
		{"kenwigses", "kenwigs"},
		{"kepler", "kepler"},
		{"kept", "kept"},
		{"kerchief", "kerchief"},
		{"kerguelen", "kerguelen"},
		{"kernel", "kernel"},
		{"kerr", "kerr"},
		{"kerrig", "kerrig"},
		{"kettle", "kettl"},
		{"kettles", "kettl"},
		{"key", "key"},
		{"keyhole", "keyhol"},
		{"keyholes", "keyhol"},
		{"keyne", "keyn"},
		{"keys", "key"},
		{"khan", "khan"},
		{"kick", "kick"},
		{"kicked", "kick"},
		{"kicking", "kick"},
		{"kicks", "kick"},
		{"kid", "kid"},
		{"kidnapped", "kidnap"},
		{"kidnapper", "kidnapp"},
		{"kidnapping", "kidnap"},
		{"kidney", "kidney"},
		{"kilda", "kilda"},
		{"kill", "kill"},
		{"killed", "kill"},
		{"killer", "killer"},
		{"killing", "kill"},
		{"kills", "kill"},
		{"kiln", "kiln"},
		{"kilns", "kiln"},
		{"kilt", "kilt"},
		{"kimbo", "kimbo"},
		{"kimiri", "kimiri"},
		{"kimpelled", "kimpel"},
		{"kin", "kin"},
		{"kind", "kind"},
		{"kinder", "kinder"},
		{"kindest", "kindest"},
		{"kindhearted", "kindheart"},
		{"kindle", "kindl"},
		{"kindled", "kindl"},
		{"kindles", "kindl"},
		{"kindlier", "kindlier"},
		{"kindliest", "kindliest"},
		{"kindliness", "kindli"},
		{"kindling", "kindl"},
		{"kindly", "kind"},
		{"kindness", "kind"},
		{"kindnesses", "kind"},
		{"kindred", "kindr"},
		{"kinds", "kind"},
		{"king", "king"},
		{"kingdom", "kingdom"},
		{"kingdoms", "kingdom"},
		{"kingfisher", "kingfish"},
		{"kingly", "king"},
		{"kings", "king"},
		{"kingston", "kingston"},
		{"kinkajou", "kinkajou"},
		{"kinsman", "kinsman"},
		{"kirby", "kirbi"},
		{"kiss", "kiss"},
		{"kissed", "kiss"},
		{"kisses", "kiss"},
		{"kissing", "kiss"},
		{"kit", "kit"},
		{"kitchen", "kitchen"},
		{"kitchens", "kitchen"},
		{"kitchin", "kitchin"},
		{"kite", "kite"},
		{"kitten", "kitten"},
		{"kittlitz", "kittlitz"},
		{"kitty", "kitti"},
		{"klopstock", "klopstock"},
		{"knack", "knack"},
		{"knackeries", "knackeri"},
		{"knacks", "knack"},
		{"knag", "knag"},
		{"knave", "knave"},
		{"knaves", "knave"},
		{"knavish", "knavish"},
		{"kneaded", "knead"},
		{"kneading", "knead"},
		{"knee", "knee"},
		{"kneel", "kneel"},
		{"kneeled", "kneel"},
		{"kneeling", "kneel"},
		{"kneels", "kneel"},
		{"knees", "knee"},
		{"knell", "knell"},
		{"knelt", "knelt"},
		{"knew", "knew"},
		{"knick", "knick"},
		{"knif", "knif"},
		{"knife", "knife"},
		{"knight", "knight"},
		{"knightly", "knight"},
		{"knights", "knight"},
		{"knit", "knit"},
		{"knits", "knit"},
		{"knitted", "knit"},
		{"knitting", "knit"},
		{"knives", "knive"},
		{"knob", "knob"},
		{"knobs", "knob"},
		{"knock", "knock"},
		{"knocked", "knock"},
		{"knocker", "knocker"},
		{"knockers", "knocker"},
		{"knocking", "knock"},
		{"knocks", "knock"},
		{"knopp", "knopp"},
		{"knot", "knot"},
		{"knots", "knot"},
		{"knotted", "knot"},
		{"knotty", "knotti"},
		{"know", "know"},
		{"knowa", "knowa"},
		{"knowd", "knowd"},
		{"knowed", "know"},
		{"knowest", "knowest"},
		{"knoweth", "knoweth"},
		{"knowin", "knowin"},
		{"knowing", "know"},
		{"knowledg", "knowledg"},
		{"knowledge", "knowledg"},
		{"known", "known"},
		{"knows", "know"},
		{"knuckle", "knuckl"},
		{"knuckleboy", "knuckleboy"},
		{"knuckles", "knuckl"},
		{"kobelev", "kobelev"},
		{"kobilatnikov", "kobilatnikov"},
		{"koch", "koch"},
		{"koeldwethout", "koeldwethout"},
		{"kolomensky", "kolomenski"},
		{"kolya", "kolya"},
		{"kong", "kong"},
		{"konig", "konig"},
		{"koodle", "koodl"},
		{"kororadika", "kororadika"},
		{"kotzebue", "kotzebu"},
		{"kozel", "kozel"},
		{"krestovsky", "krestovski"},
		{"kriegsrath", "kriegsrath"},
		{"krook", "krook"},
		{"kryukov", "kryukov"},
		{"kuffy", "kuffi"},
		{"l", "l"},
		{"la", "la"},
		{"label", "label"},
		{"labelled", "label"},
		{"labillardiere", "labillardier"},
		{"laborious", "labori"},
		{"laboriously", "labori"},
		{"labour", "labour"},
		{"laboured", "labour"},
		{"labourer", "labour"},
		{"labourers", "labour"},
		{"labouring", "labour"},
		{"labourious", "labouri"},
		{"labours", "labour"},
		{"laburnum", "laburnum"},
		{"labyrinth", "labyrinth"},
		{"labyrinths", "labyrinth"},
		{"lace", "lace"},
		{"laced", "lace"},
		{"lacerate", "lacer"},
		{"lacerta", "lacerta"},
		{"laches", "lach"},
		{"lachrymatories", "lachrymatori"},
		{"lachrymose", "lachrymos"},
		{"lacing", "lace"},
		{"lack", "lack"},
		{"lackadaisical", "lackadais"},
		{"lacked", "lack"},
		{"lacking", "lack"},
		{"lacks", "lack"},
		{"laconic", "lacon"},
		{"lacquered", "lacquer"},
		{"lad", "lad"},
		{"ladder", "ladder"},
		{"ladders", "ladder"},
		{"lade", "lade"},
		{"laden", "laden"},
		{"laderas", "ladera"},
		{"ladies", "ladi"},
		{"ladle", "ladl"},
		{"lads", "lad"},
		{"lady", "ladi"},
		{"ladyhood", "ladyhood"},
		{"ladylike", "ladylik"},
		{"ladyship", "ladyship"},
		{"lag", "lag"},
		{"laggard", "laggard"},
		{"lagged", "lag"},
		{"lagging", "lag"},
		{"lagoa", "lagoa"},
		{"lagoon", "lagoon"},
		{"lagoons", "lagoon"},
		{"lagostomus", "lagostomus"},
		{"lags", "lag"},
		{"laguna", "laguna"},
		{"laid", "laid"},
		{"lain", "lain"},
		{"lair", "lair"},
		{"laissez", "laissez"},
		{"laity", "laiti"},
		{"lajdak", "lajdak"},
		{"lake", "lake"},
		{"lakes", "lake"},
		{"lalegraicavalca", "lalegraicavalca"},
		{"lall", "lall"},
		{"lalla", "lalla"},
		{"lama", "lama"},
		{"lamarck", "lamarck"},
		{"lamb", "lamb"},
		{"lambert", "lambert"},
		{"lambeth", "lambeth"},
		{"lambs", "lamb"},
		{"lame", "lame"},
		{"lamed", "lame"},
		{"lamellicorn", "lamellicorn"},
		{"lameness", "lame"},
		{"lament", "lament"},
		{"lamentable", "lament"},
		{"lamentably", "lament"},
		{"lamentation", "lament"},
		{"lamentations", "lament"},
		{"lamented", "lament"},
		{"lamenting", "lament"},
		{"laments", "lament"},
		{"laminae", "lamina"},
		{"lamp", "lamp"},
		{"lamplight", "lamplight"},
		{"lamplighter", "lamplight"},
		{"lamps", "lamp"},
		{"lampyridae", "lampyrida"},
		{"lampyris", "lampyri"},
		{"lancashire", "lancashir"},
		{"lancaster", "lancast"},
		{"lance", "lanc"},
		{"lancerated", "lancer"},
		{"land", "land"},
		{"landed", "land"},
		{"landing", "land"},
		{"landings", "land"},
		{"landlady", "landladi"},
		{"landlord", "landlord"},
		{"landmark", "landmark"},
		{"landmarks", "landmark"},
		{"landowner", "landown"},
		{"landowners", "landown"},
		{"lands", "land"},
		{"landscape", "landscap"},
		{"landseer", "landseer"},
		{"landsman", "landsman"},
		{"lane", "lane"},
		{"lanes", "lane"},
		{"langsdorff", "langsdorff"},
		{"language", "languag"},
		{"languages", "languag"},
		{"languid", "languid"},
		{"languidly", "languid"},
		{"languish", "languish"},
		{"languished", "languish"},
		{"languishing", "languish"},
		{"languor", "languor"},
		{"langwedge", "langwedg"},
		{"lank", "lank"},
		{"lanky", "lanki"},
		{"lantern", "lantern"},
		{"lanterns", "lantern"},
		{"lap", "lap"},
		{"lapel", "lapel"},
		{"lappel", "lappel"},
		{"laps", "lap"},
		{"lapse", "laps"},
		{"lapsed", "laps"},
		{"lapses", "laps"},
		{"lapsing", "laps"},
		{"lar", "lar"},
		{"larcenerer", "larcener"},
		{"larch", "larch"},
		{"larg", "larg"},
		{"large", "larg"},
		{"largely", "larg"},
		{"largeness", "larg"},
		{"larger", "larger"},
		{"largest", "largest"},
		{"lark", "lark"},
		{"larking", "lark"},
		{"larks", "lark"},
		{"larming", "larm"},
		{"larry", "larri"},
		{"larvae", "larva"},
		{"las", "las"},
		{"lash", "lash"},
		{"lashed", "lash"},
		{"lashes", "lash"},
		{"lashing", "lash"},
		{"lass", "lass"},
		{"lassie", "lassi"},
		{"lassitude", "lassitud"},
		{"lassoit", "lassoit"},
		{"lassonthwaite", "lassonthwait"},
		{"lassonthwayte", "lassonthwayt"},
		{"last", "last"},
		{"lasted", "last"},
		{"lasting", "last"},
		{"lastly", "last"},
		{"lasts", "last"},
		{"lat", "lat"},
		{"latch", "latch"},
		{"latched", "latch"},
		{"late", "late"},
		{"latel", "latel"},
		{"lately", "late"},
		{"lateness", "late"},
		{"latent", "latent"},
		{"later", "later"},
		{"lateral", "later"},
		{"laterally", "later"},
		{"latest", "latest"},
		{"lath", "lath"},
		{"lathered", "lather"},
		{"latin", "latin"},
		{"latinity", "latin"},
		{"latitude", "latitud"},
		{"latitudes", "latitud"},
		{"latreille", "latreill"},
		{"latro", "latro"},
		{"latte", "latt"},
		{"latter", "latter"},
		{"latterly", "latter"},
		{"latther", "latther"},
		{"latthers", "latther"},
		{"lattice", "lattic"},
		{"latticed", "lattic"},
		{"lattle", "lattl"},
		{"laud", "laud"},
		{"laudable", "laudabl"},
		{"laudamus", "laudamus"},
		{"laudation", "laudat"},
		{"laudatory", "laudatori"},
		{"lauded", "laud"},
		{"laugh", "laugh"},
		{"laughable", "laughabl"},
		{"laughed", "laugh"},
		{"laughing", "laugh"},
		{"laughingly", "laugh"},
		{"laughs", "laugh"},
		{"laughter", "laughter"},
		{"launch", "launch"},
		{"launched", "launch"},
		{"launching", "launch"},
		{"laundry", "laundri"},
		{"laura", "laura"},
		{"laurance", "lauranc"},
		{"laurel", "laurel"},
		{"laurels", "laurel"},
		{"laurence", "laurenc"},
		{"lauzun", "lauzun"},
		{"lav", "lav"},
		{"lava", "lava"},
		{"laval", "laval"},
		{"lavas", "lava"},
		{"lavender", "lavend"},
		{"lavish", "lavish"},
		{"lavished", "lavish"},
		{"lavishly", "lavish"},
		{"law", "law"},
		{"lawful", "law"},
		{"lawgiver", "lawgiv"},
		{"lawk", "lawk"},
		{"lawn", "lawn"},
		{"lawns", "lawn"},
		{"lawrence", "lawrenc"},
		{"laws", "law"},
		{"lawson", "lawson"},
		{"lawstationers", "lawstation"},
		{"lawsuit", "lawsuit"},
		{"lawver", "lawver"},
		{"lawyer", "lawyer"},
		{"lawyers", "lawyer"},
		{"lax", "lax"},
		{"laxity", "laxiti"},
		{"lay", "lay"},
		{"layer", "layer"},
		{"layers", "layer"},
		{"layin", "layin"},
		{"laying", "lay"},
		{"laylec", "laylec"},
		{"lays", "lay"},
		{"layton", "layton"},
		{"laz", "laz"},
		{"lazarus", "lazarus"},
		{"lazily", "lazili"},
		{"laziness", "lazi"},
		{"lazo", "lazo"},
		{"lazoed", "lazo"},
		{"lazos", "lazo"},
		{"lazy", "lazi"},
		{"lazzeretto", "lazzeretto"},
		{"le", "le"},
		{"lead", "lead"},
		{"leaden", "leaden"},
		{"leadenhall", "leadenhal"},
		{"leader", "leader"},
		{"leaders", "leader"},
		{"leadership", "leadership"},
		{"leading", "lead"},
		{"leads", "lead"},
		{"leaf", "leaf"},
		{"leafed", "leaf"},
		{"leafless", "leafless"},
		{"leafy", "leafi"},
		{"league", "leagu"},
		{"leagued", "leagu"},
		{"leagues", "leagu"},
		{"leaked", "leak"},
		{"lean", "lean"},
		{"leaned", "lean"},
		{"leaning", "lean"},
		{"leanness", "lean"},
		{"leans", "lean"},
		{"leant", "leant"},
		{"leap", "leap"},
		{"leaped", "leap"},
		{"leaper", "leaper"},
		{"leaping", "leap"},
		{"leapings", "leap"},
		{"leapt", "leapt"},
		{"lear", "lear"},
		{"learn", "learn"},
		{"learned", "learn"},
		{"learners", "learner"},
		{"learning", "learn"},
		{"learns", "learn"},
		{"learnt", "learnt"},
		{"lease", "leas"},
		{"leases", "leas"},
		{"least", "least"},
		{"leastways", "leastway"},
		{"leather", "leather"},
		{"leathern", "leathern"},
		{"leave", "leav"},
		{"leaves", "leav"},
		{"leaving", "leav"},
		{"lebanon", "lebanon"},
		{"leben", "leben"},
		{"lebeziatnikov", "lebeziatnikov"},
		{"lecherousness", "lecher"},
		{"lecture", "lectur"},
		{"lectured", "lectur"},
		{"lecturer", "lectur"},
		{"lectures", "lectur"},
		{"lecturing", "lectur"},
		{"led", "led"},
		{"ledge", "ledg"},
		{"ledger", "ledger"},
		{"ledgers", "ledger"},
		{"ledges", "ledg"},
		{"ledrook", "ledrook"},
		{"leech", "leech"},
		{"leek", "leek"},
		{"leer", "leer"},
		{"leered", "leer"},
		{"leering", "leer"},
		{"leetle", "leetl"},
		{"leeuwin", "leeuwin"},
		{"leeward", "leeward"},
		{"left", "left"},
		{"leg", "leg"},
		{"legacy", "legaci"},
		{"legal", "legal"},
		{"legality", "legal"},
		{"legally", "legal"},
		{"legatee", "legate"},
		{"legatees", "legate"},
		{"legend", "legend"},
		{"legendary", "legendari"},
		{"legends", "legend"},
		{"legged", "leg"},
		{"leggings", "leg"},
		{"legh", "legh"},
		{"legibility", "legibl"},
		{"legible", "legibl"},
		{"legibly", "legibl"},
		{"legion", "legion"},
		{"legislation", "legisl"},
		{"legislative", "legisl"},
		{"legislator", "legisl"},
		{"legislators", "legisl"},
		{"legislature", "legislatur"},
		{"legitimacy", "legitimaci"},
		{"legitimate", "legitim"},
		{"legs", "leg"},
		{"leguminosae", "leguminosa"},
		{"leicester", "leicest"},
		{"leicestershire", "leicestershir"},
		{"leighton", "leighton"},
		{"leisure", "leisur"},
		{"leisurely", "leisur"},
		{"lemen", "lemen"},
		{"lemon", "lemon"},
		{"lemonade", "lemonad"},
		{"lemons", "lemon"},
		{"lemuel", "lemuel"},
		{"lemuy", "lemuy"},
		{"len", "len"},
		{"lend", "lend"},
		{"lender", "lender"},
		{"lenders", "lender"},
		{"lending", "lend"},
		{"lends", "lend"},
		{"length", "length"},
		{"lengthen", "lengthen"},
		{"lengthened", "lengthen"},
		{"lengths", "length"},
		{"lengthy", "lengthi"},
		{"lenient", "lenient"},
		{"leniently", "lenient"},
		{"lenning", "len"},
		{"lenou", "lenou"},
		{"lens", "len"},
		{"lent", "lent"},
		{"lentils", "lentil"},
		{"lenville", "lenvill"},
		{"leone", "leon"},
		{"leoneros", "leonero"},
		{"leoville", "leovill"},
		{"lepidoptera", "lepidoptera"},
		{"lepus", "lepus"},
		{"les", "les"},
		{"leslie", "lesli"},
		{"less", "less"},
		{"lessen", "lessen"},
		{"lessened", "lessen"},
		{"lessening", "lessen"},
		{"lesser", "lesser"},
		{"lesson", "lesson"},
		{"lessons", "lesson"},
		{"lest", "lest"},
		{"let", "let"},
		{"lethargic", "letharg"},
		{"lethargy", "lethargi"},
		{"lethe", "leth"},
		{"lets", "let"},
		{"lett", "lett"},
		{"letter", "letter"},
		{"letters", "letter"},
		{"letting", "let"},
		{"lettres", "lettr"},
		{"lettuce", "lettuc"},
		{"lettuces", "lettuc"},
		{"leurs", "leur"},
		{"levanted", "levant"},
		{"leve", "leve"},
		{"levees", "leve"},
		{"level", "level"},
		{"levelle", "levell"},
		{"levelled", "level"},
		{"levelling", "level"},
		{"levels", "level"},
		{"levers", "lever"},
		{"levities", "leviti"},
		{"levity", "leviti"},
		{"lewes", "lew"},
		{"lewis", "lewi"},
		{"li", "li"},
		{"liabilities", "liabil"},
		{"liability", "liabil"},
		{"liable", "liabl"},
		{"liana", "liana"},
		{"liar", "liar"},
		{"libation", "libat"},
		{"libel", "libel"},
		{"liberal", "liber"},
		{"liberalism", "liber"},
		{"liberality", "liber"},
		{"liberally", "liber"},
		{"liberals", "liber"},
		{"liberate", "liber"},
		{"liberated", "liber"},
		{"liberates", "liber"},
		{"liberties", "liberti"},
		{"libertine", "libertin"},
		{"libertines", "libertin"},
		{"liberty", "liberti"},
		{"librarian", "librarian"},
		{"libraries", "librari"},
		{"library", "librari"},
		{"lice", "lice"},
		{"licence", "licenc"},
		{"licences", "licenc"},
		{"license", "licens"},
		{"licensed", "licens"},
		{"licenses", "licens"},
		{"licentious", "licenti"},
		{"licentiousness", "licenti"},
		{"lichen", "lichen"},
		{"lichens", "lichen"},
		{"lichtenstein", "lichtenstein"},
		{"licked", "lick"},
		{"licking", "lick"},
		{"lid", "lid"},
		{"lida", "lida"},
		{"lids", "lid"},
		{"lie", "lie"},
		{"liebig", "liebig"},
		{"lied", "lie"},
		{"lies", "lie"},
		{"liesk", "liesk"},
		{"lieu", "lieu"},
		{"lieut", "lieut"},
		{"lieutenancies", "lieuten"},
		{"lieutenant", "lieuten"},
		{"lieutenants", "lieuten"},
		{"life", "life"},
		{"lifeless", "lifeless"},
		{"lifetime", "lifetim"},
		{"lift", "lift"},
		{"lifted", "lift"},
		{"lifting", "lift"},
		{"lifts", "lift"},
		{"ligament", "ligament"},
		{"ligaments", "ligament"},
		{"ligh", "ligh"},
		{"light", "light"},
		{"lighted", "light"},
		{"lighten", "lighten"},
		{"lightened", "lighten"},
		{"lightening", "lighten"},
		{"lightens", "lighten"},
		{"lighter", "lighter"},
		{"lightest", "lightest"},
		{"lightheaded", "lighthead"},
		{"lighthearted", "lightheart"},
		{"lighthouse", "lighthous"},
		{"lighthouses", "lighthous"},
		{"lighting", "light"},
		{"lightly", "light"},
		{"lightness", "light"},
		{"lightning", "lightn"},
		{"lights", "light"},
		{"lightsome", "lightsom"},
		{"lignite", "lignit"},
		{"lignum", "lignum"},
		{"lii", "lii"},
		{"liii", "liii"},
		{"lik", "lik"},
		{"like", "like"},
		{"liked", "like"},
		{"likelier", "likeli"},
		{"likelihood", "likelihood"},
		{"likely", "like"},
		{"likened", "liken"},
		{"likeness", "like"},
		{"likenesses", "like"},
		{"likes", "like"},
		{"likewise", "likewis"},
		{"liking", "like"},
		{"likings", "like"},
		{"lilac", "lilac"},
		{"lilaceous", "lilac"},
		{"lilacs", "lilac"},
		{"liliaceous", "liliac"},
		{"lilies", "lili"},
		{"lilliput", "lilliput"},
		{"lillyvick", "lillyvick"},
		{"lillyvicks", "lillyvick"},
		{"lily", "lili"},
		{"lima", "lima"},
		{"limache", "limach"},
		{"limb", "limb"},
		{"limbs", "limb"},
		{"lime", "lime"},
		{"limes", "lime"},
		{"limestone", "limeston"},
		{"limit", "limit"},
		{"limited", "limit"},
		{"limiting", "limit"},
		{"limits", "limit"},
		{"limnaea", "limnaea"},
		{"limp", "limp"},
		{"limped", "limp"},
		{"limpet", "limpet"},
		{"limpid", "limpid"},
		{"limping", "limp"},
		{"lin", "lin"},
		{"lincoln", "lincoln"},
		{"lincolnshire", "lincolnshir"},
		{"line", "line"},
		{"linea", "linea"},
		{"lineage", "lineag"},
		{"lineament", "lineament"},
		{"lineaments", "lineament"},
		{"linear", "linear"},
		{"lined", "line"},
		{"linen", "linen"},
		{"linendraper", "linendrap"},
		{"lines", "line"},
		{"linger", "linger"},
		{"lingered", "linger"},
		{"lingering", "linger"},
		{"lingerings", "linger"},
		{"lingers", "linger"},
		{"linguist", "linguist"},
		{"lining", "line"},
		{"linings", "line"},
		{"link", "link"},
		{"linked", "link"},
		{"linking", "link"},
		{"linkinwater", "linkinwat"},
		{"links", "link"},
		{"linn", "linn"},
		{"linnaean", "linnaean"},
		{"linnean", "linnean"},
		{"linnets", "linnet"},
		{"lintels", "lintel"},
		{"lion", "lion"},
		{"lioness", "lioness"},
		{"lions", "lion"},
		{"lip", "lip"},
		{"lippevechsel", "lippevechsel"},
		{"lipping", "lip"},
		{"lips", "lip"},
		{"liquid", "liquid"},
		{"liquidating", "liquid"},
		{"liquor", "liquor"},
		{"liquorish", "liquorish"},
		{"liquors", "liquor"},
		{"lisbon", "lisbon"},
		{"lisp", "lisp"},
		{"list", "list"},
		{"listed", "list"},
		{"listen", "listen"},
		{"listened", "listen"},
		{"listener", "listen"},
		{"listeners", "listen"},
		{"listening", "listen"},
		{"listenings", "listen"},
		{"listens", "listen"},
		{"listless", "listless"},
		{"listlessly", "listless"},
		{"listlessness", "listless"},
		{"lists", "list"},
		{"lit", "lit"},
		{"litany", "litani"},
		{"literal", "liter"},
		{"literally", "liter"},
		{"literary", "literari"},
		{"literature", "literatur"},
		{"lithe", "lith"},
		{"lithographic", "lithograph"},
		{"litigation", "litig"},
		{"litigious", "litigi"},
		{"litter", "litter"},
		{"littered", "litter"},
		{"littering", "litter"},
		{"littl", "littl"},
		{"little", "littl"},
		{"littleness", "littl"},
		{"littlenesses", "littl"},
		{"littlest", "littlest"},
		{"littoral", "littor"},
		{"liv", "liv"},
		{"live", "live"},
		{"lived", "live"},
		{"livelier", "liveli"},
		{"liveliest", "liveliest"},
		{"livelihood", "livelihood"},
		{"liveliness", "liveli"},
		{"livelong", "livelong"},
		{"lively", "live"},
		{"liver", "liver"},
		{"liveried", "liveri"},
		{"liveries", "liveri"},
		{"liverpool", "liverpool"},
		{"livers", "liver"},
		{"livery", "liveri"},
		{"lives", "live"},
		{"livest", "livest"},
		{"liveth", "liveth"},
		{"livid", "livid"},
		{"living", "live"},
		{"livingstone", "livingston"},
		{"lix", "lix"},
		{"liz", "liz"},
		{"lizard", "lizard"},
		{"lizards", "lizard"},
		{"lizaveta", "lizaveta"},
		{"lizzie", "lizzi"},
		{"lizzy", "lizzi"},
		{"ll", "ll"},
		{"llama", "llama"},
		{"llandaff", "llandaff"},
		{"llanos", "llano"},
		{"lloyd", "lloyd"},
		{"llth", "llth"},
		{"lmmediately", "lmmediat"},
		{"lo", "lo"},
		{"load", "load"},
		{"loaded", "load"},
		{"loading", "load"},
		{"loads", "load"},
		{"loaf", "loaf"},
		{"loam", "loam"},
		{"loan", "loan"},
		{"loans", "loan"},
		{"loath", "loath"},
		{"loathe", "loath"},
		{"loathed", "loath"},
		{"loathing", "loath"},
		{"loathsome", "loathsom"},
		{"loathsomeness", "loathsom"},
		{"loaves", "loav"},
		{"lobbies", "lobbi"},
		{"lobby", "lobbi"},
		{"lobster", "lobster"},
		{"lobsters", "lobster"},
		{"local", "local"},
		{"locality", "local"},
		{"locations", "locat"},
		{"lochness", "loch"},
		{"lock", "lock"},
		{"locked", "lock"},
		{"locket", "locket"},
		{"locking", "lock"},
		{"lockouts", "lockout"},
		{"locks", "lock"},
		{"locksmiths", "locksmith"},
		{"lockyer", "lockyer"},
		{"locock", "locock"},
		{"lococks", "locock"},
		{"locomotion", "locomot"},
		{"locomotive", "locomot"},
		{"locomotives", "locomot"},
		{"locust", "locust"},
		{"locusts", "locust"},
		{"lod", "lod"},
		{"lodge", "lodg"},
		{"lodged", "lodg"},
		{"lodger", "lodger"},
		{"lodgers", "lodger"},
		{"lodges", "lodg"},
		{"lodging", "lodg"},
		{"lodgings", "lodg"},
		{"loft", "loft"},
		{"loftiest", "loftiest"},
		{"loftily", "loftili"},
		{"loftiness", "lofti"},
		{"lofty", "lofti"},
		{"log", "log"},
		{"loggerheaded", "loggerhead"},
		{"loggerheads", "loggerhead"},
		{"logic", "logic"},
		{"logical", "logic"},
		{"logically", "logic"},
		{"logs", "log"},
		{"loight", "loight"},
		{"loike", "loik"},
		{"loikewise", "loikewis"},
		{"loins", "loin"},
		{"loiter", "loiter"},
		{"loitered", "loiter"},
		{"loiterer", "loiter"},
		{"loiterers", "loiter"},
		{"loitering", "loiter"},
		{"loix", "loix"},
		{"loll", "loll"},
		{"lolling", "loll"},
		{"lombard", "lombard"},
		{"lombardic", "lombard"},
		{"lon", "lon"},
		{"lond", "lond"},
		{"london", "london"},
		{"lone", "lone"},
		{"lonelier", "loneli"},
		{"loneliness", "loneli"},
		{"lonely", "lone"},
		{"lonesome", "lonesom"},
		{"long", "long"},
		{"longbarns", "longbarn"},
		{"longed", "long"},
		{"longer", "longer"},
		{"longest", "longest"},
		{"longevity", "longev"},
		{"longing", "long"},
		{"longings", "long"},
		{"longitude", "longitud"},
		{"longitudinal", "longitudin"},
		{"longitudinally", "longitudin"},
		{"longs", "long"},
		{"longwood", "longwood"},
		{"loo", "loo"},
		{"looder", "looder"},
		{"loodgin", "loodgin"},
		{"loodle", "loodl"},
		{"look", "look"},
		{"looked", "look"},
		{"lookee", "looke"},
		{"looker", "looker"},
		{"lookers", "looker"},
		{"looking", "look"},
		{"looks", "look"},
		{"lookye", "looky"},
		{"loom", "loom"},
		{"loomed", "loom"},
		{"looming", "loom"},
		{"looms", "loom"},
		{"loonching", "loonch"},
		{"loone", "loon"},
		{"loop", "loop"},
		{"loopholes", "loophol"},
		{"loose", "loos"},
		{"loosed", "loos"},
		{"loosely", "loos"},
		{"loosen", "loosen"},
		{"loosened", "loosen"},
		{"looseness", "loos"},
		{"loosening", "loosen"},
		{"looser", "looser"},
		{"loosing", "loos"},
		{"loov", "loov"},
		{"lop", "lop"},
		{"lopez", "lopez"},
		{"lopezes", "lopez"},
		{"lopezites", "lopezit"},
		{"lopped", "lop"},
		{"loppings", "lop"},
		{"loquacious", "loquaci"},
		{"lor", "lor"},
		{"lord", "lord"},
		{"lordlings", "lordl"},
		{"lordly", "lord"},
		{"lords", "lord"},
		{"lordship", "lordship"},
		{"lordships", "lordship"},
		{"lorenzo", "lorenzo"},
		{"los", "los"},
		{"lose", "lose"},
		{"loser", "loser"},
		{"losers", "loser"},
		{"loses", "lose"},
		{"losing", "lose"},
		{"loss", "loss"},
		{"losses", "loss"},
		{"lost", "lost"},
		{"lot", "lot"},
		{"lothbury", "lothburi"},
		{"lots", "lot"},
		{"lottery", "lotteri"},
		{"loud", "loud"},
		{"louder", "louder"},
		{"loudest", "loudest"},
		{"loudly", "loud"},
		{"loudness", "loud"},
		{"louis", "loui"},
		{"louisa", "louisa"},
		{"lounge", "loung"},
		{"lounged", "loung"},
		{"lounger", "lounger"},
		{"loungers", "lounger"},
		{"lounges", "loung"},
		{"lounging", "loung"},
		{"lous", "lous"},
		{"louse", "lous"},
		{"louvain", "louvain"},
		{"lovable", "lovabl"},
		{"love", "love"},
		{"loveable", "loveabl"},
		{"loved", "love"},
		{"lovelier", "loveli"},
		{"loveliest", "loveliest"},
		{"loveliness", "loveli"},
		{"lovely", "love"},
		{"lover", "lover"},
		{"lovers", "lover"},
		{"loves", "love"},
		{"loving", "love"},
		{"lovingly", "love"},
		{"lovingness", "loving"},
		{"low", "low"},
		{"lower", "lower"},
		{"lowered", "lower"},
		{"lowering", "lower"},
		{"lowers", "lower"},
		{"lowest", "lowest"},
		{"lowland", "lowland"},
		{"lowliest", "lowliest"},
		{"lowliness", "lowli"},
		{"lowly", "lowli"},
		{"lowness", "low"},
		{"loyal", "loyal"},
		{"loyalty", "loyalti"},
		{"lozenge", "lozeng"},
		{"lozenges", "lozeng"},
		{"lt", "lt"},
		{"lubricates", "lubric"},
		{"lucanee", "lucane"},
		{"lucia", "lucia"},
		{"luciano", "luciano"},
		{"lucid", "lucid"},
		{"lucidly", "lucid"},
		{"lucifer", "lucif"},
		{"lucifers", "lucif"},
		{"luck", "luck"},
		{"luckiest", "luckiest"},
		{"luckily", "luckili"},
		{"luckless", "luckless"},
		{"lucky", "lucki"},
		{"lucrative", "lucrat"},
		{"lucre", "lucr"},
		{"lucy", "luci"},
		{"lud", "lud"},
		{"ludgate", "ludgat"},
		{"ludicrous", "ludicr"},
		{"ludicrously", "ludicr"},
		{"ludship", "ludship"},
		{"ludwigovna", "ludwigovna"},
		{"luffy", "luffi"},
		{"luggage", "luggag"},
		{"lugged", "lug"},
		{"lui", "lui"},
		{"luis", "lui"},
		{"luise", "luis"},
		{"lukewarm", "lukewarm"},
		{"lukin", "lukin"},
		{"lull", "lull"},
		{"lullaby", "lullabi"},
		{"lulled", "lull"},
		{"lulling", "lull"},
		{"lulls", "lull"},
		{"lumb", "lumb"},
		{"lumbagers", "lumbag"},
		{"lumber", "lumber"},
		{"lumbering", "lumber"},
		{"lumbey", "lumbey"},
		{"luminary", "luminari"},
		{"luminosus", "luminosus"},
		{"luminous", "lumin"},
		{"lumley", "lumley"},
		{"lump", "lump"},
		{"lumpkin", "lumpkin"},
		{"lumps", "lump"},
		{"lumpy", "lumpi"},
		{"lunacy", "lunaci"},
		{"lunatic", "lunat"},
		{"lunch", "lunch"},
		{"luncheon", "luncheon"},
		{"lunches", "lunch"},
		{"lund", "lund"},
		{"lunge", "lung"},
		{"lungs", "lung"},
		{"lunnun", "lunnun"},
		{"lupton", "lupton"},
		{"lurch", "lurch"},
		{"lurched", "lurch"},
		{"lure", "lure"},
		{"lured", "lure"},
		{"lures", "lure"},
		{"lurid", "lurid"},
		{"luring", "lure"},
		{"lurk", "lurk"},
		{"lurked", "lurk"},
		{"lurking", "lurk"},
		{"luscious", "luscious"},
		{"lustfahrt", "lustfahrt"},
		{"lustier", "lustier"},
		{"lustily", "lustili"},
		{"lustre", "lustr"},
		{"lustreless", "lustreless"},
		{"lustrous", "lustrous"},
		{"lusts", "lust"},
		{"lusty", "lusti"},
		{"lute", "lute"},
		{"luxan", "luxan"},
		{"luxuriance", "luxuri"},
		{"luxuriant", "luxuri"},
		{"luxuriantly", "luxuri"},
		{"luxuriate", "luxuri"},
		{"luxuriating", "luxuri"},
		{"luxuries", "luxuri"},
		{"luxurious", "luxuri"},
		{"luxuriously", "luxuri"},
		{"luxury", "luxuri"},
		{"luzhin", "luzhin"},
		{"lv", "lv"},
		{"lvi", "lvi"},
		{"lvii", "lvii"},
		{"lviii", "lviii"},
		{"lx", "lx"},
		{"lxi", "lxi"},
		{"lxii", "lxii"},
		{"lxiii", "lxiii"},
		{"lxiv", "lxiv"},
		{"lxv", "lxv"},
		{"lxvi", "lxvi"},
		{"lxvii", "lxvii"},
		{"ly", "ly"},
		{"lycosa", "lycosa"},
		{"lycurgus", "lycurgus"},
		{"lyell", "lyell"},
		{"lying", "lie"},
		{"lymington", "lymington"},
		{"lymph", "lymph"},
		{"lynne", "lynn"},
		{"lynx", "lynx"},
		{"lyra", "lyra"},
		{"lyre", "lyre"},
		{"lyres", "lyre"},
		{"m", "m"},
		{"ma", "ma"},
		{"macadam", "macadam"},
		{"macae", "maca"},
		{"macbeth", "macbeth"},
		{"maccoort", "maccoort"},
		{"maccoorts", "maccoort"},
		{"macculloch", "macculloch"},
		{"mace", "mace"},
		{"maces", "mace"},
		{"macfuzlem", "macfuzlem"},
		{"macgregor", "macgregor"},
		{"machina", "machina"},
		{"machine", "machin"},
		{"machinery", "machineri"},
		{"mack", "mack"},
		{"mackenzie", "mackenzi"},
		{"maclaren", "maclaren"},
		{"macpherson", "macpherson"},
		{"macphersons", "macpherson"},
		{"macquarie", "macquari"},
		{"macquarrie", "macquarri"},
		{"macrauchenia", "macrauchenia"},
		{"macrocystis", "macrocysti"},
		{"mactrae", "mactra"},
		{"maculata", "maculata"},
		{"mad", "mad"},
		{"madagascar", "madagascar"},
		{"madam", "madam"},
		{"madame", "madam"},
		{"madcaps", "madcap"},
		{"madchen", "madchen"},
		{"madden", "madden"},
		{"maddened", "madden"},
		{"maddening", "madden"},
		{"madder", "madder"},
		{"maddest", "maddest"},
		{"made", "made"},
		{"madeira", "madeira"},
		{"madeline", "madelin"},
		{"mademoiselle", "mademoisell"},
		{"madhouse", "madhous"},
		{"madly", "mad"},
		{"madman", "madman"},
		{"madmen", "madmen"},
		{"madness", "mad"},
		{"madonna", "madonna"},
		{"madras", "madra"},
		{"madre", "madr"},
		{"madrid", "madrid"},
		{"madrina", "madrina"},
		{"madrinas", "madrina"},
		{"madwoman", "madwoman"},
		{"mag", "mag"},
		{"magalonyx", "magalonyx"},
		{"magazine", "magazin"},
		{"magazines", "magazin"},
		{"magdalen", "magdalen"},
		{"magellan", "magellan"},
		{"magellanica", "magellanica"},
		{"magellanicus", "magellanicus"},
		{"maggot", "maggot"},
		{"maggots", "maggot"},
		{"magic", "magic"},
		{"magical", "magic"},
		{"magically", "magic"},
		{"magician", "magician"},
		{"magistrate", "magistr"},
		{"magistrates", "magistr"},
		{"magnanimity", "magnanim"},
		{"magnanimous", "magnanim"},
		{"magnanimously", "magnanim"},
		{"magnate", "magnat"},
		{"magnates", "magnat"},
		{"magnesium", "magnesium"},
		{"magnetic", "magnet"},
		{"magnetized", "magnet"},
		{"magnificence", "magnific"},
		{"magnificent", "magnific"},
		{"magnificently", "magnific"},
		{"magnified", "magnifi"},
		{"magnifies", "magnifi"},
		{"magnify", "magnifi"},
		{"magnifying", "magnifi"},
		{"magnirostris", "magnirostri"},
		{"magnitude", "magnitud"},
		{"magnum", "magnum"},
		{"magog", "magog"},
		{"magpie", "magpi"},
		{"magpies", "magpi"},
		{"mahdoo", "mahdoo"},
		{"mahlos", "mahlo"},
		{"mahogany", "mahogani"},
		{"mahomedan", "mahomedan"},
		{"mahomet", "mahomet"},
		{"mahony", "mahoni"},
		{"mai", "mai"},
		{"maid", "maid"},
		{"maiden", "maiden"},
		{"maidenly", "maiden"},
		{"maidens", "maiden"},
		{"maidish", "maidish"},
		{"maids", "maid"},
		{"maidservants", "maidserv"},
		{"mail", "mail"},
		{"maim", "maim"},
		{"maimed", "maim"},
		{"main", "main"},
		{"mainland", "mainland"},
		{"mainly", "main"},
		{"mainspring", "mainspr"},
		{"mainstay", "mainstay"},
		{"maintain", "maintain"},
		{"maintained", "maintain"},
		{"maintaining", "maintain"},
		{"maintenance", "mainten"},
		{"maire", "mair"},
		{"maitre", "maitr"},
		{"majestic", "majest"},
		{"majestically", "majest"},
		{"majesty", "majesti"},
		{"major", "major"},
		{"majorities", "major"},
		{"majority", "major"},
		{"mak", "mak"},
		{"make", "make"},
		{"maker", "maker"},
		{"makers", "maker"},
		{"makes", "make"},
		{"making", "make"},
		{"maktng", "maktng"},
		{"mal", "mal"},
		{"malacca", "malacca"},
		{"malady", "maladi"},
		{"malaria", "malaria"},
		{"malay", "malay"},
		{"malaya", "malaya"},
		{"malays", "malay"},
		{"malcolmson", "malcolmson"},
		{"malcontents", "malcont"},
		{"maldiva", "maldiva"},
		{"maldonado", "maldonado"},
		{"male", "male"},
		{"malediction", "maledict"},
		{"maledictions", "maledict"},
		{"malefactors", "malefactor"},
		{"males", "male"},
		{"malevolent", "malevol"},
		{"malgre", "malgr"},
		{"malice", "malic"},
		{"malicious", "malici"},
		{"maliciously", "malici"},
		{"malignance", "malign"},
		{"malignant", "malign"},
		{"malignantly", "malign"},
		{"maligned", "malign"},
		{"malignity", "malign"},
		{"mall", "mall"},
		{"malleable", "malleabl"},
		{"mallowford", "mallowford"},
		{"malouines", "malouin"},
		{"malt", "malt"},
		{"malta", "malta"},
		{"malte", "malt"},
		{"maltreatment", "maltreat"},
		{"malty", "malti"},
		{"mama", "mama"},
		{"mamas", "mama"},
		{"mameluke", "mameluk"},
		{"mamma", "mamma"},
		{"mammalia", "mammalia"},
		{"mammals", "mammal"},
		{"mammiferous", "mammifer"},
		{"mammifers", "mammif"},
		{"mammillated", "mammil"},
		{"mammon", "mammon"},
		{"mammy", "mammi"},
		{"man", "man"},
		{"manage", "manag"},
		{"manageable", "manag"},
		{"managed", "manag"},
		{"management", "manag"},
		{"manager", "manag"},
		{"manageress", "manageress"},
		{"managers", "manag"},
		{"manages", "manag"},
		{"managing", "manag"},
		{"manatee", "manate"},
		{"manchester", "manchest"},
		{"mandate", "mandat"},
		{"mandetiba", "mandetiba"},
		{"mandibl", "mandibl"},
		{"mandible", "mandibl"},
		{"mandioca", "mandioca"},
		{"mane", "mane"},
		{"manes", "mane"},
		{"manful", "man"},
		{"manfully", "man"},
		{"manganese", "manganes"},
		{"manger", "manger"},
		{"mangering", "manger"},
		{"mangle", "mangl"},
		{"mangles", "mangl"},
		{"mangling", "mangl"},
		{"mango", "mango"},
		{"mangostin", "mangostin"},
		{"mangot", "mangot"},
		{"mangroves", "mangrov"},
		{"mangy", "mangi"},
		{"manhood", "manhood"},
		{"mania", "mania"},
		{"maniac", "maniac"},
		{"maniacs", "maniac"},
		{"manie", "mani"},
		{"manifest", "manifest"},
		{"manifestation", "manifest"},
		{"manifestations", "manifest"},
		{"manifested", "manifest"},
		{"manifesting", "manifest"},
		{"manifestly", "manifest"},
		{"manifests", "manifest"},
		{"manifold", "manifold"},
		{"manipulated", "manipul"},
		{"manipulation", "manipul"},
		{"mankind", "mankind"},
		{"manliness", "manli"},
		{"manly", "man"},
		{"manne", "mann"},
		{"manned", "man"},
		{"manner", "manner"},
		{"mannered", "manner"},
		{"manners", "manner"},
		{"mannish", "mannish"},
		{"manoeuvre", "manoeuvr"},
		{"manoeuvred", "manoeuvr"},
		{"manoeuvres", "manoeuvr"},
		{"manoeuvring", "manoeuvr"},
		{"manor", "manor"},
		{"mansion", "mansion"},
		{"mansions", "mansion"},
		{"manslaughtering", "manslaught"},
		{"mansos", "manso"},
		{"mantalini", "mantalini"},
		{"mantel", "mantel"},
		{"mantelpiece", "mantelpiec"},
		{"mantelshelf", "mantelshelf"},
		{"mantie", "manti"},
		{"mantle", "mantl"},
		{"mantled", "mantl"},
		{"mantles", "mantl"},
		{"mantling", "mantl"},
		{"manual", "manual"},
		{"manuals", "manual"},
		{"manuel", "manuel"},
		{"manufactories", "manufactori"},
		{"manufactory", "manufactori"},
		{"manufacture", "manufactur"},
		{"manufactured", "manufactur"},
		{"manufacturers", "manufactur"},
		{"manufacturing", "manufactur"},
		{"manure", "manur"},
		{"manured", "manur"},
		{"manuring", "manur"},
		{"manuscript", "manuscript"},
		{"manuscripts", "manuscript"},
		{"many", "mani"},
		{"map", "map"},
		{"mapped", "map"},
		{"maps", "map"},
		{"mar", "mar"},
		{"marbl", "marbl"},
		{"marble", "marbl"},
		{"marbles", "marbl"},
		{"march", "march"},
		{"marchantiae", "marchantia"},
		{"marched", "march"},
		{"marches", "march"},
		{"marching", "march"},
		{"mare", "mare"},
		{"mares", "mare"},
		{"marfa", "marfa"},
		{"margate", "margat"},
		{"marge", "marg"},
		{"margin", "margin"},
		{"marginal", "margin"},
		{"margins", "margin"},
		{"mari", "mari"},
		{"maria", "maria"},
		{"mariano", "mariano"},
		{"marica", "marica"},
		{"marie", "mari"},
		{"marine", "marin"},
		{"mariners", "marin"},
		{"marines", "marin"},
		{"marital", "marit"},
		{"maritime", "maritim"},
		{"mark", "mark"},
		{"marked", "mark"},
		{"marker", "marker"},
		{"market", "market"},
		{"marketing", "market"},
		{"marketplace", "marketplac"},
		{"markets", "market"},
		{"marking", "mark"},
		{"marks", "mark"},
		{"marl", "marl"},
		{"marlborough", "marlborough"},
		{"marly", "mar"},
		{"marmalade", "marmalad"},
		{"marmeladov", "marmeladov"},
		{"marmeladovs", "marmeladov"},
		{"marquess", "marquess"},
		{"marquis", "marqui"},
		{"marquises", "marquis"},
		{"marred", "mar"},
		{"marriage", "marriag"},
		{"marriages", "marriag"},
		{"married", "marri"},
		{"marries", "marri"},
		{"marring", "mar"},
		{"marrow", "marrow"},
		{"marrows", "marrow"},
		{"marry", "marri"},
		{"marrying", "marri"},
		{"mars", "mar"},
		{"marsden", "marsden"},
		{"marseilles", "marseill"},
		{"marsh", "marsh"},
		{"marshal", "marshal"},
		{"marshalled", "marshal"},
		{"marshes", "marsh"},
		{"marshy", "marshi"},
		{"marstone", "marston"},
		{"marstones", "marston"},
		{"marsupial", "marsupi"},
		{"mart", "mart"},
		{"martens", "marten"},
		{"martha", "martha"},
		{"martial", "martial"},
		{"martin", "martin"},
		{"martindale", "martindal"},
		{"martindales", "martindal"},
		{"martins", "martin"},
		{"martlets", "martlet"},
		{"martyr", "martyr"},
		{"martyrdom", "martyrdom"},
		{"marvel", "marvel"},
		{"marvelled", "marvel"},
		{"marvelling", "marvel"},
		{"marvellous", "marvel"},
		{"marvellously", "marvel"},
		{"marvels", "marvel"},
		{"mary", "mari"},
		{"marylebone", "marylebon"},
		{"marys", "mari"},
		{"mascariensis", "mascariensi"},
		{"masculine", "masculin"},
		{"mashes", "mash"},
		{"mask", "mask"},
		{"masonry", "masonri"},
		{"masquerading", "masquerad"},
		{"mass", "mass"},
		{"massacre", "massacr"},
		{"massacred", "massacr"},
		{"massacres", "massacr"},
		{"masse", "mass"},
		{"masses", "mass"},
		{"massive", "massiv"},
		{"massively", "massiv"},
		{"mast", "mast"},
		{"mastadon", "mastadon"},
		{"masted", "mast"},
		{"master", "master"},
		{"mastered", "master"},
		{"masterful", "master"},
		{"mastering", "master"},
		{"masterly", "master"},
		{"masterpieces", "masterpiec"},
		{"masters", "master"},
		{"mastery", "masteri"},
		{"masthead", "masthead"},
		{"mastiff", "mastiff"},
		{"mastodon", "mastodon"},
		{"mastodons", "mastodon"},
		{"masts", "mast"},
		{"mat", "mat"},
		{"mata", "mata"},
		{"mataco", "mataco"},
		{"matador", "matador"},
		{"matavai", "matavai"},
		{"match", "match"},
		{"matched", "match"},
		{"matches", "match"},
		{"matching", "match"},
		{"mate", "mate"},
		{"material", "materi"},
		{"materially", "materi"},
		{"materials", "materi"},
		{"maternal", "matern"},
		{"mates", "mate"},
		{"mathematical", "mathemat"},
		{"mathematically", "mathemat"},
		{"mathematics", "mathemat"},
		{"matilda", "matilda"},
		{"matins", "matin"},
		{"matlock", "matlock"},
		{"matricide", "matricid"},
		{"matrimonial", "matrimoni"},
		{"matrimonially", "matrimoni"},
		{"matrimony", "matrimoni"},
		{"matrix", "matrix"},
		{"matron", "matron"},
		{"matronly", "matron"},
		{"matrons", "matron"},
		{"mats", "mat"},
		{"matted", "mat"},
		{"matter", "matter"},
		{"mattered", "matter"},
		{"matters", "matter"},
		{"matther", "matther"},
		{"matthew", "matthew"},
		{"matthews", "matthew"},
		{"matting", "mat"},
		{"mattress", "mattress"},
		{"mattresses", "mattress"},
		{"mature", "matur"},
		{"matured", "matur"},
		{"maturely", "matur"},
		{"maturer", "matur"},
		{"maturity", "matur"},
		{"matutina", "matutina"},
		{"matvey", "matvey"},
		{"maun", "maun"},
		{"maunder", "maunder"},
		{"maurice", "mauric"},
		{"mauritius", "mauritius"},
		{"maurua", "maurua"},
		{"mausoleum", "mausoleum"},
		{"mausoleums", "mausoleum"},
		{"mauvais", "mauvai"},
		{"mawkish", "mawkish"},
		{"maxillae", "maxilla"},
		{"maxim", "maxim"},
		{"may", "may"},
		{"maybe", "mayb"},
		{"maydickle", "maydickl"},
		{"mayfair", "mayfair"},
		{"mayhap", "mayhap"},
		{"mayn", "mayn"},
		{"mayo", "mayo"},
		{"mayor", "mayor"},
		{"maypu", "maypu"},
		{"mayst", "mayst"},
		{"maze", "maze"},
		{"mazeppa", "mazeppa"},
		{"mazes", "maze"},
		{"mazurka", "mazurka"},
		{"mazy", "mazi"},
		{"me", "me"},
		{"meadow", "meadow"},
		{"meadows", "meadow"},
		{"meads", "mead"},
		{"meagre", "meagr"},
		{"meal", "meal"},
		{"meals", "meal"},
		{"mean", "mean"},
		{"meandering", "meander"},
		{"meanest", "meanest"},
		{"meaning", "mean"},
		{"meaningless", "meaningless"},
		{"meanings", "mean"},
		{"meanly", "mean"},
		{"meanness", "mean"},
		{"means", "mean"},
		{"meant", "meant"},
		{"meantime", "meantim"},
		{"meanwhile", "meanwhil"},
		{"measles", "measl"},
		{"measther", "measther"},
		{"measthers", "measther"},
		{"measure", "measur"},
		{"measured", "measur"},
		{"measurement", "measur"},
		{"measurements", "measur"},
		{"measurer", "measur"},
		{"measures", "measur"},
		{"measuring", "measur"},
		{"meat", "meat"},
		{"meats", "meat"},
		{"mechanic", "mechan"},
		{"mechanical", "mechan"},
		{"mechanically", "mechan"},
		{"mechanics", "mechan"},
		{"mechanism", "mechan"},
		{"mecum", "mecum"},
		{"medal", "medal"},
		{"medallions", "medallion"},
		{"meddle", "meddl"},
		{"meddled", "meddl"},
		{"meddlers", "meddler"},
		{"meddlesome", "meddlesom"},
		{"meddling", "meddl"},
		{"mediaeval", "mediaev"},
		{"mediate", "mediat"},
		{"mediation", "mediat"},
		{"mediator", "mediat"},
		{"medical", "medic"},
		{"medicinal", "medicin"},
		{"medicine", "medicin"},
		{"medicines", "medicin"},
		{"mediocrity", "mediocr"},
		{"meditate", "medit"},
		{"meditated", "medit"},
		{"meditates", "medit"},
		{"meditating", "medit"},
		{"meditation", "medit"},
		{"meditations", "medit"},
		{"meditative", "medit"},
		{"meditatively", "medit"},
		{"mediterranean", "mediterranean"},
		{"medium", "medium"},
		{"medley", "medley"},
		{"medusae", "medusa"},
		{"meek", "meek"},
		{"meekest", "meekest"},
		{"meekly", "meek"},
		{"meekness", "meek"},
		{"meet", "meet"},
		{"meeting", "meet"},
		{"meetings", "meet"},
		{"meets", "meet"},
		{"megalonyx", "megalonyx"},
		{"megalosaurus", "megalosaurus"},
		{"megapodius", "megapodius"},
		{"megatherium", "megatherium"},
		{"megatheroid", "megatheroid"},
		{"mehr", "mehr"},
		{"melancholy", "melancholi"},
		{"melanops", "melanop"},
		{"melanotis", "melanoti"},
		{"melasoma", "melasoma"},
		{"melchisedech", "melchisedech"},
		{"melindres", "melindr"},
		{"mell", "mell"},
		{"mellifluousness", "melliflu"},
		{"mellow", "mellow"},
		{"mellowed", "mellow"},
		{"mellows", "mellow"},
		{"melodious", "melodi"},
		{"melodiously", "melodi"},
		{"melodrama", "melodrama"},
		{"melodramatic", "melodramat"},
		{"melody", "melodi"},
		{"melolonthidae", "melolonthida"},
		{"melons", "melon"},
		{"melt", "melt"},
		{"melted", "melt"},
		{"melteth", "melteth"},
		{"melting", "melt"},
		{"melts", "melt"},
		{"melvilleson", "melvilleson"},
		{"mem", "mem"},
		{"member", "member"},
		{"members", "member"},
		{"membrane", "membran"},
		{"membranous", "membran"},
		{"mememto", "mememto"},
		{"memoir", "memoir"},
		{"memoirs", "memoir"},
		{"memorable", "memor"},
		{"memoranda", "memoranda"},
		{"memorandum", "memorandum"},
		{"memorial", "memori"},
		{"memorials", "memori"},
		{"memories", "memori"},
		{"memory", "memori"},
		{"men", "men"},
		{"menace", "menac"},
		{"menacing", "menac"},
		{"menage", "menag"},
		{"menchicoff", "menchicoff"},
		{"mend", "mend"},
		{"mended", "mend"},
		{"mending", "mend"},
		{"mendoza", "mendoza"},
		{"mendozinos", "mendozino"},
		{"mends", "mend"},
		{"menfion", "menfion"},
		{"menfioning", "menfion"},
		{"mental", "mental"},
		{"mentally", "mental"},
		{"mention", "mention"},
		{"mentioned", "mention"},
		{"mentioning", "mention"},
		{"mentions", "mention"},
		{"mentor", "mentor"},
		{"mercantile", "mercantil"},
		{"mercedes", "merced"},
		{"mercenary", "mercenari"},
		{"mercers", "mercer"},
		{"merchandise", "merchandis"},
		{"merchant", "merchant"},
		{"merchants", "merchant"},
		{"mercie", "merci"},
		{"mercies", "merci"},
		{"merciful", "merci"},
		{"mercifully", "merci"},
		{"merciless", "merciless"},
		{"mercilessly", "merciless"},
		{"mercuries", "mercuri"},
		{"mercury", "mercuri"},
		{"mercy", "merci"},
		{"mere", "mere"},
		{"merely", "mere"},
		{"merest", "merest"},
		{"merged", "merg"},
		{"merging", "merg"},
		{"merid", "merid"},
		{"meridian", "meridian"},
		{"merit", "merit"},
		{"merited", "merit"},
		{"meritorious", "meritori"},
		{"meritoriously", "meritori"},
		{"merits", "merit"},
		{"mermaid", "mermaid"},
		{"mero", "mero"},
		{"merrier", "merrier"},
		{"merriest", "merriest"},
		{"merrily", "merrili"},
		{"merriment", "merriment"},
		{"merry", "merri"},
		{"merveille", "merveill"},
		{"mervyn", "mervyn"},
		{"mesalliance", "mesalli"},
		{"mesh", "mesh"},
		{"meshes", "mesh"},
		{"mesmerism", "mesmer"},
		{"mess", "mess"},
		{"message", "messag"},
		{"messages", "messag"},
		{"messenger", "messeng"},
		{"messengers", "messeng"},
		{"messes", "mess"},
		{"messiah", "messiah"},
		{"messrs", "messr"},
		{"met", "met"},
		{"metal", "metal"},
		{"metallic", "metal"},
		{"metalliferous", "metallifer"},
		{"metals", "metal"},
		{"metamorphic", "metamorph"},
		{"metamorphosed", "metamorphos"},
		{"metaphorically", "metaphor"},
		{"metaphysical", "metaphys"},
		{"metaphysics", "metaphys"},
		{"meteor", "meteor"},
		{"meteorological", "meteorolog"},
		{"meteors", "meteor"},
		{"method", "method"},
		{"methodical", "method"},
		{"methodically", "method"},
		{"methodist", "methodist"},
		{"methods", "method"},
		{"methoozellers", "methoozel"},
		{"methuselah", "methuselah"},
		{"metropolis", "metropoli"},
		{"metropolitan", "metropolitan"},
		{"mettle", "mettl"},
		{"mew", "mew"},
		{"mewlinn", "mewlinn"},
		{"mewlinnwillinwodd", "mewlinnwillinwodd"},
		{"mews", "mew"},
		{"mexican", "mexican"},
		{"mexico", "mexico"},
		{"mezzotinto", "mezzotinto"},
		{"miasma", "miasma"},
		{"mica", "mica"},
		{"micaceous", "micac"},
		{"mice", "mice"},
		{"michael", "michael"},
		{"michaelmas", "michaelma"},
		{"michell", "michel"},
		{"mickle", "mickl"},
		{"microbes", "microb"},
		{"microscope", "microscop"},
		{"microscopic", "microscop"},
		{"microscopical", "microscop"},
		{"mid", "mid"},
		{"midday", "midday"},
		{"middl", "middl"},
		{"middle", "middl"},
		{"middlesex", "middlesex"},
		{"middleton", "middleton"},
		{"middling", "middl"},
		{"midnight", "midnight"},
		{"midshipmen", "midshipmen"},
		{"midst", "midst"},
		{"midsummer", "midsumm"},
		{"midway", "midway"},
		{"midwives", "midwiv"},
		{"mien", "mien"},
		{"miers", "mier"},
		{"might", "might"},
		{"mightier", "mightier"},
		{"mightily", "mightili"},
		{"mightn", "mightn"},
		{"mighty", "mighti"},
		{"mignonette", "mignonett"},
		{"migrate", "migrat"},
		{"migrated", "migrat"},
		{"migrates", "migrat"},
		{"migrating", "migrat"},
		{"migration", "migrat"},
		{"migrations", "migrat"},
		{"migratorius", "migratorius"},
		{"migratory", "migratori"},
		{"mihail", "mihail"},
		{"mihailovitch", "mihailovitch"},
		{"mihailovsky", "mihailovski"},
		{"mikolka", "mikolka"},
		{"milch", "milch"},
		{"mild", "mild"},
		{"milder", "milder"},
		{"mildest", "mildest"},
		{"mildewed", "mildew"},
		{"mildly", "mild"},
		{"mildmay", "mildmay"},
		{"mildness", "mild"},
		{"mile", "mile"},
		{"miles", "mile"},
		{"milestone", "mileston"},
		{"milestones", "mileston"},
		{"military", "militari"},
		{"militia", "militia"},
		{"milk", "milk"},
		{"milked", "milk"},
		{"milking", "milk"},
		{"milkmaid", "milkmaid"},
		{"milkman", "milkman"},
		{"milkpot", "milkpot"},
		{"milksop", "milksop"},
		{"milky", "milki"},
		{"mill", "mill"},
		{"millennium", "millennium"},
		{"millenniums", "millennium"},
		{"millepois", "millepoi"},
		{"millepora", "millepora"},
		{"miller", "miller"},
		{"milleypoise", "milleypois"},
		{"milliner", "millin"},
		{"milliners", "millin"},
		{"millinery", "millineri"},
		{"milling", "mill"},
		{"million", "million"},
		{"millionaire", "millionair"},
		{"millions", "million"},
		{"millionth", "millionth"},
		{"mills", "mill"},
		{"millstone", "millston"},
		{"milton", "milton"},
		{"mimicking", "mimick"},
		{"mimicry", "mimicri"},
		{"mimics", "mimic"},
		{"mimosa", "mimosa"},
		{"mimosae", "mimosa"},
		{"mimosas", "mimosa"},
		{"mimus", "mimus"},
		{"minaret", "minaret"},
		{"minas", "mina"},
		{"mince", "minc"},
		{"minced", "minc"},
		{"mincefenille", "mincefenill"},
		{"mincing", "minc"},
		{"mincingly", "minc"},
		{"mind", "mind"},
		{"minded", "mind"},
		{"mindedly", "mind"},
		{"mindedness", "minded"},
		{"mindful", "mind"},
		{"minding", "mind"},
		{"minds", "mind"},
		{"mine", "mine"},
		{"miner", "miner"},
		{"mineral", "miner"},
		{"mineralogical", "mineralog"},
		{"miners", "miner"},
		{"minerva", "minerva"},
		{"mines", "mine"},
		{"mingle", "mingl"},
		{"mingled", "mingl"},
		{"mingles", "mingl"},
		{"mingling", "mingl"},
		{"miniature", "miniatur"},
		{"miniatures", "miniatur"},
		{"minimum", "minimum"},
		{"mining", "mine"},
		{"minions", "minion"},
		{"minister", "minist"},
		{"ministered", "minist"},
		{"ministerial", "ministeri"},
		{"ministerialist", "ministerialist"},
		{"ministers", "minist"},
		{"ministership", "ministership"},
		{"ministration", "ministr"},
		{"ministrations", "ministr"},
		{"ministress", "ministress"},
		{"ministries", "ministri"},
		{"ministry", "ministri"},
		{"minnit", "minnit"},
		{"minor", "minor"},
		{"minorities", "minor"},
		{"minority", "minor"},
		{"minster", "minster"},
		{"minstrel", "minstrel"},
		{"mint", "mint"},
		{"minute", "minut"},
		{"minutely", "minut"},
		{"minuteness", "minut"},
		{"minutes", "minut"},
		{"minutest", "minutest"},
		{"minutus", "minutus"},
		{"minx", "minx"},
		{"miracle", "miracl"},
		{"miraculous", "miracul"},
		{"mirage", "mirag"},
		{"miranda", "miranda"},
		{"mire", "mire"},
		{"mirror", "mirror"},
		{"mirrored", "mirror"},
		{"mirrors", "mirror"},
		{"mirth", "mirth"},
		{"mirthful", "mirth"},
		{"mirthfulness", "mirth"},
		{"miry", "miri"},
		{"misanthrope", "misanthrop"},
		{"misanthropical", "misanthrop"},
		{"misapprehend", "misapprehend"},
		{"misapprehended", "misapprehend"},
		{"misbehave", "misbehav"},
		{"misbehaved", "misbehav"},
		{"misbehaving", "misbehav"},
		{"misbestowed", "misbestow"},
		{"miscalculated", "miscalcul"},
		{"miscalculation", "miscalcul"},
		{"miscalled", "miscal"},
		{"miscarried", "miscarri"},
		{"miscellaneous", "miscellan"},
		{"mischance", "mischanc"},
		{"mischances", "mischanc"},
		{"mischeevious", "mischeevi"},
		{"mischief", "mischief"},
		{"mischievous", "mischiev"},
		{"misconception", "misconcept"},
		{"misconduct", "misconduct"},
		{"misconstruction", "misconstruct"},
		{"misconstructions", "misconstruct"},
		{"misconstrued", "misconstru"},
		{"misconstruing", "misconstru"},
		{"miscreant", "miscreant"},
		{"misdeed", "misde"},
		{"misdeeds", "misde"},
		{"misdemeanor", "misdemeanor"},
		{"misdemeanour", "misdemeanour"},
		{"misdemeanours", "misdemeanour"},
		{"misdirected", "misdirect"},
		{"misdirecting", "misdirect"},
		{"misdirections", "misdirect"},
		{"miser", "miser"},
		{"miserable", "miser"},
		{"miserably", "miser"},
		{"misericordia", "misericordia"},
		{"miseries", "miseri"},
		{"miserly", "miser"},
		{"misers", "miser"},
		{"misery", "miseri"},
		{"misfortune", "misfortun"},
		{"misfortunes", "misfortun"},
		{"misgave", "misgav"},
		{"misgiving", "misgiv"},
		{"misgivings", "misgiv"},
		{"mishap", "mishap"},
		{"misinformed", "misinform"},
		{"misinterpreted", "misinterpret"},
		{"misjudged", "misjudg"},
		{"misjudges", "misjudg"},
		{"mislaid", "mislaid"},
		{"mislead", "mislead"},
		{"misled", "misl"},
		{"mismanaged", "mismanag"},
		{"mismanagement", "mismanag"},
		{"misplaced", "misplac"},
		{"misrepresent", "misrepres"},
		{"misrepresentations", "misrepresent"},
		{"misrepresenting", "misrepres"},
		{"miss", "miss"},
		{"missed", "miss"},
		{"misses", "miss"},
		{"missile", "missil"},
		{"missing", "miss"},
		{"mission", "mission"},
		{"missionaries", "missionari"},
		{"missionary", "missionari"},
		{"missiones", "mission"},
		{"missions", "mission"},
		{"missis", "missi"},
		{"missive", "missiv"},
		{"misspent", "misspent"},
		{"missus", "missus"},
		{"missy", "missi"},
		{"mist", "mist"},
		{"mistake", "mistak"},
		{"mistaken", "mistaken"},
		{"mistakenly", "mistaken"},
		{"mistakes", "mistak"},
		{"mistaking", "mistak"},
		{"miste", "mist"},
		{"mister", "mister"},
		{"misther", "misther"},
		{"mistily", "mistili"},
		{"mistiness", "misti"},
		{"mistoo", "mistoo"},
		{"mistook", "mistook"},
		{"mistress", "mistress"},
		{"mistresses", "mistress"},
		{"mistrust", "mistrust"},
		{"mistrusted", "mistrust"},
		{"mistrustful", "mistrust"},
		{"mistrustfully", "mistrust"},
		{"mistrusting", "mistrust"},
		{"mistrusts", "mistrust"},
		{"mists", "mist"},
		{"misty", "misti"},
		{"misunderstand", "misunderstand"},
		{"misunderstanding", "misunderstand"},
		{"misunderstood", "misunderstood"},
		{"misused", "misus"},
		{"misuses", "misus"},
		{"mitchell", "mitchel"},
		{"mite", "mite"},
		{"mites", "mite"},
		{"mitigation", "mitig"},
		{"mitka", "mitka"},
		{"mitrofanievsky", "mitrofanievski"},
		{"mitten", "mitten"},
		{"mix", "mix"},
		{"mixed", "mix"},
		{"mixer", "mixer"},
		{"mixes", "mix"},
		{"mixing", "mix"},
		{"mixtur", "mixtur"},
		{"mixture", "mixtur"},
		{"mizzle", "mizzl"},
		{"mlud", "mlud"},
		{"mm", "mm"},
		{"mmd", "mmd"},
		{"mo", "mo"},
		{"moan", "moan"},
		{"moaned", "moan"},
		{"moaning", "moan"},
		{"moanings", "moan"},
		{"moans", "moan"},
		{"moat", "moat"},
		{"mob", "mob"},
		{"mobbed", "mob"},
		{"mobbs", "mobb"},
		{"mobile", "mobil"},
		{"mock", "mock"},
		{"mocked", "mock"},
		{"mockeries", "mockeri"},
		{"mockery", "mockeri"},
		{"mocking", "mock"},
		{"mockingly", "mock"},
		{"mode", "mode"},
		{"model", "model"},
		{"modelled", "model"},
		{"modelling", "model"},
		{"models", "model"},
		{"moderate", "moder"},
		{"moderated", "moder"},
		{"moderately", "moder"},
		{"moderation", "moder"},
		{"modern", "modern"},
		{"modes", "mode"},
		{"modest", "modest"},
		{"modestly", "modest"},
		{"modesty", "modesti"},
		{"modifications", "modif"},
		{"modified", "modifi"},
		{"modify", "modifi"},
		{"mogley", "mogley"},
		{"mogul", "mogul"},
		{"mohair", "mohair"},
		{"moi", "moi"},
		{"moiler", "moiler"},
		{"moind", "moind"},
		{"moins", "moin"},
		{"moist", "moist"},
		{"moisten", "moisten"},
		{"moistened", "moisten"},
		{"moistening", "moisten"},
		{"moisture", "moistur"},
		{"molar", "molar"},
		{"molasses", "molass"},
		{"moldavia", "moldavia"},
		{"mole", "mole"},
		{"molest", "molest"},
		{"molestation", "molest"},
		{"molested", "molest"},
		{"molesting", "molest"},
		{"moliere", "molier"},
		{"molina", "molina"},
		{"mollified", "mollifi"},
		{"mollify", "mollifi"},
		{"mollifying", "mollifi"},
		{"mollusca", "mollusca"},
		{"molluscous", "mollusc"},
		{"molluscs", "mollusc"},
		{"molothrus", "molothrus"},
		{"molten", "molten"},
		{"momen", "momen"},
		{"moment", "moment"},
		{"momentarily", "momentarili"},
		{"momentary", "momentari"},
		{"momentous", "moment"},
		{"moments", "moment"},
		{"momentum", "momentum"},
		{"mon", "mon"},
		{"monarch", "monarch"},
		{"monarchs", "monarch"},
		{"monastery", "monasteri"},
		{"monats", "monat"},
		{"monceaux", "monceaux"},
		{"mond", "mond"},
		{"monday", "monday"},
		{"mondays", "monday"},
		{"monde", "mond"},
		{"monetary", "monetari"},
		{"money", "money"},
		{"moneyed", "money"},
		{"moneys", "money"},
		{"monge", "mong"},
		{"mongering", "monger"},
		{"mongrel", "mongrel"},
		{"mongrels", "mongrel"},
		{"mongrober", "mongrob"},
		{"monied", "moni"},
		{"monitions", "monit"},
		{"monk", "monk"},
		{"monkey", "monkey"},
		{"monkeyish", "monkeyish"},
		{"monkeys", "monkey"},
		{"monks", "monk"},
		{"monneyment", "monney"},
		{"monoceros", "monocero"},
		{"monocotyledonous", "monocotyledon"},
		{"monodonta", "monodonta"},
		{"monogram", "monogram"},
		{"monologues", "monologu"},
		{"monomania", "monomania"},
		{"monomaniac", "monomaniac"},
		{"monomaniacs", "monomaniac"},
		{"monopolising", "monopolis"},
		{"monopolist", "monopolist"},
		{"monopolize", "monopol"},
		{"monopoly", "monopoli"},
		{"monosyllabic", "monosyllab"},
		{"monosyllable", "monosyl"},
		{"monosyllables", "monosyl"},
		{"monotonous", "monoton"},
		{"monotonously", "monoton"},
		{"monotony", "monotoni"},
		{"monsieur", "monsieur"},
		{"monsoon", "monsoon"},
		{"monster", "monster"},
		{"monsters", "monster"},
		{"monsther", "monsther"},
		{"monstrous", "monstrous"},
		{"monstrously", "monstrous"},
		{"mont", "mont"},
		{"montagne", "montagn"},
		{"monte", "mont"},
		{"monter", "monter"},
		{"montes", "mont"},
		{"month", "month"},
		{"monthly", "month"},
		{"months", "month"},
		{"monument", "monument"},
		{"monumental", "monument"},
		{"monuments", "monument"},
		{"mood", "mood"},
		{"moodily", "moodili"},
		{"moodiness", "moodi"},
		{"moodle", "moodl"},
		{"moods", "mood"},
		{"moody", "moodi"},
		{"moon", "moon"},
		{"mooney", "mooney"},
		{"mooning", "moon"},
		{"moonlight", "moonlight"},
		{"moonlighted", "moonlight"},
		{"moons", "moon"},
		{"moonshine", "moonshin"},
		{"moonths", "moonth"},
		{"moor", "moor"},
		{"moored", "moor"},
		{"moorings", "moor"},
		{"moorish", "moorish"},
		{"moorland", "moorland"},
		{"moors", "moor"},
		{"moot", "moot"},
		{"mooted", "moot"},
		{"mooth", "mooth"},
		{"moothers", "moother"},
		{"mope", "mope"},
		{"moped", "mope"},
		{"moping", "mope"},
		{"mor", "mor"},
		{"moraine", "morain"},
		{"moral", "moral"},
		{"moralise", "moralis"},
		{"moralised", "moralis"},
		{"moralising", "moralis"},
		{"moralisings", "moralis"},
		{"morality", "moral"},
		{"moralizes", "moral"},
		{"moralizing", "moral"},
		{"morally", "moral"},
		{"morals", "moral"},
		{"morass", "morass"},
		{"morbid", "morbid"},
		{"morbidly", "morbid"},
		{"morbury", "morburi"},
		{"more", "more"},
		{"moreover", "moreov"},
		{"moresby", "moresbi"},
		{"moreton", "moreton"},
		{"morgan", "morgan"},
		{"morgenfruh", "morgenfruh"},
		{"morleena", "morleena"},
		{"morn", "morn"},
		{"morning", "morn"},
		{"mornings", "morn"},
		{"mornmg", "mornmg"},
		{"morocco", "morocco"},
		{"morose", "moros"},
		{"morosely", "moros"},
		{"moroseness", "moros"},
		{"morpheus", "morpheus"},
		{"morrow", "morrow"},
		{"morsel", "morsel"},
		{"morsels", "morsel"},
		{"mortal", "mortal"},
		{"mortality", "mortal"},
		{"mortally", "mortal"},
		{"mortals", "mortal"},
		{"mortar", "mortar"},
		{"mortgage", "mortgag"},
		{"mortgages", "mortgag"},
		{"mortgaging", "mortgag"},
		{"mortification", "mortif"},
		{"mortified", "mortifi"},
		{"mortify", "mortifi"},
		{"mortifying", "mortifi"},
		{"mortimer", "mortim"},
		{"morton", "morton"},
		{"mos", "mos"},
		{"moscow", "moscow"},
		{"mosquitoes", "mosquito"},
		{"moss", "moss"},
		{"mosses", "moss"},
		{"mossy", "mossi"},
		{"most", "most"},
		{"mostly", "most"},
		{"moth", "moth"},
		{"mother", "mother"},
		{"motherless", "motherless"},
		{"motherly", "mother"},
		{"mothers", "mother"},
		{"moths", "moth"},
		{"motion", "motion"},
		{"motioned", "motion"},
		{"motioning", "motion"},
		{"motionles", "motionl"},
		{"motionless", "motionless"},
		{"motions", "motion"},
		{"motive", "motiv"},
		{"motives", "motiv"},
		{"motley", "motley"},
		{"mottled", "mottl"},
		{"mottles", "mottl"},
		{"motto", "motto"},
		{"mouchoir", "mouchoir"},
		{"mould", "mould"},
		{"moulded", "mould"},
		{"moulder", "moulder"},
		{"mouldering", "moulder"},
		{"moulding", "mould"},
		{"moulds", "mould"},
		{"mouldy", "mouldi"},
		{"moun", "moun"},
		{"mound", "mound"},
		{"mounds", "mound"},
		{"mount", "mount"},
		{"mountain", "mountain"},
		{"mountainous", "mountain"},
		{"mountains", "mountain"},
		{"mountebanks", "mountebank"},
		{"mounted", "mount"},
		{"mounting", "mount"},
		{"mounts", "mount"},
		{"mourn", "mourn"},
		{"mourned", "mourn"},
		{"mourner", "mourner"},
		{"mourners", "mourner"},
		{"mournful", "mourn"},
		{"mournfully", "mourn"},
		{"mournfulness", "mourn"},
		{"mourning", "mourn"},
		{"mourns", "mourn"},
		{"mouse", "mous"},
		{"moustache", "moustach"},
		{"moustached", "moustach"},
		{"moustaches", "moustach"},
		{"moustachios", "moustachio"},
		{"mouth", "mouth"},
		{"mouthed", "mouth"},
		{"mouthful", "mouth"},
		{"mouthfuls", "mouth"},
		{"mouthing", "mouth"},
		{"mouthpiece", "mouthpiec"},
		{"mouths", "mouth"},
		{"mov", "mov"},
		{"movables", "movabl"},
		{"move", "move"},
		{"moveable", "moveabl"},
		{"moved", "move"},
		{"movemen", "movemen"},
		{"movement", "movement"},
		{"movements", "movement"},
		{"mover", "mover"},
		{"moves", "move"},
		{"moving", "move"},
		{"mowed", "mow"},
		{"mown", "mown"},
		{"mozart", "mozart"},
		{"mp", "mp"},
		{"mps", "mps"},
		{"mr", "mr"},
		{"mrs", "mrs"},
		{"ms", "ms"},
		{"mt", "mt"},
		{"muc", "muc"},
		{"much", "much"},
		{"muchisimas", "muchisima"},
		{"mucilaginous", "mucilagin"},
		{"mucker", "mucker"},
		{"mud", "mud"},
		{"muddiest", "muddiest"},
		{"muddle", "muddl"},
		{"muddled", "muddl"},
		{"muddles", "muddl"},
		{"muddocks", "muddock"},
		{"muddy", "muddi"},
		{"muddying", "muddi"},
		{"mudie", "mudi"},
		{"mudlike", "mudlik"},
		{"muffin", "muffin"},
		{"muffins", "muffin"},
		{"muffle", "muffl"},
		{"muffled", "muffl"},
		{"muffles", "muffl"},
		{"muffling", "muffl"},
		{"muffy", "muffi"},
		{"mug", "mug"},
		{"mugeres", "muger"},
		{"mugs", "mug"},
		{"mulatto", "mulatto"},
		{"mulberry", "mulberri"},
		{"mulcted", "mulct"},
		{"mule", "mule"},
		{"mules", "mule"},
		{"muleteer", "mulet"},
		{"muleteers", "mulet"},
		{"mulita", "mulita"},
		{"mullins", "mullin"},
		{"multimaculatus", "multimaculatus"},
		{"multiplication", "multipl"},
		{"multiplicity", "multipl"},
		{"multiplied", "multipli"},
		{"multiplier", "multipli"},
		{"multiply", "multipli"},
		{"multiplying", "multipli"},
		{"multitude", "multitud"},
		{"multitudes", "multitud"},
		{"multitudinous", "multitudin"},
		{"mum", "mum"},
		{"mumbled", "mumbl"},
		{"mumbling", "mumbl"},
		{"mummery", "mummeri"},
		{"mummy", "mummi"},
		{"mun", "mun"},
		{"munchausen", "munchausen"},
		{"munches", "munch"},
		{"munching", "munch"},
		{"mundane", "mundan"},
		{"mungo", "mungo"},
		{"munich", "munich"},
		{"municipal", "municip"},
		{"municipalities", "municip"},
		{"munificence", "munific"},
		{"munificent", "munific"},
		{"muniz", "muniz"},
		{"muntle", "muntl"},
		{"muntlehiney", "muntlehiney"},
		{"murder", "murder"},
		{"murdered", "murder"},
		{"murderer", "murder"},
		{"murderers", "murder"},
		{"murderess", "murderess"},
		{"murdering", "murder"},
		{"murderous", "murder"},
		{"murders", "murder"},
		{"muriate", "muriat"},
		{"muriates", "muriat"},
		{"murinus", "murinus"},
		{"murky", "murki"},
		{"murmur", "murmur"},
		{"murmured", "murmur"},
		{"murmuring", "murmur"},
		{"murmuringly", "murmur"},
		{"murmurings", "murmur"},
		{"murmurs", "murmur"},
		{"murphy", "murphi"},
		{"murray", "murray"},
		{"murrumbidgee", "murrumbidge"},
		{"mus", "mus"},
		{"muscle", "muscl"},
		{"muscles", "muscl"},
		{"muscular", "muscular"},
		{"muse", "muse"},
		{"mused", "muse"},
		{"muses", "muse"},
		{"museum", "museum"},
		{"musgrave", "musgrav"},
		{"mushroom", "mushroom"},
		{"mushrooms", "mushroom"},
		{"music", "music"},
		{"musical", "music"},
		{"musician", "musician"},
		{"musing", "muse"},
		{"musingly", "muse"},
		{"musk", "musk"},
		{"musket", "musket"},
		{"musketry", "musketri"},
		{"muskets", "musket"},
		{"muslin", "muslin"},
		{"muslins", "muslin"},
		{"musn", "musn"},
		{"musquitoes", "musquito"},
		{"muss", "muss"},
		{"mussel", "mussel"},
		{"must", "must"},
		{"mustaches", "mustach"},
		{"mustard", "mustard"},
		{"muster", "muster"},
		{"mustered", "muster"},
		{"mustn", "mustn"},
		{"musty", "musti"},
		{"mute", "mute"},
		{"mutilated", "mutil"},
		{"mutilates", "mutil"},
		{"mutinous", "mutin"},
		{"mutiny", "mutini"},
		{"mutter", "mutter"},
		{"muttered", "mutter"},
		{"muttering", "mutter"},
		{"mutterings", "mutter"},
		{"mutters", "mutter"},
		{"mutton", "mutton"},
		{"mutual", "mutual"},
		{"mutually", "mutual"},
		{"muy", "muy"},
		{"muzzle", "muzzl"},
		{"my", "my"},
		{"myiobius", "myiobius"},
		{"mylodon", "mylodon"},
		{"myopotamus", "myopotamus"},
		{"myriads", "myriad"},
		{"myrmidons", "myrmidon"},
		{"myrtle", "myrtl"},
		{"myrtus", "myrtus"},
		{"myself", "myself"},
		{"mysteries", "mysteri"},
		{"mysterieuse", "mysterieus"},
		{"mysterious", "mysteri"},
		{"mysteriously", "mysteri"},
		{"mystery", "mysteri"},
		{"mystic", "mystic"},
		{"mystification", "mystif"},
		{"mystified", "mystifi"},
		{"mystify", "mystifi"},
		{"mythische", "mythisch"},
		{"myths", "myth"},
		{"mytilus", "mytilus"},
		{"n", "n"},
		{"na", "na"},
		{"nae", "nae"},
		{"nag", "nag"},
		{"nags", "nag"},
		{"nail", "nail"},
		{"nailed", "nail"},
		{"nails", "nail"},
		{"naive", "naiv"},
		{"naively", "naiv"},
		{"naked", "nake"},
		{"nakedness", "naked"},
		{"nam", "nam"},
		{"name", "name"},
		{"named", "name"},
		{"nameless", "nameless"},
		{"namely", "name"},
		{"names", "name"},
		{"namesake", "namesak"},
		{"naming", "name"},
		{"nankeen", "nankeen"},
		{"nanus", "nanus"},
		{"nap", "nap"},
		{"nape", "nape"},
		{"napkin", "napkin"},
		{"naples", "napl"},
		{"napoleon", "napoleon"},
		{"napoleons", "napoleon"},
		{"narborough", "narborough"},
		{"narcissus", "narcissus"},
		{"narr", "narr"},
		{"narrated", "narrat"},
		{"narrates", "narrat"},
		{"narration", "narrat"},
		{"narrative", "narrat"},
		{"narratives", "narrat"},
		{"narrow", "narrow"},
		{"narrowed", "narrow"},
		{"narrower", "narrow"},
		{"narrowest", "narrowest"},
		{"narrowing", "narrow"},
		{"narrowly", "narrowli"},
		{"narrowness", "narrow"},
		{"narrows", "narrow"},
		{"nasal", "nasal"},
		{"nassa", "nassa"},
		{"nastasya", "nastasya"},
		{"nastiness", "nasti"},
		{"nasturtions", "nasturt"},
		{"nasty", "nasti"},
		{"nat", "nat"},
		{"nata", "nata"},
		{"natalya", "natalya"},
		{"nate", "nate"},
		{"nateral", "nater"},
		{"naterally", "nater"},
		{"nation", "nation"},
		{"national", "nation"},
		{"nationality", "nation"},
		{"nations", "nation"},
		{"native", "nativ"},
		{"natives", "nativ"},
		{"natur", "natur"},
		{"natural", "natur"},
		{"naturalest", "naturalest"},
		{"naturalist", "naturalist"},
		{"naturalista", "naturalista"},
		{"naturalists", "naturalist"},
		{"naturalized", "natur"},
		{"naturally", "natur"},
		{"naturalness", "natur"},
		{"nature", "natur"},
		{"natured", "natur"},
		{"naturedly", "natur"},
		{"naturelles", "naturell"},
		{"natures", "natur"},
		{"naughtiest", "naughtiest"},
		{"naughtiness", "naughti"},
		{"naughty", "naughti"},
		{"nausea", "nausea"},
		{"nauseous", "nauseous"},
		{"nautical", "nautic"},
		{"naval", "naval"},
		{"navarin", "navarin"},
		{"nave", "nave"},
		{"navedad", "navedad"},
		{"navel", "navel"},
		{"navies", "navi"},
		{"navigate", "navig"},
		{"navigating", "navig"},
		{"navigation", "navig"},
		{"navigator", "navig"},
		{"navigators", "navig"},
		{"navy", "navi"},
		{"nay", "nay"},
		{"nayver", "nayver"},
		{"nd", "nd"},
		{"ne", "ne"},
		{"nea", "nea"},
		{"neame", "neam"},
		{"neaming", "neam"},
		{"neane", "nean"},
		{"near", "near"},
		{"neared", "near"},
		{"nearer", "nearer"},
		{"nearest", "nearest"},
		{"nearl", "nearl"},
		{"nearly", "near"},
		{"nearness", "near"},
		{"nearsighted", "nearsight"},
		{"neat", "neat"},
		{"neatest", "neatest"},
		{"neath", "neath"},
		{"neatly", "neat"},
		{"neatness", "neat"},
		{"nebulous", "nebul"},
		{"necesary", "necesari"},
		{"necesidad", "necesidad"},
		{"necessaries", "necessari"},
		{"necessarily", "necessarili"},
		{"necessary", "necessari"},
		{"necessitate", "necessit"},
		{"necessitated", "necessit"},
		{"necessitates", "necessit"},
		{"necessities", "necess"},
		{"necessity", "necess"},
		{"neck", "neck"},
		{"neckcloth", "neckcloth"},
		{"neckcloths", "neckcloth"},
		{"necked", "neck"},
		{"neckerchief", "neckerchief"},
		{"neckett", "neckett"},
		{"neckkerchief", "neckkerchief"},
		{"necklace", "necklac"},
		{"necklaced", "necklac"},
		{"necklaces", "necklac"},
		{"necks", "neck"},
		{"necktie", "neckti"},
		{"necromancer", "necromanc"},
		{"necrophagous", "necrophag"},
		{"nectar", "nectar"},
		{"nectarine", "nectarin"},
		{"nectarines", "nectarin"},
		{"ned", "ned"},
		{"neeburs", "neebur"},
		{"need", "need"},
		{"needed", "need"},
		{"needful", "need"},
		{"needing", "need"},
		{"needle", "needl"},
		{"needless", "needless"},
		{"needlework", "needlework"},
		{"needn", "needn"},
		{"needs", "need"},
		{"needy", "needi"},
		{"neeght", "neeght"},
		{"nefarious", "nefari"},
		{"negative", "negat"},
		{"neglect", "neglect"},
		{"neglected", "neglect"},
		{"neglectful", "neglect"},
		{"neglecting", "neglect"},
		{"negligemment", "negligem"},
		{"negligence", "neglig"},
		{"negligent", "neglig"},
		{"negligently", "neglig"},
		{"negotiable", "negoti"},
		{"negotiate", "negoti"},
		{"negotiating", "negoti"},
		{"negotiation", "negoti"},
		{"negotiations", "negoti"},
		{"negress", "negress"},
		{"negro", "negro"},
		{"negroes", "negro"},
		{"negus", "negus"},
		{"neigh", "neigh"},
		{"neighborhood", "neighborhood"},
		{"neighbour", "neighbour"},
		{"neighbourhood", "neighbourhood"},
		{"neighbouring", "neighbour"},
		{"neighbourly", "neighbour"},
		{"neighbours", "neighbour"},
		{"neighing", "neigh"},
		{"neight", "neight"},
		{"neither", "neither"},
		{"nekrassov", "nekrassov"},
		{"nelly", "nelli"},
		{"nemo", "nemo"},
		{"nemophilas", "nemophila"},
		{"neophyte", "neophyt"},
		{"nepean", "nepean"},
		{"nephew", "nephew"},
		{"nephews", "nephew"},
		{"ner", "ner"},
		{"nereidae", "nereida"},
		{"nereidous", "nereid"},
		{"nero", "nero"},
		{"nerve", "nerv"},
		{"nerves", "nerv"},
		{"nerving", "nerv"},
		{"nervous", "nervous"},
		{"nervously", "nervous"},
		{"nervousness", "nervous"},
		{"nervure", "nervur"},
		{"nervures", "nervur"},
		{"nesbit", "nesbit"},
		{"nest", "nest"},
		{"nestled", "nestl"},
		{"nestling", "nestl"},
		{"nestlings", "nestl"},
		{"nestor", "nestor"},
		{"nests", "nest"},
		{"net", "net"},
		{"nether", "nether"},
		{"nets", "net"},
		{"netted", "net"},
		{"nettle", "nettl"},
		{"nettled", "nettl"},
		{"nettles", "nettl"},
		{"neuralgia", "neuralgia"},
		{"neuroptera", "neuroptera"},
		{"neuter", "neuter"},
		{"neutral", "neutral"},
		{"neva", "neva"},
		{"neve", "neve"},
		{"never", "never"},
		{"nevertheless", "nevertheless"},
		{"nevew", "nevew"},
		{"nevsky", "nevski"},
		{"new", "new"},
		{"newark", "newark"},
		{"newcastle", "newcastl"},
		{"newcomers", "newcom"},
		{"newer", "newer"},
		{"newest", "newest"},
		{"newgate", "newgat"},
		{"newly", "newli"},
		{"newman", "newman"},
		{"newmarket", "newmarket"},
		{"newness", "new"},
		{"news", "news"},
		{"newsmen", "newsmen"},
		{"newspaper", "newspap"},
		{"newspapers", "newspap"},
		{"newton", "newton"},
		{"next", "next"},
		{"ney", "ney"},
		{"neyver", "neyver"},
		{"nezhin", "nezhin"},
		{"ni", "ni"},
		{"niagaras", "niagara"},
		{"niata", "niata"},
		{"niatas", "niata"},
		{"nib", "nib"},
		{"nice", "nice"},
		{"nicely", "nice"},
		{"niceness", "nice"},
		{"nicer", "nicer"},
		{"nicest", "nicest"},
		{"nicety", "niceti"},
		{"niche", "nich"},
		{"nicher", "nicher"},
		{"niches", "nich"},
		{"nicholas", "nichola"},
		{"nick", "nick"},
		{"nickelby", "nickelbi"},
		{"nickleby", "nicklebi"},
		{"nicklebys", "nicklebi"},
		{"nickname", "nicknam"},
		{"nicolas", "nicola"},
		{"nictitating", "nictit"},
		{"nidification", "nidif"},
		{"niebla", "niebla"},
		{"niece", "niec"},
		{"nieces", "niec"},
		{"niente", "nient"},
		{"niger", "niger"},
		{"nigger", "nigger"},
		{"niggering", "nigger"},
		{"niggers", "nigger"},
		{"nigh", "nigh"},
		{"night", "night"},
		{"nightcap", "nightcap"},
		{"nightcaps", "nightcap"},
		{"nightfall", "nightfal"},
		{"nightingale", "nightingal"},
		{"nightingales", "nightingal"},
		{"nightly", "night"},
		{"nightmare", "nightmar"},
		{"nights", "night"},
		{"nigra", "nigra"},
		{"nigricans", "nigrican"},
		{"nigricollis", "nigricolli"},
		{"nihil", "nihil"},
		{"nihilist", "nihilist"},
		{"nihilists", "nihilist"},
		{"nikiforovna", "nikiforovna"},
		{"nikodim", "nikodim"},
		{"nikolaevsky", "nikolaevski"},
		{"nikolay", "nikolay"},
		{"nil", "nil"},
		{"nile", "nile"},
		{"nillandoo", "nillandoo"},
		{"nimble", "nimbl"},
		{"nimbly", "nimbl"},
		{"nimrod", "nimrod"},
		{"nine", "nine"},
		{"ninepence", "ninep"},
		{"ninepin", "ninepin"},
		{"nines", "nine"},
		{"nineteen", "nineteen"},
		{"nineteenth", "nineteenth"},
		{"ninetta", "ninetta"},
		{"ninety", "nineti"},
		{"ninevite", "ninevit"},
		{"ninnies", "ninni"},
		{"ninth", "ninth"},
		{"niobe", "niob"},
		{"nipped", "nip"},
		{"nipping", "nip"},
		{"nips", "nip"},
		{"nitrate", "nitrat"},
		{"nitric", "nitric"},
		{"nivalis", "nivali"},
		{"nixon", "nixon"},
		{"nixt", "nixt"},
		{"no", "no"},
		{"noa", "noa"},
		{"noabody", "noabodi"},
		{"noah", "noah"},
		{"nobbiest", "nobbiest"},
		{"nobility", "nobil"},
		{"noble", "nobl"},
		{"nobleman", "nobleman"},
		{"noblemen", "noblemen"},
		{"nobleness", "nobl"},
		{"nobler", "nobler"},
		{"noblesse", "nobless"},
		{"noblest", "noblest"},
		{"nobly", "nobli"},
		{"nobodies", "nobodi"},
		{"nobody", "nobodi"},
		{"nobodys", "nobodi"},
		{"nocturna", "nocturna"},
		{"nocturnal", "nocturn"},
		{"nod", "nod"},
		{"nodded", "nod"},
		{"noddies", "noddi"},
		{"nodding", "nod"},
		{"noddings", "nod"},
		{"noddy", "noddi"},
		{"nods", "nod"},
		{"nodules", "nodul"},
		{"noes", "noe"},
		{"nogg", "nogg"},
		{"noggs", "nogg"},
		{"noice", "noic"},
		{"noir", "noir"},
		{"noire", "noir"},
		{"noise", "nois"},
		{"noised", "nois"},
		{"noiseless", "noiseless"},
		{"noiselessly", "noiseless"},
		{"noises", "nois"},
		{"noisier", "noisier"},
		{"noisily", "noisili"},
		{"noisome", "noisom"},
		{"noisy", "noisi"},
		{"nokolay", "nokolay"},
		{"nolasko", "nolasko"},
		{"nomadically", "nomad"},
		{"nomads", "nomad"},
		{"nomenclature", "nomenclatur"},
		{"nominal", "nomin"},
		{"nominally", "nomin"},
		{"nominate", "nomin"},
		{"nominated", "nomin"},
		{"nomination", "nomin"},
		{"nominative", "nomin"},
		{"nominee", "nomine"},
		{"non", "non"},
		{"nonce", "nonc"},
		{"nonchalance", "nonchal"},
		{"nonchalant", "nonchal"},
		{"none", "none"},
		{"nonentity", "nonent"},
		{"nonpareil", "nonpareil"},
		{"nonsense", "nonsens"},
		{"nonsensical", "nonsens"},
		{"noo", "noo"},
		{"noodle", "noodl"},
		{"noodles", "noodl"},
		{"nook", "nook"},
		{"nooks", "nook"},
		{"noon", "noon"},
		{"noonday", "noonday"},
		{"noose", "noos"},
		{"nooses", "noos"},
		{"nor", "nor"},
		{"nore", "nore"},
		{"normal", "normal"},
		{"normally", "normal"},
		{"norman", "norman"},
		{"normously", "normous"},
		{"noronha", "noronha"},
		{"north", "north"},
		{"northampton", "northampton"},
		{"northerly", "norther"},
		{"northern", "northern"},
		{"northward", "northward"},
		{"northwards", "northward"},
		{"norval", "norval"},
		{"norway", "norway"},
		{"nose", "nose"},
		{"nosed", "nose"},
		{"nosegay", "nosegay"},
		{"nosegays", "nosegay"},
		{"noses", "nose"},
		{"nostril", "nostril"},
		{"nostrils", "nostril"},
		{"not", "not"},
		{"notable", "notabl"},
		{"notably", "notabl"},
		{"notaphus", "notaphus"},
		{"notary", "notari"},
		{"notched", "notch"},
		{"notches", "notch"},
		{"note", "note"},
		{"notebook", "notebook"},
		{"notebooks", "notebook"},
		{"noted", "note"},
		{"notes", "note"},
		{"noteworthy", "noteworthi"},
		{"nothin", "nothin"},
		{"nothing", "noth"},
		{"nothings", "noth"},
		{"nothink", "nothink"},
		{"nothura", "nothura"},
		{"notic", "notic"},
		{"notice", "notic"},
		{"noticeable", "notic"},
		{"noticeably", "notic"},
		{"noticed", "notic"},
		{"notices", "notic"},
		{"noticing", "notic"},
		{"notification", "notif"},
		{"notified", "notifi"},
		{"noting", "note"},
		{"notion", "notion"},
		{"notions", "notion"},
		{"notopods", "notopod"},
		{"notoriety", "notorieti"},
		{"notorious", "notori"},
		{"notoriously", "notori"},
		{"notre", "notr"},
		{"notwithstanding", "notwithstand"},
		{"nou", "nou"},
		{"nough", "nough"},
		{"nought", "nought"},
		{"noun", "noun"},
		{"nourish", "nourish"},
		{"nourished", "nourish"},
		{"nourishment", "nourish"},
		{"nous", "nous"},
		{"nov", "nov"},
		{"novae", "nova"},
		{"novel", "novel"},
		{"novelist", "novelist"},
		{"novels", "novel"},
		{"novelties", "novelti"},
		{"novelty", "novelti"},
		{"november", "novemb"},
		{"novice", "novic"},
		{"novices", "novic"},
		{"novitiate", "noviti"},
		{"novos", "novo"},
		{"now", "now"},
		{"nowadays", "nowaday"},
		{"noways", "noway"},
		{"nowhere", "nowher"},
		{"nowheres", "nowher"},
		{"nowise", "nowis"},
		{"nowt", "nowt"},
		{"noxious", "noxious"},
		{"nozzle", "nozzl"},
		{"nt", "nt"},
		{"nucleus", "nucleus"},
		{"nudge", "nudg"},
		{"nudged", "nudg"},
		{"nudges", "nudg"},
		{"nudging", "nudg"},
		{"nuisance", "nuisanc"},
		{"nulla", "nulla"},
		{"nulliporae", "nullipora"},
		{"numb", "numb"},
		{"numbed", "numb"},
		{"number", "number"},
		{"numbered", "number"},
		{"numberless", "numberless"},
		{"numbers", "number"},
		{"numerical", "numer"},
		{"numerous", "numer"},
		{"nummularia", "nummularia"},
		{"numskull", "numskul"},
		{"nun", "nun"},
		{"nunnery", "nunneri"},
		{"nuptial", "nuptial"},
		{"nuptials", "nuptial"},
		{"nurse", "nurs"},
		{"nursed", "nurs"},
		{"nursemaid", "nursemaid"},
		{"nursery", "nurseri"},
		{"nurses", "nurs"},
		{"nursing", "nurs"},
		{"nurture", "nurtur"},
		{"nurtured", "nurtur"},
		{"nuss", "nuss"},
		{"nut", "nut"},
		{"nutcrackers", "nutcrack"},
		{"nutmeg", "nutmeg"},
		{"nutriment", "nutriment"},
		{"nutritious", "nutriti"},
		{"nuts", "nut"},
		{"nutshell", "nutshel"},
		{"nutshells", "nutshel"},
		{"nymph", "nymph"},
		{"nymphs", "nymph"},
		{"o", "o"},
		{"oaf", "oaf"},
		{"oak", "oak"},
		{"oaken", "oaken"},
		{"oaks", "oak"},
		{"oar", "oar"},
		{"oars", "oar"},
		{"oarsman", "oarsman"},
		{"oasis", "oasi"},
		{"oath", "oath"},
		{"oaths", "oath"},
		{"oats", "oat"},
		{"oban", "oban"},
		{"obduracy", "obduraci"},
		{"obdurate", "obdur"},
		{"obdurately", "obdur"},
		{"obedience", "obedi"},
		{"obedient", "obedi"},
		{"obediently", "obedi"},
		{"obedt", "obedt"},
		{"obeisance", "obeis"},
		{"obeisances", "obeis"},
		{"obelisk", "obelisk"},
		{"obelisks", "obelisk"},
		{"obesity", "obes"},
		{"obey", "obey"},
		{"obeyed", "obey"},
		{"obeyeth", "obeyeth"},
		{"obeying", "obey"},
		{"obeys", "obey"},
		{"obispo", "obispo"},
		{"obits", "obit"},
		{"object", "object"},
		{"objected", "object"},
		{"objecting", "object"},
		{"objection", "object"},
		{"objectionable", "objection"},
		{"objections", "object"},
		{"objectless", "objectless"},
		{"objects", "object"},
		{"obleege", "obleeg"},
		{"obleeging", "obleeg"},
		{"obligation", "oblig"},
		{"obligations", "oblig"},
		{"oblige", "oblig"},
		{"obliged", "oblig"},
		{"obliges", "oblig"},
		{"obliging", "oblig"},
		{"obligingly", "oblig"},
		{"obligingness", "obliging"},
		{"oblique", "obliqu"},
		{"obliterate", "obliter"},
		{"obliterated", "obliter"},
		{"obliterating", "obliter"},
		{"obliteration", "obliter"},
		{"oblivion", "oblivion"},
		{"oblivious", "oblivi"},
		{"oblong", "oblong"},
		{"obscene", "obscen"},
		{"obscenity", "obscen"},
		{"obscure", "obscur"},
		{"obscured", "obscur"},
		{"obscurely", "obscur"},
		{"obscures", "obscur"},
		{"obscuring", "obscur"},
		{"obscurity", "obscur"},
		{"obsequious", "obsequi"},
		{"obsequiousness", "obsequi"},
		{"observa", "observa"},
		{"observable", "observ"},
		{"observaciones", "observacion"},
		{"observance", "observ"},
		{"observant", "observ"},
		{"observation", "observ"},
		{"observations", "observ"},
		{"observe", "observ"},
		{"observed", "observ"},
		{"observer", "observ"},
		{"observers", "observ"},
		{"observes", "observ"},
		{"observing", "observ"},
		{"obsession", "obsess"},
		{"obsolete", "obsolet"},
		{"obstacle", "obstacl"},
		{"obstacles", "obstacl"},
		{"obstinacy", "obstinaci"},
		{"obstinate", "obstin"},
		{"obstinately", "obstin"},
		{"obstructed", "obstruct"},
		{"obstructing", "obstruct"},
		{"obstruction", "obstruct"},
		{"obtain", "obtain"},
		{"obtainable", "obtain"},
		{"obtained", "obtain"},
		{"obtaining", "obtain"},
		{"obtains", "obtain"},
		{"obtruded", "obtrud"},
		{"obtruding", "obtrud"},
		{"obtrusive", "obtrus"},
		{"obtrusively", "obtrus"},
		{"obtuse", "obtus"},
		{"obviating", "obviat"},
		{"obvious", "obvious"},
		{"obviously", "obvious"},
		{"occasion", "occas"},
		{"occasional", "occasion"},
		{"occasionally", "occasion"},
		{"occasioned", "occas"},
		{"occasioning", "occas"},
		{"occasions", "occas"},
		{"occidentalis", "occidentali"},
		{"occupancy", "occup"},
		{"occupant", "occup"},
		{"occupants", "occup"},
		{"occupation", "occup"},
		{"occupations", "occup"},
		{"occupied", "occupi"},
		{"occupier", "occupi"},
		{"occupiers", "occupi"},
		{"occupies", "occupi"},
		{"occupy", "occupi"},
		{"occupying", "occupi"},
		{"occur", "occur"},
		{"occurred", "occur"},
		{"occurrence", "occurr"},
		{"occurrences", "occurr"},
		{"occurring", "occur"},
		{"occurs", "occur"},
		{"ocean", "ocean"},
		{"oceanic", "ocean"},
		{"oceans", "ocean"},
		{"och", "och"},
		{"octave", "octav"},
		{"octavia", "octavia"},
		{"octavo", "octavo"},
		{"october", "octob"},
		{"octopus", "octopus"},
		{"ocular", "ocular"},
		{"odd", "odd"},
		{"odder", "odder"},
		{"oddest", "oddest"},
		{"oddities", "odditi"},
		{"oddity", "odditi"},
		{"oddly", "odd"},
		{"oddness", "odd"},
		{"odds", "odd"},
		{"ode", "ode"},
		{"odious", "odious"},
		{"odiously", "odious"},
		{"odium", "odium"},
		{"odoriferous", "odorifer"},
		{"odour", "odour"},
		{"odours", "odour"},
		{"ods", "od"},
		{"oens", "oen"},
		{"oesophagus", "oesophagus"},
		{"oeuvre", "oeuvr"},
		{"of", "of"},
		{"off", "off"},
		{"offal", "offal"},
		{"offe", "off"},
		{"offence", "offenc"},
		{"offences", "offenc"},
		{"offend", "offend"},
		{"offended", "offend"},
		{"offender", "offend"},
		{"offending", "offend"},
		{"offends", "offend"},
		{"offense", "offens"},
		{"offensive", "offens"},
		{"offensively", "offens"},
		{"offer", "offer"},
		{"offered", "offer"},
		{"offering", "offer"},
		{"offerings", "offer"},
		{"offers", "offer"},
		{"office", "offic"},
		{"officer", "offic"},
		{"officered", "offic"},
		{"officers", "offic"},
		{"offices", "offic"},
		{"official", "offici"},
		{"officially", "offici"},
		{"officials", "offici"},
		{"officiates", "offici"},
		{"officier", "offici"},
		{"officious", "offici"},
		{"officiously", "offici"},
		{"offing", "of"},
		{"offshoots", "offshoot"},
		{"offspring", "offspr"},
		{"oft", "oft"},
		{"often", "often"},
		{"oftener", "often"},
		{"oftenest", "oftenest"},
		{"oftentimes", "oftentim"},
		{"ogles", "ogl"},
		{"ogre", "ogr"},
		{"ogreish", "ogreish"},
		{"oh", "oh"},
		{"ohnglaube", "ohnglaub"},
		{"oho", "oho"},
		{"oil", "oil"},
		{"oiliness", "oili"},
		{"oilskin", "oilskin"},
		{"oily", "oili"},
		{"ointment", "ointment"},
		{"ojection", "oject"},
		{"ojos", "ojo"},
		{"old", "old"},
		{"older", "older"},
		{"oldest", "oldest"},
		{"ole", "ole"},
		{"olfactory", "olfactori"},
		{"olfersia", "olfersia"},
		{"olinda", "olinda"},
		{"oliva", "oliva"},
		{"olivasea", "olivasea"},
		{"olive", "oliv"},
		{"olives", "oliv"},
		{"olivia", "olivia"},
		{"ologies", "olog"},
		{"olympus", "olympus"},
		{"ombu", "ombu"},
		{"omen", "omen"},
		{"ominous", "omin"},
		{"omission", "omiss"},
		{"omissions", "omiss"},
		{"omit", "omit"},
		{"omitted", "omit"},
		{"omitting", "omit"},
		{"omnibus", "omnibus"},
		{"omnibuses", "omnibus"},
		{"omnipotence", "omnipot"},
		{"omnipotent", "omnipot"},
		{"omniscience", "omnisci"},
		{"omniscient", "omnisci"},
		{"omnium", "omnium"},
		{"omnivorous", "omnivor"},
		{"on", "on"},
		{"once", "onc"},
		{"one", "one"},
		{"oneness", "one"},
		{"onerous", "oner"},
		{"ones", "one"},
		{"oneself", "oneself"},
		{"onion", "onion"},
		{"onions", "onion"},
		{"oniscia", "oniscia"},
		{"only", "onli"},
		{"ont", "ont"},
		{"onthophagus", "onthophagus"},
		{"onto", "onto"},
		{"onus", "onus"},
		{"onward", "onward"},
		{"onwards", "onward"},
		{"onwholesome", "onwholesom"},
		{"ony", "oni"},
		{"oo", "oo"},
		{"ooman", "ooman"},
		{"oop", "oop"},
		{"oot", "oot"},
		{"oother", "oother"},
		{"ootside", "ootsid"},
		{"ooze", "ooz"},
		{"oozed", "ooz"},
		{"oozes", "ooz"},
		{"opaque", "opaqu"},
		{"ope", "ope"},
		{"open", "open"},
		{"opened", "open"},
		{"opener", "open"},
		{"opening", "open"},
		{"openings", "open"},
		{"openly", "open"},
		{"openness", "open"},
		{"opens", "open"},
		{"opera", "opera"},
		{"operas", "opera"},
		{"operate", "oper"},
		{"operated", "oper"},
		{"operating", "oper"},
		{"operation", "oper"},
		{"operations", "oper"},
		{"operative", "oper"},
		{"operator", "oper"},
		{"operculum", "operculum"},
		{"opetiorhynchi", "opetiorhynchi"},
		{"opetiorhynchus", "opetiorhynchus"},
		{"ophrys", "ophri"},
		{"opiate", "opiat"},
		{"opimon", "opimon"},
		{"opined", "opin"},
		{"opining", "opin"},
		{"opinion", "opinion"},
		{"opinionated", "opinion"},
		{"opinionative", "opinion"},
		{"opinions", "opinion"},
		{"opinlon", "opinlon"},
		{"opium", "opium"},
		{"opossum", "opossum"},
		{"opossums", "opossum"},
		{"opp", "opp"},
		{"opponent", "oppon"},
		{"opponents", "oppon"},
		{"opportune", "opportun"},
		{"opportunely", "opportun"},
		{"opportunities", "opportun"},
		{"opportunity", "opportun"},
		{"oppose", "oppos"},
		{"opposed", "oppos"},
		{"opposing", "oppos"},
		{"opposite", "opposit"},
		{"opposites", "opposit"},
		{"opposition", "opposit"},
		{"oppress", "oppress"},
		{"oppressed", "oppress"},
		{"oppression", "oppress"},
		{"oppressive", "oppress"},
		{"oppressor", "oppressor"},
		{"opprobrious", "opprobri"},
		{"optic", "optic"},
		{"optical", "optic"},
		{"opulence", "opul"},
		{"opulent", "opul"},
		{"opuntia", "opuntia"},
		{"opuntias", "opuntia"},
		{"or", "or"},
		{"oracle", "oracl"},
		{"oracularly", "oracular"},
		{"oraison", "oraison"},
		{"orange", "orang"},
		{"orangeman", "orangeman"},
		{"oranges", "orang"},
		{"oration", "orat"},
		{"orations", "orat"},
		{"orator", "orat"},
		{"orators", "orat"},
		{"oratory", "oratori"},
		{"orb", "orb"},
		{"orbigny", "orbigni"},
		{"orbignyi", "orbignyi"},
		{"orbingy", "orbingi"},
		{"orchard", "orchard"},
		{"orchards", "orchard"},
		{"orchestra", "orchestra"},
		{"orchideae", "orchidea"},
		{"orchideous", "orchid"},
		{"orchids", "orchid"},
		{"orchis", "orchi"},
		{"ordained", "ordain"},
		{"ordeal", "ordeal"},
		{"order", "order"},
		{"ordered", "order"},
		{"ordering", "order"},
		{"orderly", "order"},
		{"orders", "order"},
		{"ordinance", "ordin"},
		{"ordinances", "ordin"},
		{"ordinarily", "ordinarili"},
		{"ordinary", "ordinari"},
		{"ore", "ore"},
		{"ores", "ore"},
		{"organ", "organ"},
		{"organic", "organ"},
		{"organically", "organ"},
		{"organisation", "organis"},
		{"organise", "organis"},
		{"organised", "organis"},
		{"organism", "organ"},
		{"organization", "organ"},
		{"organizations", "organ"},
		{"organized", "organ"},
		{"organs", "organ"},
		{"orgies", "orgi"},
		{"oriels", "oriel"},
		{"oriental", "orient"},
		{"orifice", "orific"},
		{"orifices", "orific"},
		{"origin", "origin"},
		{"original", "origin"},
		{"originality", "origin"},
		{"originally", "origin"},
		{"originals", "origin"},
		{"originate", "origin"},
		{"originated", "origin"},
		{"originates", "origin"},
		{"originating", "origin"},
		{"originatinin", "originatinin"},
		{"orinoco", "orinoco"},
		{"orlando", "orlando"},
		{"orlandos", "orlando"},
		{"ormolu", "ormolu"},
		{"ornament", "ornament"},
		{"ornamental", "ornament"},
		{"ornamented", "ornament"},
		{"ornamenting", "ornament"},
		{"ornaments", "ornament"},
		{"ornithologist", "ornithologist"},
		{"ornithologists", "ornithologist"},
		{"ornithology", "ornitholog"},
		{"ornithorhynchus", "ornithorhynchus"},
		{"orphan", "orphan"},
		{"orphaned", "orphan"},
		{"orphanhood", "orphanhood"},
		{"orphans", "orphan"},
		{"orpheus", "orpheus"},
		{"orsono", "orsono"},
		{"orth", "orth"},
		{"orthodox", "orthodox"},
		{"orthography", "orthographi"},
		{"orthoptera", "orthoptera"},
		{"oruro", "oruro"},
		{"oryctes", "oryct"},
		{"oryzivorus", "oryzivorus"},
		{"oscillated", "oscil"},
		{"oscillates", "oscil"},
		{"oscillating", "oscil"},
		{"oscillation", "oscil"},
		{"oscillations", "oscil"},
		{"osorno", "osorno"},
		{"ossemens", "ossemen"},
		{"osseous", "osseous"},
		{"ostend", "ostend"},
		{"ostensible", "ostens"},
		{"ostensibly", "ostens"},
		{"ostentation", "ostent"},
		{"ostentatious", "ostentati"},
		{"ostentatiously", "ostentati"},
		{"ostler", "ostler"},
		{"ostlers", "ostler"},
		{"ostrich", "ostrich"},
		{"ostriches", "ostrich"},
		{"ostrov", "ostrov"},
		{"oswald", "oswald"},
		{"osyth", "osyth"},
		{"otaheite", "otaheit"},
		{"othe", "oth"},
		{"othello", "othello"},
		{"other", "other"},
		{"othered", "other"},
		{"others", "other"},
		{"otherwise", "otherwis"},
		{"otter", "otter"},
		{"otters", "otter"},
		{"otto", "otto"},
		{"ottoman", "ottoman"},
		{"ottomans", "ottoman"},
		{"otus", "otus"},
		{"ou", "ou"},
		{"ought", "ought"},
		{"oughtn", "oughtn"},
		{"oughts", "ought"},
		{"ouly", "ouli"},
		{"oun", "oun"},
		{"ounce", "ounc"},
		{"ounces", "ounc"},
		{"our", "our"},
		{"ourangoutang", "ourangoutang"},
		{"ours", "our"},
		{"oursel", "oursel"},
		{"ourselves", "ourselv"},
		{"ouse", "ous"},
		{"ousting", "oust"},
		{"out", "out"},
		{"outbidden", "outbidden"},
		{"outbreak", "outbreak"},
		{"outburst", "outburst"},
		{"outcast", "outcast"},
		{"outcasts", "outcast"},
		{"outcries", "outcri"},
		{"outcry", "outcri"},
		{"outdie", "outdi"},
		{"outdone", "outdon"},
		{"outer", "outer"},
		{"outerest", "outerest"},
		{"outermost", "outermost"},
		{"outerside", "outersid"},
		{"outfit", "outfit"},
		{"outgoing", "outgo"},
		{"outgoings", "outgo"},
		{"outgrown", "outgrown"},
		{"outhouse", "outhous"},
		{"outlandish", "outlandish"},
		{"outlaw", "outlaw"},
		{"outlaws", "outlaw"},
		{"outlay", "outlay"},
		{"outlet", "outlet"},
		{"outlets", "outlet"},
		{"outliers", "outlier"},
		{"outline", "outlin"},
		{"outlines", "outlin"},
		{"outlive", "outliv"},
		{"outlived", "outliv"},
		{"outlook", "outlook"},
		{"outlying", "out"},
		{"outposts", "outpost"},
		{"outpouring", "outpour"},
		{"outpourings", "outpour"},
		{"outr", "outr"},
		{"outrage", "outrag"},
		{"outraged", "outrag"},
		{"outrageous", "outrag"},
		{"outrageously", "outrag"},
		{"outrages", "outrag"},
		{"outraging", "outrag"},
		{"outre", "outr"},
		{"outrigeously", "outrig"},
		{"outright", "outright"},
		{"outrun", "outrun"},
		{"outs", "out"},
		{"outset", "outset"},
		{"outshine", "outshin"},
		{"outshone", "outshon"},
		{"outside", "outsid"},
		{"outsider", "outsid"},
		{"outsiders", "outsid"},
		{"outsides", "outsid"},
		{"outskirting", "outskirt"},
		{"outskirts", "outskirt"},
		{"outspoken", "outspoken"},
		{"outspread", "outspread"},
		{"outstanding", "outstand"},
		{"outstep", "outstep"},
		{"outstretched", "outstretch"},
		{"outstripping", "outstrip"},
		{"outward", "outward"},
		{"outwardly", "outward"},
		{"outwards", "outward"},
		{"outweigh", "outweigh"},
		{"outweighed", "outweigh"},
		{"outweighing", "outweigh"},
		{"ova", "ova"},
		{"oval", "oval"},
		{"ovarium", "ovarium"},
		{"ove", "ove"},
		{"oven", "oven"},
		{"ovens", "oven"},
		{"over", "over"},
		{"overawe", "overaw"},
		{"overawed", "overaw"},
		{"overbalancing", "overbalanc"},
		{"overbearing", "overbear"},
		{"overblown", "overblown"},
		{"overboard", "overboard"},
		{"overborne", "overborn"},
		{"overburdened", "overburden"},
		{"overcame", "overcam"},
		{"overcast", "overcast"},
		{"overcoat", "overcoat"},
		{"overcome", "overcom"},
		{"overcoming", "overcom"},
		{"overcrowed", "overcrow"},
		{"overdid", "overdid"},
		{"overdo", "overdo"},
		{"overdoes", "overdo"},
		{"overdoing", "overdo"},
		{"overdone", "overdon"},
		{"overdriven", "overdriven"},
		{"overdue", "overdu"},
		{"overflow", "overflow"},
		{"overflowed", "overflow"},
		{"overflowing", "overflow"},
		{"overflows", "overflow"},
		{"overgrown", "overgrown"},
		{"overhanging", "overhang"},
		{"overhangs", "overhang"},
		{"overhaul", "overhaul"},
		{"overhead", "overhead"},
		{"overhear", "overhear"},
		{"overheard", "overheard"},
		{"overhearing", "overhear"},
		{"overhung", "overhung"},
		{"overjoyed", "overjoy"},
		{"overlaid", "overlaid"},
		{"overleap", "overleap"},
		{"overleaping", "overleap"},
		{"overloaded", "overload"},
		{"overlook", "overlook"},
		{"overlooked", "overlook"},
		{"overlookers", "overlook"},
		{"overlooking", "overlook"},
		{"overlying", "over"},
		{"overmuch", "overmuch"},
		{"overnight", "overnight"},
		{"overpowered", "overpow"},
		{"overpowering", "overpow"},
		{"overpoweringly", "overpow"},
		{"overpowers", "overpow"},
		{"overrated", "overr"},
		{"overreached", "overreach"},
		{"overreaching", "overreach"},
		{"overruled", "overrul"},
		{"overrun", "overrun"},
		{"overset", "overset"},
		{"overshadowed", "overshadow"},
		{"overshadowing", "overshadow"},
		{"overshadows", "overshadow"},
		{"oversleep", "oversleep"},
		{"oversleeping", "oversleep"},
		{"overslept", "overslept"},
		{"overspreading", "overspread"},
		{"overspreads", "overspread"},
		{"overstated", "overst"},
		{"overstating", "overst"},
		{"overstep", "overstep"},
		{"overstepped", "overstep"},
		{"overstepping", "overstep"},
		{"overstrained", "overstrain"},
		{"overtake", "overtak"},
		{"overtaken", "overtaken"},
		{"overtakes", "overtak"},
		{"overtaking", "overtak"},
		{"overtask", "overtask"},
		{"overtasked", "overtask"},
		{"overthrew", "overthrew"},
		{"overthrow", "overthrow"},
		{"overthrown", "overthrown"},
		{"overthrows", "overthrow"},
		{"overtime", "overtim"},
		{"overtook", "overtook"},
		{"overtures", "overtur"},
		{"overturn", "overturn"},
		{"overturned", "overturn"},
		{"overturning", "overturn"},
		{"overturns", "overturn"},
		{"overweening", "overween"},
		{"overwhelm", "overwhelm"},
		{"overwhelmed", "overwhelm"},
		{"overwhelming", "overwhelm"},
		{"overwhelmingly", "overwhelm"},
		{"overwhelms", "overwhelm"},
		{"overworked", "overwork"},
		{"overwrought", "overwrought"},
		{"ovules", "ovul"},
		{"ow", "ow"},
		{"owdacious", "owdaci"},
		{"owe", "owe"},
		{"owed", "owe"},
		{"owen", "owen"},
		{"ower", "ower"},
		{"owes", "owe"},
		{"owing", "owe"},
		{"owl", "owl"},
		{"owlish", "owlish"},
		{"owls", "owl"},
		{"own", "own"},
		{"owned", "own"},
		{"owner", "owner"},
		{"owners", "owner"},
		{"ownership", "ownership"},
		{"owning", "own"},
		{"owns", "own"},
		{"owor", "owor"},
		{"ox", "ox"},
		{"oxen", "oxen"},
		{"oxford", "oxford"},
		{"oxidate", "oxid"},
		{"oxides", "oxid"},
		{"oxyurus", "oxyurus"},
		{"oyster", "oyster"},
		{"oysters", "oyster"},
		{"p", "p"},
		{"pa", "pa"},
		{"pace", "pace"},
		{"paced", "pace"},
		{"paces", "pace"},
		{"pachydermata", "pachydermata"},
		{"pachydermatous", "pachydermat"},
		{"pachydermous", "pachyderm"},
		{"pacific", "pacif"},
		{"pacified", "pacifi"},
		{"pacify", "pacifi"},
		{"pacifying", "pacifi"},
		{"pacing", "pace"},
		{"pack", "pack"},
		{"package", "packag"},
		{"packages", "packag"},
		{"packed", "pack"},
		{"packer", "packer"},
		{"packet", "packet"},
		{"packets", "packet"},
		{"packhorse", "packhors"},
		{"packing", "pack"},
		{"packs", "pack"},
		{"pad", "pad"},
		{"padded", "pad"},
		{"paddled", "paddl"},
		{"paddles", "paddl"},
		{"paddling", "paddl"},
		{"paddock", "paddock"},
		{"padlock", "padlock"},
		{"padlocked", "padlock"},
		{"padlocking", "padlock"},
		{"padre", "padr"},
		{"padres", "padr"},
		{"pagan", "pagan"},
		{"page", "page"},
		{"pageant", "pageant"},
		{"pageants", "pageant"},
		{"pages", "page"},
		{"pah", "pah"},
		{"pahia", "pahia"},
		{"paid", "paid"},
		{"pail", "pail"},
		{"pailfuls", "pail"},
		{"pain", "pain"},
		{"pained", "pain"},
		{"painful", "pain"},
		{"painfullest", "painfullest"},
		{"painfully", "pain"},
		{"pains", "pain"},
		{"painstaking", "painstak"},
		{"paint", "paint"},
		{"painted", "paint"},
		{"painter", "painter"},
		{"painters", "painter"},
		{"painting", "paint"},
		{"paintings", "paint"},
		{"paints", "paint"},
		{"pair", "pair"},
		{"paired", "pair"},
		{"pairing", "pair"},
		{"pairs", "pair"},
		{"palace", "palac"},
		{"palaces", "palac"},
		{"paladin", "paladin"},
		{"palaeologos", "palaeologo"},
		{"palaeotherium", "palaeotherium"},
		{"palais", "palai"},
		{"palanquin", "palanquin"},
		{"palatable", "palat"},
		{"palate", "palat"},
		{"palates", "palat"},
		{"pale", "pale"},
		{"paled", "pale"},
		{"palely", "pale"},
		{"paleness", "pale"},
		{"paler", "paler"},
		{"palings", "pale"},
		{"pall", "pall"},
		{"palladium", "palladium"},
		{"pallas", "palla"},
		{"palliate", "palliat"},
		{"palliated", "palliat"},
		{"palliation", "palliat"},
		{"pallid", "pallid"},
		{"palliser", "pallis"},
		{"pallisers", "pallis"},
		{"pallor", "pallor"},
		{"palm", "palm"},
		{"palmer", "palmer"},
		{"palmerston", "palmerston"},
		{"palmes", "palm"},
		{"palms", "palm"},
		{"palmy", "palmi"},
		{"palpable", "palpabl"},
		{"palpably", "palpabl"},
		{"palpitate", "palpit"},
		{"palpitated", "palpit"},
		{"palpitating", "palpit"},
		{"palpitation", "palpit"},
		{"palpitations", "palpit"},
		{"pals", "pal"},
		{"palsy", "palsi"},
		{"paltry", "paltri"},
		{"paludina", "paludina"},
		{"pampaean", "pampaean"},
		{"pampas", "pampa"},
		{"pampean", "pampean"},
		{"pamper", "pamper"},
		{"pampered", "pamper"},
		{"pamphlet", "pamphlet"},
		{"pamphlets", "pamphlet"},
		{"pamplemousses", "pamplemouss"},
		{"pan", "pan"},
		{"panacea", "panacea"},
		{"panama", "panama"},
		{"pancake", "pancak"},
		{"pancakes", "pancak"},
		{"pandanus", "pandanus"},
		{"pandemoniac", "pandemoniac"},
		{"pandemonium", "pandemonium"},
		{"pane", "pane"},
		{"panel", "panel"},
		{"panelled", "panel"},
		{"panelling", "panel"},
		{"panels", "panel"},
		{"panes", "pane"},
		{"pang", "pang"},
		{"pangs", "pang"},
		{"pani", "pani"},
		{"panic", "panic"},
		{"panics", "panic"},
		{"panke", "pank"},
		{"pannikins", "pannikin"},
		{"panoply", "panopli"},
		{"panorama", "panorama"},
		{"pans", "pan"},
		{"pansies", "pansi"},
		{"pant", "pant"},
		{"pantaloons", "pantaloon"},
		{"panted", "pant"},
		{"panther", "panther"},
		{"panting", "pant"},
		{"pantomime", "pantomim"},
		{"pantomimes", "pantomim"},
		{"pantomimist", "pantomimist"},
		{"pantry", "pantri"},
		{"pants", "pant"},
		{"panza", "panza"},
		{"papa", "papa"},
		{"papal", "papal"},
		{"papawa", "papawa"},
		{"paper", "paper"},
		{"papered", "paper"},
		{"papering", "paper"},
		{"papers", "paper"},
		{"papiete", "papiet"},
		{"papilio", "papilio"},
		{"papillae", "papilla"},
		{"papin", "papin"},
		{"papist", "papist"},
		{"paposo", "paposo"},
		{"par", "par"},
		{"parable", "parabl"},
		{"parabola", "parabola"},
		{"parade", "parad"},
		{"paraded", "parad"},
		{"parades", "parad"},
		{"paradise", "paradis"},
		{"paradox", "paradox"},
		{"paradoxical", "paradox"},
		{"paradoxus", "paradoxus"},
		{"paragon", "paragon"},
		{"paragraph", "paragraph"},
		{"paragraphs", "paragraph"},
		{"paraguay", "paraguay"},
		{"parallel", "parallel"},
		{"parallelism", "parallel"},
		{"paralyse", "paralys"},
		{"paralysed", "paralys"},
		{"paralysis", "paralysi"},
		{"paralytic", "paralyt"},
		{"paramatta", "paramatta"},
		{"paramount", "paramount"},
		{"parana", "parana"},
		{"parapet", "parapet"},
		{"parapets", "parapet"},
		{"parasha", "parasha"},
		{"parasite", "parasit"},
		{"parasites", "parasit"},
		{"parasitic", "parasit"},
		{"parasitical", "parasit"},
		{"parasol", "parasol"},
		{"parasols", "parasol"},
		{"parcel", "parcel"},
		{"parcels", "parcel"},
		{"parchappe", "parchapp"},
		{"parched", "parch"},
		{"parchment", "parchment"},
		{"parchments", "parchment"},
		{"parchmentses", "parchments"},
		{"pardiggle", "pardiggl"},
		{"pardiggles", "pardiggl"},
		{"pardon", "pardon"},
		{"pardonable", "pardon"},
		{"pardoned", "pardon"},
		{"pardoning", "pardon"},
		{"pardons", "pardon"},
		{"pared", "pare"},
		{"parenchymatous", "parenchymat"},
		{"parent", "parent"},
		{"parentage", "parentag"},
		{"parental", "parent"},
		{"parentheses", "parenthes"},
		{"parenthesis", "parenthesi"},
		{"parenthetically", "parenthet"},
		{"parents", "parent"},
		{"pariah", "pariah"},
		{"paris", "pari"},
		{"parish", "parish"},
		{"parishes", "parish"},
		{"parishioner", "parishion"},
		{"parisian", "parisian"},
		{"parisians", "parisian"},
		{"park", "park"},
		{"parker", "parker"},
		{"parkers", "parker"},
		{"parks", "park"},
		{"parlance", "parlanc"},
		{"parlay", "parlay"},
		{"parlaying", "parlay"},
		{"parley", "parley"},
		{"parlez", "parlez"},
		{"parliament", "parliament"},
		{"parliamentary", "parliamentari"},
		{"parliaments", "parliament"},
		{"parlour", "parlour"},
		{"parlours", "parlour"},
		{"parochial", "parochi"},
		{"parole", "parol"},
		{"paroxysm", "paroxysm"},
		{"paroxysms", "paroxysm"},
		{"parried", "parri"},
		{"parrot", "parrot"},
		{"parrots", "parrot"},
		{"parry", "parri"},
		{"parsimonious", "parsimoni"},
		{"parsimony", "parsimoni"},
		{"parsley", "parsley"},
		{"parson", "parson"},
		{"parsonage", "parsonag"},
		{"part", "part"},
		{"partake", "partak"},
		{"partaken", "partaken"},
		{"partaker", "partak"},
		{"partakes", "partak"},
		{"partaking", "partak"},
		{"parted", "part"},
		{"parterre", "parterr"},
		{"parthenon", "parthenon"},
		{"parti", "parti"},
		{"partial", "partial"},
		{"partiality", "partial"},
		{"partially", "partial"},
		{"participate", "particip"},
		{"participated", "particip"},
		{"participation", "particip"},
		{"particle", "particl"},
		{"particles", "particl"},
		{"particular", "particular"},
		{"particularised", "particularis"},
		{"particularity", "particular"},
		{"particularly", "particular"},
		{"particulars", "particular"},
		{"parties", "parti"},
		{"parting", "part"},
		{"partings", "part"},
		{"partisans", "partisan"},
		{"partisanship", "partisanship"},
		{"partition", "partit"},
		{"partitioned", "partit"},
		{"partitions", "partit"},
		{"partly", "part"},
		{"partner", "partner"},
		{"partners", "partner"},
		{"partnership", "partnership"},
		{"partnerships", "partnership"},
		{"partook", "partook"},
		{"partridge", "partridg"},
		{"partridges", "partridg"},
		{"parts", "part"},
		{"party", "parti"},
		{"parvula", "parvula"},
		{"parvulus", "parvulus"},
		{"pas", "pas"},
		{"pashenka", "pashenka"},
		{"pass", "pass"},
		{"passable", "passabl"},
		{"passage", "passag"},
		{"passages", "passag"},
		{"passed", "pass"},
		{"passee", "passe"},
		{"passees", "passe"},
		{"passenger", "passeng"},
		{"passengers", "passeng"},
		{"passer", "passer"},
		{"passerby", "passerbi"},
		{"passers", "passer"},
		{"passes", "pass"},
		{"passin", "passin"},
		{"passing", "pass"},
		{"passion", "passion"},
		{"passionate", "passion"},
		{"passionately", "passion"},
		{"passionless", "passionless"},
		{"passions", "passion"},
		{"passive", "passiv"},
		{"passively", "passiv"},
		{"passport", "passport"},
		{"passports", "passport"},
		{"passwords", "password"},
		{"past", "past"},
		{"pasteboard", "pasteboard"},
		{"pasted", "past"},
		{"pasthry", "pasthri"},
		{"pastime", "pastim"},
		{"pastoral", "pastor"},
		{"pastors", "pastor"},
		{"pastry", "pastri"},
		{"pastrycook", "pastrycook"},
		{"pasturage", "pasturag"},
		{"pasture", "pastur"},
		{"pastures", "pastur"},
		{"pasty", "pasti"},
		{"pat", "pat"},
		{"patachonica", "patachonica"},
		{"patagones", "patagon"},
		{"patagonia", "patagonia"},
		{"patagonian", "patagonian"},
		{"patagonians", "patagonian"},
		{"patagonica", "patagonica"},
		{"patagonicus", "patagonicus"},
		{"patch", "patch"},
		{"patched", "patch"},
		{"patches", "patch"},
		{"patchwork", "patchwork"},
		{"patellae", "patella"},
		{"patelliform", "patelliform"},
		{"patent", "patent"},
		{"paternal", "patern"},
		{"paternally", "patern"},
		{"path", "path"},
		{"pathetic", "pathet"},
		{"pathetically", "pathet"},
		{"pathetics", "pathet"},
		{"pathos", "patho"},
		{"paths", "path"},
		{"pathway", "pathway"},
		{"pathways", "pathway"},
		{"patience", "patienc"},
		{"patient", "patient"},
		{"patienter", "patient"},
		{"patiently", "patient"},
		{"patients", "patient"},
		{"patriarch", "patriarch"},
		{"patriarchal", "patriarch"},
		{"patriarchs", "patriarch"},
		{"patrician", "patrician"},
		{"patrick", "patrick"},
		{"patrimonial", "patrimoni"},
		{"patrimony", "patrimoni"},
		{"patriot", "patriot"},
		{"patriotic", "patriot"},
		{"patriotism", "patriot"},
		{"patrolling", "patrol"},
		{"patron", "patron"},
		{"patronage", "patronag"},
		{"patroness", "patro"},
		{"patronesses", "patro"},
		{"patronise", "patronis"},
		{"patronised", "patronis"},
		{"patronising", "patronis"},
		{"patronize", "patron"},
		{"patronized", "patron"},
		{"patronizing", "patron"},
		{"patronizingly", "patron"},
		{"patrons", "patron"},
		{"pats", "pat"},
		{"patted", "pat"},
		{"pattening", "patten"},
		{"pattens", "patten"},
		{"patter", "patter"},
		{"pattered", "patter"},
		{"pattering", "patter"},
		{"pattern", "pattern"},
		{"patternless", "patternless"},
		{"patterns", "pattern"},
		{"patting", "pat"},
		{"patula", "patula"},
		{"paucity", "pauciti"},
		{"paul", "paul"},
		{"pauline", "paulin"},
		{"paunch", "paunch"},
		{"paunchy", "paunchi"},
		{"pauper", "pauper"},
		{"paupers", "pauper"},
		{"pause", "paus"},
		{"paused", "paus"},
		{"pauses", "paus"},
		{"pausilippo", "pausilippo"},
		{"pausing", "paus"},
		{"pave", "pave"},
		{"paved", "pave"},
		{"pavement", "pavement"},
		{"pavements", "pavement"},
		{"pavilion", "pavilion"},
		{"paving", "pave"},
		{"paviour", "paviour"},
		{"pavlitch", "pavlitch"},
		{"pavlovitch", "pavlovitch"},
		{"pavlovna", "pavlovna"},
		{"paw", "paw"},
		{"pawn", "pawn"},
		{"pawnbroker", "pawnbrok"},
		{"pawnbrokers", "pawnbrok"},
		{"pawned", "pawn"},
		{"paws", "paw"},
		{"pay", "pay"},
		{"payable", "payabl"},
		{"paying", "pay"},
		{"payment", "payment"},
		{"payments", "payment"},
		{"paypote", "paypot"},
		{"pays", "pay"},
		{"pe", "pe"},
		{"pea", "pea"},
		{"peace", "peac"},
		{"peaceable", "peaceabl"},
		{"peaceably", "peaceabl"},
		{"peaceful", "peac"},
		{"peacefully", "peac"},
		{"peacefulness", "peac"},
		{"peach", "peach"},
		{"peaches", "peach"},
		{"peachy", "peachi"},
		{"peacock", "peacock"},
		{"peacocks", "peacock"},
		{"peak", "peak"},
		{"peaked", "peak"},
		{"peaks", "peak"},
		{"peal", "peal"},
		{"pealed", "peal"},
		{"peals", "peal"},
		{"pear", "pear"},
		{"pearl", "pearl"},
		{"pearls", "pearl"},
		{"pearly", "pear"},
		{"pears", "pear"},
		{"peas", "pea"},
		{"peasant", "peasant"},
		{"peasantry", "peasantri"},
		{"peasants", "peasant"},
		{"pease", "peas"},
		{"peat", "peat"},
		{"peaty", "peati"},
		{"pebble", "pebbl"},
		{"pebbles", "pebbl"},
		{"pecado", "pecado"},
		{"peccari", "peccari"},
		{"peccaries", "peccari"},
		{"peccet", "peccet"},
		{"peck", "peck"},
		{"pecker", "pecker"},
		{"pecking", "peck"},
		{"pecoris", "pecori"},
		{"pectoral", "pector"},
		{"peculation", "pecul"},
		{"peculiar", "peculiar"},
		{"peculiarities", "peculiar"},
		{"peculiarity", "peculiar"},
		{"peculiarly", "peculiar"},
		{"pecuniarily", "pecuniarili"},
		{"pecuniary", "pecuniari"},
		{"pedagogue", "pedagogu"},
		{"pedantry", "pedantri"},
		{"pedestal", "pedest"},
		{"pedestrian", "pedestrian"},
		{"pedigree", "pedigre"},
		{"pediment", "pediment"},
		{"pedlar", "pedlar"},
		{"pedlars", "pedlar"},
		{"pedro", "pedro"},
		{"peel", "peel"},
		{"peeled", "peel"},
		{"peeling", "peel"},
		{"peep", "peep"},
		{"peeped", "peep"},
		{"peeping", "peep"},
		{"peeps", "peep"},
		{"peepy", "peepi"},
		{"peer", "peer"},
		{"peerage", "peerag"},
		{"peerages", "peerag"},
		{"peered", "peer"},
		{"peeresses", "peeress"},
		{"peering", "peer"},
		{"peerless", "peerless"},
		{"peers", "peer"},
		{"peevish", "peevish"},
		{"peevishly", "peevish"},
		{"peevishness", "peevish"},
		{"peewit", "peewit"},
		{"peewits", "peewit"},
		{"peffer", "peffer"},
		{"peg", "peg"},
		{"pegasus", "pegasus"},
		{"pegged", "peg"},
		{"pegs", "peg"},
		{"pelacanoides", "pelacanoid"},
		{"pelagic", "pelag"},
		{"pelham", "pelham"},
		{"pelisse", "peliss"},
		{"pell", "pell"},
		{"pelt", "pelt"},
		{"pelted", "pelt"},
		{"pelting", "pelt"},
		{"peltirogus", "peltirogus"},
		{"peltiroguses", "peltirogus"},
		{"peludo", "peludo"},
		{"pembroke", "pembrok"},
		{"pen", "pen"},
		{"penal", "penal"},
		{"penalties", "penalti"},
		{"penalty", "penalti"},
		{"penance", "penanc"},
		{"penas", "pena"},
		{"pence", "penc"},
		{"pencil", "pencil"},
		{"pencilled", "pencil"},
		{"pencils", "pencil"},
		{"pendant", "pendant"},
		{"pending", "pend"},
		{"pendulum", "pendulum"},
		{"penetrable", "penetr"},
		{"penetrate", "penetr"},
		{"penetrated", "penetr"},
		{"penetrates", "penetr"},
		{"penetrating", "penetr"},
		{"penetration", "penetr"},
		{"penguin", "penguin"},
		{"penguins", "penguin"},
		{"peninsula", "peninsula"},
		{"peninsular", "peninsular"},
		{"penitence", "penit"},
		{"penitent", "penit"},
		{"penitential", "penitenti"},
		{"penitents", "penit"},
		{"penknife", "penknif"},
		{"penn", "penn"},
		{"penned", "pen"},
		{"penniless", "penniless"},
		{"penny", "penni"},
		{"pennyworth", "pennyworth"},
		{"pens", "pen"},
		{"pension", "pension"},
		{"pensioner", "pension"},
		{"pensioners", "pension"},
		{"pensioning", "pension"},
		{"pensions", "pension"},
		{"pensive", "pensiv"},
		{"pensively", "pensiv"},
		{"pensiveness", "pensiv"},
		{"pent", "pent"},
		{"pentland", "pentland"},
		{"penton", "penton"},
		{"pentonville", "pentonvill"},
		{"penultimate", "penultim"},
		{"penury", "penuri"},
		{"peony", "peoni"},
		{"people", "peopl"},
		{"peopled", "peopl"},
		{"peoples", "peopl"},
		{"pepper", "pepper"},
		{"pepsis", "pepsi"},
		{"per", "per"},
		{"perceive", "perceiv"},
		{"perceived", "perceiv"},
		{"perceives", "perceiv"},
		{"perceiving", "perceiv"},
		{"percent", "percent"},
		{"percentage", "percentag"},
		{"percentages", "percentag"},
		{"perceptible", "percept"},
		{"perceptibly", "percept"},
		{"perception", "percept"},
		{"perceptions", "percept"},
		{"percepts", "percept"},
		{"perch", "perch"},
		{"percha", "percha"},
		{"perchance", "perchanc"},
		{"perched", "perch"},
		{"perches", "perch"},
		{"percival", "perciv"},
		{"percolates", "percol"},
		{"percolating", "percol"},
		{"percolation", "percol"},
		{"percy", "perci"},
		{"perdition", "perdit"},
		{"peremptorily", "peremptorili"},
		{"peremptory", "peremptori"},
		{"perennial", "perenni"},
		{"perennially", "perenni"},
		{"perfecfly", "perfecfli"},
		{"perfect", "perfect"},
		{"perfected", "perfect"},
		{"perfection", "perfect"},
		{"perfections", "perfect"},
		{"perfectly", "perfect"},
		{"perfidy", "perfidi"},
		{"perforate", "perfor"},
		{"perforated", "perfor"},
		{"perforce", "perforc"},
		{"perform", "perform"},
		{"performance", "perform"},
		{"performances", "perform"},
		{"performed", "perform"},
		{"performer", "perform"},
		{"performers", "perform"},
		{"performing", "perform"},
		{"performs", "perform"},
		{"perfume", "perfum"},
		{"perfumed", "perfum"},
		{"perfumery", "perfumeri"},
		{"perfumes", "perfum"},
		{"perhaps", "perhap"},
		{"periagua", "periagua"},
		{"perianth", "perianth"},
		{"pericardium", "pericardium"},
		{"peril", "peril"},
		{"perilled", "peril"},
		{"perilous", "peril"},
		{"perilously", "peril"},
		{"perils", "peril"},
		{"period", "period"},
		{"periodical", "period"},
		{"periodically", "period"},
		{"periodicals", "period"},
		{"periods", "period"},
		{"perish", "perish"},
		{"perishable", "perish"},
		{"perished", "perish"},
		{"perishing", "perish"},
		{"perjured", "perjur"},
		{"perjury", "perjuri"},
		{"perkins", "perkin"},
		{"perlen", "perlen"},
		{"permanence", "perman"},
		{"permanent", "perman"},
		{"permanently", "perman"},
		{"permeated", "permeat"},
		{"permissable", "permiss"},
		{"permissible", "permiss"},
		{"permission", "permiss"},
		{"permit", "permit"},
		{"permitted", "permit"},
		{"permitting", "permit"},
		{"pernambuco", "pernambuco"},
		{"pernety", "perneti"},
		{"pernicious", "pernici"},
		{"peron", "peron"},
		{"peroration", "peror"},
		{"perpendicular", "perpendicular"},
		{"perpendicularly", "perpendicular"},
		{"perpetrated", "perpetr"},
		{"perpetration", "perpetr"},
		{"perpetrator", "perpetr"},
		{"perpetrators", "perpetr"},
		{"perpetual", "perpetu"},
		{"perpetually", "perpetu"},
		{"perpetuate", "perpetu"},
		{"perpetuated", "perpetu"},
		{"perpetuating", "perpetu"},
		{"perpetuity", "perpetu"},
		{"perplex", "perplex"},
		{"perplexed", "perplex"},
		{"perplexing", "perplex"},
		{"perplexities", "perplex"},
		{"perplexity", "perplex"},
		{"perquisition", "perquisit"},
		{"perquisitions", "perquisit"},
		{"pers", "per"},
		{"persecute", "persecut"},
		{"persecuted", "persecut"},
		{"persecuting", "persecut"},
		{"persecution", "persecut"},
		{"persecutions", "persecut"},
		{"persecutor", "persecutor"},
		{"persecutors", "persecutor"},
		{"perseverance", "persever"},
		{"persevere", "persever"},
		{"persevered", "persev"},
		{"perseveres", "persever"},
		{"persevering", "persev"},
		{"perseveringly", "persev"},
		{"persia", "persia"},
		{"persian", "persian"},
		{"persist", "persist"},
		{"persisted", "persist"},
		{"persistence", "persist"},
		{"persistency", "persist"},
		{"persistent", "persist"},
		{"persistently", "persist"},
		{"persisting", "persist"},
		{"persists", "persist"},
		{"person", "person"},
		{"personage", "personag"},
		{"personages", "personag"},
		{"personal", "person"},
		{"personality", "person"},
		{"personally", "person"},
		{"personate", "person"},
		{"personated", "person"},
		{"personification", "personif"},
		{"personified", "personifi"},
		{"persons", "person"},
		{"perspective", "perspect"},
		{"perspiration", "perspir"},
		{"perspired", "perspir"},
		{"perspires", "perspir"},
		{"persuadable", "persuad"},
		{"persuade", "persuad"},
		{"persuaded", "persuad"},
		{"persuading", "persuad"},
		{"persuasion", "persuas"},
		{"persuasions", "persuas"},
		{"persuasive", "persuas"},
		{"persuasively", "persuas"},
		{"pert", "pert"},
		{"perthshire", "perthshir"},
		{"pertinacious", "pertinaci"},
		{"pertinaciously", "pertinaci"},
		{"pertinacity", "pertinac"},
		{"perturbation", "perturb"},
		{"perturbed", "perturb"},
		{"peru", "peru"},
		{"perusal", "perus"},
		{"perusals", "perus"},
		{"peruse", "perus"},
		{"perused", "perus"},
		{"perusing", "perus"},
		{"peruvian", "peruvian"},
		{"peruvians", "peruvian"},
		{"pervade", "pervad"},
		{"pervaded", "pervad"},
		{"pervades", "pervad"},
		{"pervading", "pervad"},
		{"perverse", "pervers"},
		{"perversely", "pervers"},
		{"perverseness", "pervers"},
		{"perversion", "pervers"},
		{"perversity", "pervers"},
		{"perverted", "pervert"},
		{"pervious", "pervious"},
		{"perwerse", "perwers"},
		{"peski", "peski"},
		{"pest", "pest"},
		{"pester", "pester"},
		{"pestered", "pester"},
		{"pestering", "pester"},
		{"pestiferous", "pestifer"},
		{"pestilence", "pestil"},
		{"pestilent", "pestil"},
		{"pestilential", "pestilenti"},
		{"pestle", "pestl"},
		{"pestryakov", "pestryakov"},
		{"pet", "pet"},
		{"petals", "petal"},
		{"peter", "peter"},
		{"petersburg", "petersburg"},
		{"petersham", "petersham"},
		{"petioles", "petiol"},
		{"petise", "petis"},
		{"petises", "petis"},
		{"petition", "petit"},
		{"petitioned", "petit"},
		{"petitioners", "petition"},
		{"petitioning", "petit"},
		{"petitions", "petit"},
		{"petorca", "petorca"},
		{"petowker", "petowk"},
		{"petrel", "petrel"},
		{"petrels", "petrel"},
		{"petrified", "petrifi"},
		{"petrovitch", "petrovitch"},
		{"petrovna", "petrovna"},
		{"petrovsky", "petrovski"},
		{"petruchio", "petruchio"},
		{"pets", "pet"},
		{"petted", "pet"},
		{"petticoat", "petticoat"},
		{"petticoats", "petticoat"},
		{"pettifoggers", "pettifogg"},
		{"pettifogging", "pettifog"},
		{"pettiness", "petti"},
		{"petting", "pet"},
		{"pettish", "pettish"},
		{"pettishly", "pettish"},
		{"petty", "petti"},
		{"petulance", "petul"},
		{"petulant", "petul"},
		{"petulantly", "petul"},
		{"peuquenes", "peuquen"},
		{"pew", "pew"},
		{"pewter", "pewter"},
		{"pfoo", "pfoo"},
		{"phaeton", "phaeton"},
		{"phairy", "phairi"},
		{"phalanstery", "phalansteri"},
		{"phallus", "phallus"},
		{"phanaeus", "phanaeus"},
		{"phantom", "phantom"},
		{"phantoms", "phantom"},
		{"pharaoh", "pharaoh"},
		{"pharisees", "pharise"},
		{"phases", "phase"},
		{"pheasants", "pheasant"},
		{"phenomena", "phenomena"},
		{"phenomenal", "phenomen"},
		{"phenomenally", "phenomen"},
		{"phenomenes", "phenomen"},
		{"phenomenon", "phenomenon"},
		{"phenomenons", "phenomenon"},
		{"phew", "phew"},
		{"phib", "phib"},
		{"phil", "phil"},
		{"philandering", "philand"},
		{"philanthropic", "philanthrop"},
		{"philanthropical", "philanthrop"},
		{"philanthropist", "philanthropist"},
		{"philanthropists", "philanthropist"},
		{"philanthropy", "philanthropi"},
		{"philip", "philip"},
		{"philippe", "philipp"},
		{"philippines", "philippin"},
		{"phillippensis", "phillippensi"},
		{"philo", "philo"},
		{"philos", "philo"},
		{"philosoph", "philosoph"},
		{"philosopher", "philosoph"},
		{"philosophers", "philosoph"},
		{"philosophical", "philosoph"},
		{"philosophically", "philosoph"},
		{"philosophies", "philosophi"},
		{"philosophy", "philosophi"},
		{"phineas", "phinea"},
		{"phlegmatic", "phlegmat"},
		{"pho", "pho"},
		{"phoebe", "phoeb"},
		{"phoenix", "phoenix"},
		{"phonolite", "phonolit"},
		{"phosphate", "phosphat"},
		{"phosphorescence", "phosphoresc"},
		{"phosphorescent", "phosphoresc"},
		{"phosphoric", "phosphor"},
		{"phosphorus", "phosphorus"},
		{"phosphuretted", "phosphuret"},
		{"photographer", "photograph"},
		{"phrase", "phrase"},
		{"phrased", "phrase"},
		{"phraseology", "phraseolog"},
		{"phrases", "phrase"},
		{"phrenological", "phrenolog"},
		{"phryniscus", "phryniscus"},
		{"physalia", "physalia"},
		{"physic", "physic"},
		{"physical", "physic"},
		{"physically", "physic"},
		{"physician", "physician"},
		{"physicians", "physician"},
		{"physicking", "physick"},
		{"physiognomist", "physiognomist"},
		{"physiognomy", "physiognomi"},
		{"physiol", "physiol"},
		{"physiological", "physiolog"},
		{"physiology", "physiolog"},
		{"physique", "physiqu"},
		{"phytolitharia", "phytolitharia"},
		{"piano", "piano"},
		{"pianoforte", "pianofort"},
		{"pianos", "piano"},
		{"picaninnies", "picaninni"},
		{"picaninny", "picaninni"},
		{"piccadilly", "piccadilli"},
		{"pichy", "pichi"},
		{"pick", "pick"},
		{"pickaxe", "pickax"},
		{"picked", "pick"},
		{"pickers", "picker"},
		{"picking", "pick"},
		{"pickings", "pick"},
		{"pickle", "pickl"},
		{"pickled", "pickl"},
		{"pickles", "pickl"},
		{"pickling", "pickl"},
		{"pickpocket", "pickpocket"},
		{"pickpockets", "pickpocket"},
		{"picks", "pick"},
		{"pickwick", "pickwick"},
		{"picnic", "picnic"},
		{"picnics", "picnic"},
		{"picter", "picter"},
		{"pictorial", "pictori"},
		{"picture", "pictur"},
		{"pictured", "pictur"},
		{"pictures", "pictur"},
		{"picturesque", "picturesqu"},
		{"picturing", "pictur"},
		{"piderit", "piderit"},
		{"pie", "pie"},
		{"piebald", "piebald"},
		{"piebalds", "piebald"},
		{"piece", "piec"},
		{"pieced", "piec"},
		{"piecemeal", "piecem"},
		{"pieces", "piec"},
		{"piecework", "piecework"},
		{"pieman", "pieman"},
		{"pier", "pier"},
		{"pierce", "pierc"},
		{"pierced", "pierc"},
		{"pierces", "pierc"},
		{"piercing", "pierc"},
		{"piercingly", "pierc"},
		{"pierre", "pierr"},
		{"pierres", "pierr"},
		{"piers", "pier"},
		{"pies", "pie"},
		{"pietras", "pietra"},
		{"piety", "pieti"},
		{"pig", "pig"},
		{"pigeon", "pigeon"},
		{"pigeons", "pigeon"},
		{"pigmies", "pigmi"},
		{"pigmy", "pigmi"},
		{"pigs", "pig"},
		{"pigsties", "pigsti"},
		{"pigtail", "pigtail"},
		{"pigtails", "pigtail"},
		{"pikestaff", "pikestaff"},
		{"pile", "pile"},
		{"piled", "pile"},
		{"piles", "pile"},
		{"pilfering", "pilfer"},
		{"pilger", "pilger"},
		{"pilgrim", "pilgrim"},
		{"pilgrimage", "pilgrimag"},
		{"piling", "pile"},
		{"pill", "pill"},
		{"pillar", "pillar"},
		{"pillars", "pillar"},
		{"pillow", "pillow"},
		{"pillowed", "pillow"},
		{"pillows", "pillow"},
		{"pills", "pill"},
		{"pilot", "pilot"},
		{"piloted", "pilot"},
		{"pilots", "pilot"},
		{"pimlico", "pimlico"},
		{"pimple", "pimpl"},
		{"pimples", "pimpl"},
		{"pimply", "pimpli"},
		{"pin", "pin"},
		{"pinafore", "pinafor"},
		{"pincers", "pincer"},
		{"pinch", "pinch"},
		{"pinched", "pinch"},
		{"pincheira", "pincheira"},
		{"pinches", "pinch"},
		{"pinching", "pinch"},
		{"pincushions", "pincushion"},
		{"pine", "pine"},
		{"pineapple", "pineappl"},
		{"pined", "pine"},
		{"pines", "pine"},
		{"pining", "pine"},
		{"pinion", "pinion"},
		{"pinions", "pinion"},
		{"pink", "pink"},
		{"pinked", "pink"},
		{"pinker", "pinker"},
		{"pinkish", "pinkish"},
		{"pinnace", "pinnac"},
		{"pinnacle", "pinnacl"},
		{"pinnacled", "pinnacl"},
		{"pinnacles", "pinnacl"},
		{"pinned", "pin"},
		{"pinning", "pin"},
		{"pins", "pin"},
		{"pint", "pint"},
		{"pints", "pint"},
		{"pious", "pious"},
		{"pipe", "pipe"},
		{"pipeclayed", "pipeclay"},
		{"pipelight", "pipelight"},
		{"piper", "piper"},
		{"pipes", "pipe"},
		{"piping", "pipe"},
		{"pips", "pip"},
		{"piquancy", "piquanc"},
		{"piquant", "piquant"},
		{"pique", "piqu"},
		{"piqued", "piqu"},
		{"piquet", "piquet"},
		{"pirouette", "pirouett"},
		{"pisagua", "pisagua"},
		{"pise", "pise"},
		{"pish", "pish"},
		{"pistil", "pistil"},
		{"pistol", "pistol"},
		{"pistoling", "pistol"},
		{"pistolling", "pistol"},
		{"pistols", "pistol"},
		{"pit", "pit"},
		{"pitcairn", "pitcairn"},
		{"pitch", "pitch"},
		{"pitched", "pitch"},
		{"pitcher", "pitcher"},
		{"pitchers", "pitcher"},
		{"pitchfork", "pitchfork"},
		{"pitching", "pitch"},
		{"pitchy", "pitchi"},
		{"piteous", "piteous"},
		{"piteously", "piteous"},
		{"pitfall", "pitfal"},
		{"pitfalls", "pitfal"},
		{"pith", "pith"},
		{"pithy", "pithi"},
		{"pitiable", "pitiabl"},
		{"pitiably", "pitiabl"},
		{"pitied", "piti"},
		{"pities", "piti"},
		{"pitiful", "piti"},
		{"pitilessly", "pitiless"},
		{"pitmen", "pitmen"},
		{"pits", "pit"},
		{"pitt", "pitt"},
		{"pittance", "pittanc"},
		{"pittances", "pittanc"},
		{"pitted", "pit"},
		{"pitty", "pitti"},
		{"pity", "piti"},
		{"pitying", "piti"},
		{"pivot", "pivot"},
		{"pizzaro", "pizzaro"},
		{"pla", "pla"},
		{"plac", "plac"},
		{"placard", "placard"},
		{"placarded", "placard"},
		{"placards", "placard"},
		{"place", "place"},
		{"placed", "place"},
		{"places", "place"},
		{"placid", "placid"},
		{"placidity", "placid"},
		{"placidly", "placid"},
		{"placing", "place"},
		{"plagiarists", "plagiarist"},
		{"plague", "plagu"},
		{"plagued", "plagu"},
		{"plagues", "plagu"},
		{"plaguing", "plagu"},
		{"plaid", "plaid"},
		{"plain", "plain"},
		{"plainer", "plainer"},
		{"plainest", "plainest"},
		{"plainly", "plain"},
		{"plainness", "plain"},
		{"plains", "plain"},
		{"plaint", "plaint"},
		{"plaintiff", "plaintiff"},
		{"plaintiffs", "plaintiff"},
		{"plaintive", "plaintiv"},
		{"plaintively", "plaintiv"},
		{"plaintiveness", "plaintiv"},
		{"plaire", "plair"},
		{"plaisir", "plaisir"},
		{"plait", "plait"},
		{"plaited", "plait"},
		{"plaits", "plait"},
		{"plan", "plan"},
		{"planaria", "planaria"},
		{"planariae", "planaria"},
		{"plane", "plane"},
		{"planed", "plane"},
		{"planet", "planet"},
		{"planing", "plane"},
		{"plank", "plank"},
		{"planks", "plank"},
		{"planned", "plan"},
		{"planning", "plan"},
		{"plans", "plan"},
		{"plant", "plant"},
		{"plantagenet", "plantagenet"},
		{"plantation", "plantat"},
		{"plantations", "plantat"},
		{"planted", "plant"},
		{"planter", "planter"},
		{"planting", "plant"},
		{"plants", "plant"},
		{"planty", "planti"},
		{"plashing", "plash"},
		{"plaster", "plaster"},
		{"plastered", "plaster"},
		{"plat", "plat"},
		{"plata", "plata"},
		{"plate", "plate"},
		{"plateau", "plateau"},
		{"plated", "plate"},
		{"plates", "plate"},
		{"platform", "platform"},
		{"platforms", "platform"},
		{"platforna", "platforna"},
		{"platina", "platina"},
		{"platitudes", "platitud"},
		{"platters", "platter"},
		{"plaudits", "plaudit"},
		{"plausible", "plausibl"},
		{"plausibly", "plausibl"},
		{"play", "play"},
		{"playbill", "playbil"},
		{"playbills", "playbil"},
		{"played", "play"},
		{"player", "player"},
		{"players", "player"},
		{"playfellow", "playfellow"},
		{"playfellows", "playfellow"},
		{"playful", "play"},
		{"playfully", "play"},
		{"playfulness", "play"},
		{"playing", "play"},
		{"playmate", "playmat"},
		{"playmates", "playmat"},
		{"plays", "play"},
		{"playsure", "playsur"},
		{"plaything", "playth"},
		{"playthings", "playth"},
		{"playwright", "playwright"},
		{"plaza", "plaza"},
		{"plea", "plea"},
		{"pleace", "pleac"},
		{"plead", "plead"},
		{"pleaded", "plead"},
		{"pleader", "pleader"},
		{"pleaders", "pleader"},
		{"pleading", "plead"},
		{"pleadingly", "plead"},
		{"pleads", "plead"},
		{"pleasant", "pleasant"},
		{"pleasanter", "pleasant"},
		{"pleasantest", "pleasantest"},
		{"pleasantly", "pleasant"},
		{"pleasantness", "pleasant"},
		{"pleasantry", "pleasantri"},
		{"please", "pleas"},
		{"pleased", "pleas"},
		{"pleases", "pleas"},
		{"pleasing", "pleas"},
		{"pleasurable", "pleasur"},
		{"pleasure", "pleasur"},
		{"pleasures", "pleasur"},
		{"pleasuring", "pleasur"},
		{"plebeian", "plebeian"},
		{"pledge", "pledg"},
		{"pledged", "pledg"},
		{"pledges", "pledg"},
		{"pledging", "pledg"},
		{"plentiful", "plenti"},
		{"plentifully", "plenti"},
		{"plenty", "plenti"},
		{"plestcheiev", "plestcheiev"},
		{"pliability", "pliabil"},
		{"plicata", "plicata"},
		{"plied", "pli"},
		{"plies", "pli"},
		{"plight", "plight"},
		{"plighting", "plight"},
		{"plodding", "plod"},
		{"plot", "plot"},
		{"plots", "plot"},
		{"plotted", "plot"},
		{"plotter", "plotter"},
		{"plotters", "plotter"},
		{"plotting", "plot"},
		{"plough", "plough"},
		{"ploughboy", "ploughboy"},
		{"ploughed", "plough"},
		{"ploughing", "plough"},
		{"ploughman", "ploughman"},
		{"ploughs", "plough"},
		{"ploughshare", "ploughshar"},
		{"ploughshares", "ploughshar"},
		{"plover", "plover"},
		{"pluck", "pluck"},
		{"plucked", "pluck"},
		{"plucking", "pluck"},
		{"plucks", "pluck"},
		{"plug", "plug"},
		{"pluies", "plui"},
		{"plum", "plum"},
		{"plumage", "plumag"},
		{"plumbago", "plumbago"},
		{"plumed", "plume"},
		{"pluming", "plume"},
		{"plummets", "plummet"},
		{"plump", "plump"},
		{"plumpest", "plumpest"},
		{"plumpness", "plump"},
		{"plums", "plum"},
		{"plunder", "plunder"},
		{"plundered", "plunder"},
		{"plundering", "plunder"},
		{"plunge", "plung"},
		{"plunged", "plung"},
		{"plunges", "plung"},
		{"plunging", "plung"},
		{"plural", "plural"},
		{"plurality", "plural"},
		{"plus", "plus"},
		{"plutonic", "pluton"},
		{"ply", "pli"},
		{"plying", "pli"},
		{"plymouth", "plymouth"},
		{"pm", "pm"},
		{"poached", "poach"},
		{"poaching", "poach"},
		{"poast", "poast"},
		{"pock", "pock"},
		{"pocket", "pocket"},
		{"pocketbook", "pocketbook"},
		{"pocketed", "pocket"},
		{"pocketing", "pocket"},
		{"pockets", "pocket"},
		{"pods", "pod"},
		{"poem", "poem"},
		{"poems", "poem"},
		{"poet", "poet"},
		{"poetic", "poetic"},
		{"poetical", "poetic"},
		{"poetizing", "poetiz"},
		{"poetry", "poetri"},
		{"poets", "poet"},
		{"poignant", "poignant"},
		{"poin", "poin"},
		{"poins", "poin"},
		{"point", "point"},
		{"pointed", "point"},
		{"pointedly", "point"},
		{"pointing", "point"},
		{"pointless", "pointless"},
		{"points", "point"},
		{"poised", "pois"},
		{"poising", "pois"},
		{"poison", "poison"},
		{"poisoned", "poison"},
		{"poisoning", "poison"},
		{"poisonous", "poison"},
		{"poke", "poke"},
		{"poked", "poke"},
		{"poker", "poker"},
		{"pokers", "poker"},
		{"pokes", "poke"},
		{"poking", "poke"},
		{"pokorev", "pokorev"},
		{"polanco", "polanco"},
		{"polar", "polar"},
		{"pole", "pole"},
		{"polecat", "polecat"},
		{"polemical", "polem"},
		{"polenka", "polenka"},
		{"poles", "pole"},
		{"police", "polic"},
		{"policeman", "policeman"},
		{"policemen", "policemen"},
		{"policies", "polici"},
		{"policy", "polici"},
		{"polish", "polish"},
		{"polished", "polish"},
		{"polishes", "polish"},
		{"polishing", "polish"},
		{"polit", "polit"},
		{"polite", "polit"},
		{"politely", "polit"},
		{"politeness", "polit"},
		{"politest", "politest"},
		{"politic", "polit"},
		{"political", "polit"},
		{"politically", "polit"},
		{"politician", "politician"},
		{"politicians", "politician"},
		{"politics", "polit"},
		{"polking", "polk"},
		{"poll", "poll"},
		{"pollard", "pollard"},
		{"pollewt", "pollewt"},
		{"polling", "poll"},
		{"pollis", "polli"},
		{"pollute", "pollut"},
		{"polluted", "pollut"},
		{"pollutions", "pollut"},
		{"polly", "polli"},
		{"pollys", "polli"},
		{"poltroon", "poltroon"},
		{"polya", "polya"},
		{"polybori", "polybori"},
		{"polyborus", "polyborus"},
		{"polygastrica", "polygastrica"},
		{"polygon", "polygon"},
		{"polynesia", "polynesia"},
		{"polynesian", "polynesian"},
		{"polypi", "polypi"},
		{"polypus", "polypus"},
		{"polysyllable", "polysyl"},
		{"pomaded", "pomad"},
		{"pomarre", "pomarr"},
		{"pomatum", "pomatum"},
		{"pommel", "pommel"},
		{"pomp", "pomp"},
		{"pompey", "pompey"},
		{"pomposities", "pompos"},
		{"pompous", "pompous"},
		{"pompously", "pompous"},
		{"pomps", "pomp"},
		{"poncho", "poncho"},
		{"ponchos", "poncho"},
		{"pond", "pond"},
		{"ponder", "ponder"},
		{"pondered", "ponder"},
		{"pondering", "ponder"},
		{"ponderous", "ponder"},
		{"ponders", "ponder"},
		{"ponds", "pond"},
		{"poniard", "poniard"},
		{"ponies", "poni"},
		{"ponsonby", "ponsonbi"},
		{"pony", "poni"},
		{"pooder", "pooder"},
		{"poodle", "poodl"},
		{"poof", "poof"},
		{"pooh", "pooh"},
		{"pool", "pool"},
		{"pools", "pool"},
		{"poonded", "poond"},
		{"poop", "poop"},
		{"poor", "poor"},
		{"poorer", "poorer"},
		{"poorest", "poorest"},
		{"poorly", "poor"},
		{"poorness", "poor"},
		{"pop", "pop"},
		{"pope", "pope"},
		{"popery", "poperi"},
		{"poplars", "poplar"},
		{"popolorum", "popolorum"},
		{"popped", "pop"},
		{"poppet", "poppet"},
		{"popping", "pop"},
		{"popular", "popular"},
		{"popularity", "popular"},
		{"populated", "popul"},
		{"population", "popul"},
		{"populous", "popul"},
		{"porch", "porch"},
		{"porches", "porch"},
		{"porcupine", "porcupin"},
		{"pore", "pore"},
		{"pored", "pore"},
		{"pores", "pore"},
		{"porfiry", "porfiri"},
		{"poring", "pore"},
		{"pork", "pork"},
		{"porous", "porous"},
		{"porphyries", "porphyri"},
		{"porphyrio", "porphyrio"},
		{"porphyry", "porphyri"},
		{"porpoises", "porpois"},
		{"porridge", "porridg"},
		{"porson", "porson"},
		{"port", "port"},
		{"portable", "portabl"},
		{"portal", "portal"},
		{"portend", "portend"},
		{"portended", "portend"},
		{"portentous", "portent"},
		{"porter", "porter"},
		{"porterage", "porterag"},
		{"porters", "porter"},
		{"portfolio", "portfolio"},
		{"portfolios", "portfolio"},
		{"porth", "porth"},
		{"portico", "portico"},
		{"portillo", "portillo"},
		{"portion", "portion"},
		{"portionless", "portionless"},
		{"portions", "portion"},
		{"portland", "portland"},
		{"portly", "port"},
		{"portmanteau", "portmanteau"},
		{"portmanteaus", "portmanteaus"},
		{"porto", "porto"},
		{"portrait", "portrait"},
		{"portraits", "portrait"},
		{"portrayed", "portray"},
		{"ports", "port"},
		{"portsmouth", "portsmouth"},
		{"portugal", "portug"},
		{"portuguese", "portugues"},
		{"pose", "pose"},
		{"posed", "pose"},
		{"poses", "pose"},
		{"posession", "posess"},
		{"posing", "pose"},
		{"position", "posit"},
		{"positions", "posit"},
		{"positive", "posit"},
		{"positively", "posit"},
		{"positiveness", "posit"},
		{"possess", "possess"},
		{"possesse", "possess"},
		{"possessed", "possess"},
		{"possesses", "possess"},
		{"possessin", "possessin"},
		{"possessing", "possess"},
		{"possession", "possess"},
		{"possessions", "possess"},
		{"possessive", "possess"},
		{"possessor", "possessor"},
		{"possessors", "possessor"},
		{"possibilities", "possibl"},
		{"possibility", "possibl"},
		{"possible", "possibl"},
		{"possibly", "possibl"},
		{"post", "post"},
		{"posta", "posta"},
		{"postage", "postag"},
		{"postas", "posta"},
		{"posted", "post"},
		{"poster", "poster"},
		{"posterior", "posterior"},
		{"posterity", "poster"},
		{"postern", "postern"},
		{"posters", "poster"},
		{"posthouse", "posthous"},
		{"postilion", "postilion"},
		{"posting", "post"},
		{"postman", "postman"},
		{"postmaster", "postmast"},
		{"postmen", "postmen"},
		{"postpone", "postpon"},
		{"postponed", "postpon"},
		{"postponement", "postpon"},
		{"postpones", "postpon"},
		{"postponing", "postpon"},
		{"posts", "post"},
		{"postscript", "postscript"},
		{"posture", "postur"},
		{"postures", "postur"},
		{"posuit", "posuit"},
		{"pot", "pot"},
		{"potanchikov", "potanchikov"},
		{"potash", "potash"},
		{"potations", "potat"},
		{"potato", "potato"},
		{"potatoes", "potato"},
		{"potatoless", "potatoless"},
		{"potboy", "potboy"},
		{"potchinkov", "potchinkov"},
		{"potent", "potent"},
		{"potentate", "potent"},
		{"pothouse", "pothous"},
		{"potion", "potion"},
		{"potosi", "potosi"},
		{"potrero", "potrero"},
		{"pots", "pot"},
		{"potted", "pot"},
		{"potter", "potter"},
		{"potteries", "potteri"},
		{"pottery", "potteri"},
		{"pouce", "pouc"},
		{"pouch", "pouch"},
		{"pouches", "pouch"},
		{"poultry", "poultri"},
		{"pounce", "pounc"},
		{"pounced", "pounc"},
		{"pounces", "pounc"},
		{"pouncing", "pounc"},
		{"pound", "pound"},
		{"pounded", "pound"},
		{"pounder", "pounder"},
		{"pounds", "pound"},
		{"pountney", "pountney"},
		{"pountneys", "pountney"},
		{"pour", "pour"},
		{"poured", "pour"},
		{"pouring", "pour"},
		{"pours", "pour"},
		{"pout", "pout"},
		{"pouted", "pout"},
		{"pouting", "pout"},
		{"poverty", "poverti"},
		{"powder", "powder"},
		{"powdered", "powder"},
		{"powderin", "powderin"},
		{"powe", "pow"},
		{"powell", "powel"},
		{"power", "power"},
		{"powerful", "power"},
		{"powerfully", "power"},
		{"powerless", "powerless"},
		{"powers", "power"},
		{"pox", "pox"},
		{"pp", "pp"},
		{"pr", "pr"},
		{"practicability", "practic"},
		{"practicable", "practic"},
		{"practical", "practic"},
		{"practicality", "practic"},
		{"practically", "practic"},
		{"practice", "practic"},
		{"practices", "practic"},
		{"practise", "practis"},
		{"practised", "practis"},
		{"practiser", "practis"},
		{"practises", "practis"},
		{"practising", "practis"},
		{"practitioner", "practition"},
		{"practitioners", "practition"},
		{"prae", "prae"},
		{"praetorian", "praetorian"},
		{"praia", "praia"},
		{"prairies", "prairi"},
		{"praise", "prais"},
		{"praised", "prais"},
		{"praises", "prais"},
		{"praiseworthy", "praiseworthi"},
		{"praising", "prais"},
		{"prance", "pranc"},
		{"prancing", "pranc"},
		{"pranks", "prank"},
		{"prasant", "prasant"},
		{"praskovya", "praskovya"},
		{"prattlings", "prattl"},
		{"pratty", "pratti"},
		{"prawn", "prawn"},
		{"prawns", "prawn"},
		{"pray", "pray"},
		{"praya", "praya"},
		{"prayed", "pray"},
		{"prayer", "prayer"},
		{"prayers", "prayer"},
		{"prayfession", "prayfess"},
		{"prayin", "prayin"},
		{"praying", "pray"},
		{"prays", "pray"},
		{"pre", "pre"},
		{"preach", "preach"},
		{"preached", "preach"},
		{"preacher", "preacher"},
		{"preachers", "preacher"},
		{"preaching", "preach"},
		{"prebendary", "prebendari"},
		{"precarious", "precari"},
		{"precaution", "precaut"},
		{"precautions", "precaut"},
		{"precede", "preced"},
		{"preceded", "preced"},
		{"precedence", "preced"},
		{"precedent", "preced"},
		{"precedents", "preced"},
		{"preceding", "preced"},
		{"precept", "precept"},
		{"preceptor", "preceptor"},
		{"precepts", "precept"},
		{"precincts", "precinct"},
		{"precious", "precious"},
		{"preciousest", "preciousest"},
		{"precipice", "precipic"},
		{"precipices", "precipic"},
		{"precipitate", "precipit"},
		{"precipitated", "precipit"},
		{"precipitately", "precipit"},
		{"precipitation", "precipit"},
		{"precipitous", "precipit"},
		{"precise", "precis"},
		{"precisely", "precis"},
		{"precision", "precis"},
		{"precluded", "preclud"},
		{"precocious", "precoci"},
		{"precociously", "precoci"},
		{"preconceived", "preconceiv"},
		{"preconcerted", "preconcert"},
		{"predecessor", "predecessor"},
		{"predecessors", "predecessor"},
		{"predestined", "predestin"},
		{"predicament", "predica"},
		{"predicaments", "predica"},
		{"predict", "predict"},
		{"predicted", "predict"},
		{"predicting", "predict"},
		{"prediction", "predict"},
		{"predictions", "predict"},
		{"predilections", "predilect"},
		{"predisposition", "predisposit"},
		{"predominant", "predomin"},
		{"predominate", "predomin"},
		{"predominated", "predomin"},
		{"preening", "preen"},
		{"preface", "prefac"},
		{"prefacing", "prefac"},
		{"prefatory", "prefatori"},
		{"prefer", "prefer"},
		{"preferable", "prefer"},
		{"preference", "prefer"},
		{"preferer", "prefer"},
		{"preferment", "prefer"},
		{"preferred", "prefer"},
		{"preferring", "prefer"},
		{"prefers", "prefer"},
		{"prefixed", "prefix"},
		{"prehensile", "prehensil"},
		{"prehensilis", "prehensili"},
		{"prejudge", "prejudg"},
		{"prejudice", "prejudic"},
		{"prejudiced", "prejud"},
		{"prejudices", "prejudic"},
		{"prejudicial", "prejudici"},
		{"preliminaries", "preliminari"},
		{"preliminary", "preliminari"},
		{"prelude", "prelud"},
		{"premature", "prematur"},
		{"prematurely", "prematur"},
		{"premeditated", "premedit"},
		{"premeditation", "premedit"},
		{"premier", "premier"},
		{"premiers", "premier"},
		{"premiership", "premiership"},
		{"premise", "premis"},
		{"premised", "premis"},
		{"premises", "premis"},
		{"premium", "premium"},
		{"prentice", "prentic"},
		{"prentices", "prentic"},
		{"preoccupation", "preoccup"},
		{"preoccupations", "preoccup"},
		{"preoccupied", "preoccupi"},
		{"preordained", "preordain"},
		{"preparation", "prepar"},
		{"preparations", "prepar"},
		{"preparatory", "preparatori"},
		{"prepare", "prepar"},
		{"prepared", "prepar"},
		{"prepares", "prepar"},
		{"preparing", "prepar"},
		{"prepense", "prepens"},
		{"preponderance", "preponder"},
		{"preponderated", "preponder"},
		{"preponderates", "preponder"},
		{"preponderating", "preponder"},
		{"prepossessed", "prepossess"},
		{"prepossessing", "prepossess"},
		{"prepossession", "prepossess"},
		{"prepossessions", "prepossess"},
		{"preposterous", "preposter"},
		{"presbyterian", "presbyterian"},
		{"prescribe", "prescrib"},
		{"prescribed", "prescrib"},
		{"prescription", "prescript"},
		{"prescriptive", "prescript"},
		{"presence", "presenc"},
		{"presenfty", "presenfti"},
		{"present", "present"},
		{"presentable", "present"},
		{"presentation", "present"},
		{"presented", "present"},
		{"presentime", "presentim"},
		{"presentiment", "presenti"},
		{"presentiments", "presenti"},
		{"presenting", "present"},
		{"presently", "present"},
		{"presentments", "present"},
		{"presents", "present"},
		{"preservation", "preserv"},
		{"preserve", "preserv"},
		{"preserved", "preserv"},
		{"preserver", "preserv"},
		{"preserves", "preserv"},
		{"preserving", "preserv"},
		{"preside", "presid"},
		{"presided", "presid"},
		{"presidency", "presid"},
		{"president", "presid"},
		{"presidents", "presid"},
		{"presidentship", "presidentship"},
		{"presiding", "presid"},
		{"press", "press"},
		{"pressed", "press"},
		{"presses", "press"},
		{"pressing", "press"},
		{"pressingly", "press"},
		{"pressure", "pressur"},
		{"prestige", "prestig"},
		{"presumably", "presum"},
		{"presume", "presum"},
		{"presumed", "presum"},
		{"presumes", "presum"},
		{"presuming", "presum"},
		{"presumption", "presumpt"},
		{"presumptuous", "presumptu"},
		{"presumptuously", "presumptu"},
		{"presupposes", "presuppos"},
		{"pretence", "pretenc"},
		{"pretences", "pretenc"},
		{"pretend", "pretend"},
		{"pretended", "pretend"},
		{"pretending", "pretend"},
		{"pretends", "pretend"},
		{"pretension", "pretens"},
		{"pretensions", "pretens"},
		{"pretentious", "pretenti"},
		{"preternatural", "preternatur"},
		{"pretext", "pretext"},
		{"pretexts", "pretext"},
		{"prett", "prett"},
		{"prettier", "prettier"},
		{"prettiest", "prettiest"},
		{"prettily", "prettili"},
		{"prettiness", "pretti"},
		{"prettinesses", "pretti"},
		{"pretty", "pretti"},
		{"prevail", "prevail"},
		{"prevailed", "prevail"},
		{"prevailing", "prevail"},
		{"prevails", "prevail"},
		{"prevalent", "preval"},
		{"prevaricate", "prevar"},
		{"prevent", "prevent"},
		{"prevented", "prevent"},
		{"preventing", "prevent"},
		{"prevents", "prevent"},
		{"previous", "previous"},
		{"previously", "previous"},
		{"prevost", "prevost"},
		{"prey", "prey"},
		{"preyed", "prey"},
		{"preying", "prey"},
		{"preys", "prey"},
		{"price", "price"},
		{"priceless", "priceless"},
		{"prices", "price"},
		{"prick", "prick"},
		{"pricked", "prick"},
		{"pricking", "prick"},
		{"prickles", "prickl"},
		{"prickly", "prick"},
		{"pricks", "prick"},
		{"pride", "pride"},
		{"pries", "pri"},
		{"priest", "priest"},
		{"priesthood", "priesthood"},
		{"priestly", "priest"},
		{"priests", "priest"},
		{"prig", "prig"},
		{"prilukov", "prilukov"},
		{"prim", "prim"},
		{"primarily", "primarili"},
		{"primary", "primari"},
		{"prime", "prime"},
		{"primer", "primer"},
		{"primera", "primera"},
		{"primeval", "primev"},
		{"primitive", "primit"},
		{"primogeniture", "primogenitur"},
		{"primrose", "primros"},
		{"prince", "princ"},
		{"princely", "princ"},
		{"princes", "princ"},
		{"princess", "princess"},
		{"princesses", "princess"},
		{"principal", "princip"},
		{"principally", "princip"},
		{"principals", "princip"},
		{"principle", "principl"},
		{"principles", "principl"},
		{"prinking", "prink"},
		{"print", "print"},
		{"printed", "print"},
		{"printers", "printer"},
		{"printing", "print"},
		{"prints", "print"},
		{"prionotus", "prionotus"},
		{"prior", "prior"},
		{"prioress", "prioress"},
		{"priority", "prioriti"},
		{"priory", "priori"},
		{"priscilla", "priscilla"},
		{"prismatic", "prismat"},
		{"prison", "prison"},
		{"prisoner", "prison"},
		{"prisoners", "prison"},
		{"prisons", "prison"},
		{"pritchard", "pritchard"},
		{"pritchards", "pritchard"},
		{"privacy", "privaci"},
		{"private", "privat"},
		{"privateer", "privat"},
		{"privately", "privat"},
		{"privation", "privat"},
		{"privations", "privat"},
		{"privilege", "privileg"},
		{"privileged", "privileg"},
		{"privileges", "privileg"},
		{"privy", "privi"},
		{"prize", "prize"},
		{"prized", "prize"},
		{"prizes", "prize"},
		{"pro", "pro"},
		{"probabilities", "probabl"},
		{"probability", "probabl"},
		{"probable", "probabl"},
		{"probably", "probabl"},
		{"probation", "probat"},
		{"probing", "probe"},
		{"problem", "problem"},
		{"problematical", "problemat"},
		{"problems", "problem"},
		{"proboscis", "probosci"},
		{"procedure", "procedur"},
		{"proceed", "proceed"},
		{"proceeded", "proceed"},
		{"proceeding", "proceed"},
		{"proceedings", "proceed"},
		{"proceeds", "proceed"},
		{"procellaria", "procellaria"},
		{"process", "process"},
		{"processes", "process"},
		{"procession", "process"},
		{"proclaim", "proclaim"},
		{"proclaimed", "proclaim"},
		{"proclaiming", "proclaim"},
		{"proclaims", "proclaim"},
		{"proclamation", "proclam"},
		{"procrastinates", "procrastin"},
		{"procrastination", "procrastin"},
		{"proctotretus", "proctotretus"},
		{"procurable", "procur"},
		{"procure", "procur"},
		{"procured", "procur"},
		{"procuring", "procur"},
		{"prodigal", "prodig"},
		{"prodigality", "prodig"},
		{"prodigieux", "prodigieux"},
		{"prodigious", "prodigi"},
		{"prodigiously", "prodigi"},
		{"prodigy", "prodigi"},
		{"produce", "produc"},
		{"produced", "produc"},
		{"produces", "produc"},
		{"producible", "produc"},
		{"producing", "produc"},
		{"product", "product"},
		{"production", "product"},
		{"productions", "product"},
		{"productive", "product"},
		{"productiveness", "product"},
		{"products", "product"},
		{"profanation", "profan"},
		{"profane", "profan"},
		{"profanely", "profan"},
		{"profaning", "profan"},
		{"profess", "profess"},
		{"professed", "profess"},
		{"professes", "profess"},
		{"professing", "profess"},
		{"profession", "profess"},
		{"professional", "profession"},
		{"professionally", "profession"},
		{"professionals", "profession"},
		{"professionaly", "professionali"},
		{"professions", "profess"},
		{"professor", "professor"},
		{"professors", "professor"},
		{"professorship", "professorship"},
		{"proffer", "proffer"},
		{"proffered", "proffer"},
		{"proficiency", "profici"},
		{"proficient", "profici"},
		{"profile", "profil"},
		{"profit", "profit"},
		{"profitable", "profit"},
		{"profited", "profit"},
		{"profiting", "profit"},
		{"profitless", "profitless"},
		{"profits", "profit"},
		{"profligacy", "profligaci"},
		{"profligate", "proflig"},
		{"profligately", "proflig"},
		{"profligates", "proflig"},
		{"profound", "profound"},
		{"profoundest", "profoundest"},
		{"profoundly", "profound"},
		{"profundity", "profund"},
		{"profuse", "profus"},
		{"profusely", "profus"},
		{"profusion", "profus"},
		{"progenitive", "progenit"},
		{"progenitors", "progenitor"},
		{"progne", "progn"},
		{"prognostications", "prognost"},
		{"programme", "programm"},
		{"progress", "progress"},
		{"progressed", "progress"},
		{"progressing", "progress"},
		{"progression", "progress"},
		{"progressive", "progress"},
		{"progressively", "progress"},
		{"progressives", "progress"},
		{"prohibited", "prohibit"},
		{"prohibiting", "prohibit"},
		{"prohibition", "prohibit"},
		{"project", "project"},
		{"projected", "project"},
		{"projecting", "project"},
		{"projection", "project"},
		{"projector", "projector"},
		{"projects", "project"},
		{"prokofitch", "prokofitch"},
		{"prolific", "prolif"},
		{"prolix", "prolix"},
		{"prolixities", "prolix"},
		{"prolixity", "prolix"},
		{"prolong", "prolong"},
		{"prolongation", "prolong"},
		{"prolonged", "prolong"},
		{"prolonging", "prolong"},
		{"promenade", "promenad"},
		{"promethean", "promethean"},
		{"prominent", "promin"},
		{"prominently", "promin"},
		{"promise", "promis"},
		{"promised", "promis"},
		{"promises", "promis"},
		{"promisin", "promisin"},
		{"promising", "promis"},
		{"promissory", "promissori"},
		{"promontories", "promontori"},
		{"promontory", "promontori"},
		{"promote", "promot"},
		{"promoted", "promot"},
		{"promoter", "promot"},
		{"promotes", "promot"},
		{"promoting", "promot"},
		{"promotion", "promot"},
		{"prompt", "prompt"},
		{"prompted", "prompt"},
		{"prompter", "prompter"},
		{"prompters", "prompter"},
		{"prompting", "prompt"},
		{"promptitude", "promptitud"},
		{"promptly", "prompt"},
		{"promptness", "prompt"},
		{"prompts", "prompt"},
		{"prone", "prone"},
		{"proneness", "prone"},
		{"pronoun", "pronoun"},
		{"pronounce", "pronounc"},
		{"pronounced", "pronounc"},
		{"pronounces", "pronounc"},
		{"pronouncing", "pronounc"},
		{"proodest", "proodest"},
		{"proof", "proof"},
		{"proofs", "proof"},
		{"prop", "prop"},
		{"propaganda", "propaganda"},
		{"propagated", "propag"},
		{"propagates", "propag"},
		{"propagation", "propag"},
		{"propensity", "propens"},
		{"proper", "proper"},
		{"properly", "proper"},
		{"properties", "properti"},
		{"property", "properti"},
		{"propertyless", "propertyless"},
		{"prophecy", "propheci"},
		{"prophesied", "prophesi"},
		{"prophesying", "prophesi"},
		{"prophet", "prophet"},
		{"prophetic", "prophet"},
		{"prophetical", "prophet"},
		{"prophetically", "prophet"},
		{"propitiate", "propiti"},
		{"propitiated", "propiti"},
		{"propitiation", "propiti"},
		{"propitiatory", "propitiatori"},
		{"propitious", "propiti"},
		{"proportion", "proport"},
		{"proportionably", "proportion"},
		{"proportional", "proport"},
		{"proportionally", "proport"},
		{"proportionate", "proportion"},
		{"proportionately", "proportion"},
		{"proportioned", "proport"},
		{"proportions", "proport"},
		{"propos", "propo"},
		{"proposal", "propos"},
		{"proposals", "propos"},
		{"propose", "propos"},
		{"proposed", "propos"},
		{"proposes", "propos"},
		{"proposing", "propos"},
		{"proposition", "proposit"},
		{"propositions", "proposit"},
		{"propound", "propound"},
		{"propounded", "propound"},
		{"propounding", "propound"},
		{"propoundlng", "propoundlng"},
		{"propounds", "propound"},
		{"propped", "prop"},
		{"propping", "prop"},
		{"proprieties", "proprieti"},
		{"proprietor", "proprietor"},
		{"proprietorship", "proprietorship"},
		{"proprietress", "proprietress"},
		{"propriety", "proprieti"},
		{"prorogation", "prorog"},
		{"prosaic", "prosaic"},
		{"proscenium", "proscenium"},
		{"proscribed", "proscrib"},
		{"prose", "prose"},
		{"prosecute", "prosecut"},
		{"prosecuted", "prosecut"},
		{"prosecution", "prosecut"},
		{"prosecutor", "prosecutor"},
		{"prosing", "prose"},
		{"prospect", "prospect"},
		{"prospective", "prospect"},
		{"prospects", "prospect"},
		{"prospectus", "prospectus"},
		{"prosper", "prosper"},
		{"prospered", "prosper"},
		{"prospering", "prosper"},
		{"prosperity", "prosper"},
		{"prosperous", "prosper"},
		{"prosperously", "prosper"},
		{"prostrate", "prostrat"},
		{"prostrated", "prostrat"},
		{"prostration", "prostrat"},
		{"prosy", "prosi"},
		{"protect", "protect"},
		{"protected", "protect"},
		{"protecting", "protect"},
		{"protection", "protect"},
		{"protective", "protect"},
		{"protector", "protector"},
		{"protectors", "protector"},
		{"protegee", "protege"},
		{"proteges", "proteg"},
		{"protest", "protest"},
		{"protestant", "protest"},
		{"protestantism", "protestant"},
		{"protestation", "protest"},
		{"protestations", "protest"},
		{"protested", "protest"},
		{"protesting", "protest"},
		{"protests", "protest"},
		{"proteus", "proteus"},
		{"protococcus", "protococcus"},
		{"prototype", "prototyp"},
		{"prototypes", "prototyp"},
		{"protract", "protract"},
		{"protracted", "protract"},
		{"protrude", "protrud"},
		{"protruded", "protrud"},
		{"protrudes", "protrud"},
		{"protruding", "protrud"},
		{"proud", "proud"},
		{"prouder", "prouder"},
		{"proudest", "proudest"},
		{"proudhon", "proudhon"},
		{"proudly", "proud"},
		{"prov", "prov"},
		{"prove", "prove"},
		{"proved", "prove"},
		{"proverb", "proverb"},
		{"proves", "prove"},
		{"provide", "provid"},
		{"provided", "provid"},
		{"providence", "provid"},
		{"providential", "providenti"},
		{"providentially", "providenti"},
		{"provider", "provid"},
		{"provides", "provid"},
		{"providing", "provid"},
		{"province", "provinc"},
		{"provinces", "provinc"},
		{"provincial", "provinci"},
		{"proving", "prove"},
		{"provision", "provis"},
		{"provisional", "provision"},
		{"provisions", "provis"},
		{"proviso", "proviso"},
		{"provocation", "provoc"},
		{"provocative", "provoc"},
		{"provoke", "provok"},
		{"provoked", "provok"},
		{"provokes", "provok"},
		{"provoking", "provok"},
		{"provokingly", "provok"},
		{"prow", "prow"},
		{"prowess", "prowess"},
		{"prowl", "prowl"},
		{"prowled", "prowl"},
		{"prowling", "prowl"},
		{"proximity", "proxim"},
		{"proxy", "proxi"},
		{"proxying", "proxi"},
		{"prudence", "prudenc"},
		{"prudent", "prudent"},
		{"prudently", "prudent"},
		{"prudery", "pruderi"},
		{"prudish", "prudish"},
		{"pruning", "prune"},
		{"prunings", "prune"},
		{"prurient", "prurient"},
		{"prussian", "prussian"},
		{"prussians", "prussian"},
		{"prussic", "prussic"},
		{"pry", "pri"},
		{"psalm", "psalm"},
		{"psalms", "psalm"},
		{"psammophis", "psammophi"},
		{"pselaphus", "pselaphus"},
		{"pseudo", "pseudo"},
		{"psha", "psha"},
		{"pshaw", "pshaw"},
		{"psyche", "psych"},
		{"psychological", "psycholog"},
		{"psychologically", "psycholog"},
		{"psychologist", "psychologist"},
		{"psychology", "psycholog"},
		{"pt", "pt"},
		{"ptarmigans", "ptarmigan"},
		{"pterophorus", "pterophorus"},
		{"pteropoda", "pteropoda"},
		{"pteroptochos", "pteroptocho"},
		{"public", "public"},
		{"publicans", "publican"},
		{"publication", "public"},
		{"publications", "public"},
		{"publicity", "public"},
		{"publicly", "public"},
		{"publish", "publish"},
		{"published", "publish"},
		{"publisher", "publish"},
		{"publishers", "publish"},
		{"publishing", "publish"},
		{"puckered", "pucker"},
		{"puddick", "puddick"},
		{"pudding", "pud"},
		{"puddings", "pud"},
		{"puddle", "puddl"},
		{"puddles", "puddl"},
		{"puente", "puent"},
		{"puff", "puff"},
		{"puffed", "puf"},
		{"puffing", "puf"},
		{"puffinus", "puffinus"},
		{"puffs", "puff"},
		{"puffy", "puffi"},
		{"pug", "pug"},
		{"pugilistic", "pugilist"},
		{"pugnacious", "pugnaci"},
		{"pugnacity", "pugnac"},
		{"pugstyles", "pugstyl"},
		{"pul", "pul"},
		{"pulcheria", "pulcheria"},
		{"pull", "pull"},
		{"pulled", "pull"},
		{"pulling", "pull"},
		{"pulls", "pull"},
		{"pulp", "pulp"},
		{"pulperia", "pulperia"},
		{"pulpit", "pulpit"},
		{"pulpy", "pulpi"},
		{"pulse", "puls"},
		{"pulses", "puls"},
		{"pum", "pum"},
		{"puma", "puma"},
		{"pumas", "puma"},
		{"pumice", "pumic"},
		{"pumiceous", "pumic"},
		{"pumila", "pumila"},
		{"pummelled", "pummel"},
		{"pummelling", "pummel"},
		{"pump", "pump"},
		{"pumping", "pump"},
		{"pumpkin", "pumpkin"},
		{"pumps", "pump"},
		{"pun", "pun"},
		{"puna", "puna"},
		{"punch", "punch"},
		{"punched", "punch"},
		{"punches", "punch"},
		{"punchinello", "punchinello"},
		{"punching", "punch"},
		{"punctatissima", "punctatissima"},
		{"punctilious", "punctili"},
		{"punctiliousness", "punctili"},
		{"punctual", "punctual"},
		{"punctuality", "punctual"},
		{"punctually", "punctual"},
		{"punctuation", "punctuat"},
		{"puncture", "punctur"},
		{"punctured", "punctur"},
		{"pundit", "pundit"},
		{"pundits", "pundit"},
		{"punish", "punish"},
		{"punished", "punish"},
		{"punishing", "punish"},
		{"punishment", "punish"},
		{"punt", "punt"},
		{"punta", "punta"},
		{"puny", "puni"},
		{"pupil", "pupil"},
		{"pupils", "pupil"},
		{"pupker", "pupker"},
		{"puppet", "puppet"},
		{"puppies", "puppi"},
		{"puppy", "puppi"},
		{"puppyism", "puppyism"},
		{"purblind", "purblind"},
		{"purchas", "purcha"},
		{"purchase", "purchas"},
		{"purchased", "purchas"},
		{"purchaser", "purchas"},
		{"purchases", "purchas"},
		{"purchasing", "purchas"},
		{"pure", "pure"},
		{"purechurch", "purechurch"},
		{"purely", "pure"},
		{"purer", "purer"},
		{"purest", "purest"},
		{"purge", "purg"},
		{"purified", "purifi"},
		{"purify", "purifi"},
		{"purity", "puriti"},
		{"purple", "purpl"},
		{"purplish", "purplish"},
		{"purport", "purport"},
		{"purporting", "purport"},
		{"purpose", "purpos"},
		{"purposed", "purpos"},
		{"purposeless", "purposeless"},
		{"purposely", "purpos"},
		{"purposes", "purpos"},
		{"purpura", "purpura"},
		{"purpurea", "purpurea"},
		{"purr", "purr"},
		{"purring", "pur"},
		{"purse", "purs"},
		{"pursed", "purs"},
		{"purser", "purser"},
		{"purses", "purs"},
		{"pursing", "purs"},
		{"pursuance", "pursuanc"},
		{"pursuant", "pursuant"},
		{"pursue", "pursu"},
		{"pursued", "pursu"},
		{"pursuer", "pursuer"},
		{"pursuers", "pursuer"},
		{"pursues", "pursu"},
		{"pursuing", "pursu"},
		{"pursuit", "pursuit"},
		{"pursuits", "pursuit"},
		{"pursult", "pursult"},
		{"purvided", "purvid"},
		{"push", "push"},
		{"pushed", "push"},
		{"pushes", "push"},
		{"pushing", "push"},
		{"pushkin", "pushkin"},
		{"pusillanimity", "pusillanim"},
		{"puss", "puss"},
		{"pussy", "pussi"},
		{"pustules", "pustul"},
		{"put", "put"},
		{"putrefaction", "putrefact"},
		{"putrefying", "putrefi"},
		{"putrid", "putrid"},
		{"putridity", "putrid"},
		{"puts", "put"},
		{"puttin", "puttin"},
		{"putting", "put"},
		{"puzzle", "puzzl"},
		{"puzzled", "puzzl"},
		{"puzzles", "puzzl"},
		{"puzzling", "puzzl"},
		{"py", "py"},
		{"pye", "pye"},
		{"pygmy", "pygmi"},
		{"pyke", "pyke"},
		{"pyotr", "pyotr"},
		{"pyramid", "pyramid"},
		{"pyramids", "pyramid"},
		{"pyrard", "pyrard"},
		{"pyre", "pyre"},
		{"pyrenees", "pyrene"},
		{"pyrifera", "pyrifera"},
		{"pyrites", "pyrit"},
		{"pyrocephalus", "pyrocephalus"},
		{"pyrophorus", "pyrophorus"},
		{"pyrosma", "pyrosma"},
		{"q", "q"},
		{"qc", "qc"},
		{"qu", "qu"},
		{"quaccha", "quaccha"},
		{"quack", "quack"},
		{"quadra", "quadra"},
		{"quadrangle", "quadrangl"},
		{"quadrangular", "quadrangular"},
		{"quadras", "quadra"},
		{"quadrille", "quadrill"},
		{"quadruped", "quadrup"},
		{"quadrupeds", "quadrup"},
		{"quadruple", "quadrupl"},
		{"quadrupled", "quadrupl"},
		{"quagmire", "quagmir"},
		{"quagmires", "quagmir"},
		{"quail", "quail"},
		{"quailed", "quail"},
		{"quailing", "quail"},
		{"quails", "quail"},
		{"quaint", "quaint"},
		{"quaintly", "quaint"},
		{"quaintness", "quaint"},
		{"quake", "quak"},
		{"quaked", "quak"},
		{"quakes", "quak"},
		{"quaking", "quak"},
		{"quakings", "quak"},
		{"quale", "qual"},
		{"qualification", "qualif"},
		{"qualifications", "qualif"},
		{"qualified", "qualifi"},
		{"qualify", "qualifi"},
		{"qualifying", "qualifi"},
		{"qualities", "qualiti"},
		{"quality", "qualiti"},
		{"quand", "quand"},
		{"quantite", "quantit"},
		{"quantities", "quantiti"},
		{"quantity", "quantiti"},
		{"quarrel", "quarrel"},
		{"quarrelled", "quarrel"},
		{"quarrelling", "quarrel"},
		{"quarrels", "quarrel"},
		{"quarrelsome", "quarrelsom"},
		{"quarry", "quarri"},
		{"quart", "quart"},
		{"quarter", "quarter"},
		{"quartered", "quarter"},
		{"quartering", "quarter"},
		{"quarterly", "quarter"},
		{"quartermaster", "quartermast"},
		{"quartern", "quartern"},
		{"quarters", "quarter"},
		{"quarther", "quarther"},
		{"quartz", "quartz"},
		{"quatre", "quatr"},
		{"quaver", "quaver"},
		{"quavering", "quaver"},
		{"quay", "quay"},
		{"que", "que"},
		{"quebec", "quebec"},
		{"quebrantahuesos", "quebrantahueso"},
		{"quedius", "quedius"},
		{"queen", "queen"},
		{"queens", "queen"},
		{"queer", "queer"},
		{"queerest", "queerest"},
		{"queerness", "queer"},
		{"quell", "quell"},
		{"quelled", "quell"},
		{"quench", "quench"},
		{"quenched", "quench"},
		{"quenching", "quench"},
		{"queries", "queri"},
		{"querulous", "querul"},
		{"query", "queri"},
		{"quest", "quest"},
		{"question", "question"},
		{"questionable", "question"},
		{"questioned", "question"},
		{"questioner", "question"},
		{"questioning", "question"},
		{"questionings", "question"},
		{"questions", "question"},
		{"quibble", "quibbl"},
		{"quick", "quick"},
		{"quicken", "quicken"},
		{"quickened", "quicken"},
		{"quickens", "quicken"},
		{"quicker", "quicker"},
		{"quickest", "quickest"},
		{"quickly", "quick"},
		{"quickness", "quick"},
		{"quicksilver", "quicksilv"},
		{"quidnuncs", "quidnunc"},
		{"quien", "quien"},
		{"quiescence", "quiescenc"},
		{"quiescent", "quiescent"},
		{"quiet", "quiet"},
		{"quieted", "quiet"},
		{"quieter", "quieter"},
		{"quietest", "quietest"},
		{"quietly", "quiet"},
		{"quietness", "quiet"},
		{"quiets", "quiet"},
		{"quietude", "quietud"},
		{"quilimari", "quilimari"},
		{"quillay", "quillay"},
		{"quillota", "quillota"},
		{"quills", "quill"},
		{"quilmes", "quilm"},
		{"quilt", "quilt"},
		{"quince", "quinc"},
		{"quinchao", "quinchao"},
		{"quintero", "quintero"},
		{"quints", "quint"},
		{"quintus", "quintus"},
		{"quiriquina", "quiriquina"},
		{"quit", "quit"},
		{"quite", "quit"},
		{"quito", "quito"},
		{"quits", "quit"},
		{"quitted", "quit"},
		{"quitting", "quit"},
		{"quiver", "quiver"},
		{"quivered", "quiver"},
		{"quivering", "quiver"},
		{"quivers", "quiver"},
		{"quixote", "quixot"},
		{"quixotic", "quixot"},
		{"quixotism", "quixot"},
		{"quizzical", "quizzic"},
		{"quizzing", "quizz"},
		{"quizzings", "quizz"},
		{"qulte", "qult"},
		{"quo", "quo"},
		{"quondam", "quondam"},
		{"quoodle", "quoodl"},
		{"quotation", "quotat"},
		{"quotations", "quotat"},
		{"quote", "quot"},
		{"quoted", "quot"},
		{"quotes", "quot"},
		{"quoth", "quoth"},
		{"quoting", "quot"},
		{"quoy", "quoy"},
		{"r", "r"},
		{"ra", "ra"},
		{"raa", "raa"},
		{"rabbit", "rabbit"},
		{"rabbits", "rabbit"},
		{"rabidly", "rabid"},
		{"race", "race"},
		{"racehorses", "racehors"},
		{"racers", "racer"},
		{"races", "race"},
		{"rachael", "rachael"},
		{"rachel", "rachel"},
		{"racing", "race"},
		{"rack", "rack"},
		{"racked", "rack"},
		{"racket", "racket"},
		{"racketing", "racket"},
		{"racking", "rack"},
		{"rackings", "rack"},
		{"radack", "radack"},
		{"radiance", "radianc"},
		{"radiant", "radiant"},
		{"radiantly", "radiant"},
		{"radiata", "radiata"},
		{"radiate", "radiat"},
		{"radiated", "radiat"},
		{"radiating", "radiat"},
		{"radiation", "radiat"},
		{"radical", "radic"},
		{"radicalism", "radic"},
		{"radicals", "radic"},
		{"radii", "radii"},
		{"radish", "radish"},
		{"radishchev", "radishchev"},
		{"radishes", "radish"},
		{"rads", "rad"},
		{"rafael", "rafael"},
		{"raff", "raff"},
		{"raffaelite", "raffaelit"},
		{"raffaelites", "raffaelit"},
		{"raffaelitism", "raffaelit"},
		{"raft", "raft"},
		{"rafters", "rafter"},
		{"rafts", "raft"},
		{"rag", "rag"},
		{"rage", "rage"},
		{"raged", "rage"},
		{"rages", "rage"},
		{"ragged", "rag"},
		{"raging", "rage"},
		{"rags", "rag"},
		{"rail", "rail"},
		{"railed", "rail"},
		{"railing", "rail"},
		{"railings", "rail"},
		{"raillery", "railleri"},
		{"railroad", "railroad"},
		{"railroads", "railroad"},
		{"rails", "rail"},
		{"railway", "railway"},
		{"railways", "railway"},
		{"rain", "rain"},
		{"rainbow", "rainbow"},
		{"raindrops", "raindrop"},
		{"rained", "rain"},
		{"raining", "rain"},
		{"rains", "rain"},
		{"rainy", "raini"},
		{"raise", "rais"},
		{"raised", "rais"},
		{"raises", "rais"},
		{"raising", "rais"},
		{"raisins", "raisin"},
		{"rake", "rake"},
		{"raked", "rake"},
		{"rakes", "rake"},
		{"raking", "rake"},
		{"rakish", "rakish"},
		{"rakishly", "rakish"},
		{"rakishness", "rakish"},
		{"ral", "ral"},
		{"rallied", "ralli"},
		{"rallus", "rallus"},
		{"rally", "ralli"},
		{"rallying", "ralli"},
		{"ralph", "ralph"},
		{"ram", "ram"},
		{"ramble", "rambl"},
		{"rambled", "rambl"},
		{"rambles", "rambl"},
		{"rambling", "rambl"},
		{"ramification", "ramif"},
		{"ramirez", "ramirez"},
		{"rammer", "rammer"},
		{"rampant", "rampant"},
		{"rampart", "rampart"},
		{"ramsden", "ramsden"},
		{"ramsgate", "ramsgat"},
		{"ran", "ran"},
		{"rana", "rana"},
		{"rancagua", "rancagua"},
		{"ranche", "ranch"},
		{"rancho", "rancho"},
		{"ranchos", "rancho"},
		{"rancorous", "rancor"},
		{"rancorously", "rancor"},
		{"rancour", "rancour"},
		{"randal", "randal"},
		{"randall", "randal"},
		{"random", "random"},
		{"rang", "rang"},
		{"range", "rang"},
		{"ranged", "rang"},
		{"rangees", "range"},
		{"ranges", "rang"},
		{"ranging", "rang"},
		{"rank", "rank"},
		{"ranked", "rank"},
		{"rankled", "rankl"},
		{"rankling", "rankl"},
		{"rankness", "rank"},
		{"ranks", "rank"},
		{"ransack", "ransack"},
		{"ransacked", "ransack"},
		{"ransacking", "ransack"},
		{"rap", "rap"},
		{"rapacious", "rapaci"},
		{"rapacity", "rapac"},
		{"raphael", "raphael"},
		{"rapid", "rapid"},
		{"rapidity", "rapid"},
		{"rapidly", "rapid"},
		{"rapine", "rapin"},
		{"rapping", "rap"},
		{"raps", "rap"},
		{"rapt", "rapt"},
		{"rapture", "raptur"},
		{"raptures", "raptur"},
		{"rapturous", "raptur"},
		{"rapturously", "raptur"},
		{"rare", "rare"},
		{"rarefied", "rarefi"},
		{"rarely", "rare"},
		{"rarer", "rarer"},
		{"rarest", "rarest"},
		{"rarity", "rariti"},
		{"rascal", "rascal"},
		{"rascality", "rascal"},
		{"rascally", "rascal"},
		{"rascals", "rascal"},
		{"rash", "rash"},
		{"rasher", "rasher"},
		{"rashly", "rash"},
		{"rashness", "rash"},
		{"raskolnikov", "raskolnikov"},
		{"raspberries", "raspberri"},
		{"raspberry", "raspberri"},
		{"rasper", "rasper"},
		{"rastro", "rastro"},
		{"rat", "rat"},
		{"rate", "rate"},
		{"rated", "rate"},
		{"rates", "rate"},
		{"rathe", "rath"},
		{"rather", "rather"},
		{"ratio", "ratio"},
		{"rational", "ration"},
		{"rationally", "ration"},
		{"rations", "ration"},
		{"rats", "rat"},
		{"rattle", "rattl"},
		{"rattled", "rattl"},
		{"rattler", "rattler"},
		{"rattlers", "rattler"},
		{"rattles", "rattl"},
		{"rattlesnake", "rattlesnak"},
		{"rattling", "rattl"},
		{"rattus", "rattus"},
		{"ravaged", "ravag"},
		{"ravages", "ravag"},
		{"ravaging", "ravag"},
		{"rave", "rave"},
		{"raved", "rave"},
		{"raven", "raven"},
		{"ravenous", "raven"},
		{"ravenously", "raven"},
		{"ravens", "raven"},
		{"ravine", "ravin"},
		{"ravines", "ravin"},
		{"raving", "rave"},
		{"ravings", "rave"},
		{"ravins", "ravin"},
		{"ravishing", "ravish"},
		{"raw", "raw"},
		{"rawest", "rawest"},
		{"ray", "ray"},
		{"rays", "ray"},
		{"razor", "razor"},
		{"razors", "razor"},
		{"razsudkin", "razsudkin"},
		{"razumihin", "razumihin"},
		{"razumihins", "razumihin"},
		{"rd", "rd"},
		{"re", "re"},
		{"rea", "rea"},
		{"reach", "reach"},
		{"reached", "reach"},
		{"reaches", "reach"},
		{"reaching", "reach"},
		{"reaction", "reaction"},
		{"reactionaries", "reactionari"},
		{"reactionary", "reactionari"},
		{"read", "read"},
		{"reader", "reader"},
		{"readers", "reader"},
		{"readied", "readi"},
		{"readiest", "readiest"},
		{"readil", "readil"},
		{"readily", "readili"},
		{"readiness", "readi"},
		{"reading", "read"},
		{"readings", "read"},
		{"readjourned", "readjourn"},
		{"readjust", "readjust"},
		{"readjusted", "readjust"},
		{"readjusts", "readjust"},
		{"reads", "read"},
		{"ready", "readi"},
		{"real", "real"},
		{"realisation", "realis"},
		{"realise", "realis"},
		{"realised", "realis"},
		{"realising", "realis"},
		{"realit", "realit"},
		{"realities", "realiti"},
		{"reality", "realiti"},
		{"realize", "realiz"},
		{"realized", "realiz"},
		{"realizes", "realiz"},
		{"realizing", "realiz"},
		{"reall", "reall"},
		{"really", "realli"},
		{"realm", "realm"},
		{"realms", "realm"},
		{"reals", "real"},
		{"realty", "realti"},
		{"ream", "ream"},
		{"reams", "ream"},
		{"reanimate", "reanim"},
		{"reap", "reap"},
		{"reaped", "reap"},
		{"reaping", "reap"},
		{"reappear", "reappear"},
		{"reappearance", "reappear"},
		{"reappeared", "reappear"},
		{"reappearing", "reappear"},
		{"reappears", "reappear"},
		{"rear", "rear"},
		{"reared", "rear"},
		{"rearing", "rear"},
		{"rearrange", "rearrang"},
		{"rearrangements", "rearrang"},
		{"rears", "rear"},
		{"reascended", "reascend"},
		{"reascending", "reascend"},
		{"reason", "reason"},
		{"reasonable", "reason"},
		{"reasonableness", "reason"},
		{"reasonably", "reason"},
		{"reasoned", "reason"},
		{"reasoners", "reason"},
		{"reasoning", "reason"},
		{"reasons", "reason"},
		{"reassume", "reassum"},
		{"reassurance", "reassur"},
		{"reassure", "reassur"},
		{"reassured", "reassur"},
		{"reassures", "reassur"},
		{"reassuring", "reassur"},
		{"reassuringly", "reassur"},
		{"reaumur", "reaumur"},
		{"rebel", "rebel"},
		{"rebelled", "rebel"},
		{"rebelling", "rebel"},
		{"rebellion", "rebellion"},
		{"rebellious", "rebelli"},
		{"rebellyon", "rebellyon"},
		{"rebels", "rebel"},
		{"rebound", "rebound"},
		{"rebounded", "rebound"},
		{"rebounding", "rebound"},
		{"rebuff", "rebuff"},
		{"rebuffed", "rebuf"},
		{"rebuilding", "rebuild"},
		{"rebuilt", "rebuilt"},
		{"rebuke", "rebuk"},
		{"rebuked", "rebuk"},
		{"rec", "rec"},
		{"recado", "recado"},
		{"recall", "recal"},
		{"recalled", "recal"},
		{"recalling", "recal"},
		{"recalls", "recal"},
		{"recantation", "recant"},
		{"recapitulate", "recapitul"},
		{"recapitulation", "recapitul"},
		{"rece", "rece"},
		{"receded", "reced"},
		{"receding", "reced"},
		{"receipt", "receipt"},
		{"receipts", "receipt"},
		{"receive", "receiv"},
		{"received", "receiv"},
		{"receiver", "receiv"},
		{"receives", "receiv"},
		{"receiving", "receiv"},
		{"recent", "recent"},
		{"recently", "recent"},
		{"reception", "recept"},
		{"receptions", "recept"},
		{"recess", "recess"},
		{"recesses", "recess"},
		{"recipe", "recip"},
		{"recipient", "recipi"},
		{"recipro", "recipro"},
		{"reciprocal", "reciproc"},
		{"reciprocate", "reciproc"},
		{"reciprocated", "reciproc"},
		{"reciprocating", "reciproc"},
		{"reciprocity", "reciproc"},
		{"recital", "recit"},
		{"recitals", "recit"},
		{"recite", "recit"},
		{"recited", "recit"},
		{"reckless", "reckless"},
		{"recklessly", "reckless"},
		{"recklessness", "reckless"},
		{"reckon", "reckon"},
		{"reckoned", "reckon"},
		{"reckoners", "reckon"},
		{"reckoning", "reckon"},
		{"reckonings", "reckon"},
		{"reclaim", "reclaim"},
		{"reclaimed", "reclaim"},
		{"reclined", "reclin"},
		{"reclines", "reclin"},
		{"reclining", "reclin"},
		{"reclosing", "reclos"},
		{"recluse", "reclus"},
		{"recognisant", "recognis"},
		{"recognise", "recognis"},
		{"recognised", "recognis"},
		{"recognising", "recognis"},
		{"recognition", "recognit"},
		{"recognize", "recogn"},
		{"recognized", "recogn"},
		{"recognizes", "recogn"},
		{"recognizing", "recogn"},
		{"recoil", "recoil"},
		{"recoiled", "recoil"},
		{"recoiling", "recoil"},
		{"recoils", "recoil"},
		{"recollect", "recollect"},
		{"recollected", "recollect"},
		{"recollecting", "recollect"},
		{"recollection", "recollect"},
		{"recollections", "recollect"},
		{"recollects", "recollect"},
		{"recommenced", "recommenc"},
		{"recommences", "recomm"},
		{"recommend", "recommend"},
		{"recommendation", "recommend"},
		{"recommended", "recommend"},
		{"recommending", "recommend"},
		{"recompense", "recompens"},
		{"recompenses", "recompens"},
		{"recomposed", "recompos"},
		{"recomposing", "recompos"},
		{"reconcilable", "reconcil"},
		{"reconcile", "reconcil"},
		{"reconciled", "reconcil"},
		{"reconcilements", "reconcil"},
		{"reconciliation", "reconcili"},
		{"reconciling", "reconcil"},
		{"reconnoitre", "reconnoitr"},
		{"reconnoitred", "reconnoitr"},
		{"reconsider", "reconsid"},
		{"reconsideration", "reconsider"},
		{"reconsidering", "reconsid"},
		{"reconsigning", "reconsign"},
		{"reconsignment", "reconsign"},
		{"recopied", "recopi"},
		{"record", "record"},
		{"recorded", "record"},
		{"recording", "record"},
		{"records", "record"},
		{"recount", "recount"},
		{"recounted", "recount"},
		{"recounting", "recount"},
		{"recouped", "recoup"},
		{"recourse", "recours"},
		{"recover", "recov"},
		{"recovered", "recov"},
		{"recovering", "recov"},
		{"recovers", "recov"},
		{"recovery", "recoveri"},
		{"recreation", "recreat"},
		{"recreative", "recreat"},
		{"recrimination", "recrimin"},
		{"recriminations", "recrimin"},
		{"recross", "recross"},
		{"recrossed", "recross"},
		{"recrossing", "recross"},
		{"recruit", "recruit"},
		{"recruited", "recruit"},
		{"rectified", "rectifi"},
		{"rectify", "rectifi"},
		{"rectifying", "rectifi"},
		{"rectitude", "rectitud"},
		{"rectly", "rect"},
		{"rector", "rector"},
		{"rectory", "rectori"},
		{"recumbent", "recumb"},
		{"recuperative", "recup"},
		{"recur", "recur"},
		{"recurred", "recur"},
		{"recurrence", "recurr"},
		{"recurrent", "recurr"},
		{"recurring", "recur"},
		{"recurs", "recur"},
		{"recuvver", "recuvv"},
		{"red", "red"},
		{"reddened", "redden"},
		{"reddening", "redden"},
		{"redder", "redder"},
		{"reddest", "reddest"},
		{"reddish", "reddish"},
		{"reddy", "reddi"},
		{"redecorated", "redecor"},
		{"redeem", "redeem"},
		{"redeemed", "redeem"},
		{"redeemer", "redeem"},
		{"redeeming", "redeem"},
		{"redemption", "redempt"},
		{"redistribution", "redistribut"},
		{"redly", "red"},
		{"redolent", "redol"},
		{"redouble", "redoubl"},
		{"redoubled", "redoubl"},
		{"redoubling", "redoubl"},
		{"redoubtable", "redoubt"},
		{"redound", "redound"},
		{"redounded", "redound"},
		{"redress", "redress"},
		{"reduce", "reduc"},
		{"reduced", "reduc"},
		{"reduces", "reduc"},
		{"reducidos", "reducido"},
		{"reducing", "reduc"},
		{"reduction", "reduct"},
		{"reductions", "reduct"},
		{"reduvius", "reduvius"},
		{"reed", "reed"},
		{"reeds", "reed"},
		{"reef", "reef"},
		{"reefs", "reef"},
		{"reeght", "reeght"},
		{"reek", "reek"},
		{"reeked", "reek"},
		{"reeking", "reek"},
		{"reeks", "reek"},
		{"reel", "reel"},
		{"reeled", "reel"},
		{"reeling", "reel"},
		{"ref", "ref"},
		{"refer", "refer"},
		{"referable", "refer"},
		{"reference", "refer"},
		{"references", "refer"},
		{"referred", "refer"},
		{"referring", "refer"},
		{"refers", "refer"},
		{"refine", "refin"},
		{"refined", "refin"},
		{"refinement", "refin"},
		{"refinements", "refin"},
		{"refines", "refin"},
		{"refit", "refit"},
		{"reflect", "reflect"},
		{"reflected", "reflect"},
		{"reflectin", "reflectin"},
		{"reflecting", "reflect"},
		{"reflection", "reflect"},
		{"reflections", "reflect"},
		{"reflective", "reflect"},
		{"reflector", "reflector"},
		{"reflects", "reflect"},
		{"refolding", "refold"},
		{"refolds", "refold"},
		{"reform", "reform"},
		{"reformation", "reform"},
		{"reformed", "reform"},
		{"reformer", "reform"},
		{"reforming", "reform"},
		{"reforms", "reform"},
		{"refraction", "refract"},
		{"refractory", "refractori"},
		{"refrain", "refrain"},
		{"refrained", "refrain"},
		{"refrains", "refrain"},
		{"refresh", "refresh"},
		{"refreshed", "refresh"},
		{"refreshes", "refresh"},
		{"refreshing", "refresh"},
		{"refreshingly", "refresh"},
		{"refreshment", "refresh"},
		{"refreshments", "refresh"},
		{"refrigerator", "refriger"},
		{"refuge", "refug"},
		{"refugees", "refuge"},
		{"refulgent", "refulg"},
		{"refund", "refund"},
		{"refunded", "refund"},
		{"refurnish", "refurnish"},
		{"refusal", "refus"},
		{"refuse", "refus"},
		{"refused", "refus"},
		{"refuses", "refus"},
		{"refusest", "refusest"},
		{"refusing", "refus"},
		{"refutation", "refut"},
		{"refute", "refut"},
		{"reg", "reg"},
		{"regain", "regain"},
		{"regained", "regain"},
		{"regaining", "regain"},
		{"regains", "regain"},
		{"regal", "regal"},
		{"regale", "regal"},
		{"regaled", "regal"},
		{"regaling", "regal"},
		{"regard", "regard"},
		{"regarded", "regard"},
		{"regardful", "regard"},
		{"regarding", "regard"},
		{"regardless", "regardless"},
		{"regards", "regard"},
		{"regeneration", "regener"},
		{"regent", "regent"},
		{"regimen", "regimen"},
		{"regiment", "regiment"},
		{"regimental", "regiment"},
		{"reginald", "reginald"},
		{"region", "region"},
		{"regions", "region"},
		{"register", "regist"},
		{"registered", "regist"},
		{"registrar", "registrar"},
		{"registries", "registri"},
		{"regression", "regress"},
		{"regret", "regret"},
		{"regretful", "regret"},
		{"regretfully", "regret"},
		{"regrets", "regret"},
		{"regretted", "regret"},
		{"regretting", "regret"},
		{"regular", "regular"},
		{"regularity", "regular"},
		{"regularly", "regular"},
		{"regulars", "regular"},
		{"regulate", "regul"},
		{"regulated", "regul"},
		{"regulates", "regul"},
		{"regulating", "regul"},
		{"regulation", "regul"},
		{"rehearsal", "rehears"},
		{"rehearse", "rehears"},
		{"rehearsed", "rehears"},
		{"reid", "reid"},
		{"reign", "reign"},
		{"reigned", "reign"},
		{"reigning", "reign"},
		{"reigns", "reign"},
		{"reimbursed", "reimburs"},
		{"rein", "rein"},
		{"reindeer", "reindeer"},
		{"reined", "rein"},
		{"reinforced", "reinforc"},
		{"reining", "rein"},
		{"reins", "rein"},
		{"reinstated", "reinstat"},
		{"reinstating", "reinstat"},
		{"reiterated", "reiter"},
		{"reiterates", "reiter"},
		{"reiteration", "reiter"},
		{"reithrodon", "reithrodon"},
		{"reject", "reject"},
		{"rejected", "reject"},
		{"rejecting", "reject"},
		{"rejection", "reject"},
		{"rejects", "reject"},
		{"rejoice", "rejoic"},
		{"rejoiced", "rejoic"},
		{"rejoices", "rejoic"},
		{"rejoicing", "rejoic"},
		{"rejoicings", "rejoic"},
		{"rejoin", "rejoin"},
		{"rejoinder", "rejoind"},
		{"rejoinders", "rejoind"},
		{"rejoined", "rejoin"},
		{"rejoining", "rejoin"},
		{"rejoins", "rejoin"},
		{"rekindled", "rekindl"},
		{"relapse", "relaps"},
		{"relapsed", "relaps"},
		{"relapses", "relaps"},
		{"relapsing", "relaps"},
		{"relate", "relat"},
		{"related", "relat"},
		{"relates", "relat"},
		{"relating", "relat"},
		{"relation", "relat"},
		{"relations", "relat"},
		{"relationship", "relationship"},
		{"relative", "relat"},
		{"relatively", "relat"},
		{"relatives", "relat"},
		{"relax", "relax"},
		{"relaxation", "relax"},
		{"relaxations", "relax"},
		{"relaxe", "relax"},
		{"relaxed", "relax"},
		{"relaxes", "relax"},
		{"relaxing", "relax"},
		{"relays", "relay"},
		{"release", "releas"},
		{"released", "releas"},
		{"releases", "releas"},
		{"releasing", "releas"},
		{"relent", "relent"},
		{"relented", "relent"},
		{"relenting", "relent"},
		{"relentless", "relentless"},
		{"relents", "relent"},
		{"reliable", "reliabl"},
		{"reliance", "relianc"},
		{"reliant", "reliant"},
		{"relic", "relic"},
		{"relics", "relic"},
		{"relict", "relict"},
		{"relied", "reli"},
		{"relief", "relief"},
		{"reliefs", "relief"},
		{"relies", "reli"},
		{"relieve", "reliev"},
		{"relieved", "reliev"},
		{"relieves", "reliev"},
		{"relieving", "reliev"},
		{"religion", "religion"},
		{"religions", "religion"},
		{"religious", "religi"},
		{"religiously", "religi"},
		{"relinquish", "relinquish"},
		{"relinquished", "relinquish"},
		{"relinquishing", "relinquish"},
		{"relinquishment", "relinquish"},
		{"reliques", "reliqu"},
		{"relish", "relish"},
		{"relished", "relish"},
		{"relishing", "relish"},
		{"reluctance", "reluct"},
		{"reluctant", "reluct"},
		{"reluctantly", "reluct"},
		{"rely", "reli"},
		{"relying", "reli"},
		{"remain", "remain"},
		{"remainder", "remaind"},
		{"remaine", "remain"},
		{"remained", "remain"},
		{"remaining", "remain"},
		{"remains", "remain"},
		{"remand", "remand"},
		{"remanded", "remand"},
		{"remands", "remand"},
		{"remark", "remark"},
		{"remarkable", "remark"},
		{"remarkably", "remark"},
		{"remarked", "remark"},
		{"remarkedly", "remark"},
		{"remarking", "remark"},
		{"remarks", "remark"},
		{"remedies", "remedi"},
		{"remedy", "remedi"},
		{"remember", "rememb"},
		{"remembered", "rememb"},
		{"remembering", "rememb"},
		{"remembers", "rememb"},
		{"remembrance", "remembr"},
		{"remembrances", "remembr"},
		{"remensher", "remensh"},
		{"remind", "remind"},
		{"reminded", "remind"},
		{"reminder", "remind"},
		{"reminders", "remind"},
		{"reminding", "remind"},
		{"remindingmanfact", "remindingmanfact"},
		{"reminds", "remind"},
		{"reminiscence", "reminisc"},
		{"reminiscences", "reminisc"},
		{"reminiscent", "reminisc"},
		{"remiss", "remiss"},
		{"remit", "remit"},
		{"remittance", "remitt"},
		{"remitting", "remit"},
		{"remnant", "remnant"},
		{"remnants", "remnant"},
		{"remonstrance", "remonstr"},
		{"remonstrances", "remonstr"},
		{"remonstrate", "remonstr"},
		{"remonstrated", "remonstr"},
		{"remonstrates", "remonstr"},
		{"remonstrating", "remonstr"},
		{"remonstrative", "remonstr"},
		{"remorse", "remors"},
		{"remorseful", "remors"},
		{"remote", "remot"},
		{"remotely", "remot"},
		{"remoteness", "remot"},
		{"remotest", "remotest"},
		{"remounted", "remount"},
		{"removal", "remov"},
		{"removals", "remov"},
		{"remove", "remov"},
		{"removed", "remov"},
		{"removes", "remov"},
		{"removing", "remov"},
		{"remplir", "remplir"},
		{"remunerate", "remuner"},
		{"remunerated", "remuner"},
		{"remuneration", "remuner"},
		{"rend", "rend"},
		{"render", "render"},
		{"rendered", "render"},
		{"rendering", "render"},
		{"renders", "render"},
		{"rendezvous", "rendezv"},
		{"rending", "rend"},
		{"rendus", "rendus"},
		{"renegade", "renegad"},
		{"renew", "renew"},
		{"renewable", "renew"},
		{"renewal", "renew"},
		{"renewals", "renew"},
		{"renewed", "renew"},
		{"renewing", "renew"},
		{"renews", "renew"},
		{"rengger", "rengger"},
		{"renounce", "renounc"},
		{"renounced", "renounc"},
		{"renouncing", "renounc"},
		{"renous", "renous"},
		{"renovation", "renov"},
		{"renown", "renown"},
		{"renowned", "renown"},
		{"rent", "rent"},
		{"rents", "rent"},
		{"renunciation", "renunci"},
		{"repacked", "repack"},
		{"repaid", "repaid"},
		{"repair", "repair"},
		{"repaired", "repair"},
		{"repairing", "repair"},
		{"repairs", "repair"},
		{"reparation", "repar"},
		{"repartee", "reparte"},
		{"repass", "repass"},
		{"repassed", "repass"},
		{"repassing", "repass"},
		{"repast", "repast"},
		{"repay", "repay"},
		{"repaying", "repay"},
		{"repayment", "repay"},
		{"repays", "repay"},
		{"repeal", "repeal"},
		{"repealed", "repeal"},
		{"repeat", "repeat"},
		{"repeated", "repeat"},
		{"repeatedly", "repeat"},
		{"repeater", "repeat"},
		{"repeating", "repeat"},
		{"repeats", "repeat"},
		{"repeatually", "repeatu"},
		{"repel", "repel"},
		{"repelled", "repel"},
		{"repellent", "repel"},
		{"repelling", "repel"},
		{"repent", "repent"},
		{"repentance", "repent"},
		{"repentant", "repent"},
		{"repented", "repent"},
		{"repenteth", "repenteth"},
		{"repenting", "repent"},
		{"repents", "repent"},
		{"reperusal", "reperus"},
		{"repetition", "repetit"},
		{"repetitions", "repetit"},
		{"rephed", "reph"},
		{"repine", "repin"},
		{"repined", "repin"},
		{"repines", "repin"},
		{"repining", "repin"},
		{"replace", "replac"},
		{"replaced", "replac"},
		{"replaces", "replac"},
		{"replacing", "replac"},
		{"replenishing", "replenish"},
		{"replete", "replet"},
		{"repletion", "replet"},
		{"replied", "repli"},
		{"replies", "repli"},
		{"reply", "repli"},
		{"replying", "repli"},
		{"report", "report"},
		{"reported", "report"},
		{"reporter", "report"},
		{"reporters", "report"},
		{"reporting", "report"},
		{"reports", "report"},
		{"repose", "repos"},
		{"reposed", "repos"},
		{"reposes", "repos"},
		{"reposing", "repos"},
		{"repository", "repositori"},
		{"repossess", "repossess"},
		{"repossession", "repossess"},
		{"reprehensible", "reprehens"},
		{"reprehension", "reprehens"},
		{"represent", "repres"},
		{"representation", "represent"},
		{"representations", "represent"},
		{"representative", "repres"},
		{"representatives", "repres"},
		{"represented", "repres"},
		{"representing", "repres"},
		{"represents", "repres"},
		{"repress", "repress"},
		{"repressed", "repress"},
		{"repressing", "repress"},
		{"reprieve", "repriev"},
		{"reprint", "reprint"},
		{"reprinted", "reprint"},
		{"reproach", "reproach"},
		{"reproached", "reproach"},
		{"reproaches", "reproach"},
		{"reproachful", "reproach"},
		{"reproachfully", "reproach"},
		{"reproaching", "reproach"},
		{"reprobate", "reprob"},
		{"reprobates", "reprob"},
		{"reprobation", "reprob"},
		{"reproduce", "reproduc"},
		{"reproduced", "reproduc"},
		{"reproducing", "reproduc"},
		{"reproof", "reproof"},
		{"reproofs", "reproof"},
		{"reprove", "reprov"},
		{"reproved", "reprov"},
		{"reprovingly", "reprov"},
		{"reptile", "reptil"},
		{"reptiles", "reptil"},
		{"republic", "republ"},
		{"republican", "republican"},
		{"republicanism", "republican"},
		{"republicans", "republican"},
		{"republics", "republ"},
		{"republished", "republish"},
		{"repudiate", "repudi"},
		{"repudiated", "repudi"},
		{"repudiating", "repudi"},
		{"repudiation", "repudi"},
		{"repugnance", "repugn"},
		{"repugnant", "repugn"},
		{"repulse", "repuls"},
		{"repulsed", "repuls"},
		{"repulsion", "repuls"},
		{"repulsive", "repuls"},
		{"reputable", "reput"},
		{"reputation", "reput"},
		{"reputations", "reput"},
		{"repute", "reput"},
		{"reputed", "reput"},
		{"request", "request"},
		{"requested", "request"},
		{"requesting", "request"},
		{"requests", "request"},
		{"requiem", "requiem"},
		{"require", "requir"},
		{"required", "requir"},
		{"requirements", "requir"},
		{"requires", "requir"},
		{"requiring", "requir"},
		{"requisite", "requisit"},
		{"requisites", "requisit"},
		{"requisition", "requisit"},
		{"requite", "requit"},
		{"reread", "reread"},
		{"rescue", "rescu"},
		{"rescued", "rescu"},
		{"rescuers", "rescuer"},
		{"rescuing", "rescu"},
		{"research", "research"},
		{"researches", "research"},
		{"resemblance", "resembl"},
		{"resemble", "resembl"},
		{"resembled", "resembl"},
		{"resembles", "resembl"},
		{"resembling", "resembl"},
		{"resent", "resent"},
		{"resented", "resent"},
		{"resentful", "resent"},
		{"resentfully", "resent"},
		{"resenting", "resent"},
		{"resentment", "resent"},
		{"resentments", "resent"},
		{"resents", "resent"},
		{"reservation", "reserv"},
		{"reservations", "reserv"},
		{"reserve", "reserv"},
		{"reserved", "reserv"},
		{"reserves", "reserv"},
		{"reserving", "reserv"},
		{"reservoir", "reservoir"},
		{"reservoirs", "reservoir"},
		{"resettles", "resettl"},
		{"resfless", "resfless"},
		{"reside", "resid"},
		{"resided", "resid"},
		{"residence", "resid"},
		{"residences", "resid"},
		{"resident", "resid"},
		{"residents", "resid"},
		{"resides", "resid"},
		{"residing", "resid"},
		{"residue", "residu"},
		{"resign", "resign"},
		{"resignation", "resign"},
		{"resignations", "resign"},
		{"resigned", "resign"},
		{"resigning", "resign"},
		{"resigns", "resign"},
		{"resin", "resin"},
		{"resinous", "resin"},
		{"resist", "resist"},
		{"resistance", "resist"},
		{"resisted", "resist"},
		{"resisting", "resist"},
		{"resists", "resist"},
		{"resoled", "resol"},
		{"resolute", "resolut"},
		{"resolutely", "resolut"},
		{"resolution", "resolut"},
		{"resolutions", "resolut"},
		{"resolve", "resolv"},
		{"resolved", "resolv"},
		{"resolves", "resolv"},
		{"resolving", "resolv"},
		{"resonant", "reson"},
		{"resort", "resort"},
		{"resorted", "resort"},
		{"resorting", "resort"},
		{"resorts", "resort"},
		{"resound", "resound"},
		{"resounded", "resound"},
		{"resounding", "resound"},
		{"resource", "resourc"},
		{"resourcefulness", "resourc"},
		{"resources", "resourc"},
		{"respect", "respect"},
		{"respectabilities", "respect"},
		{"respectability", "respect"},
		{"respectable", "respect"},
		{"respectably", "respect"},
		{"respected", "respect"},
		{"respectful", "respect"},
		{"respectfully", "respect"},
		{"respecting", "respect"},
		{"respective", "respect"},
		{"respectively", "respect"},
		{"respects", "respect"},
		{"respiration", "respir"},
		{"respite", "respit"},
		{"resplendent", "resplend"},
		{"resplendently", "resplend"},
		{"respond", "respond"},
		{"responded", "respond"},
		{"responding", "respond"},
		{"responds", "respond"},
		{"response", "respons"},
		{"responsibilities", "respons"},
		{"responsibility", "respons"},
		{"responsible", "respons"},
		{"responsive", "respons"},
		{"resslich", "resslich"},
		{"rest", "rest"},
		{"restaurant", "restaur"},
		{"restaurants", "restaur"},
		{"rested", "rest"},
		{"restful", "rest"},
		{"resting", "rest"},
		{"restitution", "restitut"},
		{"restive", "restiv"},
		{"restless", "restless"},
		{"restlessly", "restless"},
		{"restlessness", "restless"},
		{"restoration", "restor"},
		{"restorative", "restor"},
		{"restoratives", "restor"},
		{"restore", "restor"},
		{"restored", "restor"},
		{"restores", "restor"},
		{"restoring", "restor"},
		{"restrain", "restrain"},
		{"restrained", "restrain"},
		{"restraining", "restrain"},
		{"restrains", "restrain"},
		{"restraint", "restraint"},
		{"restraints", "restraint"},
		{"restrictions", "restrict"},
		{"rests", "rest"},
		{"resuit", "resuit"},
		{"result", "result"},
		{"resultant", "result"},
		{"resulted", "result"},
		{"resulting", "result"},
		{"results", "result"},
		{"resume", "resum"},
		{"resumed", "resum"},
		{"resumes", "resum"},
		{"resuming", "resum"},
		{"resumption", "resumpt"},
		{"resurrected", "resurrect"},
		{"resurrection", "resurrect"},
		{"resurrections", "resurrect"},
		{"resuscitated", "resuscit"},
		{"retail", "retail"},
		{"retain", "retain"},
		{"retained", "retain"},
		{"retainer", "retain"},
		{"retainers", "retain"},
		{"retaining", "retain"},
		{"retains", "retain"},
		{"retaliate", "retali"},
		{"retaliated", "retali"},
		{"retaliation", "retali"},
		{"retard", "retard"},
		{"retarded", "retard"},
		{"retches", "retch"},
		{"retention", "retent"},
		{"reticence", "retic"},
		{"reticent", "retic"},
		{"reticles", "reticl"},
		{"reticule", "reticul"},
		{"reticules", "reticul"},
		{"retinue", "retinu"},
		{"retire", "retir"},
		{"retired", "retir"},
		{"retirement", "retir"},
		{"retirements", "retir"},
		{"retires", "retir"},
		{"retiring", "retir"},
		{"retored", "retor"},
		{"retort", "retort"},
		{"retorted", "retort"},
		{"retorting", "retort"},
		{"retorts", "retort"},
		{"retouching", "retouch"},
		{"retrace", "retrac"},
		{"retraced", "retrac"},
		{"retraces", "retrac"},
		{"retract", "retract"},
		{"retracted", "retract"},
		{"retraction", "retract"},
		{"retreat", "retreat"},
		{"retreated", "retreat"},
		{"retreating", "retreat"},
		{"retreats", "retreat"},
		{"retrenchment", "retrench"},
		{"retrenchments", "retrench"},
		{"retribution", "retribut"},
		{"retributive", "retribut"},
		{"retrievable", "retriev"},
		{"retrieve", "retriev"},
		{"retrieved", "retriev"},
		{"retrieving", "retriev"},
		{"retrograde", "retrograd"},
		{"retrograding", "retrograd"},
		{"retrorsum", "retrorsum"},
		{"retrospect", "retrospect"},
		{"retrospective", "retrospect"},
		{"return", "return"},
		{"returned", "return"},
		{"returning", "return"},
		{"returns", "return"},
		{"retzch", "retzch"},
		{"reunion", "reunion"},
		{"rev", "rev"},
		{"reveal", "reveal"},
		{"revealed", "reveal"},
		{"revealing", "reveal"},
		{"revel", "revel"},
		{"revelation", "revel"},
		{"revelations", "revel"},
		{"revelled", "revel"},
		{"revellers", "revel"},
		{"revelling", "revel"},
		{"revelry", "revelri"},
		{"revels", "revel"},
		{"revenge", "reveng"},
		{"revenged", "reveng"},
		{"revengeful", "reveng"},
		{"revenges", "reveng"},
		{"revenging", "reveng"},
		{"revenue", "revenu"},
		{"reverberate", "reverber"},
		{"reverberated", "reverber"},
		{"reverberates", "reverber"},
		{"reverberating", "reverber"},
		{"reverberation", "reverber"},
		{"revered", "rever"},
		{"reverence", "rever"},
		{"reverenced", "reverenc"},
		{"reverend", "reverend"},
		{"reverends", "reverend"},
		{"reverent", "rever"},
		{"reverential", "reverenti"},
		{"reverentially", "reverenti"},
		{"reverently", "rever"},
		{"reverie", "reveri"},
		{"reversal", "revers"},
		{"reverse", "revers"},
		{"reversed", "revers"},
		{"reverses", "revers"},
		{"reversion", "revers"},
		{"revert", "revert"},
		{"reverted", "revert"},
		{"reverting", "revert"},
		{"reverts", "revert"},
		{"reviendra", "reviendra"},
		{"review", "review"},
		{"reviewal", "review"},
		{"reviewing", "review"},
		{"reviews", "review"},
		{"revile", "revil"},
		{"reviled", "revil"},
		{"reviling", "revil"},
		{"revilings", "revil"},
		{"revise", "revis"},
		{"revision", "revis"},
		{"revisit", "revisit"},
		{"revisited", "revisit"},
		{"revival", "reviv"},
		{"revive", "reviv"},
		{"revived", "reviv"},
		{"reviving", "reviv"},
		{"revivingly", "reviv"},
		{"revoke", "revok"},
		{"revoked", "revok"},
		{"revolt", "revolt"},
		{"revolted", "revolt"},
		{"revolting", "revolt"},
		{"revolts", "revolt"},
		{"revolution", "revolut"},
		{"revolutionary", "revolutionari"},
		{"revolutionist", "revolutionist"},
		{"revolutionized", "revolution"},
		{"revolutions", "revolut"},
		{"revolve", "revolv"},
		{"revolved", "revolv"},
		{"revolver", "revolv"},
		{"revolves", "revolv"},
		{"revolving", "revolv"},
		{"revulsion", "revuls"},
		{"reward", "reward"},
		{"rewarded", "reward"},
		{"rewarding", "reward"},
		{"rewards", "reward"},
		{"rewashed", "rewash"},
		{"rex", "rex"},
		{"rexes", "rex"},
		{"rhapsody", "rhapsodi"},
		{"rhea", "rhea"},
		{"rheims", "rheim"},
		{"rhetoric", "rhetor"},
		{"rheumatic", "rheumat"},
		{"rheumatics", "rheumat"},
		{"rheumatism", "rheumat"},
		{"rhine", "rhine"},
		{"rhinoceros", "rhinocero"},
		{"rhinoceroses", "rhinoceros"},
		{"rhododendron", "rhododendron"},
		{"rhododendrons", "rhododendron"},
		{"rhubarb", "rhubarb"},
		{"rhyme", "rhyme"},
		{"rhymes", "rhyme"},
		{"rhynchops", "rhynchop"},
		{"rhyncophora", "rhyncophora"},
		{"rhythmically", "rhythmic"},
		{"ri", "ri"},
		{"rib", "rib"},
		{"ribbed", "rib"},
		{"ribbentrop", "ribbentrop"},
		{"ribbon", "ribbon"},
		{"ribbons", "ribbon"},
		{"ribeira", "ribeira"},
		{"ribs", "rib"},
		{"rice", "rice"},
		{"rich", "rich"},
		{"richard", "richard"},
		{"richardson", "richardson"},
		{"richer", "richer"},
		{"riches", "rich"},
		{"richest", "richest"},
		{"richly", "rich"},
		{"richmond", "richmond"},
		{"richness", "rich"},
		{"rick", "rick"},
		{"rickety", "ricketi"},
		{"rickworth", "rickworth"},
		{"rid", "rid"},
		{"riddance", "riddanc"},
		{"ridden", "ridden"},
		{"ridding", "rid"},
		{"riddle", "riddl"},
		{"riddles", "riddl"},
		{"ride", "ride"},
		{"ridendus", "ridendus"},
		{"rider", "rider"},
		{"riders", "rider"},
		{"rides", "ride"},
		{"ridg", "ridg"},
		{"ridge", "ridg"},
		{"ridges", "ridg"},
		{"ridicule", "ridicul"},
		{"ridiculed", "ridicul"},
		{"ridiculous", "ridicul"},
		{"ridiculously", "ridicul"},
		{"riding", "ride"},
		{"ridinghood", "ridinghood"},
		{"rife", "rife"},
		{"riff", "riff"},
		{"rifle", "rifl"},
		{"rifles", "rifl"},
		{"rifling", "rifl"},
		{"rig", "rig"},
		{"rigamarole", "rigamarol"},
		{"riggers", "rigger"},
		{"rigging", "rig"},
		{"right", "right"},
		{"righted", "right"},
		{"righteous", "righteous"},
		{"righteousness", "righteous"},
		{"rightly", "right"},
		{"rights", "right"},
		{"rigid", "rigid"},
		{"rigidity", "rigid"},
		{"rigidly", "rigid"},
		{"rigorous", "rigor"},
		{"rigour", "rigour"},
		{"rigueur", "rigueur"},
		{"rill", "rill"},
		{"rim", "rim"},
		{"rims", "rim"},
		{"rimsky", "rimski"},
		{"rincon", "rincon"},
		{"ring", "ring"},
		{"ringed", "ring"},
		{"ringer", "ringer"},
		{"ringing", "ring"},
		{"ringleaders", "ringlead"},
		{"ringlets", "ringlet"},
		{"rings", "ring"},
		{"rinse", "rins"},
		{"rinsing", "rins"},
		{"rio", "rio"},
		{"rios", "rio"},
		{"riot", "riot"},
		{"riotous", "riotous"},
		{"rip", "rip"},
		{"ripe", "ripe"},
		{"ripen", "ripen"},
		{"ripened", "ripen"},
		{"ripening", "ripen"},
		{"ripens", "ripen"},
		{"ripped", "rip"},
		{"ripple", "rippl"},
		{"rippled", "rippl"},
		{"ripples", "rippl"},
		{"rippling", "rippl"},
		{"rise", "rise"},
		{"risen", "risen"},
		{"risers", "riser"},
		{"rises", "rise"},
		{"risible", "risibl"},
		{"risin", "risin"},
		{"rising", "rise"},
		{"risingham", "risingham"},
		{"risk", "risk"},
		{"risked", "risk"},
		{"risking", "risk"},
		{"risks", "risk"},
		{"risky", "riski"},
		{"rite", "rite"},
		{"rites", "rite"},
		{"rival", "rival"},
		{"rivalled", "rival"},
		{"rivalry", "rivalri"},
		{"rivals", "rival"},
		{"rivalship", "rivalship"},
		{"rive", "rive"},
		{"river", "river"},
		{"rivers", "river"},
		{"rivet", "rivet"},
		{"riveted", "rivet"},
		{"riveting", "rivet"},
		{"rivetted", "rivet"},
		{"riviere", "rivier"},
		{"rivoli", "rivoli"},
		{"rivulet", "rivulet"},
		{"rivulets", "rivulet"},
		{"ro", "ro"},
		{"road", "road"},
		{"roads", "road"},
		{"roadside", "roadsid"},
		{"roam", "roam"},
		{"roamed", "roam"},
		{"roaming", "roam"},
		{"roams", "roam"},
		{"roan", "roan"},
		{"roar", "roar"},
		{"roared", "roar"},
		{"roarer", "roarer"},
		{"roaring", "roar"},
		{"roast", "roast"},
		{"roasted", "roast"},
		{"roasting", "roast"},
		{"rob", "rob"},
		{"robbed", "rob"},
		{"robber", "robber"},
		{"robberies", "robberi"},
		{"robbers", "robber"},
		{"robbery", "robberi"},
		{"robbing", "rob"},
		{"robe", "robe"},
		{"robed", "robe"},
		{"robert", "robert"},
		{"roberto", "roberto"},
		{"robes", "robe"},
		{"robin", "robin"},
		{"robing", "robe"},
		{"robinson", "robinson"},
		{"robs", "rob"},
		{"robust", "robust"},
		{"robustly", "robust"},
		{"robustus", "robustus"},
		{"roby", "robi"},
		{"robys", "robi"},
		{"rochester", "rochest"},
		{"rock", "rock"},
		{"rocked", "rock"},
		{"rocket", "rocket"},
		{"rockets", "rocket"},
		{"rocking", "rock"},
		{"rocks", "rock"},
		{"rocky", "rocki"},
		{"rod", "rod"},
		{"rode", "rode"},
		{"rodent", "rodent"},
		{"rodentia", "rodentia"},
		{"rodents", "rodent"},
		{"rodeo", "rodeo"},
		{"rodion", "rodion"},
		{"rodionovitch", "rodionovitch"},
		{"rods", "rod"},
		{"rodya", "rodya"},
		{"roe", "roe"},
		{"roger", "roger"},
		{"rogers", "roger"},
		{"rogue", "rogu"},
		{"roguery", "rogueri"},
		{"rogues", "rogu"},
		{"roi", "roi"},
		{"rokeby", "rokebi"},
		{"role", "role"},
		{"roles", "role"},
		{"roll", "roll"},
		{"rolle", "roll"},
		{"rolled", "roll"},
		{"roller", "roller"},
		{"rollicking", "rollick"},
		{"rolling", "roll"},
		{"rollings", "roll"},
		{"rolls", "roll"},
		{"rolor", "rolor"},
		{"roman", "roman"},
		{"romance", "romanc"},
		{"romancing", "romanc"},
		{"romanovitch", "romanovitch"},
		{"romanovna", "romanovna"},
		{"romans", "roman"},
		{"romantic", "romant"},
		{"romantically", "romant"},
		{"rome", "rome"},
		{"romeo", "romeo"},
		{"romish", "romish"},
		{"romp", "romp"},
		{"romping", "romp"},
		{"roof", "roof"},
		{"roofed", "roof"},
		{"roofs", "roof"},
		{"rooge", "roog"},
		{"rook", "rook"},
		{"rookery", "rookeri"},
		{"rookh", "rookh"},
		{"rooks", "rook"},
		{"room", "room"},
		{"roomed", "room"},
		{"roomer", "roomer"},
		{"rooms", "room"},
		{"roomy", "roomi"},
		{"roon", "roon"},
		{"roonaway", "roonaway"},
		{"roosher", "roosher"},
		{"roost", "roost"},
		{"roosting", "roost"},
		{"root", "root"},
		{"rooted", "root"},
		{"rooteth", "rooteth"},
		{"roots", "root"},
		{"rope", "rope"},
		{"ropemakers", "ropemak"},
		{"ropes", "rope"},
		{"rosa", "rosa"},
		{"rosary", "rosari"},
		{"rosas", "rosa"},
		{"rose", "rose"},
		{"roseate", "roseat"},
		{"rosebud", "rosebud"},
		{"roses", "rose"},
		{"rosettes", "rosett"},
		{"rosewood", "rosewood"},
		{"rosina", "rosina"},
		{"rosinas", "rosina"},
		{"ross", "ross"},
		{"rosy", "rosi"},
		{"rot", "rot"},
		{"rotation", "rotat"},
		{"rotatory", "rotatori"},
		{"rote", "rote"},
		{"rotted", "rot"},
		{"rotten", "rotten"},
		{"rottenness", "rotten"},
		{"rotting", "rot"},
		{"rouble", "roubl"},
		{"roubles", "roubl"},
		{"roue", "roue"},
		{"rouge", "roug"},
		{"rouged", "roug"},
		{"rough", "rough"},
		{"roughening", "roughen"},
		{"rougher", "rougher"},
		{"roughest", "roughest"},
		{"roughing", "rough"},
		{"roughly", "rough"},
		{"roughness", "rough"},
		{"roughs", "rough"},
		{"roulette", "roulett"},
		{"rounceweil", "rounceweil"},
		{"rouncewell", "rouncewel"},
		{"rouncewells", "rouncewel"},
		{"round", "round"},
		{"roundabout", "roundabout"},
		{"rounde", "round"},
		{"rounded", "round"},
		{"rounder", "rounder"},
		{"roundest", "roundest"},
		{"rounding", "round"},
		{"roundly", "round"},
		{"roundness", "round"},
		{"rounds", "round"},
		{"rouse", "rous"},
		{"roused", "rous"},
		{"rousing", "rous"},
		{"rousseau", "rousseau"},
		{"rout", "rout"},
		{"route", "rout"},
		{"routed", "rout"},
		{"routes", "rout"},
		{"routine", "routin"},
		{"rover", "rover"},
		{"roving", "rove"},
		{"row", "row"},
		{"rowed", "row"},
		{"rowel", "rowel"},
		{"rowing", "row"},
		{"rowland", "rowland"},
		{"rowling", "rowl"},
		{"rows", "row"},
		{"roy", "roy"},
		{"royal", "royal"},
		{"royalists", "royalist"},
		{"royalty", "royalti"},
		{"roystering", "royster"},
		{"royston", "royston"},
		{"rozario", "rozario"},
		{"rt", "rt"},
		{"ruat", "ruat"},
		{"rub", "rub"},
		{"rubbed", "rub"},
		{"rubber", "rubber"},
		{"rubbers", "rubber"},
		{"rubbing", "rub"},
		{"rubbish", "rubbish"},
		{"rubbishing", "rubbish"},
		{"rubbishly", "rubbish"},
		{"rubecula", "rubecula"},
		{"rubicund", "rubicund"},
		{"rubies", "rubi"},
		{"rubinstein", "rubinstein"},
		{"rubrum", "rubrum"},
		{"rubs", "rub"},
		{"ruby", "rubi"},
		{"ruck", "ruck"},
		{"ruddier", "ruddier"},
		{"ruddle", "ruddl"},
		{"ruddy", "ruddi"},
		{"rude", "rude"},
		{"rudely", "rude"},
		{"rudeness", "rude"},
		{"ruder", "ruder"},
		{"rudest", "rudest"},
		{"rudimentary", "rudimentari"},
		{"rudiments", "rudiment"},
		{"rue", "rue"},
		{"rueful", "rueful"},
		{"ruefully", "ruefulli"},
		{"ruff", "ruff"},
		{"ruffian", "ruffian"},
		{"ruffianly", "ruffian"},
		{"ruffians", "ruffian"},
		{"ruffle", "ruffl"},
		{"ruffled", "ruffl"},
		{"rug", "rug"},
		{"rugged", "rug"},
		{"rugs", "rug"},
		{"ruin", "ruin"},
		{"ruinas", "ruina"},
		{"ruined", "ruin"},
		{"ruining", "ruin"},
		{"ruinous", "ruinous"},
		{"ruins", "ruin"},
		{"rule", "rule"},
		{"ruled", "rule"},
		{"ruler", "ruler"},
		{"rulers", "ruler"},
		{"rules", "rule"},
		{"ruling", "rule"},
		{"rum", "rum"},
		{"rumble", "rumbl"},
		{"rumbled", "rumbl"},
		{"rumbling", "rumbl"},
		{"rumicivorus", "rumicivorus"},
		{"ruminant", "rumin"},
		{"ruminants", "rumin"},
		{"ruminate", "rumin"},
		{"ruminated", "rumin"},
		{"ruminates", "rumin"},
		{"ruminating", "rumin"},
		{"ruminations", "rumin"},
		{"rummage", "rummag"},
		{"rummaged", "rummag"},
		{"rummaging", "rummag"},
		{"rummest", "rummest"},
		{"rummiest", "rummiest"},
		{"rummy", "rummi"},
		{"rumour", "rumour"},
		{"rumoured", "rumour"},
		{"rumours", "rumour"},
		{"rumpling", "rumpl"},
		{"rums", "rum"},
		{"run", "run"},
		{"runaway", "runaway"},
		{"runaways", "runaway"},
		{"rung", "rung"},
		{"running", "run"},
		{"runs", "run"},
		{"rupture", "ruptur"},
		{"ruptured", "ruptur"},
		{"rural", "rural"},
		{"rush", "rush"},
		{"rushed", "rush"},
		{"rushes", "rush"},
		{"rushing", "rush"},
		{"rushlight", "rushlight"},
		{"russell", "russel"},
		{"russet", "russet"},
		{"russia", "russia"},
		{"russian", "russian"},
		{"russians", "russian"},
		{"rust", "rust"},
		{"rusted", "rust"},
		{"rustic", "rustic"},
		{"rusticated", "rustic"},
		{"rusticities", "rustic"},
		{"rustily", "rustili"},
		{"rusting", "rust"},
		{"rustle", "rustl"},
		{"rustled", "rustl"},
		{"rustling", "rustl"},
		{"rusty", "rusti"},
		{"rut", "rut"},
		{"ruthlessly", "ruthless"},
		{"ry", "ry"},
		{"ryazan", "ryazan"},
		{"ryde", "ryde"},
		{"rylstone", "rylston"},
		{"s", "s"},
		{"sa", "sa"},
		{"sabbatarian", "sabbatarian"},
		{"sabbath", "sabbath"},
		{"sabe", "sabe"},
		{"sabine", "sabin"},
		{"sable", "sabl"},
		{"sabre", "sabr"},
		{"sabres", "sabr"},
		{"sac", "sac"},
		{"sachet", "sachet"},
		{"sack", "sack"},
		{"sackcloth", "sackcloth"},
		{"sackcloths", "sackcloth"},
		{"sacked", "sack"},
		{"sacking", "sack"},
		{"sacks", "sack"},
		{"sacrament", "sacrament"},
		{"sacramiento", "sacramiento"},
		{"sacred", "sacr"},
		{"sacredly", "sacr"},
		{"sacrifice", "sacrific"},
		{"sacrificed", "sacrif"},
		{"sacrifices", "sacrific"},
		{"sacrificing", "sacrif"},
		{"sacrilege", "sacrileg"},
		{"sad", "sad"},
		{"saddened", "sadden"},
		{"saddening", "sadden"},
		{"saddle", "saddl"},
		{"saddled", "saddl"},
		{"saddler", "saddler"},
		{"saddling", "saddl"},
		{"sadly", "sad"},
		{"sadness", "sad"},
		{"sadovy", "sadovi"},
		{"saeugethiere", "saeugethier"},
		{"safe", "safe"},
		{"safeguard", "safeguard"},
		{"safeguards", "safeguard"},
		{"safely", "safe"},
		{"safer", "safer"},
		{"safes", "safe"},
		{"safest", "safest"},
		{"safety", "safeti"},
		{"saffron", "saffron"},
		{"sagacious", "sagaci"},
		{"sagacity", "sagac"},
		{"sage", "sage"},
		{"sago", "sago"},
		{"said", "said"},
		{"sail", "sail"},
		{"sailed", "sail"},
		{"sailing", "sail"},
		{"sailor", "sailor"},
		{"sailors", "sailor"},
		{"sails", "sail"},
		{"saint", "saint"},
		{"sainted", "saint"},
		{"saintly", "saint"},
		{"saints", "saint"},
		{"saisis", "saisi"},
		{"sait", "sait"},
		{"saith", "saith"},
		{"sak", "sak"},
		{"sake", "sake"},
		{"sakes", "sake"},
		{"sal", "sal"},
		{"sala", "sala"},
		{"saladillo", "saladillo"},
		{"salado", "salado"},
		{"salaried", "salari"},
		{"salary", "salari"},
		{"sald", "sald"},
		{"sale", "sale"},
		{"salesman", "salesman"},
		{"saliferous", "salifer"},
		{"salina", "salina"},
		{"salinas", "salina"},
		{"saline", "salin"},
		{"salinus", "salinus"},
		{"salitral", "salitr"},
		{"salitrales", "salitral"},
		{"saliva", "saliva"},
		{"sallied", "salli"},
		{"sallies", "salli"},
		{"sallow", "sallow"},
		{"sally", "salli"},
		{"sallys", "salli"},
		{"salmon", "salmon"},
		{"salon", "salon"},
		{"saloon", "saloon"},
		{"saloons", "saloon"},
		{"salt", "salt"},
		{"salta", "salta"},
		{"salted", "salt"},
		{"saltenfiord", "saltenfiord"},
		{"salting", "salt"},
		{"saltire", "saltir"},
		{"saltpeter", "saltpet"},
		{"saltpetre", "saltpetr"},
		{"salts", "salt"},
		{"salubrity", "salubr"},
		{"salutary", "salutari"},
		{"salutation", "salut"},
		{"salutations", "salut"},
		{"salute", "salut"},
		{"saluted", "salut"},
		{"salutes", "salut"},
		{"saluting", "salut"},
		{"salvador", "salvador"},
		{"salvation", "salvat"},
		{"salvator", "salvat"},
		{"salver", "salver"},
		{"sam", "sam"},
		{"samaritan", "samaritan"},
		{"same", "same"},
		{"sameness", "same"},
		{"samovar", "samovar"},
		{"samovars", "samovar"},
		{"sampler", "sampler"},
		{"samples", "sampl"},
		{"samson", "samson"},
		{"san", "san"},
		{"sancho", "sancho"},
		{"sanctified", "sanctifi"},
		{"sanction", "sanction"},
		{"sanctions", "sanction"},
		{"sanctity", "sanctiti"},
		{"sanctuary", "sanctuari"},
		{"sanctum", "sanctum"},
		{"sand", "sand"},
		{"sandal", "sandal"},
		{"sandaled", "sandal"},
		{"sandalled", "sandal"},
		{"sandals", "sandal"},
		{"sanded", "sand"},
		{"sandpiper", "sandpip"},
		{"sands", "sand"},
		{"sandstone", "sandston"},
		{"sandstones", "sandston"},
		{"sandwich", "sandwich"},
		{"sandwiches", "sandwich"},
		{"sandy", "sandi"},
		{"sane", "sane"},
		{"sang", "sang"},
		{"sanger", "sanger"},
		{"sangsby", "sangsbi"},
		{"sanguinary", "sanguinari"},
		{"sanguine", "sanguin"},
		{"saniem", "saniem"},
		{"sanity", "saniti"},
		{"sank", "sank"},
		{"sant", "sant"},
		{"santa", "santa"},
		{"santiago", "santiago"},
		{"sap", "sap"},
		{"sapient", "sapient"},
		{"sapling", "sapl"},
		{"sapped", "sap"},
		{"sapphire", "sapphir"},
		{"sapphires", "sapphir"},
		{"sar", "sar"},
		{"saracen", "saracen"},
		{"saracenic", "saracen"},
		{"saracens", "saracen"},
		{"sarah", "sarah"},
		{"sarandis", "sarandi"},
		{"sarcasm", "sarcasm"},
		{"sarcastic", "sarcast"},
		{"sarcastically", "sarcast"},
		{"sarcophagus", "sarcophagus"},
		{"sarmiento", "sarmiento"},
		{"sart", "sart"},
		{"sash", "sash"},
		{"sashed", "sash"},
		{"sasiated", "sasiat"},
		{"sassafras", "sassafra"},
		{"sat", "sat"},
		{"satan", "satan"},
		{"sated", "sate"},
		{"satellite", "satellit"},
		{"satellites", "satellit"},
		{"satin", "satin"},
		{"satins", "satin"},
		{"satire", "satir"},
		{"satirical", "satir"},
		{"satirically", "satir"},
		{"satisfaction", "satisfact"},
		{"satisfactorily", "satisfactorili"},
		{"satisfactory", "satisfactori"},
		{"satisfied", "satisfi"},
		{"satisfies", "satisfi"},
		{"satisfy", "satisfi"},
		{"satisfying", "satisfi"},
		{"satrap", "satrap"},
		{"satraps", "satrap"},
		{"saturated", "satur"},
		{"saturation", "satur"},
		{"saturday", "saturday"},
		{"saturdays", "saturday"},
		{"saturnine", "saturnin"},
		{"satyr", "satyr"},
		{"sauce", "sauc"},
		{"saucepan", "saucepan"},
		{"saucepans", "saucepan"},
		{"saucer", "saucer"},
		{"saucers", "saucer"},
		{"saucily", "saucili"},
		{"saucy", "sauci"},
		{"saul", "saul"},
		{"saunter", "saunter"},
		{"sauntered", "saunter"},
		{"saunterer", "saunter"},
		{"sauntering", "saunter"},
		{"saunters", "saunter"},
		{"saurophagus", "saurophagus"},
		{"sausage", "sausag"},
		{"sausages", "sausag"},
		{"sauvages", "sauvag"},
		{"savage", "savag"},
		{"savagely", "savag"},
		{"savages", "savag"},
		{"savana", "savana"},
		{"savannahs", "savannah"},
		{"save", "save"},
		{"saved", "save"},
		{"saves", "save"},
		{"saving", "save"},
		{"savings", "save"},
		{"saviour", "saviour"},
		{"savoir", "savoir"},
		{"savour", "savour"},
		{"savoured", "savour"},
		{"savouries", "savouri"},
		{"savours", "savour"},
		{"savoury", "savouri"},
		{"saw", "saw"},
		{"sawdust", "sawdust"},
		{"saws", "saw"},
		{"sawyer", "sawyer"},
		{"saxon", "saxon"},
		{"say", "say"},
		{"saying", "say"},
		{"sayings", "say"},
		{"says", "say"},
		{"scabra", "scabra"},
		{"scabs", "scab"},
		{"scaffold", "scaffold"},
		{"scaffolding", "scaffold"},
		{"scaffolds", "scaffold"},
		{"scagliola", "scagliola"},
		{"scald", "scald"},
		{"scalded", "scald"},
		{"scalding", "scald"},
		{"scale", "scale"},
		{"scaled", "scale"},
		{"scales", "scale"},
		{"scalesia", "scalesia"},
		{"scaley", "scaley"},
		{"scaling", "scale"},
		{"scallops", "scallop"},
		{"scalping", "scalp"},
		{"scaly", "scali"},
		{"scamander", "scamand"},
		{"scamp", "scamp"},
		{"scamper", "scamper"},
		{"scampered", "scamper"},
		{"scamps", "scamp"},
		{"scan", "scan"},
		{"scandal", "scandal"},
		{"scandalising", "scandalis"},
		{"scandalized", "scandal"},
		{"scandalizing", "scandal"},
		{"scandalous", "scandal"},
		{"scandals", "scandal"},
		{"scanned", "scan"},
		{"scanning", "scan"},
		{"scant", "scant"},
		{"scantier", "scantier"},
		{"scantiest", "scantiest"},
		{"scantily", "scantili"},
		{"scantiness", "scanti"},
		{"scanty", "scanti"},
		{"scape", "scape"},
		{"scapegoat", "scapegoat"},
		{"scapegrace", "scapegrac"},
		{"scar", "scar"},
		{"scarabaeus", "scarabaeus"},
		{"scarce", "scarc"},
		{"scarcel", "scarcel"},
		{"scarcely", "scarc"},
		{"scarcer", "scarcer"},
		{"scarcity", "scarciti"},
		{"scare", "scare"},
		{"scarecrow", "scarecrow"},
		{"scarecrows", "scarecrow"},
		{"scared", "scare"},
		{"scarf", "scarf"},
		{"scarfs", "scarf"},
		{"scarlet", "scarlet"},
		{"scarred", "scar"},
		{"scars", "scar"},
		{"scarum", "scarum"},
		{"scarus", "scarus"},
		{"scatter", "scatter"},
		{"scattered", "scatter"},
		{"scattering", "scatter"},
		{"scavengers", "scaveng"},
		{"scelidotherium", "scelidotherium"},
		{"scene", "scene"},
		{"scenery", "sceneri"},
		{"scenes", "scene"},
		{"scent", "scent"},
		{"scented", "scent"},
		{"scentless", "scentless"},
		{"scents", "scent"},
		{"sceptic", "sceptic"},
		{"sceptical", "sceptic"},
		{"sceptics", "sceptic"},
		{"schedule", "schedul"},
		{"schegolskoy", "schegolskoy"},
		{"scheme", "scheme"},
		{"schemer", "schemer"},
		{"schemes", "scheme"},
		{"scheming", "scheme"},
		{"schiller", "schiller"},
		{"schilleresque", "schilleresqu"},
		{"schirdel", "schirdel"},
		{"schleswig", "schleswig"},
		{"scholar", "scholar"},
		{"scholarly", "scholar"},
		{"scholars", "scholar"},
		{"scholarship", "scholarship"},
		{"scholastic", "scholast"},
		{"schone", "schone"},
		{"schonsten", "schonsten"},
		{"school", "school"},
		{"schoolboy", "schoolboy"},
		{"schooldays", "schoolday"},
		{"schooled", "school"},
		{"schoolfellow", "schoolfellow"},
		{"schoolfellows", "schoolfellow"},
		{"schooling", "school"},
		{"schoolmaster", "schoolmast"},
		{"schoolmasters", "schoolmast"},
		{"schoolmate", "schoolmat"},
		{"schoolmeasther", "schoolmeasth"},
		{"schoolroom", "schoolroom"},
		{"schools", "school"},
		{"schooner", "schooner"},
		{"schwach", "schwach"},
		{"scienc", "scienc"},
		{"science", "scienc"},
		{"sciences", "scienc"},
		{"scientific", "scientif"},
		{"scimitar", "scimitar"},
		{"scintillate", "scintil"},
		{"scintillation", "scintil"},
		{"scions", "scion"},
		{"scissor", "scissor"},
		{"scissors", "scissor"},
		{"sclater", "sclater"},
		{"scoff", "scoff"},
		{"scoffed", "scof"},
		{"scoffers", "scoffer"},
		{"scold", "scold"},
		{"scolded", "scold"},
		{"scolding", "scold"},
		{"scolds", "scold"},
		{"scoondrel", "scoondrel"},
		{"scoondrels", "scoondrel"},
		{"scoop", "scoop"},
		{"scooped", "scoop"},
		{"scooping", "scoop"},
		{"scoops", "scoop"},
		{"scope", "scope"},
		{"scorch", "scorch"},
		{"scorched", "scorch"},
		{"scorches", "scorch"},
		{"scorching", "scorch"},
		{"scorchingly", "scorch"},
		{"score", "score"},
		{"scored", "score"},
		{"scores", "score"},
		{"scoresby", "scoresbi"},
		{"scoriaceous", "scoriac"},
		{"scoriae", "scoria"},
		{"scorn", "scorn"},
		{"scorned", "scorn"},
		{"scornful", "scorn"},
		{"scornfully", "scorn"},
		{"scorning", "scorn"},
		{"scorns", "scorn"},
		{"scorpion", "scorpion"},
		{"scorpions", "scorpion"},
		{"scot", "scot"},
		{"scotch", "scotch"},
		{"scotched", "scotch"},
		{"scotland", "scotland"},
		{"scott", "scott"},
		{"scoundrel", "scoundrel"},
		{"scoundrelly", "scoundrelli"},
		{"scoundrels", "scoundrel"},
		{"scour", "scour"},
		{"scoured", "scour"},
		{"scourge", "scourg"},
		{"scourges", "scourg"},
		{"scouring", "scour"},
		{"scours", "scour"},
		{"scout", "scout"},
		{"scouted", "scout"},
		{"scouts", "scout"},
		{"scowl", "scowl"},
		{"scowled", "scowl"},
		{"scowling", "scowl"},
		{"scowls", "scowl"},
		{"scramble", "scrambl"},
		{"scrambled", "scrambl"},
		{"scrambling", "scrambl"},
		{"scrap", "scrap"},
		{"scrapbook", "scrapbook"},
		{"scrape", "scrape"},
		{"scraped", "scrape"},
		{"scraper", "scraper"},
		{"scrapes", "scrape"},
		{"scraping", "scrape"},
		{"scraps", "scrap"},
		{"scratch", "scratch"},
		{"scratched", "scratch"},
		{"scratches", "scratch"},
		{"scratching", "scratch"},
		{"scrawl", "scrawl"},
		{"scrawled", "scrawl"},
		{"scrawls", "scrawl"},
		{"scream", "scream"},
		{"screamed", "scream"},
		{"screaming", "scream"},
		{"screams", "scream"},
		{"screeched", "screech"},
		{"screeches", "screech"},
		{"screeching", "screech"},
		{"screen", "screen"},
		{"screened", "screen"},
		{"screening", "screen"},
		{"screens", "screen"},
		{"screw", "screw"},
		{"screwdriver", "screwdriv"},
		{"screwdrivers", "screwdriv"},
		{"screwed", "screw"},
		{"screwing", "screw"},
		{"screws", "screw"},
		{"scribble", "scribbl"},
		{"scribbled", "scribbl"},
		{"scribe", "scribe"},
		{"scrip", "scrip"},
		{"scripter", "scripter"},
		{"scriptural", "scriptur"},
		{"scripture", "scriptur"},
		{"scrivener", "scriven"},
		{"scrofulous", "scroful"},
		{"scrolls", "scroll"},
		{"scrope", "scrope"},
		{"scrub", "scrub"},
		{"scrubbed", "scrub"},
		{"scrubbing", "scrub"},
		{"scrubbs", "scrubb"},
		{"scrubby", "scrubbi"},
		{"scrubs", "scrub"},
		{"scruple", "scrupl"},
		{"scruples", "scrupl"},
		{"scrupulous", "scrupul"},
		{"scrupulously", "scrupul"},
		{"scrutinise", "scrutinis"},
		{"scrutinised", "scrutinis"},
		{"scrutinising", "scrutinis"},
		{"scrutinizing", "scrutin"},
		{"scrutiny", "scrutini"},
		{"scudded", "scud"},
		{"scuffle", "scuffl"},
		{"scuffling", "scuffl"},
		{"scullery", "sculleri"},
		{"scullions", "scullion"},
		{"sculptor", "sculptor"},
		{"sculptured", "sculptur"},
		{"sculptures", "sculptur"},
		{"scum", "scum"},
		{"scurvy", "scurvi"},
		{"scuttle", "scuttl"},
		{"scuttling", "scuttl"},
		{"scytalopus", "scytalopus"},
		{"se", "se"},
		{"sea", "sea"},
		{"seacoast", "seacoast"},
		{"seafowl", "seafowl"},
		{"seal", "seal"},
		{"sealed", "seal"},
		{"sealer", "sealer"},
		{"sealers", "sealer"},
		{"sealing", "seal"},
		{"seals", "seal"},
		{"seaman", "seaman"},
		{"seame", "seam"},
		{"seamed", "seam"},
		{"seamen", "seamen"},
		{"seams", "seam"},
		{"seaport", "seaport"},
		{"sear", "sear"},
		{"search", "search"},
		{"searched", "search"},
		{"searches", "search"},
		{"searching", "search"},
		{"seas", "sea"},
		{"seashells", "seashel"},
		{"seaside", "seasid"},
		{"season", "season"},
		{"seasoned", "season"},
		{"seasons", "season"},
		{"seat", "seat"},
		{"seated", "seat"},
		{"seating", "seat"},
		{"seats", "seat"},
		{"seaward", "seaward"},
		{"seawards", "seaward"},
		{"seaweed", "seawe"},
		{"secede", "seced"},
		{"secession", "secess"},
		{"seclude", "seclud"},
		{"secluded", "seclud"},
		{"seclusion", "seclus"},
		{"seco", "seco"},
		{"second", "second"},
		{"secondary", "secondari"},
		{"seconded", "second"},
		{"secondly", "second"},
		{"seconds", "second"},
		{"secrecy", "secreci"},
		{"secret", "secret"},
		{"secretaries", "secretari"},
		{"secretary", "secretari"},
		{"secretaryship", "secretaryship"},
		{"secretaryships", "secretaryship"},
		{"secrete", "secret"},
		{"secreted", "secret"},
		{"secretes", "secret"},
		{"secreting", "secret"},
		{"secretion", "secret"},
		{"secretly", "secret"},
		{"secrets", "secret"},
		{"sect", "sect"},
		{"sectio", "sectio"},
		{"section", "section"},
		{"sections", "section"},
		{"secular", "secular"},
		{"secure", "secur"},
		{"secured", "secur"},
		{"securely", "secur"},
		{"secures", "secur"},
		{"securing", "secur"},
		{"securities", "secur"},
		{"security", "secur"},
		{"sed", "sed"},
		{"sedate", "sedat"},
		{"sedately", "sedat"},
		{"sedateness", "sedat"},
		{"sedative", "sedat"},
		{"sedentary", "sedentari"},
		{"sedes", "sede"},
		{"sedge", "sedg"},
		{"sediment", "sediment"},
		{"sedimentary", "sedimentari"},
		{"sediments", "sediment"},
		{"sedley", "sedley"},
		{"seduced", "seduc"},
		{"seducer", "seduc"},
		{"seductive", "seduct"},
		{"seductively", "seduct"},
		{"sedulous", "sedul"},
		{"sedulously", "sedul"},
		{"see", "see"},
		{"seed", "seed"},
		{"seeds", "seed"},
		{"seeing", "see"},
		{"seek", "seek"},
		{"seeker", "seeker"},
		{"seekers", "seeker"},
		{"seeking", "seek"},
		{"seeks", "seek"},
		{"seem", "seem"},
		{"seeme", "seem"},
		{"seemed", "seem"},
		{"seeming", "seem"},
		{"seemingly", "seem"},
		{"seems", "seem"},
		{"seen", "seen"},
		{"sees", "see"},
		{"seetzen", "seetzen"},
		{"segment", "segment"},
		{"segments", "segment"},
		{"sehr", "sehr"},
		{"sein", "sein"},
		{"seize", "seiz"},
		{"seized", "seiz"},
		{"seizes", "seiz"},
		{"seizing", "seiz"},
		{"seizure", "seizur"},
		{"seldom", "seldom"},
		{"select", "select"},
		{"selected", "select"},
		{"selecting", "select"},
		{"selection", "select"},
		{"selections", "select"},
		{"self", "self"},
		{"selfish", "selfish"},
		{"selfishness", "selfish"},
		{"sell", "sell"},
		{"seller", "seller"},
		{"sellers", "seller"},
		{"selling", "sell"},
		{"sellings", "sell"},
		{"sells", "sell"},
		{"selves", "selv"},
		{"semblance", "semblanc"},
		{"semblances", "semblanc"},
		{"semi", "semi"},
		{"semicircle", "semicircl"},
		{"semicircular", "semicircular"},
		{"seminal", "semin"},
		{"seminarists", "seminarist"},
		{"semyon", "semyon"},
		{"semyonova", "semyonova"},
		{"semyonovitch", "semyonovitch"},
		{"semyonovna", "semyonovna"},
		{"semyonovsky", "semyonovski"},
		{"senate", "senat"},
		{"senator", "senat"},
		{"senatorial", "senatori"},
		{"senators", "senat"},
		{"send", "send"},
		{"sender", "sender"},
		{"sending", "send"},
		{"sends", "send"},
		{"senhor", "senhor"},
		{"senile", "senil"},
		{"senior", "senior"},
		{"seniority", "senior"},
		{"seniors", "senior"},
		{"senor", "senor"},
		{"senoritas", "senorita"},
		{"sensation", "sensat"},
		{"sensational", "sensat"},
		{"sensations", "sensat"},
		{"sense", "sens"},
		{"senseless", "senseless"},
		{"senses", "sens"},
		{"sensibilities", "sensibl"},
		{"sensibility", "sensibl"},
		{"sensible", "sensibl"},
		{"sensibly", "sensibl"},
		{"sensitive", "sensit"},
		{"sensitiveness", "sensit"},
		{"sensual", "sensual"},
		{"sensualist", "sensualist"},
		{"sensuality", "sensual"},
		{"sent", "sent"},
		{"sentence", "sentenc"},
		{"sentenced", "sentenc"},
		{"sentences", "sentenc"},
		{"sententiously", "sententi"},
		{"sentiment", "sentiment"},
		{"sentimental", "sentiment"},
		{"sentimentalism", "sentiment"},
		{"sentimentality", "sentiment"},
		{"sentimentally", "sentiment"},
		{"sentiments", "sentiment"},
		{"sentinel", "sentinel"},
		{"sentinels", "sentinel"},
		{"sentries", "sentri"},
		{"sentry", "sentri"},
		{"separate", "separ"},
		{"separated", "separ"},
		{"separately", "separ"},
		{"separates", "separ"},
		{"separating", "separ"},
		{"separation", "separ"},
		{"sept", "sept"},
		{"septa", "septa"},
		{"september", "septemb"},
		{"septuagenarian", "septuagenarian"},
		{"septum", "septum"},
		{"sepulchral", "sepulchr"},
		{"sepulchre", "sepulchr"},
		{"sepultus", "sepultus"},
		{"sequel", "sequel"},
		{"sequence", "sequenc"},
		{"sequestered", "sequest"},
		{"ser", "ser"},
		{"seraph", "seraph"},
		{"seraphically", "seraph"},
		{"seraphim", "seraphim"},
		{"serces", "serc"},
		{"serenades", "serenad"},
		{"serene", "seren"},
		{"serenely", "seren"},
		{"serenity", "seren"},
		{"serf", "serf"},
		{"serfdom", "serfdom"},
		{"serfs", "serf"},
		{"sergeant", "sergeant"},
		{"seriatim", "seriatim"},
		{"series", "seri"},
		{"serio", "serio"},
		{"serious", "serious"},
		{"seriously", "serious"},
		{"seriousness", "serious"},
		{"serjeant", "serjeant"},
		{"serjeants", "serjeant"},
		{"sermon", "sermon"},
		{"sermonizing", "sermon"},
		{"serpent", "serpent"},
		{"serpentine", "serpentin"},
		{"serpents", "serpent"},
		{"serpulae", "serpula"},
		{"serrated", "serrat"},
		{"sertularia", "sertularia"},
		{"servant", "servant"},
		{"servants", "servant"},
		{"serve", "serv"},
		{"served", "serv"},
		{"server", "server"},
		{"serves", "serv"},
		{"service", "servic"},
		{"serviceable", "servic"},
		{"serviceably", "servic"},
		{"services", "servic"},
		{"servile", "servil"},
		{"servility", "servil"},
		{"serving", "serv"},
		{"servitor", "servitor"},
		{"servitude", "servitud"},
		{"servts", "servt"},
		{"ses", "ses"},
		{"session", "session"},
		{"sessions", "session"},
		{"set", "set"},
		{"sets", "set"},
		{"setten", "setten"},
		{"setting", "set"},
		{"settle", "settl"},
		{"settled", "settl"},
		{"settlement", "settlement"},
		{"settlements", "settlement"},
		{"settler", "settler"},
		{"settlers", "settler"},
		{"settles", "settl"},
		{"settling", "settl"},
		{"seul", "seul"},
		{"sevastopol", "sevastopol"},
		{"seven", "seven"},
		{"sevenpence", "sevenp"},
		{"sevens", "seven"},
		{"seventeen", "seventeen"},
		{"seventeenth", "seventeenth"},
		{"seventh", "seventh"},
		{"seventhly", "seventh"},
		{"seventy", "seventi"},
		{"seventysix", "seventysix"},
		{"sever", "sever"},
		{"severa", "severa"},
		{"several", "sever"},
		{"severally", "sever"},
		{"severe", "sever"},
		{"severed", "sever"},
		{"severely", "sever"},
		{"severer", "sever"},
		{"severest", "severest"},
		{"severity", "sever"},
		{"severn", "severn"},
		{"sevres", "sevr"},
		{"sew", "sew"},
		{"sewed", "sew"},
		{"sewerage", "sewerag"},
		{"sewerely", "sewer"},
		{"sewing", "sew"},
		{"sex", "sex"},
		{"sexes", "sex"},
		{"sexton", "sexton"},
		{"sextus", "sextus"},
		{"sexty", "sexti"},
		{"seychelle", "seychell"},
		{"seychelles", "seychell"},
		{"sh", "sh"},
		{"sha", "sha"},
		{"shabbily", "shabbili"},
		{"shabbiness", "shabbi"},
		{"shabby", "shabbi"},
		{"shade", "shade"},
		{"shaded", "shade"},
		{"shades", "shade"},
		{"shading", "shade"},
		{"shadow", "shadow"},
		{"shadowed", "shadow"},
		{"shadowless", "shadowless"},
		{"shadows", "shadow"},
		{"shadowy", "shadowi"},
		{"shady", "shadi"},
		{"shaft", "shaft"},
		{"shafts", "shaft"},
		{"shaggy", "shaggi"},
		{"shak", "shak"},
		{"shake", "shake"},
		{"shaken", "shaken"},
		{"shakes", "shake"},
		{"shakespeare", "shakespear"},
		{"shaking", "shake"},
		{"shakings", "shake"},
		{"shakspeare", "shakspear"},
		{"shal", "shal"},
		{"shall", "shall"},
		{"shallow", "shallow"},
		{"shallowest", "shallowest"},
		{"shallows", "shallow"},
		{"shalt", "shalt"},
		{"sham", "sham"},
		{"shambled", "shambl"},
		{"shambles", "shambl"},
		{"shambling", "shambl"},
		{"shame", "shame"},
		{"shamed", "shame"},
		{"shamefaced", "shamefac"},
		{"shameful", "shame"},
		{"shamefully", "shame"},
		{"shameless", "shameless"},
		{"shamelessly", "shameless"},
		{"shamming", "sham"},
		{"shan", "shan"},
		{"shanks", "shank"},
		{"shanties", "shanti"},
		{"shape", "shape"},
		{"shaped", "shape"},
		{"shapeless", "shapeless"},
		{"shapely", "shape"},
		{"shapes", "shape"},
		{"shaping", "shape"},
		{"shar", "shar"},
		{"share", "share"},
		{"shared", "share"},
		{"shareholder", "sharehold"},
		{"shareholders", "sharehold"},
		{"sharer", "sharer"},
		{"shares", "share"},
		{"sharing", "share"},
		{"shark", "shark"},
		{"sharking", "shark"},
		{"sharks", "shark"},
		{"sharmer", "sharmer"},
		{"sharp", "sharp"},
		{"sharpen", "sharpen"},
		{"sharpened", "sharpen"},
		{"sharpening", "sharpen"},
		{"sharpens", "sharpen"},
		{"sharper", "sharper"},
		{"sharpers", "sharper"},
		{"sharpest", "sharpest"},
		{"sharply", "sharpli"},
		{"sharpness", "sharp"},
		{"sharpshooters", "sharpshoot"},
		{"shattered", "shatter"},
		{"shave", "shave"},
		{"shaved", "shave"},
		{"shaven", "shaven"},
		{"shaver", "shaver"},
		{"shaves", "shave"},
		{"shaving", "shave"},
		{"shaw", "shaw"},
		{"shawl", "shawl"},
		{"shawls", "shawl"},
		{"she", "she"},
		{"sheake", "sheak"},
		{"sheame", "sheam"},
		{"shearing", "shear"},
		{"sheath", "sheath"},
		{"sheaves", "sheav"},
		{"shed", "shed"},
		{"shedding", "shed"},
		{"sheds", "shed"},
		{"sheen", "sheen"},
		{"sheep", "sheep"},
		{"sheepish", "sheepish"},
		{"sheepskin", "sheepskin"},
		{"sheer", "sheer"},
		{"sheet", "sheet"},
		{"sheets", "sheet"},
		{"sheik", "sheik"},
		{"shelf", "shelf"},
		{"shell", "shell"},
		{"shelley", "shelley"},
		{"shellfish", "shellfish"},
		{"shellfuls", "shell"},
		{"shells", "shell"},
		{"shelly", "shelli"},
		{"shelopaev", "shelopaev"},
		{"shelter", "shelter"},
		{"sheltered", "shelter"},
		{"sheltering", "shelter"},
		{"shelters", "shelter"},
		{"shelves", "shelv"},
		{"shelving", "shelv"},
		{"shepherd", "shepherd"},
		{"shepherdess", "shepherdess"},
		{"shepherdesses", "shepherdess"},
		{"shepherds", "shepherd"},
		{"sheriff", "sheriff"},
		{"sherry", "sherri"},
		{"shetland", "shetland"},
		{"shh", "shh"},
		{"shibboleth", "shibboleth"},
		{"shied", "shi"},
		{"shield", "shield"},
		{"shielded", "shield"},
		{"shielding", "shield"},
		{"shields", "shield"},
		{"shies", "shi"},
		{"shift", "shift"},
		{"shifted", "shift"},
		{"shifting", "shift"},
		{"shiftings", "shift"},
		{"shifts", "shift"},
		{"shil", "shil"},
		{"shilling", "shill"},
		{"shillings", "shill"},
		{"shin", "shin"},
		{"shine", "shine"},
		{"shines", "shine"},
		{"shingle", "shingl"},
		{"shining", "shine"},
		{"shiny", "shini"},
		{"ship", "ship"},
		{"shipbuilder", "shipbuild"},
		{"shiploads", "shipload"},
		{"shipped", "ship"},
		{"shipping", "ship"},
		{"ships", "ship"},
		{"shipton", "shipton"},
		{"shipwreck", "shipwreck"},
		{"shipwrecked", "shipwreck"},
		{"shipwrecks", "shipwreck"},
		{"shire", "shire"},
		{"shirk", "shirk"},
		{"shirked", "shirk"},
		{"shirking", "shirk"},
		{"shirt", "shirt"},
		{"shirts", "shirt"},
		{"shiver", "shiver"},
		{"shivered", "shiver"},
		{"shivering", "shiver"},
		{"shivers", "shiver"},
		{"shoal", "shoal"},
		{"shoaler", "shoaler"},
		{"shoalness", "shoal"},
		{"shoals", "shoal"},
		{"shock", "shock"},
		{"shocked", "shock"},
		{"shocking", "shock"},
		{"shockingly", "shock"},
		{"shocks", "shock"},
		{"shod", "shod"},
		{"shoe", "shoe"},
		{"shoed", "sho"},
		{"shoeless", "shoeless"},
		{"shoemaker", "shoemak"},
		{"shoemakers", "shoemak"},
		{"shoes", "shoe"},
		{"shone", "shone"},
		{"shongi", "shongi"},
		{"shoohoo", "shoohoo"},
		{"shook", "shook"},
		{"shoon", "shoon"},
		{"shoot", "shoot"},
		{"shooters", "shooter"},
		{"shooting", "shoot"},
		{"shoots", "shoot"},
		{"shop", "shop"},
		{"shopkeeper", "shopkeep"},
		{"shopkeepers", "shopkeep"},
		{"shopman", "shopman"},
		{"shopmen", "shopmen"},
		{"shopofwomen", "shopofwomen"},
		{"shops", "shop"},
		{"shore", "shore"},
		{"shoreham", "shoreham"},
		{"shores", "shore"},
		{"shorn", "shorn"},
		{"short", "short"},
		{"shortcoming", "shortcom"},
		{"shortcomings", "shortcom"},
		{"shorten", "shorten"},
		{"shortened", "shorten"},
		{"shortening", "shorten"},
		{"shortens", "shorten"},
		{"shorter", "shorter"},
		{"shortest", "shortest"},
		{"shortly", "short"},
		{"shortness", "short"},
		{"shorts", "short"},
		{"shot", "shot"},
		{"shots", "shot"},
		{"should", "should"},
		{"shoulder", "shoulder"},
		{"shouldered", "shoulder"},
		{"shouldering", "shoulder"},
		{"shoulders", "shoulder"},
		{"shouldest", "shouldest"},
		{"shouldn", "shouldn"},
		{"shouldst", "shouldst"},
		{"shout", "shout"},
		{"shouted", "shout"},
		{"shouting", "shout"},
		{"shouts", "shout"},
		{"shove", "shove"},
		{"shoved", "shove"},
		{"shovel", "shovel"},
		{"shoving", "shove"},
		{"show", "show"},
		{"showd", "showd"},
		{"showed", "show"},
		{"shower", "shower"},
		{"showered", "shower"},
		{"showering", "shower"},
		{"showers", "shower"},
		{"showery", "showeri"},
		{"showing", "show"},
		{"shown", "shown"},
		{"shows", "show"},
		{"showy", "showi"},
		{"shrank", "shrank"},
		{"shreds", "shred"},
		{"shrew", "shrew"},
		{"shrewd", "shrewd"},
		{"shrewdly", "shrewd"},
		{"shrewdness", "shrewd"},
		{"shriek", "shriek"},
		{"shrieked", "shriek"},
		{"shrieking", "shriek"},
		{"shrieks", "shriek"},
		{"shrikes", "shrike"},
		{"shrill", "shrill"},
		{"shrillest", "shrillest"},
		{"shrillness", "shrill"},
		{"shrilly", "shrilli"},
		{"shrimp", "shrimp"},
		{"shrimps", "shrimp"},
		{"shrine", "shrine"},
		{"shrink", "shrink"},
		{"shrinking", "shrink"},
		{"shrinks", "shrink"},
		{"shrivel", "shrivel"},
		{"shrivelled", "shrivel"},
		{"shropshire", "shropshir"},
		{"shroud", "shroud"},
		{"shrouded", "shroud"},
		{"shrub", "shrub"},
		{"shrubberies", "shrubberi"},
		{"shrubbery", "shrubberi"},
		{"shrubs", "shrub"},
		{"shrug", "shrug"},
		{"shrugged", "shrug"},
		{"shrugging", "shrug"},
		{"shrugs", "shrug"},
		{"shrunk", "shrunk"},
		{"shrunken", "shrunken"},
		{"shudder", "shudder"},
		{"shuddered", "shudder"},
		{"shuddering", "shudder"},
		{"shudders", "shudder"},
		{"shuffle", "shuffl"},
		{"shuffled", "shuffl"},
		{"shufflers", "shuffler"},
		{"shuffles", "shuffl"},
		{"shuffling", "shuffl"},
		{"shufflings", "shuffl"},
		{"shuflle", "shufll"},
		{"shun", "shun"},
		{"shunned", "shun"},
		{"shunning", "shun"},
		{"shut", "shut"},
		{"shuts", "shut"},
		{"shutter", "shutter"},
		{"shutters", "shutter"},
		{"shutting", "shut"},
		{"shy", "shi"},
		{"shyer", "shyer"},
		{"shyest", "shyest"},
		{"shylock", "shylock"},
		{"shyly", "shyli"},
		{"shyness", "shyness"},
		{"si", "si"},
		{"siamese", "siames"},
		{"siberia", "siberia"},
		{"siberian", "siberian"},
		{"sich", "sich"},
		{"sick", "sick"},
		{"sickened", "sicken"},
		{"sickening", "sicken"},
		{"sickens", "sicken"},
		{"sickliness", "sickli"},
		{"sickly", "sick"},
		{"sickness", "sick"},
		{"side", "side"},
		{"sideboard", "sideboard"},
		{"sided", "side"},
		{"sidelong", "sidelong"},
		{"sides", "side"},
		{"sideway", "sideway"},
		{"sideways", "sideway"},
		{"sidewise", "sidewis"},
		{"sidings", "side"},
		{"sidle", "sidl"},
		{"sidled", "sidl"},
		{"sidles", "sidl"},
		{"sidling", "sidl"},
		{"siege", "sieg"},
		{"sierra", "sierra"},
		{"sieve", "siev"},
		{"sift", "sift"},
		{"sifter", "sifter"},
		{"sigh", "sigh"},
		{"sighed", "sigh"},
		{"sighing", "sigh"},
		{"sighs", "sigh"},
		{"sight", "sight"},
		{"sighted", "sight"},
		{"sightedness", "sighted"},
		{"sightless", "sightless"},
		{"sights", "sight"},
		{"sightseer", "sightseer"},
		{"sign", "sign"},
		{"signal", "signal"},
		{"signalised", "signalis"},
		{"signalize", "signal"},
		{"signalling", "signal"},
		{"signally", "signal"},
		{"signals", "signal"},
		{"signature", "signatur"},
		{"signatures", "signatur"},
		{"signed", "sign"},
		{"significance", "signific"},
		{"significancy", "signific"},
		{"significant", "signific"},
		{"significantly", "signific"},
		{"signification", "signif"},
		{"signified", "signifi"},
		{"signifies", "signifi"},
		{"signifieth", "signifieth"},
		{"signify", "signifi"},
		{"signifying", "signifi"},
		{"signing", "sign"},
		{"signoritas", "signorita"},
		{"signs", "sign"},
		{"sike", "sike"},
		{"silence", "silenc"},
		{"silenced", "silenc"},
		{"silencing", "silenc"},
		{"silent", "silent"},
		{"silently", "silent"},
		{"silex", "silex"},
		{"siliceous", "silic"},
		{"silicified", "silicifi"},
		{"silk", "silk"},
		{"silken", "silken"},
		{"silkiness", "silki"},
		{"silks", "silk"},
		{"silkworm", "silkworm"},
		{"silky", "silki"},
		{"sill", "sill"},
		{"sillier", "sillier"},
		{"sillies", "silli"},
		{"silliest", "silliest"},
		{"silliman", "silliman"},
		{"silliness", "silli"},
		{"sills", "sill"},
		{"silly", "silli"},
		{"silurian", "silurian"},
		{"silurus", "silurus"},
		{"silver", "silver"},
		{"silverbridge", "silverbridg"},
		{"silvered", "silver"},
		{"silversmith", "silversmith"},
		{"silvery", "silveri"},
		{"silworth", "silworth"},
		{"similar", "similar"},
		{"similarity", "similar"},
		{"similarly", "similar"},
		{"simile", "simil"},
		{"similes", "simil"},
		{"similitude", "similitud"},
		{"simmering", "simmer"},
		{"simmonds", "simmond"},
		{"simper", "simper"},
		{"simpered", "simper"},
		{"simpering", "simper"},
		{"simple", "simpl"},
		{"simpler", "simpler"},
		{"simplest", "simplest"},
		{"simpleton", "simpleton"},
		{"simpletons", "simpleton"},
		{"simplex", "simplex"},
		{"simplicity", "simplic"},
		{"simplified", "simplifi"},
		{"simplon", "simplon"},
		{"simply", "simpli"},
		{"simpson", "simpson"},
		{"simul", "simul"},
		{"simultaneous", "simultan"},
		{"simultaneously", "simultan"},
		{"sin", "sin"},
		{"sinai", "sinai"},
		{"sinbad", "sinbad"},
		{"since", "sinc"},
		{"sincere", "sincer"},
		{"sincerely", "sincer"},
		{"sincerest", "sincerest"},
		{"sincerity", "sincer"},
		{"sinecure", "sinecur"},
		{"sinew", "sinew"},
		{"sinews", "sinew"},
		{"sinewy", "sinewi"},
		{"sinful", "sin"},
		{"sinfulness", "sin"},
		{"sing", "sing"},
		{"singapore", "singapor"},
		{"singed", "sing"},
		{"singeing", "sing"},
		{"singer", "singer"},
		{"singers", "singer"},
		{"singing", "sing"},
		{"single", "singl"},
		{"singleness", "singl"},
		{"singling", "singl"},
		{"singly", "singl"},
		{"sings", "sing"},
		{"singula", "singula"},
		{"singular", "singular"},
		{"singularities", "singular"},
		{"singularity", "singular"},
		{"singularly", "singular"},
		{"sinister", "sinist"},
		{"sink", "sink"},
		{"sinking", "sink"},
		{"sinks", "sink"},
		{"sinless", "sinless"},
		{"sinlessly", "sinless"},
		{"sinned", "sin"},
		{"sinner", "sinner"},
		{"sinners", "sinner"},
		{"sinning", "sin"},
		{"sins", "sin"},
		{"sinuous", "sinuous"},
		{"sip", "sip"},
		{"siphon", "siphon"},
		{"sipped", "sip"},
		{"sipping", "sip"},
		{"sips", "sip"},
		{"sir", "sir"},
		{"sire", "sire"},
		{"siren", "siren"},
		{"sirocco", "sirocco"},
		{"sirrah", "sirrah"},
		{"sister", "sister"},
		{"sisterhood", "sisterhood"},
		{"sisterly", "sister"},
		{"sisters", "sister"},
		{"sistine", "sistin"},
		{"sit", "sit"},
		{"site", "site"},
		{"sites", "site"},
		{"sitiwation", "sitiw"},
		{"sitiwations", "sitiw"},
		{"sits", "sit"},
		{"sitter", "sitter"},
		{"sitters", "sitter"},
		{"sittin", "sittin"},
		{"sitting", "sit"},
		{"sittings", "sit"},
		{"situ", "situ"},
		{"situate", "situat"},
		{"situated", "situat"},
		{"situation", "situat"},
		{"situations", "situat"},
		{"siunmerson", "siunmerson"},
		{"sivatherium", "sivatherium"},
		{"six", "six"},
		{"sixes", "six"},
		{"sixieme", "sixiem"},
		{"sixpen", "sixpen"},
		{"sixpence", "sixpenc"},
		{"sixpences", "sixpenc"},
		{"sixpenny", "sixpenni"},
		{"sixteen", "sixteen"},
		{"sixteenth", "sixteenth"},
		{"sixth", "sixth"},
		{"sixthly", "sixth"},
		{"sixty", "sixti"},
		{"size", "size"},
		{"sized", "size"},
		{"sizes", "size"},
		{"skampling", "skampl"},
		{"skate", "skate"},
		{"skaters", "skater"},
		{"skating", "skate"},
		{"skeen", "skeen"},
		{"skein", "skein"},
		{"skeleto", "skeleto"},
		{"skeleton", "skeleton"},
		{"skeletons", "skeleton"},
		{"sketch", "sketch"},
		{"sketched", "sketch"},
		{"sketches", "sketch"},
		{"sketchily", "sketchili"},
		{"sketching", "sketch"},
		{"skewer", "skewer"},
		{"skiddaw", "skiddaw"},
		{"skies", "sky"},
		{"skilful", "skil"},
		{"skilfully", "skil"},
		{"skilfulness", "skil"},
		{"skill", "skill"},
		{"skilled", "skill"},
		{"skilly", "skilli"},
		{"skim", "skim"},
		{"skimmed", "skim"},
		{"skimming", "skim"},
		{"skimpole", "skimpol"},
		{"skims", "skim"},
		{"skin", "skin"},
		{"skinned", "skin"},
		{"skinning", "skin"},
		{"skinny", "skinni"},
		{"skins", "skin"},
		{"skip", "skip"},
		{"skipped", "skip"},
		{"skipper", "skipper"},
		{"skipping", "skip"},
		{"skips", "skip"},
		{"skirmish", "skirmish"},
		{"skirmished", "skirmish"},
		{"skirmishes", "skirmish"},
		{"skirmishing", "skirmish"},
		{"skirt", "skirt"},
		{"skirted", "skirt"},
		{"skirts", "skirt"},
		{"skittish", "skittish"},
		{"skittle", "skittl"},
		{"skittles", "skittl"},
		{"skrimmage", "skrimmag"},
		{"skul", "skul"},
		{"skulk", "skulk"},
		{"skulking", "skulk"},
		{"skulks", "skulk"},
		{"skull", "skull"},
		{"skulls", "skull"},
		{"skumpling", "skumpl"},
		{"skunks", "skunk"},
		{"skurry", "skurri"},
		{"skuttle", "skuttl"},
		{"sky", "sky"},
		{"skye", "skye"},
		{"skylark", "skylark"},
		{"skylight", "skylight"},
		{"skylights", "skylight"},
		{"slab", "slab"},
		{"slabs", "slab"},
		{"slack", "slack"},
		{"slacken", "slacken"},
		{"slackened", "slacken"},
		{"slackness", "slack"},
		{"sladdery", "sladderi"},
		{"slags", "slag"},
		{"slain", "slain"},
		{"slaked", "slake"},
		{"slam", "slam"},
		{"slammed", "slam"},
		{"slammons", "slammon"},
		{"slander", "slander"},
		{"slandered", "slander"},
		{"slanderer", "slander"},
		{"slanderers", "slander"},
		{"slandering", "slander"},
		{"slang", "slang"},
		{"slangular", "slangular"},
		{"slanting", "slant"},
		{"slap", "slap"},
		{"slapped", "slap"},
		{"slapping", "slap"},
		{"slaps", "slap"},
		{"slash", "slash"},
		{"slashing", "slash"},
		{"slat", "slat"},
		{"slate", "slate"},
		{"slatternly", "slattern"},
		{"slaughter", "slaughter"},
		{"slaughtered", "slaughter"},
		{"slaughtering", "slaughter"},
		{"slaughterous", "slaughter"},
		{"slave", "slave"},
		{"slaved", "slave"},
		{"slavery", "slaveri"},
		{"slaves", "slave"},
		{"slavish", "slavish"},
		{"slavishly", "slavish"},
		{"slay", "slay"},
		{"sledge", "sledg"},
		{"sleek", "sleek"},
		{"sleep", "sleep"},
		{"sleeper", "sleeper"},
		{"sleepers", "sleeper"},
		{"sleepily", "sleepili"},
		{"sleepiness", "sleepi"},
		{"sleeping", "sleep"},
		{"sleepless", "sleepless"},
		{"sleeps", "sleep"},
		{"sleepy", "sleepi"},
		{"sleet", "sleet"},
		{"sleeve", "sleev"},
		{"sleeved", "sleev"},
		{"sleeves", "sleev"},
		{"sleight", "sleight"},
		{"slender", "slender"},
		{"slenderer", "slender"},
		{"slenderly", "slender"},
		{"slep", "slep"},
		{"slept", "slept"},
		{"slice", "slice"},
		{"sliced", "slice"},
		{"slices", "slice"},
		{"slicing", "slice"},
		{"slid", "slid"},
		{"slide", "slide"},
		{"slider", "slider"},
		{"sliders", "slider"},
		{"sliderskew", "sliderskew"},
		{"slides", "slide"},
		{"sliding", "slide"},
		{"slight", "slight"},
		{"slighted", "slight"},
		{"slighter", "slighter"},
		{"slightest", "slightest"},
		{"slighting", "slight"},
		{"slightly", "slight"},
		{"slights", "slight"},
		{"slim", "slim"},
		{"slime", "slime"},
		{"slimy", "slimi"},
		{"sling", "sling"},
		{"slings", "sling"},
		{"slinking", "slink"},
		{"slip", "slip"},
		{"slipped", "slip"},
		{"slipper", "slipper"},
		{"slippered", "slipper"},
		{"slippers", "slipper"},
		{"slippery", "slipperi"},
		{"slipping", "slip"},
		{"slips", "slip"},
		{"slipshod", "slipshod"},
		{"slit", "slit"},
		{"slits", "slit"},
		{"sloane", "sloan"},
		{"slocomb", "slocomb"},
		{"slongs", "slong"},
		{"slope", "slope"},
		{"sloped", "slope"},
		{"slopes", "slope"},
		{"sloping", "slope"},
		{"sloppy", "sloppi"},
		{"slopseller", "slopsel"},
		{"sloth", "sloth"},
		{"sloths", "sloth"},
		{"slouch", "slouch"},
		{"slouching", "slouch"},
		{"sloven", "sloven"},
		{"slovenly", "sloven"},
		{"slow", "slow"},
		{"slower", "slower"},
		{"slowly", "slowli"},
		{"slowness", "slow"},
		{"sludge", "sludg"},
		{"slug", "slug"},
		{"sluggish", "sluggish"},
		{"slugs", "slug"},
		{"sluices", "sluic"},
		{"slumber", "slumber"},
		{"slumbered", "slumber"},
		{"slumbering", "slumber"},
		{"slumbers", "slumber"},
		{"slung", "slung"},
		{"slunk", "slunk"},
		{"slurring", "slur"},
		{"slush", "slush"},
		{"slut", "slut"},
		{"sly", "sli"},
		{"slyboots", "slyboot"},
		{"slyly", "slyli"},
		{"slyness", "slyness"},
		{"smack", "smack"},
		{"smacked", "smack"},
		{"smacking", "smack"},
		{"smacks", "smack"},
		{"smal", "smal"},
		{"small", "small"},
		{"smallclothes", "smallcloth"},
		{"smaller", "smaller"},
		{"smallest", "smallest"},
		{"smallness", "small"},
		{"smalls", "small"},
		{"smallweed", "smallwe"},
		{"smallweeds", "smallwe"},
		{"smallweedy", "smallweedi"},
		{"smart", "smart"},
		{"smartened", "smarten"},
		{"smarting", "smart"},
		{"smartly", "smart"},
		{"smartness", "smart"},
		{"smartnesses", "smart"},
		{"smarts", "smart"},
		{"smash", "smash"},
		{"smashed", "smash"},
		{"smashing", "smash"},
		{"smattering", "smatter"},
		{"smear", "smear"},
		{"smeared", "smear"},
		{"smearing", "smear"},
		{"smears", "smear"},
		{"smell", "smell"},
		{"smelling", "smell"},
		{"smells", "smell"},
		{"smelt", "smelt"},
		{"smelted", "smelt"},
		{"smelting", "smelt"},
		{"smiffeld", "smiffeld"},
		{"smifligate", "smiflig"},
		{"smifligation", "smiflig"},
		{"smifser", "smifser"},
		{"smike", "smike"},
		{"smile", "smile"},
		{"smiled", "smile"},
		{"smiles", "smile"},
		{"smilin", "smilin"},
		{"smiling", "smile"},
		{"smilingly", "smile"},
		{"smirched", "smirch"},
		{"smirk", "smirk"},
		{"smirking", "smirk"},
		{"smith", "smith"},
		{"smithers", "smither"},
		{"smithfield", "smithfield"},
		{"smithson", "smithson"},
		{"smiting", "smite"},
		{"smitten", "smitten"},
		{"smock", "smock"},
		{"smoke", "smoke"},
		{"smoked", "smoke"},
		{"smoker", "smoker"},
		{"smokes", "smoke"},
		{"smoking", "smoke"},
		{"smokings", "smoke"},
		{"smoky", "smoki"},
		{"smoldering", "smolder"},
		{"smooth", "smooth"},
		{"smoothed", "smooth"},
		{"smoother", "smoother"},
		{"smoothing", "smooth"},
		{"smoothingly", "smooth"},
		{"smoothings", "smooth"},
		{"smoothly", "smooth"},
		{"smoothness", "smooth"},
		{"smooths", "smooth"},
		{"smote", "smote"},
		{"smothered", "smother"},
		{"smothering", "smother"},
		{"smothers", "smother"},
		{"smouldering", "smoulder"},
		{"smuggle", "smuggl"},
		{"smuggler", "smuggler"},
		{"smut", "smut"},
		{"smutty", "smutti"},
		{"snagsby", "snagsbi"},
		{"snail", "snail"},
		{"snails", "snail"},
		{"snake", "snake"},
		{"snakes", "snake"},
		{"snap", "snap"},
		{"snapped", "snap"},
		{"snapper", "snapper"},
		{"snapping", "snap"},
		{"snappish", "snappish"},
		{"snappishly", "snappish"},
		{"snaps", "snap"},
		{"snare", "snare"},
		{"snares", "snare"},
		{"snarl", "snarl"},
		{"snarled", "snarl"},
		{"snarling", "snarl"},
		{"snarls", "snarl"},
		{"snatch", "snatch"},
		{"snatched", "snatch"},
		{"snatches", "snatch"},
		{"snatching", "snatch"},
		{"snawley", "snawley"},
		{"sneak", "sneak"},
		{"sneaked", "sneak"},
		{"sneaking", "sneak"},
		{"sneaks", "sneak"},
		{"sneer", "sneer"},
		{"sneered", "sneer"},
		{"sneering", "sneer"},
		{"sneers", "sneer"},
		{"sneeze", "sneez"},
		{"sneezed", "sneez"},
		{"sneezing", "sneez"},
		{"snevellicci", "snevellicci"},
		{"snewkes", "snewk"},
		{"sniff", "sniff"},
		{"sniffed", "snif"},
		{"sniffing", "snif"},
		{"sniffs", "sniff"},
		{"snigger", "snigger"},
		{"sniggered", "snigger"},
		{"sniggering", "snigger"},
		{"snipe", "snipe"},
		{"snipping", "snip"},
		{"snittle", "snittl"},
		{"snobb", "snobb"},
		{"snoog", "snoog"},
		{"snooks", "snook"},
		{"snore", "snore"},
		{"snores", "snore"},
		{"snoring", "snore"},
		{"snort", "snort"},
		{"snorted", "snort"},
		{"snorting", "snort"},
		{"snorts", "snort"},
		{"snout", "snout"},
		{"snow", "snow"},
		{"snowed", "snow"},
		{"snowflakes", "snowflak"},
		{"snowing", "snow"},
		{"snowstorm", "snowstorm"},
		{"snowstorms", "snowstorm"},
		{"snowy", "snowi"},
		{"snub", "snub"},
		{"snubbed", "snub"},
		{"snubbing", "snub"},
		{"snubs", "snub"},
		{"snuff", "snuff"},
		{"snuffed", "snuf"},
		{"snuffers", "snuffer"},
		{"snuffim", "snuffim"},
		{"snuffing", "snuf"},
		{"snuffling", "snuffl"},
		{"snuffy", "snuffi"},
		{"snug", "snug"},
		{"snugly", "snug"},
		{"so", "so"},
		{"soaked", "soak"},
		{"soaking", "soak"},
		{"soap", "soap"},
		{"soar", "soar"},
		{"soared", "soar"},
		{"soaring", "soar"},
		{"soars", "soar"},
		{"sob", "sob"},
		{"sobbed", "sob"},
		{"sobbing", "sob"},
		{"sobbings", "sob"},
		{"sober", "sober"},
		{"sobered", "sober"},
		{"sobering", "sober"},
		{"soberly", "sober"},
		{"sobre", "sobr"},
		{"sobriety", "sobrieti"},
		{"sobs", "sob"},
		{"soc", "soc"},
		{"socego", "socego"},
		{"sociable", "sociabl"},
		{"social", "social"},
		{"socialist", "socialist"},
		{"socialists", "socialist"},
		{"sociality", "social"},
		{"socially", "social"},
		{"society", "societi"},
		{"sock", "sock"},
		{"socket", "socket"},
		{"sockets", "socket"},
		{"socks", "sock"},
		{"soda", "soda"},
		{"sodden", "sodden"},
		{"soever", "soever"},
		{"sofa", "sofa"},
		{"sofas", "sofa"},
		{"soft", "soft"},
		{"soften", "soften"},
		{"softened", "soften"},
		{"softeners", "soften"},
		{"softening", "soften"},
		{"softens", "soften"},
		{"softer", "softer"},
		{"softest", "softest"},
		{"softly", "soft"},
		{"softness", "soft"},
		{"sofy", "sofi"},
		{"sofya", "sofya"},
		{"soho", "soho"},
		{"soie", "soie"},
		{"soight", "soight"},
		{"soil", "soil"},
		{"soiled", "soil"},
		{"soiree", "soire"},
		{"soirees", "soire"},
		{"soizable", "soizabl"},
		{"soizes", "soiz"},
		{"sojourn", "sojourn"},
		{"sojourners", "sojourn"},
		{"sojourning", "sojourn"},
		{"sol", "sol"},
		{"solace", "solac"},
		{"solaced", "solac"},
		{"solaces", "solac"},
		{"solacing", "solac"},
		{"solander", "soland"},
		{"solar", "solar"},
		{"sold", "sold"},
		{"soldier", "soldier"},
		{"soldiering", "soldier"},
		{"soldierly", "soldier"},
		{"soldiers", "soldier"},
		{"sole", "sole"},
		{"solecisms", "solec"},
		{"solely", "sole"},
		{"solemn", "solemn"},
		{"solemnest", "solemnest"},
		{"solemnities", "solemn"},
		{"solemnity", "solemn"},
		{"solemnly", "solemn"},
		{"solen", "solen"},
		{"solent", "solent"},
		{"soles", "sole"},
		{"solicitation", "solicit"},
		{"solicitations", "solicit"},
		{"solicited", "solicit"},
		{"soliciting", "solicit"},
		{"solicitor", "solicitor"},
		{"solicitors", "solicitor"},
		{"solicitous", "solicit"},
		{"solicitously", "solicit"},
		{"solicits", "solicit"},
		{"solicitude", "solicitud"},
		{"solid", "solid"},
		{"solidified", "solidifi"},
		{"solidities", "solid"},
		{"solidity", "solid"},
		{"solidness", "solid"},
		{"soliloquies", "soliloqui"},
		{"soliloquised", "soliloquis"},
		{"soliloquize", "soliloqu"},
		{"soliloquized", "soliloqu"},
		{"soliloquy", "soliloquy"},
		{"solitaries", "solitari"},
		{"solitary", "solitari"},
		{"solitude", "solitud"},
		{"solitudes", "solitud"},
		{"solo", "solo"},
		{"solomon", "solomon"},
		{"solon", "solon"},
		{"solstice", "solstic"},
		{"soluble", "solubl"},
		{"solution", "solut"},
		{"solve", "solv"},
		{"solved", "solv"},
		{"solvent", "solvent"},
		{"solves", "solv"},
		{"som", "som"},
		{"sombre", "sombr"},
		{"sombrero", "sombrero"},
		{"some", "some"},
		{"somebodies", "somebodi"},
		{"somebody", "somebodi"},
		{"someday", "someday"},
		{"somehow", "somehow"},
		{"someone", "someon"},
		{"somers", "somer"},
		{"something", "someth"},
		{"somethings", "someth"},
		{"somethink", "somethink"},
		{"sometime", "sometim"},
		{"sometimes", "sometim"},
		{"someway", "someway"},
		{"somewhat", "somewhat"},
		{"somewhere", "somewher"},
		{"somewheres", "somewher"},
		{"somewhither", "somewhith"},
		{"somnolent", "somnol"},
		{"somnum", "somnum"},
		{"son", "son"},
		{"sondern", "sondern"},
		{"sone", "sone"},
		{"song", "song"},
		{"songs", "song"},
		{"sonia", "sonia"},
		{"sonnets", "sonnet"},
		{"sonorous", "sonor"},
		{"sonorously", "sonor"},
		{"sonourous", "sonour"},
		{"sons", "son"},
		{"soobjact", "soobjact"},
		{"soodden", "soodden"},
		{"sooffer", "sooffer"},
		{"soom", "soom"},
		{"soomat", "soomat"},
		{"soon", "soon"},
		{"sooner", "sooner"},
		{"soonest", "soonest"},
		{"soop", "soop"},
		{"sooper", "sooper"},
		{"soot", "soot"},
		{"sooth", "sooth"},
		{"soothe", "sooth"},
		{"soothed", "sooth"},
		{"soothing", "sooth"},
		{"soothingly", "sooth"},
		{"sooty", "sooti"},
		{"sop", "sop"},
		{"sophistry", "sophistri"},
		{"soporific", "soporif"},
		{"sopped", "sop"},
		{"sorcery", "sorceri"},
		{"sordid", "sordid"},
		{"sore", "sore"},
		{"sorely", "sore"},
		{"soreness", "sore"},
		{"sores", "sore"},
		{"sorest", "sorest"},
		{"sorrel", "sorrel"},
		{"sorrow", "sorrow"},
		{"sorrowful", "sorrow"},
		{"sorrowfully", "sorrow"},
		{"sorrowing", "sorrow"},
		{"sorrows", "sorrow"},
		{"sorry", "sorri"},
		{"sort", "sort"},
		{"sorted", "sort"},
		{"sorting", "sort"},
		{"sorts", "sort"},
		{"sotto", "sotto"},
		{"sought", "sought"},
		{"soul", "soul"},
		{"souled", "soul"},
		{"souls", "soul"},
		{"soun", "soun"},
		{"sound", "sound"},
		{"sounded", "sound"},
		{"sounder", "sounder"},
		{"sounding", "sound"},
		{"soundings", "sound"},
		{"soundly", "sound"},
		{"soundness", "sound"},
		{"sounds", "sound"},
		{"soup", "soup"},
		{"sour", "sour"},
		{"source", "sourc"},
		{"sources", "sourc"},
		{"soured", "sour"},
		{"souring", "sour"},
		{"sourly", "sour"},
		{"sous", "sous"},
		{"soused", "sous"},
		{"sousing", "sous"},
		{"sout", "sout"},
		{"south", "south"},
		{"southampton", "southampton"},
		{"southerly", "souther"},
		{"southern", "southern"},
		{"southfront", "southfront"},
		{"southward", "southward"},
		{"southwards", "southward"},
		{"southwestern", "southwestern"},
		{"sov", "sov"},
		{"sovereign", "sovereign"},
		{"sovereignest", "sovereignest"},
		{"sovereigns", "sovereign"},
		{"sovereignty", "sovereignti"},
		{"sow", "sow"},
		{"sowed", "sow"},
		{"sowerby", "sowerbi"},
		{"sowing", "sow"},
		{"sown", "sown"},
		{"sows", "sow"},
		{"space", "space"},
		{"spaces", "space"},
		{"spacious", "spacious"},
		{"spade", "spade"},
		{"spain", "spain"},
		{"spak", "spak"},
		{"spake", "spake"},
		{"spaletro", "spaletro"},
		{"span", "span"},
		{"spangled", "spangl"},
		{"spaniard", "spaniard"},
		{"spaniards", "spaniard"},
		{"spaniels", "spaniel"},
		{"spanish", "spanish"},
		{"spanned", "span"},
		{"spar", "spar"},
		{"spare", "spare"},
		{"spared", "spare"},
		{"spares", "spare"},
		{"sparing", "spare"},
		{"sparingly", "spare"},
		{"spark", "spark"},
		{"sparking", "spark"},
		{"sparkle", "sparkl"},
		{"sparkled", "sparkl"},
		{"sparklers", "sparkler"},
		{"sparkles", "sparkl"},
		{"sparkling", "sparkl"},
		{"sparks", "spark"},
		{"sparring", "spar"},
		{"sparrow", "sparrow"},
		{"sparrows", "sparrow"},
		{"spartan", "spartan"},
		{"spasm", "spasm"},
		{"spasmodic", "spasmod"},
		{"spasmodically", "spasmod"},
		{"spasms", "spasm"},
		{"spat", "spat"},
		{"spattered", "spatter"},
		{"spawn", "spawn"},
		{"speak", "speak"},
		{"speaker", "speaker"},
		{"speaketh", "speaketh"},
		{"speakin", "speakin"},
		{"speaking", "speak"},
		{"speaks", "speak"},
		{"spear", "spear"},
		{"spearhead", "spearhead"},
		{"spearing", "spear"},
		{"spears", "spear"},
		{"spec", "spec"},
		{"special", "special"},
		{"specialist", "specialist"},
		{"speciality", "special"},
		{"specially", "special"},
		{"specialty", "specialti"},
		{"species", "speci"},
		{"specific", "specif"},
		{"specifically", "specif"},
		{"specified", "specifi"},
		{"specify", "specifi"},
		{"specimen", "specimen"},
		{"specimens", "specimen"},
		{"specious", "specious"},
		{"speck", "speck"},
		{"speckelation", "speckel"},
		{"speckled", "speckl"},
		{"specks", "speck"},
		{"spectacle", "spectacl"},
		{"spectacled", "spectacl"},
		{"spectacles", "spectacl"},
		{"spectator", "spectat"},
		{"spectators", "spectat"},
		{"spectral", "spectral"},
		{"spectre", "spectr"},
		{"speculate", "specul"},
		{"speculated", "specul"},
		{"speculates", "specul"},
		{"speculating", "specul"},
		{"speculation", "specul"},
		{"speculations", "specul"},
		{"speculative", "specul"},
		{"speculator", "specul"},
		{"speculators", "specul"},
		{"sped", "sped"},
		{"speech", "speech"},
		{"speeches", "speech"},
		{"speechifying", "speechifi"},
		{"speechless", "speechless"},
		{"speechlessly", "speechless"},
		{"speed", "speed"},
		{"speediest", "speediest"},
		{"speedily", "speedili"},
		{"speedy", "speedi"},
		{"spell", "spell"},
		{"spelling", "spell"},
		{"spells", "spell"},
		{"spelt", "spelt"},
		{"spence", "spenc"},
		{"spencer", "spencer"},
		{"spend", "spend"},
		{"spending", "spend"},
		{"spends", "spend"},
		{"spendthrift", "spendthrift"},
		{"spent", "spent"},
		{"spermaceti", "spermaceti"},
		{"sphere", "sphere"},
		{"spheres", "sphere"},
		{"spherical", "spheric"},
		{"sphex", "sphex"},
		{"sphinx", "sphinx"},
		{"sphinxes", "sphinx"},
		{"spice", "spice"},
		{"spick", "spick"},
		{"spicula", "spicula"},
		{"spicy", "spici"},
		{"spider", "spider"},
		{"spiders", "spider"},
		{"spied", "spi"},
		{"spies", "spi"},
		{"spigwiffin", "spigwiffin"},
		{"spiked", "spike"},
		{"spikes", "spike"},
		{"spileing", "spile"},
		{"spill", "spill"},
		{"spilled", "spill"},
		{"spilling", "spill"},
		{"spilt", "spilt"},
		{"spin", "spin"},
		{"spinach", "spinach"},
		{"spinal", "spinal"},
		{"spindle", "spindl"},
		{"spine", "spine"},
		{"spines", "spine"},
		{"spinners", "spinner"},
		{"spinnies", "spinni"},
		{"spinning", "spin"},
		{"spinster", "spinster"},
		{"spiny", "spini"},
		{"spiral", "spiral"},
		{"spirally", "spiral"},
		{"spire", "spire"},
		{"spires", "spire"},
		{"spirit", "spirit"},
		{"spirited", "spirit"},
		{"spiritless", "spiritless"},
		{"spirits", "spirit"},
		{"spiritual", "spiritu"},
		{"spirituous", "spiritu"},
		{"spirt", "spirt"},
		{"spirted", "spirt"},
		{"spit", "spit"},
		{"spite", "spite"},
		{"spiteful", "spite"},
		{"spitefully", "spite"},
		{"spitefulness", "spite"},
		{"spithead", "spithead"},
		{"spits", "spit"},
		{"spitting", "spit"},
		{"spittoon", "spittoon"},
		{"spittoons", "spittoon"},
		{"spitzbergen", "spitzbergen"},
		{"splash", "splash"},
		{"splashed", "splash"},
		{"splashes", "splash"},
		{"splashin", "splashin"},
		{"splashing", "splash"},
		{"spleen", "spleen"},
		{"splendid", "splendid"},
		{"splendidly", "splendid"},
		{"splendour", "splendour"},
		{"splendours", "splendour"},
		{"splenetic", "splenet"},
		{"splinter", "splinter"},
		{"split", "split"},
		{"splitting", "split"},
		{"sploiced", "sploic"},
		{"splutter", "splutter"},
		{"spluttering", "splutter"},
		{"spo", "spo"},
		{"spoil", "spoil"},
		{"spoiled", "spoil"},
		{"spoiling", "spoil"},
		{"spoils", "spoil"},
		{"spoilt", "spoilt"},
		{"spoke", "spoke"},
		{"spoken", "spoken"},
		{"spokesman", "spokesman"},
		{"spoliation", "spoliat"},
		{"sponge", "spong"},
		{"spongey", "spongey"},
		{"sponsor", "sponsor"},
		{"sponsorial", "sponsori"},
		{"sponsors", "sponsor"},
		{"spontaneous", "spontan"},
		{"spontaneously", "spontan"},
		{"spoon", "spoon"},
		{"spoonbill", "spoonbil"},
		{"spoonful", "spoon"},
		{"spoonfuls", "spoon"},
		{"spoons", "spoon"},
		{"sport", "sport"},
		{"sported", "sport"},
		{"sporting", "sport"},
		{"sportive", "sportiv"},
		{"sportiveness", "sportiv"},
		{"sports", "sport"},
		{"sportsman", "sportsman"},
		{"sportsmen", "sportsmen"},
		{"sporules", "sporul"},
		{"spot", "spot"},
		{"spotless", "spotless"},
		{"spots", "spot"},
		{"spotted", "spot"},
		{"spotty", "spotti"},
		{"spouse", "spous"},
		{"spout", "spout"},
		{"spouting", "spout"},
		{"spouts", "spout"},
		{"spraining", "sprain"},
		{"sprang", "sprang"},
		{"sprawler", "sprawler"},
		{"sprawls", "sprawl"},
		{"spray", "spray"},
		{"spread", "spread"},
		{"spreading", "spread"},
		{"spreads", "spread"},
		{"spree", "spree"},
		{"sprightliness", "sprightli"},
		{"sprightly", "spright"},
		{"spring", "spring"},
		{"springing", "spring"},
		{"springs", "spring"},
		{"sprinkle", "sprinkl"},
		{"sprinkled", "sprinkl"},
		{"sprinkling", "sprinkl"},
		{"sprite", "sprite"},
		{"sprott", "sprott"},
		{"sprout", "sprout"},
		{"sprouter", "sprouter"},
		{"sprouts", "sprout"},
		{"spruce", "spruce"},
		{"sprucely", "spruce"},
		{"sprugeon", "sprugeon"},
		{"sprugeons", "sprugeon"},
		{"sprung", "sprung"},
		{"spun", "spun"},
		{"spur", "spur"},
		{"spurn", "spurn"},
		{"spurned", "spurn"},
		{"spurred", "spur"},
		{"spurs", "spur"},
		{"spy", "spi"},
		{"spying", "spi"},
		{"squabble", "squabbl"},
		{"squabbles", "squabbl"},
		{"squabbling", "squabbl"},
		{"squabs", "squab"},
		{"squalid", "squalid"},
		{"squall", "squall"},
		{"squallingest", "squallingest"},
		{"squalls", "squall"},
		{"squally", "squalli"},
		{"squalor", "squalor"},
		{"squander", "squander"},
		{"squandered", "squander"},
		{"squandering", "squander"},
		{"square", "squar"},
		{"squared", "squar"},
		{"squarely", "squar"},
		{"squarer", "squarer"},
		{"squares", "squar"},
		{"squaring", "squar"},
		{"squashed", "squash"},
		{"squat", "squat"},
		{"squatted", "squat"},
		{"squatters", "squatter"},
		{"squatting", "squat"},
		{"squeak", "squeak"},
		{"squeaked", "squeak"},
		{"squeal", "squeal"},
		{"squealed", "squeal"},
		{"squealing", "squeal"},
		{"squeals", "squeal"},
		{"squeamishly", "squeamish"},
		{"squeamishness", "squeamish"},
		{"squeedged", "squeedg"},
		{"squeedgin", "squeedgin"},
		{"squeer", "squeer"},
		{"squeers", "squeer"},
		{"squeerses", "squeers"},
		{"squeery", "squeeri"},
		{"squeeze", "squeez"},
		{"squeezed", "squeez"},
		{"squeezes", "squeez"},
		{"squeezing", "squeez"},
		{"squib", "squib"},
		{"squint", "squint"},
		{"squire", "squir"},
		{"squirearchy", "squirearchi"},
		{"squires", "squir"},
		{"squiress", "squiress"},
		{"squirt", "squirt"},
		{"squod", "squod"},
		{"st", "st"},
		{"stab", "stab"},
		{"stabbed", "stab"},
		{"stabbing", "stab"},
		{"stability", "stabil"},
		{"stable", "stabl"},
		{"stabled", "stabl"},
		{"stables", "stabl"},
		{"stablewards", "stableward"},
		{"stabling", "stabl"},
		{"stack", "stack"},
		{"stacks", "stack"},
		{"staff", "staff"},
		{"staffordshire", "staffordshir"},
		{"staffs", "staff"},
		{"stag", "stag"},
		{"stage", "stage"},
		{"stagecoach", "stagecoach"},
		{"stager", "stager"},
		{"stages", "stage"},
		{"stagger", "stagger"},
		{"staggered", "stagger"},
		{"staggering", "stagger"},
		{"staggers", "stagger"},
		{"stagnant", "stagnant"},
		{"stagnating", "stagnat"},
		{"stagnation", "stagnat"},
		{"stags", "stag"},
		{"staid", "staid"},
		{"staidness", "staid"},
		{"stain", "stain"},
		{"stained", "stain"},
		{"stains", "stain"},
		{"stair", "stair"},
		{"staircase", "staircas"},
		{"staircases", "staircas"},
		{"stairs", "stair"},
		{"stake", "stake"},
		{"staked", "stake"},
		{"stakes", "stake"},
		{"staking", "stake"},
		{"stalactical", "stalact"},
		{"stalactitic", "stalactit"},
		{"stale", "stale"},
		{"staled", "stale"},
		{"stalk", "stalk"},
		{"stalked", "stalk"},
		{"stalking", "stalk"},
		{"stalks", "stalk"},
		{"stall", "stall"},
		{"stallion", "stallion"},
		{"stallions", "stallion"},
		{"stalwart", "stalwart"},
		{"stamens", "stamen"},
		{"stamford", "stamford"},
		{"stammer", "stammer"},
		{"stammered", "stammer"},
		{"stammering", "stammer"},
		{"stammers", "stammer"},
		{"stamp", "stamp"},
		{"stamped", "stamp"},
		{"stamping", "stamp"},
		{"stamps", "stamp"},
		{"stan", "stan"},
		{"stanch", "stanch"},
		{"stand", "stand"},
		{"standaloft", "standaloft"},
		{"standard", "standard"},
		{"standing", "stand"},
		{"stands", "stand"},
		{"standstill", "standstil"},
		{"stanza", "stanza"},
		{"staphylinidae", "staphylinida"},
		{"staple", "stapl"},
		{"star", "star"},
		{"starch", "starch"},
		{"starched", "starch"},
		{"stare", "stare"},
		{"stared", "stare"},
		{"stares", "stare"},
		{"staring", "stare"},
		{"staringly", "stare"},
		{"stark", "stark"},
		{"starlight", "starlight"},
		{"starling", "starl"},
		{"starn", "starn"},
		{"starred", "star"},
		{"starry", "starri"},
		{"stars", "star"},
		{"start", "start"},
		{"starte", "start"},
		{"started", "start"},
		{"starting", "start"},
		{"startings", "start"},
		{"startle", "startl"},
		{"startled", "startl"},
		{"startles", "startl"},
		{"startling", "startl"},
		{"starts", "start"},
		{"starvation", "starvat"},
		{"starve", "starv"},
		{"starved", "starv"},
		{"starvin", "starvin"},
		{"starving", "starv"},
		{"starwation", "starwat"},
		{"state", "state"},
		{"statecraft", "statecraft"},
		{"stated", "state"},
		{"stateliness", "stateli"},
		{"stately", "state"},
		{"statement", "statement"},
		{"statements", "statement"},
		{"statenland", "statenland"},
		{"states", "state"},
		{"statesman", "statesman"},
		{"statesmanlike", "statesmanlik"},
		{"statesmen", "statesmen"},
		{"stating", "state"},
		{"station", "station"},
		{"stationary", "stationari"},
		{"stationed", "station"},
		{"stationer", "station"},
		{"stationering", "station"},
		{"stationers", "station"},
		{"stationery", "stationeri"},
		{"stations", "station"},
		{"statu", "statu"},
		{"statuary", "statuari"},
		{"statue", "statu"},
		{"statues", "statu"},
		{"stature", "statur"},
		{"status", "status"},
		{"statute", "statut"},
		{"staunch", "staunch"},
		{"staunchly", "staunch"},
		{"staunchness", "staunch"},
		{"stave", "stave"},
		{"staved", "stave"},
		{"staves", "stave"},
		{"staving", "stave"},
		{"stay", "stay"},
		{"stayed", "stay"},
		{"staying", "stay"},
		{"staylace", "staylac"},
		{"stays", "stay"},
		{"stead", "stead"},
		{"steadfast", "steadfast"},
		{"steadfastly", "steadfast"},
		{"steadfastness", "steadfast"},
		{"steadied", "steadi"},
		{"steadier", "steadier"},
		{"steadily", "steadili"},
		{"steadiness", "steadi"},
		{"steady", "steadi"},
		{"steak", "steak"},
		{"steal", "steal"},
		{"stealing", "steal"},
		{"stealings", "steal"},
		{"steals", "steal"},
		{"stealth", "stealth"},
		{"stealthily", "stealthili"},
		{"stealthy", "stealthi"},
		{"steam", "steam"},
		{"steamboat", "steamboat"},
		{"steamboats", "steamboat"},
		{"steamed", "steam"},
		{"steamer", "steamer"},
		{"steamers", "steamer"},
		{"steaming", "steam"},
		{"steams", "steam"},
		{"steddy", "steddi"},
		{"stee", "stee"},
		{"steed", "steed"},
		{"steeds", "steed"},
		{"steel", "steel"},
		{"steeled", "steel"},
		{"steep", "steep"},
		{"steeped", "steep"},
		{"steeper", "steeper"},
		{"steepest", "steepest"},
		{"steeple", "steepl"},
		{"steeplechase", "steeplechas"},
		{"steepled", "steepl"},
		{"steeples", "steepl"},
		{"steeply", "steepli"},
		{"steepness", "steep"},
		{"steer", "steer"},
		{"steered", "steer"},
		{"steering", "steer"},
		{"stem", "stem"},
		{"stemming", "stem"},
		{"stems", "stem"},
		{"stench", "stench"},
		{"stentorian", "stentorian"},
		{"step", "step"},
		{"stepdaughter", "stepdaught"},
		{"stephenson", "stephenson"},
		{"stepmother", "stepmoth"},
		{"steppe", "stepp"},
		{"stepped", "step"},
		{"steppes", "stepp"},
		{"stepping", "step"},
		{"steps", "step"},
		{"stepson", "stepson"},
		{"stercovorous", "stercovor"},
		{"sterile", "steril"},
		{"sterilit", "sterilit"},
		{"sterility", "steril"},
		{"sterling", "sterl"},
		{"stern", "stern"},
		{"sterne", "stern"},
		{"sterner", "sterner"},
		{"sternest", "sternest"},
		{"sternly", "stern"},
		{"sternness", "stern"},
		{"stertorous", "stertor"},
		{"stertorously", "stertor"},
		{"stethoscope", "stethoscop"},
		{"stew", "stew"},
		{"stewam", "stewam"},
		{"steward", "steward"},
		{"stewardship", "stewardship"},
		{"stewart", "stewart"},
		{"stewing", "stew"},
		{"stic", "stic"},
		{"stick", "stick"},
		{"sticker", "sticker"},
		{"sticking", "stick"},
		{"stickler", "stickler"},
		{"sticks", "stick"},
		{"sticky", "sticki"},
		{"stif", "stif"},
		{"stiff", "stiff"},
		{"stiffer", "stiffer"},
		{"stiffest", "stiffest"},
		{"stiffly", "stiffli"},
		{"stiffness", "stiff"},
		{"stifle", "stifl"},
		{"stifled", "stifl"},
		{"stifling", "stifl"},
		{"stigmatised", "stigmatis"},
		{"stigmatize", "stigmat"},
		{"stigmatizing", "stigmat"},
		{"still", "still"},
		{"stillest", "stillest"},
		{"stillness", "still"},
		{"stilt", "stilt"},
		{"stilts", "stilt"},
		{"stimulant", "stimul"},
		{"stimulants", "stimul"},
		{"stimulate", "stimul"},
		{"stimulated", "stimul"},
		{"stimulates", "stimul"},
		{"stimulating", "stimul"},
		{"stimulation", "stimul"},
		{"stimulus", "stimulus"},
		{"sting", "sting"},
		{"stinginess", "stingi"},
		{"stinging", "sting"},
		{"stings", "sting"},
		{"stinketh", "stinketh"},
		{"stinking", "stink"},
		{"stinks", "stink"},
		{"stipend", "stipend"},
		{"stipendiaries", "stipendiari"},
		{"stipulate", "stipul"},
		{"stipulated", "stipul"},
		{"stipulating", "stipul"},
		{"stipulation", "stipul"},
		{"stipulations", "stipul"},
		{"stir", "stir"},
		{"stirred", "stir"},
		{"stirring", "stir"},
		{"stirrup", "stirrup"},
		{"stirrups", "stirrup"},
		{"stirs", "stir"},
		{"stitch", "stitch"},
		{"stitched", "stitch"},
		{"stitches", "stitch"},
		{"stitching", "stitch"},
		{"stock", "stock"},
		{"stockade", "stockad"},
		{"stockbroker", "stockbrok"},
		{"stocked", "stock"},
		{"stocking", "stock"},
		{"stockingless", "stockingless"},
		{"stockings", "stock"},
		{"stocks", "stock"},
		{"stokes", "stoke"},
		{"stolbuns", "stolbun"},
		{"stole", "stole"},
		{"stolen", "stolen"},
		{"stolid", "stolid"},
		{"stolidity", "stolid"},
		{"stolidly", "stolid"},
		{"stomach", "stomach"},
		{"stomached", "stomach"},
		{"stomacher", "stomach"},
		{"stomachic", "stomach"},
		{"stomachs", "stomach"},
		{"stond", "stond"},
		{"stone", "stone"},
		{"stoned", "stone"},
		{"stones", "stone"},
		{"stony", "stoni"},
		{"stood", "stood"},
		{"stool", "stool"},
		{"stools", "stool"},
		{"stoop", "stoop"},
		{"stooped", "stoop"},
		{"stooping", "stoop"},
		{"stoops", "stoop"},
		{"stop", "stop"},
		{"stoppage", "stoppag"},
		{"stoppages", "stoppag"},
		{"stopped", "stop"},
		{"stopper", "stopper"},
		{"stopping", "stop"},
		{"stops", "stop"},
		{"store", "store"},
		{"stored", "store"},
		{"storehouse", "storehous"},
		{"storehouses", "storehous"},
		{"stores", "store"},
		{"storey", "storey"},
		{"storeys", "storey"},
		{"storied", "stori"},
		{"stories", "stori"},
		{"storing", "store"},
		{"stork", "stork"},
		{"storks", "stork"},
		{"storm", "storm"},
		{"stormed", "storm"},
		{"storming", "storm"},
		{"storms", "storm"},
		{"stormy", "stormi"},
		{"storr", "storr"},
		{"story", "stori"},
		{"storybook", "storybook"},
		{"stout", "stout"},
		{"stouter", "stouter"},
		{"stoutest", "stoutest"},
		{"stoutish", "stoutish"},
		{"stoutly", "stout"},
		{"stove", "stove"},
		{"stoves", "stove"},
		{"stow", "stow"},
		{"stowed", "stow"},
		{"strack", "strack"},
		{"straggle", "straggl"},
		{"straggled", "straggl"},
		{"straggler", "straggler"},
		{"stragglers", "straggler"},
		{"straggling", "straggl"},
		{"straight", "straight"},
		{"straightening", "straighten"},
		{"straightforward", "straightforward"},
		{"straightly", "straight"},
		{"straightway", "straightway"},
		{"strain", "strain"},
		{"strained", "strain"},
		{"straining", "strain"},
		{"strains", "strain"},
		{"strait", "strait"},
		{"straitened", "straiten"},
		{"straits", "strait"},
		{"strand", "strand"},
		{"stranded", "strand"},
		{"stranding", "strand"},
		{"strange", "strang"},
		{"strangely", "strang"},
		{"strangeness", "strang"},
		{"stranger", "stranger"},
		{"strangers", "stranger"},
		{"strangest", "strangest"},
		{"strangle", "strangl"},
		{"strangled", "strangl"},
		{"strangling", "strangl"},
		{"strangulation", "strangul"},
		{"strap", "strap"},
		{"strapped", "strap"},
		{"straps", "strap"},
		{"strata", "strata"},
		{"stratagem", "stratagem"},
		{"strategy", "strategi"},
		{"stratford", "stratford"},
		{"stratification", "stratif"},
		{"stratified", "stratifi"},
		{"stratum", "stratum"},
		{"straw", "straw"},
		{"strawberries", "strawberri"},
		{"straws", "straw"},
		{"stray", "stray"},
		{"strayed", "stray"},
		{"straying", "stray"},
		{"streak", "streak"},
		{"streaked", "streak"},
		{"streaks", "streak"},
		{"stream", "stream"},
		{"streamed", "stream"},
		{"streamer", "streamer"},
		{"streaming", "stream"},
		{"streamlet", "streamlet"},
		{"streamlets", "streamlet"},
		{"streams", "stream"},
		{"street", "street"},
		{"streetdoor", "streetdoor"},
		{"streets", "street"},
		{"strength", "strength"},
		{"strengthen", "strengthen"},
		{"strengthened", "strengthen"},
		{"strengthening", "strengthen"},
		{"strenuously", "strenuous"},
		{"stress", "stress"},
		{"stretch", "stretch"},
		{"stretched", "stretch"},
		{"stretches", "stretch"},
		{"stretching", "stretch"},
		{"stretchings", "stretch"},
		{"strew", "strew"},
		{"strewed", "strew"},
		{"strewn", "strewn"},
		{"stricken", "stricken"},
		{"strickland", "strickland"},
		{"strict", "strict"},
		{"stricter", "stricter"},
		{"strictest", "strictest"},
		{"strictly", "strict"},
		{"strictness", "strict"},
		{"stride", "stride"},
		{"strides", "stride"},
		{"striding", "stride"},
		{"strife", "strife"},
		{"strike", "strike"},
		{"strikes", "strike"},
		{"striking", "strike"},
		{"strikingly", "strike"},
		{"string", "string"},
		{"strings", "string"},
		{"strip", "strip"},
		{"striped", "stripe"},
		{"stripes", "stripe"},
		{"stripling", "stripl"},
		{"stripped", "strip"},
		{"stripping", "strip"},
		{"strips", "strip"},
		{"stritched", "stritch"},
		{"strive", "strive"},
		{"striven", "striven"},
		{"striving", "strive"},
		{"strix", "strix"},
		{"strode", "strode"},
		{"stroke", "stroke"},
		{"stroked", "stroke"},
		{"strokes", "stroke"},
		{"stroking", "stroke"},
		{"strokings", "stroke"},
		{"stroll", "stroll"},
		{"strolled", "stroll"},
		{"strolling", "stroll"},
		{"strolls", "stroll"},
		{"strong", "strong"},
		{"stronger", "stronger"},
		{"strongest", "strongest"},
		{"strongholds", "stronghold"},
		{"strongly", "strong"},
		{"strongylus", "strongylus"},
		{"strop", "strop"},
		{"strove", "strove"},
		{"struck", "struck"},
		{"structure", "structur"},
		{"structures", "structur"},
		{"struggle", "struggl"},
		{"struggled", "struggl"},
		{"struggler", "struggler"},
		{"strugglers", "struggler"},
		{"struggles", "struggl"},
		{"struggling", "struggl"},
		{"strum", "strum"},
		{"strung", "strung"},
		{"struthio", "struthio"},
		{"strzelecki", "strzelecki"},
		{"stuart", "stuart"},
		{"stubb", "stubb"},
		{"stubble", "stubbl"},
		{"stubbly", "stubbl"},
		{"stubborn", "stubborn"},
		{"stubbornly", "stubborn"},
		{"stubbornness", "stubborn"},
		{"stubbs", "stubb"},
		{"stuck", "stuck"},
		{"stud", "stud"},
		{"studded", "stud"},
		{"student", "student"},
		{"students", "student"},
		{"studied", "studi"},
		{"studies", "studi"},
		{"studio", "studio"},
		{"studious", "studious"},
		{"studiously", "studious"},
		{"studiousness", "studious"},
		{"study", "studi"},
		{"studying", "studi"},
		{"stuff", "stuff"},
		{"stuffed", "stuf"},
		{"stuffing", "stuf"},
		{"stuffs", "stuff"},
		{"stuffy", "stuffi"},
		{"stumble", "stumbl"},
		{"stumbled", "stumbl"},
		{"stumbles", "stumbl"},
		{"stumbling", "stumbl"},
		{"stump", "stump"},
		{"stumps", "stump"},
		{"stung", "stung"},
		{"stunned", "stun"},
		{"stunning", "stun"},
		{"stunted", "stunt"},
		{"stupefaction", "stupefact"},
		{"stupefied", "stupefi"},
		{"stupendous", "stupend"},
		{"stupid", "stupid"},
		{"stupider", "stupid"},
		{"stupidity", "stupid"},
		{"stupidly", "stupid"},
		{"stupids", "stupid"},
		{"stupor", "stupor"},
		{"sturdiest", "sturdiest"},
		{"sturdily", "sturdili"},
		{"sturdy", "sturdi"},
		{"sturt", "sturt"},
		{"stuttered", "stutter"},
		{"style", "style"},
		{"styles", "style"},
		{"stylifer", "stylif"},
		{"stylish", "stylish"},
		{"suadiva", "suadiva"},
		{"suavity", "suaviti"},
		{"sub", "sub"},
		{"subacid", "subacid"},
		{"subaqueous", "subaqu"},
		{"subcostal", "subcost"},
		{"subdue", "subdu"},
		{"subdued", "subdu"},
		{"subduer", "subduer"},
		{"subdues", "subdu"},
		{"subduing", "subdu"},
		{"subgroup", "subgroup"},
		{"subgroups", "subgroup"},
		{"subject", "subject"},
		{"subjected", "subject"},
		{"subjecting", "subject"},
		{"subjection", "subject"},
		{"subjects", "subject"},
		{"subjugating", "subjug"},
		{"sublime", "sublim"},
		{"sublimity", "sublim"},
		{"submarine", "submarin"},
		{"submerged", "submerg"},
		{"submergence", "submerg"},
		{"submission", "submiss"},
		{"submissive", "submiss"},
		{"submissively", "submiss"},
		{"submissiveness", "submiss"},
		{"submit", "submit"},
		{"submits", "submit"},
		{"submitted", "submit"},
		{"submitting", "submit"},
		{"subordinate", "subordin"},
		{"subordinates", "subordin"},
		{"subordination", "subordin"},
		{"suborned", "suborn"},
		{"suborning", "suborn"},
		{"subscribe", "subscrib"},
		{"subscribed", "subscrib"},
		{"subscribing", "subscrib"},
		{"subscription", "subscript"},
		{"subscriptions", "subscript"},
		{"subsequent", "subsequ"},
		{"subsequently", "subsequ"},
		{"subservience", "subservi"},
		{"subserviences", "subservi"},
		{"subservient", "subservi"},
		{"subside", "subsid"},
		{"subsided", "subsid"},
		{"subsidence", "subsid"},
		{"subsides", "subsid"},
		{"subsidiary", "subsidiari"},
		{"subsiding", "subsid"},
		{"subsidized", "subsid"},
		{"subsist", "subsist"},
		{"subsisted", "subsist"},
		{"subsistence", "subsist"},
		{"subsoil", "subsoil"},
		{"substance", "substanc"},
		{"substances", "substanc"},
		{"substantial", "substanti"},
		{"substantially", "substanti"},
		{"substantials", "substanti"},
		{"substantiate", "substanti"},
		{"substantive", "substant"},
		{"substitute", "substitut"},
		{"substituted", "substitut"},
		{"substitutes", "substitut"},
		{"substituting", "substitut"},
		{"substracted", "substract"},
		{"substratum", "substratum"},
		{"subterfuge", "subterfug"},
		{"subterfuges", "subterfug"},
		{"subterranean", "subterranean"},
		{"subtile", "subtil"},
		{"subtle", "subtl"},
		{"subtlety", "subtleti"},
		{"subtracted", "subtract"},
		{"subtracting", "subtract"},
		{"suburb", "suburb"},
		{"suburban", "suburban"},
		{"suburbs", "suburb"},
		{"subversive", "subvers"},
		{"subverted", "subvert"},
		{"suc", "suc"},
		{"succeed", "succeed"},
		{"succeeded", "succeed"},
		{"succeeding", "succeed"},
		{"succeeds", "succeed"},
		{"success", "success"},
		{"successes", "success"},
		{"successful", "success"},
		{"successfully", "success"},
		{"succession", "success"},
		{"successions", "success"},
		{"successive", "success"},
		{"successively", "success"},
		{"successor", "successor"},
		{"successors", "successor"},
		{"succinea", "succinea"},
		{"succour", "succour"},
		{"succulent", "succul"},
		{"succumbed", "succumb"},
		{"succumbing", "succumb"},
		{"such", "such"},
		{"suck", "suck"},
		{"sucked", "suck"},
		{"sucker", "sucker"},
		{"suckers", "sucker"},
		{"sucking", "suck"},
		{"suckle", "suckl"},
		{"suckling", "suckl"},
		{"suction", "suction"},
		{"sudden", "sudden"},
		{"suddenl", "suddenl"},
		{"suddenly", "sudden"},
		{"suddenness", "sudden"},
		{"suds", "sud"},
		{"sued", "su"},
		{"suffer", "suffer"},
		{"sufferance", "suffer"},
		{"suffered", "suffer"},
		{"sufferer", "suffer"},
		{"sufferers", "suffer"},
		{"suffering", "suffer"},
		{"sufferings", "suffer"},
		{"suffers", "suffer"},
		{"suffice", "suffic"},
		{"sufficed", "suffic"},
		{"sufficiency", "suffici"},
		{"sufficient", "suffici"},
		{"sufficiently", "suffici"},
		{"sufficing", "suffic"},
		{"sufflciently", "sufflcient"},
		{"suffocated", "suffoc"},
		{"suffocating", "suffoc"},
		{"suffocation", "suffoc"},
		{"suffolk", "suffolk"},
		{"suffrage", "suffrag"},
		{"suffrages", "suffrag"},
		{"suffused", "suffus"},
		{"sugar", "sugar"},
		{"sugarscaps", "sugarscap"},
		{"sugarscraps", "sugarscrap"},
		{"suggest", "suggest"},
		{"suggested", "suggest"},
		{"suggesting", "suggest"},
		{"suggestion", "suggest"},
		{"suggestions", "suggest"},
		{"suggestive", "suggest"},
		{"suggests", "suggest"},
		{"suicidal", "suicid"},
		{"suicide", "suicid"},
		{"suicides", "suicid"},
		{"suing", "su"},
		{"suit", "suit"},
		{"suitability", "suitabl"},
		{"suitable", "suitabl"},
		{"suitably", "suitabl"},
		{"suite", "suit"},
		{"suited", "suit"},
		{"suites", "suit"},
		{"suiting", "suit"},
		{"suitor", "suitor"},
		{"suitors", "suitor"},
		{"suits", "suit"},
		{"sulivan", "sulivan"},
		{"sulk", "sulk"},
		{"sulked", "sulk"},
		{"sulkily", "sulkili"},
		{"sulkiness", "sulki"},
		{"sulks", "sulk"},
		{"sulky", "sulki"},
		{"sullen", "sullen"},
		{"sullenly", "sullen"},
		{"sullenness", "sullen"},
		{"sully", "sulli"},
		{"sulphate", "sulphat"},
		{"sulphates", "sulphat"},
		{"sulphur", "sulphur"},
		{"sulphuratus", "sulphuratus"},
		{"sulphureous", "sulphur"},
		{"sulphuric", "sulphur"},
		{"sultan", "sultan"},
		{"sultry", "sultri"},
		{"sum", "sum"},
		{"sumatra", "sumatra"},
		{"sumhoo", "sumhoo"},
		{"summarily", "summarili"},
		{"summary", "summari"},
		{"summat", "summat"},
		{"summer", "summer"},
		{"summers", "summer"},
		{"summerson", "summerson"},
		{"summertime", "summertim"},
		{"summing", "sum"},
		{"summit", "summit"},
		{"summits", "summit"},
		{"summon", "summon"},
		{"summoned", "summon"},
		{"summoning", "summon"},
		{"summons", "summon"},
		{"summonses", "summons"},
		{"summonsizzing", "summonsizz"},
		{"sumptuous", "sumptuous"},
		{"sumptuously", "sumptuous"},
		{"sums", "sum"},
		{"sun", "sun"},
		{"sunbeam", "sunbeam"},
		{"sunburnt", "sunburnt"},
		{"sunday", "sunday"},
		{"sundays", "sunday"},
		{"sundries", "sundri"},
		{"sundry", "sundri"},
		{"sunflowers", "sunflow"},
		{"sung", "sung"},
		{"sunk", "sunk"},
		{"sunken", "sunken"},
		{"sunlight", "sunlight"},
		{"sunning", "sun"},
		{"sunny", "sunni"},
		{"sunrise", "sunris"},
		{"suns", "sun"},
		{"sunset", "sunset"},
		{"sunsets", "sunset"},
		{"sunshine", "sunshin"},
		{"sunshiny", "sunshini"},
		{"sup", "sup"},
		{"superabundant", "superabund"},
		{"superadded", "superad"},
		{"superadding", "superad"},
		{"superannuated", "superannu"},
		{"superannuating", "superannu"},
		{"superb", "superb"},
		{"superbly", "superbl"},
		{"supercilious", "supercili"},
		{"superciliously", "supercili"},
		{"superciliousness", "supercili"},
		{"superficial", "superfici"},
		{"superficially", "superfici"},
		{"superfluities", "superflu"},
		{"superfluity", "superflu"},
		{"superfluous", "superflu"},
		{"superhuman", "superhuman"},
		{"superincumbent", "superincumb"},
		{"superinduced", "superinduc"},
		{"superintend", "superintend"},
		{"superintended", "superintend"},
		{"superintendence", "superintend"},
		{"superintendent", "superintend"},
		{"superintending", "superintend"},
		{"superintends", "superintend"},
		{"superior", "superior"},
		{"superiority", "superior"},
		{"superiors", "superior"},
		{"superlative", "superl"},
		{"superlatives", "superl"},
		{"superlativest", "superlativest"},
		{"supernatural", "supernatur"},
		{"supernumeraries", "supernumerari"},
		{"superscription", "superscript"},
		{"supersede", "supersed"},
		{"superseded", "supersed"},
		{"superstition", "superstit"},
		{"superstitious", "superstiti"},
		{"superstitiously", "superstiti"},
		{"supervene", "superven"},
		{"supervision", "supervis"},
		{"supped", "sup"},
		{"supper", "supper"},
		{"suppers", "supper"},
		{"supplanted", "supplant"},
		{"supple", "suppl"},
		{"supplementary", "supplementari"},
		{"suppleness", "suppl"},
		{"suppliant", "suppliant"},
		{"supplication", "supplic"},
		{"supplications", "supplic"},
		{"supplied", "suppli"},
		{"supplies", "suppli"},
		{"supply", "suppli"},
		{"supplying", "suppli"},
		{"suppor", "suppor"},
		{"support", "support"},
		{"supported", "support"},
		{"supporter", "support"},
		{"supporters", "support"},
		{"supporting", "support"},
		{"supports", "support"},
		{"suppose", "suppos"},
		{"supposed", "suppos"},
		{"supposes", "suppos"},
		{"supposing", "suppos"},
		{"supposition", "supposit"},
		{"suppositions", "supposit"},
		{"supposititious", "supposititi"},
		{"suppress", "suppress"},
		{"suppressed", "suppress"},
		{"suppressing", "suppress"},
		{"suppression", "suppress"},
		{"suppurated", "suppur"},
		{"supremacy", "supremaci"},
		{"supreme", "suprem"},
		{"supremely", "suprem"},
		{"supremest", "supremest"},
		{"sups", "sup"},
		{"sur", "sur"},
		{"surcingle", "surcingl"},
		{"sure", "sure"},
		{"surely", "sure"},
		{"surest", "surest"},
		{"surf", "surf"},
		{"surfac", "surfac"},
		{"surface", "surfac"},
		{"surfaces", "surfac"},
		{"surge", "surg"},
		{"surged", "surg"},
		{"surgeon", "surgeon"},
		{"surgeons", "surgeon"},
		{"surgery", "surgeri"},
		{"surging", "surg"},
		{"surly", "sur"},
		{"surmise", "surmis"},
		{"surmised", "surmis"},
		{"surmises", "surmis"},
		{"surmising", "surmis"},
		{"surmount", "surmount"},
		{"surmounted", "surmount"},
		{"surmounting", "surmount"},
		{"surname", "surnam"},
		{"surnames", "surnam"},
		{"surpass", "surpass"},
		{"surpassed", "surpass"},
		{"surpasses", "surpass"},
		{"surpassing", "surpass"},
		{"surplus", "surplus"},
		{"surprise", "surpris"},
		{"surprised", "surpris"},
		{"surprises", "surpris"},
		{"surprising", "surpris"},
		{"surprisingly", "surpris"},
		{"surrender", "surrend"},
		{"surrendered", "surrend"},
		{"surrendering", "surrend"},
		{"surreptitiously", "surreptiti"},
		{"surrey", "surrey"},
		{"surround", "surround"},
		{"surrounded", "surround"},
		{"surrounding", "surround"},
		{"surroundings", "surround"},
		{"surry", "surri"},
		{"surveillance", "surveil"},
		{"survey", "survey"},
		{"surveyed", "survey"},
		{"surveying", "survey"},
		{"surveyor", "surveyor"},
		{"surveyors", "surveyor"},
		{"surveys", "survey"},
		{"survive", "surviv"},
		{"survived", "surviv"},
		{"surviving", "surviv"},
		{"survivor", "survivor"},
		{"survivors", "survivor"},
		{"surweys", "surwey"},
		{"susan", "susan"},
		{"susceptibility", "suscept"},
		{"susceptible", "suscept"},
		{"suspect", "suspect"},
		{"suspected", "suspect"},
		{"suspecting", "suspect"},
		{"suspects", "suspect"},
		{"suspended", "suspend"},
		{"suspending", "suspend"},
		{"suspense", "suspens"},
		{"suspension", "suspens"},
		{"suspicion", "suspicion"},
		{"suspicions", "suspicion"},
		{"suspicious", "suspici"},
		{"suspiciously", "suspici"},
		{"suspiciousness", "suspici"},
		{"sustain", "sustain"},
		{"sustained", "sustain"},
		{"sustaining", "sustain"},
		{"sustenance", "susten"},
		{"svidrigailov", "svidrigailov"},
		{"svidrigailovs", "svidrigailov"},
		{"svidrigrailovs", "svidrigrailov"},
		{"svirbey", "svirbey"},
		{"swab", "swab"},
		{"swaddling", "swaddl"},
		{"swagger", "swagger"},
		{"swaggered", "swagger"},
		{"swaggering", "swagger"},
		{"swaggerings", "swagger"},
		{"swain", "swain"},
		{"swains", "swain"},
		{"swainson", "swainson"},
		{"swaller", "swaller"},
		{"swallering", "swaller"},
		{"swallow", "swallow"},
		{"swallowed", "swallow"},
		{"swallower", "swallow"},
		{"swallowing", "swallow"},
		{"swallows", "swallow"},
		{"swam", "swam"},
		{"swamp", "swamp"},
		{"swamps", "swamp"},
		{"swampy", "swampi"},
		{"swan", "swan"},
		{"swans", "swan"},
		{"swansea", "swansea"},
		{"sward", "sward"},
		{"swarm", "swarm"},
		{"swarmed", "swarm"},
		{"swarming", "swarm"},
		{"swarms", "swarm"},
		{"swart", "swart"},
		{"swarthy", "swarthi"},
		{"sway", "sway"},
		{"swayed", "sway"},
		{"swaying", "sway"},
		{"swear", "swear"},
		{"swearing", "swear"},
		{"swears", "swear"},
		{"sweat", "sweat"},
		{"sweden", "sweden"},
		{"sweep", "sweep"},
		{"sweeper", "sweeper"},
		{"sweepers", "sweeper"},
		{"sweeping", "sweep"},
		{"sweeps", "sweep"},
		{"sweet", "sweet"},
		{"sweetbread", "sweetbread"},
		{"sweetbrier", "sweetbrier"},
		{"sweeten", "sweeten"},
		{"sweetened", "sweeten"},
		{"sweetener", "sweeten"},
		{"sweeter", "sweeter"},
		{"sweetest", "sweetest"},
		{"sweetheart", "sweetheart"},
		{"sweethearts", "sweetheart"},
		{"sweetie", "sweeti"},
		{"sweetly", "sweet"},
		{"sweetmeat", "sweetmeat"},
		{"sweetness", "sweet"},
		{"sweets", "sweet"},
		{"swell", "swell"},
		{"swelled", "swell"},
		{"swelling", "swell"},
		{"swellings", "swell"},
		{"swells", "swell"},
		{"sweltering", "swelter"},
		{"swept", "swept"},
		{"swerve", "swerv"},
		{"swerved", "swerv"},
		{"swift", "swift"},
		{"swifter", "swifter"},
		{"swiftest", "swiftest"},
		{"swiftly", "swift"},
		{"swiftness", "swift"},
		{"swig", "swig"},
		{"swillenhausen", "swillenhausen"},
		{"swillenhausens", "swillenhausen"},
		{"swills", "swill"},
		{"swim", "swim"},
		{"swimming", "swim"},
		{"swims", "swim"},
		{"swindle", "swindl"},
		{"swindled", "swindl"},
		{"swindler", "swindler"},
		{"swindlers", "swindler"},
		{"swindling", "swindl"},
		{"swine", "swine"},
		{"swing", "swing"},
		{"swinging", "swing"},
		{"swings", "swing"},
		{"swinishness", "swinish"},
		{"swipes", "swipe"},
		{"swirling", "swirl"},
		{"switch", "switch"},
		{"switches", "switch"},
		{"switzerland", "switzerland"},
		{"swollen", "swollen"},
		{"swoln", "swoln"},
		{"swoon", "swoon"},
		{"swooned", "swoon"},
		{"swooning", "swoon"},
		{"swoop", "swoop"},
		{"swooped", "swoop"},
		{"sword", "sword"},
		{"swords", "sword"},
		{"swordsman", "swordsman"},
		{"swordsmanship", "swordsmanship"},
		{"swordsmen", "swordsmen"},
		{"swore", "swore"},
		{"sworn", "sworn"},
		{"swosser", "swosser"},
		{"swung", "swung"},
		{"sycophancy", "sycoph"},
		{"sydney", "sydney"},
		{"syenite", "syenit"},
		{"syenitic", "syenit"},
		{"syllable", "syllabl"},
		{"syllogism", "syllog"},
		{"sylph", "sylph"},
		{"symbol", "symbol"},
		{"symbolic", "symbol"},
		{"symbolism", "symbol"},
		{"symbols", "symbol"},
		{"symes", "syme"},
		{"symmetrical", "symmetr"},
		{"symmetrically", "symmetr"},
		{"symmetry", "symmetri"},
		{"symond", "symond"},
		{"symonds", "symond"},
		{"sympathetic", "sympathet"},
		{"sympathetically", "sympathet"},
		{"sympathies", "sympathi"},
		{"sympathise", "sympathis"},
		{"sympathised", "sympathis"},
		{"sympathising", "sympathis"},
		{"sympathize", "sympath"},
		{"sympathized", "sympath"},
		{"sympathizers", "sympath"},
		{"sympathizing", "sympath"},
		{"sympathy", "sympathi"},
		{"symptom", "symptom"},
		{"symptomatic", "symptomat"},
		{"symptoms", "symptom"},
		{"synetheres", "synether"},
		{"synod", "synod"},
		{"synonymous", "synonym"},
		{"syria", "syria"},
		{"syriac", "syriac"},
		{"syrphus", "syrphus"},
		{"system", "system"},
		{"systematic", "systemat"},
		{"systems", "system"},
		{"t", "t"},
		{"ta", "ta"},
		{"tabanus", "tabanus"},
		{"tabby", "tabbi"},
		{"table", "tabl"},
		{"tableau", "tableau"},
		{"tablecloth", "tablecloth"},
		{"tablecloths", "tablecloth"},
		{"tables", "tabl"},
		{"tabooed", "taboo"},
		{"tabor", "tabor"},
		{"tacit", "tacit"},
		{"tacitly", "tacit"},
		{"taciturn", "taciturn"},
		{"taciturnity", "taciturn"},
		{"tack", "tack"},
		{"tacking", "tack"},
		{"tackle", "tackl"},
		{"tacks", "tack"},
		{"tacna", "tacna"},
		{"tact", "tact"},
		{"tactics", "tactic"},
		{"tags", "tag"},
		{"tagua", "tagua"},
		{"tahiti", "tahiti"},
		{"tahitian", "tahitian"},
		{"tahitians", "tahitian"},
		{"tail", "tail"},
		{"tailed", "tail"},
		{"tailor", "tailor"},
		{"tailors", "tailor"},
		{"tails", "tail"},
		{"tain", "tain"},
		{"taint", "taint"},
		{"tainted", "taint"},
		{"tainting", "taint"},
		{"taints", "taint"},
		{"tak", "tak"},
		{"take", "take"},
		{"taken", "taken"},
		{"taker", "taker"},
		{"takes", "take"},
		{"taketh", "taketh"},
		{"taking", "take"},
		{"takken", "takken"},
		{"takkin", "takkin"},
		{"talbot", "talbot"},
		{"talcahuano", "talcahuano"},
		{"tale", "tale"},
		{"talent", "talent"},
		{"talented", "talent"},
		{"talents", "talent"},
		{"tales", "tale"},
		{"talguen", "talguen"},
		{"talisman", "talisman"},
		{"talk", "talk"},
		{"talkative", "talkat"},
		{"talked", "talk"},
		{"talker", "talker"},
		{"talkers", "talker"},
		{"talkin", "talkin"},
		{"talking", "talk"},
		{"talks", "talk"},
		{"tall", "tall"},
		{"taller", "taller"},
		{"tallest", "tallest"},
		{"tallied", "talli"},
		{"tallow", "tallow"},
		{"tally", "talli"},
		{"talus", "talus"},
		{"tam", "tam"},
		{"tambillos", "tambillo"},
		{"tambour", "tambour"},
		{"tambourine", "tambourin"},
		{"tame", "tame"},
		{"tamed", "tame"},
		{"tamely", "tame"},
		{"tameness", "tame"},
		{"tamer", "tamer"},
		{"taming", "tame"},
		{"tamper", "tamper"},
		{"tampered", "tamper"},
		{"tampering", "tamper"},
		{"tampers", "tamper"},
		{"tan", "tan"},
		{"tandeel", "tandeel"},
		{"tangible", "tangibl"},
		{"tangle", "tangl"},
		{"tangled", "tangl"},
		{"tankard", "tankard"},
		{"tanks", "tank"},
		{"tanned", "tan"},
		{"tanqui", "tanqui"},
		{"tantalisation", "tantalis"},
		{"tantalised", "tantalis"},
		{"tantalising", "tantalis"},
		{"tantalizing", "tantal"},
		{"tantamount", "tantamount"},
		{"tantrums", "tantrum"},
		{"tap", "tap"},
		{"tapacolo", "tapacolo"},
		{"tapalguen", "tapalguen"},
		{"tape", "tape"},
		{"taper", "taper"},
		{"tapering", "taper"},
		{"tapers", "taper"},
		{"tapes", "tape"},
		{"tapir", "tapir"},
		{"tapirs", "tapir"},
		{"tapis", "tapi"},
		{"tapn", "tapn"},
		{"tapped", "tap"},
		{"tapping", "tap"},
		{"taps", "tap"},
		{"tapster", "tapster"},
		{"taradiddle", "taradiddl"},
		{"tardily", "tardili"},
		{"tardiness", "tardi"},
		{"tardy", "tardi"},
		{"tares", "tare"},
		{"target", "target"},
		{"targets", "target"},
		{"tarn", "tarn"},
		{"tarnii", "tarnii"},
		{"tarnish", "tarnish"},
		{"tarnished", "tarnish"},
		{"tarpaulins", "tarpaulin"},
		{"tarradiddles", "tarradiddl"},
		{"tarred", "tar"},
		{"tarry", "tarri"},
		{"tart", "tart"},
		{"tartan", "tartan"},
		{"tartar", "tartar"},
		{"tartary", "tartari"},
		{"tartly", "tart"},
		{"tarts", "tart"},
		{"task", "task"},
		{"tasking", "task"},
		{"tasks", "task"},
		{"tasman", "tasman"},
		{"tasmania", "tasmania"},
		{"tassel", "tassel"},
		{"tasselled", "tassel"},
		{"tassels", "tassel"},
		{"tasso", "tasso"},
		{"taste", "tast"},
		{"tasted", "tast"},
		{"tasteful", "tast"},
		{"tastefully", "tast"},
		{"tasteless", "tasteless"},
		{"tastes", "tast"},
		{"tasting", "tast"},
		{"tat", "tat"},
		{"tata", "tata"},
		{"tattered", "tatter"},
		{"tatters", "tatter"},
		{"tattoo", "tattoo"},
		{"tattooed", "tattoo"},
		{"tattooing", "tattoo"},
		{"taught", "taught"},
		{"taunt", "taunt"},
		{"taunted", "taunt"},
		{"taunting", "taunt"},
		{"taunto", "taunto"},
		{"taunton", "taunton"},
		{"taunts", "taunt"},
		{"tavern", "tavern"},
		{"taverns", "tavern"},
		{"tawdry", "tawdri"},
		{"tawny", "tawni"},
		{"tax", "tax"},
		{"taxation", "taxat"},
		{"taxed", "tax"},
		{"taxes", "tax"},
		{"taylor", "taylor"},
		{"tbe", "tbe"},
		{"tchebarov", "tchebarov"},
		{"te", "te"},
		{"tea", "tea"},
		{"teach", "teach"},
		{"teacher", "teacher"},
		{"teachers", "teacher"},
		{"teaches", "teach"},
		{"teaching", "teach"},
		{"teachings", "teach"},
		{"teacups", "teacup"},
		{"teak", "teak"},
		{"team", "team"},
		{"teapot", "teapot"},
		{"tear", "tear"},
		{"teardrop", "teardrop"},
		{"tearful", "tear"},
		{"tearfully", "tear"},
		{"tearing", "tear"},
		{"tearless", "tearless"},
		{"tears", "tear"},
		{"tease", "teas"},
		{"teased", "teas"},
		{"teasing", "teas"},
		{"teaspoon", "teaspoon"},
		{"teaspoons", "teaspoon"},
		{"teatime", "teatim"},
		{"technicalities", "technic"},
		{"tedious", "tedious"},
		{"tediousness", "tedious"},
		{"tedium", "tedium"},
		{"tee", "tee"},
		{"teel", "teel"},
		{"teeming", "teem"},
		{"teems", "teem"},
		{"teens", "teen"},
		{"teeth", "teeth"},
		{"tehuelches", "tehuelch"},
		{"tekenika", "tekenika"},
		{"telegram", "telegram"},
		{"telegrams", "telegram"},
		{"telegraph", "telegraph"},
		{"telegraphed", "telegraph"},
		{"telegraphic", "telegraph"},
		{"telegraphing", "telegraph"},
		{"telemachus", "telemachus"},
		{"telephoridae", "telephorida"},
		{"telescope", "telescop"},
		{"telescopes", "telescop"},
		{"telescopic", "telescop"},
		{"tell", "tell"},
		{"tellee", "telle"},
		{"teller", "teller"},
		{"telling", "tell"},
		{"tells", "tell"},
		{"temminckii", "temminckii"},
		{"temp", "temp"},
		{"temper", "temper"},
		{"temperament", "tempera"},
		{"temperaments", "tempera"},
		{"temperance", "temper"},
		{"temperate", "temper"},
		{"temperature", "temperatur"},
		{"tempered", "temper"},
		{"tempers", "temper"},
		{"tempest", "tempest"},
		{"tempestuous", "tempestu"},
		{"temple", "templ"},
		{"temples", "templ"},
		{"temporal", "tempor"},
		{"temporary", "temporari"},
		{"tempt", "tempt"},
		{"temptation", "temptat"},
		{"temptations", "temptat"},
		{"tempted", "tempt"},
		{"tempter", "tempter"},
		{"tempting", "tempt"},
		{"tempts", "tempt"},
		{"ten", "ten"},
		{"tenacious", "tenaci"},
		{"tenaciously", "tenaci"},
		{"tenacity", "tenac"},
		{"tenant", "tenant"},
		{"tenanted", "tenant"},
		{"tenantry", "tenantri"},
		{"tenants", "tenant"},
		{"tend", "tend"},
		{"tended", "tend"},
		{"tendencies", "tendenc"},
		{"tendency", "tendenc"},
		{"tender", "tender"},
		{"tendered", "tender"},
		{"tenderer", "tender"},
		{"tenderest", "tenderest"},
		{"tendering", "tender"},
		{"tenderly", "tender"},
		{"tenderness", "tender"},
		{"tending", "tend"},
		{"tendinous", "tendin"},
		{"tendon", "tendon"},
		{"tends", "tend"},
		{"tenement", "tenement"},
		{"tenements", "tenement"},
		{"teneriffe", "teneriff"},
		{"tenez", "tenez"},
		{"tenfold", "tenfold"},
		{"tennyson", "tennyson"},
		{"tenor", "tenor"},
		{"tens", "ten"},
		{"tense", "tens"},
		{"tension", "tension"},
		{"tensions", "tension"},
		{"tent", "tent"},
		{"tentacula", "tentacula"},
		{"tentative", "tentat"},
		{"tentatively", "tentat"},
		{"tenth", "tenth"},
		{"tenths", "tenth"},
		{"tents", "tent"},
		{"tenure", "tenur"},
		{"tenway", "tenway"},
		{"ter", "ter"},
		{"tercero", "tercero"},
		{"terebra", "terebra"},
		{"terebyeva", "terebyeva"},
		{"terewth", "terewth"},
		{"term", "term"},
		{"termagant", "termag"},
		{"termed", "term"},
		{"terminal", "termin"},
		{"terminate", "termin"},
		{"terminated", "termin"},
		{"terminates", "termin"},
		{"terminating", "termin"},
		{"termination", "termin"},
		{"terms", "term"},
		{"tern", "tern"},
		{"terns", "tern"},
		{"tero", "tero"},
		{"terra", "terra"},
		{"terrace", "terrac"},
		{"terraces", "terrac"},
		{"terres", "terr"},
		{"terrestrial", "terrestri"},
		{"terrible", "terribl"},
		{"terribly", "terribl"},
		{"terrier", "terrier"},
		{"terriers", "terrier"},
		{"terrific", "terrif"},
		{"terrified", "terrifi"},
		{"terrify", "terrifi"},
		{"terrifying", "terrifi"},
		{"territorial", "territori"},
		{"territories", "territori"},
		{"territory", "territori"},
		{"terror", "terror"},
		{"terrors", "terror"},
		{"terse", "ters"},
		{"terseness", "ters"},
		{"tertiary", "tertiari"},
		{"teru", "teru"},
		{"tesselated", "tessel"},
		{"test", "test"},
		{"testacea", "testacea"},
		{"testament", "testament"},
		{"testamentary", "testamentari"},
		{"testator", "testat"},
		{"tested", "test"},
		{"testified", "testifi"},
		{"testifies", "testifi"},
		{"testifled", "testifl"},
		{"testify", "testifi"},
		{"testifying", "testifi"},
		{"testily", "testili"},
		{"testimonial", "testimoni"},
		{"testimony", "testimoni"},
		{"testiness", "testi"},
		{"tests", "test"},
		{"testudo", "testudo"},
		{"testy", "testi"},
		{"tete", "tete"},
		{"tetes", "tete"},
		{"teutons", "teuton"},
		{"tew", "tew"},
		{"text", "text"},
		{"texture", "textur"},
		{"tfoo", "tfoo"},
		{"th", "th"},
		{"tha", "tha"},
		{"thames", "thame"},
		{"than", "than"},
		{"thank", "thank"},
		{"thanked", "thank"},
		{"thankee", "thanke"},
		{"thankful", "thank"},
		{"thankfully", "thank"},
		{"thankfulness", "thank"},
		{"thanking", "thank"},
		{"thankless", "thankless"},
		{"thanks", "thank"},
		{"thanksgiving", "thanksgiv"},
		{"thanksgivings", "thanksgiv"},
		{"thanyou", "thanyou"},
		{"that", "that"},
		{"thatch", "thatch"},
		{"thatched", "thatch"},
		{"thavies", "thavi"},
		{"thaw", "thaw"},
		{"thawed", "thaw"},
		{"thawing", "thaw"},
		{"the", "the"},
		{"theatre", "theatr"},
		{"theatres", "theatr"},
		{"theatrical", "theatric"},
		{"theatrically", "theatric"},
		{"theatricals", "theatric"},
		{"theayter", "theayter"},
		{"thee", "thee"},
		{"theer", "theer"},
		{"theeself", "theeself"},
		{"theft", "theft"},
		{"thei", "thei"},
		{"theils", "theil"},
		{"their", "their"},
		{"theirs", "their"},
		{"theirselves", "theirselv"},
		{"them", "them"},
		{"theme", "theme"},
		{"themes", "theme"},
		{"themselves", "themselv"},
		{"then", "then"},
		{"thence", "thenc"},
		{"thenceforth", "thenceforth"},
		{"theodolite", "theodolit"},
		{"theodora", "theodora"},
		{"theodoras", "theodora"},
		{"theodore", "theodor"},
		{"theoretical", "theoret"},
		{"theoretically", "theoret"},
		{"theorie", "theori"},
		{"theories", "theori"},
		{"theorize", "theoriz"},
		{"theory", "theori"},
		{"ther", "ther"},
		{"there", "there"},
		{"thereabout", "thereabout"},
		{"thereabouts", "thereabout"},
		{"thereafter", "thereaft"},
		{"thereby", "therebi"},
		{"therefore", "therefor"},
		{"therefrom", "therefrom"},
		{"therein", "therein"},
		{"thereof", "thereof"},
		{"thereon", "thereon"},
		{"theresa", "theresa"},
		{"thereto", "thereto"},
		{"thereunto", "thereunto"},
		{"thereupon", "thereupon"},
		{"therewith", "therewith"},
		{"theridion", "theridion"},
		{"theristicus", "theristicus"},
		{"thermometer", "thermomet"},
		{"thes", "thes"},
		{"these", "these"},
		{"they", "they"},
		{"thi", "thi"},
		{"thick", "thick"},
		{"thicken", "thicken"},
		{"thickened", "thicken"},
		{"thickening", "thicken"},
		{"thicker", "thicker"},
		{"thickest", "thickest"},
		{"thicket", "thicket"},
		{"thickets", "thicket"},
		{"thickly", "thick"},
		{"thickness", "thick"},
		{"thief", "thief"},
		{"thier", "thier"},
		{"thieved", "thiev"},
		{"thieves", "thiev"},
		{"thigh", "thigh"},
		{"thighs", "thigh"},
		{"thimble", "thimbl"},
		{"thin", "thin"},
		{"thine", "thine"},
		{"thing", "thing"},
		{"things", "thing"},
		{"think", "think"},
		{"thinkable", "thinkabl"},
		{"thinker", "thinker"},
		{"thinkin", "thinkin"},
		{"thinking", "think"},
		{"thinks", "think"},
		{"thinly", "thin"},
		{"thinned", "thin"},
		{"thinner", "thinner"},
		{"thinness", "thin"},
		{"thinning", "thin"},
		{"thins", "thin"},
		{"third", "third"},
		{"thirdly", "third"},
		{"thirds", "third"},
		{"thirst", "thirst"},
		{"thirstier", "thirstier"},
		{"thirsting", "thirst"},
		{"thirsty", "thirsti"},
		{"thirteen", "thirteen"},
		{"thirteenth", "thirteenth"},
		{"thirtieth", "thirtieth"},
		{"thirty", "thirti"},
		{"this", "this"},
		{"thistle", "thistl"},
		{"thistles", "thistl"},
		{"thither", "thither"},
		{"tho", "tho"},
		{"thomas", "thoma"},
		{"thong", "thong"},
		{"thongs", "thong"},
		{"thorax", "thorax"},
		{"thorn", "thorn"},
		{"thorns", "thorn"},
		{"thorny", "thorni"},
		{"thorough", "thorough"},
		{"thoroughbred", "thoroughbr"},
		{"thoroughfare", "thoroughfar"},
		{"thoroughfares", "thoroughfar"},
		{"thoroughgoing", "thoroughgo"},
		{"thoroughly", "thorough"},
		{"those", "those"},
		{"thot", "thot"},
		{"thou", "thou"},
		{"though", "though"},
		{"thought", "thought"},
		{"thoughtful", "thought"},
		{"thoughtfully", "thought"},
		{"thoughtfulness", "thought"},
		{"thoughtless", "thoughtless"},
		{"thoughtlessness", "thoughtless"},
		{"thoughts", "thought"},
		{"thoughy", "thoughi"},
		{"thousand", "thousand"},
		{"thousandfold", "thousandfold"},
		{"thousands", "thousand"},
		{"thousandth", "thousandth"},
		{"thousandths", "thousandth"},
		{"thousing", "thous"},
		{"thout", "thout"},
		{"thraldom", "thraldom"},
		{"thrash", "thrash"},
		{"thrashed", "thrash"},
		{"thrashing", "thrash"},
		{"thre", "thre"},
		{"thread", "thread"},
		{"threadbare", "threadbar"},
		{"threaded", "thread"},
		{"threading", "thread"},
		{"threadneedle", "threadneedl"},
		{"threads", "thread"},
		{"threat", "threat"},
		{"threaten", "threaten"},
		{"threatened", "threaten"},
		{"threatening", "threaten"},
		{"threatenings", "threaten"},
		{"threatens", "threaten"},
		{"threats", "threat"},
		{"three", "three"},
		{"threepence", "threepenc"},
		{"threes", "three"},
		{"threescore", "threescor"},
		{"threshed", "thresh"},
		{"threshold", "threshold"},
		{"threw", "threw"},
		{"thrice", "thrice"},
		{"thried", "thri"},
		{"thrift", "thrift"},
		{"thriftless", "thriftless"},
		{"thrill", "thrill"},
		{"thrilled", "thrill"},
		{"thrilling", "thrill"},
		{"thrills", "thrill"},
		{"thrive", "thrive"},
		{"thriven", "thriven"},
		{"thrives", "thrive"},
		{"thriving", "thrive"},
		{"throat", "throat"},
		{"throats", "throat"},
		{"throb", "throb"},
		{"throbbed", "throb"},
		{"throbbing", "throb"},
		{"throne", "throne"},
		{"throng", "throng"},
		{"thronged", "throng"},
		{"thronging", "throng"},
		{"throngs", "throng"},
		{"throttled", "throttl"},
		{"throug", "throug"},
		{"through", "through"},
		{"throughout", "throughout"},
		{"throve", "throve"},
		{"throw", "throw"},
		{"throwed", "throw"},
		{"throwing", "throw"},
		{"thrown", "thrown"},
		{"throws", "throw"},
		{"thrush", "thrush"},
		{"thrushes", "thrush"},
		{"thrust", "thrust"},
		{"thrusting", "thrust"},
		{"thrusts", "thrust"},
		{"thrveydrop", "thrveydrop"},
		{"thu", "thu"},
		{"thud", "thud"},
		{"thuds", "thud"},
		{"thumb", "thumb"},
		{"thumbed", "thumb"},
		{"thumbs", "thumb"},
		{"thump", "thump"},
		{"thumped", "thump"},
		{"thumping", "thump"},
		{"thumps", "thump"},
		{"thunder", "thunder"},
		{"thunderbolt", "thunderbolt"},
		{"thunderclap", "thunderclap"},
		{"thundered", "thunder"},
		{"thundering", "thunder"},
		{"thunderings", "thunder"},
		{"thunderstorm", "thunderstorm"},
		{"thunderstorms", "thunderstorm"},
		{"thunderstruck", "thunderstruck"},
		{"thundery", "thunderi"},
		{"thursday", "thursday"},
		{"thursdays", "thursday"},
		{"thus", "thus"},
		{"thwart", "thwart"},
		{"thwarted", "thwart"},
		{"thwarting", "thwart"},
		{"thy", "thi"},
		{"thyself", "thyself"},
		{"ti", "ti"},
		{"tiaauru", "tiaauru"},
		{"tial", "tial"},
		{"tibby", "tibbi"},
		{"tibiae", "tibia"},
		{"tick", "tick"},
		{"ticked", "tick"},
		{"ticket", "ticket"},
		{"ticketed", "ticket"},
		{"tickets", "ticket"},
		{"ticking", "tick"},
		{"tickings", "tick"},
		{"tickle", "tickl"},
		{"tickled", "tickl"},
		{"tickles", "tickl"},
		{"tickling", "tickl"},
		{"ticklish", "ticklish"},
		{"ticks", "tick"},
		{"tidal", "tidal"},
		{"tiddler", "tiddler"},
		{"tide", "tide"},
		{"tides", "tide"},
		{"tidied", "tidi"},
		{"tidily", "tidili"},
		{"tidings", "tide"},
		{"tidy", "tidi"},
		{"tie", "tie"},
		{"tied", "tie"},
		{"tierra", "tierra"},
		{"tiers", "tier"},
		{"ties", "tie"},
		{"tiff", "tiff"},
		{"tiger", "tiger"},
		{"tigerish", "tigerish"},
		{"tigers", "tiger"},
		{"tight", "tight"},
		{"tighten", "tighten"},
		{"tightened", "tighten"},
		{"tighter", "tighter"},
		{"tightly", "tight"},
		{"tightness", "tight"},
		{"tights", "tight"},
		{"tigre", "tigr"},
		{"tigress", "tigress"},
		{"til", "til"},
		{"tilda", "tilda"},
		{"tile", "tile"},
		{"tiles", "tile"},
		{"tiliareus", "tiliareus"},
		{"till", "till"},
		{"tillage", "tillag"},
		{"tilled", "till"},
		{"tilly", "tilli"},
		{"tilted", "tilt"},
		{"tilting", "tilt"},
		{"tilts", "tilt"},
		{"tim", "tim"},
		{"timber", "timber"},
		{"timberry", "timberri"},
		{"timbers", "timber"},
		{"timbrel", "timbrel"},
		{"time", "time"},
		{"timed", "time"},
		{"timely", "time"},
		{"times", "time"},
		{"timid", "timid"},
		{"timidity", "timid"},
		{"timidly", "timid"},
		{"timorous", "timor"},
		{"timorously", "timor"},
		{"timothy", "timothi"},
		{"timour", "timour"},
		{"tin", "tin"},
		{"tinae", "tina"},
		{"tinamus", "tinamus"},
		{"tinder", "tinder"},
		{"tinderidica", "tinderidica"},
		{"tinge", "ting"},
		{"tinged", "ting"},
		{"tingle", "tingl"},
		{"tingled", "tingl"},
		{"tingling", "tingl"},
		{"tiniest", "tiniest"},
		{"tinker", "tinker"},
		{"tinkers", "tinker"},
		{"tinkle", "tinkl"},
		{"tinkled", "tinkl"},
		{"tinkling", "tinkl"},
		{"tinochorus", "tinochorus"},
		{"tint", "tint"},
		{"tinted", "tint"},
		{"tinting", "tint"},
		{"tints", "tint"},
		{"tiny", "tini"},
		{"tion", "tion"},
		{"tip", "tip"},
		{"tipped", "tip"},
		{"tipperary", "tipperari"},
		{"tippets", "tippet"},
		{"tippy", "tippi"},
		{"tips", "tip"},
		{"tipsily", "tipsili"},
		{"tipslark", "tipslark"},
		{"tipsy", "tipsi"},
		{"tiptoe", "tipto"},
		{"tiptop", "tiptop"},
		{"tirade", "tirad"},
		{"tire", "tire"},
		{"tired", "tire"},
		{"tires", "tire"},
		{"tiresome", "tiresom"},
		{"tiring", "tire"},
		{"tis", "tis"},
		{"tissue", "tissu"},
		{"tit", "tit"},
		{"tithe", "tith"},
		{"titian", "titian"},
		{"titlark", "titlark"},
		{"title", "titl"},
		{"titled", "titl"},
		{"titles", "titl"},
		{"titmouse", "titmous"},
		{"tittered", "titter"},
		{"tittering", "titter"},
		{"titular", "titular"},
		{"tiv", "tiv"},
		{"tix", "tix"},
		{"tle", "tle"},
		{"to", "to"},
		{"toad", "toad"},
		{"toads", "toad"},
		{"toast", "toast"},
		{"toasted", "toast"},
		{"toasting", "toast"},
		{"tobacco", "tobacco"},
		{"tobacconist", "tobacconist"},
		{"tockahoopo", "tockahoopo"},
		{"today", "today"},
		{"toddy", "toddi"},
		{"toe", "toe"},
		{"toes", "toe"},
		{"together", "togeth"},
		{"togezzer", "togezz"},
		{"toight", "toight"},
		{"toil", "toil"},
		{"toiled", "toil"},
		{"toiler", "toiler"},
		{"toilet", "toilet"},
		{"toilette", "toilett"},
		{"toiling", "toil"},
		{"toils", "toil"},
		{"toilsome", "toilsom"},
		{"toity", "toiti"},
		{"token", "token"},
		{"tokens", "token"},
		{"tol", "tol"},
		{"told", "told"},
		{"toldos", "toldo"},
		{"tolerable", "toler"},
		{"tolerably", "toler"},
		{"tolerate", "toler"},
		{"tolerated", "toler"},
		{"toleration", "toler"},
		{"toll", "toll"},
		{"tolled", "toll"},
		{"tolling", "toll"},
		{"tolstyakov", "tolstyakov"},
		{"tom", "tom"},
		{"tomahawk", "tomahawk"},
		{"tomahawked", "tomahawk"},
		{"tomb", "tomb"},
		{"tombs", "tomb"},
		{"tombstone", "tombston"},
		{"tombstones", "tombston"},
		{"tomkins", "tomkin"},
		{"tommy", "tommi"},
		{"tomorrow", "tomorrow"},
		{"ton", "ton"},
		{"tone", "tone"},
		{"toned", "tone"},
		{"tones", "tone"},
		{"tongs", "tong"},
		{"tongue", "tongu"},
		{"tongued", "tongu"},
		{"tongues", "tongu"},
		{"tonight", "tonight"},
		{"tons", "ton"},
		{"tony", "toni"},
		{"too", "too"},
		{"toogather", "toogath"},
		{"took", "took"},
		{"tool", "tool"},
		{"tools", "tool"},
		{"toomultuous", "toomultu"},
		{"toon", "toon"},
		{"tooth", "tooth"},
		{"toothed", "tooth"},
		{"toothful", "tooth"},
		{"toothpick", "toothpick"},
		{"toothpicks", "toothpick"},
		{"tooting", "toot"},
		{"top", "top"},
		{"topic", "topic"},
		{"topics", "topic"},
		{"topped", "top"},
		{"topping", "top"},
		{"toppling", "toppl"},
		{"tops", "top"},
		{"topsail", "topsail"},
		{"topsel", "topsel"},
		{"topsy", "topsi"},
		{"tor", "tor"},
		{"torches", "torch"},
		{"torchlight", "torchlight"},
		{"tore", "tore"},
		{"torment", "torment"},
		{"tormented", "torment"},
		{"tormenting", "torment"},
		{"tormentor", "tormentor"},
		{"tormentors", "tormentor"},
		{"torments", "torment"},
		{"torn", "torn"},
		{"torpid", "torpid"},
		{"torpor", "torpor"},
		{"torrent", "torrent"},
		{"torrents", "torrent"},
		{"torrid", "torrid"},
		{"tortershell", "tortershel"},
		{"tortoise", "tortois"},
		{"tortoises", "tortois"},
		{"tortuous", "tortuous"},
		{"torture", "tortur"},
		{"tortured", "tortur"},
		{"torturer", "tortur"},
		{"tortures", "tortur"},
		{"torturing", "tortur"},
		{"tory", "tori"},
		{"toryism", "toryism"},
		{"toss", "toss"},
		{"tossed", "toss"},
		{"tosses", "toss"},
		{"tossing", "toss"},
		{"tossings", "toss"},
		{"total", "total"},
		{"totally", "total"},
		{"totanus", "totanus"},
		{"tottenham", "tottenham"},
		{"tottered", "totter"},
		{"tottering", "totter"},
		{"totum", "totum"},
		{"toucans", "toucan"},
		{"touch", "touch"},
		{"touched", "touch"},
		{"toucher", "toucher"},
		{"touches", "touch"},
		{"touching", "touch"},
		{"touchingly", "touch"},
		{"touchstone", "touchston"},
		{"touchwood", "touchwood"},
		{"tough", "tough"},
		{"tougher", "tougher"},
		{"toughey", "toughey"},
		{"toughness", "tough"},
		{"toughy", "toughi"},
		{"toulon", "toulon"},
		{"tour", "tour"},
		{"tourists", "tourist"},
		{"tours", "tour"},
		{"tout", "tout"},
		{"toutes", "tout"},
		{"touts", "tout"},
		{"toward", "toward"},
		{"towards", "toward"},
		{"towed", "tow"},
		{"towel", "towel"},
		{"towelling", "towel"},
		{"towels", "towel"},
		{"tower", "tower"},
		{"towered", "tower"},
		{"towering", "tower"},
		{"towers", "tower"},
		{"town", "town"},
		{"towns", "town"},
		{"township", "township"},
		{"townsman", "townsman"},
		{"townsmen", "townsmen"},
		{"townspeople", "townspeopl"},
		{"toxodon", "toxodon"},
		{"toy", "toy"},
		{"toyed", "toy"},
		{"toying", "toy"},
		{"toys", "toy"},
		{"trace", "trace"},
		{"traceable", "traceabl"},
		{"traced", "trace"},
		{"tracery", "traceri"},
		{"traces", "trace"},
		{"tracing", "trace"},
		{"track", "track"},
		{"tracked", "track"},
		{"tracking", "track"},
		{"trackless", "trackless"},
		{"tracks", "track"},
		{"tract", "tract"},
		{"tractable", "tractabl"},
		{"tracts", "tract"},
		{"trade", "trade"},
		{"trader", "trader"},
		{"traders", "trader"},
		{"trades", "trade"},
		{"tradesfolk", "tradesfolk"},
		{"tradesman", "tradesman"},
		{"tradesmen", "tradesmen"},
		{"tradespeople", "tradespeopl"},
		{"trading", "trade"},
		{"tradition", "tradit"},
		{"traditional", "tradit"},
		{"traditionally", "tradit"},
		{"traditions", "tradit"},
		{"traducer", "traduc"},
		{"traducers", "traduc"},
		{"trafalgar", "trafalgar"},
		{"traffic", "traffic"},
		{"tragedian", "tragedian"},
		{"tragedies", "tragedi"},
		{"tragedy", "tragedi"},
		{"tragic", "tragic"},
		{"tragical", "tragic"},
		{"trail", "trail"},
		{"trailed", "trail"},
		{"trailing", "trail"},
		{"trails", "trail"},
		{"train", "train"},
		{"trained", "train"},
		{"trainer", "trainer"},
		{"training", "train"},
		{"trains", "train"},
		{"trait", "trait"},
		{"traitent", "traitent"},
		{"traitor", "traitor"},
		{"traitorous", "traitor"},
		{"traitors", "traitor"},
		{"traits", "trait"},
		{"trammels", "trammel"},
		{"tramp", "tramp"},
		{"tramped", "tramp"},
		{"tramping", "tramp"},
		{"trample", "trampl"},
		{"trampled", "trampl"},
		{"trampling", "trampl"},
		{"tramps", "tramp"},
		{"trance", "tranc"},
		{"tranquil", "tranquil"},
		{"tranquillity", "tranquil"},
		{"tranquillize", "tranquil"},
		{"tranquillized", "tranquil"},
		{"tranquilly", "tranquilli"},
		{"trans", "tran"},
		{"transact", "transact"},
		{"transacted", "transact"},
		{"transaction", "transact"},
		{"transactions", "transact"},
		{"transcendent", "transcend"},
		{"transfer", "transfer"},
		{"transferred", "transfer"},
		{"transferring", "transfer"},
		{"transfers", "transfer"},
		{"transfigured", "transfigur"},
		{"transfixed", "transfix"},
		{"transform", "transform"},
		{"transformation", "transform"},
		{"transformed", "transform"},
		{"transgress", "transgress"},
		{"transgressed", "transgress"},
		{"transgressing", "transgress"},
		{"transgression", "transgress"},
		{"transient", "transient"},
		{"transit", "transit"},
		{"transition", "transit"},
		{"transitory", "transitori"},
		{"translate", "translat"},
		{"translated", "translat"},
		{"translating", "translat"},
		{"translation", "translat"},
		{"translator", "translat"},
		{"translucency", "transluc"},
		{"transmission", "transmiss"},
		{"transmits", "transmit"},
		{"transmitted", "transmit"},
		{"transmutes", "transmut"},
		{"transparency", "transpar"},
		{"transparenfly", "transparenfli"},
		{"transparent", "transpar"},
		{"transpire", "transpir"},
		{"transpired", "transpir"},
		{"transplant", "transplant"},
		{"transplanted", "transplant"},
		{"transplanting", "transplant"},
		{"transport", "transport"},
		{"transportable", "transport"},
		{"transportal", "transport"},
		{"transportation", "transport"},
		{"transported", "transport"},
		{"transporting", "transport"},
		{"transports", "transport"},
		{"transposing", "transpos"},
		{"transverse", "transvers"},
		{"transversely", "transvers"},
		{"trap", "trap"},
		{"trappe", "trapp"},
		{"trapped", "trap"},
		{"trappings", "trap"},
		{"traps", "trap"},
		{"trash", "trash"},
		{"trashy", "trashi"},
		{"travel", "travel"},
		{"travelers", "travel"},
		{"travelled", "travel"},
		{"traveller", "travel"},
		{"travellers", "travel"},
		{"travelling", "travel"},
		{"travels", "travel"},
		{"traverse", "travers"},
		{"traversed", "travers"},
		{"traversia", "traversia"},
		{"traversing", "travers"},
		{"travertin", "travertin"},
		{"tray", "tray"},
		{"trays", "tray"},
		{"treaces", "treac"},
		{"treacherous", "treacher"},
		{"treachery", "treacheri"},
		{"treacle", "treacl"},
		{"treacled", "treacl"},
		{"tread", "tread"},
		{"treadin", "treadin"},
		{"treading", "tread"},
		{"treadmills", "treadmil"},
		{"treads", "tread"},
		{"treason", "treason"},
		{"treasur", "treasur"},
		{"treasure", "treasur"},
		{"treasured", "treasur"},
		{"treasures", "treasur"},
		{"treasuring", "treasur"},
		{"treasury", "treasuri"},
		{"treat", "treat"},
		{"treated", "treat"},
		{"treating", "treat"},
		{"treatise", "treatis"},
		{"treatises", "treatis"},
		{"treatment", "treatment"},
		{"treats", "treat"},
		{"treaty", "treati"},
		{"treble", "trebl"},
		{"trebled", "trebl"},
		{"tree", "tree"},
		{"trees", "tree"},
		{"trellis", "trelli"},
		{"trellised", "trellis"},
		{"tremble", "trembl"},
		{"trembled", "trembl"},
		{"trembles", "trembl"},
		{"trembling", "trembl"},
		{"tremblingly", "trembl"},
		{"tremblings", "trembl"},
		{"tremendous", "tremend"},
		{"tremendously", "tremend"},
		{"tremenjous", "tremenj"},
		{"tremor", "tremor"},
		{"tremors", "tremor"},
		{"tremulous", "tremul"},
		{"tremulously", "tremul"},
		{"trenchant", "trenchant"},
		{"trenched", "trench"},
		{"trenches", "trench"},
		{"trenching", "trench"},
		{"trenham", "trenham"},
		{"trepanned", "trepan"},
		{"trepidation", "trepid"},
		{"tres", "tres"},
		{"trespass", "trespass"},
		{"tress", "tress"},
		{"tresses", "tress"},
		{"trial", "trial"},
		{"trials", "trial"},
		{"triangle", "triangl"},
		{"triangular", "triangular"},
		{"triangularity", "triangular"},
		{"tribe", "tribe"},
		{"tribes", "tribe"},
		{"tribulation", "tribul"},
		{"tributaries", "tributari"},
		{"tributary", "tributari"},
		{"tribute", "tribut"},
		{"trice", "trice"},
		{"trichodactylus", "trichodactylus"},
		{"trichodesmium", "trichodesmium"},
		{"trichomanes", "trichoman"},
		{"trick", "trick"},
		{"tricked", "trick"},
		{"trickery", "trickeri"},
		{"trickled", "trickl"},
		{"trickles", "trickl"},
		{"trickling", "trickl"},
		{"tricks", "trick"},
		{"tricksters", "trickster"},
		{"tried", "tri"},
		{"triermain", "triermain"},
		{"tries", "tri"},
		{"trifasciatus", "trifasciatus"},
		{"trifle", "trifl"},
		{"trifled", "trifl"},
		{"trifles", "trifl"},
		{"trifling", "trifl"},
		{"trigger", "trigger"},
		{"trigonocephalus", "trigonocephalus"},
		{"trigonometry", "trigonometri"},
		{"trigonomical", "trigonom"},
		{"trigonomics", "trigonom"},
		{"trilled", "trill"},
		{"trilling", "trill"},
		{"trim", "trim"},
		{"trimly", "trim"},
		{"trimmed", "trim"},
		{"trimmers", "trimmer"},
		{"trimming", "trim"},
		{"trimmings", "trim"},
		{"trinity", "triniti"},
		{"trinket", "trinket"},
		{"trinkets", "trinket"},
		{"trio", "trio"},
		{"trip", "trip"},
		{"tripod", "tripod"},
		{"tripods", "tripod"},
		{"tripped", "trip"},
		{"tripping", "trip"},
		{"trippingly", "trip"},
		{"tristan", "tristan"},
		{"tristram", "tristram"},
		{"triturated", "tritur"},
		{"triumph", "triumph"},
		{"triumphal", "triumphal"},
		{"triumphant", "triumphant"},
		{"triumphantly", "triumphant"},
		{"triumphed", "triumph"},
		{"triumphing", "triumph"},
		{"triumphs", "triumph"},
		{"triumvirate", "triumvir"},
		{"trivets", "trivet"},
		{"trivial", "trivial"},
		{"trivialities", "trivial"},
		{"trochi", "trochi"},
		{"trochilus", "trochilus"},
		{"trochus", "trochus"},
		{"trod", "trod"},
		{"trodden", "trodden"},
		{"troifling", "troifl"},
		{"trois", "troi"},
		{"trolling", "troll"},
		{"trollope", "trollop"},
		{"troop", "troop"},
		{"trooped", "troop"},
		{"trooper", "trooper"},
		{"troops", "troop"},
		{"trophies", "trophi"},
		{"trophy", "trophi"},
		{"tropic", "tropic"},
		{"tropical", "tropic"},
		{"tropics", "tropic"},
		{"tropillas", "tropilla"},
		{"trot", "trot"},
		{"trotted", "trot"},
		{"trotting", "trot"},
		{"trotty", "trotti"},
		{"trouble", "troubl"},
		{"troubled", "troubl"},
		{"troubles", "troubl"},
		{"troublesome", "troublesom"},
		{"troubling", "troubl"},
		{"troublous", "troublous"},
		{"troughs", "trough"},
		{"trouser", "trouser"},
		{"trousers", "trouser"},
		{"trousseau", "trousseau"},
		{"trout", "trout"},
		{"trouve", "trouv"},
		{"trowel", "trowel"},
		{"trowels", "trowel"},
		{"truant", "truant"},
		{"trudged", "trudg"},
		{"trudges", "trudg"},
		{"trudging", "trudg"},
		{"true", "true"},
		{"truer", "truer"},
		{"truest", "truest"},
		{"truly", "truli"},
		{"trump", "trump"},
		{"trumpery", "trumperi"},
		{"trumpet", "trumpet"},
		{"trumpeters", "trumpet"},
		{"trumpets", "trumpet"},
		{"trumps", "trump"},
		{"truncate", "truncat"},
		{"truncated", "truncat"},
		{"truncheon", "truncheon"},
		{"truncheons", "truncheon"},
		{"trunk", "trunk"},
		{"trunks", "trunk"},
		{"trusses", "truss"},
		{"trust", "trust"},
		{"trusted", "trust"},
		{"trustees", "truste"},
		{"trustful", "trust"},
		{"trustiest", "trustiest"},
		{"trusting", "trust"},
		{"trusts", "trust"},
		{"trustworthy", "trustworthi"},
		{"trusty", "trusti"},
		{"truth", "truth"},
		{"truthful", "truth"},
		{"truthlike", "truthlik"},
		{"truths", "truth"},
		{"try", "tri"},
		{"trying", "tri"},
		{"tryst", "tryst"},
		{"tsar", "tsar"},
		{"tschudi", "tschudi"},
		{"tsetup", "tsetup"},
		{"tsubmit", "tsubmit"},
		{"tub", "tub"},
		{"tube", "tube"},
		{"tubercles", "tubercl"},
		{"tuberculata", "tuberculata"},
		{"tubers", "tuber"},
		{"tubes", "tube"},
		{"tubs", "tub"},
		{"tuck", "tuck"},
		{"tucked", "tuck"},
		{"tucker", "tucker"},
		{"tuckered", "tucker"},
		{"tucking", "tuck"},
		{"tucks", "tuck"},
		{"tucuman", "tucuman"},
		{"tucutuco", "tucutuco"},
		{"tucutucos", "tucutuco"},
		{"tuesday", "tuesday"},
		{"tufaceous", "tufac"},
		{"tuff", "tuff"},
		{"tuft", "tuft"},
		{"tufted", "tuft"},
		{"tufts", "tuft"},
		{"tugged", "tug"},
		{"tugging", "tug"},
		{"tuition", "tuition"},
		{"tul", "tul"},
		{"tulip", "tulip"},
		{"tulkinghorn", "tulkinghorn"},
		{"tumble", "tumbl"},
		{"tumbled", "tumbl"},
		{"tumbler", "tumbler"},
		{"tumblers", "tumbler"},
		{"tumbles", "tumbl"},
		{"tumbling", "tumbl"},
		{"tumblings", "tumbl"},
		{"tumbrils", "tumbril"},
		{"tuming", "tume"},
		{"tumley", "tumley"},
		{"tumult", "tumult"},
		{"tumultuous", "tumultu"},
		{"tumultuously", "tumultu"},
		{"tunbridge", "tunbridg"},
		{"tune", "tune"},
		{"tunes", "tune"},
		{"tunic", "tunic"},
		{"tuning", "tune"},
		{"tunnel", "tunnel"},
		{"tunnels", "tunnel"},
		{"tupinieri", "tupinieri"},
		{"tupungato", "tupungato"},
		{"turban", "turban"},
		{"turbans", "turban"},
		{"turbid", "turbid"},
		{"turbo", "turbo"},
		{"turbulence", "turbul"},
		{"turbulent", "turbul"},
		{"turco", "turco"},
		{"tureen", "tureen"},
		{"turf", "turf"},
		{"turgenev", "turgenev"},
		{"turgid", "turgid"},
		{"turing", "ture"},
		{"turk", "turk"},
		{"turkey", "turkey"},
		{"turkish", "turkish"},
		{"turks", "turk"},
		{"turmoil", "turmoil"},
		{"turmoils", "turmoil"},
		{"turn", "turn"},
		{"turnbull", "turnbul"},
		{"turned", "turn"},
		{"turner", "turner"},
		{"turning", "turn"},
		{"turnings", "turn"},
		{"turnip", "turnip"},
		{"turnips", "turnip"},
		{"turnout", "turnout"},
		{"turnpike", "turnpik"},
		{"turns", "turn"},
		{"turnstile", "turnstil"},
		{"turpentining", "turpentin"},
		{"turpin", "turpin"},
		{"turret", "turret"},
		{"turreted", "turret"},
		{"turrets", "turret"},
		{"turtle", "turtl"},
		{"turtledoves", "turtledov"},
		{"turtles", "turtl"},
		{"turveydrop", "turveydrop"},
		{"turveydrops", "turveydrop"},
		{"turvy", "turvi"},
		{"tusks", "tusk"},
		{"tussocks", "tussock"},
		{"tut", "tut"},
		{"tutbury", "tutburi"},
		{"tutor", "tutor"},
		{"tw", "tw"},
		{"twain", "twain"},
		{"twang", "twang"},
		{"twas", "twas"},
		{"tweak", "tweak"},
		{"tweaking", "tweak"},
		{"twelfth", "twelfth"},
		{"twelve", "twelv"},
		{"twelvemonth", "twelvemonth"},
		{"twelvemonths", "twelvemonth"},
		{"twenties", "twenti"},
		{"twentieth", "twentieth"},
		{"twenty", "twenti"},
		{"twice", "twice"},
		{"twickenham", "twickenham"},
		{"twig", "twig"},
		{"twigs", "twig"},
		{"twilight", "twilight"},
		{"twin", "twin"},
		{"twine", "twine"},
		{"twined", "twine"},
		{"twinge", "twing"},
		{"twining", "twine"},
		{"twinkle", "twinkl"},
		{"twinkled", "twinkl"},
		{"twinkling", "twinkl"},
		{"twinklings", "twinkl"},
		{"twins", "twin"},
		{"twirl", "twirl"},
		{"twirled", "twirl"},
		{"twirling", "twirl"},
		{"twirls", "twirl"},
		{"twist", "twist"},
		{"twisted", "twist"},
		{"twisting", "twist"},
		{"twistings", "twist"},
		{"twists", "twist"},
		{"twitch", "twitch"},
		{"twitched", "twitch"},
		{"twitching", "twitch"},
		{"twitchings", "twitch"},
		{"twitted", "twit"},
		{"twitter", "twitter"},
		{"twittering", "twitter"},
		{"twixt", "twixt"},
		{"two", "two"},
		{"twofold", "twofold"},
		{"twolve", "twolv"},
		{"twonty", "twonti"},
		{"twopence", "twopenc"},
		{"twopenn", "twopenn"},
		{"twopenny", "twopenni"},
		{"twos", "twos"},
		{"twould", "twould"},
		{"ty", "ty"},
		{"tybalt", "tybalt"},
		{"tyerman", "tyerman"},
		{"tying", "tie"},
		{"tyler", "tyler"},
		{"tylerish", "tylerish"},
		{"type", "type"},
		{"types", "type"},
		{"typhus", "typhus"},
		{"typical", "typic"},
		{"tyrannical", "tyrann"},
		{"tyrannized", "tyrann"},
		{"tyrannus", "tyrannus"},
		{"tyranny", "tyranni"},
		{"tyrant", "tyrant"},
		{"tyrants", "tyrant"},
		{"tyrolese", "tyroles"},
		{"tyrone", "tyron"},
		{"u", "u"},
		{"ud", "ud"},
		{"ugh", "ugh"},
		{"uglier", "uglier"},
		{"ugliness", "ugli"},
		{"ugly", "ugli"},
		{"uji", "uji"},
		{"ulloa", "ulloa"},
		{"ulterior", "ulterior"},
		{"ultimate", "ultim"},
		{"ultimately", "ultim"},
		{"ultra", "ultra"},
		{"ulvae", "ulva"},
		{"um", "um"},
		{"umb", "umb"},
		{"umbilical", "umbil"},
		{"umbrageous", "umbrag"},
		{"umbrella", "umbrella"},
		{"umbrellas", "umbrella"},
		{"umsonst", "umsonst"},
		{"un", "un"},
		{"unabashed", "unabash"},
		{"unabated", "unab"},
		{"unable", "unabl"},
		{"unaccompanied", "unaccompani"},
		{"unaccountable", "unaccount"},
		{"unaccountably", "unaccount"},
		{"unaccustomed", "unaccustom"},
		{"unacknowledged", "unacknowledg"},
		{"unacquainted", "unacquaint"},
		{"unadorned", "unadorn"},
		{"unaffected", "unaffect"},
		{"unaffectedly", "unaffect"},
		{"unaided", "unaid"},
		{"unallowable", "unallow"},
		{"unalloyed", "unalloy"},
		{"unalluring", "unallur"},
		{"unaltered", "unalt"},
		{"unambitious", "unambiti"},
		{"unanimous", "unanim"},
		{"unanimously", "unanim"},
		{"unanswerable", "unanswer"},
		{"unanswered", "unansw"},
		{"unanue", "unanu"},
		{"unappeasable", "unappeas"},
		{"unappeased", "unappeas"},
		{"unapproachable", "unapproach"},
		{"unasked", "unask"},
		{"unassailable", "unassail"},
		{"unassisted", "unassist"},
		{"unassuming", "unassum"},
		{"unattached", "unattach"},
		{"unattainable", "unattain"},
		{"unattempted", "unattempt"},
		{"unavailing", "unavail"},
		{"unavailingly", "unavail"},
		{"unavoidable", "unavoid"},
		{"unavoidably", "unavoid"},
		{"unaware", "unawar"},
		{"unawares", "unawar"},
		{"unbear", "unbear"},
		{"unbearable", "unbear"},
		{"unbearably", "unbear"},
		{"unbecoming", "unbecom"},
		{"unbelieving", "unbeliev"},
		{"unbending", "unbend"},
		{"unbent", "unbent"},
		{"unbiassed", "unbiass"},
		{"unbidden", "unbidden"},
		{"unblemished", "unblemish"},
		{"unblotted", "unblot"},
		{"unblushing", "unblush"},
		{"unblushingly", "unblush"},
		{"unbolted", "unbolt"},
		{"unbonneted", "unbonnet"},
		{"unborn", "unborn"},
		{"unbound", "unbound"},
		{"unbounded", "unbound"},
		{"unbroken", "unbroken"},
		{"unbrushed", "unbrush"},
		{"unburdening", "unburden"},
		{"unburied", "unburi"},
		{"unbusiness", "unbusi"},
		{"unbuttoned", "unbutton"},
		{"uncalculating", "uncalcul"},
		{"uncalled", "uncal"},
		{"uncandid", "uncandid"},
		{"uncanny", "uncanni"},
		{"uncared", "uncar"},
		{"uncarried", "uncarri"},
		{"unceasing", "unceas"},
		{"unceasingly", "unceas"},
		{"uncensorious", "uncensori"},
		{"unceremonious", "unceremoni"},
		{"unceremoniously", "unceremoni"},
		{"uncertain", "uncertain"},
		{"uncertainly", "uncertain"},
		{"uncertainties", "uncertainti"},
		{"uncertainty", "uncertainti"},
		{"unchain", "unchain"},
		{"unchallengeable", "unchalleng"},
		{"unchangeable", "unchang"},
		{"unchangeably", "unchang"},
		{"unchanged", "unchang"},
		{"unchanging", "unchang"},
		{"uncharitable", "uncharit"},
		{"unchastened", "unchasten"},
		{"unchecked", "uncheck"},
		{"uncherished", "uncherish"},
		{"unchild", "unchild"},
		{"unchildish", "unchildish"},
		{"unchildlike", "unchildlik"},
		{"uncivil", "uncivil"},
		{"uncivilized", "uncivil"},
		{"unclaimed", "unclaim"},
		{"unclasp", "unclasp"},
		{"unclasped", "unclasp"},
		{"unclasping", "unclasp"},
		{"unclassified", "unclassifi"},
		{"uncle", "uncl"},
		{"unclean", "unclean"},
		{"uncleanliness", "uncleanli"},
		{"uncleanness", "unclean"},
		{"uncleared", "unclear"},
		{"uncles", "uncl"},
		{"unclose", "unclos"},
		{"unclouded", "uncloud"},
		{"uncoile", "uncoil"},
		{"uncoils", "uncoil"},
		{"uncomfortable", "uncomfort"},
		{"uncomfortably", "uncomfort"},
		{"uncommon", "uncommon"},
		{"uncommonly", "uncommon"},
		{"uncommunicative", "uncommun"},
		{"uncompanionable", "uncompanion"},
		{"uncomplaining", "uncomplain"},
		{"uncompleted", "uncomplet"},
		{"uncomplimentary", "uncomplimentari"},
		{"uncomprehended", "uncomprehend"},
		{"uncompressed", "uncompress"},
		{"uncompromising", "uncompromis"},
		{"unconcealed", "unconc"},
		{"unconcern", "unconcern"},
		{"unconcerned", "unconcern"},
		{"unconcernedly", "unconcern"},
		{"unconfinable", "unconfin"},
		{"unconfined", "unconfin"},
		{"uncongenial", "uncongeni"},
		{"unconnected", "unconnect"},
		{"unconquerable", "unconquer"},
		{"unconscious", "unconsci"},
		{"unconsciously", "unconsci"},
		{"unconsciousness", "unconsci"},
		{"unconsidered", "unconsid"},
		{"unconstitutional", "unconstitut"},
		{"unconstitutionally", "unconstitut"},
		{"unconstrained", "unconstrain"},
		{"uncontaminated", "uncontamin"},
		{"uncontradicted", "uncontradict"},
		{"uncontrollable", "uncontrol"},
		{"uncontrollably", "uncontrol"},
		{"uncontrolled", "uncontrol"},
		{"unconvinced", "unconvinc"},
		{"uncorked", "uncork"},
		{"uncourteous", "uncourt"},
		{"uncouth", "uncouth"},
		{"uncover", "uncov"},
		{"uncovered", "uncov"},
		{"uncritically", "uncrit"},
		{"uncrossed", "uncross"},
		{"uncrossing", "uncross"},
		{"unction", "unction"},
		{"uncultivated", "uncultiv"},
		{"uncut", "uncut"},
		{"und", "und"},
		{"undaunted", "undaunt"},
		{"undeceive", "undec"},
		{"undeceived", "undeceiv"},
		{"undeceiving", "undeceiv"},
		{"undecided", "undecid"},
		{"undefaced", "undefac"},
		{"undefinable", "undefin"},
		{"undefined", "undefin"},
		{"undeniable", "undeni"},
		{"under", "under"},
		{"underbred", "underbr"},
		{"undercliff", "undercliff"},
		{"underclothes", "undercloth"},
		{"underdone", "underdon"},
		{"underfoot", "underfoot"},
		{"undergo", "undergo"},
		{"undergoes", "undergo"},
		{"undergoing", "undergo"},
		{"undergone", "undergon"},
		{"undergraduate", "undergradu"},
		{"underground", "underground"},
		{"underhand", "underhand"},
		{"underhanded", "underhand"},
		{"underling", "underl"},
		{"underlip", "underlip"},
		{"underlying", "under"},
		{"undermine", "undermin"},
		{"undermined", "undermin"},
		{"undermining", "undermin"},
		{"underneath", "underneath"},
		{"underrated", "underr"},
		{"underscored", "underscor"},
		{"undersecretary", "undersecretari"},
		{"underserving", "underserv"},
		{"undersoil", "undersoil"},
		{"understand", "understand"},
		{"understanding", "understand"},
		{"understands", "understand"},
		{"understood", "understood"},
		{"understrapper", "understrapp"},
		{"understrappers", "understrapp"},
		{"undertake", "undertak"},
		{"undertaken", "undertaken"},
		{"undertaker", "undertak"},
		{"undertakers", "undertak"},
		{"undertakes", "undertak"},
		{"undertaking", "undertak"},
		{"undertakings", "undertak"},
		{"undertone", "underton"},
		{"undertook", "undertook"},
		{"undervalue", "undervalu"},
		{"underwent", "underw"},
		{"underwood", "underwood"},
		{"undescribed", "undescrib"},
		{"undeserved", "undeserv"},
		{"undeservedly", "undeserv"},
		{"undesigning", "undesign"},
		{"undesirable", "undesir"},
		{"undetermined", "undetermin"},
		{"undeviating", "undevi"},
		{"undid", "undid"},
		{"undignified", "undignifi"},
		{"undiminished", "undiminish"},
		{"undimmed", "undim"},
		{"undisfigured", "undisfigur"},
		{"undisguisable", "undisguis"},
		{"undisguised", "undisguis"},
		{"undisguisedly", "undisguis"},
		{"undismayed", "undismay"},
		{"undisposed", "undispos"},
		{"undistinguishable", "undistinguish"},
		{"undisturbed", "undisturb"},
		{"undivided", "undivid"},
		{"undivulged", "undivulg"},
		{"undo", "undo"},
		{"undoing", "undo"},
		{"undone", "undon"},
		{"undoubted", "undoubt"},
		{"undoubtedly", "undoubt"},
		{"undrained", "undrain"},
		{"undraws", "undraw"},
		{"undress", "undress"},
		{"undressed", "undress"},
		{"undressing", "undress"},
		{"undue", "undu"},
		{"undulating", "undul"},
		{"undulation", "undul"},
		{"undulations", "undul"},
		{"undulatory", "undulatori"},
		{"undutiful", "unduti"},
		{"undying", "undi"},
		{"une", "une"},
		{"unearthed", "unearth"},
		{"unearthly", "unearth"},
		{"uneasily", "uneasili"},
		{"uneasiness", "uneasi"},
		{"uneasy", "uneasi"},
		{"uneatable", "uneat"},
		{"uneducated", "uneduc"},
		{"unembarrassed", "unembarrass"},
		{"unemployed", "unemploy"},
		{"unencumbered", "unencumb"},
		{"unendurable", "unendur"},
		{"unenviable", "unenvi"},
		{"unequal", "unequ"},
		{"unequalled", "unequal"},
		{"unequally", "unequ"},
		{"unequivocal", "unequivoc"},
		{"unequivocally", "unequivoc"},
		{"unerring", "uner"},
		{"unes", "une"},
		{"uneven", "uneven"},
		{"uneventful", "unev"},
		{"unexamined", "unexamin"},
		{"unexampled", "unexampl"},
		{"unexceptionable", "unexception"},
		{"unexciting", "unexcit"},
		{"unexpected", "unexpect"},
		{"unexpectedly", "unexpect"},
		{"unexplained", "unexplain"},
		{"unexplored", "unexplor"},
		{"unexpressed", "unexpress"},
		{"unfailing", "unfail"},
		{"unfair", "unfair"},
		{"unfairly", "unfair"},
		{"unfaithfulness", "unfaith"},
		{"unfamiliar", "unfamiliar"},
		{"unfamiliarity", "unfamiliar"},
		{"unfashionable", "unfashion"},
		{"unfastened", "unfasten"},
		{"unfathomable", "unfathom"},
		{"unfavourable", "unfavour"},
		{"unfeeling", "unfeel"},
		{"unfeelingly", "unfeel"},
		{"unfeigned", "unfeign"},
		{"unfeignedly", "unfeign"},
		{"unfeminine", "unfeminin"},
		{"unfilled", "unfil"},
		{"unfinished", "unfinish"},
		{"unfit", "unfit"},
		{"unfitness", "unfit"},
		{"unfitted", "unfit"},
		{"unfitting", "unfit"},
		{"unflinching", "unflinch"},
		{"unflinchingly", "unflinch"},
		{"unfold", "unfold"},
		{"unfolded", "unfold"},
		{"unfolding", "unfold"},
		{"unfolds", "unfold"},
		{"unforeseen", "unforeseen"},
		{"unforgiving", "unforgiv"},
		{"unformed", "unform"},
		{"unfort", "unfort"},
		{"unfortnet", "unfortnet"},
		{"unfortunate", "unfortun"},
		{"unfortunately", "unfortun"},
		{"unfortunates", "unfortun"},
		{"unfounded", "unfound"},
		{"unfrequent", "unfrequ"},
		{"unfrequented", "unfrequ"},
		{"unfrequently", "unfrequ"},
		{"unfresh", "unfresh"},
		{"unfriended", "unfriend"},
		{"unfriendly", "unfriend"},
		{"unfulfilled", "unfulfil"},
		{"unfurled", "unfurl"},
		{"ungainly", "ungain"},
		{"ungallant", "ungal"},
		{"ungenerous", "ungener"},
		{"ungenial", "ungeni"},
		{"ungenteel", "ungenteel"},
		{"ungentlemanly", "ungentleman"},
		{"ungirdles", "ungirdl"},
		{"ungovernable", "ungovern"},
		{"ungracious", "ungraci"},
		{"ungraciously", "ungraci"},
		{"ungraciousness", "ungraci"},
		{"ungrateful", "ungrat"},
		{"ungratefully", "ungrat"},
		{"ungratified", "ungratifi"},
		{"ungrown", "ungrown"},
		{"unguarded", "unguard"},
		{"unhand", "unhand"},
		{"unhandsome", "unhandsom"},
		{"unhappier", "unhappi"},
		{"unhappily", "unhappili"},
		{"unhappiness", "unhappi"},
		{"unhappy", "unhappi"},
		{"unharnessing", "unhar"},
		{"unhealed", "unheal"},
		{"unhealthy", "unhealthi"},
		{"unheard", "unheard"},
		{"unheeded", "unheed"},
		{"unheeding", "unheed"},
		{"unhesitatingly", "unhesit"},
		{"unhewn", "unhewn"},
		{"unhinged", "unhing"},
		{"unholy", "unholi"},
		{"unhonoured", "unhonour"},
		{"unhooking", "unhook"},
		{"unhorsed", "unhors"},
		{"unhurried", "unhurri"},
		{"unhurt", "unhurt"},
		{"unifor", "unifor"},
		{"uniform", "uniform"},
		{"uniformity", "uniform"},
		{"uniformly", "uniform"},
		{"uniforms", "uniform"},
		{"unimaginable", "unimagin"},
		{"unimagined", "unimagin"},
		{"unimpaired", "unimpair"},
		{"unimpeachable", "unimpeach"},
		{"unimpeached", "unimpeach"},
		{"unimportant", "unimport"},
		{"unimprovable", "unimprov"},
		{"unimproved", "unimprov"},
		{"uninfluenced", "uninfluenc"},
		{"uninhabited", "uninhabit"},
		{"uninitiated", "uniniti"},
		{"uninjured", "uninjur"},
		{"unintellectual", "unintellectu"},
		{"unintelligible", "unintellig"},
		{"unintentional", "unintent"},
		{"unintentionally", "unintent"},
		{"uninterested", "uninterest"},
		{"uninteresting", "uninterest"},
		{"uninterrupted", "uninterrupt"},
		{"uninterruptedly", "uninterrupt"},
		{"uninvited", "uninvit"},
		{"uninviting", "uninvit"},
		{"union", "union"},
		{"unions", "union"},
		{"unique", "uniqu"},
		{"unison", "unison"},
		{"unit", "unit"},
		{"unite", "unit"},
		{"united", "unit"},
		{"unites", "unit"},
		{"unities", "uniti"},
		{"uniting", "unit"},
		{"units", "unit"},
		{"unity", "uniti"},
		{"universal", "univers"},
		{"universally", "univers"},
		{"universe", "univers"},
		{"university", "univers"},
		{"unjoyous", "unjoy"},
		{"unjust", "unjust"},
		{"unjustifiable", "unjustifi"},
		{"unjustly", "unjust"},
		{"unkempt", "unkempt"},
		{"unkind", "unkind"},
		{"unkindly", "unkind"},
		{"unkindness", "unkind"},
		{"unkiver", "unkiv"},
		{"unknowing", "unknow"},
		{"unknowingly", "unknow"},
		{"unknown", "unknown"},
		{"unladylike", "unladylik"},
		{"unlatched", "unlatch"},
		{"unlawful", "unlaw"},
		{"unlawfully", "unlaw"},
		{"unlearn", "unlearn"},
		{"unlearnt", "unlearnt"},
		{"unless", "unless"},
		{"unlicensed", "unlicens"},
		{"unlike", "unlik"},
		{"unlikely", "unlik"},
		{"unlimited", "unlimit"},
		{"unliquidated", "unliquid"},
		{"unload", "unload"},
		{"unloaded", "unload"},
		{"unloading", "unload"},
		{"unlock", "unlock"},
		{"unlocked", "unlock"},
		{"unlocking", "unlock"},
		{"unlocks", "unlock"},
		{"unlooked", "unlook"},
		{"unloosed", "unloos"},
		{"unloosened", "unloosen"},
		{"unlovable", "unlov"},
		{"unloved", "unlov"},
		{"unlovely", "unlov"},
		{"unloving", "unlov"},
		{"unluckily", "unluckili"},
		{"unlucky", "unlucki"},
		{"unmade", "unmad"},
		{"unmake", "unmak"},
		{"unmanageable", "unmanag"},
		{"unmanly", "unman"},
		{"unmanned", "unman"},
		{"unmans", "unman"},
		{"unmarked", "unmark"},
		{"unmarried", "unmarri"},
		{"unmasked", "unmask"},
		{"unmatched", "unmatch"},
		{"unmeaning", "unmean"},
		{"unmentionable", "unmention"},
		{"unmerciful", "unmerci"},
		{"unmercifully", "unmerci"},
		{"unmerited", "unmerit"},
		{"unmindful", "unmind"},
		{"unmistakable", "unmistak"},
		{"unmistakably", "unmistak"},
		{"unmitigated", "unmitig"},
		{"unmixed", "unmix"},
		{"unmolested", "unmolest"},
		{"unmoved", "unmov"},
		{"unnamed", "unnam"},
		{"unnat", "unnat"},
		{"unnatural", "unnatur"},
		{"unnaturally", "unnatur"},
		{"unnecessarily", "unnecessarili"},
		{"unnecessary", "unnecessari"},
		{"unnerved", "unnerv"},
		{"unnoticed", "unnot"},
		{"unobjectionable", "unobjection"},
		{"unobservant", "unobserv"},
		{"unobserved", "unobserv"},
		{"unobtrusive", "unobtrus"},
		{"unoccupied", "unoccupi"},
		{"unoffending", "unoffend"},
		{"unopenable", "unopen"},
		{"unopened", "unopen"},
		{"unowned", "unown"},
		{"unpack", "unpack"},
		{"unpacked", "unpack"},
		{"unpacking", "unpack"},
		{"unpaid", "unpaid"},
		{"unpainted", "unpaint"},
		{"unpalatable", "unpalat"},
		{"unparalleled", "unparallel"},
		{"unpardonable", "unpardon"},
		{"unpardonably", "unpardon"},
		{"unpaved", "unpav"},
		{"unpensioning", "unpens"},
		{"unperformed", "unperform"},
		{"unpersuadable", "unpersuad"},
		{"unperturbable", "unperturb"},
		{"unpicturesque", "unpicturesqu"},
		{"unpitying", "unpiti"},
		{"unplaced", "unplac"},
		{"unpleasant", "unpleas"},
		{"unpleasantly", "unpleas"},
		{"unpleasantness", "unpleas"},
		{"unpleasantnesses", "unpleas"},
		{"unpleasing", "unpleas"},
		{"unpleasingly", "unpleas"},
		{"unpolite", "unpolit"},
		{"unpolitely", "unpolit"},
		{"unpoliteness", "unpolit"},
		{"unpopular", "unpopular"},
		{"unpractical", "unpract"},
		{"unpractised", "unpractis"},
		{"unprecedented", "unpreced"},
		{"unpremeditated", "unpremedit"},
		{"unprepared", "unprepar"},
		{"unpretending", "unpretend"},
		{"unpretendingly", "unpretend"},
		{"unprevaricating", "unprevar"},
		{"unprincipled", "unprincipl"},
		{"unproducible", "unproduc"},
		{"unproductive", "unproduct"},
		{"unprofitable", "unprofit"},
		{"unpromising", "unpromis"},
		{"unprosperous", "unprosper"},
		{"unprotected", "unprotect"},
		{"unprovided", "unprovid"},
		{"unpublished", "unpublish"},
		{"unpunctual", "unpunctu"},
		{"unpunished", "unpunish"},
		{"unqualified", "unqualifi"},
		{"unquestionable", "unquestion"},
		{"unquestionably", "unquestion"},
		{"unquiet", "unquiet"},
		{"unravel", "unravel"},
		{"unravelling", "unravel"},
		{"unravelment", "unravel"},
		{"unread", "unread"},
		{"unreal", "unreal"},
		{"unreason", "unreason"},
		{"unreasonable", "unreason"},
		{"unreasonableness", "unreason"},
		{"unreasonably", "unreason"},
		{"unreasoning", "unreason"},
		{"unreclaimed", "unreclaim"},
		{"unrecognised", "unrecognis"},
		{"unredeemed", "unredeem"},
		{"unrelenting", "unrel"},
		{"unrelieved", "unreliev"},
		{"unremitting", "unremit"},
		{"unrepining", "unrepin"},
		{"unrequited", "unrequit"},
		{"unreserved", "unreserv"},
		{"unresisting", "unresist"},
		{"unrest", "unrest"},
		{"unrestrained", "unrestrain"},
		{"unrestrainedly", "unrestrain"},
		{"unriddling", "unriddl"},
		{"unripe", "unrip"},
		{"unrivalled", "unrival"},
		{"unroofed", "unroof"},
		{"unruly", "unruli"},
		{"unsaddle", "unsaddl"},
		{"unsaddled", "unsaddl"},
		{"unsafe", "unsaf"},
		{"unsatisfactory", "unsatisfactori"},
		{"unsatisfied", "unsatisfi"},
		{"unsavoury", "unsavouri"},
		{"unsay", "unsay"},
		{"unschooled", "unschool"},
		{"unscratched", "unscratch"},
		{"unscrews", "unscrew"},
		{"unscrupulous", "unscrupul"},
		{"unscrupulously", "unscrupul"},
		{"unseasonable", "unseason"},
		{"unseemly", "unseem"},
		{"unseen", "unseen"},
		{"unselfish", "unselfish"},
		{"unselfishly", "unselfish"},
		{"unselfishness", "unselfish"},
		{"unsettle", "unsettl"},
		{"unsettled", "unsettl"},
		{"unsettles", "unsettl"},
		{"unsettling", "unsettl"},
		{"unshackled", "unshackl"},
		{"unshadowed", "unshadow"},
		{"unshaken", "unshaken"},
		{"unshaved", "unshav"},
		{"unshaven", "unshaven"},
		{"unsheltered", "unshelt"},
		{"unshod", "unshod"},
		{"unsightly", "unsight"},
		{"unskilful", "unskil"},
		{"unsoftened", "unsoften"},
		{"unsolicited", "unsolicit"},
		{"unsolved", "unsolv"},
		{"unsophisticated", "unsophist"},
		{"unsparing", "unspar"},
		{"unspeakable", "unspeak"},
		{"unspeakably", "unspeak"},
		{"unspoilt", "unspoilt"},
		{"unspoken", "unspoken"},
		{"unstable", "unstabl"},
		{"unsteadier", "unsteadi"},
		{"unsteadily", "unsteadili"},
		{"unsteadiness", "unsteadi"},
		{"unsteady", "unsteadi"},
		{"unstratified", "unstratifi"},
		{"unstrung", "unstrung"},
		{"unstudied", "unstudi"},
		{"unsubstantial", "unsubstanti"},
		{"unsuccessful", "unsuccess"},
		{"unsuccessfully", "unsuccess"},
		{"unsuitable", "unsuit"},
		{"unsuited", "unsuit"},
		{"unsullied", "unsulli"},
		{"unsupportable", "unsupport"},
		{"unsupported", "unsupport"},
		{"unsuspecting", "unsuspect"},
		{"unsuspicious", "unsuspici"},
		{"unsustainable", "unsustain"},
		{"unsymmetrical", "unsymmetr"},
		{"unsympathetic", "unsympathet"},
		{"untainted", "untaint"},
		{"untamed", "untam"},
		{"untarnished", "untarnish"},
		{"untasted", "untast"},
		{"untaxed", "untax"},
		{"untenable", "unten"},
		{"untenanted", "unten"},
		{"untended", "untend"},
		{"unthankful", "unthank"},
		{"unthankfulness", "unthank"},
		{"unthinkable", "unthink"},
		{"unthought", "unthought"},
		{"unthrifty", "unthrifti"},
		{"untidily", "untidili"},
		{"untidy", "untidi"},
		{"untie", "unti"},
		{"untied", "unti"},
		{"unties", "unti"},
		{"until", "until"},
		{"untimely", "untim"},
		{"untiring", "untir"},
		{"unto", "unto"},
		{"untold", "untold"},
		{"untouched", "untouch"},
		{"untoward", "untoward"},
		{"untrammelled", "untrammel"},
		{"untranslatable", "untranslat"},
		{"untried", "untri"},
		{"untrimmed", "untrim"},
		{"untroubled", "untroubl"},
		{"untrue", "untru"},
		{"untrustworthy", "untrustworthi"},
		{"unturned", "unturn"},
		{"untwisting", "untwist"},
		{"untying", "unti"},
		{"unused", "unus"},
		{"unusual", "unusu"},
		{"unusually", "unusu"},
		{"unutterable", "unutter"},
		{"unuttered", "unutt"},
		{"unvaried", "unvari"},
		{"unvarying", "unvari"},
		{"unveil", "unveil"},
		{"unveiling", "unveil"},
		{"unventilated", "unventil"},
		{"unverified", "unverifi"},
		{"unwarily", "unwarili"},
		{"unwary", "unwari"},
		{"unwashed", "unwash"},
		{"unwearied", "unweari"},
		{"unwearying", "unweari"},
		{"unwelcome", "unwelcom"},
		{"unwell", "unwel"},
		{"unwhitewashed", "unwhitewash"},
		{"unwholesome", "unwholesom"},
		{"unwieldy", "unwieldi"},
		{"unwilling", "unwil"},
		{"unwillingly", "unwil"},
		{"unwillingness", "unwilling"},
		{"unwinding", "unwind"},
		{"unwise", "unwis"},
		{"unwisely", "unwis"},
		{"unwittingly", "unwit"},
		{"unwonted", "unwont"},
		{"unworldly", "unworld"},
		{"unworthily", "unworthili"},
		{"unworthiness", "unworthi"},
		{"unworthy", "unworthi"},
		{"unwound", "unwound"},
		{"unwritten", "unwritten"},
		{"unwrung", "unwrung"},
		{"unyielding", "unyield"},
		{"up", "up"},
		{"upas", "upa"},
		{"upbearing", "upbear"},
		{"upbraid", "upbraid"},
		{"upbraiding", "upbraid"},
		{"upheaval", "upheav"},
		{"upheavals", "upheav"},
		{"upheaved", "upheav"},
		{"upheaving", "upheav"},
		{"upheld", "upheld"},
		{"uphill", "uphil"},
		{"uphold", "uphold"},
		{"upholding", "uphold"},
		{"upholstered", "upholst"},
		{"upholsterer", "upholster"},
		{"upholsterers", "upholster"},
		{"upholstery", "upholsteri"},
		{"upjohn", "upjohn"},
		{"uplan", "uplan"},
		{"upland", "upland"},
		{"uplift", "uplift"},
		{"uplifted", "uplift"},
		{"uplifting", "uplift"},
		{"upliftings", "uplift"},
		{"upon", "upon"},
		{"upper", "upper"},
		{"uppermost", "uppermost"},
		{"upraised", "uprais"},
		{"upright", "upright"},
		{"uprightness", "upright"},
		{"uprising", "upris"},
		{"uprisings", "upris"},
		{"uproar", "uproar"},
		{"uproarious", "uproari"},
		{"uproariously", "uproari"},
		{"uproot", "uproot"},
		{"uprooting", "uproot"},
		{"uprose", "upros"},
		{"ups", "up"},
		{"upsallata", "upsallata"},
		{"upset", "upset"},
		{"upsets", "upset"},
		{"upsetting", "upset"},
		{"upshot", "upshot"},
		{"upside", "upsid"},
		{"upstairs", "upstair"},
		{"upstart", "upstart"},
		{"upstarts", "upstart"},
		{"upturned", "upturn"},
		{"upward", "upward"},
		{"upwards", "upward"},
		{"urbane", "urban"},
		{"urbanity", "urban"},
		{"urchin", "urchin"},
		{"urge", "urg"},
		{"urged", "urg"},
		{"urgency", "urgenc"},
		{"urgent", "urgent"},
		{"urgently", "urgent"},
		{"urges", "urg"},
		{"urging", "urg"},
		{"urinary", "urinari"},
		{"urn", "urn"},
		{"ursula", "ursula"},
		{"uruguay", "uruguay"},
		{"us", "us"},
		{"usage", "usag"},
		{"usborne", "usborn"},
		{"use", "use"},
		{"used", "use"},
		{"useful", "use"},
		{"usefully", "use"},
		{"usefulness", "use"},
		{"useless", "useless"},
		{"uselessly", "useless"},
		{"uselessness", "useless"},
		{"uses", "use"},
		{"usher", "usher"},
		{"ushered", "usher"},
		{"ushering", "usher"},
		{"ushers", "usher"},
		{"using", "use"},
		{"usnera", "usnera"},
		{"uspallata", "uspallata"},
		{"usual", "usual"},
		{"usually", "usual"},
		{"usurer", "usur"},
		{"usurers", "usur"},
		{"usurp", "usurp"},
		{"utamme", "utamm"},
		{"utensils", "utensil"},
		{"utilitarianism", "utilitarian"},
		{"utility", "util"},
		{"utilize", "util"},
		{"utilized", "util"},
		{"utmost", "utmost"},
		{"utter", "utter"},
		{"utterance", "utter"},
		{"uttered", "utter"},
		{"uttering", "utter"},
		{"utterly", "utter"},
		{"utters", "utter"},
		{"v", "v"},
		{"va", "va"},
		{"vacancies", "vacanc"},
		{"vacancy", "vacanc"},
		{"vacant", "vacant"},
		{"vacantly", "vacant"},
		{"vacas", "vaca"},
		{"vacate", "vacat"},
		{"vacated", "vacat"},
		{"vacation", "vacat"},
		{"vacations", "vacat"},
		{"vacillated", "vacil"},
		{"vacillating", "vacil"},
		{"vacillations", "vacil"},
		{"vacillatory", "vacillatori"},
		{"vade", "vade"},
		{"vagabond", "vagabond"},
		{"vagabondizing", "vagabond"},
		{"vagabonds", "vagabond"},
		{"vagaries", "vagari"},
		{"vagary", "vagari"},
		{"vagrant", "vagrant"},
		{"vagrants", "vagrant"},
		{"vague", "vagu"},
		{"vaguely", "vagu"},
		{"vagueness", "vagu"},
		{"vahrushin", "vahrushin"},
		{"vain", "vain"},
		{"vainer", "vainer"},
		{"vainest", "vainest"},
		{"vainglory", "vainglori"},
		{"vainly", "vain"},
		{"vaiuly", "vaiuli"},
		{"valdes", "vald"},
		{"valdivia", "valdivia"},
		{"vale", "vale"},
		{"valet", "valet"},
		{"valets", "valet"},
		{"valiantly", "valiant"},
		{"valid", "valid"},
		{"validity", "valid"},
		{"valise", "valis"},
		{"valle", "vall"},
		{"valley", "valley"},
		{"valleys", "valley"},
		{"valour", "valour"},
		{"valparaiso", "valparaiso"},
		{"valuable", "valuabl"},
		{"valuables", "valuabl"},
		{"valuation", "valuat"},
		{"value", "valu"},
		{"valued", "valu"},
		{"valueless", "valueless"},
		{"valve", "valv"},
		{"vamp", "vamp"},
		{"vampire", "vampir"},
		{"van", "van"},
		{"vancouver", "vancouv"},
		{"vane", "vane"},
		{"vanellus", "vanellus"},
		{"vanes", "vane"},
		{"vanessa", "vanessa"},
		{"vanikoro", "vanikoro"},
		{"vanish", "vanish"},
		{"vanished", "vanish"},
		{"vanishes", "vanish"},
		{"vanishing", "vanish"},
		{"vanities", "vaniti"},
		{"vanity", "vaniti"},
		{"vans", "van"},
		{"vapid", "vapid"},
		{"vapidity", "vapid"},
		{"vaporous", "vapor"},
		{"vapour", "vapour"},
		{"vapouring", "vapour"},
		{"vapourings", "vapour"},
		{"vapours", "vapour"},
		{"vapoury", "vapouri"},
		{"vara", "vara"},
		{"varents", "varent"},
		{"variable", "variabl"},
		{"variance", "varianc"},
		{"variation", "variat"},
		{"variations", "variat"},
		{"varie", "vari"},
		{"varied", "vari"},
		{"variegated", "varieg"},
		{"varies", "vari"},
		{"varieties", "varieti"},
		{"variety", "varieti"},
		{"various", "various"},
		{"variously", "various"},
		{"varnish", "varnish"},
		{"varnished", "varnish"},
		{"vary", "vari"},
		{"varying", "vari"},
		{"vase", "vase"},
		{"vases", "vase"},
		{"vassal", "vassal"},
		{"vassalage", "vassalag"},
		{"vassilitch", "vassilitch"},
		{"vassily", "vassili"},
		{"vassilyevsky", "vassilyevski"},
		{"vast", "vast"},
		{"vastly", "vast"},
		{"vastness", "vast"},
		{"vasya", "vasya"},
		{"vater", "vater"},
		{"vaughans", "vaughan"},
		{"vault", "vault"},
		{"vaulted", "vault"},
		{"vaulting", "vault"},
		{"vaults", "vault"},
		{"vaunt", "vaunt"},
		{"vauxhall", "vauxhal"},
		{"vayli", "vayli"},
		{"ve", "ve"},
		{"veal", "veal"},
		{"veals", "veal"},
		{"veer", "veer"},
		{"veered", "veer"},
		{"veering", "veer"},
		{"vegetabl", "vegetabl"},
		{"vegetable", "veget"},
		{"vegetables", "veget"},
		{"vegetate", "veget"},
		{"vegetation", "veget"},
		{"vehemence", "vehem"},
		{"vehement", "vehement"},
		{"vehemently", "vehement"},
		{"vehicle", "vehicl"},
		{"vehicles", "vehicl"},
		{"veil", "veil"},
		{"veiled", "veil"},
		{"veils", "veil"},
		{"vein", "vein"},
		{"veined", "vein"},
		{"veinous", "veinous"},
		{"veins", "vein"},
		{"vellum", "vellum"},
		{"velocity", "veloc"},
		{"velvet", "velvet"},
		{"velvets", "velvet"},
		{"venda", "venda"},
		{"vendome", "vendom"},
		{"vendor", "vendor"},
		{"vendors", "vendor"},
		{"venerable", "vener"},
		{"veneration", "vener"},
		{"venetian", "venetian"},
		{"vengeance", "vengeanc"},
		{"venice", "venic"},
		{"veniso", "veniso"},
		{"venom", "venom"},
		{"venomous", "venom"},
		{"vent", "vent"},
		{"ventana", "ventana"},
		{"vented", "vent"},
		{"ventilated", "ventil"},
		{"ventilation", "ventil"},
		{"ventilator", "ventil"},
		{"venting", "vent"},
		{"ventnor", "ventnor"},
		{"ventriloquists", "ventriloquist"},
		{"vents", "vent"},
		{"venture", "ventur"},
		{"ventured", "ventur"},
		{"ventures", "ventur"},
		{"venturesome", "venturesom"},
		{"venturing", "ventur"},
		{"venus", "venus"},
		{"veo", "veo"},
		{"ver", "ver"},
		{"vera", "vera"},
		{"veracious", "veraci"},
		{"veracity", "verac"},
		{"veranda", "veranda"},
		{"verandah", "verandah"},
		{"verandahs", "verandah"},
		{"verb", "verb"},
		{"verbal", "verbal"},
		{"verbally", "verbal"},
		{"verbena", "verbena"},
		{"verbenas", "verbena"},
		{"verbose", "verbos"},
		{"verd", "verd"},
		{"verdant", "verdant"},
		{"verdict", "verdict"},
		{"verdigris", "verdigri"},
		{"verds", "verd"},
		{"verdure", "verdur"},
		{"vere", "vere"},
		{"verge", "verg"},
		{"verging", "verg"},
		{"verified", "verifi"},
		{"verify", "verifi"},
		{"verily", "verili"},
		{"verisopht", "verisopht"},
		{"veritably", "verit"},
		{"verite", "verit"},
		{"vermiform", "vermiform"},
		{"vermilion", "vermilion"},
		{"vermin", "vermin"},
		{"verona", "verona"},
		{"versailles", "versaill"},
		{"versatile", "versatil"},
		{"verse", "vers"},
		{"versed", "vers"},
		{"verses", "vers"},
		{"versification", "versif"},
		{"version", "version"},
		{"versions", "version"},
		{"versts", "verst"},
		{"vertebrae", "vertebra"},
		{"vertical", "vertic"},
		{"vertically", "vertic"},
		{"vertu", "vertu"},
		{"verulam", "verulam"},
		{"very", "veri"},
		{"vesicles", "vesicl"},
		{"vessel", "vessel"},
		{"vessels", "vessel"},
		{"vestal", "vestal"},
		{"vestige", "vestig"},
		{"vestiges", "vestig"},
		{"vestigia", "vestigia"},
		{"vestry", "vestri"},
		{"vesuvius", "vesuvius"},
		{"veteran", "veteran"},
		{"veterinary", "veterinari"},
		{"veto", "veto"},
		{"vex", "vex"},
		{"vexation", "vexat"},
		{"vexations", "vexat"},
		{"vexatious", "vexati"},
		{"vexed", "vex"},
		{"vexes", "vex"},
		{"vexing", "vex"},
		{"vholes", "vhole"},
		{"vholeses", "vholes"},
		{"vi", "vi"},
		{"via", "via"},
		{"viands", "viand"},
		{"viazemsky", "viazemski"},
		{"vibrate", "vibrat"},
		{"vibrated", "vibrat"},
		{"vibrates", "vibrat"},
		{"vibrating", "vibrat"},
		{"vibration", "vibrat"},
		{"vibrations", "vibrat"},
		{"vibratory", "vibratori"},
		{"vicar", "vicar"},
		{"vicarage", "vicarag"},
		{"vicarious", "vicari"},
		{"vicariously", "vicari"},
		{"vice", "vice"},
		{"vicencio", "vicencio"},
		{"viceroys", "viceroy"},
		{"vices", "vice"},
		{"vicinity", "vicin"},
		{"vicious", "vicious"},
		{"viciously", "vicious"},
		{"viciousness", "vicious"},
		{"vicissitudes", "vicissitud"},
		{"victim", "victim"},
		{"victimized", "victim"},
		{"victims", "victim"},
		{"victoria", "victoria"},
		{"victories", "victori"},
		{"victorious", "victori"},
		{"victory", "victori"},
		{"victualled", "victual"},
		{"victuals", "victual"},
		{"vicuna", "vicuna"},
		{"vide", "vide"},
		{"video", "video"},
		{"vie", "vie"},
		{"vied", "vie"},
		{"vienna", "vienna"},
		{"view", "view"},
		{"viewed", "view"},
		{"viewing", "view"},
		{"views", "view"},
		{"vigil", "vigil"},
		{"vigilance", "vigil"},
		{"vigilant", "vigil"},
		{"vigilantly", "vigil"},
		{"vigorous", "vigor"},
		{"vigorously", "vigor"},
		{"vigour", "vigour"},
		{"vii", "vii"},
		{"viii", "viii"},
		{"vil", "vil"},
		{"vile", "vile"},
		{"vilely", "vile"},
		{"vileness", "vile"},
		{"viler", "viler"},
		{"vilest", "vilest"},
		{"vilified", "vilifi"},
		{"vilinco", "vilinco"},
		{"vilipilli", "vilipilli"},
		{"villa", "villa"},
		{"village", "villag"},
		{"villagers", "villag"},
		{"villages", "villag"},
		{"villain", "villain"},
		{"villainous", "villain"},
		{"villains", "villain"},
		{"villainy", "villaini"},
		{"villarica", "villarica"},
		{"villas", "villa"},
		{"villechardouin", "villechardouin"},
		{"villosus", "villosus"},
		{"vilna", "vilna"},
		{"vin", "vin"},
		{"vincent", "vincent"},
		{"vindicate", "vindic"},
		{"vindicated", "vindic"},
		{"vindication", "vindic"},
		{"vindictive", "vindict"},
		{"vindictively", "vindict"},
		{"vindictiveness", "vindict"},
		{"vine", "vine"},
		{"vinegar", "vinegar"},
		{"vines", "vine"},
		{"vineyards", "vineyard"},
		{"vino", "vino"},
		{"vinoque", "vinoqu"},
		{"vintems", "vintem"},
		{"viola", "viola"},
		{"violate", "violat"},
		{"violated", "violat"},
		{"violates", "violat"},
		{"violation", "violat"},
		{"violence", "violenc"},
		{"violent", "violent"},
		{"violently", "violent"},
		{"violet", "violet"},
		{"violets", "violet"},
		{"violin", "violin"},
		{"violins", "violin"},
		{"violoncello", "violoncello"},
		{"violoncellos", "violoncello"},
		{"viper", "viper"},
		{"vire", "vire"},
		{"virgin", "virgin"},
		{"virginian", "virginian"},
		{"virgularia", "virgularia"},
		{"virtually", "virtual"},
		{"virtue", "virtu"},
		{"virtues", "virtu"},
		{"virtuous", "virtuous"},
		{"virtuously", "virtuous"},
		{"virulence", "virul"},
		{"vis", "vis"},
		{"visage", "visag"},
		{"visaged", "visag"},
		{"viscid", "viscid"},
		{"vise", "vise"},
		{"vish", "vish"},
		{"vishera", "vishera"},
		{"visible", "visibl"},
		{"visibly", "visibl"},
		{"vision", "vision"},
		{"visionary", "visionari"},
		{"visions", "vision"},
		{"visit", "visit"},
		{"visitation", "visit"},
		{"visitations", "visit"},
		{"visited", "visit"},
		{"visiting", "visit"},
		{"visitor", "visitor"},
		{"visitors", "visitor"},
		{"visits", "visit"},
		{"vista", "vista"},
		{"vitae", "vita"},
		{"vital", "vital"},
		{"vitality", "vital"},
		{"vitally", "vital"},
		{"vitals", "vital"},
		{"vith", "vith"},
		{"vithout", "vithout"},
		{"vitiated", "vitiat"},
		{"vitrified", "vitrifi"},
		{"vittles", "vittl"},
		{"vituperation", "vituper"},
		{"vituperative", "vitup"},
		{"vivacious", "vivaci"},
		{"vivacity", "vivac"},
		{"vive", "vive"},
		{"vivid", "vivid"},
		{"vividly", "vivid"},
		{"vividness", "vivid"},
		{"vivisecting", "vivisect"},
		{"vivoras", "vivora"},
		{"vixen", "vixen"},
		{"vixenish", "vixenish"},
		{"viz", "viz"},
		{"vizier", "vizier"},
		{"vm", "vm"},
		{"vocabulary", "vocabulari"},
		{"vocal", "vocal"},
		{"vocalist", "vocalist"},
		{"vocalists", "vocalist"},
		{"vocation", "vocat"},
		{"voce", "voce"},
		{"vociferates", "vocifer"},
		{"vociferous", "vocifer"},
		{"vodka", "vodka"},
		{"vogue", "vogu"},
		{"voice", "voic"},
		{"voiced", "voic"},
		{"voices", "voic"},
		{"void", "void"},
		{"voir", "voir"},
		{"vol", "vol"},
		{"volatile", "volatil"},
		{"volatilized", "volatil"},
		{"volcanic", "volcan"},
		{"volcano", "volcano"},
		{"volcanoes", "volcano"},
		{"volcanos", "volcano"},
		{"volley", "volley"},
		{"volleys", "volley"},
		{"volney", "volney"},
		{"volte", "volt"},
		{"volubility", "volubl"},
		{"voluble", "volubl"},
		{"volubly", "volubl"},
		{"volume", "volum"},
		{"volumes", "volum"},
		{"voluminous", "volumin"},
		{"volumnia", "volumnia"},
		{"volumnias", "volumnia"},
		{"voluntarily", "voluntarili"},
		{"voluntary", "voluntari"},
		{"volunteer", "volunt"},
		{"volunteered", "volunt"},
		{"volunteering", "volunt"},
		{"voluptuous", "voluptu"},
		{"voluta", "voluta"},
		{"volutas", "voluta"},
		{"volute", "volut"},
		{"vom", "vom"},
		{"vomit", "vomit"},
		{"von", "von"},
		{"voraciously", "voraci"},
		{"vortex", "vortex"},
		{"vorticose", "vorticos"},
		{"voskresensky", "voskresenski"},
		{"votaries", "votari"},
		{"vote", "vote"},
		{"voted", "vote"},
		{"voter", "voter"},
		{"voters", "voter"},
		{"votes", "vote"},
		{"voting", "vote"},
		{"vouch", "vouch"},
		{"vouches", "vouch"},
		{"vouchsafe", "vouchsaf"},
		{"vouchsafed", "vouchsaf"},
		{"vouchsafing", "vouchsaf"},
		{"vous", "vous"},
		{"vow", "vow"},
		{"vowed", "vow"},
		{"vowing", "vow"},
		{"vows", "vow"},
		{"voyage", "voyag"},
		{"voyager", "voyag"},
		{"voyagers", "voyag"},
		{"voyages", "voyag"},
		{"voznesensky", "voznesenski"},
		{"vrazumihin", "vrazumihin"},
		{"vremya", "vremya"},
		{"vrow", "vrow"},
		{"vue", "vue"},
		{"vulgar", "vulgar"},
		{"vulgarest", "vulgarest"},
		{"vulgarise", "vulgaris"},
		{"vulgarity", "vulgar"},
		{"vultur", "vultur"},
		{"vulture", "vultur"},
		{"vultures", "vultur"},
		{"w", "w"},
		{"wa", "wa"},
		{"waa", "waa"},
		{"waants", "waant"},
		{"waat", "waat"},
		{"wackford", "wackford"},
		{"wackfords", "wackford"},
		{"wadded", "wad"},
		{"wadding", "wad"},
		{"waddling", "waddl"},
		{"wade", "wade"},
		{"waded", "wade"},
		{"waders", "wader"},
		{"wading", "wade"},
		{"wafer", "wafer"},
		{"wafered", "wafer"},
		{"wafers", "wafer"},
		{"waft", "waft"},
		{"wafted", "waft"},
		{"wage", "wage"},
		{"waged", "wage"},
		{"wager", "wager"},
		{"wagers", "wager"},
		{"wages", "wage"},
		{"wagged", "wag"},
		{"wagging", "wag"},
		{"waggish", "waggish"},
		{"waggishly", "waggish"},
		{"waggon", "waggon"},
		{"waggoner", "waggon"},
		{"waggons", "waggon"},
		{"wagner", "wagner"},
		{"wagon", "wagon"},
		{"wai", "wai"},
		{"wail", "wail"},
		{"wailed", "wail"},
		{"wailing", "wail"},
		{"wailings", "wail"},
		{"wails", "wail"},
		{"waimate", "waimat"},
		{"wainscot", "wainscot"},
		{"wainscotting", "wainscot"},
		{"waiomio", "waiomio"},
		{"waist", "waist"},
		{"waistcoat", "waistcoat"},
		{"waistcoats", "waistcoat"},
		{"waisted", "waist"},
		{"waists", "waist"},
		{"wait", "wait"},
		{"waited", "wait"},
		{"waiter", "waiter"},
		{"waiters", "waiter"},
		{"waither", "waither"},
		{"waiting", "wait"},
		{"waitress", "waitress"},
		{"waits", "wait"},
		{"wake", "wake"},
		{"waked", "wake"},
		{"wakeful", "wake"},
		{"wakefulness", "wake"},
		{"wakened", "waken"},
		{"wakening", "waken"},
		{"wakes", "wake"},
		{"waking", "wake"},
		{"wakken", "wakken"},
		{"walckanaer", "walckana"},
		{"walcot", "walcot"},
		{"wale", "wale"},
		{"walerawang", "walerawang"},
		{"wales", "wale"},
		{"walk", "walk"},
		{"walked", "walk"},
		{"walker", "walker"},
		{"walketh", "walketh"},
		{"walking", "walk"},
		{"walks", "walk"},
		{"wall", "wall"},
		{"walled", "wall"},
		{"walleechu", "walleechu"},
		{"wallenstein", "wallenstein"},
		{"wallflower", "wallflow"},
		{"wallflowers", "wallflow"},
		{"wallow", "wallow"},
		{"wallowing", "wallow"},
		{"walls", "wall"},
		{"walnut", "walnut"},
		{"walpole", "walpol"},
		{"walter", "walter"},
		{"walting", "walt"},
		{"waltz", "waltz"},
		{"waltzed", "waltz"},
		{"waltzes", "waltz"},
		{"waltzing", "waltz"},
		{"wan", "wan"},
		{"wand", "wand"},
		{"wander", "wander"},
		{"wandered", "wander"},
		{"wanderer", "wander"},
		{"wanderers", "wander"},
		{"wandering", "wander"},
		{"wanderings", "wander"},
		{"wanders", "wander"},
		{"wands", "wand"},
		{"wane", "wane"},
		{"waned", "wane"},
		{"wanness", "wan"},
		{"wanst", "wanst"},
		{"want", "want"},
		{"wanted", "want"},
		{"wanting", "want"},
		{"wanton", "wanton"},
		{"wantonly", "wanton"},
		{"wantonness", "wanton"},
		{"wants", "want"},
		{"war", "war"},
		{"warbler", "warbler"},
		{"warbling", "warbl"},
		{"warburton", "warburton"},
		{"ward", "ward"},
		{"warded", "ward"},
		{"warder", "warder"},
		{"warding", "ward"},
		{"wardrobe", "wardrob"},
		{"wardrobes", "wardrob"},
		{"wards", "ward"},
		{"ware", "ware"},
		{"warehouse", "warehous"},
		{"warehousemen", "warehousemen"},
		{"warehouses", "warehous"},
		{"wares", "ware"},
		{"warfare", "warfar"},
		{"warhorse", "warhors"},
		{"warily", "warili"},
		{"warking", "wark"},
		{"warlike", "warlik"},
		{"warm", "warm"},
		{"warmed", "warm"},
		{"warmer", "warmer"},
		{"warmest", "warmest"},
		{"warmhearted", "warmheart"},
		{"warming", "warm"},
		{"warmly", "warm"},
		{"warms", "warm"},
		{"warmth", "warmth"},
		{"warn", "warn"},
		{"warned", "warn"},
		{"warning", "warn"},
		{"warnings", "warn"},
		{"warped", "warp"},
		{"warrant", "warrant"},
		{"warranted", "warrant"},
		{"warrants", "warrant"},
		{"warrens", "warren"},
		{"warring", "war"},
		{"warrior", "warrior"},
		{"warriors", "warrior"},
		{"warrn", "warrn"},
		{"wars", "war"},
		{"wart", "wart"},
		{"warted", "wart"},
		{"warts", "wart"},
		{"warwick", "warwick"},
		{"wary", "wari"},
		{"was", "was"},
		{"wasche", "wasch"},
		{"wash", "wash"},
		{"washed", "wash"},
		{"washerwoman", "washerwoman"},
		{"washery", "washeri"},
		{"washes", "wash"},
		{"washin", "washin"},
		{"washing", "wash"},
		{"washings", "wash"},
		{"wasn", "wasn"},
		{"wasp", "wasp"},
		{"waste", "wast"},
		{"wasted", "wast"},
		{"wasteful", "wast"},
		{"wastefulness", "wast"},
		{"wastes", "wast"},
		{"wasting", "wast"},
		{"wat", "wat"},
		{"watch", "watch"},
		{"watched", "watch"},
		{"watcher", "watcher"},
		{"watchers", "watcher"},
		{"watches", "watch"},
		{"watchful", "watch"},
		{"watchfully", "watch"},
		{"watchfulness", "watch"},
		{"watching", "watch"},
		{"watchings", "watch"},
		{"watchmaker", "watchmak"},
		{"watchman", "watchman"},
		{"watchmen", "watchmen"},
		{"water", "water"},
		{"watercourse", "watercours"},
		{"watered", "water"},
		{"waterfall", "waterfal"},
		{"waterfalls", "waterfal"},
		{"waterfloods", "waterflood"},
		{"waterfowl", "waterfowl"},
		{"waterhouse", "waterhous"},
		{"watering", "water"},
		{"waterloo", "waterloo"},
		{"waterproof", "waterproof"},
		{"waters", "water"},
		{"watershed", "watersh"},
		{"waterside", "watersid"},
		{"waterwheel", "waterwheel"},
		{"waterworn", "waterworn"},
		{"watery", "wateri"},
		{"wather", "wather"},
		{"watkins", "watkin"},
		{"watt", "watt"},
		{"watts", "watt"},
		{"wave", "wave"},
		{"waved", "wave"},
		{"wavered", "waver"},
		{"wavering", "waver"},
		{"waves", "wave"},
		{"waving", "wave"},
		{"wavy", "wavi"},
		{"wax", "wax"},
		{"waxed", "wax"},
		{"waxen", "waxen"},
		{"waxing", "wax"},
		{"waxy", "waxi"},
		{"way", "way"},
		{"wayfarer", "wayfar"},
		{"wayfarers", "wayfar"},
		{"waylaid", "waylaid"},
		{"waylay", "waylay"},
		{"ways", "way"},
		{"wayside", "waysid"},
		{"wayward", "wayward"},
		{"waywardness", "wayward"},
		{"we", "we"},
		{"weak", "weak"},
		{"weaken", "weaken"},
		{"weakened", "weaken"},
		{"weakening", "weaken"},
		{"weaker", "weaker"},
		{"weakest", "weakest"},
		{"weakly", "weak"},
		{"weakness", "weak"},
		{"weaknesses", "weak"},
		{"weals", "weal"},
		{"wealth", "wealth"},
		{"wealthy", "wealthi"},
		{"wean", "wean"},
		{"weaning", "wean"},
		{"weapon", "weapon"},
		{"weapons", "weapon"},
		{"wear", "wear"},
		{"wearer", "wearer"},
		{"wearers", "wearer"},
		{"wearied", "weari"},
		{"wearily", "wearili"},
		{"weariness", "weari"},
		{"wearing", "wear"},
		{"wearisome", "wearisom"},
		{"wears", "wear"},
		{"weary", "weari"},
		{"wearying", "weari"},
		{"weasen", "weasen"},
		{"weather", "weather"},
		{"weatherboard", "weatherboard"},
		{"weathercock", "weathercock"},
		{"weathered", "weather"},
		{"weathers", "weather"},
		{"weave", "weav"},
		{"weavers", "weaver"},
		{"weaving", "weav"},
		{"weazen", "weazen"},
		{"weazened", "weazen"},
		{"web", "web"},
		{"webb", "webb"},
		{"webbed", "web"},
		{"webs", "web"},
		{"webster", "webster"},
		{"wed", "wed"},
		{"wedded", "wed"},
		{"weddin", "weddin"},
		{"wedding", "wed"},
		{"weddings", "wed"},
		{"wedge", "wedg"},
		{"wedged", "wedg"},
		{"wedges", "wedg"},
		{"wedlock", "wedlock"},
		{"wednesday", "wednesday"},
		{"wednesdays", "wednesday"},
		{"weed", "weed"},
		{"weeding", "weed"},
		{"weeds", "weed"},
		{"weedur", "weedur"},
		{"weedy", "weedi"},
		{"week", "week"},
		{"weekly", "week"},
		{"weeks", "week"},
		{"weel", "weel"},
		{"weep", "weep"},
		{"weepers", "weeper"},
		{"weeping", "weep"},
		{"weeps", "weep"},
		{"weevle", "weevl"},
		{"wehr", "wehr"},
		{"weigh", "weigh"},
		{"weighed", "weigh"},
		{"weighing", "weigh"},
		{"weighs", "weigh"},
		{"weight", "weight"},
		{"weightily", "weightili"},
		{"weights", "weight"},
		{"weighty", "weighti"},
		{"weir", "weir"},
		{"weird", "weird"},
		{"weirs", "weir"},
		{"weise", "weis"},
		{"welcome", "welcom"},
		{"welcomed", "welcom"},
		{"welcomer", "welcom"},
		{"welcomes", "welcom"},
		{"welcoming", "welcom"},
		{"welfare", "welfar"},
		{"well", "well"},
		{"wellington", "wellington"},
		{"wells", "well"},
		{"welsh", "welsh"},
		{"weltering", "welter"},
		{"welveteen", "welveteen"},
		{"wen", "wen"},
		{"wench", "wench"},
		{"wenches", "wench"},
		{"wend", "wend"},
		{"wended", "wend"},
		{"wending", "wend"},
		{"wengeance", "wengeanc"},
		{"went", "went"},
		{"weobly", "weobli"},
		{"wepping", "wep"},
		{"wept", "wept"},
		{"wer", "wer"},
		{"were", "were"},
		{"weren", "weren"},
		{"werry", "werri"},
		{"wery", "weri"},
		{"wessel", "wessel"},
		{"west", "west"},
		{"westerly", "wester"},
		{"western", "western"},
		{"westminster", "westminst"},
		{"westmoreland", "westmoreland"},
		{"westward", "westward"},
		{"westwood", "westwood"},
		{"wet", "wet"},
		{"wets", "wet"},
		{"wetted", "wet"},
		{"wettest", "wettest"},
		{"wetting", "wet"},
		{"wexed", "wex"},
		{"wha", "wha"},
		{"whale", "whale"},
		{"whalebones", "whalebon"},
		{"whaler", "whaler"},
		{"whalers", "whaler"},
		{"whalery", "whaleri"},
		{"whales", "whale"},
		{"whaling", "whale"},
		{"wharf", "wharf"},
		{"wharton", "wharton"},
		{"whartons", "wharton"},
		{"wharves", "wharv"},
		{"what", "what"},
		{"whate", "whate"},
		{"whatever", "whatev"},
		{"whatsername", "whatsernam"},
		{"whatsoever", "whatsoev"},
		{"whe", "whe"},
		{"wheat", "wheat"},
		{"wheedled", "wheedl"},
		{"wheedlin", "wheedlin"},
		{"wheel", "wheel"},
		{"wheelbarrow", "wheelbarrow"},
		{"wheelbarrowful", "wheelbarrow"},
		{"wheeled", "wheel"},
		{"wheeling", "wheel"},
		{"wheels", "wheel"},
		{"wheelwright", "wheelwright"},
		{"wheeze", "wheez"},
		{"wheezing", "wheez"},
		{"when", "when"},
		{"whence", "whenc"},
		{"whenever", "whenev"},
		{"whensoever", "whensoev"},
		{"wher", "wher"},
		{"where", "where"},
		{"whereabout", "whereabout"},
		{"whereabouts", "whereabout"},
		{"whereas", "wherea"},
		{"whereat", "whereat"},
		{"whereby", "wherebi"},
		{"wherefore", "wherefor"},
		{"wherein", "wherein"},
		{"whereof", "whereof"},
		{"whereon", "whereon"},
		{"wheresoever", "wheresoev"},
		{"whereupon", "whereupon"},
		{"whereve", "wherev"},
		{"wherever", "wherev"},
		{"wherewith", "wherewith"},
		{"whet", "whet"},
		{"whethe", "wheth"},
		{"whether", "whether"},
		{"whew", "whew"},
		{"whey", "whey"},
		{"whic", "whic"},
		{"which", "which"},
		{"whichever", "whichev"},
		{"whichsoever", "whichsoev"},
		{"whiff", "whiff"},
		{"whig", "whig"},
		{"whigs", "whig"},
		{"while", "while"},
		{"whiles", "while"},
		{"whilst", "whilst"},
		{"whim", "whim"},
		{"whimper", "whimper"},
		{"whimpered", "whimper"},
		{"whimpering", "whimper"},
		{"whimpers", "whimper"},
		{"whims", "whim"},
		{"whimsical", "whimsic"},
		{"whimsically", "whimsic"},
		{"whined", "whine"},
		{"whines", "whine"},
		{"whining", "whine"},
		{"whinstone", "whinston"},
		{"whip", "whip"},
		{"whipcord", "whipcord"},
		{"whipped", "whip"},
		{"whipper", "whipper"},
		{"whipping", "whip"},
		{"whips", "whip"},
		{"whipster", "whipster"},
		{"whipt", "whipt"},
		{"whirl", "whirl"},
		{"whirled", "whirl"},
		{"whirling", "whirl"},
		{"whirlpool", "whirlpool"},
		{"whirls", "whirl"},
		{"whirlwind", "whirlwind"},
		{"whirr", "whirr"},
		{"whish", "whish"},
		{"whisk", "whisk"},
		{"whisked", "whisk"},
		{"whisker", "whisker"},
		{"whiskered", "whisker"},
		{"whiskers", "whisker"},
		{"whisking", "whisk"},
		{"whisky", "whiski"},
		{"whisper", "whisper"},
		{"whispered", "whisper"},
		{"whisperers", "whisper"},
		{"whispering", "whisper"},
		{"whisperings", "whisper"},
		{"whisperirig", "whisperirig"},
		{"whispers", "whisper"},
		{"whist", "whist"},
		{"whistle", "whistl"},
		{"whistled", "whistl"},
		{"whistles", "whistl"},
		{"whistling", "whistl"},
		{"whit", "whit"},
		{"white", "white"},
		{"whitechapel", "whitechapel"},
		{"whiteford", "whiteford"},
		{"whitefriars", "whitefriar"},
		{"whitened", "whiten"},
		{"whiteness", "white"},
		{"whitening", "whiten"},
		{"whiter", "whiter"},
		{"whites", "white"},
		{"whitest", "whitest"},
		{"whitewash", "whitewash"},
		{"whitewashed", "whitewash"},
		{"whitewashing", "whitewash"},
		{"whitey", "whitey"},
		{"whitford", "whitford"},
		{"whither", "whither"},
		{"whitish", "whitish"},
		{"whitsunday", "whitsunday"},
		{"whitsuntide", "whitsuntid"},
		{"whittington", "whittington"},
		{"whity", "whiti"},
		{"who", "who"},
		{"whoam", "whoam"},
		{"whoever", "whoever"},
		{"whol", "whol"},
		{"whole", "whole"},
		{"wholesale", "wholesal"},
		{"wholesome", "wholesom"},
		{"wholesomely", "wholesom"},
		{"wholesomer", "wholesom"},
		{"wholly", "wholli"},
		{"whom", "whom"},
		{"whomsoever", "whomsoev"},
		{"whoo", "whoo"},
		{"whooping", "whoop"},
		{"whoosh", "whoosh"},
		{"whose", "whose"},
		{"whosoever", "whosoev"},
		{"why", "whi"},
		{"whytorseller", "whytorsel"},
		{"wi", "wi"},
		{"wice", "wice"},
		{"wicious", "wicious"},
		{"wick", "wick"},
		{"wicked", "wick"},
		{"wickedest", "wickedest"},
		{"wickedly", "wick"},
		{"wickedness", "wicked"},
		{"wicker", "wicker"},
		{"wicket", "wicket"},
		{"wickham", "wickham"},
		{"widder", "widder"},
		{"wide", "wide"},
		{"widely", "wide"},
		{"widened", "widen"},
		{"wider", "wider"},
		{"widespread", "widespread"},
		{"widest", "widest"},
		{"widow", "widow"},
		{"widowed", "widow"},
		{"widower", "widow"},
		{"widowhood", "widowhood"},
		{"widows", "widow"},
		{"width", "width"},
		{"widths", "width"},
		{"wield", "wield"},
		{"wielded", "wield"},
		{"wife", "wife"},
		{"wig", "wig"},
		{"wight", "wight"},
		{"wiglomeration", "wiglomer"},
		{"wigmaker", "wigmak"},
		{"wigmore", "wigmor"},
		{"wigs", "wig"},
		{"wigwam", "wigwam"},
		{"wigwams", "wigwam"},
		{"wil", "wil"},
		{"wild", "wild"},
		{"wilder", "wilder"},
		{"wilderness", "wilder"},
		{"wildest", "wildest"},
		{"wildly", "wild"},
		{"wildness", "wild"},
		{"wile", "wile"},
		{"wiled", "wile"},
		{"wiles", "wile"},
		{"wilful", "wil"},
		{"wilfully", "wil"},
		{"wilfulness", "wil"},
		{"wilheim", "wilheim"},
		{"will", "will"},
		{"willage", "willag"},
		{"willed", "will"},
		{"william", "william"},
		{"williams", "william"},
		{"willin", "willin"},
		{"willing", "will"},
		{"willingiy", "willingiy"},
		{"willingly", "will"},
		{"willingness", "willing"},
		{"willinwodd", "willinwodd"},
		{"willl", "willl"},
		{"willow", "willow"},
		{"willows", "willow"},
		{"wills", "will"},
		{"willst", "willst"},
		{"willy", "willi"},
		{"wilmot", "wilmot"},
		{"wilson", "wilson"},
		{"wilt", "wilt"},
		{"wily", "wili"},
		{"win", "win"},
		{"winced", "winc"},
		{"winchester", "winchest"},
		{"wincing", "winc"},
		{"wind", "wind"},
		{"winded", "wind"},
		{"winder", "winder"},
		{"winders", "winder"},
		{"winding", "wind"},
		{"windings", "wind"},
		{"windlass", "windlass"},
		{"windmill", "windmil"},
		{"windmills", "windmil"},
		{"window", "window"},
		{"windowed", "window"},
		{"windows", "window"},
		{"windpipe", "windpip"},
		{"winds", "wind"},
		{"windsor", "windsor"},
		{"windward", "windward"},
		{"windy", "windi"},
		{"wine", "wine"},
		{"wineglassful", "wineglass"},
		{"wines", "wine"},
		{"wing", "wing"},
		{"winged", "wing"},
		{"wingfield", "wingfield"},
		{"wingless", "wingless"},
		{"wings", "wing"},
		{"wink", "wink"},
		{"winked", "wink"},
		{"winking", "wink"},
		{"winkles", "winkl"},
		{"winks", "wink"},
		{"winner", "winner"},
		{"winning", "win"},
		{"winnings", "win"},
		{"winnowing", "winnow"},
		{"wins", "win"},
		{"winter", "winter"},
		{"winters", "winter"},
		{"wintry", "wintri"},
		{"wiolinceller", "wiolincel"},
		{"wiolincellers", "wiolincel"},
		{"wipe", "wipe"},
		{"wiped", "wipe"},
		{"wipes", "wipe"},
		{"wiping", "wipe"},
		{"wire", "wire"},
		{"wires", "wire"},
		{"wiry", "wiri"},
		{"wis", "wis"},
		{"wisdom", "wisdom"},
		{"wise", "wise"},
		{"wisely", "wise"},
		{"wiser", "wiser"},
		{"wisest", "wisest"},
		{"wish", "wish"},
		{"wished", "wish"},
		{"wisher", "wisher"},
		{"wishermaydie", "wishermaydi"},
		{"wishes", "wish"},
		{"wishful", "wish"},
		{"wishing", "wish"},
		{"wisit", "wisit"},
		{"wisitation", "wisit"},
		{"wisitations", "wisit"},
		{"wisitin", "wisitin"},
		{"wisiting", "wisit"},
		{"wisk", "wisk"},
		{"wisp", "wisp"},
		{"wiss", "wiss"},
		{"wissen", "wissen"},
		{"wistful", "wist"},
		{"wistfully", "wist"},
		{"wit", "wit"},
		{"witch", "witch"},
		{"witchcraft", "witchcraft"},
		{"witchery", "witcheri"},
		{"witches", "witch"},
		{"with", "with"},
		{"withal", "withal"},
		{"withdraw", "withdraw"},
		{"withdrawal", "withdraw"},
		{"withdrawed", "withdraw"},
		{"withdrawing", "withdraw"},
		{"withdrawn", "withdrawn"},
		{"withdraws", "withdraw"},
		{"withdrew", "withdrew"},
		{"wither", "wither"},
		{"withered", "wither"},
		{"withering", "wither"},
		{"withers", "wither"},
		{"withheld", "withheld"},
		{"withhold", "withhold"},
		{"withi", "withi"},
		{"within", "within"},
		{"withou", "withou"},
		{"without", "without"},
		{"withstand", "withstand"},
		{"withstood", "withstood"},
		{"wititterly", "wititt"},
		{"wititterlys", "wititt"},
		{"witness", "wit"},
		{"witnessed", "wit"},
		{"witnesses", "wit"},
		{"witnessing", "wit"},
		{"wits", "wit"},
		{"witted", "wit"},
		{"witticism", "wittic"},
		{"witticisms", "wittic"},
		{"wittier", "wittier"},
		{"wittily", "wittili"},
		{"wittles", "wittl"},
		{"witty", "witti"},
		{"wives", "wive"},
		{"wizard", "wizard"},
		{"wizened", "wizen"},
		{"wlll", "wlll"},
		{"wo", "wo"},
		{"woa", "woa"},
		{"woe", "woe"},
		{"woebegone", "woebegon"},
		{"woeful", "woeful"},
		{"woes", "woe"},
		{"woful", "woful"},
		{"wofully", "wofulli"},
		{"woice", "woic"},
		{"woices", "woic"},
		{"woke", "woke"},
		{"wold", "wold"},
		{"wolds", "wold"},
		{"wolf", "wolf"},
		{"wolgan", "wolgan"},
		{"wollaston", "wollaston"},
		{"wolsey", "wolsey"},
		{"wolves", "wolv"},
		{"woman", "woman"},
		{"womanhood", "womanhood"},
		{"womanish", "womanish"},
		{"womankind", "womankind"},
		{"womanly", "woman"},
		{"women", "women"},
		{"won", "won"},
		{"wonder", "wonder"},
		{"wondered", "wonder"},
		{"wonderful", "wonder"},
		{"wonderfully", "wonder"},
		{"wondering", "wonder"},
		{"wonderingly", "wonder"},
		{"wonderment", "wonder"},
		{"wonders", "wonder"},
		{"wondrous", "wondrous"},
		{"wonld", "wonld"},
		{"wont", "wont"},
		{"wonted", "wont"},
		{"woo", "woo"},
		{"wood", "wood"},
		{"woodbine", "woodbin"},
		{"woodchips", "woodchip"},
		{"woodcot", "woodcot"},
		{"woodcourt", "woodcourt"},
		{"woodcut", "woodcut"},
		{"wooded", "wood"},
		{"wooden", "wooden"},
		{"woodland", "woodland"},
		{"woodlouse", "woodlous"},
		{"woodman", "woodman"},
		{"woodpecker", "woodpeck"},
		{"woods", "wood"},
		{"woodwork", "woodwork"},
		{"woody", "woodi"},
		{"wooed", "woo"},
		{"wool", "wool"},
		{"woolen", "woolen"},
		{"woollen", "woollen"},
		{"woolly", "woolli"},
		{"woollya", "woollya"},
		{"woolsack", "woolsack"},
		{"woolwich", "woolwich"},
		{"wooman", "wooman"},
		{"wor", "wor"},
		{"word", "word"},
		{"worded", "word"},
		{"wording", "word"},
		{"words", "word"},
		{"wordsworth", "wordsworth"},
		{"wordy", "wordi"},
		{"wore", "wore"},
		{"worid", "worid"},
		{"work", "work"},
		{"workaday", "workaday"},
		{"workbox", "workbox"},
		{"worked", "work"},
		{"worker", "worker"},
		{"workers", "worker"},
		{"workhouse", "workhous"},
		{"working", "work"},
		{"workings", "work"},
		{"workman", "workman"},
		{"workmanlike", "workmanlik"},
		{"workmanship", "workmanship"},
		{"workmen", "workmen"},
		{"workroom", "workroom"},
		{"works", "work"},
		{"workshop", "workshop"},
		{"workshops", "workshop"},
		{"world", "world"},
		{"worldliness", "worldli"},
		{"worldlings", "worldl"},
		{"worldly", "world"},
		{"worlds", "world"},
		{"worm", "worm"},
		{"worming", "worm"},
		{"worms", "worm"},
		{"wormwood", "wormwood"},
		{"worn", "worn"},
		{"worried", "worri"},
		{"worries", "worri"},
		{"worrit", "worrit"},
		{"worrited", "worrit"},
		{"worritted", "worrit"},
		{"worry", "worri"},
		{"worrying", "worri"},
		{"worse", "wors"},
		{"worship", "worship"},
		{"worshipped", "worship"},
		{"worshippers", "worshipp"},
		{"worships", "worship"},
		{"worst", "worst"},
		{"worsted", "worst"},
		{"worsteds", "worst"},
		{"worth", "worth"},
		{"worthbourne", "worthbourn"},
		{"worthier", "worthier"},
		{"worthies", "worthi"},
		{"worthily", "worthili"},
		{"worthless", "worthless"},
		{"worthlessness", "worthless"},
		{"worthwhile", "worthwhil"},
		{"worthy", "worthi"},
		{"wos", "wos"},
		{"wot", "wot"},
		{"woul", "woul"},
		{"would", "would"},
		{"wouldest", "wouldest"},
		{"wouldn", "wouldn"},
		{"wound", "wound"},
		{"wounded", "wound"},
		{"wounding", "wound"},
		{"wounds", "wound"},
		{"woven", "woven"},
		{"wow", "wow"},
		{"wows", "wow"},
		{"wrangerton", "wrangerton"},
		{"wrangle", "wrangl"},
		{"wrangling", "wrangl"},
		{"wrap", "wrap"},
		{"wrapped", "wrap"},
		{"wrapper", "wrapper"},
		{"wrappers", "wrapper"},
		{"wrapping", "wrap"},
		{"wrappings", "wrap"},
		{"wrapt", "wrapt"},
		{"wrath", "wrath"},
		{"wrathful", "wrath"},
		{"wrathfully", "wrath"},
		{"wreaked", "wreak"},
		{"wreaking", "wreak"},
		{"wreath", "wreath"},
		{"wreathed", "wreath"},
		{"wreathes", "wreath"},
		{"wreathing", "wreath"},
		{"wreaths", "wreath"},
		{"wreck", "wreck"},
		{"wrecked", "wreck"},
		{"wren", "wren"},
		{"wrench", "wrench"},
		{"wrenched", "wrench"},
		{"wrenching", "wrench"},
		{"wrens", "wren"},
		{"wrested", "wrest"},
		{"wresting", "wrest"},
		{"wrestle", "wrestl"},
		{"wrestling", "wrestl"},
		{"wretch", "wretch"},
		{"wretched", "wretch"},
		{"wretchedest", "wretchedest"},
		{"wretchedly", "wretch"},
		{"wretchedness", "wretched"},
		{"wretches", "wretch"},
		{"wriggling", "wriggl"},
		{"wring", "wring"},
		{"wringing", "wring"},
		{"wrings", "wring"},
		{"wrinkle", "wrinkl"},
		{"wrinkled", "wrinkl"},
		{"wrinkles", "wrinkl"},
		{"wrinkling", "wrinkl"},
		{"wrist", "wrist"},
		{"wristbands", "wristband"},
		{"wrists", "wrist"},
		{"writ", "writ"},
		{"write", "write"},
		{"writer", "writer"},
		{"writers", "writer"},
		{"writes", "write"},
		{"writhe", "writh"},
		{"writhed", "writh"},
		{"writhing", "writh"},
		{"writhings", "writh"},
		{"writin", "writin"},
		{"writing", "write"},
		{"writings", "write"},
		{"written", "written"},
		{"wrong", "wrong"},
		{"wrongdoing", "wrongdo"},
		{"wronged", "wrong"},
		{"wrongfully", "wrong"},
		{"wronging", "wrong"},
		{"wrongly", "wrong"},
		{"wrongs", "wrong"},
		{"wrote", "wrote"},
		{"wroth", "wroth"},
		{"wrought", "wrought"},
		{"wrung", "wrung"},
		{"wry", "wri"},
		{"wrymug", "wrymug"},
		{"wull", "wull"},
		{"wuns", "wun"},
		{"wunst", "wunst"},
		{"wur", "wur"},
		{"wurd", "wurd"},
		{"wye", "wye"},
		{"wyelands", "wyeland"},
		{"wyndham", "wyndham"},
		{"x", "x"},
		{"xi", "xi"},
		{"xii", "xii"},
		{"xiii", "xiii"},
		{"xiv", "xiv"},
		{"xix", "xix"},
		{"xl", "xl"},
		{"xli", "xli"},
		{"xlii", "xlii"},
		{"xliii", "xliii"},
		{"xliv", "xliv"},
		{"xlix", "xlix"},
		{"xlv", "xlv"},
		{"xlvi", "xlvi"},
		{"xlvii", "xlvii"},
		{"xlviii", "xlviii"},
		{"xv", "xv"},
		{"xvi", "xvi"},
		{"xvii", "xvii"},
		{"xviii", "xviii"},
		{"xx", "xx"},
		{"xxi", "xxi"},
		{"xxii", "xxii"},
		{"xxiii", "xxiii"},
		{"xxiv", "xxiv"},
		{"xxix", "xxix"},
		{"xxv", "xxv"},
		{"xxvi", "xxvi"},
		{"xxvii", "xxvii"},
		{"xxviii", "xxviii"},
		{"xxx", "xxx"},
		{"xxxi", "xxxi"},
		{"xxxii", "xxxii"},
		{"xxxiii", "xxxiii"},
		{"xxxiv", "xxxiv"},
		{"xxxix", "xxxix"},
		{"xxxv", "xxxv"},
		{"xxxvi", "xxxvi"},
		{"xxxvii", "xxxvii"},
		{"xxxviii", "xxxviii"},
		{"y", "y"},
		{"ya", "ya"},
		{"yacht", "yacht"},
		{"yachting", "yacht"},
		{"yagouaroundi", "yagouaroundi"},
		{"yam", "yam"},
		{"yammerschooner", "yammerschoon"},
		{"yammerschoonering", "yammerschoon"},
		{"yams", "yam"},
		{"yan", "yan"},
		{"yankee", "yanke"},
		{"yaquil", "yaquil"},
		{"yard", "yard"},
		{"yards", "yard"},
		{"yarn", "yarn"},
		{"yataghan", "yataghan"},
		{"yawl", "yawl"},
		{"yawn", "yawn"},
		{"yawned", "yawn"},
		{"yawning", "yawn"},
		{"yawns", "yawn"},
		{"ye", "ye"},
		{"yea", "yea"},
		{"year", "year"},
		{"yearly", "year"},
		{"yearned", "yearn"},
		{"yearning", "yearn"},
		{"yearnings", "yearn"},
		{"years", "year"},
		{"yegorovna", "yegorovna"},
		{"yell", "yell"},
		{"yelled", "yell"},
		{"yelling", "yell"},
		{"yellow", "yellow"},
		{"yellowed", "yellow"},
		{"yellower", "yellow"},
		{"yellowish", "yellowish"},
		{"yells", "yell"},
		{"yelping", "yelp"},
		{"yeoman", "yeoman"},
		{"yerba", "yerba"},
		{"yes", "yes"},
		{"yesday", "yesday"},
		{"yeso", "yeso"},
		{"yesterday", "yesterday"},
		{"yet", "yet"},
		{"yew", "yew"},
		{"yield", "yield"},
		{"yielded", "yield"},
		{"yielding", "yield"},
		{"yields", "yield"},
		{"yinder", "yinder"},
		{"yit", "yit"},
		{"yo", "yo"},
		{"yoke", "yoke"},
		{"yokes", "yoke"},
		{"yolk", "yolk"},
		{"yon", "yon"},
		{"yonder", "yonder"},
		{"yonge", "yong"},
		{"yoong", "yoong"},
		{"yoongster", "yoongster"},
		{"yore", "yore"},
		{"yorick", "yorick"},
		{"york", "york"},
		{"yorkshire", "yorkshir"},
		{"yorkshireman", "yorkshireman"},
		{"you", "you"},
		{"youn", "youn"},
		{"young", "young"},
		{"younger", "younger"},
		{"youngest", "youngest"},
		{"youngster", "youngster"},
		{"youngsters", "youngster"},
		{"your", "your"},
		{"yours", "your"},
		{"yourself", "yourself"},
		{"yourselves", "yourselv"},
		{"youth", "youth"},
		{"youthful", "youth"},
		{"youthfully", "youth"},
		{"youthfulness", "youth"},
		{"youths", "youth"},
		{"yquem", "yquem"},
		{"yseulte", "yseult"},
		{"yucca", "yucca"},
		{"yushin", "yushin"},
		{"yusupov", "yusupov"},
		{"z", "z"},
		{"zag", "zag"},
		{"zaharovitch", "zaharovitch"},
		{"zametov", "zametov"},
		{"zample", "zampl"},
		{"zaraisk", "zaraisk"},
		{"zaraisky", "zaraiski"},
		{"zarnitsyn", "zarnitsyn"},
		{"zeal", "zeal"},
		{"zealand", "zealand"},
		{"zealander", "zealand"},
		{"zealanders", "zealand"},
		{"zealous", "zealous"},
		{"zebras", "zebra"},
		{"zelandiae", "zelandia"},
		{"zelinda", "zelinda"},
		{"zenaida", "zenaida"},
		{"zenith", "zenith"},
		{"zest", "zest"},
		{"zeus", "zeus"},
		{"zig", "zig"},
		{"zigzag", "zigzag"},
		{"zigzags", "zigzag"},
		{"zimmerman", "zimmerman"},
		{"zone", "zone"},
		{"zones", "zone"},
		{"zonotrichia", "zonotrichia"},
		{"zoo", "zoo"},
		{"zoodle", "zoodl"},
		{"zooks", "zook"},
		{"zoolog", "zoolog"},
		{"zoological", "zoolog"},
		{"zoologically", "zoolog"},
		{"zoology", "zoolog"},
		{"zoophyt", "zoophyt"},
		{"zoophyte", "zoophyt"},
		{"zoophytes", "zoophyt"},
		{"zorillo", "zorillo"},
		{"zorillos", "zorillo"},
		{"zossimov", "zossimov"},
		{"zu", "zu"},
	}
	for _, testCase := range testCases {
		result := english.Stem(testCase.in, true)
		if result != testCase.out {
			t.Errorf("Expected %v -> %v, but got %v", testCase.in, testCase.out, result)
		}
	}
}
