// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/feature_online_store_service.proto

package aiplatformpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FeatureOnlineStoreService_FetchFeatureValues_FullMethodName          = "/google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService/FetchFeatureValues"
	FeatureOnlineStoreService_StreamingFetchFeatureValues_FullMethodName = "/google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService/StreamingFetchFeatureValues"
	FeatureOnlineStoreService_SearchNearestEntities_FullMethodName       = "/google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService/SearchNearestEntities"
	FeatureOnlineStoreService_FeatureViewDirectWrite_FullMethodName      = "/google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService/FeatureViewDirectWrite"
)

// FeatureOnlineStoreServiceClient is the client API for FeatureOnlineStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FeatureOnlineStoreServiceClient interface {
	// Fetch feature values under a FeatureView.
	FetchFeatureValues(ctx context.Context, in *FetchFeatureValuesRequest, opts ...grpc.CallOption) (*FetchFeatureValuesResponse, error)
	// Bidirectional streaming RPC to fetch feature values under a FeatureView.
	// Requests may not have a one-to-one mapping to responses and responses may
	// be returned out-of-order to reduce latency.
	StreamingFetchFeatureValues(ctx context.Context, opts ...grpc.CallOption) (FeatureOnlineStoreService_StreamingFetchFeatureValuesClient, error)
	// Search the nearest entities under a FeatureView.
	// Search only works for indexable feature view; if a feature view isn't
	// indexable, returns Invalid argument response.
	SearchNearestEntities(ctx context.Context, in *SearchNearestEntitiesRequest, opts ...grpc.CallOption) (*SearchNearestEntitiesResponse, error)
	// Bidirectional streaming RPC to directly write to feature values in a
	// feature view. Requests may not have a one-to-one mapping to responses and
	// responses may be returned out-of-order to reduce latency.
	FeatureViewDirectWrite(ctx context.Context, opts ...grpc.CallOption) (FeatureOnlineStoreService_FeatureViewDirectWriteClient, error)
}

type featureOnlineStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeatureOnlineStoreServiceClient(cc grpc.ClientConnInterface) FeatureOnlineStoreServiceClient {
	return &featureOnlineStoreServiceClient{cc}
}

func (c *featureOnlineStoreServiceClient) FetchFeatureValues(ctx context.Context, in *FetchFeatureValuesRequest, opts ...grpc.CallOption) (*FetchFeatureValuesResponse, error) {
	out := new(FetchFeatureValuesResponse)
	err := c.cc.Invoke(ctx, FeatureOnlineStoreService_FetchFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreServiceClient) StreamingFetchFeatureValues(ctx context.Context, opts ...grpc.CallOption) (FeatureOnlineStoreService_StreamingFetchFeatureValuesClient, error) {
	stream, err := c.cc.NewStream(ctx, &FeatureOnlineStoreService_ServiceDesc.Streams[0], FeatureOnlineStoreService_StreamingFetchFeatureValues_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &featureOnlineStoreServiceStreamingFetchFeatureValuesClient{stream}
	return x, nil
}

type FeatureOnlineStoreService_StreamingFetchFeatureValuesClient interface {
	Send(*StreamingFetchFeatureValuesRequest) error
	Recv() (*StreamingFetchFeatureValuesResponse, error)
	grpc.ClientStream
}

type featureOnlineStoreServiceStreamingFetchFeatureValuesClient struct {
	grpc.ClientStream
}

func (x *featureOnlineStoreServiceStreamingFetchFeatureValuesClient) Send(m *StreamingFetchFeatureValuesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *featureOnlineStoreServiceStreamingFetchFeatureValuesClient) Recv() (*StreamingFetchFeatureValuesResponse, error) {
	m := new(StreamingFetchFeatureValuesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *featureOnlineStoreServiceClient) SearchNearestEntities(ctx context.Context, in *SearchNearestEntitiesRequest, opts ...grpc.CallOption) (*SearchNearestEntitiesResponse, error) {
	out := new(SearchNearestEntitiesResponse)
	err := c.cc.Invoke(ctx, FeatureOnlineStoreService_SearchNearestEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreServiceClient) FeatureViewDirectWrite(ctx context.Context, opts ...grpc.CallOption) (FeatureOnlineStoreService_FeatureViewDirectWriteClient, error) {
	stream, err := c.cc.NewStream(ctx, &FeatureOnlineStoreService_ServiceDesc.Streams[1], FeatureOnlineStoreService_FeatureViewDirectWrite_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &featureOnlineStoreServiceFeatureViewDirectWriteClient{stream}
	return x, nil
}

type FeatureOnlineStoreService_FeatureViewDirectWriteClient interface {
	Send(*FeatureViewDirectWriteRequest) error
	Recv() (*FeatureViewDirectWriteResponse, error)
	grpc.ClientStream
}

type featureOnlineStoreServiceFeatureViewDirectWriteClient struct {
	grpc.ClientStream
}

func (x *featureOnlineStoreServiceFeatureViewDirectWriteClient) Send(m *FeatureViewDirectWriteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *featureOnlineStoreServiceFeatureViewDirectWriteClient) Recv() (*FeatureViewDirectWriteResponse, error) {
	m := new(FeatureViewDirectWriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FeatureOnlineStoreServiceServer is the server API for FeatureOnlineStoreService service.
// All implementations should embed UnimplementedFeatureOnlineStoreServiceServer
// for forward compatibility
type FeatureOnlineStoreServiceServer interface {
	// Fetch feature values under a FeatureView.
	FetchFeatureValues(context.Context, *FetchFeatureValuesRequest) (*FetchFeatureValuesResponse, error)
	// Bidirectional streaming RPC to fetch feature values under a FeatureView.
	// Requests may not have a one-to-one mapping to responses and responses may
	// be returned out-of-order to reduce latency.
	StreamingFetchFeatureValues(FeatureOnlineStoreService_StreamingFetchFeatureValuesServer) error
	// Search the nearest entities under a FeatureView.
	// Search only works for indexable feature view; if a feature view isn't
	// indexable, returns Invalid argument response.
	SearchNearestEntities(context.Context, *SearchNearestEntitiesRequest) (*SearchNearestEntitiesResponse, error)
	// Bidirectional streaming RPC to directly write to feature values in a
	// feature view. Requests may not have a one-to-one mapping to responses and
	// responses may be returned out-of-order to reduce latency.
	FeatureViewDirectWrite(FeatureOnlineStoreService_FeatureViewDirectWriteServer) error
}

// UnimplementedFeatureOnlineStoreServiceServer should be embedded to have forward compatible implementations.
type UnimplementedFeatureOnlineStoreServiceServer struct {
}

func (UnimplementedFeatureOnlineStoreServiceServer) FetchFeatureValues(context.Context, *FetchFeatureValuesRequest) (*FetchFeatureValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchFeatureValues not implemented")
}
func (UnimplementedFeatureOnlineStoreServiceServer) StreamingFetchFeatureValues(FeatureOnlineStoreService_StreamingFetchFeatureValuesServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingFetchFeatureValues not implemented")
}
func (UnimplementedFeatureOnlineStoreServiceServer) SearchNearestEntities(context.Context, *SearchNearestEntitiesRequest) (*SearchNearestEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchNearestEntities not implemented")
}
func (UnimplementedFeatureOnlineStoreServiceServer) FeatureViewDirectWrite(FeatureOnlineStoreService_FeatureViewDirectWriteServer) error {
	return status.Errorf(codes.Unimplemented, "method FeatureViewDirectWrite not implemented")
}

// UnsafeFeatureOnlineStoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FeatureOnlineStoreServiceServer will
// result in compilation errors.
type UnsafeFeatureOnlineStoreServiceServer interface {
	mustEmbedUnimplementedFeatureOnlineStoreServiceServer()
}

func RegisterFeatureOnlineStoreServiceServer(s grpc.ServiceRegistrar, srv FeatureOnlineStoreServiceServer) {
	s.RegisterService(&FeatureOnlineStoreService_ServiceDesc, srv)
}

func _FeatureOnlineStoreService_FetchFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreServiceServer).FetchFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureOnlineStoreService_FetchFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreServiceServer).FetchFeatureValues(ctx, req.(*FetchFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreService_StreamingFetchFeatureValues_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FeatureOnlineStoreServiceServer).StreamingFetchFeatureValues(&featureOnlineStoreServiceStreamingFetchFeatureValuesServer{stream})
}

type FeatureOnlineStoreService_StreamingFetchFeatureValuesServer interface {
	Send(*StreamingFetchFeatureValuesResponse) error
	Recv() (*StreamingFetchFeatureValuesRequest, error)
	grpc.ServerStream
}

type featureOnlineStoreServiceStreamingFetchFeatureValuesServer struct {
	grpc.ServerStream
}

func (x *featureOnlineStoreServiceStreamingFetchFeatureValuesServer) Send(m *StreamingFetchFeatureValuesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *featureOnlineStoreServiceStreamingFetchFeatureValuesServer) Recv() (*StreamingFetchFeatureValuesRequest, error) {
	m := new(StreamingFetchFeatureValuesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _FeatureOnlineStoreService_SearchNearestEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchNearestEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreServiceServer).SearchNearestEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureOnlineStoreService_SearchNearestEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreServiceServer).SearchNearestEntities(ctx, req.(*SearchNearestEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreService_FeatureViewDirectWrite_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FeatureOnlineStoreServiceServer).FeatureViewDirectWrite(&featureOnlineStoreServiceFeatureViewDirectWriteServer{stream})
}

type FeatureOnlineStoreService_FeatureViewDirectWriteServer interface {
	Send(*FeatureViewDirectWriteResponse) error
	Recv() (*FeatureViewDirectWriteRequest, error)
	grpc.ServerStream
}

type featureOnlineStoreServiceFeatureViewDirectWriteServer struct {
	grpc.ServerStream
}

func (x *featureOnlineStoreServiceFeatureViewDirectWriteServer) Send(m *FeatureViewDirectWriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *featureOnlineStoreServiceFeatureViewDirectWriteServer) Recv() (*FeatureViewDirectWriteRequest, error) {
	m := new(FeatureViewDirectWriteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FeatureOnlineStoreService_ServiceDesc is the grpc.ServiceDesc for FeatureOnlineStoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FeatureOnlineStoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService",
	HandlerType: (*FeatureOnlineStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchFeatureValues",
			Handler:    _FeatureOnlineStoreService_FetchFeatureValues_Handler,
		},
		{
			MethodName: "SearchNearestEntities",
			Handler:    _FeatureOnlineStoreService_SearchNearestEntities_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingFetchFeatureValues",
			Handler:       _FeatureOnlineStoreService_StreamingFetchFeatureValues_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "FeatureViewDirectWrite",
			Handler:       _FeatureOnlineStoreService_FeatureViewDirectWrite_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1beta1/feature_online_store_service.proto",
}
