// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/reasoning_engine.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ReasoningEngine configurations
type ReasoningEngineSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The service account that the Reasoning Engine artifact runs as.
	// It should have "roles/storage.objectViewer" for reading the user project's
	// Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
	// not specified, the Vertex AI Reasoning Engine Service Agent in the project
	// will be used.
	ServiceAccount *string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3,oneof" json:"service_account,omitempty"`
	// Optional. User provided package spec of the ReasoningEngine.
	// Ignored when users directly specify a deployment image through
	// `deployment_spec.first_party_image_override`, but keeping the
	// field_behavior to avoid introducing breaking changes.
	PackageSpec *ReasoningEngineSpec_PackageSpec `protobuf:"bytes,2,opt,name=package_spec,json=packageSpec,proto3" json:"package_spec,omitempty"`
	// Optional. The specification of a Reasoning Engine deployment.
	DeploymentSpec *ReasoningEngineSpec_DeploymentSpec `protobuf:"bytes,4,opt,name=deployment_spec,json=deploymentSpec,proto3" json:"deployment_spec,omitempty"`
	// Optional. Declarations for object class methods in OpenAPI specification
	// format.
	ClassMethods []*structpb.Struct `protobuf:"bytes,3,rep,name=class_methods,json=classMethods,proto3" json:"class_methods,omitempty"`
	// Optional. The OSS agent framework used to develop the agent.
	// Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
	// "llama-index", "custom".
	AgentFramework string `protobuf:"bytes,5,opt,name=agent_framework,json=agentFramework,proto3" json:"agent_framework,omitempty"`
}

func (x *ReasoningEngineSpec) Reset() {
	*x = ReasoningEngineSpec{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineSpec) ProtoMessage() {}

func (x *ReasoningEngineSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescGZIP(), []int{0}
}

func (x *ReasoningEngineSpec) GetServiceAccount() string {
	if x != nil && x.ServiceAccount != nil {
		return *x.ServiceAccount
	}
	return ""
}

func (x *ReasoningEngineSpec) GetPackageSpec() *ReasoningEngineSpec_PackageSpec {
	if x != nil {
		return x.PackageSpec
	}
	return nil
}

func (x *ReasoningEngineSpec) GetDeploymentSpec() *ReasoningEngineSpec_DeploymentSpec {
	if x != nil {
		return x.DeploymentSpec
	}
	return nil
}

func (x *ReasoningEngineSpec) GetClassMethods() []*structpb.Struct {
	if x != nil {
		return x.ClassMethods
	}
	return nil
}

func (x *ReasoningEngineSpec) GetAgentFramework() string {
	if x != nil {
		return x.AgentFramework
	}
	return ""
}

// ReasoningEngine provides a customizable runtime for models to determine
// which actions to take and in which order.
type ReasoningEngine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the ReasoningEngine.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the ReasoningEngine.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the ReasoningEngine.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Configurations of the ReasoningEngine
	Spec *ReasoningEngineSpec `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
	// Output only. Timestamp when this ReasoningEngine was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this ReasoningEngine was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Used to perform consistent read-modify-write updates. If not set,
	// a blind "overwrite" update happens.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// Customer-managed encryption key spec for a ReasoningEngine. If set, this
	// ReasoningEngine and all sub-resources of this ReasoningEngine will be
	// secured by this key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,11,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
}

func (x *ReasoningEngine) Reset() {
	*x = ReasoningEngine{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngine) ProtoMessage() {}

func (x *ReasoningEngine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngine.ProtoReflect.Descriptor instead.
func (*ReasoningEngine) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescGZIP(), []int{1}
}

func (x *ReasoningEngine) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReasoningEngine) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ReasoningEngine) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReasoningEngine) GetSpec() *ReasoningEngineSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *ReasoningEngine) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ReasoningEngine) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ReasoningEngine) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *ReasoningEngine) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

// User provided package spec like pickled object and package requirements.
type ReasoningEngineSpec_PackageSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Cloud Storage URI of the pickled python object.
	PickleObjectGcsUri string `protobuf:"bytes,1,opt,name=pickle_object_gcs_uri,json=pickleObjectGcsUri,proto3" json:"pickle_object_gcs_uri,omitempty"`
	// Optional. The Cloud Storage URI of the dependency files in tar.gz format.
	DependencyFilesGcsUri string `protobuf:"bytes,2,opt,name=dependency_files_gcs_uri,json=dependencyFilesGcsUri,proto3" json:"dependency_files_gcs_uri,omitempty"`
	// Optional. The Cloud Storage URI of the `requirements.txt` file
	RequirementsGcsUri string `protobuf:"bytes,3,opt,name=requirements_gcs_uri,json=requirementsGcsUri,proto3" json:"requirements_gcs_uri,omitempty"`
	// Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
	// If not specified, default value is 3.10.
	PythonVersion string `protobuf:"bytes,4,opt,name=python_version,json=pythonVersion,proto3" json:"python_version,omitempty"`
}

func (x *ReasoningEngineSpec_PackageSpec) Reset() {
	*x = ReasoningEngineSpec_PackageSpec{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineSpec_PackageSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineSpec_PackageSpec) ProtoMessage() {}

func (x *ReasoningEngineSpec_PackageSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineSpec_PackageSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineSpec_PackageSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ReasoningEngineSpec_PackageSpec) GetPickleObjectGcsUri() string {
	if x != nil {
		return x.PickleObjectGcsUri
	}
	return ""
}

func (x *ReasoningEngineSpec_PackageSpec) GetDependencyFilesGcsUri() string {
	if x != nil {
		return x.DependencyFilesGcsUri
	}
	return ""
}

func (x *ReasoningEngineSpec_PackageSpec) GetRequirementsGcsUri() string {
	if x != nil {
		return x.RequirementsGcsUri
	}
	return ""
}

func (x *ReasoningEngineSpec_PackageSpec) GetPythonVersion() string {
	if x != nil {
		return x.PythonVersion
	}
	return ""
}

// The specification of a Reasoning Engine deployment.
type ReasoningEngineSpec_DeploymentSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Environment variables to be set with the Reasoning Engine
	// deployment. The environment variables can be updated through the
	// UpdateReasoningEngine API.
	Env []*EnvVar `protobuf:"bytes,1,rep,name=env,proto3" json:"env,omitempty"`
	// Optional. Environment variables where the value is a secret in Cloud
	// Secret Manager.
	// To use this feature, add 'Secret Manager Secret Accessor' role
	// (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
	// Service Agent.
	SecretEnv []*SecretEnvVar `protobuf:"bytes,2,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
	// Optional. Configuration for PSC-I.
	PscInterfaceConfig *PscInterfaceConfig `protobuf:"bytes,4,opt,name=psc_interface_config,json=pscInterfaceConfig,proto3" json:"psc_interface_config,omitempty"`
	// Optional. The minimum number of application instances that will be kept
	// running at all times. Defaults to 1. Range: [0, 10].
	MinInstances *int32 `protobuf:"varint,5,opt,name=min_instances,json=minInstances,proto3,oneof" json:"min_instances,omitempty"`
	// Optional. The maximum number of application instances that can be
	// launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
	//
	// If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
	MaxInstances *int32 `protobuf:"varint,6,opt,name=max_instances,json=maxInstances,proto3,oneof" json:"max_instances,omitempty"`
	// Optional. Resource limits for each container. Only 'cpu' and 'memory'
	// keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
	//
	//   - The only supported values for CPU are '1', '2', '4', '6' and '8'. For
	//     more information, go to
	//     https://cloud.google.com/run/docs/configuring/cpu.
	//   - The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
	//   - For required cpu on different memory values, go to
	//     https://cloud.google.com/run/docs/configuring/memory-limits
	ResourceLimits map[string]string `protobuf:"bytes,7,rep,name=resource_limits,json=resourceLimits,proto3" json:"resource_limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Concurrency for each container and agent server. Recommended
	// value: 2 * cpu + 1. Defaults to 9.
	ContainerConcurrency *int32 `protobuf:"varint,8,opt,name=container_concurrency,json=containerConcurrency,proto3,oneof" json:"container_concurrency,omitempty"`
}

func (x *ReasoningEngineSpec_DeploymentSpec) Reset() {
	*x = ReasoningEngineSpec_DeploymentSpec{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineSpec_DeploymentSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineSpec_DeploymentSpec) ProtoMessage() {}

func (x *ReasoningEngineSpec_DeploymentSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineSpec_DeploymentSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineSpec_DeploymentSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetEnv() []*EnvVar {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetSecretEnv() []*SecretEnvVar {
	if x != nil {
		return x.SecretEnv
	}
	return nil
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetPscInterfaceConfig() *PscInterfaceConfig {
	if x != nil {
		return x.PscInterfaceConfig
	}
	return nil
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetMinInstances() int32 {
	if x != nil && x.MinInstances != nil {
		return *x.MinInstances
	}
	return 0
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetMaxInstances() int32 {
	if x != nil && x.MaxInstances != nil {
		return *x.MaxInstances
	}
	return 0
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetResourceLimits() map[string]string {
	if x != nil {
		return x.ResourceLimits
	}
	return nil
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetContainerConcurrency() int32 {
	if x != nil && x.ContainerConcurrency != nil {
		return *x.ContainerConcurrency
	}
	return 0
}

var File_google_cloud_aiplatform_v1_reasoning_engine_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xad, 0x0a, 0x0a, 0x13,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x31, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6c, 0x0a, 0x0f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x41, 0x0a, 0x0d, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x0f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0xe6, 0x01, 0x0a, 0x0b, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x36, 0x0a, 0x15, 0x70, 0x69,
	0x63, 0x6b, 0x6c, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12,
	0x70, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x47, 0x63, 0x73, 0x55,
	0x72, 0x69, 0x12, 0x3c, 0x0a, 0x18, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69,
	0x12, 0x35, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x2a, 0x0a, 0x0e, 0x70, 0x79, 0x74, 0x68, 0x6f,
	0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x1a, 0xa1, 0x05, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x39, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x65, 0x6e,
	0x76, 0x12, 0x4c, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x12,
	0x65, 0x0a, 0x14, 0x70, 0x73, 0x63, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x70, 0x73, 0x63, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x14, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x79, 0x88, 0x01, 0x01, 0x1a, 0x41, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6d, 0x69,
	0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x18, 0x0a,
	0x16, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd7, 0x04, 0x0a, 0x0f,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x73, 0x70, 0x65,
	0x63, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x53,
	0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x3a, 0x9f, 0x01, 0xea, 0x41, 0x9b, 0x01, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x7d, 0x2a, 0x10, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x73, 0x32, 0x0f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0xd2, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescData = file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_aiplatform_v1_reasoning_engine_proto_goTypes = []any{
	(*ReasoningEngineSpec)(nil),                // 0: google.cloud.aiplatform.v1.ReasoningEngineSpec
	(*ReasoningEngine)(nil),                    // 1: google.cloud.aiplatform.v1.ReasoningEngine
	(*ReasoningEngineSpec_PackageSpec)(nil),    // 2: google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
	(*ReasoningEngineSpec_DeploymentSpec)(nil), // 3: google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
	nil,                           // 4: google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.ResourceLimitsEntry
	(*structpb.Struct)(nil),       // 5: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil), // 6: google.protobuf.Timestamp
	(*EncryptionSpec)(nil),        // 7: google.cloud.aiplatform.v1.EncryptionSpec
	(*EnvVar)(nil),                // 8: google.cloud.aiplatform.v1.EnvVar
	(*SecretEnvVar)(nil),          // 9: google.cloud.aiplatform.v1.SecretEnvVar
	(*PscInterfaceConfig)(nil),    // 10: google.cloud.aiplatform.v1.PscInterfaceConfig
}
var file_google_cloud_aiplatform_v1_reasoning_engine_proto_depIdxs = []int32{
	2,  // 0: google.cloud.aiplatform.v1.ReasoningEngineSpec.package_spec:type_name -> google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
	3,  // 1: google.cloud.aiplatform.v1.ReasoningEngineSpec.deployment_spec:type_name -> google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
	5,  // 2: google.cloud.aiplatform.v1.ReasoningEngineSpec.class_methods:type_name -> google.protobuf.Struct
	0,  // 3: google.cloud.aiplatform.v1.ReasoningEngine.spec:type_name -> google.cloud.aiplatform.v1.ReasoningEngineSpec
	6,  // 4: google.cloud.aiplatform.v1.ReasoningEngine.create_time:type_name -> google.protobuf.Timestamp
	6,  // 5: google.cloud.aiplatform.v1.ReasoningEngine.update_time:type_name -> google.protobuf.Timestamp
	7,  // 6: google.cloud.aiplatform.v1.ReasoningEngine.encryption_spec:type_name -> google.cloud.aiplatform.v1.EncryptionSpec
	8,  // 7: google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.env:type_name -> google.cloud.aiplatform.v1.EnvVar
	9,  // 8: google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.secret_env:type_name -> google.cloud.aiplatform.v1.SecretEnvVar
	10, // 9: google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.psc_interface_config:type_name -> google.cloud.aiplatform.v1.PscInterfaceConfig
	4,  // 10: google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.resource_limits:type_name -> google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.ResourceLimitsEntry
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_reasoning_engine_proto_init() }
func file_google_cloud_aiplatform_v1_reasoning_engine_proto_init() {
	if File_google_cloud_aiplatform_v1_reasoning_engine_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1_env_var_proto_init()
	file_google_cloud_aiplatform_v1_service_networking_proto_init()
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes[3].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_reasoning_engine_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_reasoning_engine_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_reasoning_engine_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_reasoning_engine_proto = out.File
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_depIdxs = nil
}
