/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class AstraProtocolDecoder
extends BaseProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AstraProtocolDecoder.class);
    public static final int MSG_HEARTBEAT = 26;
    public static final int MSG_DATA = 16;

    public AstraProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        byte protocol = buf.readByte();
        buf.readUnsignedShort();
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])new byte[]{6}), remoteAddress));
        }
        return switch (protocol) {
            case 75 -> this.decodeK(channel, remoteAddress, buf);
            case 88 -> this.decodeX(channel, remoteAddress, buf);
            default -> null;
        };
    }

    private String readImei(ByteBuf buf) {
        return String.format("%08d", buf.readUnsignedInt()) + String.format("%07d", buf.readUnsignedMedium());
    }

    private Date readTime(ByteBuf buf) {
        DateBuilder dateBuilder = new DateBuilder().setDate(1980, 1, 6).addMillis(buf.readUnsignedInt() * 1000L);
        return dateBuilder.getDate();
    }

    private Object decodeK(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.readImei(buf));
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() > 2) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            buf.readUnsignedByte();
            position.setValid(true);
            position.setLatitude((double)buf.readInt() * 1.0E-6);
            position.setLongitude((double)buf.readInt() * 1.0E-6);
            position.setTime(this.readTime(buf));
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte() * 2));
            position.setCourse(buf.readUnsignedByte() * 2);
            int reason = buf.readUnsignedMedium();
            position.set("event", reason);
            int status = buf.readUnsignedShort();
            position.set("status", status);
            position.set("io1", buf.readUnsignedByte());
            position.set("adc1", buf.readUnsignedByte());
            position.set("battery", buf.readUnsignedByte());
            position.set("power", buf.readUnsignedByte());
            buf.readUnsignedByte();
            buf.skipBytes(6);
            position.set("tripOdometer", buf.readUnsignedShort());
            buf.readUnsignedShort();
            position.setAltitude(buf.readUnsignedByte() * 20);
            short quality = buf.readUnsignedByte();
            position.set("sat", quality & 0xF);
            position.set("rssi", quality >> 4);
            buf.readUnsignedByte();
            if (BitUtil.check(status, 8)) {
                position.set("driverUniqueId", buf.readSlice(7).toString(StandardCharsets.US_ASCII));
                position.set("odometer", buf.readUnsignedMedium() * 1000);
                position.set("hours", UnitsConverter.msFromHours(buf.readUnsignedShort()));
            }
            if (BitUtil.check(status, 6)) {
                LOGGER.warn("Extension data is not supported");
                return position;
            }
            positions.add(position);
        }
        return positions;
    }

    private Object decodeX(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        int count = buf.readUnsignedByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.readImei(buf));
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < count; ++i) {
            int j;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("index", buf.readUnsignedByte());
            long mask = ((long)buf.readUnsignedShort() << 32) + buf.readUnsignedInt();
            position.setDeviceTime(this.readTime(buf));
            position.set("event", buf.readUnsignedInt());
            position.set("status", buf.readUnsignedShort());
            if ((mask & 1L) > 0L) {
                position.set("power", (double)buf.readUnsignedByte() * 0.2);
                position.set("batteryLevel", buf.readUnsignedByte());
            }
            if ((mask & 2L) > 0L) {
                position.setValid(true);
                position.setFixTime(this.readTime(buf));
                position.setLatitude((double)buf.readInt() * 1.0E-6);
                position.setLongitude((double)buf.readInt() * 1.0E-6);
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte() * 2));
                buf.readUnsignedByte();
                position.setCourse(buf.readUnsignedByte() * 2);
                position.setAltitude(buf.readUnsignedByte() * 20);
                position.set("tripOdometer", buf.readUnsignedShort() * 100);
            } else {
                this.getLastLocation(position, position.getDeviceTime());
            }
            if ((mask & 4L) > 0L) {
                buf.readUnsignedShort();
                buf.readUnsignedShort();
            }
            if ((mask & 8L) > 0L) {
                buf.readUnsignedShort();
                buf.readUnsignedShort();
            }
            if ((mask & 0x10L) > 0L) {
                position.set("xMax", buf.readByte());
                position.set("xMin", buf.readByte());
                position.set("yMax", buf.readByte());
                position.set("yMin", buf.readByte());
                position.set("zMax", buf.readByte());
                position.set("zMin", buf.readByte());
                position.set("idleHours", buf.readUnsignedShort());
            }
            if ((mask & 0x20L) > 0L) {
                short value = buf.readUnsignedByte();
                position.set("sat", BitUtil.to(value, 4));
                position.set("rssi", BitUtil.from(value, 4));
            }
            if ((mask & 0x40L) > 0L) {
                buf.readUnsignedShort();
                buf.readUnsignedShort();
            }
            if ((mask & 0x80L) > 0L) {
                buf.readUnsignedByte();
            }
            if ((mask & 0x100L) > 0L) {
                buf.readUnsignedByte();
                buf.readLong();
            }
            if ((mask & 0x200L) > 0L) {
                buf.readUnsignedByte();
                buf.skipBytes(10);
                buf.readUnsignedByte();
            }
            if ((mask & 0x400L) > 0L) {
                position.set("axleWeight", buf.readUnsignedShort());
            }
            if ((mask & 0x800L) > 0L) {
                position.set("odometer", buf.readUnsignedMedium() * 1000);
                position.set("hours", buf.readUnsignedShort() * 3600000);
            }
            if ((mask & 0x1000L) > 0L) {
                position.set("wheelSpeedMax", buf.readUnsignedByte());
                position.set("wheelSpeedAvg", buf.readUnsignedByte());
                position.set("rpmMax", buf.readUnsignedByte() * 32);
                position.set("rpmAvg", buf.readUnsignedByte() * 32);
                position.set("acceleratorMax", buf.readUnsignedByte());
                position.set("acceleratorAvg", buf.readUnsignedByte());
                position.set("engineLoadMax", buf.readUnsignedByte());
                position.set("engineLoadAvg", buf.readUnsignedByte());
                position.set("tripOdometer", buf.readUnsignedShort() * 100);
                position.set("coolantTemp", buf.readByte() + 40);
                position.set("fmsStatus", buf.readUnsignedShort());
                position.set("fmsEvents", buf.readUnsignedShort());
                position.set("fuel", buf.readUnsignedByte());
                position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.5);
            }
            if ((mask & 0x2000L) > 0L) {
                position.set("wheelSpeedMax", buf.readUnsignedByte());
                position.set("wheelSpeedAvg", buf.readUnsignedByte());
                position.set("rpmMax", buf.readUnsignedByte() * 32);
                position.set("rpmAvg", buf.readUnsignedByte() * 32);
                position.set("acceleratorMax", buf.readUnsignedByte());
                position.set("acceleratorAvg", buf.readUnsignedByte());
                position.set("engineLoadMax", buf.readUnsignedByte());
                position.set("engineLoadAvg", buf.readUnsignedByte());
                position.set("tripOdometer", buf.readUnsignedShort() * 100);
                position.set("coolantTemp", buf.readByte() + 40);
                position.set("obdStatus", buf.readUnsignedShort());
                position.set("obdEvents", buf.readUnsignedShort());
                position.set("fuel", buf.readUnsignedByte());
                position.set("fuelUsed", (double)buf.readUnsignedShort() * 0.1);
            }
            if ((mask & 0x4000L) > 0L) {
                for (j = 1; j <= 5; ++j) {
                    position.set("dtc" + j, buf.readCharSequence(5, StandardCharsets.US_ASCII).toString());
                }
            }
            if ((mask & 0x8000L) > 0L) {
                position.set("odometer", buf.readUnsignedMedium() * 1000);
                position.set("hours", buf.readUnsignedShort() * 3600000);
                position.set("axleWeight", buf.readUnsignedShort());
                position.set("tripFuelUsed", (double)buf.readUnsignedShort() * 0.1);
                position.set("tripCruise", buf.readUnsignedShort());
                position.set("serviceOdometer", buf.readUnsignedShort() * 5);
            }
            if ((mask & 0x10000L) > 0L) {
                position.set("odometer", buf.readUnsignedMedium() * 1000);
                position.set("hours", buf.readUnsignedShort() * 3600000);
                buf.readUnsignedShort();
                buf.readUnsignedShort();
            }
            if ((mask & 0x20000L) > 0L) {
                for (j = 1; j <= 6; ++j) {
                    position.set("temp" + j, (double)buf.readShort() * 0.1);
                }
                for (j = 1; j <= 3; ++j) {
                    position.set("setpoint" + j, (double)buf.readByte() * 0.5);
                }
                buf.readUnsignedByte();
                buf.readUnsignedShort();
                buf.readUnsignedShort();
                buf.readUnsignedShort();
                buf.readUnsignedMedium();
            }
            if ((mask & 0x40000L) > 0L) {
                for (j = 1; j <= 4; ++j) {
                    position.set("temp" + j, (double)(buf.readUnsignedShort() - 550) * 0.1);
                }
            }
            if ((mask & 0x80000L) > 0L) {
                position.set("alarmCount", buf.readUnsignedByte());
                position.set("alarmQueue", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(16)));
            }
            if ((mask & 0x100000000L) > 0L) {
                for (j = 1; j <= 6; ++j) {
                    position.set("sensor" + j, buf.readUnsignedMedium());
                }
            }
            positions.add(position);
        }
        return positions;
    }
}

