package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WithdrawVpcPublishedRouteEntries invokes the vpc.WithdrawVpcPublishedRouteEntries API synchronously
func (client *Client) WithdrawVpcPublishedRouteEntries(request *WithdrawVpcPublishedRouteEntriesRequest) (response *WithdrawVpcPublishedRouteEntriesResponse, err error) {
	response = CreateWithdrawVpcPublishedRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// WithdrawVpcPublishedRouteEntriesWithChan invokes the vpc.WithdrawVpcPublishedRouteEntries API asynchronously
func (client *Client) WithdrawVpcPublishedRouteEntriesWithChan(request *WithdrawVpcPublishedRouteEntriesRequest) (<-chan *WithdrawVpcPublishedRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *WithdrawVpcPublishedRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WithdrawVpcPublishedRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WithdrawVpcPublishedRouteEntriesWithCallback invokes the vpc.WithdrawVpcPublishedRouteEntries API asynchronously
func (client *Client) WithdrawVpcPublishedRouteEntriesWithCallback(request *WithdrawVpcPublishedRouteEntriesRequest, callback func(response *WithdrawVpcPublishedRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WithdrawVpcPublishedRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.WithdrawVpcPublishedRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WithdrawVpcPublishedRouteEntriesRequest is the request struct for api WithdrawVpcPublishedRouteEntries
type WithdrawVpcPublishedRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                                `position:"Query" name:"ResourceOwnerId"`
	TargetType           string                                          `position:"Query" name:"TargetType"`
	DryRun               requests.Boolean                                `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string                                          `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                          `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                                `position:"Query" name:"OwnerId"`
	TargetInstanceId     string                                          `position:"Query" name:"TargetInstanceId"`
	RouteEntries         *[]WithdrawVpcPublishedRouteEntriesRouteEntries `position:"Query" name:"RouteEntries"  type:"Repeated"`
}

// WithdrawVpcPublishedRouteEntriesRouteEntries is a repeated param struct in WithdrawVpcPublishedRouteEntriesRequest
type WithdrawVpcPublishedRouteEntriesRouteEntries struct {
	RouteTableId         string `name:"RouteTableId"`
	DestinationCidrBlock string `name:"DestinationCidrBlock"`
}

// WithdrawVpcPublishedRouteEntriesResponse is the response struct for api WithdrawVpcPublishedRouteEntries
type WithdrawVpcPublishedRouteEntriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateWithdrawVpcPublishedRouteEntriesRequest creates a request to invoke WithdrawVpcPublishedRouteEntries API
func CreateWithdrawVpcPublishedRouteEntriesRequest() (request *WithdrawVpcPublishedRouteEntriesRequest) {
	request = &WithdrawVpcPublishedRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "WithdrawVpcPublishedRouteEntries", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWithdrawVpcPublishedRouteEntriesResponse creates a response to parse from WithdrawVpcPublishedRouteEntries response
func CreateWithdrawVpcPublishedRouteEntriesResponse() (response *WithdrawVpcPublishedRouteEntriesResponse) {
	response = &WithdrawVpcPublishedRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
