package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGeographicSubRegions invokes the vpc.ListGeographicSubRegions API synchronously
func (client *Client) ListGeographicSubRegions(request *ListGeographicSubRegionsRequest) (response *ListGeographicSubRegionsResponse, err error) {
	response = CreateListGeographicSubRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListGeographicSubRegionsWithChan invokes the vpc.ListGeographicSubRegions API asynchronously
func (client *Client) ListGeographicSubRegionsWithChan(request *ListGeographicSubRegionsRequest) (<-chan *ListGeographicSubRegionsResponse, <-chan error) {
	responseChan := make(chan *ListGeographicSubRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGeographicSubRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGeographicSubRegionsWithCallback invokes the vpc.ListGeographicSubRegions API asynchronously
func (client *Client) ListGeographicSubRegionsWithCallback(request *ListGeographicSubRegionsRequest, callback func(response *ListGeographicSubRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGeographicSubRegionsResponse
		var err error
		defer close(result)
		response, err = client.ListGeographicSubRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGeographicSubRegionsRequest is the request struct for api ListGeographicSubRegions
type ListGeographicSubRegionsRequest struct {
	*requests.RpcRequest
	GeographicRegionId string `position:"Query" name:"GeographicRegionId"`
}

// ListGeographicSubRegionsResponse is the response struct for api ListGeographicSubRegions
type ListGeographicSubRegionsResponse struct {
	*responses.BaseResponse
	RequestId            string   `json:"RequestId" xml:"RequestId"`
	Count                int64    `json:"Count" xml:"Count"`
	GeographicSubRegions []string `json:"GeographicSubRegions" xml:"GeographicSubRegions"`
}

// CreateListGeographicSubRegionsRequest creates a request to invoke ListGeographicSubRegions API
func CreateListGeographicSubRegionsRequest() (request *ListGeographicSubRegionsRequest) {
	request = &ListGeographicSubRegionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListGeographicSubRegions", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGeographicSubRegionsResponse creates a response to parse from ListGeographicSubRegions response
func CreateListGeographicSubRegionsResponse() (response *ListGeographicSubRegionsResponse) {
	response = &ListGeographicSubRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
