package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpv6Gateways invokes the vpc.DescribeIpv6Gateways API synchronously
func (client *Client) DescribeIpv6Gateways(request *DescribeIpv6GatewaysRequest) (response *DescribeIpv6GatewaysResponse, err error) {
	response = CreateDescribeIpv6GatewaysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpv6GatewaysWithChan invokes the vpc.DescribeIpv6Gateways API asynchronously
func (client *Client) DescribeIpv6GatewaysWithChan(request *DescribeIpv6GatewaysRequest) (<-chan *DescribeIpv6GatewaysResponse, <-chan error) {
	responseChan := make(chan *DescribeIpv6GatewaysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpv6Gateways(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpv6GatewaysWithCallback invokes the vpc.DescribeIpv6Gateways API asynchronously
func (client *Client) DescribeIpv6GatewaysWithCallback(request *DescribeIpv6GatewaysRequest, callback func(response *DescribeIpv6GatewaysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpv6GatewaysResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpv6Gateways(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpv6GatewaysRequest is the request struct for api DescribeIpv6Gateways
type DescribeIpv6GatewaysRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer            `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer            `position:"Query" name:"PageNumber"`
	ResourceGroupId      string                      `position:"Query" name:"ResourceGroupId"`
	PageSize             requests.Integer            `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string                      `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                      `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer            `position:"Query" name:"OwnerId"`
	Tags                 *[]DescribeIpv6GatewaysTags `position:"Query" name:"Tags"  type:"Repeated"`
	VpcId                string                      `position:"Query" name:"VpcId"`
	Ipv6GatewayId        string                      `position:"Query" name:"Ipv6GatewayId"`
	Name                 string                      `position:"Query" name:"Name"`
}

// DescribeIpv6GatewaysTags is a repeated param struct in DescribeIpv6GatewaysRequest
type DescribeIpv6GatewaysTags struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeIpv6GatewaysResponse is the response struct for api DescribeIpv6Gateways
type DescribeIpv6GatewaysResponse struct {
	*responses.BaseResponse
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	Ipv6Gateways Ipv6Gateways `json:"Ipv6Gateways" xml:"Ipv6Gateways"`
}

// CreateDescribeIpv6GatewaysRequest creates a request to invoke DescribeIpv6Gateways API
func CreateDescribeIpv6GatewaysRequest() (request *DescribeIpv6GatewaysRequest) {
	request = &DescribeIpv6GatewaysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeIpv6Gateways", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIpv6GatewaysResponse creates a response to parse from DescribeIpv6Gateways response
func CreateDescribeIpv6GatewaysResponse() (response *DescribeIpv6GatewaysResponse) {
	response = &DescribeIpv6GatewaysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
