package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpcGatewayEndpoint invokes the vpc.CreateVpcGatewayEndpoint API synchronously
func (client *Client) CreateVpcGatewayEndpoint(request *CreateVpcGatewayEndpointRequest) (response *CreateVpcGatewayEndpointResponse, err error) {
	response = CreateCreateVpcGatewayEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpcGatewayEndpointWithChan invokes the vpc.CreateVpcGatewayEndpoint API asynchronously
func (client *Client) CreateVpcGatewayEndpointWithChan(request *CreateVpcGatewayEndpointRequest) (<-chan *CreateVpcGatewayEndpointResponse, <-chan error) {
	responseChan := make(chan *CreateVpcGatewayEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpcGatewayEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpcGatewayEndpointWithCallback invokes the vpc.CreateVpcGatewayEndpoint API asynchronously
func (client *Client) CreateVpcGatewayEndpointWithCallback(request *CreateVpcGatewayEndpointRequest, callback func(response *CreateVpcGatewayEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpcGatewayEndpointResponse
		var err error
		defer close(result)
		response, err = client.CreateVpcGatewayEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpcGatewayEndpointRequest is the request struct for api CreateVpcGatewayEndpoint
type CreateVpcGatewayEndpointRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer               `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string                         `position:"Query" name:"ClientToken"`
	ResourceGroupId      string                         `position:"Query" name:"ResourceGroupId"`
	ServiceName          string                         `position:"Query" name:"ServiceName"`
	Tag                  *[]CreateVpcGatewayEndpointTag `position:"Query" name:"Tag"  type:"Repeated"`
	DryRun               requests.Boolean               `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string                         `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                         `position:"Query" name:"OwnerAccount"`
	EndpointDescription  string                         `position:"Query" name:"EndpointDescription"`
	OwnerId              requests.Integer               `position:"Query" name:"OwnerId"`
	VpcId                string                         `position:"Query" name:"VpcId"`
	EndpointName         string                         `position:"Query" name:"EndpointName"`
	PolicyDocument       string                         `position:"Query" name:"PolicyDocument"`
}

// CreateVpcGatewayEndpointTag is a repeated param struct in CreateVpcGatewayEndpointRequest
type CreateVpcGatewayEndpointTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateVpcGatewayEndpointResponse is the response struct for api CreateVpcGatewayEndpoint
type CreateVpcGatewayEndpointResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	EndpointId      string `json:"EndpointId" xml:"EndpointId"`
	ServiceName     string `json:"ServiceName" xml:"ServiceName"`
	EndpointName    string `json:"EndpointName" xml:"EndpointName"`
	CreationTime    string `json:"CreationTime" xml:"CreationTime"`
	ResourceGroupId string `json:"ResourceGroupId" xml:"ResourceGroupId"`
}

// CreateCreateVpcGatewayEndpointRequest creates a request to invoke CreateVpcGatewayEndpoint API
func CreateCreateVpcGatewayEndpointRequest() (request *CreateVpcGatewayEndpointRequest) {
	request = &CreateVpcGatewayEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateVpcGatewayEndpoint", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpcGatewayEndpointResponse creates a response to parse from CreateVpcGatewayEndpoint response
func CreateCreateVpcGatewayEndpointResponse() (response *CreateVpcGatewayEndpointResponse) {
	response = &CreateVpcGatewayEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
