package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateIpv6Address invokes the vpc.AllocateIpv6Address API synchronously
func (client *Client) AllocateIpv6Address(request *AllocateIpv6AddressRequest) (response *AllocateIpv6AddressResponse, err error) {
	response = CreateAllocateIpv6AddressResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateIpv6AddressWithChan invokes the vpc.AllocateIpv6Address API asynchronously
func (client *Client) AllocateIpv6AddressWithChan(request *AllocateIpv6AddressRequest) (<-chan *AllocateIpv6AddressResponse, <-chan error) {
	responseChan := make(chan *AllocateIpv6AddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateIpv6Address(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateIpv6AddressWithCallback invokes the vpc.AllocateIpv6Address API asynchronously
func (client *Client) AllocateIpv6AddressWithCallback(request *AllocateIpv6AddressRequest, callback func(response *AllocateIpv6AddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateIpv6AddressResponse
		var err error
		defer close(result)
		response, err = client.AllocateIpv6Address(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateIpv6AddressRequest is the request struct for api AllocateIpv6Address
type AllocateIpv6AddressRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer          `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string                    `position:"Query" name:"ClientToken"`
	Ipv6AddressDescription string                    `position:"Query" name:"Ipv6AddressDescription"`
	ResourceGroupId        string                    `position:"Query" name:"ResourceGroupId"`
	AddressType            string                    `position:"Query" name:"AddressType"`
	Tag                    *[]AllocateIpv6AddressTag `position:"Query" name:"Tag"  type:"Repeated"`
	Ipv6AddressName        string                    `position:"Query" name:"Ipv6AddressName"`
	DryRun                 requests.Boolean          `position:"Query" name:"DryRun"`
	ResourceOwnerAccount   string                    `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string                    `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer          `position:"Query" name:"OwnerId"`
	VSwitchId              string                    `position:"Query" name:"VSwitchId"`
	Ipv6Address            string                    `position:"Query" name:"Ipv6Address"`
}

// AllocateIpv6AddressTag is a repeated param struct in AllocateIpv6AddressRequest
type AllocateIpv6AddressTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// AllocateIpv6AddressResponse is the response struct for api AllocateIpv6Address
type AllocateIpv6AddressResponse struct {
	*responses.BaseResponse
	Ipv6AddressId   string `json:"Ipv6AddressId" xml:"Ipv6AddressId"`
	Ipv6Address     string `json:"Ipv6Address" xml:"Ipv6Address"`
	ResourceGroupId string `json:"ResourceGroupId" xml:"ResourceGroupId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateIpv6AddressRequest creates a request to invoke AllocateIpv6Address API
func CreateAllocateIpv6AddressRequest() (request *AllocateIpv6AddressRequest) {
	request = &AllocateIpv6AddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AllocateIpv6Address", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAllocateIpv6AddressResponse creates a response to parse from AllocateIpv6Address response
func CreateAllocateIpv6AddressResponse() (response *AllocateIpv6AddressResponse) {
	response = &AllocateIpv6AddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
