package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMediaStorageClass invokes the vod.UpdateMediaStorageClass API synchronously
func (client *Client) UpdateMediaStorageClass(request *UpdateMediaStorageClassRequest) (response *UpdateMediaStorageClassResponse, err error) {
	response = CreateUpdateMediaStorageClassResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMediaStorageClassWithChan invokes the vod.UpdateMediaStorageClass API asynchronously
func (client *Client) UpdateMediaStorageClassWithChan(request *UpdateMediaStorageClassRequest) (<-chan *UpdateMediaStorageClassResponse, <-chan error) {
	responseChan := make(chan *UpdateMediaStorageClassResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMediaStorageClass(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMediaStorageClassWithCallback invokes the vod.UpdateMediaStorageClass API asynchronously
func (client *Client) UpdateMediaStorageClassWithCallback(request *UpdateMediaStorageClassRequest, callback func(response *UpdateMediaStorageClassResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMediaStorageClassResponse
		var err error
		defer close(result)
		response, err = client.UpdateMediaStorageClass(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMediaStorageClassRequest is the request struct for api UpdateMediaStorageClass
type UpdateMediaStorageClassRequest struct {
	*requests.RpcRequest
	RestoreTier                 string           `position:"Query" name:"RestoreTier"`
	Scope                       string           `position:"Query" name:"Scope"`
	MediaIds                    string           `position:"Query" name:"MediaIds"`
	StorageClass                string           `position:"Query" name:"StorageClass"`
	AllowUpdateWithoutTimeLimit requests.Boolean `position:"Query" name:"AllowUpdateWithoutTimeLimit"`
}

// UpdateMediaStorageClassResponse is the response struct for api UpdateMediaStorageClass
type UpdateMediaStorageClassResponse struct {
	*responses.BaseResponse
	RequestId     string                                 `json:"RequestId" xml:"RequestId"`
	Status        string                                 `json:"Status" xml:"Status"`
	IgnoredList   IgnoredListInUpdateMediaStorageClass   `json:"IgnoredList" xml:"IgnoredList"`
	ForbiddenList ForbiddenListInUpdateMediaStorageClass `json:"ForbiddenList" xml:"ForbiddenList"`
}

// CreateUpdateMediaStorageClassRequest creates a request to invoke UpdateMediaStorageClass API
func CreateUpdateMediaStorageClassRequest() (request *UpdateMediaStorageClassRequest) {
	request = &UpdateMediaStorageClassRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateMediaStorageClass", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMediaStorageClassResponse creates a response to parse from UpdateMediaStorageClass response
func CreateUpdateMediaStorageClassResponse() (response *UpdateMediaStorageClassResponse) {
	response = &UpdateMediaStorageClassResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
