package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDailyPlayRegionStatis invokes the vod.GetDailyPlayRegionStatis API synchronously
func (client *Client) GetDailyPlayRegionStatis(request *GetDailyPlayRegionStatisRequest) (response *GetDailyPlayRegionStatisResponse, err error) {
	response = CreateGetDailyPlayRegionStatisResponse()
	err = client.DoAction(request, response)
	return
}

// GetDailyPlayRegionStatisWithChan invokes the vod.GetDailyPlayRegionStatis API asynchronously
func (client *Client) GetDailyPlayRegionStatisWithChan(request *GetDailyPlayRegionStatisRequest) (<-chan *GetDailyPlayRegionStatisResponse, <-chan error) {
	responseChan := make(chan *GetDailyPlayRegionStatisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDailyPlayRegionStatis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDailyPlayRegionStatisWithCallback invokes the vod.GetDailyPlayRegionStatis API asynchronously
func (client *Client) GetDailyPlayRegionStatisWithCallback(request *GetDailyPlayRegionStatisRequest, callback func(response *GetDailyPlayRegionStatisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDailyPlayRegionStatisResponse
		var err error
		defer close(result)
		response, err = client.GetDailyPlayRegionStatis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDailyPlayRegionStatisRequest is the request struct for api GetDailyPlayRegionStatis
type GetDailyPlayRegionStatisRequest struct {
	*requests.RpcRequest
	Date        string `position:"Query" name:"Date"`
	MediaRegion string `position:"Query" name:"MediaRegion"`
}

// GetDailyPlayRegionStatisResponse is the response struct for api GetDailyPlayRegionStatis
type GetDailyPlayRegionStatisResponse struct {
	*responses.BaseResponse
	RequestId                 string                        `json:"RequestId" xml:"RequestId"`
	FailDates                 []string                      `json:"FailDates" xml:"FailDates"`
	EmptyDates                []string                      `json:"EmptyDates" xml:"EmptyDates"`
	DailyPlayRegionStatisList []DailyPlayRegionStatisFileDO `json:"DailyPlayRegionStatisList" xml:"DailyPlayRegionStatisList"`
}

// CreateGetDailyPlayRegionStatisRequest creates a request to invoke GetDailyPlayRegionStatis API
func CreateGetDailyPlayRegionStatisRequest() (request *GetDailyPlayRegionStatisRequest) {
	request = &GetDailyPlayRegionStatisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetDailyPlayRegionStatis", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDailyPlayRegionStatisResponse creates a response to parse from GetDailyPlayRegionStatis response
func CreateGetDailyPlayRegionStatisResponse() (response *GetDailyPlayRegionStatisResponse) {
	response = &GetDailyPlayRegionStatisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
