package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodTieringStorageData invokes the vod.DescribeVodTieringStorageData API synchronously
func (client *Client) DescribeVodTieringStorageData(request *DescribeVodTieringStorageDataRequest) (response *DescribeVodTieringStorageDataResponse, err error) {
	response = CreateDescribeVodTieringStorageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodTieringStorageDataWithChan invokes the vod.DescribeVodTieringStorageData API asynchronously
func (client *Client) DescribeVodTieringStorageDataWithChan(request *DescribeVodTieringStorageDataRequest) (<-chan *DescribeVodTieringStorageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodTieringStorageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodTieringStorageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodTieringStorageDataWithCallback invokes the vod.DescribeVodTieringStorageData API asynchronously
func (client *Client) DescribeVodTieringStorageDataWithCallback(request *DescribeVodTieringStorageDataRequest, callback func(response *DescribeVodTieringStorageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodTieringStorageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodTieringStorageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodTieringStorageDataRequest is the request struct for api DescribeVodTieringStorageData
type DescribeVodTieringStorageDataRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	SplitBy      string           `position:"Query" name:"SplitBy"`
	EndTime      string           `position:"Query" name:"EndTime"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	StorageClass string           `position:"Query" name:"StorageClass"`
	AppId        string           `position:"Query" name:"AppId"`
	Region       string           `position:"Query" name:"Region"`
}

// DescribeVodTieringStorageDataResponse is the response struct for api DescribeVodTieringStorageData
type DescribeVodTieringStorageDataResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	StorageData []DataModule `json:"StorageData" xml:"StorageData"`
}

// CreateDescribeVodTieringStorageDataRequest creates a request to invoke DescribeVodTieringStorageData API
func CreateDescribeVodTieringStorageDataRequest() (request *DescribeVodTieringStorageDataRequest) {
	request = &DescribeVodTieringStorageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodTieringStorageData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodTieringStorageDataResponse creates a response to parse from DescribeVodTieringStorageData response
func CreateDescribeVodTieringStorageDataResponse() (response *DescribeVodTieringStorageDataResponse) {
	response = &DescribeVodTieringStorageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
